SET NAMES utf8mb4;
SET foreign_key_checks=0;


CREATE TABLE `active_state` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `country_id` int(11) NOT NULL,
  `state_id` int(11) NOT NULL,
  `state_code` varchar(50) NOT NULL,
  `state_sector_code` enum('local','domestic','international') NOT NULL,
  `status` tinyint(1) NOT NULL DEFAULT 1,
  `created_at` datetime DEFAULT current_timestamp(),
  `updated_at` datetime DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `created_by` bigint(20) DEFAULT NULL,
  `updated_by` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `unique_state` (`state_id`),
  KEY `country_id` (`country_id`),
  CONSTRAINT `active_state_ibfk_1` FOREIGN KEY (`country_id`) REFERENCES `country` (`id`),
  CONSTRAINT `active_state_ibfk_2` FOREIGN KEY (`state_id`) REFERENCES `state` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `active_state` VALUES ('1','1','23','001','domestic','1','2025-07-28 17:10:18','2025-07-28 17:10:18','','');
INSERT INTO `active_state` VALUES ('2','1','11','92','local','1','2025-07-29 12:41:42','2025-07-29 12:41:42','','');


CREATE TABLE `booking` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `branch_id` int(11) DEFAULT NULL,
  `product_id` int(11) NOT NULL,
  `pickup_center_id` int(11) DEFAULT NULL,
  `booking_method_id` int(11) NOT NULL,
  `cn_number` bigint(20) NOT NULL,
  `booking_date` date NOT NULL,
  `party_id` int(11) DEFAULT NULL,
  `consignor_id` int(11) DEFAULT NULL,
  `consignee_id` int(11) DEFAULT NULL,
  `consignor_name` varchar(255) NOT NULL,
  `consignor_mobile_no` varchar(20) DEFAULT NULL,
  `consignor_landline_no` varchar(15) DEFAULT NULL COMMENT 'Consignor landline/telephone number',
  `consignor_email` varchar(255) DEFAULT NULL,
  `consignor_address_line1` varchar(255) NOT NULL,
  `consignor_address_line2` varchar(255) DEFAULT NULL,
  `consignor_gst_no` varchar(30) DEFAULT NULL,
  `consignor_state_id` int(11) DEFAULT NULL,
  `consignor_pincode` varchar(10) NOT NULL,
  `consignee_name` varchar(255) NOT NULL,
  `consignee_mobile_no` varchar(20) NOT NULL,
  `consignee_landline_no` varchar(15) DEFAULT NULL COMMENT 'Consignee landline/telephone number',
  `consignee_address_line1` varchar(255) NOT NULL,
  `consignee_address_line2` varchar(255) DEFAULT NULL,
  `consignee_gst_no` varchar(30) DEFAULT NULL,
  `consignee_state_id` int(11) DEFAULT NULL,
  `consignee_pincode` varchar(10) DEFAULT NULL,
  `content` varchar(255) DEFAULT NULL,
  `delared_value` decimal(12,2) DEFAULT 0.00,
  `discount` decimal(10,2) NOT NULL DEFAULT 0.00 COMMENT 'Discount amount applied to booking',
  `other_charges` decimal(10,2) NOT NULL DEFAULT 0.00 COMMENT 'Additional charges applied to booking',
  `is_volumetric` tinyint(1) DEFAULT 0,
  `consignment_type` enum('Document','Parcel') NOT NULL,
  `mode_type` enum('Surface','Air','Local') NOT NULL,
  `no_of_pieces` int(11) DEFAULT 1,
  `actual_weight_kg` decimal(10,2) DEFAULT NULL,
  `volumetric_weight_kg` decimal(10,2) DEFAULT NULL,
  `length_cm` decimal(10,2) DEFAULT NULL,
  `width_cm` decimal(10,2) DEFAULT NULL,
  `height_cm` decimal(10,2) DEFAULT NULL,
  `weight_kg` decimal(10,2) DEFAULT NULL,
  `total_amount` decimal(12,2) DEFAULT 0.00,
  `status` tinyint(1) NOT NULL DEFAULT 1,
  `tracking_status_id` int(11) DEFAULT 1,
  `created_at` datetime DEFAULT current_timestamp(),
  `updated_at` datetime DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `created_by` bigint(20) DEFAULT NULL,
  `updated_by` bigint(20) DEFAULT NULL,
  `consignee_email` varchar(50) DEFAULT NULL,
  `destination` varchar(30) DEFAULT NULL,
  `specific_content` varchar(255) DEFAULT NULL,
  `gst_amount` decimal(10,2) DEFAULT 0.00 COMMENT 'Total GST amount applied to the booking',
  `gst_type` enum('CGST_SGST','IGST') DEFAULT 'CGST_SGST' COMMENT 'Type of GST applied (CGST+SGST for within state, IGST for inter-state)',
  `gst_cgst` decimal(10,2) DEFAULT 0.00 COMMENT 'CGST amount (9% for within state)',
  `gst_sgst` decimal(10,2) DEFAULT 0.00 COMMENT 'SGST amount (9% for within state)',
  `gst_igst` decimal(10,2) DEFAULT 0.00 COMMENT 'IGST amount (18% for inter-state)',
  `gst_rate` decimal(5,2) DEFAULT 0.00 COMMENT 'GST rate applied (18% or 9%+9%)',
  `gst_inclusive` tinyint(1) DEFAULT 1 COMMENT '1 if GST is inclusive in total_amount (booking method 1,2), 0 if exclusive (booking method 3,4)',
  `is_new_rate` int(11) NOT NULL DEFAULT 0,
  `is_return_pod` int(11) NOT NULL DEFAULT 0,
  `return_pod_date` datetime DEFAULT NULL,
  `actual_tat_date` datetime DEFAULT NULL,
  `pod_status` varchar(20) DEFAULT NULL,
  `pod_remarks` varchar(100) DEFAULT NULL,
  `remarks` text DEFAULT NULL,
  `id_new_rate_check` int(11) NOT NULL DEFAULT 0,
  `pod_created_by` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `cn_number` (`cn_number`),
  KEY `product_id` (`product_id`),
  KEY `booking_method_id` (`booking_method_id`),
  KEY `consignor_id` (`consignor_id`),
  KEY `consignee_id` (`consignee_id`),
  KEY `consignor_state_id` (`consignor_state_id`),
  KEY `consignee_state_id` (`consignee_state_id`),
  KEY `fk_booking_pickup_center` (`pickup_center_id`),
  KEY `fk_booking_party` (`party_id`),
  KEY `idx_tracking_status` (`tracking_status_id`),
  KEY `idx_cn_number_tracking` (`cn_number`),
  KEY `idx_booking_branch_date` (`branch_id`,`booking_date`),
  KEY `idx_booking_product` (`product_id`),
  KEY `idx_booking_pickup_center` (`pickup_center_id`),
  KEY `idx_booking_status` (`status`),
  KEY `idx_booking_mode_type` (`mode_type`),
  KEY `idx_booking_date_only` (`booking_date`),
  KEY `idx_booking_filters` (`branch_id`,`product_id`,`pickup_center_id`,`status`,`mode_type`),
  KEY `idx_booking` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=133115 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `booking` VALUES ('10','7','1','','2','3394977','2025-11-03','','4586','26','SRI MATHA TRANSPORT','919944796735','','','APMC BUILDING','BAIKAMPADY','','11','575019','SASIKUMAR','919942225565','','VINAYAGAR STREET','NADARMEDU','','23','638002','','0.00','0.00','0.00','0','Document','Surface','1','0.01','','','','','0.01','70.00','1','1','2025-11-03 09:39:26','2025-12-13 14:15:37','2147483647','2147483647','','114','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('12','7','1','','2','3394978','2025-11-03','','4588','28','SRI MATHA TRANSPORT','919846740408','','','APMC BUILDING','BAIKAMPADY','','11','575011','NATIONAL TRANSPORT','919843139310','','PAPAMPATTI POST','','','23','641016','Document','0.00','0.00','0.00','0','Document','Surface','1','0.05','','','','','0.05','70.00','1','1','2025-11-03 09:50:17','2025-12-20 13:13:02','2147483647','2147483647','','535','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('14','7','1','','2','3394979','2025-11-03','','4589','29','SHEKAR K POOJARY','919167231647','','','KRISHNA NILAYA','KUDUMBUR','','11','575011','MANOJ J','917829961994','','COFFEE GLOBAL LTD','BANNERHATTA ROAD','','11','','Document','0.00','0.00','0.00','0','Document','Surface','1','0.01','','','','','0.01','60.00','1','1','2025-11-03 09:55:16','2025-11-03 09:55:16','2147483647','2147483647','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('16','13','1','','2','3403967','2025-11-03','','4590','30','SUNDHA MOBILE','917019227682','','','CENTRAL MARKET','MKT ROAD','','11','575001','MAHADEV TELECOM','918286146963','','SHOP NO710 C J PALAZA APSARA CINEMA','LAMINTON ROAD','','14','400007','Parcel','3000.00','0.00','0.00','0','Parcel','Surface','1','6.32','','','','','6.32','1155.00','1','1','2025-11-03 10:09:42','2025-11-03 10:09:42','2147483647','2147483647','','57','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('17','12','1','','2','3382922','2025-11-03','','4591','31','SUREKHA K','919880631437','','','MANGALA CARGO CARRIERS','MONKY STAND MANGALORE','','11','','PREM KUMAR','919265707208','','COUNTRYWIDE LOGISTICS INDIA P LTD','ADAKAMARANAHALLI DASANAPURA HOBLI MAKALI','','11','562123','Document','10.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-03 10:09:47','2025-11-03 10:09:47','2147483647','2147483647','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('18','10','1','','2','3406695','2025-11-03','','4592','32','GEETHA','919448231183','','','FLAT NO 001','PALLKHI ENCLAVE PRASHANTH NAGAR','','11','575006','NAGARATHNA','918105426627','','18/G3, 3RD CROSS','NEHRU COLONY','','11','583101','Document','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-03 10:11:41','2025-11-03 10:11:41','2147483647','2147483647','','427','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('19','20','1','','2','3417981','2025-11-03','','4593','33','JYOTHI GEETHA DSOUZA','919008921552','','','JEPPU BAJAL','MANGALORE','','11','575002','K HARISH ADHIKARI','917019553528','','LOBO COMPLEX AJEKAR','MARNE VILLAGE','','11','574101','Document','10.00','0.00','0.00','0','Document','Surface','1','0.30','','','','','0.30','85.00','1','1','2025-11-03 10:12:37','2025-11-26 16:01:53','2147483647','1','','1639','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('20','18','1','','2','3385013','2025-11-03','','4594','34','BHASHEER','918095457782','','','KULUR KAVOOR','MANGALORE','','11','575013','SIRE LOGISTICES','919494581505','','SRINIVASALAH COMPLEX','THIRUMALASHETH BANGALORE','','11','560067','','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-03 10:14:34','2025-11-03 10:14:34','2147483647','2147483647','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('21','7','1','','2','3394980','2025-11-03','','4595','35','SHANMUGAN','918281193745','','','BAIKAMPADY','MANGALORE','','11','575011','REJI PD','919744580316','','NAIK FROZEN FOODS  PLTD','MIDC AREA TALOJA','','14','410208','','0.01','0.00','0.00','0','Document','Surface','1','0.37','','','','','0.37','170.00','1','1','2025-11-03 10:14:40','2025-11-03 10:14:40','2147483647','2147483647','','979','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('22','20','1','','2','3417982','2025-11-03','','4596','36','KAUSHIK RAO C','919538807555','','','ARADHANA','BEJAI KAPIKAD','','11','575004','V BABU NAMBOODRI','919632754273','','9TH BLOCK ITI BACKSIDE','OPP CHIPPI HOMESTAY','','11','571201','Document','10.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-03 10:17:26','2025-11-03 10:17:26','2147483647','2147483647','','332','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('23','23','1','','2','3408476','2025-11-03','','4597','37','KAVITHA DIGITAL SEVA KENDRA','918310356016','','','PANDESHWARA','MANGALORE','','11','560010','SHREE GURU RAGHVENDRA','919900418545','','JUGGANAHALLI NEAR','RAJAJI NAGAR','','11','560010','Document','100.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-03 10:18:07','2025-11-03 10:18:07','2147483647','2147483647','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('24','13','1','','2','3403968','2025-11-03','','4590','38','SUNDHA MOBILE','917019227682','','','CENTRAL MARKET','MKT ROAD','','11','575001','CELL','919980964219','','CELL SHOP','S P ROAD','','11','','Parcel','0.00','0.00','0.00','0','Parcel','Surface','1','1.79','','','','','1.79','339.00','1','1','2025-11-03 10:27:43','2025-11-03 10:27:43','2147483647','2147483647','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('25','18','1','','2','3385014','2025-11-03','','4598','39','DEEPAK ROAD CARRRIER','919448477171','','','KULUR KAVOOR ROAD','MANGALORE','','11','','V. PONNUSWAMY','919750466273','','T KALPANA','VALLIPURAM','','23','637001','','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','70.00','1','1','2025-11-03 10:29:51','2025-11-03 10:29:51','2147483647','2147483647','','592','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('26','13','1','','2','3403969','2025-11-03','','4599','40','VAISHNAVI APPARELA','919964676467','','','NEW FIELD STREET','DONGARKERY MLR','','11','575001','S SATHIYA NARAYANAN','919008854009','','NAIDU HALL APPARELS','GANDHI NAGAR OOMERABAD','','23','635808','Document','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','70.00','1','1','2025-11-03 10:35:58','2025-11-03 10:35:58','2147483647','2147483647','','2308','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('27','18','1','','2','3385015','2025-11-03','','4598','41','DEEPAK ROAD CARRRIER','919448477171','','','KULUR KAVOOR ROAD','MANGALORE','','11','','NANDA KUMAR','919962063299','','182 A PNS  COMPLEX','MAIN  ROAD  NAMMAKAL','','23','637001','Document','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','70.00','1','1','2025-11-03 10:38:34','2025-11-03 10:38:34','2147483647','2147483647','','280','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('28','21','1','','2','3393079','2025-11-03','','4600','42','AKSHAY ACHARYA','917259908578','','','7TH B CROSS KODIKAL','MANGALORE','','11','575006','COMPAC INDUSTRIES INDIA LTD','911141411229','','K 73, UDYOG NAGAR','ROHTAK ROAD','','32','110041','Document','50.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','100.00','1','1','2025-11-03 10:41:23','2025-11-03 10:41:23','2147483647','2147483647','','1995','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('29','20','1','','2','3417983','2025-11-03','','4601','43','RANJITH K','919945739600','','','MANGALORE','','','11','575001','MR UMESH','919535133155','','#23 1ST MAIN 1ST CROSS','DODDABASTHI MAIN ROAD','BEHIND SHIVAJI HOTEL','11','560056','Document','10.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-03 10:42:35','2025-11-03 10:42:35','2147483647','2147483647','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('30','18','1','','2','3385016','2025-11-03','','4598','44','DEEPAK ROAD CARRRIER','919448477171','','','KULUR KAVOOR ROAD','MANGALORE','','11','','RCS LORRY SERVICE','917810078000','','TVS & SONS LTD','VALLIPURAM','','23','637001','Document','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','70.00','1','1','2025-11-03 10:44:00','2025-11-03 10:44:00','2147483647','2147483647','','592','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('31','20','1','','2','3417984','2025-11-03','','4601','45','RANJITH K','919945739600','','','MANGALORE','','','11','575001','SONI POLYMER PVT LTD','917122232002','','#42 UTKAKSHA VISHAKHA','BAJAJNAGAR','','14','440010','','10.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','100.00','1','1','2025-11-03 10:44:36','2025-11-03 11:23:21','2147483647','1','','335','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('32','23','1','','2','3408477','2025-11-03','','4603','46','BBQ','918975675107','','','PANDESHWARA','MANGALORE','','43','575001','M R INTERNATIONAL WORK','918591458510','','INFINITY SQUARE','WALIV ROAD FAST VASAI EAST','','14','401208','','100.00','0.00','0.00','0','Document','Surface','1','0.25','','','','','0.25','130.00','1','1','2025-11-03 10:45:45','2025-11-03 10:45:45','2147483647','2147483647','','57','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('33','16','1','','2','3357226','2025-11-03','','4604','47','RAJ','919901958050','','','KAIKAMBA','MANGALORE','','11','574151','DENTEXPERTS DENTAL LAB','919880972722','','STATION ROAD','KARWAR','','11','581301','Parcel','500.00','0.00','0.00','0','Document','Surface','1','0.28','','','','','0.28','105.00','1','1','2025-11-03 10:50:16','2025-11-03 10:50:16','2147483647','2147483647','','296','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('34','13','1','','2','3403970','2025-11-03','','4605','48','MA WOOD PRODUCTS','919746368211','','','BATTIAPADAVU KALIYOOR VILLAGE','MANJESHWARA','','11','575001','POPULAR','919448064537','','POPULAR4 TRADING CO','S J P ROAD','','11','560002','Parcel','0.00','0.00','0.00','0','Parcel','Surface','1','1.00','','','','','1.00','150.00','1','1','2025-11-03 10:50:53','2025-11-03 10:50:53','2147483647','2147483647','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('35','26','1','','2','3400836','2025-11-03','','4606','49','MANISH B','919746384480','','','TKT','MANGALORE','','11','575001','KRISHNAPPA','919620555992','','OM ENTERPRSES','5TH MN RD RAJAJINAGAR','','11','560010','Document','0.00','0.00','0.00','0','Document','Surface','1','0.05','','','','','0.05','60.00','1','1','2025-11-03 10:53:03','2025-11-03 10:53:03','2147483647','2147483647','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('36','12','1','','2','3382923','2025-11-03','','4591','50','SUREKHA K','919880631437','','','MANGALA CARGO CARRIERS','MONKY STAND MANGALORE','','11','','NITCO LOGISTICS P LTD','919972418395','','NO204 MADANAYAKANAHALLI TUMKUM RD','NR PADMAVATHI KALYAN MANTAP','','11','560001','','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-03 10:53:11','2025-11-03 10:53:11','2147483647','2147483647','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('37','20','1','','2','3417985','2025-11-03','','4607','51','SHAHSIDHARA','919945047660','','','KULSHEKAR','MANGALORE','','11','','PRADEEP','918867039585','','1ST CROSS BUDHANAGAR','MARUTHI SHARMILA OPP','','11','577201','Document','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-03 10:54:43','2025-11-03 10:54:43','2147483647','2147483647','','1829','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('39','13','1','','2','3403971','2025-11-03','','4609','53','LAKARAM CHOUDRY','918097875524','','','MARKDET RD MANGALORE','MANGALORE','','11','575001','RATHAN PATEL','918128729630','','SHOP NO 7 G FLORE PATEL PLAZA','KAROL BAGH','','32','110005','Document','0.00','0.00','0.00','0','Document','Surface','1','1.12','','','','','1.12','370.00','1','1','2025-11-03 11:00:06','2025-11-03 11:00:06','2147483647','2147483647','RATAN PATEL','1995','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('40','23','1','','2','3408478','2025-11-03','','4610','54','MEGA MARINE SPARES','919148924587','','','BUNDER','MANGALORE','','43','575001','S M MARIANE ADVANCE','919629366412','','APPTA MARKET COMPLEX','OZHUGISERY','','23','629001','Parcel','100.00','0.00','0.00','0','Document','Surface','1','1.70','','','','','1.70','304.00','1','1','2025-11-03 11:01:16','2025-11-03 11:01:16','2147483647','2147483647','','473','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('41','13','1','','2','3403972','2025-11-03','','4611','55','MUNISH','919980463700','','','GHS ROAD','MANGALORE','','43','575001','SREKANTH T','916281906541','','DEVAR VAMZAL','MEDCHAL ROAD','','13','500078','Document','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','70.00','1','1','2025-11-03 11:05:41','2025-11-03 11:05:41','2147483647','2147483647','EMRI GREEN HEALTH SER','1824','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('42','22','1','','2','3411023','2025-11-03','','4612','56','M V ENTERPRISES','918296470054','','','SHOP NO 4 AKSHAYA COMPLEX','MAIN RD KADABA','','11','574221','KWALITY TECH ZONE LLP','919739933180','','MANISWARAPPA LANE','S P ROAD CROSS BANGALORE','','11','560002','Document','5000.00','0.00','0.00','0','Document','Surface','1','3.00','','','','','3.00','523.00','1','1','2025-11-03 11:05:42','2025-11-03 11:05:42','2147483647','2147483647','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('43','20','1','','2','3417986','2025-11-03','','4613','57','SDM LAW CLG','918494900305','','','MANGALORE','','','11','','SDME SCTY','918494900305','','UJIRE','','','11','','Document','10.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','50.00','1','1','2025-11-03 11:05:58','2025-11-03 11:05:58','2147483647','2147483647','','3440','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('44','18','1','','2','3385017','2025-11-03','','4614','58','PRAJWAL SHETTY','919964427850','','','VISHVAS SAMRAT','VASANAGAR MANGALORE','','11','','SANTOSH SHETTY','919869611152','','DOSTI VIHAR COMPLEX','POKHRAN ROAD NO.1 THANE','','14','400606','Document','0.00','0.00','0.00','0','Document','Surface','1','0.32','','','','','0.32','170.00','1','1','2025-11-03 11:08:12','2025-11-03 11:08:12','2147483647','2147483647','','848','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('45','13','1','','2','3403973','2025-11-03','','4615','59','HEMAVATHI','919620172346','','','CAR ST MANGALORE','MANGALORE','','43','575001','VEENELA','919535760225','','EDIGAM CHOURASTHA','BHAYANAGAR','','1','504106','Document','0.00','0.00','0.00','0','Document','Surface','1','3.75','','','','','3.75','661.00','1','1','2025-11-03 11:10:21','2025-11-03 11:10:21','2147483647','2147483647','VEENELA','1435','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('46','13','1','','2','3403974','2025-11-03','','4616','60','DHANYA KUMARI','918277193643','','','KODIYAL BAIL','MANGALORE','','43','575001','TIMMAPPA RAI','919945922586','','PUTTUR','','','43','','Document','0.00','0.00','0.00','0','Document','Surface','1','0.07','','','','','0.07','65.00','1','1','2025-11-03 11:17:20','2025-11-03 11:17:20','2147483647','2147483647','BANNUR VIRPAJE','1904','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('48','17','1','','2','3404664','2025-11-03','','4617','62','SHOBHA ANAND','917846860042','','','MOURSHIKA PALACE','KADRI KAMBLA MANGALORE','','11','575003','MR SUNDARA  N DEVADIGA','918105650829','','NAINADU ROAD','GOLIYANGADI','','11','','Document','0.00','0.00','0.00','0','Document','Surface','1','0.43','','','','','0.43','85.00','1','1','2025-11-03 11:18:18','2025-11-03 11:18:18','2147483647','2147483647','BOLJAL BETTU','1102','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('49','21','1','','2','3393080','2025-11-03','','4618','63','VIDYASAGAR HEGDE','918884200537','','','HAFELE INDIA PVT TLD','KODICAL','','11','575006','SAMEER','918105200870','','TEAMWORK DEVELOPERS','NGO BUILDING, NEAR VIDHANA SOUDHA','','11','574201','Document','500.00','0.00','0.00','0','Document','Surface','1','0.73','','','','','0.73','95.00','1','1','2025-11-03 11:19:58','2025-11-03 11:19:58','2147483647','2147483647','','1904','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('50','20','1','','2','3417987','2025-11-03','','4619','57','JAYARAM','919448104462','','','KODIALBAIL','','','11','','SDME SCTY','918494900305','','UJIRE','','','11','','Document','10.00','0.00','0.00','0','Document','Surface','1','0.40','','','','','0.40','85.00','1','1','2025-11-03 11:20:12','2025-11-03 13:24:13','2147483647','2147483647','','3211','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('51','7','1','','2','3394981','2025-11-03','','4620','64','BHARATHI SURESH','919845416376','','','KULAI','HOSABETTU','','11','575011','SHASHI ACHAR','919886039637','','GUBBALALA GATE','KANAKAPURA ROAD','','11','560061','','0.01','0.00','0.00','0','Document','Surface','1','0.01','','','','','0.01','60.00','1','1','2025-11-03 11:21:24','2025-11-03 11:21:24','2147483647','2147483647','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('52','20','1','','2','3417988','2025-11-03','','4621','65','K S LINGEGOWDA','919743855679','','','ASHOKNAGAR','','','11','','PADMA GOPAL','919535589467','','SHESHADRIPURAM','','','1','','Document','10.00','0.00','0.00','0','Document','Surface','1','0.80','','','','','0.80','155.00','1','1','2025-11-03 11:24:50','2025-11-03 11:24:50','2147483647','2147483647','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('53','22','1','','2','3411024','2025-11-03','','4622','66','ROBERT D SOUZA','919731934013','','','KUDUPU','KULSHEKAR  MANGALURU','','11','575028','QUINITA   D SOUZA','918197726690','','SUJAY  PAIS   SIDDAGANGA EXTN','GALANCE 4TH CROSS','','11','572102','Document','100.00','0.00','0.00','0','Document','Surface','1','0.25','','','','','0.25','85.00','1','1','2025-11-03 11:25:49','2025-11-03 11:25:49','2147483647','2147483647','','1633','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('54','23','1','','2','3408479','2025-11-03','','4623','67','DR SYED ZAHID','917204846993','','','pandeshwara','mangalore','','11','575001','karnataka state pollu','917204846993','','baikampady','indu area','','11','575001','','100.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','100.00','1','1','2025-11-03 11:25:50','2025-11-03 11:25:50','2147483647','2147483647','parisara bhavana','3210','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('55','8','1','','2','3351468','2025-11-03','','4608','52','HUSSAIN SIRAJ','919844609688','','','DELUXE COTTEGE','AIRPORT RD','','11','574142','SUPERITENDENT OF ENGINEER PRED','919964978711','','HUNSUR RD','MAKT SO','','11','570006','Document','10.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-03 11:30:02','2025-11-03 11:30:02','2147483647','2147483647','','669','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('56','20','1','','2','3417989','2025-11-03','','4624','68','MRS S RAMOLA','918792433440','','','KARANGALPADY','','','11','','LEONA','919741970138','','RAAGA APPT E BLOCK','KANNURU','','11','560077','Document','10.00','0.00','0.00','0','Document','Surface','1','2.90','','','','','2.90','523.00','1','1','2025-11-03 11:33:56','2025-11-03 11:33:56','2147483647','2147483647','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('57','13','1','','2','3403975','2025-11-03','','4625','69','PEEYUSH MARKETING','919741612713','','','MARKET ROAD','MANGALORE','','43','575001','NAKODA TOYS','919611998282','','241 NAGDEVI STREET','1ST FLOOR,ROMM NO 1 TO 5','','14','400003','Document','0.00','0.00','0.00','0','Document','Surface','1','0.19','','','','','0.19','130.00','1','1','2025-11-03 11:34:01','2025-11-03 11:34:01','2147483647','2147483647','','57','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('59','17','1','','2','3404665','2025-11-03','','4626','70','PUSHPARAJ HEGDE','919821123972','','','FRONTAGE ALU','NEAR COLACO HOSPITAL','','11','575002','ARCH SOURABH','919820325127','','SKYLINE ARCHTECTS','KAMAL CITY SENAPATI BAPAT MARG','','14','400013','Parcel','1500.00','0.00','0.00','0','Document','Surface','1','3.80','','','','','3.80','1250.00','1','1','2025-11-03 11:36:35','2025-11-03 11:36:35','2147483647','2147483647','','57','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('60','20','1','','2','3417990','2025-11-03','','4627','57','ELECTRO SERVICE CENTRE','919845081979','','','KODIALBAIL','','','11','','SBI','918494900305','','PAVOOR','','','11','','Document','10.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','50.00','1','1','2025-11-03 11:38:22','2025-11-03 11:38:22','2147483647','2147483647','','56','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('62','23','1','','2','3408480','2025-11-03','','4629','71','lokesh','919036583850','','','pandeshwara','mangalore','','11','575001','PCC LOGISTICS LTD','918971290073','','ASHIRWAD BLDG','SOMESHWAPURA ULSOOR','','11','560008','Document','100.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-03 11:43:07','2025-11-03 11:43:07','2147483647','2147483647','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('63','17','1','','2','3404666','2025-11-03','','4630','72','yathiraj','919844475971','','','presidency zone','mangalore','','11','','BALAKRISHNa shetty','919008005709','','SKANRAY TECH','HEBBAL','','11','570018','Document','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-03 11:43:16','2025-11-03 11:43:16','2147483647','2147483647','','669','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('64','7','1','','2','3394982','2025-11-03','','4631','73','KCS TPT','919442015537','','','MANI','MANGALORE','','11','575011','THIRUMALA TRANSPORT','919047361935','','THE RAMCO CEMENT','SINGIPURAM POST,VALAPPADY TK','','23','636115','Document','0.00','0.00','0.00','0','Document','Surface','1','0.01','','','','','0.01','70.00','1','1','2025-11-03 11:45:20','2025-11-03 11:45:20','2147483647','2147483647','','1815','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('65','7','1','','2','3394983','2025-11-03','','4632','74','RGM INT','917760749824','','','BAIKAMPADY IND AREA','MANGALORE','','11','575011','RGM INT','919448284731','','DVG ROAD NEAR GUNDEGOWDA KOPPLAL','VIDYANAGAR','','11','573201','Document','0.00','0.00','0.00','0','Document','Surface','1','0.20','','','','','0.20','90.00','1','1','2025-11-03 11:50:14','2025-11-03 11:50:14','2147483647','2147483647','','448','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('66','24','1','','2','3399441','2025-11-03','','4633','75','ROYAL CARS','919448378583','','','UJJODI PUMPWELL','MANGALORE','','11','575002','BALAJI AUTP CARS','916364164719','','OPP FAMCO TENHINGUNDI','BHATKAL','','11','581320','Document','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-03 11:52:19','2025-11-03 11:52:19','2147483647','2147483647','','1689','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('67','18','1','','2','3385018','2025-11-03','','4634','76','ABHISHEK THIRTHA','919632123820','','','KODICAL','MANGALORE','','11','','CHANDAN KUMAR','917483544479','','NEAR BRAHMADEVA BOOKS AND','GENERAL STORE CHAMARAJNAGAR','','11','','Document','0.00','0.00','0.00','0','Document','Surface','1','0.52','','','','','0.52','125.00','1','1','2025-11-03 11:57:48','2025-11-03 11:57:48','2147483647','2147483647','','184','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('69','24','1','','2','3399442','2025-11-03','','4633','77','ROYAL CARS','919448378583','','','UJJODI PUMPWELL','MANGALORE','','11','575002','B.M PATIL','919845295594','','NR R.T.O OFFICE','BAILHONGAL','','11','591102','Document','10.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-03 11:58:51','2025-11-03 11:58:51','2147483647','2147483647','','1128','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('70','23','1','','2','3408481','2025-11-03','','4635','78','jyothi vas','917411710938','','','pandeshwara','mangalore','','11','575001','mahanthesh','919686928807','','keb road shivaji park','rayabag vtc raybag','','11','591317','Parcel','1000.00','0.00','0.00','0','Parcel','Surface','1','6.00','','','','','6.00','660.00','1','1','2025-11-03 11:58:56','2025-11-03 18:44:20','2147483647','17617218175043','','4','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('71','13','1','','2','3403976','2025-11-03','','4636','79','VEENA SUDHAKARA','919480763715','','','GURUKRIPA SOLUTION','BALMATTA MANGALORE','','43','57001','SHIVANI','919449690215','','NAGACHITTANYS SR PG FOR LADIES','KADUBEEASANAHALLI,PANATHUR','','11','560103','','0.00','0.00','0.00','0','Document','Surface','1','1.55','','','','','1.55','300.00','1','1','2025-11-03 12:00:21','2025-11-03 12:00:21','2147483647','2147483647','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('72','22','1','','2','3411025','2025-11-03','','4612','80','M V ENTERPRISES','918296470054','','','SHOP NO 4 AKSHAYA COMPLEX','MAIN RD KADABA','','11','574221','FLYBALL ENTERPRISES','917975205878','','IST FLOOR BALADI COMPLEX','S P ROAD','','11','560002','Document','0.00','0.00','0.00','0','Document','Surface','1','2.92','','','','','2.92','523.00','1','1','2025-11-03 12:00:37','2025-11-03 12:00:37','2147483647','2147483647','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('73','20','1','','2','3417991','2025-11-03','','4637','81','CHEMM FINANCE LTD','918242451629','','','M G ROAD MANGALORE','','','11','','CHEMM FINANCE LTD','918022221099','','BEHIND CHEMMANUR JEWELLERS','MISSION ROAD','','11','560027','Document','10.00','0.00','0.00','0','Document','Surface','1','0.12','','','','','0.12','85.00','1','1','2025-11-03 12:04:11','2025-11-03 12:04:11','2147483647','2147483647','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('74','20','1','','2','3417992','2025-11-03','','4639','82','RAKSHITH RAI','917406580700','','','KADRI','MANGALORE','','11','','MDINDIA HEALTH INS TPA PVT LTD','912025300000','','E SPACE A WING 3RD FLOOR','PUNE NAGAR ROAD','','14','411014','Document','10.00','0.00','0.00','0','Document','Surface','1','0.15','','','','','0.15','130.00','1','1','2025-11-03 12:06:45','2025-11-03 12:06:45','2147483647','2147483647','','13','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('75','18','1','','2','3385019','2025-11-03','','4640','83','NAGARAJ NAIK','919148092178','','','RATNA HOTEL','KULUR MANGALORE','','11','','KESHAVAJATTA NAIK','918197406725','','P SHARALI','BHATKAL','','27','581354','Document','0.00','0.00','0.00','0','Document','Surface','1','0.87','','','','','0.87','155.00','1','1','2025-11-03 12:06:50','2025-11-03 12:06:50','2147483647','2147483647','','2043','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('76','23','1','','2','3408482','2025-11-03','','4642','84','anil devadiga','919449523381','','','pandeshwara','mangaloRE','','11','587312','CHETHAN DEVADIGA','919035186487','','NEAR VAIBHAV TALUK','BANHATTI','','11','587312','Document','0.00','0.00','0.00','0','Document','Surface','1','100.00','','','','','100.00','60.00','1','1','2025-11-03 12:09:15','2025-11-03 12:09:15','2147483647','2147483647','SHIVASAGAR HOTEL','3449','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('77','20','1','','2','3417993','2025-11-03','','4613','99','SATI ENT','918494900305','','','MANGALORE','','','11','','SATI ENT','918042161275','','SUNROISE CHAMBERS','ULSOOR ROAD','','11','560042','','10.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-03 12:10:18','2025-11-03 12:22:54','2147483647','2147483647','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('78','24','1','','2','3399443','2025-11-03','','4633','86','ROYAL CARS','919448378583','','','UJJODI PUMPWELL','MANGALORE','','11','575002','MANSOOR J.S','919632132688','','ARLAPADAVU PANAJE','PUTTUR','','43','574201','','0.01','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','50.00','1','1','2025-11-03 12:10:33','2025-11-03 12:10:33','2147483647','2147483647','','1904','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('79','23','1','','2','3408483','2025-11-03','','4644','87','GIRISH G','919008228484','','','PANDESHWARA','MANGALORE','','11','575001','V SURESH','919980205144','','BANSHANKARI 3RD STAGE','BLR','','11','560085','Document','100.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-03 12:12:32','2025-11-03 12:12:32','2147483647','2147483647','NO 2 7TH CROSS','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('80','26','1','','2','3400837','2025-11-03','','4645','88','KIRAN KUMAR','919535159255','','','MATHANUGRAHA HOUSE','KANEETHOTA','','11','575022','JOHN PA','919986794254','','KAYARTHADKA','NEAR ST MARYS CHURCH','','43','574216','Parcel','2000.00','0.00','0.00','0','Parcel','Surface','1','6.00','','','','','6.00','600.00','1','1','2025-11-03 12:12:43','2025-11-03 12:12:43','2147483647','2147483647','PATTERIL HOUSE','2580','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('81','13','1','','2','3403977','2025-11-03','','4646','89','MUKUNDAN','917022866404','','','CARSTREET','MANGALORE','','43','575001','NISARGA SPA','919043638838','','MADIWALA EXTENSION','OPP CARY MART MARUTI NAGAR','','11','560003','Document','0.00','0.00','0.00','0','Document','Surface','1','0.10','','','','','0.10','90.00','1','1','2025-11-03 12:14:09','2025-11-03 12:14:09','2147483647','2147483647','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('82','14','1','','2','3364659','2025-11-03','','4647','90','WOODSIDE HOTEL','918244252650','','','NEXT BHARATH MOTORS BLDG','BALMATA RD','','11','575001','AKHTAR NADAF','918244252650','','INDUS TOWERS LTD NO 12 TOWER D 7 TH FLOOR','SUBRAMNAYA ARACADE BANNERGHATTA RD','','11','560001','Document','10.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-03 12:14:50','2025-11-03 12:14:50','2147483647','2147483647','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('83','18','1','','2','3385020','2025-11-03','','4648','93','ROOPA.S','917483153243','','','IDFC FIRST BANK','BALLALBAGH CIRCLE','','11','575003','ABHIJEET','919620422492','','IDFC FIRST BANK','SARASWATHIPURAM MYSORE','','11','','Document','0.00','0.00','0.00','0','Document','Surface','1','0.81','','','','','0.81','155.00','1','1','2025-11-03 12:16:26','2025-11-03 12:16:26','2147483647','2147483647','','2043','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('84','24','1','','2','3399444','2025-11-03','','4649','94','ROHITH M','918722780352','','','BAJJODI MAROLI','MANGALORE','','11','575005','HBC PHARMACEUTICALS PVT LTD','919099977793','','GANDHI NAGAR','GUJARATH','','14','382421','Document','10.00','0.00','0.00','0','Document','Surface','1','0.05','','','','','0.05','100.00','1','1','2025-11-03 12:16:36','2025-11-03 12:16:36','2147483647','2147483647','','381','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('85','13','1','','2','3403978','2025-11-03','','4646','95','MUKUNDAN PODUWAL','917022866404','','','CARSTREET','MANGALORE','','43','575001','THASNEEM P','919847711744','','THIRUVANLI ROAD','EDAVANNA','','12','676541','Document','0.00','0.00','0.00','0','Document','Surface','1','0.10','','','','','0.10','90.00','1','1','2025-11-03 12:17:50','2025-11-03 12:17:50','2147483647','2147483647','','284','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('86','8','1','','2','3351469','2025-11-03','','4650','96','CAPTN MADHUSUDHAN','917025519477','','','MSEZ','BAJPE','','11','574142','KIRAN KUMAR K C','917760122267','','FIRSTMAN MGT SERVICE PVT LTD','NO 25 1ST BLOCK  MILLER TANK BUND RD','','11','560052','Document','10.00','0.00','0.00','0','Document','Surface','1','0.09','','','','','0.09','75.00','1','1','2025-11-03 12:19:34','2025-11-03 12:19:34','2147483647','2147483647','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('87','13','1','','2','3403979','2025-11-03','','4646','97','MUKUNDAN','917022866404','','','CARSTREET','MANGALORE','','43','575001','DINESH','916381494829','','ARUKPORENJOTHI NAGAR','KURINIIPADI','','12','607308','Document','0.00','0.00','0.00','0','Document','Surface','1','0.10','','','','','0.10','90.00','1','1','2025-11-03 12:21:08','2025-11-03 12:21:08','2147483647','2147483647','','276','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('88','6','1','','2','3381516','2025-11-03','','4651','98','B N R PAI &CO','919483918084','','','PADAMVATHI KRIPA','MATADAKANI RD','','43','575006','JANATHA AGRO KENDRA','919902385688','','GANDHI NAGAR','SULLIA','','11','574239','Document','0.00','0.00','0.00','0','Document','Surface','1','1.00','','','','','1.00','105.00','1','1','2025-11-03 12:21:19','2025-11-03 12:21:19','2147483647','2147483647','JANTHA COMPLEX','2577','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('89','20','1','','2','3417994','2025-11-03','','4613','57','SATI ENT','918494900305','','','MANGALORE','','','11','','TRIVENI CHEM TRADERS','918494900305','','HONNAKATTE','MANGALORE','','11','','Document','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','40.00','1','1','2025-11-03 12:25:12','2025-11-26 15:56:16','2147483647','2147483647','','3453','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('90','26','1','','2','3400838','2025-11-03','','4652','100','PINKY RANI','919743700540','','','KANEERTHOTA','KOLYA','','43','575022','SANTHOSH KUMAR','919606694634','','CHENNAA GOWDA','BANTARA GRAMA','','11','574230','Document','0.00','0.00','0.00','0','Document','Surface','1','0.10','','','','','0.10','65.00','1','1','2025-11-03 12:25:34','2025-11-03 12:25:34','2147483647','2147483647','','3411','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('91','13','1','','2','3403980','2025-11-03','','4653','101','SHRVAN KUMAR GEHLAT','919448952910','','','CARSTREET','MANGALORE','','43','575001','KANAK LAXMI JEWELLERS','919321216969','','MUMBADEVI COMPOUND','KALBADEVI ROAD','','14','400002','','0.01','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','100.00','1','1','2025-11-03 12:26:08','2025-11-03 12:26:08','2147483647','2147483647','','57','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('92','13','1','','2','3403981','2025-11-03','','4654','102','KRISHNA PODUWAL','917676974702','','','K S RAO ROAD','MANGALORE','','11','575001','B N SATHYA PRAKASH','918970557466','','NR GUTHAL SOCIETY','ARAKESHWARA','','11','571403','','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-03 12:29:06','2025-11-03 12:29:06','2147483647','2147483647','','403','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('93','22','1','','2','3411026','2025-11-03','','4655','103','SUHAIL','919731777707','','','FERNIL NANTHOOR','MANGALORE','','11','575001','SABEEL BIKE SCAN CENTRE','919513693639','','SHOP NO 6 BESIDE HOSUR','CANADA HOTEL','','11','580021','Document','500.00','0.00','0.00','0','Document','Surface','1','0.25','','','','','0.25','85.00','1','1','2025-11-03 12:29:15','2025-11-03 12:29:15','2147483647','2147483647','','557','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('94','17','1','','2','3404667','2025-11-03','','4656','104','RIMAZ','917892598157','','','BALMATTA','MANGALORE','','11','575001','ABDUL NABEEL','919605330103','','KARUVALAM POST','PADANAKAD','','12','671314','Others','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','70.00','1','1','2025-11-03 12:29:19','2025-11-03 12:29:19','2147483647','2147483647','','1062','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('95','13','1','','2','3403982','2025-11-03','','4657','105','VIJAYA PEN MART','919448056591','','','HAMPANKATTA','MANGALORE','','43','575001','JAGADEESH HUDERI','919448445703','','NR AV G AYURVEDA MEDICAL COLLEGE','AMBATE ADKA','','43','574201','','0.00','0.00','0.00','0','Document','Surface','1','0.29','','','','','0.29','60.00','1','1','2025-11-03 12:32:14','2025-11-03 12:32:14','2147483647','2147483647','','2577','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('96','23','1','','2','3408484','2025-11-03','','4658','106','SHARAVAN KUMAR','919036436376','','','HOIGEBAZAR','MANGALORE','','11','575001','SHRI VAISHN A NETS P LTD','919535656904','','AVI NAGAR','INDU AREA','','26','201002','Parcel','0.00','0.00','0.00','0','Parcel','Surface','1','12.50','','','','','12.50','2145.00','1','1','2025-11-03 12:33:27','2025-11-03 17:28:21','2147483647','17617218175043','SRI VAISHO NUTS FACTORY PVT LTD','547','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('97','18','1','','2','3385021','2025-11-03','','4659','107','NAGARAJ','919448911310','','','GANDHI NAGAR KULUR','KAVOOR MANGALORE','','11','','A.G ROADLINES AGR','917021415757','','APMC MARKET','VASHI NAVI MUMBAI','','14','','Document','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','100.00','1','1','2025-11-03 12:33:31','2025-11-03 12:33:31','2147483647','2147483647','','57','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('98','10','1','','2','3406696','2025-11-03','','4660','108','SATHISH ALVA','918422813662','','','BEJAI','MANGALORE','','11','575004','VISHAL','919448034658','','GANIGARPET','BANGALORE','','11','560002','Document','100.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-03 12:34:01','2025-11-03 12:34:01','2147483647','2147483647','KAMAL AGENCY','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('99','20','1','','2','3417995','2025-11-03','','4661','109','MICRO ELECTRICALS','919019478505','','','MANGALORE','','','11','','INDIAN STRATEGIC PETROLEUM','917795893805','','BAJPE','','','11','','','10.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','50.00','1','1','2025-11-03 12:34:05','2025-11-03 12:34:05','2147483647','2147483647','MZEZ','3219','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('100','23','1','','2','3408485','2025-11-03','','13946','106','SHARAVAN KUMAR','918124455952','','','HOIGEBAZAR','MANGALORE','','11','575001','SHRI VAISHN A NETS P LTD','919535656904','','AVI NAGAR','INDU AREA','','26','201002','Parcel','0.00','665.00','0.00','0','Parcel','Surface','1','19.00','','','','','19.00','3135.00','1','1','2025-11-03 12:35:11','2025-12-12 18:39:33','2147483647','1','','547','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('101','7','1','','2','3394984','2025-11-03','','4662','110','ANJANEYA TPT','919901907759','','','TN 30 AW 3508','BAIKAMPADY','','11','575011','SRI RAGHAVENDRA TPT','919442447776','','OUTER RING ROAD','HOSUR','','23','635109','Document','0.00','0.00','0.00','0','Document','Surface','1','0.01','','','','','0.01','70.00','1','1','2025-11-03 12:36:55','2025-11-03 12:36:55','2147483647','2147483647','','452','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('102','22','1','','2','3411027','2025-11-03','','4663','111','H R B RAO','919632462199','','','SISCO','MANGALORE','','11','575005','SOUTH INDIA SURGICAL PVT LTD','914442195500','','CHENNAI','117 WALLJAH RD','','23','600002','Document','10.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','70.00','1','1','2025-11-03 12:36:56','2025-11-03 12:36:56','2147483647','2147483647','','1931','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('103','26','1','','2','3400839','2025-11-03','','4652','112','PINKY RANI','919743700540','','','KANEERTHOTA','KOLYA','','43','575022','MONICA','919108543139','','SHREE DEVI INST','KENJAR','','11','574142','Document','0.00','0.00','0.00','0','Document','Surface','1','0.10','','','','','0.10','65.00','1','1','2025-11-03 12:37:19','2025-11-03 12:37:19','2147483647','2147483647','','3219','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('104','20','1','','2','3417996','2025-11-03','','4661','115','MICRO ELECTRICALS','919019478505','','','MANGALORE','','','11','','MASTER GRAPHICS','919791050947','','NATTUPILLAYAR KIOL','CHENNAI','','23','600075','','70.00','0.00','0.00','0','Document','Surface','1','0.40','','','','','0.40','120.00','1','1','2025-11-03 12:37:50','2025-11-03 12:37:50','2147483647','2147483647','','1931','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('105','7','1','','2','3394985','2025-11-03','','4662','116','ANJANEYA TPT','919901907759','','','TN 30 AW 3508','BAIKAMPADY','','11','575011','THIRUMALAI VASA LORRY BOOK OFFICE','919443455669','','RAYAKOTTA RING ROAD','HOSUR','','23','635109','Document','0.00','0.00','0.00','0','Document','Surface','1','0.05','','','','','0.05','70.00','1','1','2025-11-03 12:38:27','2025-12-20 13:13:02','2147483647','2147483647','','452','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('106','25','1','','2','3388816','2025-11-03','','4664','117','ARIF','917259891761','','','CHELAIR','SURATHKAL','','11','575014','RAIBOW SEEDS AND SPICES PVT','919925246451','','SALISTER RAJPATH RANGOLI ROAD','BODAKDEV','','7','380054','Document','100.00','0.00','0.00','0','Document','Surface','1','1.00','','','','','1.00','290.00','1','1','2025-11-03 12:39:47','2025-11-03 12:45:57','2147483647','2147483647','','3','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('107','7','1','','2','3394986','2025-11-03','','4662','118','ANJANEYA TPT','919901907759','','','TN 24 AL 7828','BAIKAMPADY','','11','575011','DEVRAJ BOOK OFFICE','919843095699','','PUTHIYAMPUTHUR ROAD','TUTICORIN','','23','628002','Document','0.00','0.00','0.00','0','Document','Surface','1','0.01','','','','','0.01','70.00','1','1','2025-11-03 12:39:50','2025-11-03 12:39:50','2147483647','2147483647','','1635','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('108','10','1','','2','3406697','2025-11-03','','4665','119','K R SHETTY','918095320014','','','KAVOOR','MANGLAORE','','11','575008','SREENIVAS','918022262391','','BANGALORE TURF CLUB LTD','RACE COURCE ROAD','','11','560001','Document','100.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-03 12:42:57','2025-11-03 12:42:57','2147483647','2147483647','TOTE MANAGER','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('109','20','1','','2','3417997','2025-11-03','','4666','120','DR RUDRESH HIREMATH','918970137697','','','NELLORE','ANDRA PRADESH','','1','','D S MATH CLASS 1','917349700207','','SHREE DHANESHWARI NILAYA','VIJAYAPURA','','11','586103','','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-03 12:43:09','2025-11-03 12:43:09','2147483647','2147483647','','2357','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('110','7','1','','2','3394987','2025-11-03','','4667','121','DEEPAK SALES','919742681166','','','PANAMBUR','MANGALORE','','11','575011','SELLWELL AGENCIES','919741521666','','KALAKUNJ ROAD','MANGALORE','','11','575003','Document','0.00','0.00','0.00','0','Document','Surface','1','0.01','','','','','0.01','35.00','1','1','2025-11-03 12:43:12','2025-11-26 15:56:16','2147483647','2147483647','','3453','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('111','26','1','','2','3400840','2025-11-03','','4668','122','SAI PRASAD','917022986559','','','KAPIKAD','THOKKOTU','','11','575020','PRAVEENA SHETTY','919819840620','','GREEN WORLD','AIROLI','','11','400708','Parcel','0.00','0.00','0.00','0','Parcel','Surface','1','0.48','','','','','0.48','170.00','1','1','2025-11-03 12:44:22','2025-11-03 12:44:22','2147483647','2147483647','','57','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('112','7','1','','2','3394988','2025-11-03','','4669','123','DEEPAK SALES','919187566112','','','PANAMBUR','MANGALORE','','11','575011','BALIGA ENT','919711644266','','MUBARAK TOWERS','BIBI ALABI ROAD','','11','575001','Document','0.00','0.00','0.00','0','Document','Surface','1','0.01','','','','','0.01','35.00','1','1','2025-11-03 12:46:11','2025-11-26 15:56:16','2147483647','2147483647','','3453','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('113','21','1','','2','3393081','2025-11-03','','4670','124','SHARAVU ENTERPRISES','918244269513','','','MANJESH ARCADE','ASHOKNAGAR','','11','575006','SUNIL','919844011665','','JAQUAR ORIENTATION CENTRE','PURVA PREMIERE RAHEJA','','11','560025','Document','50.00','0.00','0.00','0','Document','Surface','1','0.04','','','','','0.04','60.00','1','1','2025-11-03 12:47:44','2025-11-03 12:47:44','2147483647','2147483647','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('114','7','1','','2','3394989','2025-11-03','','4671','125','S H ROADLINES','917338396415','','','SURATHKAL','MANGALORE','','11','575011','ILC IRON AND STEELS P LTD','919686550801','','DAM ROAD','HOSPETE','','11','583203','Document','0.00','0.00','0.00','0','Document','Surface','1','0.19','','','','','0.19','85.00','1','1','2025-11-03 12:48:50','2025-11-03 12:48:50','2147483647','2147483647','','451','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('115','20','1','','2','3417998','2025-11-03','','4672','126','PRAKYATH RAI','917022790555','','','M G ROAD','MANGALORE','','11','','SHIVA KUMAR K S','918722345825','','OPP APMC MARKET','NANJANGUD','','11','','','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-03 12:49:40','2025-11-03 12:49:40','2147483647','2147483647','SHRIRAM, FINANCE LTD','594','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('116','21','1','','2','3393082','2025-11-03','','4673','127','SHARAVU ENTERPRISES','919964696906','','','MANJESH ARCADE ASHOKNAGAR, MANGALORE-575006','','29BHYPK7587C1ZG','11','575006','MARUDHURAI R','919844139636','','JAQUAR ORIENTATION CENTRE','PURVA PREMIERE RAHEJA PARAMOUNT','','11','560025','Document','50.00','0.00','0.00','0','Document','Surface','1','0.08','','','','','0.08','75.00','1','1','2025-11-03 12:51:21','2025-11-03 12:51:21','2147483647','2147483647','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('117','25','1','','2','3388817','2025-11-03','','4674','128','CHANDRASHEKAR SHETTY','918050330037','','','CITY ASSOCIATES','MAIN ROAD SURATHKAL','','11','575014','RANJITH NAIK','917259289709','','WESTTEK ENTERPRISES PVT','SHIVALLI IND AREA MANIPAL','','11','576104','Document','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','50.00','1','1','2025-11-03 12:52:54','2025-11-03 12:52:54','2147483647','2147483647','','662','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('118','20','1','','2','3417999','2025-11-03','','4675','129','VIJAYAVANI','918884432358','','','NERAR PVS','MANGALORE','','11','','MR ANIL RAJ','919847302621','','#23 GURUVAYARAPPAN NAGAR','SHORANUR','','11','679122','Document','0.00','0.00','0.00','0','Document','Surface','1','0.13','','','','','0.13','95.00','1','1','2025-11-03 12:54:25','2025-11-03 12:54:25','2147483647','2147483647','','672','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('119','17','1','','2','3404668','2025-11-03','','4676','130','SAMUEL PUSHPARAJ','919902210678','','','BAJAJ FINANCE LTD','BALMATTA MANGALORE','','11','575002','BABU PATROSE','919768270581','','BAJAJ FINANCE LTD','VIMAN NAGAR PUNE','','7','411014','Document','0.00','0.00','0.00','0','Document','Surface','1','0.25','','','','','0.25','130.00','1','1','2025-11-03 12:56:53','2025-11-03 12:56:53','2147483647','2147483647','','13','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('120','25','1','','2','3388818','2025-11-03','','4674','131','CHANDRASHEKAR SHETTY','918050330037','','','CITY ASSOCIATES','MAIN ROAD SURATHKAL','','11','575014','AASHA PRAVEEN','919148970881','','THE MANIPAL GROUP','PRESS CORNER MANIPAL','','11','576104','Document','100.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','50.00','1','1','2025-11-03 12:57:22','2025-11-03 12:57:22','2147483647','2147483647','','662','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('121','25','1','','2','3388819','2025-11-03','','4674','132','CHANDRASHEKAR SHETTY','918050330037','','','CITY ASSOCIATES','MAIN ROAD SURATHKAL','','11','575014','PRAVEEN NAYAK','918310156060','','THE MANIPAL GROUP','PRESS CORNER MANIPAL','','11','576104','Document','100.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','50.00','1','1','2025-11-03 12:59:17','2025-11-03 12:59:17','2147483647','2147483647','','662','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('122','21','1','','2','3393083','2025-11-03','','4677','133','DANIEL PANDIDURAI','919840348160','','','JENITA ILLAM, VIVEKANAND NAGAR 12TH CROSS','KODICAL','','11','575006','CARE HEALTH INSURANCE LTD','917338846897','','FF A, ARMENIAN CENTER','NO. 94 P;D NO. 71, GEORGE TOWN','','23','600001','','0.00','0.00','0.00','0','Document','Surface','1','0.64','','','','','0.64','140.00','1','1','2025-11-03 13:00:44','2025-11-03 13:00:44','2147483647','2147483647','','1931','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('123','20','1','','2','3418000','2025-11-03','','4678','134','DETAIL BASKET','919037373728','','','1ST FLOOR SHANTHARAM PERGA COMPLEX','OPP INDIAN HOSPITAL','','11','','RAJESH K V','918281234536','','KURUPPAM VETTIL','EAST CHENNARA MALAPPURAM','','12','676561','','0.00','0.00','0.00','0','Document','Surface','1','0.43','','','','','0.43','120.00','1','1','2025-11-03 13:02:23','2025-11-03 13:02:23','2147483647','2147483647','','1628','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('124','7','1','','2','3394990','2025-11-03','','4679','135','M R TRANSPORT','917204081998','','','BAIKAMPADY','MANGALORE','','11','575011','SALEEM TRANSPORT','919980352817','','APMC YARD','YESHWANTHPUR','','11','560022','Document','0.00','0.00','0.00','0','Document','Surface','1','0.01','','','','','0.01','60.00','1','1','2025-11-03 13:05:19','2025-11-03 13:05:19','2147483647','2147483647','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('125','7','1','','2','3394991','2025-11-03','','4679','110','M R TRANSPORT','917204081998','','','BAIKAMPADY','MANGALORE','','11','575011','SRI RAGHAVENDRA TPT','919442447776','','OUTER RING ROAD','HOSUR','','23','635109','Document','0.00','0.00','0.00','0','Document','Surface','1','0.01','','','','','0.01','70.00','1','1','2025-11-03 13:06:07','2025-11-03 13:06:07','2147483647','2147483647','','452','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('126','7','1','','2','3394992','2025-11-03','','4679','136','M R TRANSPORT','917204081998','','','BAIKAMPADY','MANGALORE','','11','575011','GADILINGESHWARA TPT','919480511118','','BANDIMOTE','BELLARY','','11','583101','Document','0.00','0.00','0.00','0','Document','Surface','1','0.01','','','','','0.01','60.00','1','1','2025-11-03 13:10:26','2025-11-03 13:10:26','2147483647','2147483647','','427','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('127','18','1','','2','3385022','2025-11-03','','4680','137','LAXMEESHA','919481416009','','','BOLLAJE HOUSE','KATIPALLA MANGALORE','','11','575030','DINESH','919980616801','','BHORUKA EXTRUSION PVT LTD','METAGALLI MYSORE','','11','570016','Document','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-03 13:12:34','2025-11-03 13:12:34','2147483647','2147483647','','669','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('128','7','1','','2','3394993','2025-11-03','','4679','138','M R TRANSPORT','917204081998','','','BAIKAMPADY','MANGALORE','','11','575011','NITHYANANDA ROADLINES','919141686286','','HUNSUR MAIN ROAD','HOOTAGALLI','','11','570018','Document','0.00','0.00','0.00','0','Document','Surface','1','0.01','','','','','0.01','60.00','1','1','2025-11-03 13:12:44','2025-11-03 13:12:44','2147483647','2147483647','','669','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('129','26','1','','2','3400841','2025-11-03','','4681','139','LAXSHMAN KIRIDIAN','918197526818','','','SOMESHWAR','MLR','','11','575022','FIVE FATE INFRA P LTD','919820422275','','NARIMAN POINT','JOURNAL RD','','14','400021','Document','0.00','0.00','0.00','0','Document','Surface','1','0.05','','','','','0.05','100.00','1','1','2025-11-03 13:13:17','2025-11-03 13:13:17','','','','57','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('130','20','1','','2','3418001','2025-11-03','','4682','140','P RANJAN RAO','919448368356','','','BUNTS HOSTEL','MANGALORE','','11','','K SACHINDRA KARANTH','918041510242','','#32 SANKEY ROAD CROSS','ABSHOT LAYOUT BANGALORE','','11','560052','','10.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-03 13:13:28','2025-11-03 13:13:28','2147483647','2147483647','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('131','10','1','','2','3406698','2025-11-03','','4683','141','YOGISH ACHAR','917829686555','','','MANDARA GARDEN','DEREBAIL','','11','575004','KARTHIK MEDICALS','919740763918','','SHIROOR MARKET','BYNDOOR','','11','576228','Document','0.00','0.00','0.00','0','Document','Surface','1','0.27','','','','','0.27','90.00','1','1','2025-11-03 13:14:24','2025-11-03 13:14:24','2147483647','2147483647','','3370','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('132','18','1','','2','3385023','2025-11-03','','4680','142','LAXMEESHA','919481416009','','','BOLLAJE HOUSE','KATIPALLA MANGALORE','','11','575030','SURESH','917760988213','','THOREDAHALLI KRISHNAPURA','RANEBENNUR','','11','581208','Document','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-03 13:15:39','2025-11-03 13:15:39','2147483647','2147483647','','1173','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('133','7','1','','2','3394994','2025-11-03','','4685','143','TIPESH','919008381237','','','KA17B4883','','','11','575011','SRI VENKATESHWARA TR','919845167189','','THOGARI BEED','K R MOHALLA','','11','570024','Document','0.00','0.00','0.00','0','Document','Surface','1','0.01','','','','','0.01','60.00','1','1','2025-11-03 13:16:33','2025-11-03 13:16:33','2147483647','2147483647','','669','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('134','6','1','','2','3381517','2025-11-03','','4686','144','AKASH SHETTY','918951638559','','','LALAITHA NARAYAN 2ND FLOOR','GUNDURAO LANE','','11','575003','RAJENDRA NAIR  K P','911142504862','','MODI TOWER 98','NEHARU PALCE','','32','110019','Document','1.01','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','100.00','1','1','2025-11-03 13:16:48','2025-11-03 13:16:48','2147483647','2147483647','WIN MEDICARE P LTD','1995','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('135','10','1','','2','3406699','2025-11-03','','4688','145','DR FAKRUDDIN KUNIL','918050065389','','','KUNIL HOUSE','KADRI','','11','575004','NAJEEB KUNIL','919322707087','','SPENCER COUART','FRAZER TOWN','','11','560005','Document','100.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-03 13:17:48','2025-11-03 13:17:48','2147483647','2147483647','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('136','23','1','','2','3408486','2025-11-03','','4689','146','STEEL CENTRE','918242427492','','','BUNDER','MANGALORE','','11','575001','MR M SUBRAMANI','919844385345','','OKALIPURAM','SRI RAMPUR POST','','11','560021','Document','100.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-03 13:17:55','2025-11-03 13:17:55','2147483647','2147483647','M S BUILDING','2043','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('137','21','1','','2','3393084','2025-11-03','','4690','147','RBS MARITIME SERVICES','919449282918','','','BETHEL HOUSE, ARYA MARG','DEREBAIL, MANGALORE','','11','575006','RBS MARITIME SERVICES','919495941004','','229, BHAVANA NAGAR','KADAPPAKADA','','12','691008','','5000.00','0.00','0.00','0','Document','Surface','1','6.90','','','','','6.90','875.00','1','1','2025-11-03 13:17:58','2025-11-03 13:17:58','2147483647','2147483647','','650','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('138','18','1','','2','3385024','2025-11-03','','4680','148','LAXMEESHA','919481416009','','','BOLLAJE HOUSE','KATIPALLA MANGALORE','','11','575030','SANJEEV CHOWDRY','917699001918','','ATNOOR AFZALPURA','KALABURGI','','11','585301','','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-03 13:19:36','2025-11-03 13:19:36','2147483647','2147483647','','1195','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('139','10','1','','2','3406700','2025-11-03','','4693','149','S B PHARMACEUTICALS','916360582951','','','MANGALORE','','','11','','SOWMYA K G','919483718714','','RAGHAVENDRA NAGARA','3RD CROSS','','11','577126','Document','200.00','0.00','0.00','0','Document','Surface','1','1.40','','','','','1.40','250.00','1','1','2025-11-03 13:21:01','2025-11-03 13:21:01','2147483647','2147483647','','859','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('140','7','1','','2','3394995','2025-11-03','','4694','150','R RAMESH','919789303424','','','HINCOL BITUMEN TERMINAL','PANAMBUR','','11','575011','GURUMOORTHI','919500014160','','PONNIYAMMANMEDU','CHENNAI','','23','600110','Document','0.00','0.00','0.00','0','Document','Surface','1','0.01','','','','','0.01','70.00','1','1','2025-11-03 13:21:14','2025-11-03 13:21:14','2147483647','2147483647','','1931','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('141','13','1','','2','3403983','2025-11-03','','4695','151','sri gopalakrihsna','919480532405','','','carst mangalgore','','','43','575001','pallavi v b','919986016968','','chambenhalli','psr aster','','11','562175','Document','10.00','0.00','0.00','0','Document','Surface','1','0.05','','','','','0.05','60.00','1','1','2025-11-03 13:21:16','2025-11-03 13:21:16','2147483647','2147483647','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('142','6','1','','2','3381518','2025-11-03','','4696','152','SRI VENKATARAMANA TEMPLE','919164993455','','','CARSTREET','MANGALORE','','11','575001','K VENKTESH SHENOY','919964019793','','AGRAHARA VILLGE','KODIL CROSS','','11','560064','Document','0.01','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-03 13:21:51','2025-11-03 13:21:51','2147483647','2147483647','SHAMYA PRASAD APOORVA MEDOWS','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('143','23','1','','2','3408487','2025-11-03','','4697','153','VINAYAK TARVAND','918147419878','','','SAMEER HOSTEL','BUNDER','','11','575001','KIRAN M','918861941390','','RAMABAI LADIES HOSTEL','BANGALORE UNIVERSITY','','11','560056','Document','100.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-03 13:21:57','2025-11-03 13:21:57','2147483647','2147483647','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('144','7','1','','2','3394996','2025-11-03','','4698','154','KEVIN PINTO','918073534264','','','PREETHI NAGAR','KULAI','','11','575011','BIPUL CHANDRANATH SEC AG','919449146999','','KORAMANGALA','BANGALORE','','11','560095','Document','0.00','0.00','0.00','0','Document','Surface','1','0.25','','','','','0.25','85.00','1','1','2025-11-03 13:22:54','2025-11-03 13:22:54','2147483647','2147483647','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('145','13','1','','2','3403984','2025-11-03','','4700','155','raju g jain','918828177525','','','carst','mangalore','','43','575001','gopal singh','919920298321','','3rd floor','ratna milan bldg','','14','400003','Document','10.00','0.00','0.00','0','Document','Surface','1','0.05','','','','','0.05','100.00','1','1','2025-11-03 13:24:22','2025-11-03 13:24:22','2147483647','2147483647','','57','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('146','25','1','','2','3388820','2025-11-03','','4701','156','SURESH','919843584454','','','FIVE  STAR  SUPER  BAZAR','BALA','','11','575030','MURGAVILAS','919789605277','','GOLDEN  TRANSPORT','SELAM  ROAD','','23','637001','Document','100.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','70.00','1','1','2025-11-03 13:24:51','2025-11-03 13:24:51','2147483647','2147483647','','592','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('147','6','1','','2','3381519','2025-11-03','','4696','157','SRI VENKATARAMANA TEMPLE','919164993455','','','CARSTREET','MANGALORE','','11','575001','SRI SUJIR GANAPATHY NAYAK','919448112100','','SHRI GANESH CLOTH CENTER','UPPINAGADY','','43','574241','Document','0.01','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','50.00','1','1','2025-11-03 13:24:56','2025-11-03 13:24:56','2147483647','2147483647','','2352','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('148','10','1','','2','3406701','2025-11-03','','4702','158','ABHISHEK','919071946224','','','MANGALORE','','','11','575004','SRI SAI TRANSPORT','919900169229','','OPP UNION BANK','UTTARAHALLI','','11','560061','Document','100.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-03 13:25:03','2025-11-03 13:25:03','2147483647','2147483647','OM SAI RESIDENCY','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('149','18','1','','2','3385025','2025-11-03','','4680','159','LAXMEESHA','919481416009','','','BOLLAJE HOUSE','KATIPALLA MANGALORE','','11','575030','SWAPANA NAIDU','919594864322','','ANATHEA AROMATICES PVT LTD','NAVI MUMBAI','','14','400701','Document','0.00','0.00','0.00','0','Document','Surface','1','0.18','','','','','0.18','130.00','1','1','2025-11-03 13:26:41','2025-11-03 13:26:41','2147483647','2147483647','','57','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('150','24','1','','2','3399445','2025-11-03','','4704','160','VENKATESH B','919538461456','','','F.O MANGALORE','MANGALORE','','43','575002','DALI DEBANATH','919741394020','','CHECKMATE SERVICES PVT LTD','INDIRA NAGAR BANGALORE','','11','560008','Document','10.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-03 13:27:10','2025-11-26 15:56:16','2147483647','2147483647','','3453','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('151','10','1','','2','3406702','2025-11-03','','4683','161','MERCY VEENA DSOUZA','917829686555','','','C V NAYAK HALL','MANGALORE','','11','575004','P OMSARAVAN','919600032159','','REDHILLS','THIRVALLUR','','23','600052','Document','100.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','70.00','1','1','2025-11-03 13:27:55','2025-11-03 13:27:55','2147483647','2147483647','M A NAGAR','2908','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('152','8','1','','2','3351470','2025-11-03','','4706','162','MAHESH S NAIK','919481492330','','','JAYALAXMI  COMPOUND','MAIN RD','','11','574142','NAVEEN SUVARNA','918123088840','','GOLDEN EMPIRE APT','ASHOK NAGAR','','11','575006','Document','10.00','0.00','0.00','0','Document','Surface','1','0.10','','','','','0.10','55.00','1','1','2025-11-03 13:28:23','2025-11-26 15:56:16','2147483647','2147483647','','3453','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('153','21','1','','2','3393085','2025-11-03','','4707','163','ZEDS','919972721904','','','KOTTARA CHOWKI','','','11','575006','KAVANA HARSHA','918088170578','','HOLLEKOPPA, BASAVANI POST','THIRTHAHALLI','','11','577432','','1000.00','0.00','0.00','0','Document','Surface','1','3.60','','','','','3.60','661.00','1','1','2025-11-03 13:28:25','2025-11-03 13:28:25','2147483647','2147483647','','3323','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('154','20','1','','2','3418002','2025-11-03','','4709','164','G V PRASAD','919986092528','','','KADRI KAMBLA','MANGALORE','','11','','NAGASHREE','919611017150','','CANARA BANK','BASAVANGUDI','','11','560004','Document','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-03 13:29:08','2025-11-03 13:29:08','2147483647','2147483647','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('155','7','1','','2','3394997','2025-11-03','','4710','165','BHARATH G','917676667957','','','MANGALORE','','','11','575011','SSA TRANSPORT','919092979343','','PERANDAPALLI BUS STOP','HOSUR','','23','635109','Document','0.00','0.00','0.00','0','Document','Surface','1','0.01','','','','','0.01','70.00','1','1','2025-11-03 13:30:33','2025-11-03 13:30:33','2147483647','2147483647','','452','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('156','6','1','','2','3381520','2025-11-03','','4696','166','SRI VENKATARAMANA TEMPLE','919164993455','','','CARSTREET','MANGALORE','','11','575001','SRI MANJUNATH PAI','918762317227','','SRI MAHALASA NARAYANI','BHANADARY BETTU','','43','574211','Document','0.01','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','50.00','1','1','2025-11-03 13:31:02','2025-11-03 13:31:02','2147483647','2147483647','','783','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('157','10','1','','2','3406703','2025-11-03','','4683','167','BLINKIT MANGALORE','917829686555','','','BEJAI','MANGALORE','','11','575004','AMRITHA COOLING SYSTEM','919019979854','','8TH MAIN ROAD, 1ST CROSS','SBM COLONY BRINDAVAN NAGAR','','11','560054','','0.00','0.00','0.00','0','Document','Surface','1','1.40','','','','','1.40','250.00','1','1','2025-11-03 13:31:06','2025-11-03 13:31:06','2147483647','2147483647','NO 51, GROUND FLOOR','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('158','18','1','','2','3385026','2025-11-03','','4711','168','MUDHAYA','919900959736','','','K A 52 B 2213','MANGALORE','','11','','H.P TRANSPORT','919535300701','','MAIN ROAD SUNKADAKATTE','BANGALORE','','11','560091','Document','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-03 13:33:12','2025-11-03 13:33:12','2147483647','2147483647','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('159','6','1','','2','3381521','2025-11-03','','4696','169','SRI VENKATARAMANA TEMPLE','919164993455','','','CARSTREET','MANGALORE','','11','575001','B ANANTH BALIGA','919036000831','','BANNERGHTTA MAIN RD','BANGALORE','','11','560076','Document','0.01','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-03 13:35:15','2025-11-03 13:35:15','2147483647','2147483647','SOURABAMA NAGAR','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('160','21','1','','2','3393086','2025-11-03','','4712','170','SHARATH','919148343492','','','KN SHENOY, CHILIMBI ROAD','CHILIMBI, MANGALORE','','11','575006','SRI VATHSA','918867159857','','SHABARI LAYOUT, PHASE 2','BALA BHARATHI SCHOOL','','11','583103','Document','500.00','0.00','0.00','0','Document','Surface','1','0.59','','','','','0.59','125.00','1','1','2025-11-03 13:35:44','2025-11-03 13:35:44','2147483647','2147483647','','427','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('161','24','1','','2','3399446','2025-11-03','','4713','171','SWASTIK INSURENCE SERVICE','918618743831','','','PUMPWELL','MANGALORE','','11','575002','ISHWARAPPA NINGABASAPPA','919880652371','','ASHOK NAGAR','MANGALORE','','11','575006','Document','0.02','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','40.00','1','1','2025-11-03 13:35:44','2025-11-26 15:56:16','2147483647','2147483647','','3453','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('162','23','1','','2','3408488','2025-11-03','','4714','172','LEVIS STORE','919606057373','','','PANDESHWARA','MANGALORE','','11','575001','ADONIS GROUP','918023147821','','8TH CROSS','MAGADAI ROAD','','11','560023','Document','100.00','0.00','0.00','0','Document','Surface','1','0.25','','','','','0.25','90.00','1','1','2025-11-03 13:36:38','2025-11-03 13:36:38','2147483647','2147483647','SHANKARAPPA GARDEN','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('163','25','1','','2','3388821','2025-11-03','','4715','173','FIVE  STAR SUPER  BAZAR','918903868875','','','BALA','MANGALOR','','11','575014','SAVMVARHIKA','919597439793','','PRAMATHI  ROAD','ROAD','','1','637001','','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','70.00','1','1','2025-11-03 13:36:48','2025-11-03 13:36:48','2147483647','2147483647','','592','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('164','20','1','','2','3418003','2025-11-03','','4716','174','SMAYYA ENT','917353761666','','','P M RAO ROAD','MANGALORE','','11','','NITHESH KUMAR G','918660598688','','R.NO 701, 7TH FLOOR','BMTC BUILDING KORAMANGALA','','11','560090','','0.00','0.00','0.00','0','Document','Surface','1','0.23','','','','','0.23','85.00','1','1','2025-11-03 13:36:52','2025-11-03 13:36:52','2147483647','2147483647','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('165','8','1','','2','3351471','2025-11-03','','4706','175','MAHESH S NAIK','919481492330','','','JAYALAXMI  COMPOUND','MAIN RD','','11','574142','HARISH S NAIK','917365819978','','I O B MARUTHI VITHIKA','THNEKAPETE','','11','576101','Document','10.00','0.00','0.00','0','Document','Surface','1','0.12','','','','','0.12','85.00','1','1','2025-11-03 13:38:05','2025-11-26 16:01:53','2147483647','2147483647','','1639','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('166','12','1','','2','3382924','2025-11-03','','4717','176','ABDUL RAZAK NALKA','919048486956','','','RAIMAS CHAMBERS OPP AJ HOPITAL','KUNTIKANA MANGALORE','','11','575004','INDUS TOWER LTD','919880911155','','OPP TO JALBHAVAN BANNERGHATTA ROAD','BANGALORE-','','11','560029','','10.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-03 13:38:25','2025-11-03 13:38:25','2147483647','2147483647','NO12 SUBRAMANYA ARCADE 7TH FLOOR TOWER D','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('167','21','1','','2','3393087','2025-11-03','','4718','177','JAI MATADI ENTERPRISES','919741465353','','','GUJJADI CHAMBERS, CHILIMBI','','','11','575006','THE AURUM SUBRAHMANYA','917022271041','','AGRAHARA SOMNATH ESWAR TEMPLE RD','KUKKE SUBRAHMANYA','','11','574238','','50.00','0.00','0.00','0','Document','Surface','1','0.05','','','','','0.05','50.00','1','1','2025-11-03 13:39:02','2025-11-03 13:39:02','2147483647','2147483647','','2577','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('168','20','1','','2','3418004','2025-11-03','','4719','178','BIPIN RAI','919972108597','','','MANGALORE','','','11','','CHANDRASHEKAR','919380993364','','NADANGERE','ANKOLA','','11','581344','Document','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-03 13:39:42','2025-11-03 13:39:42','2147483647','2147483647','','712','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('169','21','1','','2','3393088','2025-11-03','','4718','179','JAI MATADI ENTERPRISES','919741465353','','','GUJJADI CHAMBERS, CHILIMBI','','','11','575006','DIWAKAR','919900321873','','HINDLANA, NO. 180 MFAR SILVERLINE','TECH PARK, WHITEFIELD','','11','560066','','50.00','0.00','0.00','0','Document','Surface','1','0.05','','','','','0.05','60.00','1','1','2025-11-03 13:40:36','2025-11-03 13:40:36','2147483647','2147483647','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('170','13','1','','2','3403985','2025-11-03','','4720','180','northern sky','918242429339','','','j v building','mangalore','','43','575001','nikhil k m','919961833198','','moozhikkara','thalaseery','','12','670103','Document','10.00','0.00','0.00','0','Document','Surface','1','0.05','','','','','0.05','70.00','1','1','2025-11-03 13:41:05','2025-11-03 13:41:05','2147483647','2147483647','nirmalayam','642','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('171','25','1','','2','3388822','2025-11-03','','4721','181','KAV  V  LOGISTICS','917200041496','','','KODIKERI','KANA','','11','575030','BALAJI  BULK','919321777103','','GREEN  PARK','VASHI','','14','400705','Document','100.00','0.00','0.00','0','Document','Surface','1','0.15','','','','','0.15','130.00','1','1','2025-11-03 13:41:45','2025-11-03 13:41:45','2147483647','2147483647','','57','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('172','20','1','','2','3418005','2025-11-03','','4722','182','RAMESH','919448858489','','','ALAKE','MANGALORE','','11','575003','R POOJA','918971042330','','VEDAVATHI  HOSTEL','NIMHANS','','11','560029','Document','100.00','0.00','0.00','0','Document','Surface','1','0.58','','','','','0.58','125.00','1','1','2025-11-03 13:43:22','2025-11-03 13:43:22','2147483647','2147483647','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('173','25','1','','2','3388823','2025-11-03','','4723','183','KRISHNA  PRASAD','919740555973','','','SADANADA  SUPERBAZAR','SKL','','11','575014','VISHAL KUMAR','919845081664','','SARJAPURA','KASANAVALLI','','11','','Document','100.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-03 13:45:50','2025-11-03 13:45:50','2147483647','2147483647','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('174','8','1','','2','3351472','2025-11-03','','4724','184','INDIAN AUTO MOBILES','919743598558','','','OPP BUS STAND','MAIN ROAD','','11','574142','JALLUNDER MOTOR AGENCY','919342368016','','GORIGUDDA NH 17','KANKANADY','','11','575001','Document','10.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','35.00','1','1','2025-11-03 13:46:09','2025-11-26 15:56:16','2147483647','2147483647','','3453','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('175','7','1','','2','3394998','2025-11-03','','4725','185','VIHSNU ENTERPRISE','918494900304','','','PANAMBUR','MANGALORE','','11','575011','INA  INDIA  LTD','919739222247','','HOSKOTE','BANGALORE','','11','562114','Document','0.00','0.00','0.00','0','Document','Surface','1','0.05','','','','','0.05','60.00','1','1','2025-11-03 13:50:20','2025-11-10 12:29:24','2147483647','17617199828916','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('176','6','1','','2','3381522','2025-11-03','','4696','186','SRI VENKATARAMANA TEMPLE','919164993455','','','CARSTREET','MANGALORE','','11','575001','M VIJENDRA','919845014521','','7TH PHASE','PUTTENHALLI','','11','560078','Document','0.01','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-03 13:52:31','2025-11-03 13:52:31','2147483647','2147483647','J P NAGAR','1036','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('177','10','1','','2','3406704','2025-11-03','','4726','187','SONAR IMPEX','916364465119','','','NEAR BIANKA APTS','BEJAI MANGALORE','','11','','N NAGARAJAN','919787363992','','2ND CROSS STREET','OPP TO OLD BUS STAND','','23','635109','Document','0.00','0.00','0.00','0','Document','Surface','1','3.40','','','','','3.40','640.00','1','1','2025-11-03 13:52:53','2025-11-03 13:52:53','2147483647','2147483647','BRINDHAVAN GARDEN','452','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('178','23','1','','2','3408489','2025-11-03','','4727','188','SUBRAMANYA NAIK A','919880899368','','','BELTHANGADY','D K','','11','575001','OPTIMUS MEDICAL SERVICES','917619123571','','PVT LTD','CHAITHANYA BUILDING','','12','682016','Document','100.00','0.00','0.00','0','Document','Surface','1','0.20','','','','','0.20','95.00','1','1','2025-11-03 13:53:49','2025-11-03 13:53:49','2147483647','2147483647','','2432','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('179','25','1','','2','3388824','2025-11-03','','4728','189','SENTHIL','917708806608','','','FIVE  STAR  SUPER BAZAR','BALA','','11','575030','VKMS  ROAD  LINES','919443251165','','KKB  COMPLEX','84A  TRICY  ROAD','','23','637001','Document','100.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','70.00','1','1','2025-11-03 13:54:28','2025-11-03 13:54:28','2147483647','2147483647','','592','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('180','6','1','','2','3381523','2025-11-03','','4696','190','SRI VENKATARAMANA TEMPLE','919164993455','','','CARSTREET','MANGALORE','','11','575001','SRI VYOM AMITH','918898907836','','NAGAPPA BLOCK 1ST MAIN','ESHWARA NILAYA','','11','560021','Document','0.01','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-03 13:55:15','2025-11-03 13:55:15','2147483647','2147483647','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('181','7','1','','2','3394999','2025-11-03','','4725','191','VIHSNU ENTERPRISE','918494900304','','','PANAMBUR','MANGALORE','','11','575011','SATI  ENTER','919611001010','','ULSOOR ROAD','BANGALORE','','11','560042','Document','0.00','0.00','0.00','0','Document','Surface','1','0.05','','','','','0.05','60.00','1','1','2025-11-03 13:55:24','2025-11-10 12:33:07','2147483647','17617199828916','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('182','23','1','','2','3408490','2025-11-03','','4727','192','SUBRAMANYA NAIK A','919880899368','','','BELTHANGADY','D K','','11','575001','MUDASIR AHMED','918147149616','','OPP TO BRIGHT HOUSE BTM LAYOUT','1ST STAGE','','11','560029','Document','100.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-03 13:55:45','2025-11-03 13:55:45','2147483647','2147483647','5TH MAIN','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('183','26','1','','2','3400842','2025-11-03','','4731','193','RAMLATH','918904814997','','','MANGALORE','MLR','','11','575022','TAQIYA SULTHAN','918147262208','','MADEENA MASJID RD','FORT','','11','572130','Document','500.00','0.00','0.00','0','Document','Surface','1','0.19','','','','','0.19','85.00','1','1','2025-11-03 13:57:16','2025-11-03 13:57:16','2147483647','2147483647','','2750','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('184','10','1','','2','3406705','2025-11-03','','4732','194','SRI DURGA FORK LIFT SERVICES','919845318906','','','GURU PLAZA COMPLEX','BEJAIMANGALORE','','11','575004','F4 ENGINEERING INDIA PVT LTD','919538360536','','SANTHUR POST','KAUP TALUK','','11','574111','Document','100.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','50.00','1','1','2025-11-03 13:57:52','2025-11-03 13:57:52','2147483647','2147483647','1-49, PADUBIDRI','1639','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('185','25','1','','2','3388825','2025-11-03','','4733','195','SAKER','919787555740','','','FIVE  STAR  SUPER  BAZAR','BALA','','11','575014','GANAPATY  TRANSPORT','919842820870','','THABAN  KUMARASAMY','NEAR  BUS STAND','','23','637001','Document','100.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','70.00','1','1','2025-11-03 13:59:45','2025-11-03 13:59:45','2147483647','2147483647','','592','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('186','6','1','','2','3381524','2025-11-03','','4696','196','SRI VENKATARAMANA TEMPLE','919164993455','','','CARSTREET','MANGALORE','','11','575001','SRI DINESH SHENOY','918779259208','','MUMBAI','KRISHNALAY CHS LTD','','14','400601','Document','0.01','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','100.00','1','1','2025-11-03 14:03:04','2025-11-03 14:03:04','2147483647','2147483647','VRINDAVAN COMPLEX','57','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('187','13','1','','2','3403986','2025-11-03','','4737','197','BLUE LADY','919620662921','','','HAMPAKATTA','MANGALRORE','','43','575001','MEHEK','917259572818','','MARKET ROAD','CANARA BANK ATM','','11','577401','Document','10.00','0.00','0.00','0','Document','Surface','1','0.05','','','','','0.05','60.00','1','1','2025-11-03 14:06:42','2025-11-03 14:06:42','2147483647','2147483647','','2052','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('188','13','1','','2','3403987','2025-11-03','','4737','198','BLUE LADY','919620662921','','','HAMPAKATTA','MANGALRORE','','11','575001','RAYYZ SAMEER','919544440228','','CHERU ARAMB','KOLAVALOOR','','12','670693','Document','10.00','0.00','0.00','0','Document','Surface','1','0.05','','','','','0.05','70.00','1','1','2025-11-03 14:11:51','2025-11-03 14:11:51','2147483647','2147483647','','642','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('189','25','1','','2','3388826','2025-11-03','','4741','199','PRASHANTH','918110991668','','','FIVE  STAR SUPER  BAZAR','BALA','','11','575030','SRI SELLAM  TANSPORT','919443226255','','GONKU COMPLEX','PRAMATHI  ROD','','23','637001','Document','100.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','70.00','1','1','2025-11-03 14:13:11','2025-11-03 14:13:11','2147483647','2147483647','','592','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('190','10','1','','2','3406706','2025-11-03','','4743','200','MADHAWARAJ S','918248876833','','','C 1202 BRIGADE PINNACLE','DEREBAIL','','11','560096','B RAVICHANDRAN','919444226838','','NEAR MONTY SCHOOL','NANJUNDEHWARA NAGAR','','11','560096','Document','0.00','0.00','0.00','0','Document','Surface','1','0.40','','','','','0.40','105.00','1','1','2025-11-03 14:16:58','2025-11-03 14:16:58','2147483647','2147483647','4TH MAIN ROAD','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('191','25','1','','2','3388827','2025-11-03','','4744','201','MURUGAN','918220315344','','','FIVE  STAR  SUPER  BAZAR','BALA','','11','575030','C K T  TRANSPORT','919787404011','','VALLIPURAM  BY PASS','NAMMKAL','','23','637003','Document','100.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','70.00','1','1','2025-11-03 14:17:37','2025-11-03 14:17:37','2147483647','2147483647','','592','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('192','21','1','','2','3393089','2025-11-03','','4745','202','RAMA MOHAN RAOD','919880924105','','','1508, BHANDARY HEIGHTS','KOTTARA','','11','575006','KAMALAKSHA PATIL','919845572679','','403, VISHWAS TOWERS','COURT BACK ROAD','','11','576101','Document','2000.00','0.00','0.00','0','Document','Surface','1','0.39','','','','','0.39','85.00','1','1','2025-11-03 14:18:28','2025-11-03 14:18:28','2147483647','2147483647','','1639','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('193','6','1','','2','3381525','2025-11-03','','4696','203','SRI VENKATARAMANA TEMPLE','919164993455','','','CARSTREET','MANGALORE','','11','575001','SRI ANANTH MUKUND BHAT','919819290747','','KORENAGAR','BANDRA- MUMBAI','','14','400051','Document','-0.01','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','100.00','1','1','2025-11-03 14:19:45','2025-11-03 14:19:45','2147483647','2147483647','MHB COLONY','57','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('194','25','1','','2','3388828','2025-11-03','','4746','204','K  VADIVEL','919787071882','','','FIVE  STAR  SUPER  BAZAR','BALA','','11','575030','KKK  TRANSPORT','919443731899','','MAHALAKSHMI  TRANSPOT','PARAMATHIM ROAD','','23','637001','Document','100.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','70.00','1','1','2025-11-03 14:21:14','2025-11-03 14:21:14','2147483647','2147483647','','592','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('195','23','1','','2','3408491','2025-11-03','','4748','205','HEMALATHA R MALI','919341840849','','','PANDESHWARA','MANGALORE','','11','575001','MRS KANTHI S BHAT','919769107126','','W/O P S BHAT','HARISCHANDRA MARG','','11','576101','Document','100.00','0.00','0.00','0','Document','Surface','1','0.60','','','','','0.60','95.00','1','1','2025-11-03 14:23:41','2025-11-26 16:01:53','2147483647','2147483647','','1639','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('196','25','1','','2','3388829','2025-11-03','','4749','206','GANI','918870613291','','','FIVE  STAR  SUPER BAZAR','BALA','','11','575030','EVERST  AUTOMOBILE','919443682949','','RKM  BULDINGS','SANKARI','','23','637301','Document','100.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','70.00','1','1','2025-11-03 14:24:31','2025-11-03 14:24:31','2147483647','2147483647','','1817','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('197','6','1','','2','3381526','2025-11-03','','4696','207','SRI VENKATARAMANA TEMPLE','919164993455','','','CARSTREET','MANGALORE','','11','575001','SRI H SRIPATHI PAI','918123853879','','AMBALPADY','UDUPI','','11','576103','Document','-0.01','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-03 14:24:45','2025-11-26 16:01:53','2147483647','2147483647','JANARDHAN SWAMY MARG','1639','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('198','22','1','','2','3411028','2025-11-03','','4750','208','SHEKAR','917617590136','','','BANKIT SERVICES PVT LTD','MANGALORE','','11','575022','NEERAJ','919311499774','','BANKIT SERVICES PVT LTD','D-49 SECTOR 63','','26','201301','Document','10.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','100.00','1','1','2025-11-03 14:26:51','2025-11-03 14:26:51','2147483647','2147483647','','226','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('199','21','1','','2','3393090','2025-11-03','','4751','209','HARSHITHA','918217364893','','','SAI ASSOCIATES, SHOP NO. 6','PARIJATHA COMML , URWA STORE','','11','575006','JAYASUDHA','918105855723','','W/O. DEEPAKRAJ','NORTH BURAMANGALA','','11','574239','Document','200.00','0.00','0.00','0','Document','Surface','1','0.16','','','','','0.16','75.00','1','1','2025-11-03 14:27:41','2025-11-03 14:27:41','2147483647','2147483647','','2577','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('200','13','1','','2','3403988','2025-11-03','','4752','210','k vinayak bhat','919380815921','','','carstreet','mangalore','','11','575001','K VISHWANATH PRABHU','919380815921','','SRI BALAJI ENTERPRISES','JYOTI NAGAR','','11','574227','Document','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','50.00','1','1','2025-11-03 14:27:41','2025-11-03 14:27:41','2147483647','2147483647','','1068','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('201','25','1','','2','3388830','2025-11-03','','4753','211','G  THIYASARAVAN','917598028248','','','FIVE  STAR  SUPER  BAZAR','BALA','','11','575030','ESWAR TRANSPORT','919443356010','','SIDCO  COLONY','PARAMATHI  ROAD','','23','637003','Document','100.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','70.00','1','1','2025-11-03 14:27:53','2025-11-03 14:27:53','2147483647','2147483647','','592','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('202','23','1','','2','3408492','2025-11-03','','4754','212','HARISH KUMAR','919739354636','','','PANDESHWARA','MANGALORE','','11','','JAYASHANKAR','919840546799','','RAJIV GANDHI SALAI','SHOLINGANALLUR','','23','600001','Document','100.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','70.00','1','1','2025-11-03 14:30:02','2025-11-03 14:30:02','2147483647','2147483647','VERSUNI INDIA HOME SOLU','1931','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('203','21','1','','2','3393091','2025-11-03','','4755','213','MARIYAM','916366737732','','','PARIJATHA COMMERCIAL APRT','GROUND FLOOR','','11','575006','AYMAN SHAIKH','919967752239','','ROOM NO/. 10, NEAR MOHD COMPOUND','GHATKOPAR WEST','','14','400086','Document','1000.00','0.00','0.00','0','Document','Surface','1','0.19','','','','','0.19','130.00','1','1','2025-11-03 14:31:14','2025-11-03 14:31:14','2147483647','2147483647','','57','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('204','25','1','','2','3388831','2025-11-03','','4756','214','HARI','919500796394','','','HARI  HARAN','FIVE  STAR  SUPER  BAZAR','','11','575030','SANTHA  MURUGA  TPT','919443325896','','PARAMATHI  ROAD','NAMMKAL','','23','637001','Document','100.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','70.00','1','1','2025-11-03 14:31:45','2025-11-03 14:31:45','2147483647','2147483647','','592','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('205','13','1','','2','3403989','2025-11-03','','4752','215','k vinayak bhat','919380815921','','','carstreet','mangalore','','11','575001','DEEPANSHU GARG','919269676616','','NR SHRINAGAR PALACE','MARRIS ROAD','','26','','Document','0.00','0.00','0.00','0','Document','Surface','1','0.10','','','','','0.10','120.00','1','1','2025-11-03 14:32:13','2025-11-03 14:32:13','2147483647','2147483647','','2046','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('206','21','1','','2','3393092','2025-11-03','','4755','216','MARIYAM','916366737732','','','PARIJATHA COMMERCIAL APRT','GROUND FLOOR','','11','575006','ANU','917904168566','','THAAI WOMENS PG AND HOSTEL MAM','GANGA NAGAR, KODAMBAKKAM','','23','600024','Document','1000.00','0.00','0.00','0','Document','Surface','1','0.38','','','','','0.38','120.00','1','1','2025-11-03 14:33:45','2025-11-03 14:33:45','2147483647','2147483647','','1931','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('207','25','1','','2','3388832','2025-11-03','','4757','217','P  RAVICHADRAN','919786205246','','','FIVE  STAR  SUPER  BAZAR','BALA','','11','575030','M  BALU','919443375588','','AVK  & CO','BHARATHI  NAGAR','','23','637003','100','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','70.00','1','1','2025-11-03 14:35:36','2025-11-03 14:35:36','2147483647','2147483647','','592','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('208','6','1','','2','3381527','2025-11-03','','4758','218','ROHINI HARDWARE SOLUTION','917618729153','','','GURJI CENTRE','MANNAGUDDA, MANGALORE','','11','575003','GLITORIUM INDIA PVT LTD','919594939232','','BEHIND ALPANA APT','JV CR MUMBAI','','14','400086','DOOR HANDLE','3276.00','0.00','0.00','0','Document','Surface','1','2.50','','','','','2.50','770.00','1','1','2025-11-03 14:35:41','2025-11-03 14:35:41','2147483647','2147483647','2ND FLOOR SWASTIK ESPLANDE','57','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('209','13','1','','2','3403990','2025-11-03','','4759','219','YOUTH OF GSB WORLDWIDE PRIVATE LIMITED','919964586017','','','DHANVATHRI NAGAR','MANGALORE','','11','575001','RAVINDRA PAI','918197501501','','CENTURY REAL ESTATE HOLDINGS PVT LTD','VASANTH NAGAR','','11','560052','Document','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-03 14:35:56','2025-11-03 14:41:26','2147483647','2147483647','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('210','25','1','','2','3388833','2025-11-03','','4760','220','MURUGAN','918903964595','','','FIVE  STAR  SUPER  BAZAR','BALA','','11','575030','SWAMYMALAI  TRANSPORT','919003877642','','PARAMATHI  RTOAD','NAMMKAL','','23','637003','Document','100.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','70.00','1','1','2025-11-03 14:39:28','2025-11-03 14:39:28','2147483647','2147483647','','592','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('211','14','1','','2','3364660','2025-11-03','','4761','221','HEGDE AYURVEDA','919110656146','','','1 ST FLOOR SMART TOWER','NEW BALMATA','','11','575001','SANTHOSH C M','918495981769','','SRI SAI BALAJI P G 2 ND FLOOR','BESIDE VP STUDIO BALLANDUR','','11','560103','Document','10.00','0.00','0.00','0','Document','Surface','1','0.05','','','','','0.05','60.00','1','1','2025-11-03 14:40:54','2025-11-03 14:40:54','2147483647','2147483647','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('212','16','1','','2','3357227','2025-11-03','','4762','222','MUDAKAPPA','917795992544','','','GANJIMUTT','MANGALORE','','11','574144','RAMACHANDRA','919739020725','','9TH CROSS','KELGERI ROAD','','11','580008','Document','100.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-03 14:42:03','2025-11-03 14:42:03','2147483647','2147483647','','887','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('213','10','1','','2','3406707','2025-11-03','','4763','223','HARISH N SHETTY','919980963213','','','BELTHANGADY','','','11','574236','RAJANI RAMA','917042528734','','UDYOG NAGAR','','','32','110041','Document','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','100.00','1','1','2025-11-03 14:42:24','2025-11-03 14:42:24','2147483647','2147483647','OKAYA POWER PVT LTD','541','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('214','18','1','','2','3385027','2025-11-03','','4764','224','ASHOK','919972524747','','','ROYALOAK STYLEWORKS','BANGARA KULUR MANGALORE','','11','','MR RITWIK','919845022202','','NO 860,13TH MAIN 3RD BLOCK','KORAMANGALA BANGALORE','','11','560034','Document','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-03 14:43:14','2025-11-03 14:43:14','2147483647','2147483647','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('215','22','1','','2','3411029','2025-11-03','','4765','225','AIRCARE TECHNOLGIES INDIA PVT LTD','919900217000','','','ADARSH ARCADE','MALLIKATTE MANGALORE','','11','575003','PRASHANTH RAJ','919449252865','','SHOP NO 1 SUVARNA ARCADE','B M ROAD','','11','573201','Document','0.50','0.00','0.00','0','Document','Surface','1','1.00','','','','','1.00','155.00','1','1','2025-11-03 14:43:54','2025-11-03 14:43:54','2147483647','2147483647','','448','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('216','26','1','','2','3400843','2025-11-03','','4766','226','BHAWAR LIFE STYLE PUMA','918067917401','','','KALLAPU','TKT MLR','','11','575017','EMATES FRANCHISE P LTD','917736345727','','GANDHI ASHRAM','MALARAMA','','12','673020','Parcel','1800.00','0.00','0.00','0','Document','Surface','1','0.35','','','','','0.35','120.00','1','1','2025-11-03 14:44:12','2025-11-03 14:44:12','2147483647','2147483647','','161','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('217','10','1','','2','3406708','2025-11-03','','4767','227','MANJUNATH R SHETTY','918618076522','','','KARKALA','','','11','576112','POLICE INSPECTOR','919901761101','','SHESHADRIPURAM','','','11','560020','Document','100.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-03 14:45:52','2025-11-03 14:45:52','2147483647','2147483647','SHESHADRIPURAM POLICE STATION','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('218','25','1','','2','3388834','2025-11-03','','4768','228','C MANIVEL','919566770333','','','FIVE STAR SUPER','BALA','','11','575014','R GOPAL','919787776606','','SALEM ROAD','NAMAKKAL','','23','676001','Document','100.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','70.00','1','1','2025-11-03 14:46:54','2025-11-03 14:46:54','2147483647','2147483647','R GOPAL TRT','2424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('219','23','1','','2','3408493','2025-11-03','','4769','229','JAYANTHIMALA','919916644540','','','PANDESHWARA','MANGALORE','','11','575001','A U YOHANNAN','919731733025','','NANDUGURI','OLD STATION','','11','574221','Document','100.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','50.00','1','1','2025-11-03 14:47:07','2025-11-03 14:47:07','2147483647','2147483647','','3411','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('220','20','1','','2','3418006','2025-11-03','','4770','230','ADITHYA ENT','917718970597','','','KODIALBAIL','MANGALORE','','11','575003','ADITHYA FLEX','919360840243','','#39, FIFTY ROAD','RAMAKRISHNAPURAM','','23','639002','Document','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','70.00','1','1','2025-11-03 14:48:06','2025-11-03 14:48:06','2147483647','2147483647','','569','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('221','13','1','','2','3403991','2025-11-03','','4771','231','FARUK SHEIKH','919740123456','','','NEAR FLOWER MARKET','CARST','','11','575001','CHEDDILAL MAURYA','919969274284','','INDRA LOK COMPLEX','VIMAL DAIRY LANE BHAYANDAR EAST','','14','401105','Document','10.00','0.00','0.00','0','Document','Surface','1','0.20','','','','','0.20','130.00','1','1','2025-11-03 14:49:30','2025-11-03 14:49:30','2147483647','2147483647','','57','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('222','26','1','','2','3400844','2025-11-03','','4766','232','BHAWAR LIFE STYLE PUMA','918067917401','','','KALLAPU','TKT MLR','','11','575017','PUMA FACTORY OUTLET','917338981006','','POONAMALLIIEE MN RD','KATTUPAKKAM','','23','600056','T SHIRT','1800.00','0.00','0.00','0','Document','Surface','1','0.26','','','','','0.26','120.00','1','1','2025-11-03 14:49:59','2025-11-03 14:49:59','2147483647','2147483647','','1931','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('223','17','1','','2','3404669','2025-11-03','','4772','233','SHARATH BANGERA','919916901398','','','FALNIR ROAD','MANGALORE','','11','575002','M/S SUNU= UMBRELLA CO LTD','918212514578','','BELAGOLA IND AREA','MYSORE','','11','570016','Others','500.00','0.00','0.00','0','Document','Surface','1','0.85','','','','','0.85','155.00','1','1','2025-11-03 14:50:23','2025-11-03 14:50:23','2147483647','2147483647','#211 FIRST FLOOR','669','UMBRELLA','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('224','23','1','','2','3408494','2025-11-03','','4769','234','JAYANTHIMALA','919916644540','','','PANDESHWARA','MANGALORE','','11','575001','BABU K T','917619515784','','KAMPADAKADU HOUSE','RENJILADY','','11','574221','Document','100.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','50.00','1','1','2025-11-03 14:50:27','2025-11-03 14:50:27','2147483647','2147483647','','3411','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('225','14','1','','2','3364661','2025-11-03','','4761','235','HEGDE AYURVEDA','919110656146','','','1 ST FLOOR SMART TOWER','NEW BALMATA','','11','575001','B K ROOPA','919620814649','','#201  G1 BLOCK','GODREJ ETRNITY HOLIDAY VILLEGE RD','','11','560062','Document','10.00','0.00','0.00','0','Document','Surface','1','0.12','','','','','0.12','85.00','1','1','2025-11-03 14:50:52','2025-11-03 14:50:52','2147483647','2147483647','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('226','25','1','','2','3388835','2025-11-03','','4773','236','S VENKATESH','916374573986','','','FIVE STAR SUPER','KANA','','11','575014','CKP BULK CARRIERS','919443347593','','THILLADIPURAM','NAMAKKAL','','23','637001','Document','100.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','70.00','1','1','2025-11-03 14:51:04','2025-11-03 14:51:04','2147483647','2147483647','','2424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('227','23','1','','2','3408495','2025-11-03','','4769','237','JAYANTHIMALA','919916644540','','','PANDESHWARA','MANGALORE','','11','575001','BALACHANDRA','918028015700','','SIVANTOS INDIA PVT LTD','DODDENAKKUNDI','','11','560048','Document','100.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-03 14:52:30','2025-11-03 14:52:30','2147483647','2147483647','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('228','7','1','','2','3395000','2025-11-03','','4774','238','DIKSHITH KULAL','917039532528','','','UDUPI','MANGALORE','','11','575011','SUHAS','918850575701','','PENINSULA BUS PARK','POWER PAREL WEST','','14','400013','Document','0.00','0.00','0.00','0','Document','Surface','1','0.26','','','','','0.26','170.00','1','1','2025-11-03 14:52:48','2025-11-03 14:52:48','2147483647','2147483647','','57','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('229','7','1','','2','3395001','2025-11-03','','4774','239','DIKSHITH KULAL','917039532528','','','UDUPI','MANGALORE','','11','575011','BHAVANI KARANI','919324785473','','SENAPATI BAPOT,MARG','LOWER PAREL','','14','400013','Parcel','20000.00','0.00','0.00','0','Document','Surface','1','1.97','','','','','1.97','610.00','1','1','2025-11-03 14:55:25','2025-11-03 14:55:25','2147483647','2147483647','','57','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('230','23','1','','2','3408496','2025-11-03','','4769','237','JAYANTHIMALA','919916644540','','','PANDESHWARA','MANGALORE','','11','575001','BALACHANDRA','918028015700','','SIVANTOS INDIA PVT LTD','DODDENAKKUNDI','','11','560048','Document','100.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-03 14:55:28','2025-11-03 14:55:28','2147483647','2147483647','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('231','14','1','','2','3364662','2025-11-03','','4775','240','SHEKHAR K','918746947475','','','HASCO TRAVELS','BALMATA RD MANGALORE','','11','577432','SURAPPA','918050300891','','HEGDE GAS AGENCIES HEGDE EXTENSION','AGUMBE RD','','11','577432','Document','10.00','0.00','0.00','0','Document','Surface','1','0.04','','','','','0.04','60.00','1','1','2025-11-03 14:57:06','2025-11-03 14:57:06','2147483647','2147483647','','3323','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('232','25','1','','2','3388836','2025-11-03','','4776','241','DO WELL','919844606243','','','SWASTHIKA TOWERS','MRPL ROAD SURATHKAL','','11','575014','MUNNA INDUSTRIES','919945051101','','OPP JIMMYS SUPER MARKET','AGARWAL LANE ROAD KADRI MANGLORE','','11','575002','Document','100.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','50.00','1','1','2025-11-03 14:58:20','2025-11-26 15:56:16','2147483647','2147483647','','3453','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('233','23','1','','2','3408497','2025-11-03','','4777','242','SUNDRESH','919731805276','','','RTO PANDESHWAR','MANGALORE','','11','575001','MR GAVIRANGAPPA M','919740162090','','YESHWANPURA','RTO COMPLEX','','11','560022','Document','100.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-03 14:59:55','2025-11-03 18:00:39','2147483647','17617218175043','RTO COMPLEX YESHWARPUR','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('234','18','1','','2','3385028','2025-11-03','','4778','243','PRADEEP','919741996840','','','KA 19 AA6355','KULUR MANGALORE','','11','575013','SRI MARUTHI TRANSPORT','917892111686','','BYRAPPA COMPLEX S S CIRCLE','B.H ROAD  TUMKUR','','11','572102','Document','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-03 15:00:19','2025-11-03 15:00:19','2147483647','2147483647','','1633','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('235','26','1','','2','3400845','2025-11-03','','4766','244','BHAWAR LIFE STYLE PUMA','918067917401','','','KALLAPU','TKT MLR','','11','575017','BHASKER','918041466395','','.','BASAVANDUDI','','11','560004','Document','0.00','0.00','0.00','0','Document','Surface','1','0.22','','','','','0.22','85.00','1','1','2025-11-03 15:02:09','2025-11-03 15:02:09','2147483647','2147483647','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('236','25','1','','2','3388837','2025-11-03','','4776','245','DO WELL','919844606243','','','SWASTHIKA TOWERS','MRPL ROAD SURATHKAL','','11','575014','SBI','918494900487','','MANJUSHA BUILDING','BEJAI CHURCH ROAD MANGLORE','','11','575004','Document','100.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','50.00','1','1','2025-11-03 15:03:43','2025-11-26 15:56:16','2147483647','2147483647','','3453','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('237','8','1','','2','3351473','2025-11-03','','4779','246','HARISH GUJARAN','918951855350','','','NITHYANANDA NILAYA','KALVAR MSEZ COLONY','','11','574142','VEDA SHINDE','919833771260','','ASMITHA  JOTHI HSG SO','MARVE RD MALAD  WEST','','14','400095','DRESS','750.00','0.00','0.00','0','Document','Surface','1','1.54','','','','','1.54','530.00','1','1','2025-11-03 15:03:48','2025-11-03 15:03:48','2147483647','2147483647','','57','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('238','23','1','','2','3408498','2025-11-03','','4777','247','SUNDRESH','919731805276','','','RTO PANDESHWAR','MANGALORE','','11','575001','MR SHEKAR BIRWA','919448428822','','BIRWA AUTO CONCULTANTS','NEAR RTO BANNUR','','11','','Document','100.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','50.00','1','1','2025-11-03 15:04:21','2025-11-03 18:01:43','2147483647','17617218175043','','1904','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('239','24','1','','2','3399447','2025-11-03','','4780','248','COOL COMFORTZ','919611637732','','','PUMPWELL','MANGALORE','','11','575002','DYUT REFRIGERATION','917483710183','','OPP MINI VIDHANA SOUDHA','MULUR ROAD KUMTA','','11','581343','Parcel','1006.00','0.00','0.00','0','Document','Surface','1','1.19','','','','','1.19','201.00','1','1','2025-11-03 15:06:01','2025-11-03 15:06:01','2147483647','2147483647','','165','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('240','10','1','','2','3406709','2025-11-03','','4781','249','9741240661','919741240661','','','ROOPESH KUMAR M S','HORTICULTURE ASST','','11','575002','NAGAVENI','919535344309','','ADMN TRAINING INST','LALITHAMAHAL ROAD','','11','570011','Document','100.00','0.00','0.00','0','Document','Surface','1','1.10','','','','','1.10','201.00','1','1','2025-11-03 15:07:06','2025-11-03 15:07:06','2147483647','2147483647','LIBRARY ASST LIBRARY','669','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('241','6','1','','2','3381528','2025-11-03','','4782','250','PRAVIN KUMAR','919845256555','','','ROHINI KRIPA','NER KUDROLI TEMPLE ALAKE','','11','','K B CHANDRASHEKAR','919886110177','','9TH MAIN 3RD PHASE','GIRINAGAR','','11','560085','Document','0.01','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-03 15:07:10','2025-11-03 15:07:10','2147483647','2147483647','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('242','23','1','','2','3408499','2025-11-03','','4783','251','PACK MART','919945671204','','','BUNDER','MANGALORE','','11','','M/S NAGARKAR ENTE','919448995709','','HNNAVAR','00','','11','','Document','100.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-03 15:08:31','2025-11-03 15:08:31','2147483647','2147483647','BAZAR PETE','191','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('243','26','1','','2','3400846','2025-11-03','','4784','252','MSIL','919110444383','','','KOTEKAR','MLR','','11','575022','MSIL','919110444383','','KPDY','MLR','','11','575003','Document','0.00','0.00','0.00','0','Document','Surface','1','0.05','','','','','0.05','30.00','1','1','2025-11-03 15:09:39','2025-11-26 15:56:16','2147483647','2147483647','','3453','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('244','8','1','','2','3351474','2025-11-03','','4785','253','B N RAMESH','919880738695','','','SHENOY COMPOUND','KALLAJARY RD','','11','574142','UNIVA MEDICA','919900677585','','LAKSHMIPURA MAIN ROAD','CHIKKABANAVARA','','11','560090','Document','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-03 15:10:35','2025-11-03 15:10:35','2147483647','2147483647','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('245','23','1','','2','3408500','2025-11-03','','4786','254','SRI MADHUR TRANSPORT','919880173154','','','BAIKAMPADY','MANGALORE','','23','','BRIGHT FLEXI INTER PVT LTD','919632069693','','00','','','11','576121','Document','100.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','50.00','1','1','2025-11-03 15:11:42','2025-11-03 15:11:42','2147483647','2147483647','INNA VILLAGE','2319','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('246','16','1','','2','3357228','2025-11-03','','4787','255','MEDHASVI HYDRAULICS','919980003023','','','TENKA YEDAPADAVU','MANGALORE','','11','574144','ADHIE GEARS','919341260607','','PEENYA INDL AREA','BANGALORE','','11','560058','Document','4000.00','0.00','0.00','0','Document','Surface','1','6.00','','','','','6.00','660.00','1','1','2025-11-03 15:13:45','2025-11-03 15:13:45','2147483647','2147483647','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('247','13','1','','2','3403992','2025-11-03','','4788','256','M BABA PAI','918242496499','','','CARSTREET','MANGALORE','','11','575001','BHARATH BEEDI WORKS','910824242230','','BHARATH LOGIESTCS','BAIKAMPADY','','11','575011','Document','10.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','40.00','1','1','2025-11-03 15:14:52','2025-11-26 15:56:16','2147483647','2147483647','','3453','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('248','8','1','','2','3351475','2025-11-03','','4789','257','SARANG MOHD WAJID','918749058737','','','KAIKAMBA RD','MAIN RD','','11','574142','ALLWYN','919741099989','','1ST FLR 1ST MAIN CROSS 2ND CROSS','LBS NAGAR SVT PRIDE','','11','560017','Non Doc','0.00','0.00','0.00','0','Document','Surface','1','0.67','','','','','0.67','125.00','1','1','2025-11-03 15:15:21','2025-11-03 15:15:21','2147483647','2147483647','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('249','23','1','','2','3408501','2025-11-03','','4790','258','K M CHANDRA SHEKAR','919487144457','','','PANDESHWARA','MANGALORE','','11','','THE SUPREME INDU LTD','919445006608','','SEVELOPED PLOT ESTATE','GUINDY','','23','600032','Document','100.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','70.00','1','1','2025-11-03 15:15:26','2025-11-03 15:15:26','2147483647','2147483647','HALL MARK TOWER','1931','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('250','24','1','','2','3399448','2025-11-03','','4791','259','SHAKTHI LIFE LINE','919731984022','','','KANKANADY','MANGALORE','','11','575002','DR RASHMI','919880570058','','VIDHYANAGR','SHIMOGA','','11','577201','Document','0.00','0.00','0.00','0','Document','Surface','1','0.48','','','','','0.48','105.00','1','1','2025-11-03 15:16:26','2025-11-03 15:32:28','2147483647','2147483647','TANVI HOSPITAL','1829','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('251','8','1','','2','3351476','2025-11-03','','4789','260','SARANG MOHD WAJID','918749058737','','','KAIKAMBA RD','MAIN RD','','11','574142','AMIN ASHRAFI','917559387884','','PLOT #67 NOOR VILLA NR MAHAKAL LOK','SUBHAN NAGAR','','14','440035','Non Doc','0.00','0.00','0.00','0','Document','Surface','1','0.09','','','','','0.09','120.00','1','1','2025-11-03 15:18:50','2025-11-03 15:18:50','2147483647','2147483647','','335','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('252','10','1','','2','3406710','2025-11-03','','4792','261','VIGNESH','919741421054','','','VIJETHA PADMA NILAYA','NODU LANE','','11','575004','HITESH KUMAR','918880004445','','407 PROVIDENT SKY WORTH','VENKATAGIRI VILLAGE','','11','560060','Document','100.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-03 15:19:36','2025-11-03 15:19:36','2147483647','2147483647','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('253','23','1','','2','3408502','2025-11-03','','4825','284','RIYAZ','919900114197','','','PANDESHWARA','MANGALORE','','11','575001','SANTHOSH','919731550734','','BYRAVA DRIVING SCHOOL','RAJAJINAGAR','','11','560010','Document','100.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-03 15:19:44','2025-11-03 18:04:23','2147483647','17617218175043','HALL MARK TOWERS','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('254','8','1','','2','3351477','2025-11-03','','4789','263','SARANG MOHD WAJID','918749058737','','','KAIKAMBA RD','MAIN RD','','11','574142','SAGAR','919870444669','','COSMOSE  ENCLVE RAM MANDIR RD','KASARDAVALLI','','14','400615','Non Doc','0.00','0.00','0.00','0','Document','Surface','1','0.42','','','','','0.42','170.00','1','1','2025-11-03 15:21:41','2025-11-03 15:21:41','2147483647','2147483647','','848','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('255','14','1','','2','3364663','2025-11-03','','4794','264','DEERAJ H D SILVA','917259439695','','','MARNAMIKATTA NEW','CROSS ROAD','','11','575001','NATRAJ DONKENNANAVAR','919731439963','','NO 1639 2 ND MAIN 9 TH CROSS','OPP BBMP PARK WEAVES COLONY','','11','560032','Document','10.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-03 15:22:12','2025-11-03 15:22:12','2147483647','2147483647','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('256','10','1','','2','3406711','2025-11-03','','4795','265','KARTHIK P','918550875144','','','MANGALORE','','','11','575004','SAVITHA','917069075750','','JAYANAGAR','BANGALORE','','11','560041','Document','100.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-03 15:22:19','2025-11-03 15:22:19','2147483647','2147483647','NEXION TILES PVT LTD','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('257','7','1','','2','3395002','2025-11-03','','4800','266','PRASAD RATHOD','917483737836','','','SHIRTHADY VILLAGE','MANGALORE','','11','575011','SREE SIDDAGANGA ENT','918147456793','','DURGESH HOUSE','AKASHVANI','','11','583201','Document','0.00','0.00','0.00','0','Document','Surface','1','0.01','','','','','0.01','60.00','1','1','2025-11-03 15:27:28','2025-11-03 15:27:28','2147483647','2147483647','','451','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('258','10','1','','2','3406712','2025-11-03','','4801','267','PRABHU E','919108466827','','','APOLLO PHRMACY','MANGALORE','','11','575004','KAVITHA','918022960462','','SINGASANDRA','HOSUR MAIN ROAD','','11','560006','Document','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-03 15:27:59','2025-11-03 15:27:59','2147483647','2147483647','APOLLO PHARMACY','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('259','17','1','','2','3404670','2025-11-03','','4803','268','AJITHA K','919108236001','','','FALNIR','MANGALORE','','11','575001','ABOOBAKAR SIDDIQH A I','919108236001','','P O KANDALI','','','11','','Document','0.03','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-03 15:28:39','2025-11-03 15:28:39','2147483647','2147483647','IBRAHIM DODDAMANDIGNHALLI','448','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('260','24','1','','2','3399449','2025-11-03','','4804','269','KIRAN M.K','919353596558','','','SAHYADRI COLLEGE OF ENG','ADYAR MANGALORE','','11','575007','NAGENDRAPPA B.K','919845159239','','1ST CROSS SRI SIDDARUDA NIVAS','RAGHAVENDRA COLONY HIREKERUR','','11','581111','Document','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-03 15:28:45','2025-11-03 15:28:45','2147483647','2147483647','','1126','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('261','18','1','','2','3385029','2025-11-03','','4806','271','EXPORT INSPECTION AGENCIES','919620201415','','','SUB OFFICE KULUR','MANGALORE','','11','575001','LABORATORY','910484231694','','EXPORT INSPECTION AGENCY-KOCHI','PANAMPILLY NAGAR KOCHI','','12','','Document','0.00','0.00','0.00','0','Document','Surface','1','0.73','','','','','0.73','140.00','1','1','2025-11-03 15:29:45','2025-11-03 15:29:45','2147483647','2147483647','','2432','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('262','23','1','','2','3408503','2025-11-03','','4807','272','JISHNU CHANDRAN','919495238468','','','PANDESHWARA','MANGALORE','','11','575002','VIKAS N','919986354548','','SMS LABS SERVICES PVT LTD','NEAR VSS PUBLIC SCHOOL KENGREI','','11','560056','Document','100.00','0.00','0.00','0','Document','Surface','1','0.60','','','','','0.60','125.00','1','1','2025-11-03 15:29:51','2025-11-03 15:29:51','2147483647','2147483647','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('263','25','1','','2','3388838','2025-11-03','','4808','273','NAGARAJA S','918976763250','','','SURATHKAL','','','11','575014','ADINITY VENTURE PVTE','918976763251','','G 004 PLATFORM LEVEL','CBD BELAPUR MUMBAI','','14','400614','Document','100.00','0.00','0.00','0','Document','Surface','1','0.10','','','','','0.10','120.00','1','1','2025-11-03 15:30:14','2025-11-03 15:30:14','2147483647','2147483647','','57','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('264','22','1','','2','3411030','2025-11-03','','4809','274','PRATHIBA EYE HOSPITAL','919611448991','','','OPP CANARA BK KADRI RD','MANGALORE','','11','575003','MD INDIA TPA PVT LTD','919326442922','','E SPACE A2 BUILDING','PUNE NAGAR RD VADGAONASHERI','','14','411014','Document','10.00','0.00','0.00','0','Document','Surface','1','0.25','','','','','0.25','130.00','1','1','2025-11-03 15:30:41','2025-11-03 15:30:41','2147483647','2147483647','','13','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('265','8','1','','2','3351478','2025-11-03','','4810','275','CRYSTAL INDUSTRIES','917899057126','','','SUNKADAKATTE','BAJPE','','11','574142','GURUPRASAD ENTERPRISES','919449830748','','CRYSTAL ARC','BALMATTA RD','','11','575002','Document','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','35.00','1','1','2025-11-03 15:32:19','2025-11-26 15:56:16','2147483647','2147483647','','3453','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('266','17','1','','2','3404671','2025-11-03','','4811','276','A J SECURITY SERVICES','919448233466','','','SHIVBAGH','MANGALORE','','11','','SHILESH','919819494354','','OPP VIJAYA SALES SHOWROOM','S V ROAD SANTACRUZ','','14','400054','Document','0.02','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','100.00','1','1','2025-11-03 15:33:38','2025-11-03 15:33:38','2147483647','2147483647','SANGAM BY RUSTMJEE','57','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('267','13','1','','2','3403993','2025-11-03','','4814','277','M BABA PAI','918494900306','','','CARST','MANGALORE','','11','575001','WEST INDIA SOAP','918494900306','','KULSHEKAR','MAROLI','','43','575011','Document','10.00','0.00','0.00','0','Document','Surface','1','0.05','','','','','0.05','35.00','1','1','2025-11-03 15:34:58','2025-11-03 16:08:09','2147483647','2147483647','','3453','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('268','8','1','','2','3351479','2025-11-03','','4810','278','C M GRANITES','917899057126','','','SUNKADAKATTE','BAJPE','','11','574142','MANGALORE  EARTH MOVERS','917795000600','','NEXT HOTEL RATNA','KULUR','','11','575013','Document','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','35.00','1','1','2025-11-03 15:35:34','2025-11-26 15:56:16','2147483647','2147483647','','3453','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('269','22','1','','2','3411031','2025-11-03','','4809','274','PRATHIBHA EYE HOSPITAL','919611448991','','','OPP CANARA BANK KADRI RD','MANGALORE','','11','575003','MD INDIA TPA PVT LTD','919326442922','','E SPACE A2 BUILDING','PUNE NAGAR RD VADGAONASHERI','','14','411014','Document','0.10','0.00','0.00','0','Document','Surface','1','0.25','','','','','0.25','130.00','1','1','2025-11-03 15:36:07','2025-11-03 15:36:07','2147483647','2147483647','','13','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('270','26','1','','2','3400847','2025-11-03','','4815','279','SANJEEVINI BIO MED','919343376424','','','TKT','MLR','','11','575017','SERA THE HEALTHCARE','918223258672','','BYLAKOPPE','BYLAKOPPE','','11','571190','MEDICINE','1000.00','0.00','0.00','0','Document','Surface','1','2.42','','','','','2.42','431.00','1','1','2025-11-03 15:36:19','2025-11-03 15:36:19','2147483647','2147483647','','669','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('271','20','1','','2','3418007','2025-11-03','','4817','280','KATEEL DINESH RAO','919343351400','','','FIELD STREET','MANGALORE','','11','575001','SRI NARASIMHA SHENOY','919845439201','','#602 10TH CROSS 7TH BLOCK WEST','JAYANAGAR','','11','560070','Document','300.00','0.00','0.00','0','Document','Surface','1','0.84','','','','','0.84','160.00','1','1','2025-11-03 15:37:04','2025-11-03 15:37:04','2147483647','2147483647','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('272','24','1','','2','3399450','2025-11-03','','4791','281','SHAKTHI LIFE LINE','919731984022','','','KANKANADY','MANGALORE','','11','575002','DR SUMAN SINGH KM','919611532302','','SHRUSTI SKIN CLINIC','SHIMOGA','','11','577201','Document','0.00','0.00','0.00','0','Document','Surface','1','0.12','','','','','0.12','85.00','1','1','2025-11-03 15:37:24','2025-11-03 15:37:24','2147483647','2147483647','','1829','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('273','6','1','','2','3381529','2025-11-03','','4821','282','SAKSHAM','918050806969','','','DANISH APT','KAMBLA CROSS','ALAKE','43','575003','NOBEL JOY','917428495688','','H SIDDAIHA RD','4TH CROSS WILSON GARDEN','','11','560027','BANGALORE','0.02','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-03 15:38:05','2025-11-03 15:38:05','2147483647','2147483647','UNO  MINDA LTD','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('274','8','1','','2','3351480','2025-11-03','','4810','283','C M GRANITES','917899057126','','','SUNKADAKATTE','BAJPE','','11','574142','H VASUDEVA  SHET','919448078007','','VALLABA 2ND FLR BHOJA RAO LANE','KUDROLI','','11','575003','Document','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','35.00','1','1','2025-11-03 15:38:26','2025-11-26 15:56:16','2147483647','2147483647','','3453','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('275','21','1','','2','3393093','2025-11-03','','4823','93','KAUSHIK','918147599847','','','HONDA BIG WING','VSK TOWER, KOTTARA CHOWKI','','11','575006','ABHIJEET','919620422492','','IDFC FIRST BANK, SIDDU COMPLEX','VISHWAMANAVASARASWATHIPURAM MYSORE','','11','570009','Document','50.00','0.00','0.00','0','Document','Surface','1','0.12','','','','','0.12','85.00','1','1','2025-11-03 15:38:42','2025-11-03 15:38:42','2147483647','2147483647','','669','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('276','8','1','','2','3351481','2025-11-03','','4810','285','C M GRANITES','917899057126','','','SUNKADAKATTE','BAJPE','','11','574142','VELANKANI CONSTRUCTIONS','918722909771','','MILLAGRES BLDG','OPP CANARA BANK HAMPANKATTE','','11','575001','Document','0.00','0.00','0.00','0','Document','Surface','1','0.06','','','','','0.06','55.00','1','1','2025-11-03 15:41:01','2025-11-26 15:56:16','2147483647','2147483647','','3453','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('277','17','1','','2','3404672','2025-11-03','','4828','286','ANITHA','919148519814','','','MANGALORE','','','11','560077','DR AUGUSTIN JOSEPH','919535516307','','HENNUR BAGLUR MAIN ROAD','KOTHANUR','','11','','Food Items','500.00','0.00','0.00','0','Document','Surface','1','0.50','','','','','0.50','105.00','1','1','2025-11-03 15:41:19','2025-11-03 15:41:19','2147483647','2147483647','PATEL RAMAIH SITE NO','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('278','22','1','','2','3411032','2025-11-03','','4830','287','P JYOTHI KUMAR','919449110972','','','SRINIKETAN CHURCH COMPOUND','2ND  CROSS KULSHEKHAR','','11','575005','P SREEKUMAR','919847284771','','SREELAKAM 2 E RINDAVAN V HOMES','KARADARAMBA','','12','673010','Document','0.10','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','70.00','1','1','2025-11-03 15:41:25','2025-11-03 15:41:25','2147483647','2147483647','','112','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('279','7','1','','2','3395003','2025-11-03','','4832','288','SHREE DURGA ENT','919036493899','','','BAIKAMPADY','MANGALORE','','11','575011','FINPOWER AIRCON SYSTEMS P LTD','919741626661','','MANGALORE','','','11','574144','Document','0.00','0.00','0.00','0','Document','Surface','1','2.90','','','','','2.90','385.00','1','1','2025-11-03 15:42:14','2025-11-10 12:00:06','2147483647','17617199828916','','3254','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('280','23','1','','2','3408504','2025-11-03','','4833','289','HASAN HAJEE & CO','918242420737','','','BUNDER','MANGALORE','','11','575001','SRI SRIKANTH R','919880580818','','E RAMAMURTHI MINERALS','ERM HOUSE','K R ROAD','11','560070','Document','100.00','0.00','0.00','0','Document','Surface','1','0.10','','','','','0.10','75.00','1','1','2025-11-03 15:42:20','2025-11-03 15:42:20','2147483647','2147483647','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('281','10','1','','2','3406713','2025-11-03','','4837','291','JILU AUTO GAS','919845127397','','','OPP AJ HOSPITAL','KUNTIKAN','','28','700107','SOURAV DAS','917003088697','','RAJDANGA MAIN ROAD','','','28','700107','Document','100.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','100.00','1','1','2025-11-03 15:43:33','2025-11-03 15:43:33','2147483647','2147483647','INDIAN OIL PETRONAS PVT LTD','2666','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('282','8','1','','2','3351482','2025-11-03','','4810','292','C M GRANITES','917899057126','','','SUNKADAKATTE','BAJPE','','11','574142','R S INFRAS DEVLOPERS','918105245981','','PREETHAM TOWER','BYPASS BANTWAL','','11','574211','Document','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','50.00','1','1','2025-11-03 15:43:45','2025-11-03 15:43:45','2147483647','2147483647','','783','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('283','26','1','','2','3400848','2025-11-03','','4840','294','SHALIHA','917338799162','','','TKT','MLR','','11','575017','KALEES','918610370496','','PA;LAYAM KOLAIYAM','COVAI','','23','571190','CREAM','100.00','0.00','0.00','0','Document','Surface','1','0.05','','','','','0.05','70.00','1','1','2025-11-03 15:44:36','2025-11-03 15:44:36','2147483647','2147483647','','2039','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('284','23','1','','2','3408505','2025-11-03','','4833','295','HASAN HAJEE & CO','918242420737','','','BUNDER','MANGALORE','','11','575001','M/S SEROS SHIPPING PVT LTD','919845939315','','UNION HEIGHTS','BESIDE LAL BHAI STATDIUM VESU','','7','395007','Document','100.00','0.00','0.00','0','Document','Surface','1','0.10','','','','','0.10','120.00','1','1','2025-11-03 15:46:07','2025-11-03 15:46:07','2147483647','2147483647','','163','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('285','7','1','','2','3395004','2025-11-03','','4841','296','YASHASVI ENG','919980159955','','','KULAI','MANGALORE','','11','575011','DILIP BUILDCON LTD','919340427060','','MALUR','HOBLI','','11','563130','Parcel','316.00','0.00','0.00','0','Document','Surface','1','0.66','','','','','0.66','130.00','1','1','2025-11-03 15:46:10','2025-11-03 15:46:10','2147483647','2147483647','','1165','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('286','16','1','','2','3357229','2025-11-03','','4843','297','DINESH','919964160416','','','KALABHAIRAVA TEMPLE','MALALI','','11','','SHARATH KUMAR','919380863652','','SRI NAGAR','BANGALORE','','11','560050','Document','0.10','0.00','0.00','0','Document','Surface','1','0.45','','','','','0.45','105.00','1','1','2025-11-03 15:46:38','2025-11-03 15:46:38','2147483647','2147483647','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('287','6','1','','2','3381530','2025-11-03','','4844','298','THE CANARA WORKSHOP LTD','918242458090','','','SB ROAD URWA MKT','MANGALORE','','11','575006','BHARATH AUTO MOBILE','918242458090','','BC ROAD','BC RD','','11','574219','Document','0.01','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','50.00','1','1','2025-11-03 15:46:55','2025-11-03 15:46:55','2147483647','2147483647','BHARATH PLAZA','1006','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('288','18','1','','2','3385030','2025-11-03','','4846','299','VINAYAKA ENGINEERING  WORKS PVT LTD','919964561451','','','BAIKAMPADY INDSUTRIAL AREA','MANGALORE','','11','575011','NEW OLOG LOGISTICES PVT LTD','916369133996','','MOGAPPAIR ERI SCHEME','TAMIL NADU','','23','600037','Document','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','70.00','1','1','2025-11-03 15:47:08','2025-11-03 15:47:08','2147483647','2147483647','','2996','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('289','8','1','','2','3351483','2025-11-03','','4810','300','C M GRANITES','917899057126','','','SUNKADAKATTE','BAJPE','','11','574142','JOEL CHRISTOPHER  PEREIRA','919945542962','','IRC CONCERTE MIX INDIA LTD','BAIKAMPADY','','11','575011','Document','0.00','0.00','0.00','0','Document','Surface','1','0.10','','','','','0.10','55.00','1','1','2025-11-03 15:47:12','2025-11-26 15:56:16','2147483647','2147483647','','3453','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('290','26','1','','2','3400849','2025-11-03','','4847','301','SHALIHA','919611308572','','','TKT','MLR','','11','575017','THAMEEM ANSARI','919611308572','','PUDUPATTINAM','S H STREET','','23','603102','CREAM','100.00','0.00','0.00','0','Document','Surface','1','0.10','','','','','0.10','85.00','1','1','2025-11-03 15:47:47','2025-11-03 15:47:47','2147483647','2147483647','','1744','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('291','22','1','','2','3411033','2025-11-03','','4848','302','VISHRANTH AND KARTHIK','919845422424','','','CA 2ND FLOOR MALLIKATTE CIRCLE','MANGALORE','','11','575002','VISHRANTH AND KARTHI K','919108435934','','CA FIRST FLOOR 1OTH CROSS RD','18TH MAINIST STAGE PADMANABHANAGAR','','11','560070','Document','0.10','0.00','0.00','0','Document','Surface','1','0.15','','','','','0.15','85.00','1','1','2025-11-03 15:48:34','2025-11-03 15:48:34','2147483647','2147483647','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('292','7','1','','2','3395005','2025-11-03','','4850','303','ISSAC JAMES DSOUZA','917406572894','','','RAHEJA WATERFRONT','KULAI MANGALORE','','11','575011','INDUSVIVA HEALTHSCIENCE P LTD','918043532020','','JAYAMAHAL EXTENSION','BANGALORE','','11','560046','Document','0.00','0.00','0.00','0','Document','Surface','1','0.01','','','','','0.01','60.00','1','1','2025-11-03 15:49:01','2025-11-03 15:49:01','2147483647','2147483647','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('293','8','1','','2','3351484','2025-11-03','','4810','304','C M GRANITES','917899057126','','','SUNKADAKATTE','BAJPE','','11','574142','P B I CHRISTRUCTION COMPAY','919940737045','','BUNDEAR RD','BHATKAL','','11','581320','Document','0.00','0.00','0.00','0','Document','Surface','1','0.22','','','','','0.22','65.00','1','1','2025-11-03 15:50:05','2025-11-03 15:50:05','2147483647','2147483647','','1689','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('294','23','1','','2','3408506','2025-11-03','','4833','305','HASAN HAJEE & CO','918242420737','','','BUNDER','MANGALORE','','11','575001','SHRI SUROJIT KUMAR','917702886533','','MIRZA GHALIB STREET','SABERWAL HOUSE','','28','700016','Document','100.00','0.00','0.00','0','Document','Surface','1','0.35','','','','','0.35','170.00','1','1','2025-11-03 15:50:20','2025-11-03 15:50:20','2147483647','2147483647','M/S CARBON RESOURCES PVT LTD','2666','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('295','22','1','','2','3411034','2025-11-03','','4851','306','HARSHITH K','918105250301','','','KRISHNA KALA APTS','KAVOOR','','11','575015','RAJIV B H','919164935400','','PROFESSIONAL COURIER','BELTHANGADY','','11','574214','Document','0.10','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','50.00','1','1','2025-11-03 15:51:29','2025-11-03 15:51:29','2147483647','2147483647','','2580','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('296','26','1','','2','3400850','2025-11-03','','4847','301','SHAFEEQ','919611308572','','','TKT','MLR','','11','575017','PAVANI','919611308572','','MARATHI NAGAR','DODDABALLAPUR','','11','561203','CREAM','100.00','0.00','0.00','0','Document','Surface','1','0.24','','','','','0.24','85.00','1','1','2025-11-03 15:52:20','2025-11-03 15:52:20','2147483647','2147483647','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('297','12','1','','2','3382925','2025-11-03','','4853','307','K N PRINTERS','919900100818','','','YEYADI','MANGALORE','','11','575001','S K LAKSHIMINARAYANA','919845649491','','#2907 111RD MAIN ROAD','V V MOHALLA MYSORE','','11','570002','Document','10.00','0.00','0.00','0','Document','Surface','1','0.30','','','','','0.30','105.00','1','1','2025-11-03 15:53:27','2025-11-03 15:53:27','2147483647','2147483647','','669','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('298','8','1','','2','3351485','2025-11-03','','4810','308','CRYSTAL INDUSTRIES','917899057126','','','SUNKADAKATTE','BAJPE','','11','574142','PEARL PROPERTIES','919845085965','','BHUMIKA  TOWERS 3RD FLR','BENDOORWELL MANGALORE','','11','575002','Document','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','35.00','1','1','2025-11-03 15:54:17','2025-11-26 15:56:16','2147483647','2147483647','','3453','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('299','22','1','','2','3411035','2025-11-03','','4855','309','SAMARTH D','919663532120','','','MANGALORE','MANGALORE','','11','575001','PUNEETH L NAIK','918073948619','','BELA BANDAR','ANKOLA','','11','581314','Document','0.10','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-03 15:54:20','2025-11-03 15:54:20','2147483647','2147483647','','712','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('300','23','1','','2','3408507','2025-11-03','','4777','310','SUNDRESH','919731805276','','','RTO PANDESHWAR','MANGALORE','','11','575001','MR GUNDAPPA PRABHU','919845406060','','PRABHU AUTO CONSUL','SHRIBEEDU','','11','','Document','100.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-03 15:55:05','2025-11-26 16:01:53','2147483647','17617218175043','','1639','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('301','7','1','','2','3395006','2025-11-03','','4858','311','NARWHAL CHEMICAL','916384922529','','','BPY IND AREA','MANGALORE','','11','','RAJU C','919016368882','','SENAPATI BAPAT MARG','LOWER PAREL','','14','400013','Document','0.00','0.00','0.00','0','Document','Surface','1','0.01','','','','','0.01','100.00','1','1','2025-11-03 15:55:43','2025-11-03 15:55:43','2147483647','2147483647','','57','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('302','24','1','','2','3399451','2025-11-03','','4859','312','DR AGARWAL EYE HOSPITAL','918884008562','','','PUMPWELL','MANGALORE','','11','575002','DR AGARWAL EYE HOSPITAL RO','918884477929','','KORAMANGALA','BANGALORE','','11','560034','Document','0.00','0.00','0.00','0','Document','Surface','1','0.23','','','','','0.23','90.00','1','1','2025-11-03 15:56:49','2025-11-03 15:56:49','2147483647','2147483647','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('303','7','1','','2','3395007','2025-11-03','','4861','313','VIJAYA','919538727845','','','NARWHAL CHEMICALS','BPY IND AREA','','11','575011','PRANEETHA SHETTY','919900043112','','MASTHIKATTE ROAD','','','11','574227','Document','0.00','0.00','0.00','0','Document','Surface','1','0.01','','','','','0.01','50.00','1','1','2025-11-03 15:57:56','2025-11-03 15:57:56','2147483647','2147483647','','1068','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('304','23','1','','2','3408508','2025-11-03','','4769','314','JAYANTHIMALA','919916644540','','','PANDESHWARA','MANGALORE','','11','575001','PREETHA P','919847242387','','HDFC BANK LTD','UDMA BRANCH','','12','671318','Document','100.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','70.00','1','1','2025-11-03 16:00:25','2025-11-03 16:00:25','2147483647','2147483647','','1062','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('305','14','1','','2','3364664','2025-11-03','','4863','315','MONTEIRO TEXTILES','919844064435','','','SHARJA COMPLEX MILAGRESS CROSS RD','HAMPANAKTTA','','575001','','MEERA FABRICS','919845215492','','A M LANE CHICKPET CROSS','BANGALORE','','11','560053','Document','10.00','0.00','0.00','0','Document','Surface','1','0.09','','','','','0.09','75.00','1','1','2025-11-03 16:00:32','2025-11-03 16:00:32','2147483647','2147483647','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('306','20','1','','2','3418008','2025-11-03','','4865','316','PRAVEEN JAIN','918310998382','','','KURLON LTD ROSARIO CHURC ROAD','MANGALORE','','11','575001','VIKAS MOHAN GUPTHA','918800971001','','SHEELA FOAM LTD SLEEPWELL TOWER','#14 SEC 135 NOIDA','','26','201301','Document','0.00','0.00','0.00','0','Document','Surface','1','0.09','','','','','0.09','120.00','1','1','2025-11-03 16:01:11','2025-11-03 16:01:11','2147483647','2147483647','','226','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('307','6','1','','2','3381531','2025-11-03','','4867','317','SADASHIVA SHETTY','919845071336','','','SWATHI ENGINERG WORKS','INDUS ESATE  YEYADI','','11','575008','KSSIDC','919845071336','','SHIMOGGA','SHIMOGGA','','11','577401','Document','0.01','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-03 16:01:24','2025-11-03 16:01:24','2147483647','2147483647','SAGAR RD','1829','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('308','12','1','','2','3382926','2025-11-03','','4868','318','TDF DIAMOND','919972548543','','','FALNIR','MANGALORE','','11','575001','MR SHAMIL AHMED','919861105505','','CASADELTA NR KORAGAJJA KATTE','CHEMBUGUDDE','','11','575017','Document','0.00','0.00','0.00','0','Document','Surface','1','0.22','','','','','0.22','75.00','1','1','2025-11-03 16:02:57','2025-11-03 16:02:57','2147483647','2147483647','','3179','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('309','7','1','','2','3395008','2025-11-03','','4869','319','TGT','919880791839','','','MEENAKALIYA ROAD','BAIKAMPADY','','11','575011','BRIGHT FLEXI INT P LTD','919752216666','','INNA VILLAGE','UDUPI DIST','','11','576121','Document','0.00','0.00','0.00','0','Document','Surface','1','0.01','','','','','0.01','50.00','1','1','2025-11-03 16:03:07','2025-11-03 16:03:07','2147483647','2147483647','','2319','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('310','20','1','','2','3418009','2025-11-03','','4872','320','GURUPRASAD RAO','919845890852','','','SAHSIHITHLU','MANGALORE','','11','574146','PERFORM PEN COMPANY','919324993546','','#201 OLD SONAL IND ESTATE','KANCH PADA MALAD WEST','','14','400064','Document','10.00','0.00','0.00','0','Document','Surface','1','0.20','','','','','0.20','130.00','1','1','2025-11-03 16:04:51','2025-11-03 16:04:51','2147483647','2147483647','','57','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('311','6','1','','2','3381532','2025-11-03','','4873','321','VARUN V RAO','917483313237','','','BATRA KODI LANE','BONDEL MANGALORE','','11','575008','DIVYA S SHETTY','919535330669','','FLAT NO 9','AMBERNATH EAST','','14','','Document','0.01','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','100.00','1','1','2025-11-03 16:05:26','2025-11-03 16:05:26','2147483647','2147483647','LAXMI SALAR APT','848','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('312','7','1','','2','3395009','2025-11-03','','4869','322','TGT','919880791839','','','MEENAKALIYA ROAD  TN88B0275 KA01AE0594 KA01AD7948','BAIKAMPADY','','11','575011','BASKARRAJ LORRY BOOK OFFICE','919486157333','','NARIPPALAM','ERODE','','23','638102','Document','0.00','0.00','0.00','0','Document','Surface','1','0.01','','','','','0.01','70.00','1','1','2025-11-03 16:05:45','2025-11-03 16:05:45','2147483647','2147483647','','114','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('313','24','1','','2','3399452','2025-11-03','','4874','323','NISHANTH SHETTY (ASMT)','919900634030','','','PUMPWELL','MANGALORE','','11','575002','GOPI','919543331593','','AVN AYURVEDA FORMULATION PVT LTD','MUNIYANDIPURAM MADURAI','','23','625004','Document','10.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','80.00','1','1','2025-11-03 16:05:48','2025-11-03 16:05:48','2147483647','2147483647','','331','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('314','12','1','','2','3382927','2025-11-03','','4876','324','RUHIS BOUIQUE','918123133333','','','FALNIR','MANGALORE','','11','','YASMIN','918618906384','','IBRAHIM COMPOUND','SANTHEKATTE POST AMBAGILU UDUPI','','11','576105','Cloths','3700.00','0.00','0.00','0','Document','Surface','1','0.55','','','','','0.55','95.00','1','1','2025-11-03 16:07:38','2025-11-03 16:07:38','2147483647','2147483647','','1639','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('315','7','1','','2','3395010','2025-11-03','','4869','325','TGT','919880791839','','','MEENAKALIYA ROAD KA01AF2327 KA01AJ8692','BAIKAMPADY','','11','575011','NAMAKKAL ANJANEYA TPT','919597953327','','ETTAYAPURAM ROAD','TUTICORIN','','23','628002','Document','0.00','0.00','0.00','0','Document','Surface','1','0.01','','','','','0.01','70.00','1','1','2025-11-03 16:08:00','2025-11-03 16:08:00','2147483647','2147483647','','1635','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('316','20','1','','2','3418010','2025-11-03','','4879','326','KUDLA MEDICALS','919740558496','','','BALMATA NEW ROAD','MANGALORE','','11','575001','VINAYAK B NAIR','919972284080','','AGRA POST','KARWAR','','11','581308','Document','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-03 16:08:54','2025-11-03 16:08:54','2147483647','2147483647','','296','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('317','7','1','','2','3395011','2025-11-03','','4869','327','TGT','919880791839','','','MEENAKALIYA ROAD','BAIKAMPADY','','11','575011','THIRUMALA TRANSPORT','919443407968','','PENNADAM','','','23','606105','Document','0.00','0.00','0.00','0','Document','Surface','1','0.01','','','','','0.01','70.00','1','1','2025-11-03 16:10:56','2025-11-03 16:10:56','2147483647','2147483647','','11','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('318','8','1','','2','3351486','2025-11-03','','4882','328','SIMSON GUN HOUSE','919845406483','','','A AND A DLR','BAJPE','','11','574142','SEBASTIN VALES','919527014210','','FLAT NO BS4 PARKLANE BLDG','POVORIM BARDEZ GOA','','6','403521','Document','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','70.00','1','1','2025-11-03 16:10:56','2025-11-03 16:10:56','2147483647','2147483647','','628','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('319','14','1','','2','3364665','2025-11-03','','4863','329','MONTEIRO TEXTILES','919844064435','','','SHARJA COMPLEX MILAGRESS CROSS RD','HAMPANAKTTA','','11','575001','KOTHARI APPARELS','918088067673','','OPP ISHWAR TEMPLE','NEW FORT','','11','580020','Document','10.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-03 16:11:15','2025-11-03 16:11:15','2147483647','2147483647','','557','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('320','18','1','','2','3385031','2025-11-03','','4883','330','MR ASHWIN RAJ','917892596329','','','COMMERCE CENTER KULUR KAVOOR','PADUKOLI MANGALORE','','11','','MS SWATI REDDY, HR,','918217872910','','HINDUJA HOUSING FINANCE LTD','K H ROAD SHANTHI NAGAR BANGALOE','','11','560027','Document','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-03 16:12:22','2025-11-03 16:12:22','2147483647','2147483647','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('321','7','1','','2','3395012','2025-11-03','','4884','331','BHAT TRANSPORT','918884458965','','','BHAT WEIGH BRIDGE','BAIKAMPADY','','11','575011','SREE SELLIAMMAN TPT','919942590199','','PERUNDURAI VIA','ERODE','','23','638052','Document','0.00','0.00','0.00','0','Document','Surface','1','0.01','','','','','0.01','70.00','1','1','2025-11-03 16:12:49','2025-11-03 16:12:49','2147483647','2147483647','','114','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('322','6','1','','2','3381533','2025-11-03','','4887','332','BBEEKAY ENGINERG','919481757876','','','BEJAI MANGALORE','MANGALORE','','43','','MOBITECH WIRELESS SOLUTION P LTD','919943430000','','VENGAMEDU RD','TAMILNADU ERODE','','23','638052','Non Doc','11000.00','0.00','0.00','0','Document','Surface','1','1.25','','','','','1.25','208.00','1','1','2025-11-03 16:14:33','2025-11-03 16:14:33','2147483647','2147483647','PERUNDURAI','114','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('323','13','1','','2','3403994','2025-11-03','','4788','277','M BABA PAI','918242496499','','','CARSTREET','MANGALORE','','11','575001','HOTEL B M S','918494900306','','KUNTIKANA','DEREBAIL','','11','575006','Document','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','35.00','1','1','2025-11-03 16:14:40','2025-11-03 16:14:40','2147483647','2147483647','','3453','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('324','7','1','','2','3395013','2025-11-03','','4869','333','TGT','919880791839','','','MEENAKALIYA ROAD TN28BC6269 KA01AK7990','BAIKAMPADY','','11','575011','ARUL GANESH TPT','918870038596','','THURAIYUR ROAD','NAMAKKAL','','23','637002','Document','0.00','0.00','0.00','0','Document','Surface','1','0.01','','','','','0.01','70.00','1','1','2025-11-03 16:15:40','2025-11-03 16:15:40','2147483647','2147483647','','2424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('325','7','1','','2','3395014','2025-11-03','','4869','335','TGT','919880791839','','','MEENAKALIYA ROAD KA 01 AH 7474','BAIKAMPADY','','11','575011','BALAJI LORRY BODY LABOUR WORKS','919786652669','','THURAIYUR ROAD','GANGANAGAR','','23','637002','Document','0.00','0.00','0.00','0','Document','Surface','1','0.01','','','','','0.01','70.00','1','1','2025-11-03 16:17:28','2025-11-03 16:17:28','2147483647','2147483647','','2424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('326','22','1','','2','3411036','2025-11-03','','4891','336','PRATHEEK','917411446444','','','KADRI MANGALORE','MANGALORE','','23','','MORE RETAIL PVT LTD','917411446444','','12TH FLOOR WING E','TIMES SQUARE BLDG ANDHERI KURLA RD','','14','400059','Document','0.10','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','100.00','1','1','2025-11-03 16:18:10','2025-11-03 16:18:10','2147483647','2147483647','','57','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('327','17','1','','2','3404673','2025-11-03','','4893','337','PRAKASH ABM','919535055986','','','MANGALORE','MANGALORE','','11','575002','HEMANGI','912268406500','','G FLOOR SHA IND AREA','VEERA DESAI ROAD','','14','400053','Document','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','100.00','1','1','2025-11-03 16:18:58','2025-11-03 16:18:58','2147483647','2147483647','MS DEPT','57','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('328','7','1','','2','3395015','2025-11-03','','4895','110','SANTOSH S M','919008854847','','','KA16 C 8321','MANGALORE','','11','575011','SRI RAGHAVENDRA TPT','919442447776','','OUTER RING ROAD','HOSUR','','23','635109','Document','0.00','0.00','0.00','0','Document','Surface','1','0.01','','','','','0.01','70.00','1','1','2025-11-03 16:19:04','2025-11-03 16:21:47','2147483647','2147483647','','452','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('329','24','1','','2','3399453','2025-11-03','','4896','338','S.K GROUP MARKETING','919902402291','','','PUMPWELL','MANGALORE','','11','575002','GAYATHRI MANJUNATH','919663170328','','SRI KESHAVA KUNJ','KUNDAPURA','','11','576210','Document','0.00','0.00','0.00','0','Document','Surface','1','0.65','','','','','0.65','100.00','1','1','2025-11-03 16:19:08','2025-11-03 16:19:08','2147483647','2147483647','','3363','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('330','18','1','','2','3385032','2025-11-03','','4897','339','D IYYAPPAN','919976511437','','','MCF COMPLEX PANAMBUR','MANGALORE','','11','575010','MR CHETAN SHARMA','919450524406','','RESONANCE ENERGY PVT LTD','KANOLI NOIDA UTTAR PRADESH','','26','201301','Document','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','100.00','1','1','2025-11-03 16:19:38','2025-11-03 16:19:38','2147483647','2147483647','','226','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('331','8','1','','2','3351487','2025-11-03','','4882','340','SIMSON GUN HOUSE','919845406483','','','A AND A DLR','BAJPE','','11','574142','NISHANTH ARMS','919422271674','','A AND A DLR CHANDRABAGHA NAGAR','GANGAPUR RD NASHIK','','14','422013','Document','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','100.00','1','1','2025-11-03 16:19:50','2025-11-03 16:25:19','2147483647','2147483647','','475','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('332','13','1','','2','3403995','2025-11-03','','4788','277','M BABA PAI','918242496499','','','CARSTREET','MANGALORE','','11','575001','PRESTO FOOD CORP','918494900306','','JEPPU','MANGALORE','','11','575002','Document','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','35.00','1','1','2025-11-03 16:19:57','2025-11-03 16:19:57','2147483647','2147483647','','3453','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('333','25','1','','2','3388839','2025-11-03','','4899','341','T GIRISH SHETTY','919035852077','','','KUCHIGUDDE COMPLEX','SURATHKAL','','11','575014','DAYANAND SALIAN','918657488977','','APURVA SHANTHI NAGAR CO OP HSG','MIRA ROAD EAST MUMBAI','','14','401107','Document','100.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','100.00','1','1','2025-11-03 16:20:03','2025-11-03 16:20:03','2147483647','2147483647','','57','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('334','10','1','','2','3406714','2025-11-03','','4900','342','KUNTIKANA MEDICALS','919844374918','','','KUNTIKANA','MANGALORE','','11','575004','DR LALCHAND','918217618524','','ARINALLUR','PO KOLLAM','','12','690518','Document','100.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','70.00','1','1','2025-11-03 16:20:39','2025-11-03 16:20:39','2147483647','2147483647','LALGARDEN','1724','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('335','14','1','','2','3364666','2025-11-03','','4901','343','CROWN RUBBERSTAMP LTD','919964697480','','','SOUZA RACADE','BALMATA ROAD','','11','575001','AJANTHA PRESS','918217481390','','UPPINANGADY','UPPINANGADY','','43','574127','Document','10.00','0.00','0.00','0','Document','Surface','1','0.12','','','','','0.12','75.00','1','1','2025-11-03 16:20:45','2025-11-03 16:20:45','2147483647','2147483647','','2352','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('336','17','1','','2','3404674','2025-11-03','','4902','344','RAKESH P','918861216512','','','MANGALORE','','','11','','RAGHAVENDRA','919611673226','','PEENYA IND AREA','BANGALORE','','11','560068','Document','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-03 16:21:42','2025-11-03 16:21:42','2147483647','2147483647','ARISTO PHARMACUTICAL PVT LTD','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('337','24','1','','2','3399454','2025-11-03','','4896','345','S.K GROUP MARKETING','919902402291','','','PUMPWELL','MANGALORE','','11','575002','FAROOQ','917899452692','','RANUKARAGAR META ROAD','BALEHONNUR','','11','577112','Document','0.00','0.00','0.00','0','Document','Surface','1','0.35','','','','','0.35','105.00','1','1','2025-11-03 16:23:04','2025-11-03 16:23:04','2147483647','2147483647','','1422','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('338','20','1','','2','3418011','2025-11-03','','4905','346','PRASHANTH','919738287177','','','KODIALBAIL','','','11','575003','JAGADISH','919740565156','','VV MOHALLA','','','11','570002','Document','0.00','0.00','0.00','0','Document','Surface','1','0.33','','','','','0.33','105.00','1','1','2025-11-03 16:28:31','2025-11-03 16:28:31','2147483647','2147483647','','669','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('339','8','1','','2','3351488','2025-11-03','','4882','347','SIMSON GUN HOUSE','919845406483','','','A AND A DLR','BAJPE','','11','574142','JINDAL DEALRES','919845406483','','SYSTEMES PVT LTD','O P JINDAL MARG HISAR','','8','125005','Document','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','100.00','1','1','2025-11-03 16:28:44','2025-11-03 16:28:44','2147483647','2147483647','','6','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('340','24','1','','2','3399455','2025-11-03','','4906','348','SUDHIR ACHARYA','919513311773','','','PUMPWELL','MANGALORE','','11','575002','MR.SHREEHARI KEERTHIPATI','919513549200','','DISHA INFRA SERVICES PVT LTD','METRO STATION BANGALORE','','11','560086','Document','10.00','0.00','0.00','0','Document','Surface','1','0.09','','','','','0.09','75.00','1','1','2025-11-03 16:28:59','2025-11-03 16:28:59','2147483647','2147483647','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('341','7','1','','2','3395016','2025-11-03','','4869','349','TGT','919880791839','','','MEENAKALIYA ROAD KA 01 AE 1049','BAIKAMPADY','','11','575011','SHUBARANJANI TRANSPORT','919994028644','','BAVANI MAIN ROAD','PERUNDURAI','','23','638052','Document','0.00','0.00','0.00','0','Document','Surface','1','0.01','','','','','0.01','70.00','1','1','2025-11-03 16:29:12','2025-11-03 16:29:12','2147483647','2147483647','','2462','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('342','14','1','','4','41935986','2025-11-03','3703','3706','350','BANK OF BARODA HAMPANKATTA, VBZO','','','','2nd FLOOR, VIJAYA TOWER, L.H.H.ROAD, MANGALORE. 3, BANK OF BARODA, NITESH LEXINGTON AVENUE, BRIGADE ROAD, BENGALURU-560025','','29AAACB1534F3Z0','11','575001','BOB','918494900063','','ZO','M G RD','','11','560001','Document','0.00','0.00','0.00','0','Document','Surface','1','1.30','','','','','1.30','56.00','1','1','2025-11-03 16:29:19','2025-12-13 16:56:18','2147483647','2147483647','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','1','0','','','','','','1','');
INSERT INTO `booking` VALUES ('343','26','1','','2','3400851','2025-11-03','','4911','351','MANJU A P','919900994514','','','TKT','MLR','','11','','BHARATH FIN INCLUSION','919900994514','','JAYALAXMIPURAM','J L PURAM','','11','570012','Document','10.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-03 16:30:48','2025-11-03 16:30:48','2147483647','2147483647','','669','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('344','21','1','','2','3393094','2025-11-03','','4912','352','KARUNAKARA','919964191075','','','MANGALORE URBAN DEV, URWA','STORE, MANGALORE','','11','575006','VISHWANATH SUVARNA','919986709042','','BOLAS AGRO RPIVATE LTD','NEHRU GURIJI VAKKALERA','','11','585104','Document','100.00','0.00','0.00','0','Document','Surface','1','0.15','','','','','0.15','85.00','1','1','2025-11-03 16:30:50','2025-11-03 16:30:50','2147483647','2147483647','','445','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('345','13','1','','2','3403996','2025-11-03','','4788','277','M BABA PAI','918242496499','','','CARSTREET','MANGALORE','','11','575001','INLAND BUILDES','918494900306','','NAVABHARATH CIRCLE','BAIKAMPADY','','43','575011','Document','0.00','0.00','0.00','0','Document','Surface','1','0.05','','','','','0.05','35.00','1','1','2025-11-03 16:31:50','2025-11-03 16:31:50','2147483647','2147483647','','3453','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('346','10','1','','2','3406715','2025-11-03','','4915','353','VASANTH POOJARY','919448600313','','','PREMIER RESIDENCY','BEJAI KAPIKAD','','11','575004','ASHOK GOVEKAR','918861733550','','HAL 2ND STAGE','INDIRA NAGAR','','11','560008','Document','100.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-03 16:32:06','2025-11-03 16:32:06','2147483647','2147483647','GRATELLI WINES P  LTD','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('347','7','1','','2','3395017','2025-11-03','','4869','354','TGT','919880791839','','','MEENAKALIYA ROAD KA 01 AK 0488','BAIKAMPADY','','11','575011','R DHANAPANI','919095099250','','DALMIPURAM','TRICHY','','23','621651','Document','0.00','0.00','0.00','0','Document','Surface','1','0.01','','','','','0.01','70.00','1','1','2025-11-03 16:32:28','2025-11-03 16:32:28','2147483647','2147483647','','1631','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('348','20','1','','2','3418012','2025-11-03','','4916','355','MURALI','919591975444','','','MANGALORE','','','11','575001','ORANGE AUTO CARE','919591975421','','2ND FLOOR 690/U 15TH MAIN 12TH CROSS','J P NAGAR 2ND PHASE','','11','560078','Document','0.00','0.00','0.00','0','Document','Surface','1','0.18','','','','','0.18','85.00','1','1','2025-11-03 16:32:33','2025-11-03 16:34:36','2147483647','2147483647','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('349','24','1','','2','3399456','2025-11-03','','4948','385','RAJCHAND SHETTY','918904021867','','','PUMPWELL','MANGALORE','','11','575002','MANJUNATH Y','918317362226','','NICHAVANA HALLI','HARAPANAHALLI VIJAYA NAGAR','','11','560086','Parcel','10.00','0.00','0.00','0','Document','Surface','1','1.00','','','','','1.00','155.00','1','1','2025-11-03 16:32:36','2025-11-03 16:50:54','2147483647','2147483647','','946','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('350','8','1','','2','3351489','2025-11-03','','4918','356','SUSHAN','919535434794','','','PAKSHIKERE','KEMRAL','','11','574146','SARWESH SHUKLA','919791843193','','MODRIK  LIFE STYLE PVT LTD','RING RD','','11','560037','Document','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-03 16:32:39','2025-11-03 16:32:39','2147483647','2147483647','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('351','14','1','','4','41935987','2025-11-03','3703','3706','350','BANK OF BARODA HAMPANKATTA, VBZO','','','','2nd FLOOR, VIJAYA TOWER, L.H.H.ROAD, MANGALORE. 3, BANK OF BARODA, NITESH LEXINGTON AVENUE, BRIGADE ROAD, BENGALURU-560025','','29AAACB1534F3Z0','11','575001','BOB','918494900063','','.','BANNANJE','','11','576101','Document','0.00','0.00','0.00','0','Document','Surface','1','0.01','','','','','0.01','18.00','1','1','2025-11-03 16:33:53','2025-12-13 16:56:18','2147483647','2147483647','','1639','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','1','0','','','','','','1','');
INSERT INTO `booking` VALUES ('352','12','1','','2','3382928','2025-11-03','','4920','357','S FATHIMA','917019835173','','','MILAGRES LADIES HOSTEL','VASLINE KANKANADY','','11','575002','FR SUDHARSAN','918148000704','','ST JOSEPHS MATRICULATION SCHOOL','OUR LADY OF DOLOROUS CHUCH KODANAGAR','','23','604407','Cloths','3100.00','0.00','0.00','0','Document','Surface','1','2.11','','','','','2.11','400.00','1','1','2025-11-03 16:34:06','2025-11-03 16:34:06','2147483647','2147483647','','213','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('353','7','1','','2','3395018','2025-11-03','','4869','358','TGT','919880791839','','','MEENAKALIYA ROAD KA 01 AF 6211','BAIKAMPADY','','11','575011','SREE SELLIAMMAN TPT','919842291232','','PERUNDURAI VIA','ERODE','','23','638052','Document','0.00','5.00','0.00','0','Document','Surface','1','0.01','','','','','0.01','70.00','1','1','2025-11-03 16:34:14','2025-11-14 13:21:08','2147483647','17617199828916','','114','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('354','14','1','','2','3364667','2025-11-03','','4921','359','SEQUIRA & CO','917204026113','','','NOELLA BLDG L H H RD','MANGALORE','','11','575001','RETAIL SOLUTION & TECHNOLOGIES','919481380614','','NO 30 GROUND FLOOR 4 TH LANE 3 RD CROSS','LALBAGH RD','','11','560027','Electronic Items','1000.00','0.00','0.00','0','Document','Surface','1','0.27','','','','','0.27','105.00','1','1','2025-11-03 16:34:32','2025-11-03 16:34:32','2147483647','2147483647','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('355','7','1','','2','3395019','2025-11-03','','4869','360','TGT','919880791839','','','MEENAKALIYA ROAD TN88J9606 KA01AK3355','BAIKAMPADY','','11','575011','NAVAJEEVAN LORRY BOOK OFFICE','919843245614','','PULIPANCHAN','TUTICORIN','','23','638002','Document','0.00','0.00','0.00','0','Document','Surface','1','0.01','','','','','0.01','70.00','1','1','2025-11-03 16:35:44','2025-11-03 16:35:44','2147483647','2147483647','','1635','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('356','6','1','','2','3381534','2025-11-03','','4924','361','VERMA ROADWAYS','917317009453','','','BUNDER','MANGALORE','','43','','VERMA ROADWAYS','917317009485','','DASANAPURA','HUBLI TUMKUR RD','','11','','Document','0.01','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-03 16:35:50','2025-11-03 16:35:50','2147483647','2147483647','MADAVARA VILLEG','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('357','10','1','','2','3406716','2025-11-03','','4926','362','DR ARADHANA','917259496373','','','AJDENTAL COLLEGE','MANGALORE','','11','575004','SUHAS','918867955442','','BTM 2ND STAGE','OPP BALAJI RESIDENCY','','11','560076','Non Doc','0.00','0.00','0.00','0','Document','Surface','1','0.70','','','','','0.70','125.00','1','1','2025-11-03 16:36:36','2025-11-03 16:36:36','2147483647','2147483647','INFANT VICTORY','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('358','14','1','','4','41935988','2025-11-03','3703','3706','350','BANK OF BARODA HAMPANKATTA, VBZO','','','','2nd FLOOR, VIJAYA TOWER, L.H.H.ROAD, MANGALORE. 3, BANK OF BARODA, NITESH LEXINGTON AVENUE, BRIGADE ROAD, BENGALURU-560025','','29AAACB1534F3Z0','11','575001','BOB','918494900063','','.','.','','11','581110','Document','0.00','0.00','0.00','0','Document','Surface','1','0.01','','','','','0.01','18.00','1','1','2025-11-03 16:37:16','2025-12-13 16:56:18','2147483647','2147483647','','314','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','1','0','','','','','','1','');
INSERT INTO `booking` VALUES ('359','17','1','','2','3404675','2025-11-03','','4928','363','SEMA A','918073499749','','','BEJAI','MANGALORE','','11','575004','BLOSSOM OFFICE','918105074108','','BASJTTIKOPPALU','','','11','573201','Document','0.00','0.00','0.00','0','Document','Surface','1','0.07','','','','','0.07','75.00','1','1','2025-11-03 16:37:47','2025-11-03 16:39:33','2147483647','2147483647','BEHIND GANDADKATE','448','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('360','6','1','','2','3381535','2025-11-03','','4924','364','VERMA ROADWAYS','917317009453','','','BUNDER','MANGALORE','','43','','VERMA ROADWAYS','917311104649','','KANPUR','KANPUR','','14','','Document','0.01','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','100.00','1','1','2025-11-03 16:38:04','2025-11-03 16:38:04','2147483647','2147483647','T P NAGAR','458','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('361','13','1','','2','3403997','2025-11-03','','4788','277','M BABA PAI','918242496499','','','CARSTREET','MANGALORE','','11','575001','ULLAL VITTAPPA KRISHNA NAYAK','918494900306','','KODIALBAIL','MANGALORE','','11','575003','Document','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','35.00','1','1','2025-11-03 16:38:36','2025-11-03 16:38:36','2147483647','2147483647','','3453','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('362','7','1','','2','3395020','2025-11-03','','4869','365','TGT','919880791839','','','MEENAKALIYA ROAD KA 01 AF 5756','BAIKAMPADY','','11','575011','ANUGRAHA TRANSPORT','919842983529','','UTHANGARAI TALUK','KRISHNAGIRI','','23','638008','Document','0.00','0.00','0.00','0','Document','Surface','1','0.01','','','','','0.01','70.00','1','1','2025-11-03 16:38:38','2025-11-03 16:38:38','2147483647','2147483647','','461','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('363','20','1','','2','3418013','2025-11-03','','4930','366','H KESHAVA TANTRY','919342173373','','','MANGALORE','','','11','575001','MURALIDHAR KODANGAL','919448393832','','KODANGAL AGENCIES','RAVIVARPWT','','11','591307','Document','0.00','0.00','0.00','0','Document','Surface','1','1.10','','','','','1.10','201.00','1','1','2025-11-03 16:38:42','2025-11-03 16:38:42','2147483647','2147483647','','33','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('364','26','1','','2','3400852','2025-11-03','','4932','367','SUPER GOLD N DAIMOND','919743373748','','','KALLAPU','TKT','','11','575017','SHAHEEN','918589939889','','SWA DAIMONDS','EDARIKODE','','12','676501','COUPON','0.00','0.00','0.00','0','Document','Surface','1','2.40','','','','','2.40','448.00','1','1','2025-11-03 16:38:44','2025-11-03 16:38:44','2147483647','2147483647','','284','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('365','8','1','','2','3351490','2025-11-03','','4882','368','SIMSON GUN HOUSE','919845406483','','','A AND A DLR','BAJPE','','11','574142','CHANDRASHEKARAN KUPPASWAMY','919943710343','','DEVARAMALI THOTTAM','SEMMADAIPATTI  PALAKKONTHUT','','23','624619','Document','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','70.00','1','1','2025-11-03 16:38:45','2025-11-03 16:38:45','2147483647','2147483647','','310','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('366','7','1','','2','3395021','2025-11-03','','4869','369','TGT','919880791839','','','MEENAKALIYA ROAD KA 01 AJ 3389','BAIKAMPADY','','11','575011','KARTHI TRANSPORT','917708451888','','GOVINDAPURAM','ARIYALUR','','23','621713','Document','0.00','0.00','0.00','0','Document','Surface','1','0.01','','','','','0.01','70.00','1','1','2025-11-03 16:40:32','2025-11-03 16:40:32','2147483647','2147483647','','1721','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('367','10','1','','2','3406717','2025-11-03','','4933','370','SWATHI PHARMA','919341914964','','','BEJAI','MANGALORE','','11','575004','DR K KRISHNA BHAT','919880120415','','KUKKUNDOOR','KARKALA','','11','574104','Non Doc','0.00','0.00','0.00','0','Document','Surface','1','0.20','','','','','0.20','80.00','1','1','2025-11-03 16:40:33','2025-11-03 16:40:33','2147483647','2147483647','SAVITHA CLINIC','75','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('368','24','1','','2','3399457','2025-11-03','','4935','371','V.N D COAST','919141005000','','','SKY BOOKS','NAGURI MANGALORE','','11','575002','AMRITA VIDYALAYAM','918312443153','','MANDOLI ROAD NR BHAVANI NAGAR','BELGAUM','','11','590006','Books','1000.00','0.00','0.00','0','Parcel','Surface','1','5.60','','','','','5.60','660.00','1','1','2025-11-03 16:41:18','2025-11-03 16:41:18','2147483647','2147483647','','4','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('369','14','1','','2','3364668','2025-11-03','','4936','350','SHRADHA SHETTY','919620222410','','','MAXIMUS COMMERCIAL COMPLEX','OPP KMC','','11','575001','FUNDZ BAZAR','918494900063','','PRUDENT HOUSE PANJRA POLE CROSS RD','NEAR POLY TECHNIC AMBAVADI','','7','380015','Document','10.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','100.00','1','1','2025-11-03 16:41:49','2025-11-03 16:41:49','2147483647','2147483647','','381','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('370','7','1','','2','3395022','2025-11-03','','4869','372','TGT','919880791839','','','MEENAKALIYA ROAD  KA 01 AK 0486','BAIKAMPADY','','11','575011','RAAJALINGAM TPT','919442191909','','DALMIPURAM','TRICHY','','23','621651','Document','0.00','0.00','0.00','0','Document','Surface','1','0.01','','','','','0.01','70.00','1','1','2025-11-03 16:42:11','2025-11-03 16:42:11','2147483647','2147483647','','1631','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('371','13','1','','2','3403998','2025-11-03','','4788','277','M BABA PAI','918242496499','','','CARSTREET','MANGALORE','','11','575001','LAMINA FOUNDRIES LTD','918494900306','','INDU AREA','BAIKAMPADY','','43','575011','Document','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','35.00','1','1','2025-11-03 16:42:11','2025-11-03 16:42:11','2147483647','2147483647','','3453','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('372','14','1','','4','41935989','2025-11-03','3703','3706','350','BANK OF BARODA HAMPANKATTA, VBZO','','','','2nd FLOOR, VIJAYA TOWER, L.H.H.ROAD, MANGALORE. 3, BANK OF BARODA, NITESH LEXINGTON AVENUE, BRIGADE ROAD, BENGALURU-560025','','29AAACB1534F3Z0','11','575001','BOB','918494900063','','P B RD','','','11','581110','Document','0.00','0.00','0.00','0','Document','Surface','1','0.01','','','','','0.01','18.00','1','1','2025-11-03 16:42:50','2025-12-18 11:30:55','2147483647','2147483647','','314','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','1','1','2025-12-18 11:30:55','','received','','','1','17645841409774');
INSERT INTO `booking` VALUES ('373','7','1','','2','3395023','2025-11-03','','4869','373','TGT','919880791839','','','MEENAKALIYA ROAD TN 28 AJ 8611','BAIKAMPADY','','11','575011','C D TRANSPORTS','919715816556','','SIVANATHAPURAM','CUDDALORE','','23','607003','Document','0.00','0.00','0.00','0','Document','Surface','1','0.01','','','','','0.01','70.00','1','1','2025-11-03 16:43:53','2025-11-03 16:43:53','2147483647','2147483647','','326','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('374','26','1','','2','3400853','2025-11-03','','4938','374','MINNA AROMA','918722374019','','','TKT','TKT','','11','','KIRAN NAIK','919503947837','','NR TVS SHOWROOM','HNR','','11','','Document','1000.00','0.00','0.00','0','Document','Surface','1','0.39','','','','','0.39','105.00','1','1','2025-11-03 16:44:07','2025-11-03 16:44:07','2147483647','2147483647','','191','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('375','25','1','','2','3388840','2025-11-03','','4939','375','NITK NESCAFE','918088875195','','','NR BOYS HOSTEL','SURATHKAL','','11','575014','LAKSHMISHA M','919845323143','','NR SRI CHENNAKESHAVA TEMPLE','CARSTREET SULLIA','','11','574327','Document','100.00','0.00','0.00','0','Document','Surface','1','0.06','','','','','0.06','65.00','1','1','2025-11-03 16:44:24','2025-11-03 16:44:24','2147483647','2147483647','','2577','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('376','10','1','','2','3406718','2025-11-03','','4940','376','MALLIKARJUNA SWAMY M M','919741209830','','','MANGALORE','','','11','575004','GLADSTONE PHARMA INDIA PVT LTD','918939274808','','NATESH NAGAR','2ND CROSS, VIRUGAMBAKKAM','','23','600092','Document','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','70.00','1','1','2025-11-03 16:44:41','2025-11-03 16:44:41','2147483647','2147483647','PLOT NO 274/ 4, PEARL FLATS','1931','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('377','24','1','','2','3399458','2025-11-03','','4935','377','V.N D COAST','919141005000','','','SKY BOOKS','NAGURI MANGALORE','','11','575002','AMRITA VIDYALAYAM','918382266598','','AMRITA NAGAR SADASHIVAGAD','KARWAR','','11','581352','Books','1000.00','0.00','0.00','0','Parcel','Surface','1','5.52','','','','','5.52','660.00','1','1','2025-11-03 16:44:46','2025-11-03 16:44:46','2147483647','2147483647','','296','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('378','13','1','','2','3403999','2025-11-03','','4788','277','M BABA PAI','918242496499','','','CARSTREET','MANGALORE','','11','575001','LAMINA SUSPENSION PRODUCTS LTD','918494900306','','INDU AREA','BAIKAMPADY','','43','575011','Document','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','35.00','1','1','2025-11-03 16:45:02','2025-11-03 16:45:02','2147483647','2147483647','','3453','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('379','21','1','','2','3393095','2025-11-03','','4942','378','RAGESH K','919448305730','','','NO. 503, PROXIMUS','ASHOKNAGAR','','11','575006','MOHANAKANNAN PK','919544599888','','FLAT NO. 2018D, FEDERAAL CITY','KARAYAMPARAMBU, KARUKUTTY','','12','683575','Document','50.00','0.00','0.00','0','Document','Surface','1','0.04','','','','','0.04','70.00','1','1','2025-11-03 16:45:47','2025-11-03 16:45:47','2147483647','2147483647','','517','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('380','7','1','','2','3395024','2025-11-03','','4869','379','TGT','919880791839','','','MEENAKALIYA ROAD KA01AN1567 KA01AL5657 KA01AH2957','BAIKAMPADY','','11','575011','RAAJALINGAM TPT','919442182909','','REDDIPALAYAM','ARIYALUR','','23','621704','Document','0.00','0.00','0.00','0','Document','Surface','1','0.01','','','','','0.01','70.00','1','1','2025-11-03 16:45:49','2025-11-03 16:45:49','2147483647','2147483647','','1721','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('381','20','1','','2','3418014','2025-11-03','','4944','380','ALDRIN VAZ','919448189030','','','MANGALORE','','','11','575001','DINESH SHETTIGAR','919731705033','','ABHARAN JEWELLERS','BH O C B ROAD','','11','576101','Document','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-03 16:46:56','2025-11-26 16:01:53','2147483647','2147483647','','1639','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('382','7','1','','2','3395025','2025-11-03','','4869','381','TGT','919880791839','','','MEENAKALIYA ROAD KA01AK5569 KA01AN7119','BAIKAMPADY','','11','575011','SRI VINAYAKA R L','919976595484','','IOC BANK','NAMAKKAL','','23','637003','Document','0.00','0.00','0.00','0','Document','Surface','1','0.01','','','','','0.01','70.00','1','1','2025-11-03 16:47:15','2025-11-03 16:47:15','2147483647','2147483647','','2424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('383','14','1','','4','41935990','2025-11-03','3703','3706','382','BANK OF BARODA HAMPANKATTA, VBZO','','','','2nd FLOOR, VIJAYA TOWER, L.H.H.ROAD, MANGALORE. 3, BANK OF BARODA, NITESH LEXINGTON AVENUE, BRIGADE ROAD, BENGALURU-560025','','29AAACB1534F3Z0','11','575001','BOB','918242442901','','VIDYANAGAR','GANDHI CIRCLE','','11','577005','Document','0.00','0.00','0.00','0','Document','Surface','1','0.01','','','','','0.01','18.00','1','1','2025-11-03 16:49:35','2025-12-13 16:56:18','2147483647','2147483647','','1123','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','1','0','','','','','','1','');
INSERT INTO `booking` VALUES ('384','20','1','','2','3418015','2025-11-03','','4946','383','UNITY MEDICALS','919141271892','','','KODIALBAIL','','','11','575001','SYAM KUMAR','919947028944','','ASSOCIATE BUILDING','SREEKANDAPURAM','','12','670631','Document','0.00','0.00','0.00','0','Document','Surface','1','0.17','','','','','0.17','95.00','1','1','2025-11-03 16:50:05','2025-11-03 16:50:05','2147483647','2147483647','','276','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('385','6','1','','2','3381536','2025-11-03','','4947','384','P ATHIMOOLAM','918667664538','','','SHEDIGURI','ASHOK NAGAR','','43','','AVINASH','917259797977','','3RD STAGE  2ND BLOCK','BASAVESHWARA NAGAR','','11','','Document','0.01','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-03 16:50:28','2025-11-03 16:50:28','2147483647','2147483647','P P AUTO GAS','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('386','14','1','','2','3364669','2025-11-03','','4949','386','YAJNESH','919845518791','','','SHIVADURGA','MULLAKADU KAVOR MANGALORE','','11','575015','AMRUTHA','917204347842','','SHANVITHA NILAYAM 2 ND MAIN RD','DOMINIC LAYOUT K R PURAM','','11','560049','Document','10.00','0.00','0.00','0','Document','Surface','1','0.19','','','','','0.19','85.00','1','1','2025-11-03 16:51:04','2025-11-03 16:51:04','2147483647','2147483647','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('387','20','1','','2','3418016','2025-11-03','','4951','387','GANESH K','919986549007','','','KODIALBAIL MANGALORE','','','11','575001','ACCREDO PHARMA SCIENCE PVT LTD','918675340295','','2ND STREET J BLOCK','ANNANAGAR NEAR ARCHANA IVF','','23','600102','Document','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','70.00','1','1','2025-11-03 16:52:16','2025-11-03 16:52:16','2147483647','2147483647','','1931','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('388','17','1','','2','3404676','2025-11-03','','4952','388','M H F','918747841778','','','BENDOOR ROAD','MANGALORE','','11','575002','SURENDRA','919443341954','','RACE COURSE ROAD','COIMBATORE','','23','','Document','0.00','5.00','0.00','0','Document','Surface','1','0.08','','','','','0.08','85.00','1','1','2025-11-03 16:52:19','2025-11-15 13:42:28','2147483647','17617216042295','','535','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('389','13','1','','2','3404000','2025-11-03','','4788','277','M BABA PAI','918242496499','','','CARSTREET','MANGALORE','','11','575001','LAMINA INTERNATIONAL','918494900306','','KODAILBAIL','BAIKAMPADY','','43','575011','Document','10.00','0.00','0.00','0','Document','Surface','1','0.05','','','','','0.05','35.00','1','1','2025-11-03 16:52:48','2025-11-03 16:52:48','2147483647','2147483647','','3453','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('390','24','1','','2','3399459','2025-11-03','','4953','389','SHARUN SHETTY','917892600350','','','PUMPWELL','MANGALORE','','11','575002','CENTAUR PHARMACEUTICALS PVT LTD','919900325875','','NEW TIMBER YARD LAYOUR','MYSORE RD BANGALORE','','560026','','Document','10.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-03 16:53:42','2025-11-03 16:53:42','2147483647','2147483647','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('391','14','1','','2','3364670','2025-11-03','','4936','350','SHRADHA SHETTY','919620222410','','','MAXIMUS COMMERCIAL COMPLEX','OPP KMC','','11','575001','FUNDZ BAZAR BROKING','918494900063','','PRUDENT HOUSE PANJRA POLE CROSS RD','NEAR POLYTECHNIC AMBAWADI','','7','380015','Document','10.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','100.00','1','1','2025-11-03 16:54:57','2025-11-03 16:54:57','2147483647','2147483647','','3','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('392','14','1','','4','41935991','2025-11-03','3703','3706','390','BANK OF BARODA HAMPANKATTA, VBZO','','','','2nd FLOOR, VIJAYA TOWER, L.H.H.ROAD, MANGALORE. 3, BANK OF BARODA, NITESH LEXINGTON AVENUE, BRIGADE ROAD, BENGALURU-560025','','29AAACB1534F3Z0','11','575001','BOB','918242413901','','.',',','','11','577201','Document','0.00','0.00','0.00','0','Document','Surface','1','0.01','','','','','0.01','18.00','1','1','2025-11-03 16:55:27','2025-12-13 16:56:18','2147483647','2147483647','S R RASTHE','1829','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','1','0','','','','','','1','');
INSERT INTO `booking` VALUES ('393','20','1','','2','3418017','2025-11-03','','4955','391','SOWBHAGYA H N','919449082364','','','BESENT PU CLG','KODIALBAIL MANGALORE','','11','575003','SUPRIYA','919620959850','','BELLEZA BEAUTY SALOON','#20, R K JAYAM COMPLEX JAYANAGAR','','11','560069','Document','0.00','0.00','0.00','0','Document','Surface','1','0.25','','','','','0.25','85.00','1','1','2025-11-03 16:55:41','2025-11-03 16:55:41','2147483647','2147483647','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('394','8','1','','4','41616337','2025-11-03','4496','4864','392','MANGALORE SEZ LIMITED  AD290725004221E','919148935703','','','Plot No U-1, Sy.No 168/3A, Administrative Building,, Mangalore Special Economic Zone, Bajpe Village 574142','BAJPE','29AAECM8545K1ZV','11','574142','KIRTHI GUPTA','918494900302','','S B I 5TH FLR PARAMOUNT CAPITAL CENTER','GOLI MARKET DELHI','','32','110001','Document','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','69.00','1','1','2025-11-03 16:56:06','2025-12-13 16:56:18','2147483647','2147483647','','1995','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','1','0','','','','','','1','');
INSERT INTO `booking` VALUES ('395','13','1','','2','3404001','2025-11-03','','4788','277','M BABA PAI','918242496499','','','CARSTREET','MANGALORE','','11','575001','MANMET ENGG','918494900306','','INDUSTRIAL AREA','BAIKAMPADY','','43','575011','Document','10.00','0.00','0.00','0','Document','Surface','1','0.05','','','','','0.05','35.00','1','1','2025-11-03 16:57:09','2025-11-03 16:57:09','2147483647','2147483647','','3453','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('396','10','1','','2','3406719','2025-11-03','','4958','393','SKECHERS','919742035411','','','OPP BATA SHOW ROOM','BEJAI MAIN ROAD','','11','575004','KINJAL GOLWALA','919925867888','','UK HOUSE VESU CHAR RASTA','UDHANA','','7','395007','Document','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','100.00','1','1','2025-11-03 16:59:21','2025-11-03 16:59:21','2147483647','2147483647','','163','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('397','6','1','','4','41876018','2025-11-03','3514','3517','394','TAPASYA ENTERPRISES','917349490857','','','1ST FLOOR, DOOR NO. 6-1-3, URWA MARKET ROAD,  Ladyhill,Mangaluru, 575006','','29BFJPA5560C1ZO','11','575006','PRERANA FANCY','916360394764','','OPP KRISHNA HOTEL','BC RD','','11','574231','Non Doc','500.00','0.00','0.00','0','Document','Surface','1','0.09','','','','','0.02','17.00','1','1','2025-11-03 17:00:40','2025-12-13 16:56:18','2147483647','2147483647','RAJESHWARI COMPLEX','1006','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','1','0','','','','','','1','');
INSERT INTO `booking` VALUES ('398','13','1','','2','3404002','2025-11-03','','4788','395','M BABA PAI','918242496499','','','CARSTREET','MANGALORE','','11','575001','POONIA TENT MKT','919353973330','','HOGEIE BAZAR','','','11','575001','Document','10.00','0.00','0.00','0','Document','Surface','1','0.05','','','','','0.05','35.00','1','1','2025-11-03 17:01:02','2025-11-03 17:01:02','2147483647','2147483647','','3453','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('399','25','1','','2','3388841','2025-11-03','','4962','396','STEDHAN CRASTA','918281231423','','','SURATHKAL','SURATHKAL','','11','575014','LAWRENCE D SOUZA','919611799737','','DASANDAGOLI','KALLAMUNDKURU MOODBIDRI','','11','574227','Document','1700.00','0.00','0.00','0','Document','Surface','1','0.20','','','','','0.20','75.00','1','1','2025-11-03 17:01:40','2025-11-03 17:01:40','2147483647','2147483647','','1068','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('400','26','1','','2','3400854','2025-11-03','','4963','397','DR ABHIJITH SHETTY','919916807688','','','ULLAL','MLR','','11','575022','DR A RAMAMOHAN','919442010501','','DHALI RD','ELAMAYUTHUR','','23','','Document','10.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','70.00','1','1','2025-11-03 17:02:02','2025-11-03 17:02:02','2147483647','2147483647','','1638','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('401','7','1','','2','3395026','2025-11-03','','4965','381','JAI SRIRAM TPT','918073842232','','','BAIKAMPADY','MANGALORE','','11','575011','SRI VINAYAKA R L','919976595484','','IOC BANK','NAMAKKAL','','23','637003','Document','0.00','0.00','0.00','0','Document','Surface','1','0.01','','','','','0.01','70.00','1','1','2025-11-03 17:02:31','2025-11-03 17:02:31','2147483647','2147483647','','2424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('402','8','1','','4','41616338','2025-11-03','399','408','392','INDIAN OVERSEAS BANK BAJPE','918242252515','','','III FLOOR, 10/1, Lakshmi Narayana Complex, Palace Road,Vasanth Nagar, Bangalore, 560052','BAJPE','29AAACI1223J2ZR','11','574142','PARAMESHWARA KARANTH','918494900302','','V601 MARS AND VENUS APT','ASHOK NAGAR MANGALORE','','11','575006','Document','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','30.00','1','1','2025-11-03 17:02:56','2025-12-18 18:46:28','2147483647','2147483647','','3453','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','1','1','2025-12-18 18:46:28','','received','','','1','17645844402769');
INSERT INTO `booking` VALUES ('403','24','1','','2','3399460','2025-11-03','','4966','398','THILAK RAJ','917411390555','','','HINDUJA','MANGALORE','','11','575002','IBRAHIM','919632014353','','PANNAJE HOUSE','KANYANA VITTAL','','11','574279','Document','10.00','0.00','0.00','0','Document','Surface','1','0.16','','','','','0.16','75.00','1','1','2025-11-03 17:03:07','2025-11-03 17:03:07','2147483647','2147483647','','730','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('404','21','1','','4','41892570','2025-11-03','4029','4020','399','JOHNSON LIFTS PVT LTD','917358395771','','','4-152/12 JOS BROTHERS COMPOUND ASHOKNAGAR POST DEREBAIL VILLAGE KOTTARA CHOWKI MANGALORE','','29AAACJ0838Q1Z2','11','','JOHNSON LIFTS PRIVATE LIMITED','919025966011','','PLOT NO. 31A 6 & 7','SIDCO INDL ESTATE, AMBATTUR','','23','600098','Document','1000.00','0.00','0.00','0','Parcel','Surface','1','9.44','','','','','9.44','590.00','1','1','2025-11-03 17:03:24','2025-12-13 16:56:19','2147483647','17617234618473','','1931','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','1','0','','','','','','1','');
INSERT INTO `booking` VALUES ('405','20','1','','2','3418018','2025-11-03','','4967','400','HRISH','919611305636','','','SOMESHWAR','KOTEKAR MANGALORE','','11','575001','SVS HOME SERVICE','918088986580','','K N EXTN','YASHWANTHPURA','','11','560022','Document','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-03 17:03:29','2025-11-03 17:03:29','2147483647','2147483647','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('406','10','1','','2','3406720','2025-11-03','','4968','401','SKECHERS','917411775411','','','OPP BATA SHOW ROOM','','','11','575004','SKECHERS','919164133062','','S N MARKET','AMEER AHMED CIRCLE','','11','577201','Parcel','0.00','0.00','0.00','0','Document','Surface','1','0.96','','','','','0.96','155.00','1','1','2025-11-03 17:04:07','2025-11-03 17:04:07','2147483647','2147483647','BEARYS CITY CENTRE','1829','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('407','17','1','','2','3404677','2025-11-03','','4969','402','RENNI DSOUZA','918242439895','','','LOWER BENDOOR','MANGALORE','','11','575002','204773200','911204773200','','FOINACIAL MANGEMENT SERVICE FOUNDATION','SECTOR 26','','26','201301','Document','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','100.00','1','1','2025-11-03 17:04:31','2025-11-03 17:04:31','2147483647','2147483647','ALEX MATHEW A','226','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('408','13','1','','2','3404003','2025-11-03','','4788','277','M BABA PAI','918242496499','','','CARSTREET','MANGALORE','','11','575001','BRANCH MANAGER','918494900306','','CAMPCO','APMC YARD','','43','575011','Document','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','35.00','1','1','2025-11-03 17:06:39','2025-11-03 17:06:39','2147483647','2147483647','','3453','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('409','8','1','','4','41616339','2025-11-03','390','399','403','CARDOLITE SPECIALTY CHEMICALS INDIA  LLP(ARN)AD290725004221E','','','','PLOT NO IP-1 & IP-2, MANGALORE SPECIAL ECONOMIC ZONE (MSEZ) PAILA, BAJPE VILLAGE & POST, MANGALORE-574142','','29AAJFC3620M2Z7','11','','BANSAL TRADING CO','919871291331','','NDM 1 NETAJI SUBHAS PLACE','PITAMPURA  DELHI','','32','110034','Document','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','67.00','1','1','2025-11-03 17:07:03','2025-12-13 16:58:20','2147483647','17617178859109','','541','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','1','0','','','','','','1','');
INSERT INTO `booking` VALUES ('410','21','1','','4','41892571','2025-11-03','3999','3990','404','COGNATE INDUSTRIAL AUTOMATION','918792023988','','','1-N-5-402/1-4, AUTO WORLD TOWERS, KOTTARA CHOWKI, MANGALORE,575006','','29AANFC4476H1ZZ','11','','VETRIRANTHAN','919994960686','','HIMALAYA TABLE TENNIS ACCADEMY','THUVARAIKALAM','','23','625531','Document','100.00','0.00','0.00','0','Parcel','Surface','1','10.66','','','','','10.66','267.00','1','1','2025-11-03 17:07:58','2025-12-13 16:58:20','2147483647','17617234618473','','3453','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','1','0','','','','','','1','');
INSERT INTO `booking` VALUES ('411','22','1','','2','3411037','2025-11-03','','4970','406','RAMESH KOTE','919448723363','','','SURVEYOR LOSS ASSECCOR AND VALUER','KADRI RICKS KADRI KAMBLA','','11','575004','S CHINNUSAMY','919842121113','','NATIONAL ASSOCIATES','PARAMATHI RD NAMAKKAL','','23','637001','Document','0.10','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','70.00','1','1','2025-11-03 17:09:08','2025-11-03 17:09:08','2147483647','2147483647','','2424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('412','20','1','','2','3418019','2025-11-03','','4971','407','RAJANI R BHAT','919632690123','','','BEJAI MANGALORE','','','11','575004','GAYATHRI SALI','919980712227','','#212 T ZED HOMES BOREWELL ROAD','RAMAGONDANAHALLI','','11','560066','Document','1200.00','0.00','0.00','0','Document','Surface','1','0.25','','','','','0.25','85.00','1','1','2025-11-03 17:09:25','2025-11-03 17:09:25','2147483647','2147483647','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('413','14','1','','4','41935992','2025-11-03','3703','3706','390','BANK OF BARODA HAMPANKATTA, VBZO','','','','2nd FLOOR, VIJAYA TOWER, L.H.H.ROAD, MANGALORE. 3, BANK OF BARODA, NITESH LEXINGTON AVENUE, BRIGADE ROAD, BENGALURU-560025','','29AAACB1534F3Z0','11','','BOB','918242413901','','BOB','MG RD','','11','577201','Document','0.01','0.00','0.00','0','Document','Surface','1','0.01','','','','','0.01','18.00','1','1','2025-11-03 17:10:00','2025-12-15 17:15:18','2147483647','17617234618473','','296','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','1','0','','','','','','1','');
INSERT INTO `booking` VALUES ('414','25','1','','2','3388842','2025-11-03','','4972','408','LATHA K AMIN','919892406254','','','SURATHKAL','MANGLORE','','11','575014','DEVADAS V SHETTIGAR','919743287990','','OPP. COURT COMPLEX','COURT ROAD UDUPI','','11','576101','Document','100.00','0.00','0.00','0','Document','Surface','1','0.20','','','','','0.20','90.00','1','1','2025-11-03 17:10:29','2025-11-26 16:01:53','2147483647','2147483647','','1639','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('415','24','1','','2','3399461','2025-11-03','','4973','409','MAROOR MOTORS','919945206277','','','PUMPWELL','MANGALORE','','11','575002','MAROOR MOTORS','919591402343','','NR GENERAL HOSPITAL B/H VIKRAM HOSPITAL','MANDYA','','11','575002','Parcel','0.00','0.00','0.00','0','Parcel','Surface','1','1.39','','','','','1.39','247.00','1','1','2025-11-03 17:10:29','2025-11-03 17:10:29','2147483647','2147483647','','403','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('416','13','1','','2','3404004','2025-11-03','','4974','277','DREAM CRAFT','919900921451','','','VAMANASHRAM BUILDING','','','11','575001','VICTOR MENEZES','918494900306','','MRPL','KUTHETHOOR','','43','575011','Document','0.00','0.00','0.00','0','Document','Surface','1','0.05','','','','','0.05','50.00','1','1','2025-11-03 17:10:54','2025-11-26 15:56:16','2147483647','2147483647','','3453','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('417','22','1','','2','3411038','2025-11-03','','4970','410','RAMESH KOTE','919448723363','','','SURVEYOR LOSS ASSECCOR AND VALUER','KADRI RICKS KADRI KAMBLA','','11','575004','UNITED INDIA INS','918242475332','','SHREE VITTAL NH 66','SURATHKAL','','11','575014','Document','0.10','0.00','0.00','0','Document','Surface','1','0.15','','','','','0.15','75.00','1','1','2025-11-03 17:11:11','2025-11-03 17:11:11','2147483647','2147483647','','3211','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('419','21','1','','4','41892572','2025-11-03','4071','4059','412','PING PONG SPORTS','','','','GROUND FLOOR, 1-17/40, HOSAMANE, KULOOR CROSS ROAD,BANGRA KULOOR, Mangaluru, 575013','','29COGPM6973J1Z5','11','575006','SRIKAR','918884687690','','VISWANDEEDAM','','','11','560091','Document','100.00','0.00','0.00','0','Document','Surface','1','0.79','','','','','0.79','40.00','1','1','2025-11-03 17:11:50','2025-12-13 16:58:20','2147483647','2147483647','MARAGALA','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','1','0','','','','','','1','');
INSERT INTO `booking` VALUES ('420','8','1','','4','41616340','2025-11-03','391','400','413','CATASYNTH SPECIALITY CHEMICALS PVT LTD','919480600583','','','SEZ MANGALORE','BAJPE','29AAGCC3431L1ZI','11','574142','SIMI PILLAI','917045587328','','ANTHEA AROMATICS PVT LTD','RABLE MIDC NAVI MUMBAI','','14','400701','Document','0.00','0.00','0.00','0','Document','Surface','1','0.97','','','','','0.97','190.00','1','1','2025-11-03 17:12:05','2025-12-22 13:24:07','2147483647','2147483647','','57','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','1','0','','','','','','1','');
INSERT INTO `booking` VALUES ('421','20','1','','2','3418020','2025-11-03','','4975','414','GURU','917349430494','','','MULKI','','','11','575001','RAVI CHANDRAN','919113698601','','VENKATA LAKE VIEW','BBMP PARK YALAHANKA','','11','560064','Document','0.00','0.00','0.00','0','Document','Surface','1','0.23','','','','','0.23','85.00','1','1','2025-11-03 17:12:56','2025-11-03 17:12:56','17616544937223','17616544937223','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('422','13','1','','2','3404005','2025-11-03','','4814','277','MEDHA','918494900306','','','BHAVANTHI STREET','MANGALORE','','43','575001','CANARA BANK','918494900306','','KEDINJE','KARKALA','','43','575011','Document','10.00','0.00','0.00','0','Document','Surface','1','0.05','','','','','0.05','50.00','1','1','2025-11-03 17:13:04','2025-11-03 17:13:04','17617147018423','17617147018423','','75','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('423','18','1','','2','3385033','2025-11-03','','4976','415','K.V SURESH','919448296997','','','KIOCL','MANGALORE','','11','575010','K PRASANNA RANI','919492284177','','VASANTHAPRTA INDIANIVAS','PRODDTUR ANDHRA PRADESH','','1','516360','Document','0.00','0.00','0.00','0','Document','Surface','1','0.51','','','','','0.51','140.00','1','1','2025-11-03 17:13:39','2025-11-03 17:13:39','17621531273939','17621531273939','','487','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('425','10','1','','2','3406721','2025-11-03','','4977','417','SOMANATH MANGASULU','917353754058','','','HUBLI','','','11','580020','VISHWANATHACHARI','919019613186','','SANTHOSHAPURAM','NEAR WATER TANK SIGNAL','','11','560034','Document','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-03 17:13:54','2025-11-03 17:13:54','17617151801089','17617151801089','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('426','7','1','','2','3395027','2025-11-03','','4978','418','SUDARSHAN','919686223841','','','KA53C5859','MANGALORE','','11','575011','SRI MOOKAMBIKA LORRY SERVICE','919900162127','','MADAVARA DASANAPURA HOBLI','','','11','562123','Document','0.00','0.00','0.00','0','Document','Surface','1','0.01','','','','','0.01','60.00','1','1','2025-11-03 17:14:46','2025-11-03 17:14:46','17617199828916','17617199828916','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('427','21','1','','2','3393096','2025-11-03','','4979','419','KRISHNA J','918139945556','','','7TH CROSS BEJAI KAPIKAD','BEJAI POST','','11','575006','MANI','918150094693','','HORIZON PACKAGING PVT LTD','HAROHALLI INDL ARE','','11','562112','Document','50.00','0.00','0.00','0','Document','Surface','1','0.13','','','','','0.13','85.00','1','1','2025-11-03 17:14:51','2025-11-03 17:14:51','17617214622025','17617214622025','','1131','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('428','17','1','','2','3404678','2025-11-03','','4980','420','S C S HOSPITAL PVT LTD','918242881100','','','UPPER BENDOOR','MANGALORE','','11','','MEDI ASSIST INDIA PVT LTD','918242881100','','HOSUR MAIN ROAD','','','11','560068','Document','0.01','5.00','0.00','0','Document','Surface','1','0.40','','','','','0.40','105.00','1','1','2025-11-03 17:15:16','2025-11-15 13:46:28','17617216585187','17617216042295','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('429','8','1','','2','3351491','2025-11-03','','4981','421','TRIDENT INFRAS','919844994582','','','ROSE HOUSE BALMATTA','MANGALORE','','11','575001','AKB ASSOCIATES','919972599246','','ADVOCATE AND CONS','CUNNIGHAM RD','','11','560052','Document','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-03 17:15:23','2025-11-03 17:15:23','17617178859109','17617178859109','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('430','13','1','','2','3404006','2025-11-03','','4982','422','HEMANTH PAI','919606647027','','','KUDI CO','','','11','575001','MALLIKARJUN ARMOATICS','918382265542','','SADASHIVANAGAR','','','11','560002','Document','0.00','0.00','0.00','0','Document','Surface','1','0.26','','','','','0.26','110.00','1','1','2025-11-03 17:15:29','2025-11-03 17:15:29','17617147018423','17617147018423','','296','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('431','20','1','','2','3418021','2025-11-03','','4983','423','ANNAYA KOTE','918105433469','','','SHEDIGURI','MANGALORE','','11','575001','ZEESHAN F','918310781675','','VRUDHI HOME APPLIANCES','BANASHANKARI','','11','560085','Document','0.00','0.00','0.00','0','Document','Surface','1','0.12','','','','','0.12','85.00','1','1','2025-11-03 17:15:54','2025-11-03 17:15:54','17616544937223','17616544937223','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('432','12','1','','2','3382929','2025-11-03','','4984','424','GEETHA','919242888807','','','PANDESHWARA','MANGALORE','','11','575001','MS PRUTHVI','919480038814','','TATA AIG GENERAL INSURENCE CO LTD','ESSEL TOWER BUNTS HOSTEL  HAMPANKATTA','','11','575003','Document','100.00','0.00','0.00','0','Document','Surface','1','4.10','','','','','4.10','511.00','1','1','2025-11-03 17:16:04','2025-11-03 17:16:04','17617206505387','17617206505387','','3453','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('434','24','1','','2','3399462','2025-11-03','','4985','426','MAK PLYWOOD IND PVT LTD','918296966727','','','PUMPWELL','MANGALORE','','11','575002','JESS .MADAM','918147687727','','MAK PLYWOOD IND PVT LTD','RICHMOND TOWN BANGALORE','','11','560025','Document','10.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-03 17:17:53','2025-11-04 13:10:59','17617227102844','17617227102844','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('436','23','1','','2','3408509','2025-11-03','','4986','427','PAI SALES','918242420652','','','PANDESHWARA','MANGALORE','','11','575001','KUMAR BATTERIES','919844187108','','CHIKKALLASANDRA','SUBRAMANYAPURA POST','','11','560051','Document','700.00','0.00','0.00','0','Document','Surface','1','3.45','','','','','3.45','615.00','1','1','2025-11-03 17:18:04','2025-11-03 17:48:08','17617218175043','17617218175043','STUDIO ROAD','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('437','10','1','','2','3406722','2025-11-03','','4987','428','SUPER ELECTRODES','914994241896','','','PO MAIPADY','KASARAGOD','','12','671124','VENUGOPALAN K','917012010056','','OLD PRESS CLUB JUNCTION','KASRAGOD','','12','671121','Document','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','70.00','1','1','2025-11-03 17:18:42','2025-11-03 17:18:42','17617151801089','17617151801089','DARUSALAM BLDG','1062','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('438','22','1','','2','3411039','2025-11-03','','4988','429','S MITHUN BHANDARY','919845552433','','','301 3RD FLOOR N J LOTUS AVENUE','KADRI MALLIKATTE RD','','11','575003','MANJUNATH T N','919620192964','','NO 276 G FLOOR 14TH A MAIN','8TH B CROSS VIJAYANAGAR','','11','560040','Document','0.10','0.00','0.00','0','Document','Surface','1','0.29','','','','','0.29','105.00','1','1','2025-11-03 17:18:50','2025-11-03 17:18:50','17617169725275','17617169725275','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('440','18','1','','2','3385034','2025-11-03','','4989','431','DR ARUN SHETTY','917829993388','','','BHAGATH SINGH NAGAR','PANJIMOGARU MANGALORE','','11','','MR PRASHANTH.B','919141410664','','ADVOCATE & NOTARY','NEAR TALUK OFFICE KARKALA','','11','574104','Document','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','50.00','1','1','2025-11-03 17:19:08','2025-11-03 17:19:08','17621531273939','17621531273939','','75','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('441','21','1','','4','41892573','2025-11-03','4071','4059','432','PING PONG SPORTS','','','','GROUND FLOOR, 1-17/40, HOSAMANE, KULOOR CROSS ROAD,BANGRA KULOOR, Mangaluru, 575013','','29COGPM6973J1Z5','11','575006','SANGAM BAILOOR','919844053526','','CURRIAPPA','','','11','590009','Document','100.00','0.00','0.00','0','Document','Surface','1','1.56','','','','','1.56','80.00','1','1','2025-11-03 17:20:05','2025-12-13 16:58:20','17617214622025','17617214622025','','4','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','1','0','','','','','','1','');
INSERT INTO `booking` VALUES ('442','22','1','','2','3411040','2025-11-03','','4988','433','S MITHUN BHANDARY','919845552433','','','301 3RD FLOOR N J LOTUS AVENUE','KADRI MALLIKATTE RD','','11','575003','AMIT','919035181068','','GURUKRIPA ASSOCIATES','108 NEELIGIN RD HULBI','','11','580029','Document','0.10','0.00','0.00','0','Document','Surface','1','0.20','','','','','0.20','85.00','1','1','2025-11-03 17:20:47','2025-11-03 17:20:47','17617169725275','17617169725275','','557','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('443','10','1','','2','3406723','2025-11-03','','4990','436','DHANWANGRI PHARMA','919448045714','','','BEJAI KAPIKAD','MANGALORE','','11','575004','SRI VENKATESHWARA MEDICALS','919844734309','','MYOSRE','','','11','570018','Document','0.00','0.00','0.00','0','Document','Surface','1','0.10','','','','','0.10','75.00','1','1','2025-11-03 17:22:01','2025-11-03 17:22:01','17617151801089','17617151801089','HOOTAGALLI','669','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('445','14','1','','4','41935993','2025-11-03','3703','3706','438','BANK OF BARODA HAMPANKATTA, VBZO','','','','2nd FLOOR, VIJAYA TOWER, L.H.H.ROAD, MANGALORE. 3, BANK OF BARODA, NITESH LEXINGTON AVENUE, BRIGADE ROAD, BENGALURU-560025','','29AAACB1534F3Z0','11','575001','BOB','910000000000','','.','','','11','575001','Document','0.00','0.00','0.00','0','Document','Surface','1','0.01','','','','','0.01','15.00','1','1','2025-11-03 17:22:06','2025-12-13 16:58:20','17617208675119','17617208675119','MAIN','3453','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','1','0','','','','','','1','');
INSERT INTO `booking` VALUES ('446','8','1','','2','3351492','2025-11-03','','4991','439','SHIVAJI K L','917204806328','','','S D P T','KATEEL','','11','574148','MANMOHAN RAI','919019888591','','TEJAS RESI MARUTHI LAYOUT','COFFEE BOARD LAYOUT','','11','560024','Document','0.00','0.00','0.00','0','Document','Surface','1','0.62','','','','','0.62','125.00','1','1','2025-11-03 17:22:17','2025-11-03 17:22:17','17617178859109','17617178859109','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('447','22','1','','2','3411041','2025-11-03','','4988','440','S MITHUN BHANDARY','919845552433','','','301 3RD FLOOR N J LOTUS AVENUE','KADRI MALLIKATTE RD','','11','575003','AMITH S','919986678994','','19TH CROSS AZRAVINDA NAGAR','MYSORE','','11','570023','Document','0.10','0.00','0.00','0','Document','Surface','1','0.71','','','','','0.71','125.00','1','1','2025-11-03 17:22:24','2025-11-03 17:22:24','17617169725275','17617169725275','','669','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('448','25','1','','2','3388843','2025-11-03','','4992','441','D C VIRUPAKSH','919110220873','','','NITK','SURATHKAL','','11','575025','SRI LAHIK AHMED','919481150786','','SRI KEREDOMMA TEMPLE ROAD','JYOTHI NAGAR CHIKMANGLORE','','11','577102','Document','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-03 17:22:30','2025-11-03 17:22:30','17617202587270','17617202587270','','0','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('450','13','1','','2','3404007','2025-11-03','','4993','442','MAHALAXMI THRED HOUSE','919448711322','','','KUNIL CENTRE','','','11','575001','PARMAR FABARICS','919869529006','','OLD HANUMAN LANE','1ST CROSS LANE','','14','400002','Document','10.00','0.00','0.00','0','Document','Surface','1','0.05','','','','','0.05','100.00','1','1','2025-11-03 17:23:32','2025-11-03 17:23:32','17617147018423','17617147018423','','1018','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('451','21','1','','4','41892574','2025-11-03','4042','4033','443','M.P BROTHERS,CARGO','918861997620','','','URVA STORES MANGALORE-575006','','29AAAFM2647M1ZY','11','575006','GOAN FRESH MARINE EXPORTS PVT LTD','919972908087','','UDP','','','11','576213','Document','100.00','0.00','0.00','0','Document','Surface','1','7.90','','','','','7.90','680.00','1','1','2025-11-03 17:24:00','2025-12-13 16:58:20','17617214622025','17617214622025','BAIKADY','1470','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','1','0','','','','','','1','');
INSERT INTO `booking` VALUES ('452','22','1','','2','3411042','2025-11-03','','4988','444','S MITHUN BHANDARY','919845552433','','','301 3RD FLOOR N J LOTUS AVENUE','KADRI MALLIKATTE RD','','11','575003','SURAJ J R','919663604577','','SHIKRIPA 4TH CROSS','THILAK NAGAR SHIMOGA','','11','577201','Document','0.10','0.00','0.00','0','Document','Surface','1','0.17','','','','','0.17','85.00','1','1','2025-11-03 17:24:27','2025-11-03 17:24:27','17617169725275','17617169725275','','1829','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('453','18','1','','2','3385035','2025-11-03','','4994','445','IDEAL DIESELS','919880339459','','','NEAR KULUR CHURCH','KULUR MANGALORE','','11','575013','NISHMITHA MOTORS','919845158755','','OPP BUS STAND','MOODABIDRI','','11','574227','Document','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','50.00','1','1','2025-11-03 17:24:37','2025-11-03 17:24:37','17621531273939','17621531273939','','1068','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('454','24','1','','2','3399463','2025-11-03','','4995','446','ATELIER','919448397777','','','FR.MULLER ROAD','VALENCIA MANGALORE','','11','','ARTIRE INNOVTIONS','919582592972','','NATIONAL MARKET PEERAGARTHI DELHI','','','32','110087','Document','0.00','0.00','0.00','0','Document','Surface','1','1.53','','','','','1.53','530.00','1','1','2025-11-03 17:24:51','2025-11-03 17:24:51','17617227102844','17617227102844','','541','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('455','7','1','','2','3395028','2025-11-03','','4996','447','RYAN SCHOOL','918123159579','','','KULAI','MANGALORE','','11','575011','DENIS SEQUEIRA','919867239319','','HONEST TRANSPORT SER','AIROLI','','14','400708','Document','0.00','0.00','0.00','0','Document','Surface','1','0.01','','','','','0.01','100.00','1','1','2025-11-03 17:25:07','2025-11-03 17:25:07','17617199828916','17617199828916','','57','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('456','8','1','','2','3351493','2025-11-03','','4997','448','PURUSHOTHAM','916361861397','','','S D P T','KATEEL','','11','574148','SANATH KUMAR SHETTY','919448143251','','PRIYADARSHINI APT INDIRANAGAR','2ND STAGE  BANGALORE','','11','560038','Document','0.00','0.00','0.00','0','Document','Surface','1','0.38','','','','','0.38','105.00','1','1','2025-11-03 17:25:21','2025-11-03 17:25:21','17617178859109','17617178859109','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('457','14','1','','4','41935994','2025-11-03','3805','3807','438','S.C.D.C.C.BANK LTD. HEAD OFFICE','','','','PB NO 721, SADASHIVA SAHAKARI SADANA,KODIALBAIL, MANGALORE-575003','','29AABAT6621N2ZZ','11','','1 PC SCDCC','910000000000','','.','.','','11','575001','Parcel','0.00','0.00','0.00','0','Parcel','Surface','1','15.30','','','','','15.30','302.40','1','1','2025-11-03 17:26:08','2025-12-19 11:05:36','17617208675119','17617234618473','','3370','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','1','');
INSERT INTO `booking` VALUES ('458','17','1','','4','41848283','2025-11-03','3877','3876','450','FOUR WINDS ADVERTISING AND PUBLICITY','','','','VOILET COMPLEX BALMATTA, MANGALORE-575002','','29AAJPF6001F1Z2','11','575002','PRASAHNTH HEGDE','918242204300','','UNIVERSITY ENCLAVE','','','11','220430','Document','0.01','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','35.00','1','1','2025-11-03 17:26:57','2025-12-13 16:58:20','17617216042295','17617216042295','NITTE UNIVERSITY','3171','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','1','0','','','','','','1','');
INSERT INTO `booking` VALUES ('459','13','1','','2','3404008','2025-11-03','','4998','451','KUMAR APPARELS','919480736064','','','T T ROAD','','','11','575001','RANGE FOREST OFFICER','919480736064','','KUDREMUKH WILDLIFE RANGE','KUDREMUKH JAMBLE','','11','577124','Document','10.00','0.00','0.00','0','Document','Surface','1','0.05','','','','','0.05','60.00','1','1','2025-11-03 17:27:05','2025-11-03 17:27:05','17617147018423','17617147018423','','186','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('460','21','1','','4','41892575','2025-11-03','4081','4068','452','S.B.I KOTTARA','919480841719','','','KOTTARA CHOWKI MANGALORE 65, State Bank of India, Local Head Office, St. Marks Road, Bengaluru-560001','','29AAACS8577K3ZJ','11','575006','LIC OF INDIA','918494900188','','POPULAR BUILDING','HAMPANKATTA','','11','575001','Document','50.00','0.00','0.00','0','Document','Surface','1','0.05','','','','','0.05','9.00','1','1','2025-11-03 17:27:08','2025-12-13 16:58:20','17617214622025','17617214622025','','3453','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','1','0','','','','','','1','');
INSERT INTO `booking` VALUES ('462','14','1','','2','3364671','2025-11-03','','4999','455','RAMESH R','919886948138','','','ESSEL TOWER 2 ND FLOOR','BUNTS HOSTEL CIRCLE MANGALORE','','11','575003','MITHUN','917975494989','','GROUND FLOOR LALITHA KRIPA','B M RD HASSAN','','11','573201','Document','0.01','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-03 17:27:20','2025-11-03 17:27:20','17617209872567','17617209872567','','448','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('463','22','1','','2','3411043','2025-11-03','','5000','458','SHIMNITH INDIA PVT LTD','918495068417','','','MANGALORE','MANGALORE','','11','575003','PAI CARES','919900494153','','PAI CARES LAILA','BELTHANGADY','','11','574214','Document','0.10','0.00','0.00','0','Document','Surface','1','0.50','','','','','0.50','85.00','1','1','2025-11-03 17:29:54','2025-11-03 17:29:54','17617169725275','17617169725275','','2580','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('464','14','1','','4','41935995','2025-11-03','3805','3807','438','S.C.D.C.C.BANK LTD. HEAD OFFICE','','','','PB NO 721, SADASHIVA SAHAKARI SADANA,KODIALBAIL, MANGALORE-575003','','29AABAT6621N2ZZ','11','','1 PC SCDCC','910000000000','','.',',','','11','574240','Parcel','0.00','0.00','0.00','0','Parcel','Surface','1','10.20','','','','','10.20','231.00','1','1','2025-11-03 17:30:01','2025-12-19 11:05:36','17617208675119','17617234618473','','3440','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','1','2025-12-17 13:44:14','','received','','','1','17645841409774');
INSERT INTO `booking` VALUES ('465','6','1','','2','3381537','2025-11-03','','5001','459','NISHANTH','919845085660','','','MANGALORE','MANGALORE','','11','575003','SMITHA HANDE','919321845415','','CAR TRADE EXCHANGE SOLUTION','SPRIT CO WORK PALCE','','14','400070','Document','0.01','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','100.00','1','1','2025-11-03 17:30:17','2025-11-03 17:43:00','17617213813089','17617213813089','','57','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('466','13','1','','2','3404009','2025-11-03','','5002','460','VISHWAS TEXTILES','919448727026','','','MARKET ROAD','','','11','575001','SHREE MAJEESA AGENCY','919898148777','','5013 5TH FLOOR JASH MARKET','RING ROAD','','7','395002','Document','10.00','0.00','0.00','0','Document','Surface','1','0.05','','','','','0.05','100.00','1','1','2025-11-03 17:31:01','2025-11-03 17:31:01','17617147018423','17617147018423','','163','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('468','10','1','','2','3406724','2025-11-03','','5003','463','GEETHA GIRISH','919513438409','','','BEJAI','MANGALORE','','11','','PRAVEEN ACHARYA','918610199577','','KAIRANGALA POST & VILLAGE','BANTWALA','','11','574193','Document','100.00','0.00','0.00','0','Document','Surface','1','1.65','','','','','1.65','210.00','1','1','2025-11-03 17:32:03','2025-11-03 17:32:03','17617151801089','17617151801089','MONTUGOLI HOUSE','1006','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('469','22','1','','2','3411044','2025-11-03','','5004','464','SHIMNIT INDIA PVT LTD','916362238497','','','MALLIKATTE','MANGALORE','','11','575003','SAI RADHA MOTORS','918202525579','','BHAKTI TOWER','VIDYASAMUDRA THIRTHA RD KALSANKA','','11','576101','Document','0.50','0.00','0.00','0','Document','Surface','1','5.60','','','','','5.60','660.00','1','1','2025-11-03 17:32:15','2025-12-17 11:33:14','17617169725275','17617169725275','','1639','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','1','2025-12-17 11:33:14','','received','','','0','17617258284475');
INSERT INTO `booking` VALUES ('470','24','1','','2','3399464','2025-11-03','','5005','465','SURESHA P.S','918448293695','','','KODEKKAL','PADIL MANGALORE','','11','575007','MR.VISHAL SHERIVASTAV','919599057607','','COLOPLANT INDIA PVT LTD','SECTOR 126 NOIDA','','26','201304','Document','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','100.00','1','1','2025-11-03 17:32:33','2025-11-03 17:32:33','17617227102844','17617227102844','','226','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('471','14','1','','4','41935996','2025-11-03','3703','3706','438','BANK OF BARODA HAMPANKATTA, VBZO','','','','2nd FLOOR, VIJAYA TOWER, L.H.H.ROAD, MANGALORE. 3, BANK OF BARODA, NITESH LEXINGTON AVENUE, BRIGADE ROAD, BENGALURU-560025','','29AAACB1534F3Z0','11','575001','BOB','910000000000','','.MAIN','','','11','585101','Document','0.00','0.00','0.00','0','Document','Surface','1','0.01','','','','','0.01','18.00','1','1','2025-11-03 17:33:29','2025-12-13 16:58:20','17617208675119','17617208675119','','1195','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','1','0','','','','','','1','');
INSERT INTO `booking` VALUES ('472','21','1','','2','3393097','2025-11-03','','5006','466','SSRC','919130000310','','','MLR','','','11','575006','SSRC LOGISTICS PVT LTD','919742121211','','ADAKAMARANAHALLI','','','11','562123','Document','0.00','0.00','0.00','0','Document','Surface','1','0.83','','','','','0.83','155.00','1','1','2025-11-03 17:33:39','2025-11-03 17:33:39','17617214622025','17617214622025','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('473','21','1','','4','41892576','2025-11-03','4063','4052','467','NIRAN MOTORS PVT LTD','918147983968','','','1-16/9 PANVEL COCHIN HIGHWAY BANGERAKULOOR MANGALRE','','29AAGCN2668A1ZH','11','575006','SRINIVASAN','919611030094','','ARVAVINDHAM NILAYA','BASWADI\'','OMBER LAYOUT','11','560043','Document','50.00','0.00','0.00','0','Document','Surface','1','50.00','','','','','50.00','6415.00','1','1','2025-11-03 17:34:10','2025-12-13 16:58:20','17617214622025','17617214622025','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','1','0','','','','','','1','');
INSERT INTO `booking` VALUES ('474','23','1','','2','3408510','2025-11-03','','5007','468','sirjam munir agency','919448384483','','','bunder','mangalore','','575001','','the campco ltd','918384236096','','apmc','new market yard','','11','581402','Document','100.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-03 17:34:18','2025-11-03 17:34:18','17617218175043','17617218175043','','289','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('476','18','1','','4','41918122','2025-11-03','515','524','470','MERIDIAN  FREIGHT FORWARDEBRS PVT LTD','917090313444','','','3RD FLOOR, 00, COMMERCE CENTER, NR. ARVIND MOTORS, KULURU KAVOOR ROAD, MANGALORE, Dakshina Kannada, Karnataka, 575013','','29AADCM7648C1ZB','11','575013','SHODHAN','918310354721','','F3 MARINE FOODS WORLDWIDE','GUJJARBETTU UDUPI','','11','576115','Document','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','37.00','1','1','2025-11-03 17:34:19','2025-12-13 16:58:20','17617176063340','17617176063340','','1639','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','1','0','','','','','','1','');
INSERT INTO `booking` VALUES ('477','6','1','','4','41876019','2025-11-03','3514','3517','471','TAPASYA ENTERPRISES','917349490857','','','1ST FLOOR, DOOR NO. 6-1-3, URWA MARKET ROAD,  Ladyhill,Mangaluru, 575006','','29BFJPA5560C1ZO','11','575006','SANTHOSH FANCY & GIFT CENTRE','919113266874','','NEAR BUS STAND','B C ROAD','','11','574211','COSMETICS','-0.01','0.00','0.00','0','Document','Surface','1','0.19','','','','','0.19','17.00','1','1','2025-11-03 17:36:06','2025-12-13 16:58:20','17617213393393','17617213393393','SHRINIVAS ARCADE','1006','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','1','0','','','','','','1','');
INSERT INTO `booking` VALUES ('478','13','1','','2','3404010','2025-11-03','','5008','472','CONSOLIDATED CONSTRUCTION','918971363646','','','MUKKA','SURATHAKAL','','11','575001','CONSOLIDATED CONSTRUCTION','917013707833','','J P NAGAR','DOLLARS COLONY','','11','560078','Document','100.00','0.00','0.00','0','Document','Surface','1','0.29','','','','','0.29','110.00','1','1','2025-11-03 17:36:21','2025-11-03 17:36:21','17617147018423','17617147018423','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('479','7','1','','2','3395029','2025-11-03','','5009','473','AROMAZEN P LTD','919141058355','','','BAIKAMPADY IND AREA','MANGALORE','','11','575011','JELL PHARMACEUTICALS P LTD','919987574347','','TTC IND AREA','MIDC RABALE','','14','400701','Document','0.00','0.00','0.00','0','Document','Surface','1','0.57','','','','','0.57','230.00','1','1','2025-11-03 17:36:52','2025-11-03 17:36:52','17617199828916','17617199828916','','57','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('480','10','1','','2','3406725','2025-11-03','','5010','474','9980989135','919980989135','','','PRAKASH','VISHWAS SAGAR APTS','','11','560004','UMA SHARMA','919980989135','','OKHLA INDL ESTATE','','','32','110020','Document','100.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','100.00','1','1','2025-11-03 17:37:28','2025-11-03 17:37:28','17617151801089','17617151801089','POLY MEDICURE LTD','541','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('482','18','1','','4','41918123','2025-11-03','515','524','476','MERIDIAN  FREIGHT FORWARDEBRS PVT LTD','917090313444','','','3RD FLOOR, 00, COMMERCE CENTER, NR. ARVIND MOTORS, KULURU KAVOOR ROAD, MANGALORE, Dakshina Kannada, Karnataka, 575013','','29AADCM7648C1ZB','11','575013','MALPEFRESH MARINE EXPORT PVT LTD','918971602293','','KATBELTHURU , KUNDAPUR','','','11','576230','Document','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','37.00','1','1','2025-11-03 17:39:04','2025-12-13 16:58:20','17617176063340','17617176063340','','3363','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','1','0','','','','','','1','');
INSERT INTO `booking` VALUES ('483','7','1','','2','3395030','2025-11-03','','5011','477','GNANASEKHAR','919448933150','','','KOTEKAR','NATEKAL','','11','575011','GREEN AUTOGAS','917418483060','','TRICHY ROAD','NAMAKKAL','','23','637001','Document','0.00','0.00','0.00','0','Document','Surface','1','0.22','','','','','0.22','100.00','1','1','2025-11-03 17:40:12','2025-11-03 17:40:12','17617199828916','17617199828916','','2424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('484','17','1','','2','3404679','2025-11-03','','5012','478','GOPIKA A','917907164389','','','LOWER BENDOOR','MANGALORE','','23','','JAIMINI PUROHITH','917838921817','','BAZAR GATE STREET','','','14','400001','Document','0.01','0.00','0.00','0','Document','Surface','1','0.15','','','','','0.15','130.00','1','1','2025-11-03 17:40:16','2025-11-03 17:40:16','17617216042295','17617216042295','OPP PARAS DRY FRUITS','57','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('485','21','1','','2','3393098','2025-11-03','','5006','479','SSRC','919130000310','','','MLR','','','11','575006','SRI SHYAM ROAD CARRIER','919711860471','','S S RC','DHARUHESA','','8','123106','Document','100.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','100.00','1','1','2025-11-03 17:41:30','2025-11-03 17:41:30','17617214622025','17617214622025','','2092','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('486','17','1','','4','41848284','2025-11-03','3920','3914','480','NIRAN MOTORS PVT LTD','919019734800','','','UPPER BENDOOR OPP SCS HOSPITAL BENDOORWELL MANGALORE-2','MANGALORE','29AAGCN2668A1ZH','11','575001','MOHD ARFAZ','919008734434','','KINNIGOLI','','','11','574150','Document','0.01','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','37.00','1','1','2025-11-03 17:41:44','2025-12-13 16:58:20','17617216585187','17617216585187','','781','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','1','0','','','','','','1','');
INSERT INTO `booking` VALUES ('487','26','1','','2','3400855','2025-11-03','','5013','481','asst eng','918618344504','','','mescom','ullal','','11','','nsoft i ser p ltd','919448490420','','bsk 3rd stg','bsk','','11','560085','Document','2000.00','0.00','0.00','0','Document','Surface','1','1.34','','','','','1.34','247.00','1','1','2025-11-03 17:42:29','2025-11-03 17:42:29','17615707686074','17615707686074','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('488','13','1','','2','3404011','2025-11-03','','5014','482','GOPAL RAJALAKSHMI ELECTRONICS','917406065393','','','GHS ROAD','','','11','575001','GIRISH KUMAR','919742728022','','FLIPKART INTERNET','DEVARBEESANAHALI','','11','560103','Document','10.00','0.00','0.00','0','Document','Surface','1','0.05','','','','','0.05','60.00','1','1','2025-11-03 17:43:05','2025-11-03 17:43:05','17617147018423','17617147018423','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('489','7','1','','2','3395031','2025-11-03','','5015','483','ASHWIN KUMAR','918970146614','','','HOSABETTU','MANGALORE','','11','575011','DARSHAN','918431035878','','INDCHEMIE HEALTH SPL P LTD','YESHWANTHPURA HOBLI','','11','560073','Document','0.00','0.00','0.00','0','Document','Surface','1','0.01','','','','','0.01','60.00','1','1','2025-11-03 17:44:21','2025-11-03 17:44:21','17617199828916','17617199828916','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('490','25','1','','2','3388844','2025-11-03','','4664','484','ARIF','917259891761','','','CHELAIR','SURATHKAL','','11','575014','HARDIK BAROT','919408789776','','VIJAY CROSS ROAD','NAVARANGPUR AHMEDBAD','','7','380009','Document','100.00','0.00','0.00','0','Document','Surface','1','0.10','','','','','0.10','120.00','1','1','2025-11-03 17:44:41','2025-11-03 17:44:41','17617202587270','17617202587270','','3','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('491','23','1','','2','3408511','2025-11-03','','5016','295','jaya offset','919886009633','','','pandeshwara','mangalore','','11','575001','mr naveen','919845939315','','manipal tech nologies ltd','shivalli','','11','576104','Document','100.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','50.00','1','1','2025-11-03 17:45:08','2025-11-03 17:45:08','17617218175043','17617218175043','','662','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('492','17','1','','2','3404680','2025-11-03','','5017','485','MITSUBISHI ELEVATOR INDIA P LTD','919591984826','','','BENDOORWELL','MANGALORE','','11','575002','SHRUTHI','910802225248','','RAJBHVAN ROAD','','','560001','','Document','0.01','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-03 17:45:49','2025-11-03 17:45:49','17617216042295','17617216042295','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('493','7','1','','2','3395032','2025-11-03','','5015','486','ASHWIN KUMAR','918970146614','','','HOSABETTU','MANGALORE','','11','575011','JITHESH J AMIN','917738094939','','SAI BAB TEMPLE','BHABOLA','','14','401202','Document','0.00','0.00','0.00','0','Document','Surface','1','0.01','','','','','0.01','100.00','1','1','2025-11-03 17:45:51','2025-11-03 17:45:51','17617199828916','17617199828916','','57','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('494','21','1','','2','3393099','2025-11-03','','5018','489','ABHISHEK','918277688146','','','MLR','','','11','575006','DEENA','919743990525','','ALARIC ENT','OLD AIR PORT RD','','11','560017','Document','100.00','0.00','0.00','0','Document','Surface','1','0.98','','','','','0.98','155.00','1','1','2025-11-03 17:46:25','2025-11-03 17:46:25','17617214622025','17617214622025','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('495','18','1','','4','41918124','2025-11-03','470','479','490','DAIJI WORLD MEDIA PVT LTD ( MEDIA) (KVR)','919980184340','','','SHOP N0 XI , GROUND FLOOR , AIR PORT ROAD ,MARAKADA VILLAGE , BONDEL POST, MANGALORE','','29AACCD5705C1ZZ','11','575008','ACCOUNTS DEPT','919844852162','','SRINIVAS GROUP','HAMPANKATA,MANGALORE','','11','575001','Document','0.00','0.00','0.00','0','Document','Surface','1','0.01','','','','','0.01','34.00','1','1','2025-11-03 17:46:57','2025-12-13 16:58:20','17617176063340','17617176063340','','3453','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','1','0','','','','','','1','');
INSERT INTO `booking` VALUES ('496','13','1','','2','3404012','2025-11-03','','5019','491','V CARE SYSTEMS','918026090500','','','CARST','MANGALORE','','11','575001','ENTERPRISES SOFTWARE','918026090500','','AMBAIBOOKING J P NAGARSH','','','11','560029','Document','10.00','0.00','0.00','0','Document','Surface','1','0.54','','','','','0.54','125.00','1','1','2025-11-03 17:47:15','2025-11-03 17:47:15','17617147018423','17617147018423','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('497','25','1','','2','3388845','2025-11-03','','5020','492','NARESH R KARKERA','919036688849','','','SRI SAI KRIPA','SURATHKAL','','11','575014','DANIEL ISSAC','917709574555','','RAJ HORIZON','RAMDEV PARK ROAD MIRA ROAD','','14','401107','Document','700.00','0.00','0.00','0','Document','Surface','1','1.30','','','','','1.30','450.00','1','1','2025-11-03 17:47:43','2025-11-03 17:47:43','17617202587270','17617202587270','','848','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('498','26','1','','2','3400856','2025-11-03','','5021','493','s sivanesan','917892460608','','','kshema','dkt','','11','','s sivakumar','918431319964','','hal layout','kariyammana agrahara','','11','560103','Document','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-03 17:50:32','2025-11-03 17:50:32','17615707686074','17615707686074','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('499','21','1','','2','3393100','2025-11-03','','5022','494','RASHMI','919880162279','','','NEAR KODIKAL SCHOOL','KODICAL','','11','575006','SHASHI V','918105781159','','JAYANAGAR','SUBRAMAYANAGR','','11','560061','Document','100.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-03 17:51:52','2025-11-03 17:53:46','17617214622025','17617214622025','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('500','6','1','','4','41876020','2025-11-03','3514','3517','495','TAPASYA ENTERPRISES','917349490857','','','1ST FLOOR, DOOR NO. 6-1-3, URWA MARKET ROAD,  Ladyhill,Mangaluru, 575006','','29BFJPA5560C1ZO','11','575006','LIMRA BRIDAL COLLECTION','919747881912','','UPPINANGADY','UPG','','11','574241','COSMETICS','-0.01','0.00','0.00','0','Document','Surface','1','0.26','','','','','0.26','17.00','1','1','2025-11-03 17:52:06','2025-12-13 16:58:20','17617213393393','17617213393393','PRUTHVI COMPLEX','2352','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','1','0','','','','','','1','');
INSERT INTO `booking` VALUES ('501','25','1','','2','3388846','2025-11-03','','5023','496','JAYAKUMAR K','919937373104','','','KANA SURATHKAL','MANGLORE','','11','575014','PRABHAKAR KATIYAR','918240577839','','BHAWAN','GURGAON','','8','122001','Document','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','100.00','1','1','2025-11-03 17:52:24','2025-11-03 17:52:24','17617202587270','17617202587270','RAILWAY EQUIPMENT','5','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('502','17','1','','4','41848285','2025-11-03','3920','3914','497','NIRAN MOTORS PVT LTD','919019734791','','','UPPER BENDOOR OPP SCS HOSPITAL BENDOORWELL MANGALORE-2','','29AAGCN2668A1ZH','11','575001','MAHESH SHETTY','919448154548','','POONJA ROAD','B/H NITK','','11','575025','Document','0.01','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','37.00','1','1','2025-11-03 17:53:39','2025-12-13 16:58:21','17617216585187','17617216585187','','3211','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','1','0','','','','','','1','');
INSERT INTO `booking` VALUES ('503','23','1','','2','3408512','2025-11-03','','5024','498','nagashree','919880545870','','','pandeshwara','mangalore','','23','','rajesh g n','919538417389','','j wing sairadha apart','brahmagiri','','11','576101','Document','100.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-03 17:53:59','2025-11-26 16:01:53','17617218175043','17617218175043','','1639','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('504','8','1','','2','3351494','2025-11-03','','5025','499','DURGA SANJIVINI MANIPAL','916364872121','','','HOSPITAL','KATEEL','','11','574148','HEALTH INDIA INS TPA','918242200022','','NR INFOSYS','KOTTARACHOWKI','','11','575006','Document','0.00','0.00','0.00','0','Document','Surface','1','0.10','','','','','0.10','65.00','1','1','2025-11-03 17:54:01','2025-11-26 15:56:16','17617178859109','17617178859109','','3453','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('505','26','1','','2','3400857','2025-11-03','','5026','500','dr abhijith','919964244284','','','dr abhijith','tkt mlr','','11','575017','arunakumar','919945738715','','sadashiv nagar','aramane nagar','','11','560080','Document','10.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-03 17:54:53','2025-11-03 17:54:53','17615707686074','17615707686074','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('506','10','1','','2','3406726','2025-11-03','','4990','501','DHANWANGRI PHARMA','919448045714','','','BEJAI KAPIKAD','MANGALORE','','11','575004','RAMESHWARA MEDICALS','919448045714','','BESIDE BLUE PEARL HOTEL','','','11','577101','Document','100.00','0.00','0.00','0','Document','Surface','1','2.00','','','','','2.00','339.00','1','1','2025-11-03 17:56:06','2025-11-03 17:56:06','17617151801089','17617151801089','NEAR BALARAMESHWARA TEMPLE','696','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('507','13','1','','2','3404013','2025-11-03','','5027','502','SOURSHTRA CLOTH','919886042910','','','MARKET ROAD','','','11','575001','VIDYA VARDA SCHOOL','918546896590','','MAIN ROAD','','','11','574115','Document','0.00','0.00','0.00','0','Document','Surface','1','0.67','','','','','0.67','110.00','1','1','2025-11-03 17:57:03','2025-11-03 17:57:03','17617147018423','17617147018423','','3038','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('508','8','1','','2','3351495','2025-11-03','','5025','499','DURGA SANJIVINI MANIPAL','916364872121','','','HOSPITAL','KATEEL','','11','574148','HEALTH INDIA INS TPA','918242200022','','NR INFOSYS','KOTTARACHOWKI','','11','575006','Document','0.00','0.00','0.00','0','Document','Surface','1','0.23','','','','','0.23','65.00','1','1','2025-11-03 17:57:19','2025-11-26 15:56:16','17617178859109','17617178859109','','3453','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('509','26','1','','2','3400858','2025-11-03','','5026','503','dr abhijith','919964244284','','','dr abhijith','tkt mlr','','11','575017','dr sudhakar shetty','919535080162','','asha clinic','polibetta','','11','571215','Document','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-03 17:57:51','2025-11-03 17:57:51','17615707686074','17615707686074','','862','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('510','20','1','','2','3418022','2025-11-03','','5028','504','ANEEZ','919164402530','','','JYOTHI','MANGALORE','','11','575001','HARSHATH H','919902617381','','VIGNESH CITY COMPLEX','BELTHANGADY','','11','574214','Document','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','50.00','1','1','2025-11-03 17:58:15','2025-11-03 17:58:15','17616544937223','17616544937223','','2580','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('511','21','1','','2','3393101','2025-11-03','','5029','505','AJITH SHET','919448729320','','','CHILIMBI','MLR','','11','575006','RAGAVENDRA R BHAT','919448729320','','PRABHATNAGAR','','','11','581334','Document','100.00','0.00','0.00','0','Document','Surface','1','2.30','','','','','2.30','431.00','1','1','2025-11-03 17:58:25','2025-11-03 17:58:25','17617214622025','17617214622025','','191','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('512','22','1','','2','3411045','2025-11-03','','5030','506','DR KAUSHIK','919844172907','','','KADRI','MANGALURU','','11','575002','DR SHRVAYA','918385992233','','LIFE CARE HOSPITAL','JAIL ROaD','','11','581320','Document','10.00','0.00','0.00','0','Document','Surface','1','0.23','','','','','0.23','85.00','1','1','2025-11-03 18:00:24','2025-11-03 18:00:24','17617169725275','17617169725275','','1689','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('513','8','1','','2','3351496','2025-11-03','','5031','507','ASHWINI SANDEEP','918748022686','','','SHREE LAXMI GANESH HOUSE','NIDDODI','','11','574148','SANDEEP B SHETTY','918660473896','','MAJESTIC COMMERCIAL COMPLEX','KARANGALPADY','','11','57600','Document','0.00','0.00','0.00','0','Document','Surface','1','0.52','','','','','0.52','75.00','1','1','2025-11-03 18:00:39','2025-11-26 15:56:16','17617178859109','17617178859109','','3453','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('514','10','1','','2','3406727','2025-11-03','','5032','508','MOHITH','917022041852','','','MANGALORE','','','11','','MICHELLE','919448239914','','SHANTHI NAGAR','BANGALORE','','11','560027','Document','100.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-03 18:01:36','2025-11-03 18:01:36','17617151801089','17617151801089','LANGFORD ROAD','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('515','17','1','','4','41848286','2025-11-03','3888','3887','509','K.B.L. BALMATTA','919449089832','','','BALMATTA ROAD, MANGALORE. REGD AND HEAD OFFICE, POST BOX- 599, MAHAVEERA CIRCLE, KANKANADY, MANGALORE,575002','','29AABCT5589K1ZL','11','575001','KBL','919663554852','','HAMPANKATTA','MANGALORE','','11','575001','Document','0.01','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','19.00','1','1','2025-11-03 18:01:48','2025-12-20 18:15:23','17617216585187','17617216585187','','3453','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','1','1','2025-12-20 13:14:33','','received','','','1','17645841409774');
INSERT INTO `booking` VALUES ('516','13','1','','2','3404014','2025-11-03','','5033','510','ROHAN MENEZES','919071300503','','','BEHIND SBI HAREKALA BRANCH','MENEZES COTTEGE','','11','575001','EMMAUS','918007593531','','COUNSELLING CENTRE','FEIRDA ACTA MAPUSA','','6','403507','Document','10.00','0.00','0.00','0','Document','Surface','1','2.39','','','','','2.39','550.00','1','1','2025-11-03 18:02:45','2025-11-03 18:02:45','17617147018423','17617147018423','','1590','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('517','16','1','','4','41515291','2025-11-03','330','339','511','CANARA BANK GURUPUR (SY BK)','','','','5th Floor, 112, Canara Bank Head Office, JC Road, Town Hall Junction, Nagartapete, Bengaluru, Bengaluru Urban, , 560002','','29AAACC6106G1ZX','11','574151','CANARA BANK','','','RO','MANGALORE','','11','575001','Document','100.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','17.00','1','1','2025-11-03 18:03:16','2025-12-13 16:58:21','17617177578387','17617177578387','','3453','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','1','0','','','','','','1','');
INSERT INTO `booking` VALUES ('518','14','1','','2','3364672','2025-11-03','','5034','512','ASN ENT','918971758500','','','BONDEL','MANGALORE','','11','575005','SHUBHASBHAI BABULAL PATEL','918830790610','','JALARAM ENT GREVA RESIDENCY 15 SHOP NO 17','SUARI NAGAR SANCOLA','','6','403726','Document','0.00','0.00','0.00','0','Document','Surface','1','0.17','','','','','0.17','95.00','1','1','2025-11-03 18:03:32','2025-11-03 18:03:32','17617209872567','17617209872567','','628','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('519','17','1','','2','3404681','2025-11-03','','5035','513','ABRHAM','919449044531','','','ABRHAM','MANGALORE','','11','','A RAYMON NU CHOLAS','919606339531','','MATHIKERE','BANGALORE','','11','560054','BELT','0.01','0.00','0.00','0','Document','Surface','1','0.30','','','','','0.30','105.00','1','1','2025-11-03 18:04:07','2025-11-03 18:04:07','17617216042295','17617216042295','M S R COLLEGE ROAD','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('520','8','1','','4','41616341','2025-11-03','439','448','514','UCO BANK KINNIGOLI BRANCH','','','','13/22, K G ROAD, BENGALURU, Bengaluru Urban, Karnataka, 560009','KINNIGOLI','29AAACU3561B2ZJ','11','574150','KAVYASHREE A R','919611409762','','UCO  BANK','VIJAYNAGAR BRANCH MAGADI MAIN RD','','11','560040','Document','0.00','0.00','0.00','0','Document','Surface','1','0.15','','','','','0.15','27.00','1','1','2025-11-03 18:04:34','2025-12-13 16:58:21','17617178859109','17617178859109','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','1','0','','','','','','1','');
INSERT INTO `booking` VALUES ('521','18','1','','2','3385036','2025-11-03','','5036','515','SAJI CK','918606401183','','','CAFS KANJAR','MANGALORE','','11','','MS SMITHA.S','918448183894','','HEALTH INSURANCE TPA OF  INDIA','M G ROAD RAVIPURAM COCHIN','','12','682016','Document','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','70.00','1','1','2025-11-03 18:06:30','2025-11-03 18:06:30','17617174764463','17617174764463','','1761','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('522','26','1','','2','3400859','2025-11-03','','5037','516','thameer','919025194684','','','dkt','mlr','','11','575018','sindhu','919361035832','','ambattur','meenambedu','','23','600053','Document','0.00','0.00','0.00','0','Document','Surface','1','0.05','','','','','0.05','70.00','1','1','2025-11-03 18:07:09','2025-11-03 18:07:09','17615707686074','17615707686074','','1931','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('523','10','1','','2','3406728','2025-11-03','','5038','517','SHIVAPRASAD','918217492843','','','BEJAI MUSEUM ROAD','MANGALORE','','11','575004','REKHA J','919700000493','','RIVIERA APTS','DWARAKAPURI COLONY','','1','500082','Document','100.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','70.00','1','1','2025-11-03 18:07:11','2025-11-03 18:07:11','17617151801089','17617151801089','ION EXCHANGE INDIA LTD','117','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('524','8','1','','4','41616342','2025-11-03','393','402','518','GADRE MARINE EXPORT PRIVATE LIMITEDAD290725004221E','','','','PLOT NO.IP-32 & IP-33, MANGALORE  SPECIAL ECONOMIC ZONE BAJPE POST & VILLAGE,  MANGALORE-574142','','29AABCG4138R2Z0','11','','SARFRAJ  HDFC BANK','916652760277','','SHAHAPURI  E WARD','KOLHAPUR','','14','416001','Document','0.00','0.00','0.00','0','Parcel','Surface','1','0.60','','','','','0.60','199.00','1','1','2025-11-03 18:07:26','2025-12-17 14:34:42','17617178859109','17617229594029','','649','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','1','0','','','','','','1','');
INSERT INTO `booking` VALUES ('525','22','1','','2','3411046','2025-11-03','','5039','519','ABHIJITH','919986340153','','','SANTHOSH KUMAR','VAMANJOOR','','11','575028','NIKHIL','919746243379','','POREDOM','CHADYA MANGALAM','','12','691534','Document','760.00','0.00','0.00','0','Document','Surface','1','0.10','','','','','0.10','85.00','1','1','2025-11-03 18:07:34','2025-11-03 18:07:34','17617169725275','17617169725275','SOPANAM   THERUVN BGAGAM','650','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('526','17','1','','4','41848287','2025-11-03','3960','3954','520','VAIBHAV ENTERPRISES','','','','3RD FLOOR BRIDGE SQUARE BUILDING BEHIND JUICE JUNCTION JYOTHI MANGALORE-2','','29GCJPS1629J1ZY','11','575002','PRASHANTH BOLAR','911988655930','','BOLAR','MANGALORE','','11','575001','Document','0.01','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','31.00','1','1','2025-11-03 18:07:50','2025-12-20 12:07:36','17617216585187','17617216585187','MULIHITHLU','3453','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','1','1','2025-12-20 12:07:36','','received','','','1','17645841409774');
INSERT INTO `booking` VALUES ('527','14','1','','2','3364673','2025-11-03','','5040','521','UNIQUE SYSTEM','917259551313','','','K S RAO RD','MANGALORE','','11','575001','SKDRDP BC TRUST','917019667220','','NEAR CHENNA KESHAVA TEMPLE','OPP BSNL OFFICE','','11','574239','Document','10.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','50.00','1','1','2025-11-03 18:08:19','2025-11-03 18:08:19','17617209872567','17617209872567','','2577','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('528','21','1','','2','3393102','2025-11-03','','5041','522','CHIRAG','917022993725','','','KOTTARA','MLR','','11','575006','KARTHIK','918197590744','','NEAR NANDINI','BHUVANESHWARINAGAR','','11','561203','Document','100.00','0.00','0.00','0','Document','Surface','1','0.40','','','','','0.40','105.00','1','1','2025-11-03 18:09:55','2025-11-03 18:09:55','17617214622025','17617214622025','','1166','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('529','17','1','','2','3404682','2025-11-03','','4980','511','S C S HOSPITAL PVT LTD','918242881100','','','UPPER BENDOOR','MANGALORE','','11','','M R PL','','','KUTHETHOOR','MANGALORE','','11','','Document','0.02','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','50.00','1','1','2025-11-03 18:10:10','2025-11-26 15:56:16','17617216042295','17617216042295','','3453','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('530','22','1','','2','3411047','2025-11-03','','5042','523','SURAJ KULLAL','919591443530','','','MAROLI','KULSHEKAR','','11','575005','G KUMAR','919980032824','','10TH B CROSS ROAD','LAGGERE','','11','560086','Document','0.10','0.00','0.00','0','Document','Surface','1','0.05','','','','','0.05','60.00','1','1','2025-11-03 18:10:50','2025-11-03 18:10:50','17617169725275','17617169725275','','1036','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('531','23','1','','2','3408513','2025-11-03','','5043','524','VENUGOPAL','918317325247','','','PANDESHWARA','MANGALORE','','11','575001','ROHIT B S','919343003006','','5TH CROSS','CHARAMAJPET','5TH CROSS','11','560018','Document','100.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-03 18:10:53','2025-11-03 18:10:53','17617218175043','17617218175043','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('532','13','1','','2','3404015','2025-11-03','','5044','525','VUJAYALAXMI MOBILE','919739790275','','','CENTRAL MARKET','','','11','575001','MARCEL THE PLATIUN','919819495336','','NO145 3RD FLOOR PATTHE BAPURAO','GRANT ROAD','','14','40001','Document','10.00','0.00','0.00','0','Document','Surface','1','1.16','','','','','1.16','370.00','1','1','2025-11-03 18:11:18','2025-11-03 18:11:18','17617147018423','17617147018423','','57','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('533','7','1','','2','3395033','2025-11-03','','5045','526','MATHA  TRANSPORT','917305421385','','','APMC','BAIKAMPADY','','11','575011','C SUNDARAVADIVEL','919843044824','','KUNIYAMUTHUR','COIMBATORE','','23','641008','Document','0.00','0.00','0.00','0','Document','Surface','1','0.01','','','','','0.01','70.00','1','1','2025-11-03 18:11:19','2025-11-03 18:11:19','17617199828916','17617199828916','','535','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('534','26','1','','2','3400860','2025-11-03','','5046','527','jsi sports','917019143138','','','kallapu','tkt','','11','','r balSUBRAMANIAN','919652048511','','MADEENAGUDA','MG','','1','500049','Cloths','1000.00','0.00','0.00','0','Document','Surface','1','1.65','','','','','1.65','304.00','1','1','2025-11-03 18:11:21','2025-11-03 18:11:21','17615707686074','17615707686074','','117','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('535','17','1','','4','41848288','2025-11-03','3960','3954','528','VAIBHAV ENTERPRISES','919611747074','','','3RD FLOOR BRIDGE SQUARE BUILDING BEHIND JUICE JUNCTION JYOTHI MANGALORE-2','','29GCJPS1629J1ZY','11','575002','A SANJEEVA','919449555375','','S R DRESSES','SLN COMPLEX','','11','574241','Document','0.01','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','41.00','1','1','2025-11-03 18:11:58','2025-12-13 16:58:21','17617216585187','17617216585187','','2352','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','1','0','','','','','','1','');
INSERT INTO `booking` VALUES ('536','8','1','','4','41616343','2025-11-03','433','442','529','ST.MILAGRES CREDIT SOUHARDHA CO-OP.LTD,.KARWAR(KINNIGOLI)','','','','St Milagres Credit Souharda, co op society limited, Keshava Shet Road, Karwar, Uttara Kannada,581304','KINNIGOLI','29AACAS0079A1ZR','11','574150','ST MILAGRES CREDIT CO OP','918884419387','','APMC ROAD','PUTTUR','','11','574201','Document','0.00','0.00','0.00','0','Document','Surface','1','0.20','','','','','0.20','36.00','1','1','2025-11-03 18:13:23','2025-12-13 16:58:21','17617178859109','17617178859109','','1904','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','1','0','','','','','','1','');
INSERT INTO `booking` VALUES ('537','21','1','','2','3393103','2025-11-03','','5041','530','CHIRAG','917022993725','','','KOTTARA','MLR','','11','575006','CHIRAG','917795075109','','BCM H','BANNERGHATTA','','11','560083','Document','100.00','0.00','0.00','0','Document','Surface','1','0.54','','','','','0.54','125.00','1','1','2025-11-03 18:13:25','2025-11-03 18:13:25','17617214622025','17617214622025','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('538','25','1','','2','3388847','2025-11-03','','5047','531','R VISHNU','919482243067','','','DECCAN ROBOTICS','MANGLORE','','11','575014','PRAJWAL V SUVARNA','918073147517','','3RD ROAD G K LAYOUT','PARAPPANA AGRAHARA BANGLORE','','11','560010','Document','0.00','0.00','0.00','0','Document','Surface','1','0.20','','','','','0.20','85.00','1','1','2025-11-03 18:13:46','2025-11-03 18:13:46','17617202587270','17617202587270','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('539','14','1','','2','3364674','2025-11-03','','5048','532','7259881313','','','','UNIQUE SYSTEMS','K S RAO RD','','11','575001','VAIBHAV INFO','919739020959','','#5 3 RD FLOOR VINAYAKA PLAZA','S P RD','','11','560002','Document','10.00','0.00','0.00','0','Document','Surface','1','0.20','','','','','0.20','85.00','1','1','2025-11-03 18:14:06','2025-11-03 18:14:06','17617209872567','17617209872567','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('540','7','1','','2','3395034','2025-11-03','','5049','511','MEENAKSHI  SUNDARAM','919952965501','','','KULAI','MANGALORE','','11','575019','V VASUDEVAN','','','MIT CAMPUS','CHENNAI','','23','600044','Document','0.01','0.00','0.00','0','Document','Surface','1','0.01','','','','','0.01','70.00','1','1','2025-11-03 18:14:15','2025-11-03 18:14:15','17617199828916','17617199828916','','1931','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('541','13','1','','2','3404016','2025-11-03','','5050','533','JUDE C REGO','919845238284','','','P M RAO ROAD','','','11','575001','9869312130','919869312130','','NEHAL DESAI','22VEERA DESAI ROAD','','14','400053','Document','10.00','0.00','0.00','0','Document','Surface','1','0.05','','','','','0.05','100.00','1','1','2025-11-03 18:14:17','2025-11-03 18:14:17','17617147018423','17617147018423','','57','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('542','16','1','','4','41515292','2025-11-03','352','4802','534','MANGALORE RUBBER PVT LTD','917899565173','','','MANGALORE RUBBER PVT LTD, MARLA PADAV GANJIMUTT MANEL ROAD, GANJIMUTT, Dakshina Kannada,  574144','','29AAACM5676P1ZN','11','574144','spectrum industries','917026625564','','yeyyadi','mangalore','','11','575008','Document','500.00','0.00','0.00','0','Document','Surface','1','2.00','','','','','2.00','82.00','1','1','2025-11-03 18:14:58','2025-12-18 18:30:33','17617177578387','17617177578387','','3453','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','1','1','2025-12-18 18:30:33','','received','','','1','17645844402769');
INSERT INTO `booking` VALUES ('543','26','1','','2','3400861','2025-11-03','','5051','535','DINESHA g','918310149087','','','kairangala','mlr','','11','575018','aby mathew','919645656531','','chakaraparambu','cp','','12','682032','Document','0.00','0.00','0.00','0','Document','Surface','1','0.05','','','','','0.05','70.00','1','1','2025-11-03 18:15:35','2025-11-03 18:15:35','17615707686074','17615707686074','simpolo vitrified p ltd','1761','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('544','17','1','','4','41848289','2025-11-03','3860','3862','509','BHARATH CO-OP BANK,','919663554852','','','NEAR S.C.S. HOSPITAL, UPPER BENDOOR, MANGALORE-575001.GROUND FLOOR, Money Terrace, K.H.Road ,Double Road, Bengaluru,560027','','29AAAAT0030E1Z1','11','575002','LOAN DEPT','919663554852','','BHARAT BANK LTD','COLLEGE ROAD','','14','422005','Document','0.01','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','62.00','1','1','2025-11-03 18:16:42','2025-12-13 16:58:21','17617216585187','17617216585187','','2456','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','1','0','','','','','','1','');
INSERT INTO `booking` VALUES ('545','17','1','','2','3404683','2025-11-03','','4980','536','S C S HOSPITAL PVT LTD','918242881100','','','UPPER BENDOOR','MANGALORE','','11','575002','kishore kumar','919964889955','','vidal ehalth ins p ltd','RAJPALYA','','11','560048','Document','0.01','0.00','0.00','0','Document','Surface','1','0.37','','','','','0.37','105.00','1','1','2025-11-03 18:16:50','2025-11-03 18:16:50','17617216042295','17617216042295','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('546','12','1','','2','3382930','2025-11-03','','5052','537','RAGHAVA T RAO','919742970791','','','BOLAR','MANGALORE','','11','575001','MR KRISHNA','919986687221','','BL LIFE SCOIENCE P LTD 50 CROSS 3RD BLCOK','RAJAJINAGARA BANGALORE','','11','560010','Document','10.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-03 18:17:15','2025-11-03 18:17:15','17617206505387','17617206505387','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('547','21','1','','2','3393104','2025-11-03','','5053','538','PRAMOD ENT','918617875397','','','KOTTARA','MLR','','11','575006','PRAMOD B N','919448330416','','GANDHIBAZAR','BLR','','11','573201','Document','100.00','0.00','0.00','0','Document','Surface','1','0.29','','','','','0.29','105.00','1','1','2025-11-03 18:17:16','2025-11-03 18:17:16','17617214622025','17617214622025','','448','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('548','16','1','','4','41515293','2025-11-03','369','378','539','ST. JOSEPH ENGINEERS COLLEGE','918242263753','','','13-12-1435, Bishops House, Kodialbail Church Road, Kodialbail, Dakshina Kannada, 575003','','29AAATD0794J1ZG','11','575028','subhash','918095870143','','delnet','9th floor','','11','560049','Document','100.00','0.00','0.00','0','Document','Surface','1','0.70','','','','','0.70','89.00','1','1','2025-11-03 18:17:17','2025-12-13 16:58:21','17617177578387','17617177578387','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','1','0','','','','','','1','');
INSERT INTO `booking` VALUES ('549','8','1','','4','41616344','2025-11-03','425','434','511','S C D C C BANK DAMASKATTE','','','','ANNAPOORNESHWARI AIKALA POST DAMASKATTE','KINNIGOLI','29AABAT6621N2ZZ','11','574150','SCDCC BANK','','','HO','KBL','','11','575001','Document','0.00','0.00','0.00','0','Document','Surface','1','0.10','','','','','0.10','14.70','1','1','2025-11-03 18:17:25','2025-12-22 13:12:46','17617178859109','17617178859109','','3453','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','1','0','','','','','','1','');
INSERT INTO `booking` VALUES ('550','20','1','','2','3418023','2025-11-03','','5054','540','UTTAM TAI','919060383881','','','MANGALORE','','','11','575001','RAKESH MASCARENHAS','919686912316','','COURT ROAD','PUTTUR','','11','574201','Document','0.00','0.00','0.00','0','Document','Surface','1','0.15','','','','','0.15','75.00','1','1','2025-11-03 18:17:47','2025-11-03 18:17:47','17616544937223','17616544937223','','1904','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('551','13','1','','2','3404017','2025-11-03','','5055','541','ORCHID INNOVATIONS','919241428245','','','BALMATTA MANGALORE','','','11','575001','SIDDESH INDO MIM','919632604732','','KIADB INDU','DODDABALLPURA','','11','561203','Document','10.00','0.00','0.00','0','Document','Surface','1','0.05','','','','','0.05','60.00','1','1','2025-11-03 18:17:56','2025-11-03 18:17:56','17617147018423','17617147018423','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('552','16','1','','4','41515294','2025-11-03','330','339','511','CANARA BANK GURUPUR (SY BK)','','','','5th Floor, 112, Canara Bank Head Office, JC Road, Town Hall Junction, Nagartapete, Bengaluru, Bengaluru Urban, , 560002','','29AAACC6106G1ZX','11','575151','canara bank','','','ro','mangalore','','11','575001','Document','100.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','17.00','1','1','2025-11-03 18:19:10','2025-12-13 16:58:21','17617177578387','17617177578387','','3453','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','1','0','','','','','','1','');
INSERT INTO `booking` VALUES ('553','25','1','','2','3388848','2025-11-03','','5047','542','R VISHNU','919482243067','','','DECCAN ROBOTICS','MANGLORE','','11','575014','ADITYA JANGID','917231987966','','AURBOINDO HOSTEL','MNIT JAIPUR','','21','302017','Document','1000.00','0.00','0.00','0','Document','Surface','1','1.51','','','','','1.51','530.00','1','1','2025-11-03 18:19:14','2025-11-03 18:19:14','17617202587270','17617202587270','','455','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('554','23','1','','2','3408514','2025-11-03','','5056','543','N K PUTTARAJU RSI','919449236989','','','PANDESHWARA','MANGALORE','','23','','MANAGER','919440384594','','GC CRPF','YALAHANANKA','','11','560064','Document','100.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-03 18:20:09','2025-11-03 18:20:09','17617218175043','17617218175043','CPC MASTER CANTEEN','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('555','26','1','','2','3400862','2025-11-03','','5057','544','pavithra oil','919986466324','','','tkt','mlr','','11','','vimala prakashvidyapeeta','918147039491','','mn rd','','','11','560085','Document','500.00','0.00','0.00','0','Document','Surface','1','0.35','','','','','0.35','105.00','1','1','2025-11-03 18:20:16','2025-11-03 18:20:16','17615707686074','17615707686074','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('556','20','1','','2','3418024','2025-11-03','','5058','545','SHAHID','911903630316','','','MANGALORE','','','11','575001','MUMTAZ SHAIKH','918088795706','','SIRSI','','','11','581401','Document','0.00','0.00','0.00','0','Document','Surface','1','2.40','','','','','2.40','431.00','1','1','2025-11-03 18:20:27','2025-11-03 18:20:27','17616544937223','17616544937223','','289','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('557','8','1','','4','41616345','2025-11-03','407','416','511','KARNATAKA GRAMEENA BANK KATEEL','','','','2VWC+97W,HOTEL SOUNDARYA PALACE COMPLEX NEW BUS STOP KATEEL','KATEEL','29AAOAK6959P1ZB','11','574148','KARNATAKA GRAMEENA N\\BANK','','','R O','PADAVINANGDY','','11','575001','Document','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','18.00','1','1','2025-11-03 18:20:34','2025-12-18 18:46:10','17617178859109','17617178859109','','3453','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','1','1','2025-12-18 18:46:10','','received','','','1','17645844402769');
INSERT INTO `booking` VALUES ('558','17','1','','4','41848290','2025-11-03','3860','3862','546','BHARATH CO-OP BANK,','','','','NEAR S.C.S. HOSPITAL, UPPER BENDOOR, MANGALORE-575001.GROUND FLOOR, Money Terrace, K.H.Road ,Double Road, Bengaluru,560027','','29AAAAT0030E1Z1','11','575001','LOAN DEPT','919448596792','','HOTEL VEENU SKY PLAZA','KARKALA ROAD','','11','574227','Document','0.01','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','34.00','1','1','2025-11-03 18:20:49','2025-12-20 12:41:06','17617216585187','17617216585187','BHARAT BANK LTD','1068','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','1','1','2025-12-20 12:41:06','','received','','','1','17645841409774');
INSERT INTO `booking` VALUES ('559','17','1','','2','3404684','2025-11-03','','5048','511','BHARATH CO OP BANK','','','','MANGALORE','','','11','575002','BHARATH CO OP BANK','','','ADUMBAR CHAYA CHSL','I C COLONY','','14','400103','Document','0.00','0.00','0.00','0','Document','Surface','1','0.15','','','','','0.15','130.00','1','1','2025-11-03 18:20:56','2025-11-03 18:20:56','17617216042295','17617216042295','','57','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('560','12','1','','2','3382931','2025-11-03','','5059','547','GANESH PRABHU','916382688818','','','ATTAVARA','MANGALORE','','11','','SANDEEP','919902077762','','KASATTY TECH SOLUTION LLP','NO60 RAMAIAH LAYOUT SESHADRIPURAM','','11','560020','Document','10.00','0.00','0.00','0','Document','Surface','1','0.13','','','','','0.13','85.00','1','1','2025-11-03 18:21:26','2025-11-03 18:21:26','17617206505387','17617206505387','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('561','13','1','','2','3404018','2025-11-03','','5060','525','SUNDHA ELECTRONICS','918884826223','','','CENTRAL MKT','','','11','575001','MARCEL THE PLATIUN','919819495336','','NO145 3RD FLOOR PATTHE BAPURAO','GRANT ROAD','','14','400001','Document','10.00','0.00','0.00','0','Document','Surface','1','1.62','','','','','1.62','530.00','1','1','2025-11-03 18:21:53','2025-11-03 18:21:53','17617147018423','17617147018423','','57','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('562','22','1','','2','3411048','2025-11-03','','5061','548','SUDHAKAR','918050049587','','','DERLAKATTE','MANGALURU','','11','575017','DR PARVEEN SHETTY','919886663696','','ANANDA DENTAL CLINIC','COURT ROAD','','11','576101','Document','0.10','0.00','0.00','0','Document','Surface','1','0.40','','','','','0.40','85.00','1','1','2025-11-03 18:21:53','2025-11-03 18:21:53','17617169725275','17617169725275','','1639','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('563','20','1','','2','3418025','2025-11-03','','5062','549','BRIGHT SECURITY SERVICES','918904045574','','','KODIALBAIL','','','11','575001','VISHAL INFRA','919113629252','','BAJPE','','','11','575001','Document','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','50.00','1','1','2025-11-03 18:22:23','2025-11-03 18:22:23','17616544937223','17616544937223','','3219','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('564','25','1','','2','3388849','2025-11-03','','5063','550','VIKESH V KULAL','918880604004','','','HARSHA SKL','SKL','','11','575014','YOGISH','918971773049','','HOUSE NO 1346 NEW SHIVAJI COLONY','TILAKWADI BELGAUM','','11','590006','Document','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-03 18:23:11','2025-11-03 18:23:11','17617202587270','17617202587270','','4','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('565','16','1','','4','41515295','2025-11-03','329','338','511','CANARA BANK GANJIMUTT (SY BK)','','','','5th Floor, 112, Canara Bank Head Office, JC Road, Town Hall Junction, Nagartapete, Bengaluru, Bengaluru Urban, , 560002','','29AAACC6106G1ZX','23','575151','canara bank','','','hudson circle','bangalore','','11','560001','Document','100.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','17.00','1','1','2025-11-03 18:23:13','2025-12-13 16:58:22','17617177578387','17617177578387','','3453','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','1','0','','','','','','1','');
INSERT INTO `booking` VALUES ('566','23','1','','2','3408515','2025-11-03','','5064','551','KARTHIK AGENCIES','919845083889','','','PANDESHWARA','MANGALORE','','23','','MR RAVI KUMAR','919743267561','','THE CHIEF VENTRINATRY OFFICER','VETRANATRY HOSPITAL','','11','','Document','100.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','50.00','1','1','2025-11-03 18:23:36','2025-11-03 18:23:36','17617218175043','17617218175043','','2580','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('567','20','1','','2','3418026','2025-11-03','','5062','552','BRIGHT SECURITY SERVICES','918904045574','','','KODIALBAIL','','','11','575001','7 APPLE HOTELS PVT LTD','918976728579','','NARIMAN POINYT','','','14','400021','Document','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','100.00','1','1','2025-11-03 18:23:51','2025-11-03 18:23:51','17616544937223','17616544937223','','57','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('568','26','1','','2','3400863','2025-11-03','','5065','553','dr ronald valdier','919964277520','','','pace','mlr','','11','','registrar evaluation','918312498136','','vtu','jnana sangama','','11','','Document','0.00','0.00','0.00','0','Document','Surface','1','0.05','','','','','0.05','60.00','1','1','2025-11-03 18:23:57','2025-11-03 18:23:57','17615707686074','17615707686074','','4','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('569','8','1','','4','41616346','2025-11-03','407','416','511','KARNATAKA GRAMEENA BANK KATEEL','','','','2VWC+97W,HOTEL SOUNDARYA PALACE COMPLEX NEW BUS STOP KATEEL','KATEEL','29AAOAK6959P1ZB','11','574148','KARNATAKA GRAMEENA BANK','','','MAIN ROAD','MOODBIDRI','','11','574227','Document','0.00','0.00','0.00','0','Document','Surface','1','0.10','','','','','0.10','18.00','1','1','2025-11-03 18:24:12','2025-12-18 18:46:08','17617178859109','17617178859109','','1068','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','1','1','2025-12-18 18:46:08','','received','','','1','17645844402769');
INSERT INTO `booking` VALUES ('570','17','1','','4','41848291','2025-11-03','3938','3932','554','S.B.I.ARYA SAMAJ,','919916966223','','','ARYA SAMAJ BRANCH, BALMATTA, MANGALORE  65, State Bank of India, Local Head Office, St. Marks Road, Bengaluru,560001','','29AAACS8577K3ZJ','11','575002','AGM','916363485632','','YASHWANTHPUR','','','11','560022','Document','0.01','0.00','0.00','0','Document','Surface','1','0.30','','','','','0.30','18.00','1','1','2025-11-03 18:25:10','2025-12-13 16:58:22','17617216585187','17617216585187','SBI LCPC','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','1','0','','','','','','1','');
INSERT INTO `booking` VALUES ('571','16','1','','4','41515296','2025-11-03','331','340','511','CANARA BANK KAIKAMBA (1)(SY BK)','','','','5th Floor, 112, Canara Bank Head Office, JC Road, Town Hall Junction, Nagartapete, Bengaluru, Bengaluru Urban,  560002','','29AAACC6106G1ZX','11','575151','canara bank','','','nrupathunga road','bangalore','','11','560001','Document','100.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','17.00','1','1','2025-11-03 18:25:17','2025-12-18 18:10:25','17617177578387','17617177578387','','3453','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','1','1','2025-12-18 18:10:25','','received','','','1','17645844402769');
INSERT INTO `booking` VALUES ('572','17','1','','2','3404685','2025-11-03','','5066','555','DR KARTHIK SHETTY','919008008040','','','OPP GOLD FINCH','','','11','575002','SNEHAL','919607992951','','PURVA COMPLEX','AUNDH','','14','411007','Document','0.01','0.00','0.00','0','Document','Surface','1','0.10','','','','','0.10','120.00','1','1','2025-11-03 18:25:37','2025-11-03 18:25:37','17617216042295','17617216042295','','13','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('573','25','1','','2','3388850','2025-11-03','','5067','556','VIJAYA CR CO SOCIETY LTD','917337844288','','','SURATHKAL','SKL','','11','575014','VIJAYA CR CO SOCIETY','917337844293','','B B BUILDING','GURUVAYNKERE','','11','574217','Document','100.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','50.00','1','1','2025-11-03 18:26:17','2025-11-03 18:26:17','17617202587270','17617202587270','','2580','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('574','16','1','','4','41515297','2025-11-03','368','377','557','SRI RAMAKRISHNA CREDIT CO-OPERATIVE SOCIETY LTD.(KAI)','','','','2ND FLOOR, 3-31-2572/7, AMRUTHOTHSAV BUILDING, BUNTS HOSTEL ROAD, MANGALORE, Dakshina Kannada,  575003','','29AAAAS3576Q1ZO','11','574151','sri ramakrishna cr co-op','918242492275','','ho','bunts hostel','','11','575003','Document','100.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','18.00','1','1','2025-11-03 18:27:10','2025-12-13 16:58:22','17617177578387','17617177578387','','3453','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','1','0','','','','','','1','');
INSERT INTO `booking` VALUES ('575','8','1','','4','41616347','2025-11-03','407','416','511','KARNATAKA GRAMEENA BANK KATEEL','','','','2VWC+97W,HOTEL SOUNDARYA PALACE COMPLEX NEW BUS STOP KATEEL','KATEEL','29AAOAK6959P1ZB','11','574148','KARNATAKA GRAMEENA BANK','','','KARANGALPADY','MANGALORE','','11','575001','Document','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','18.00','1','1','2025-11-03 18:27:28','2025-12-18 18:46:08','17617178859109','17617178859109','','3453','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','1','1','2025-12-18 18:46:08','','received','','','1','17645844402769');
INSERT INTO `booking` VALUES ('576','26','1','','2','3400864','2025-11-03','','5032','558','MOHITH','917022041852','','','MANGALORE','','','11','575018','arpita p s','919483479067','','kamlapadu','','','11','','Document','0.00','0.00','0.00','0','Document','Surface','1','0.10','','','','','0.10','50.00','1','1','2025-11-03 18:28:31','2025-11-26 15:56:16','17615707686074','17615707686074','','3453','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('577','17','1','','2','3404686','2025-11-03','','4980','511','S C S HOSPITAL PVT LTD','918242881100','','','UPPER BENDOOR','MANGALORE','','11','','F H P L','','','CHETTY COLONY','','','11','560051','Document','0.00','0.00','0.00','0','Document','Surface','1','0.17','','','','','0.17','85.00','1','1','2025-11-03 18:28:35','2025-11-03 18:28:35','17617216042295','17617216042295','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('578','10','1','','2','3406729','2025-11-03','','5068','559','DR ULLASA SHETTY','919449008130','','','AJIMS','KUNTIKAN','','11','575004','THE POLICE INSPECTOR','919480805054','','T NARASIPURA TALUK','','','11','571122','Document','100.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-03 18:28:37','2025-11-03 18:28:37','17617151801089','17617151801089','TALAKADU POLICE STATION','669','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('579','25','1','','2','3388851','2025-11-03','','5069','560','I NEEDS','918242478977','','','SKL','SKL','','11','575014','VISION INFINITY','918217630549','','KILARI ROAD','BALEPTE CHICKPET','','11','560053','Parcel','10000.00','0.00','0.00','0','Document','Surface','1','0.65','','','','','0.65','125.00','1','1','2025-11-03 18:28:44','2025-11-03 18:28:44','17617202587270','17617202587270','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('580','16','1','','4','41515298','2025-11-03','362','371','511','S.C.D.C.C. BANK KAIKAMBA','','','','PB NO 721, SADASHIVA SAHAKARI SADANA, KODIALBAIL, KODIALBAIL, Dakshina Kannada, Karnataka, 575003','','29AABAT6621N2ZZ','11','574151','scdcc bank','','','saibarkatte','udupi','','11','5','Document','100.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','15.75','1','1','2025-11-03 18:28:54','2025-12-18 18:21:40','17617177578387','17617177578387','','1639','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','1','1','2025-12-18 18:21:40','','received','','','1','17645844402769');
INSERT INTO `booking` VALUES ('581','17','1','','4','41848292','2025-11-03','3916','3910','561','MOTILAL OSWAL FINANCIAL SERVICES LIMITED','912271934263','','','3rd FLOOR, MILESTONE-25 LAND TRADES BUILDER & DEVELOPERS, BALMATTA CIRCLE, MANGALORE-575001','','29AAECM2876P1ZN','11','575002','DEEPALI','919326233292','','SIGNATURE BLDG','GIFT CITY','','7','382355','Document','0.01','0.00','0.00','0','Document','Surface','1','0.40','','','','','0.40','110.00','1','1','2025-11-03 18:29:08','2025-12-13 16:58:22','17617216585187','17617216585187','DHM DOVETAIL GLOBAL SERVICES P LTD','626','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','1','0','','','','','','1','');
INSERT INTO `booking` VALUES ('582','6','1','','2','3381538','2025-11-03','','5070','562','VIKAS KOTIAN','919164004222','','','ISHANI','ALAKE MANGALORE','','11','575003','NITA','918709192842','','UNITED INDIA INSURANCE CO LTD','P B NO 88 B H RD','','11','','Document','0.01','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-03 18:29:57','2025-11-03 18:29:57','17617213813089','17617213813089','','1829','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('583','8','1','','4','41616348','2025-11-03','441','450','511','UNION BANK OF INDIA PERMUDE (CORP BK)(1)','','','','1ST FLOOR, 10/A, CHANDRA KIRAN, POLICE STATION, OPP CUBBON PARK, Bengaluru Urban, 560001','PERMUDE','29AAACU0564G2ZC','11','574509','SUKUMAR NAIR A','','','U B I','SHIRTHADY','','11','574236','Document','0.00','0.00','0.00','0','Document','Surface','1','0.24','','','','','0.24','14.00','1','1','2025-11-03 18:30:44','2025-12-13 16:58:22','17617178859109','17617178859109','','3017','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','1','0','','','','','','1','');
INSERT INTO `booking` VALUES ('584','16','1','','4','41515299','2025-11-03','333','342','511','CANARA BANK THENKAYEDAPADAV','','','','5th Floor, 112, Canara Bank Head Office, JC Road, Town Hall Junction, Nagartapete, Bengaluru, Bengaluru Urban, , 560002','','29AAACC6106G1ZX','11','574151','CANARA BANK','','','RO','MANGALORE','','11','570001','Document','100.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','17.00','1','1','2025-11-03 18:30:48','2025-12-18 18:11:05','17617177578387','17617177578387','','3453','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','1','1','2025-12-18 18:11:05','','received','','','1','17645844402769');
INSERT INTO `booking` VALUES ('585','25','1','','2','3388852','2025-11-03','','5071','563','DEEPA TRADERS','919845460080','','','SKL','SKL','','11','575030','SUBHASH BOODI','919019540779','','MULTIMODES INDIA','MIDC TURBE','','14','400703','Document','100.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','100.00','1','1','2025-11-03 18:31:13','2025-11-03 18:31:13','17617202587270','17617202587270','','57','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('586','13','1','','2','3404019','2025-11-03','','5072','564','FIZA SEWING MACHINE','919546564690','','','MKT ROAD','','','11','575001','ERAM ELECTRICALS','919821678945','','OPP SURYAJI COMPOUND BYCULLA','','','14','400011','Document','10.00','0.00','0.00','0','Document','Surface','1','4.50','','','','','4.50','1410.00','1','1','2025-11-03 18:31:14','2025-11-03 18:31:14','17617147018423','17617147018423','','57','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('587','10','1','','2','3406730','2025-11-03','','5073','565','GIRISH S DABADE','918762018158','','','SBI AO','','','11','575004','ARUN V ANAND','918618643843','','JAYANAGAR','BANGALORE','','11','560011','Document','100.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-03 18:31:54','2025-11-03 18:31:54','17617151801089','17617151801089','UNITED INDIA INSRUANCE CO','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('588','17','1','','2','3404687','2025-11-03','','4980','511','S C S HOSPITAL PVT LTD','918242881100','','','UPPER BENDOOR','MANGALORE','','11','','MD INDIA HEALTH INS','','','NANJAPPA LAYOUT','ADUGODI','','11','560030','Document','0.00','0.00','0.00','0','Document','Surface','1','0.18','','','','','0.18','85.00','1','1','2025-11-03 18:31:57','2025-11-03 18:31:57','17617216042295','17617216042295','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('589','16','1','','4','41515300','2025-11-03','326','335','566','BIG BAGS INTERNATIONAL PVT LTD','','','','NO 8, EPIP INDUSTRIAL ESTATE, GUNJIMUTT, GUNJIMUTT, Dakshina Kannada, 574144','','29AABCB4004D1ZA','11','574151','ARSHAD','918000345552','','AIRLIFT PACIFIC','MAKARBA','','7','380015','Document','100.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','53.00','1','1','2025-11-03 18:32:43','2025-12-19 13:30:49','17617177578387','17617177578387','','3','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','1','0','','','','','','1','');
INSERT INTO `booking` VALUES ('590','20','1','','2','3418027','2025-11-03','','5074','567','SURESH J','919980440280','','','MANGALORE','','','11','575001','MALHOTHRA MARKETING PVT LTD','916290821120','','RAJAJINAGAR','','','11','560010','Document','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-03 18:32:52','2025-11-03 18:32:52','17616544937223','17616544937223','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('591','17','1','','4','41848293','2025-11-03','3916','3910','568','MOTILAL OSWAL FINANCIAL SERVICES LIMITED','919916246942','','','3rd FLOOR, MILESTONE-25 LAND TRADES BUILDER & DEVELOPERS, BALMATTA CIRCLE, MANGALORE-575001','','29AAECM2876P1ZN','11','575002','DHANANJAYA HEGDE','919845777210','','B/H LIC','KOPPAL KARWADI','','11','581343','Document','0.01','0.00','0.00','0','Document','Surface','1','0.45','','','','','0.45','78.00','1','1','2025-11-03 18:32:53','2025-12-13 16:58:22','17617216585187','17617216585187','GREEN RICHY','165','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','1','0','','','','','','1','');
INSERT INTO `booking` VALUES ('592','25','1','','2','3388853','2025-11-03','','5075','93','RAMYA','917411657434','','','SAS MOTORS','SURATHKAL','','11','574154','ABHIJEET','919620422492','','IDFC FIRST BANK','SARASWATHIPURAM MYSORE','','11','','Document','1000.00','0.00','0.00','0','Document','Surface','1','0.50','','','','','0.50','105.00','1','1','2025-11-03 18:33:12','2025-11-03 18:33:12','17617202587270','17617202587270','','669','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('593','6','1','','2','3381539','2025-11-03','','5076','569','SUMANA MOTORS','919845598128','','','AZZUDDIN RD','BUNDER','','11','575001','SWADEEP SUBBAIH','919448874010','','TATA COFFE LTD','POLIBETTA','','11','571215','Document','0.01','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-03 18:33:16','2025-11-03 18:33:16','17617213813089','17617213813089','','1088','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('594','23','1','','2','3408516','2025-11-03','','5077','570','MOHAMMED HAMEED','918951764833','','','PANDESHWWRA','MANGALORE','','23','','THE BRANCH MANAGER','918951764833','','THE CAMPCO LTD','BADIADKA','','12','','Document','100.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','70.00','1','1','2025-11-03 18:33:27','2025-11-03 18:33:27','17617218175043','17617218175043','','2794','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('595','21','1','','2','3393105','2025-11-03','','5078','571','ASIATC CARS','919449004909','','','KOTTARA','MLR','','11','575006','Y M RAFIQ','919632594494','','FRAZEER TOWN','KENCHAPPA RD','','11','560005','Document','100.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-03 18:33:38','2025-11-03 18:33:38','17617214622025','17617214622025','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('596','16','1','','4','41515301','2025-11-03','326','335','572','BIG BAGS INTERNATIONAL PVT LTD','','','','NO 8, EPIP INDUSTRIAL ESTATE, GUNJIMUTT, GUNJIMUTT, Dakshina Kannada, 574144','','29AABCB4004D1ZA','11','574151','S R SEWING TECH','919330885228','','WEST BENGAL','','','28','700037','Document','0.00','0.00','0.00','0','Document','Surface','1','0.20','','','','','0.20','66.00','1','1','2025-11-03 18:34:10','2025-12-19 13:30:49','17617177578387','17617177578387','','2666','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','1','0','','','','','','1','');
INSERT INTO `booking` VALUES ('597','22','1','','2','3411049','2025-11-03','','5079','573','RDL','919901405540','','','KADRI','LOBO LANE MANAGLURU','','11','575002','DR AIRANI','919945704039','','ADC','MAIN ROAD','','11','581401','Document','0.10','0.00','0.00','0','Document','Surface','1','0.65','','','','','0.65','125.00','1','1','2025-11-03 18:34:38','2025-11-03 18:34:38','17617169725275','17617169725275','','289','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('598','24','1','','2','3399465','2025-11-03','','5080','574','SOORYA LIFE CARE','919980237144','','','PUMPWELL','MANGALORE','','11','575002','GEETHA','919110278547','','KUTHPADY','UDUPI','','11','574118','Parcel','0.00','0.00','0.00','0','Document','Surface','1','0.10','','','','','0.10','80.00','1','1','2025-11-03 18:35:33','2025-11-03 18:35:33','17617227102844','17617227102844','','3452','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('599','25','1','','2','3388854','2025-11-03','','5081','93','SHARAYNYA ACHARYA','917892655493','','','HONDA MATRIX','SURATHKAL','','11','575014','ABHIJEET','919620422492','','IDFC FIRST BANK','SARASWATHIPURAM MYSORE','','11','','Document','0.00','0.00','0.00','0','Document','Surface','1','0.40','','','','','0.40','105.00','1','1','2025-11-03 18:35:39','2025-11-03 18:35:39','17617202587270','17617202587270','','669','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('600','17','1','','2','3404688','2025-11-03','','4980','511','S C S HOSPITAL PVT LTD','918242881100','','','UPPER BENDOOR','MANGALORE','','11','','VOLO HEALTH INS TPA PVT LTD','','','PHOENIC PINNACLE','','','11','560042','Document','0.00','0.00','0.00','0','Document','Surface','1','0.13','','','','','0.13','85.00','1','1','2025-11-03 18:35:52','2025-11-03 18:35:52','17617216042295','17617216042295','ULSOOR ROAD','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('601','16','1','','4','41515302','2025-11-03','367','376','511','SRI GOKARNANATH CO-OPERATIVE BANK LIMITED(KAI)','','','','1ST FLOOR, 8-2-138/110, SRI GURUKRIPA, SRI GOKARNANATH TEMPLE ROAD, KUDROLI, Dakshina Kannada,  575003','','29AAAAS5647N1ZU','11','575028','SRI GOKARNATHA CO-P BANK','','','KUDROLI','MANGALORE','','11','575003','Document','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','19.00','1','1','2025-11-03 18:36:22','2025-12-18 18:19:29','17617177578387','17617177578387','','3453','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','1','1','2025-12-18 18:19:29','','received','','','1','17645844402769');
INSERT INTO `booking` VALUES ('602','23','1','','4','41895973','2025-11-03','4162','4147','575','COASTAL EXPORTS CORPORATION,','','','','20-16-1082/2, Good Shed Road, Bunder ,Mangalore- 575001','','29AGXPM4263E1ZV','11','575001','DILIP TETAMBE','919821873726','','SOBER CHEMICALS','KHED','','14','415722','Document','100.00','0.00','0.00','0','Document','Surface','1','0.01','','','','','0.01','42.00','1','1','2025-11-03 18:36:31','2025-12-13 16:58:22','17617221297781','17617221297781','','277','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','1','0','','','','','','1','');
INSERT INTO `booking` VALUES ('603','10','1','','2','3406731','2025-11-03','','5082','576','CIVIL&CO CA','919743286184','','','DEREBAIL','MLR','','11','575006','ARAMANA HEART CENTRE','917994983489','','ASHWININAGAR','KASARGOD','','12','671121','Document','100.00','0.00','0.00','0','Document','Surface','1','0.17','','','','','0.17','95.00','1','1','2025-11-03 18:37:09','2025-11-03 18:37:09','17617151801089','17617151801089','','1062','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('604','12','1','','2','3382932','2025-11-03','','5083','511','KASHINATH','917022495981','','','HARSHA','FALNIR','','11','','PAI INTERNATIONAL','','','KUNDAPURA','','','11','','Document','0.02','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','50.00','1','1','2025-11-03 18:37:24','2025-11-03 18:37:24','17617206505387','17617206505387','','1588','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('605','17','1','','4','41848294','2025-11-03','3929','3923','577','RADHA MEDICALS DENTAL & SURGICAL DIVISION','918202529242','','','SAI RADHA STAR, OPP HITECH  HOSPITAL, AMBALPADY, UDUPI-576103','','29AAGFR4010B1ZP','11','575002','NARENDRA SHENOY','917022999199','','UMA OPTICALS','FISH MARKET','','11','576101','Document','0.01','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','46.00','1','1','2025-11-03 18:38:11','2025-12-13 16:58:22','17617216585187','17617216585187','','1639','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','1','0','','','','','','1','');
INSERT INTO `booking` VALUES ('606','14','1','','2','3364675','2025-11-03','','5084','578','NAVIN RAJ SHETTY','919916002806','','','ANTHYA ANUGRAHA HOUSE','KANKANADY','','11','575001','HEXADOX PHARMA','919886491193','','KADIRENAHALLI','SUBRAMANYAPURA','','11','560061','Document','0.01','0.00','0.00','0','Document','Surface','1','0.10','','','','','0.10','75.00','1','1','2025-11-03 18:38:18','2025-11-03 18:38:18','17617209872567','17617209872567','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('607','24','1','','2','3399466','2025-11-03','','5080','579','SOORYA LIFE CARE','919980237144','','','PUMPWELL','MANGALORE','','11','575002','VIJAYA','919241074401','','TUNGANAGAR GOPAL','SHIMOGA','','11','577205','Parcel','0.00','0.00','0.00','0','Document','Surface','1','0.25','','','','','0.25','90.00','1','1','2025-11-03 18:38:34','2025-11-03 18:38:34','17617227102844','17617227102844','','1829','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('608','16','1','','4','41515303','2025-11-03','375','384','580','VIBRANT POLYTECH PRIVATE LIMITED','','','','PLOT , GROUND FLOOR, SY NO.85/4, BADAGAULIPADY, EPIP INDUSTRIAL AREA, Ganjimutt,  574144','','29AAHCV1336J1Z2','11','574144','VISHU POLY PRODUCTS','919686570602','','PEENYA 2ND STAGE','BANGALORE','','11','560091','Document','0.00','0.00','0.00','0','Document','Surface','1','4.00','','','','','4.00','188.00','1','1','2025-11-03 18:38:58','2025-12-18 13:25:33','17617177578387','17617177578387','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','1','0','','','','','','1','');
INSERT INTO `booking` VALUES ('609','17','1','','2','3404689','2025-11-03','','5085','581','H DISILVA','919769964410','','','MANGALORE','','','11','575002','UMESH KARKERA','919820246048','','TTARUR BHARAT','CHKALA','','14','400059','Document','0.00','0.00','0.00','0','Document','Surface','1','0.01','','','','','0.01','100.00','1','1','2025-11-03 18:39:05','2025-11-03 18:39:05','17617216042295','17617216042295','','57','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('610','23','1','','4','41895974','2025-11-03','4162','4147','582','COASTAL EXPORTS CORPORATION,','','','','20-16-1082/2, Good Shed Road, Bunder ,Mangalore- 575001','','29AGXPM4263E1ZV','11','575001','SATISH','919980691143','','R S PHARMA','YELAHANKA NEW TOWN','','11','560064','Document','100.00','0.00','0.00','0','Document','Surface','1','0.01','','','','','0.01','40.00','1','1','2025-11-03 18:39:22','2025-12-13 16:58:23','17617221297781','17617221297781','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','1','0','','','','','','1','');
INSERT INTO `booking` VALUES ('611','25','1','','2','3388855','2025-11-03','','5086','583','GOVIDA RAJ','919543927798','','','KANA','SKL','','11','575030','BALA MURUGAN DRIVING SCHOOL','919442109859','','PARAMATHI ROAD','NKL','','23','637003','Document','100.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','70.00','1','1','2025-11-03 18:39:32','2025-11-03 18:39:32','17617202587270','17617202587270','','2424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('612','22','1','','2','3411050','2025-11-03','','5087','584','PRADEEP KUMAR SHETTY','919845150722','','','KADRI','MANGALURU','','11','575003','THE MANAGER','919844098440','','HDB FINANCIAL SERIVCES','CARSTREET  MANGALURU','','11','575001','Document','0.01','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','100.00','1','1','2025-11-03 18:40:06','2025-11-26 15:56:16','17617169725275','17617169725275','','3453','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('613','12','1','','2','3382933','2025-11-03','','5088','585','AROGYA MEDICAL','917760470180','','','FALNIR','MANGALORE','','11','','ASMA SAMREEN','919611689329','','HNA MANZIL','AYAN ALI NR CARLOT MANSION','','11','577101','Document','8850.00','0.00','0.00','0','Document','Surface','1','0.18','','','','','0.18','85.00','1','1','2025-11-03 18:41:01','2025-11-03 18:41:01','17617206505387','17617206505387','','186','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('614','13','1','','2','3404020','2025-11-03','','5091','588','VAINDA KAMATH','919632053446','','','MANGALORE','','','11','575001','B VENKATESH BHAKTA','919886047321','','SREENIKETN 10TH C CROSS','SAPTAGIRI EXTN T P KAILASAM ROAD','','11','572102','Document','10.00','0.00','0.00','0','Document','Surface','1','8.10','','','','','8.10','990.00','1','1','2025-11-03 18:41:27','2025-11-03 18:41:27','17617147018423','17617147018423','','1633','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('615','24','1','','2','3399467','2025-11-03','','5080','589','SOORYA LIFE CARE','919980237144','','','PUMPWELL','MANGALORE','','11','575002','RADHA','919744261095','','CHEMBRAKANAM THIMIRI PO','KASARAGOD','','12','671313','Parcel','0.00','0.00','0.00','0','Document','Surface','1','0.10','','','','','0.10','90.00','1','1','2025-11-03 18:41:40','2025-11-03 18:41:40','17617227102844','17617227102844','','3362','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('616','25','1','','2','3388856','2025-11-03','','5092','590','UMESH','918971037269','','','SKL','SKL','','11','575014','ASSOCIATED BULK MOVERS','917506331466','','TAGORE NAGAR','VIKHROLI EAST','','14','400083','Document','100.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','100.00','1','1','2025-11-03 18:41:53','2025-11-03 18:41:53','17617202587270','17617202587270','','57','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('617','10','1','','2','3406732','2025-11-03','','5094','593','SN ENTERPRISES','919535196433','','','BONDEL','MLR','','11','575008','VAYUNAND PHARMACY','919449946224','','ALUR','HASSAN','','11','573213','Document','5719.00','0.00','0.00','0','Document','Surface','1','6.40','','','','','6.40','770.00','1','1','2025-11-03 18:42:47','2025-11-03 18:42:47','17617151801089','17617151801089','BM ROAD','448','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('618','25','1','','2','3388857','2025-11-03','','5095','594','AUTO MATRIX','918879236096','','','SURATHKAL','','','11','575014','AUTO MATERIX','919980546614','','AMATRX','CHIKMANAGALUR','','11','577101','Document','0.00','0.00','0.00','0','Document','Surface','1','6.00','','','','','6.00','660.00','1','1','2025-11-03 18:42:58','2025-11-03 18:42:58','17617203788775','17617203788775','','186','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('619','20','1','','2','3418028','2025-11-03','','5096','595','SAVIL','919620681984','','','KODIALBAIL','','','11','575003','INDRA','919148474272','','FALLIKUNNU','','','12','670004','Document','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','70.00','1','1','2025-11-03 18:43:33','2025-11-03 18:43:33','17616544937223','17616544937223','','642','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('620','22','1','','2','3411051','2025-11-03','','5097','596','NEW ALL INDIA ROADLINES','919900001516','','','NANTHOOR','MANGALURU','','11','575004','SHREEJI RUBTECH P LTD','919821017979','','765 FLY EDGE  KARA KENDRA','S V ROAD','','14','400092','Document','0.10','0.00','0.00','0','Document','Surface','1','0.01','','','','','0.01','100.00','1','1','2025-11-03 18:43:48','2025-11-03 18:43:48','17617169725275','17617169725275','','57','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('621','23','1','','4','41895975','2025-11-03','4190','4175','597','JAIN COMPUTER','','','','GROUND FLOOR, 20-3-251/49, REGAL PARK, CASABA BAZAR MISSION STREET, MANGALORE-575001','','29AARFM2162N1ZL','11','575001','BRITE ELECTRONICS','919663403003','','S P ROAD','','','11','560002','Document','100.00','0.00','0.00','0','Document','Surface','1','0.40','','','','','0.40','65.00','1','1','2025-11-03 18:44:15','2025-12-13 16:58:23','17617221297781','17617221297781','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','1','0','','','','','','1','');
INSERT INTO `booking` VALUES ('622','17','1','','4','41848295','2025-11-03','3908','3903','598','MANGALORE NURSING HOME,','919980743460','','','UPPER BENDOOR, MANGALAORE-575002','','','11','575002','FAMILY HEALTH PLAN INS LTD','918749051018','','THIMMAIAH ROAD','VASANTH NAGAR','','11','560051','Document','0.01','0.00','0.00','0','Document','Surface','1','0.25','','','','','0.25','44.00','1','1','2025-11-03 18:44:29','2025-12-19 16:27:05','17617216585187','17617216585187','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','1','1','2025-12-19 16:27:05','','received','','','1','17617229594029');
INSERT INTO `booking` VALUES ('623','16','1','','2','3357230','2025-11-03','','5098','599','TAJ RESORT','918290670206','','','KAIKAMBA','MANGALORE','','11','574151','BNP INTERIORS','919967376554','','NEW LINK ROAD','WEST MUMBAI','','14','400053','Document','100.00','0.00','0.00','0','Document','Surface','1','0.13','','','','','0.13','130.00','1','1','2025-11-03 18:44:52','2025-11-03 18:52:24','17617177578387','17617177578387','','57','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('624','25','1','','2','3388858','2025-11-03','','5111','616','SENTHIL NATHAN','919448470900','','','SURATHKAL','','','11','575014','SIVAKUMAR','919845023357','','SUN BULK CARRIERS','MOHANUR ROAD','','23','637001','Document','0.00','0.00','0.00','0','Document','Surface','1','0.10','','','','','0.10','85.00','1','1','2025-11-03 18:45:36','2025-11-03 18:52:46','17617203788775','17617202587270','','2424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('625','24','1','','2','3399468','2025-11-03','','5080','600','SOORYA LIFE CARE','919980237144','','','PUMPWELL','MANGALORE','','11','575002','DEVARAJ K N','919148626425','','ARABAGATTA PO HONNALLI TQ','DAVANAGERE','','11','577217','Parcel','0.00','0.00','0.00','0','Document','Surface','1','0.23','','','','','0.23','90.00','1','1','2025-11-03 18:45:56','2025-11-04 13:09:47','17617227102844','17617227102844','','2592','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('626','23','1','','4','41895976','2025-11-03','4190','4175','601','JAIN COMPUTER','','','','GROUND FLOOR, 20-3-251/49, REGAL PARK, CASABA BAZAR MISSION STREET, MANGALORE-575001','','29AARFM2162N1ZL','11','575001','KFD TECHNOLOGIES','919738472424','','THIGFLARPET','S P ROAD','','11','560002','Document','100.00','0.00','0.00','0','Document','Surface','1','0.40','','','','','0.40','65.00','1','1','2025-11-03 18:46:23','2025-12-13 16:58:23','17617221297781','17617221297781','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','1','0','','','','','','1','');
INSERT INTO `booking` VALUES ('627','8','1','','4','41616349','2025-11-03','428','437','511','SHELL MRPL AVIATION FUELS AND SERVICES LIMITED (BAJPE)','','','','1ST FLOOR, 102, PRESTIGE SIGMA, VITTAL MALLYA ROAD, VITTAL MALLYA ROAD, Bengaluru Urban, 560001','','29AALCS7003B1ZI','11','','G SARVANI','','','ELICO MARKETING PVT LTD','KPHB KUKKATAPALLY','','44','500085','Non Doc','0.00','0.00','0.00','0','Document','Surface','1','0.89','','','','','0.89','155.00','1','1','2025-11-03 18:46:55','2025-12-17 16:21:27','17617178859109','17617229594029','','117','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','1','0','','','','','','1','');
INSERT INTO `booking` VALUES ('628','22','1','','2','3411052','2025-11-03','','5099','602','VISHAL GAS  AGENCY','919448375473','','','RGP COMPLEX','NANTHOOR  MANGALURU','','11','575004','SHANKAR AEGIS','919880601879','','NO29 6TH FLR  PRESTIUAGE MERIDAIN','ASHOKNAGAR','','11','560001','Document','0.10','0.00','0.00','0','Document','Surface','1','0.05','','','','','0.05','60.00','1','1','2025-11-03 18:46:59','2025-11-03 18:46:59','17617169725275','17617169725275','','1036','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('629','7','1','','2','3395035','2025-11-03','','5100','603','KALPESH  PANJARI','919033869159','','','KULAI','MANGALORE','','11','575019','MAVADIYA  KNIMJI','917016746095','','UDAYA NAGAR','RAJKOT','','7','360004','Document','0.00','0.00','0.00','0','Document','Surface','1','0.25','','','','','0.25','130.00','1','1','2025-11-03 18:46:59','2025-11-03 18:46:59','17617199828916','17617199828916','','491','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('630','10','1','','2','3406733','2025-11-03','','5101','604','KIRAN KUMAR SG','918105005144','','','MLR','','','11','575001','DEEPAK SALVIA','912266455954','','MAHAKALI CAVES ROAD','ANDHERI EAST','','14','400093','Document','100.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','100.00','1','1','2025-11-03 18:47:21','2025-11-03 18:47:21','17617151801089','17617151801089','SUN PHARMACEUTICAL IND LTD','57','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('631','26','1','','2','3400865','2025-11-03','','5102','605','haya gallaery','917411805537','','','grand city','thokkotu','','11','575018','sapnaz','917204524660','','wo nassir hussain','near water tank','','11','577101','Others','30.00','0.00','5.00','0','Parcel','Surface','1','0.10','','','','','0.10','75.00','1','1','2025-11-03 18:47:31','2025-11-22 14:53:23','17615707686074','1','','186','fancy item','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('632','12','1','','2','3382934','2025-11-03','','5103','606','KRISHNA CAR ASSESSIORIES','918123350665','','','KADRI','MANGALORE','','11','','RAJGURU CAR ACCESSORIES','919620029649','','6/17 MAYUR COMPLEX','JURNALIST COLONY JC ROAD','','11','560002','Document','0.00','0.00','0.00','0','Document','Surface','1','1.50','','','','','1.50','247.00','1','1','2025-11-03 18:48:04','2025-11-03 18:48:04','17617206505387','17617206505387','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('633','13','1','','2','3404021','2025-11-03','','5104','607','NAYAKS OPTICALS','918242423697','','','CARSR MANGALORE','','','11','575001','AYISHA FARIHA','918971645597','','BEHIND SULTHAN GOLD','','','11','575014','Document','10.00','0.00','0.00','0','Document','Surface','1','0.10','','','','','0.10','80.00','1','1','2025-11-03 18:48:19','2025-11-03 18:48:19','17617147018423','17617147018423','','3211','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('634','23','1','','4','41895977','2025-11-03','4172','4157','608','EDGAR INFOTECH','','','','3RD FLOOR, RAGHAVENDRA COMPLEX, NEAR A.B.SHETTY CIRCLE, PANDESHWAR, MANGALURU- 575001','','29ARLPJ8489L1ZO','11','575001','SHRI GURURAGHVENDRA CR CO-OP SOC','918202530800','','KADIYALI','','','11','576102','Document','100.00','0.00','0.00','0','Document','Surface','1','11.00','','','','','11.00','693.00','1','1','2025-11-03 18:48:53','2025-12-14 08:36:02','17617221297781','17617221297781','','1639','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','1','0','','','','','','1','');
INSERT INTO `booking` VALUES ('635','20','1','','2','3418029','2025-11-03','','5105','609','PRAKASH OFFSET','919741476157','','','KODIALBAIL','','','11','575003','PUNITH','919945514733','','BIBRANT ENT','','','11','570016','Document','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-03 18:49:35','2025-11-03 18:49:35','17616544937223','17616544937223','','669','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('636','23','1','','2','3408517','2025-11-03','','5106','610','LAXMAN SHETTIGAR','919448408921','','','PANDESHWARA','MANGALORE','','23','','SHRI MANIKANTH ASSOCIATES','919513756555','','UNKAL','','','11','','Document','100.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-03 18:50:05','2025-11-03 18:56:30','17617218175043','17617218175043','SIDDESHWARA NAGAR','557','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('637','23','1','','4','41895978','2025-11-03','4172','4157','608','EDGAR INFOTECH','','','','3RD FLOOR, RAGHAVENDRA COMPLEX, NEAR A.B.SHETTY CIRCLE, PANDESHWAR, MANGALURU- 575001','','29ARLPJ8489L1ZO','11','575001','SHRI GURURAGHVENDRA CR CO-OP SOC','918202530800','','KADIYALI','','','11','576102','Document','100.00','0.00','0.00','0','Document','Surface','1','11.00','','','','','11.00','693.00','1','1','2025-11-03 18:50:54','2025-12-14 08:36:02','17617221297781','17617221297781','','1639','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','1','0','','','','','','1','');
INSERT INTO `booking` VALUES ('638','17','1','','2','3404690','2025-11-03','','4980','511','S C S HOSPITAL PVT LTD','918242881100','','','UPPER BENDOOR','MANGALORE','','11','','GOOD HEALTH INS TPA LTD','','','SARDAR PATEL ROAD','','','24','500003','Document','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','70.00','1','1','2025-11-03 18:51:01','2025-11-03 18:51:01','17617216042295','17617216042295','','1824','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('639','17','1','','4','41848296','2025-11-03','3956','3950','611','TOTAL SHIPPING & LOGISTICS PVT.LTD,','919967830521','','','3RD FLOOR,PRESEDENCY ZONE 1,BENDOORWELL,MANGALURE-575002.','','29AABCT9850B1Z8','11','575002','PRAMODH','919742829552','','CARDOLITE SPECIALITY CHEMICALS','UNIT OF MSEZ','','11','574142','Document','0.01','0.00','0.00','0','Document','Surface','1','0.20','','','','','0.20','36.00','1','1','2025-11-03 18:51:13','2025-12-13 16:58:23','17617216585187','17617216585187','','3219','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','1','0','','','','','','1','');
INSERT INTO `booking` VALUES ('640','22','1','','2','3411053','2025-11-03','','5107','612','MALLIKATTA MEDICLAS','917204717711','','','KADRI','MALLIKATTA  MANGALURU','','11','575002','NISHWITH CHOWTA','919902774776','','AMAR DURG HOUSE','MAIN ROAD','','11','574214','Document','0.01','0.00','0.00','0','Document','Surface','1','0.45','','','','','0.45','85.00','1','1','2025-11-03 18:51:14','2025-11-03 18:51:14','17617169725275','17617169725275','','2580','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('641','10','1','','2','3406734','2025-11-03','','5108','613','V4 DIGITAL INFOTECH','919845101979','','','YEYYADI','MLR','','11','575008','SANATH KUMAR SHETTY','919731124402','','MALLESHWARAM','BANGALORE','','11','560003','Document','50.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-03 18:51:32','2025-11-03 18:51:32','17617151801089','17617151801089','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('642','24','1','','2','3399469','2025-11-03','','5109','614','MOHAMED ENOYATH','919632049734','','','KANNUR','MANGALORE','','11','','SHOBAN M','919986626226','','INDIRANAGAR','BANGALORE','','11','560038','Document','0.00','0.00','0.00','0','Document','Surface','1','0.01','','','','','0.01','60.00','1','1','2025-11-03 18:51:32','2025-11-03 18:51:32','17617227102844','17617227102844','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('643','21','1','','2','3393106','2025-11-03','','5110','93','CHETHAN','917975855372','','','KOTTARA','MLR','','11','575006','ABHIJEET','919620422492','','IDFC FIRST BANK','SARASWATHIPURAM MYSORE','','11','570009','Document','100.00','0.00','0.00','0','Document','Surface','1','0.59','','','','','0.59','125.00','1','1','2025-11-03 18:52:10','2025-11-03 18:52:10','17617214622025','17617214622025','','669','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('644','23','1','','4','41895979','2025-11-03','4172','4157','615','EDGAR INFOTECH','','','','3RD FLOOR, RAGHAVENDRA COMPLEX, NEAR A.B.SHETTY CIRCLE, PANDESHWAR, MANGALURU- 575001','','29ARLPJ8489L1ZO','11','575001','POTTERS COTTAHE IND CO-OP SOC','918495031042','','OLD FISH MARKET','','','11','576213','Document','100.00','0.00','0.00','0','Document','Surface','1','11.00','','','','','11.00','693.00','1','1','2025-11-03 18:52:45','2025-12-14 08:36:02','17617221297781','17617221297781','','1470','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','1','0','','','','','','1','');
INSERT INTO `booking` VALUES ('645','26','1','','2','3400866','2025-11-03','','5057','617','pavithra oil','919986466324','','','tkt','mlr','','11','','manjunatha ug','918197246758','','ujjappa gs','nyamathi','','11','','Document','0.00','0.00','0.00','0','Document','Surface','1','0.10','','','','','0.10','75.00','1','1','2025-11-03 18:53:03','2025-11-03 18:53:03','17615707686074','17615707686074','','2592','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('646','20','1','','2','3418030','2025-11-03','','5112','618','VINAYAK','919353387934','','','KODIALBAIL','','','11','575003','LOKESH','918073872134','','HOSAKOPPAL','','','11','573201','Document','0.00','0.00','0.00','0','Document','Surface','1','0.59','','','','','0.59','125.00','1','1','2025-11-03 18:53:13','2025-11-03 18:53:13','17616544937223','17616544937223','','448','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('647','13','1','','2','3404022','2025-11-03','','5113','619','HARSHITA','918123790255','','','BHAGA NAGAR','','','11','575001','SHUBHA K C','919663411333','','AMBICA NAGAR','','','11','59006','Document','10.00','0.00','0.00','0','Document','Surface','1','0.90','','','','','0.90','160.00','1','1','2025-11-03 18:53:24','2025-11-03 18:53:24','17617147018423','17617147018423','AHOVE NAGAR','4','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('648','14','1','','2','3364676','2025-11-03','','5114','438','BHARATH COOP BK','910000000000','','','BHARATH COOP BK','KS RD','','11','575001','BHARATH BK','910000000000','','AMAR EMPIRE','KHANAPUR RD','','11','590001','Document','0.00','0.00','0.00','0','Document','Surface','1','0.05','','','','','0.05','60.00','1','1','2025-11-03 18:53:46','2025-11-03 18:53:46','17617211328319','17617211328319','','3078','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('649','10','1','','2','3406735','2025-11-03','','5108','620','V4 DIGITAL INFOTECH','919845101979','','','YEYYADI','MLR','','11','575008','PRAVEEN PUTTANA','919008026144','','TV9 KARNATAKA P LTD','RICHMOND TOWN','','11','560025','Document','50.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-03 18:54:02','2025-11-03 18:54:02','17617151801089','17617151801089','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('650','17','1','','2','3404691','2025-11-03','','5115','621','S A TOURISM','918722570303','','','MANGALORE','','','11','575002','BHATKAL TRAVEL HOUSE','919740838666','','NEXT TO TV S SHOWROOM','','','11','581320','Document','0.01','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-03 18:54:33','2025-11-03 18:54:33','17617216042295','17617216042295','','1689','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('651','23','1','','2','3408518','2025-11-03','','5116','622','SUNIL','919880159929','','','RTO','PANDESHWARA','','23','','MANJUNATH','919035167747','','AVALAHALLI MAIN ROIAD','MYSORE ROAD','','11','560026','Document','100.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-03 18:54:34','2025-11-03 18:54:34','17617218175043','17617218175043','SLV ENTERPRISES','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('652','18','1','','2','3385037','2025-11-03','','5117','623','VIDYA SHENOY','919480100955','','','DAMODAR ENTERPRESS','KULUR','','11','575013','VINYA KINI','919535071529','','HOTEL  SRINIVAS','NEYAR KADIYATE BUS  STPO','','11','576102','Document','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','50.00','1','1','2025-11-03 18:55:22','2025-11-03 18:55:22','17617174764463','17617174764463','','1639','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('653','26','1','','2','3400867','2025-11-03','','5057','624','pavithra oil','919986466324','','','tkt','mlr','','11','','sudha shetty','919663054017','','devanahalli','','','11','562127','oil','100.00','0.00','0.00','0','Document','Surface','1','0.10','','','','','0.10','75.00','1','1','2025-11-03 18:56:01','2025-11-03 18:56:01','17615707686074','17615707686074','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('654','16','1','','4','41515304','2025-11-03','320','329','625','AMOG GARMENTS ( KAI)','919986772449','','','5-90, CHAMANI ROAD, GURPUR, Dakshina Kannada, Karnataka, 574145','','29ADKPP8521A1ZI','11','574151','MADHU SEWING','919845296577','','VIDYANAGARA','BANGALORE','','11','560023','Document','500.00','0.00','0.00','0','Document','Surface','1','2.00','','','','','2.00','241.00','1','1','2025-11-03 18:56:07','2025-12-13 16:58:23','17617177578387','17617177578387','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','1','0','','','','','','1','');
INSERT INTO `booking` VALUES ('655','10','1','','2','3406736','2025-11-03','','5108','626','V4 DIGITAL INFOTECH','919845101979','','','YEYYADI','MLR','','11','575008','SUNOJ KUMAR','917829686555','','JIO STAR','EDAPALLY','','12','682021','Document','50.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','70.00','1','1','2025-11-03 18:56:17','2025-11-03 18:56:17','17617151801089','17617151801089','','1761','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('656','17','1','','4','41848297','2025-11-03','3848','3850','627','ASHRAYA TECHNOLOGIES','919731347444','','','D.NO.15-20-1227/72, SHOP NO.19&20 ESSEL WILLCON 2ND FLOOR BENDOORWELL MANGALORE-575002','','29AJCPD4592M1ZT','11','575002','ASHRAYA TECHNOLOGIES','919964517195','','DUO ENCLAVE','KODICHIKKANAHALLI','','11','560076','Document','0.01','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','46.00','1','1','2025-11-03 18:57:01','2025-12-20 12:38:54','17617216585187','17617216585187','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','1','1','2025-12-20 12:38:54','','received','','','1','17645841409774');
INSERT INTO `booking` VALUES ('657','22','1','','2','3411054','2025-11-03','','5107','628','MALLIKATTA MEDICLAS','917204717711','','','KADRI','MALLIKATTA  MANGALURU','','11','575002','SUMAYYA','917994857758','','BEDRUKUDLU HOUSE','BADIADKA','','12','671551','Document','0.01','0.00','0.00','0','Document','Surface','1','0.05','','','','','0.05','70.00','1','1','2025-11-03 18:57:08','2025-11-03 18:57:08','17617169725275','17617169725275','','1062','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('658','20','1','','2','3418031','2025-11-03','','5118','629','UMESH','919448215137','','','KODIALBAIL','','','11','575003','RANJAN','919632819377','','KUMARA PARK','','','11','560020','Document','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-03 18:57:10','2025-11-03 18:57:10','17616544937223','17616544937223','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('659','23','1','','4','41895980','2025-11-03','4172','4157','630','EDGAR INFOTECH','','','','3RD FLOOR, RAGHAVENDRA COMPLEX, NEAR A.B.SHETTY CIRCLE, PANDESHWAR, MANGALURU- 575001','','29ARLPJ8489L1ZO','11','575001','MADANTHYAR PACS LTD','919448815438','','BELTHANGADY TQ','','','11','574224','Document','100.00','0.00','0.00','0','Document','Surface','1','11.00','','','','','11.00','693.00','1','1','2025-11-03 18:57:22','2025-12-14 08:36:02','17617221297781','17617221297781','','851','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','1','0','','','','','','1','');
INSERT INTO `booking` VALUES ('660','13','1','','2','3404023','2025-11-03','','5119','631','SHIVAM MUSIC','919945559533','','','MARKET ROAD','','','11','575001','RAMANAND K','919353059967','','AKARSH FANCY','','','11','574229','Document','10.00','0.00','0.00','0','Document','Surface','1','0.19','','','','','0.19','80.00','1','1','2025-11-03 18:57:42','2025-11-03 18:57:42','17617147018423','17617147018423','','3451','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('661','17','1','','2','3404692','2025-11-03','','5115','632','S A TOURISM','918722570303','','','MANGALORE','','','11','575002','city travel and torus','919611127321','','JANARDHAN COMPLEX','','','11','574106','Document','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-03 18:57:42','2025-11-26 16:01:53','17617216042295','17617216042295','','1639','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('662','26','1','','2','3400868','2025-11-03','','5057','633','pavithra oil','919986466324','','','tkt','mlr','','11','','chanabasappa rb','919964675857','','nr police stn','','','11','581110','oil','0.00','0.00','0.00','0','Document','Surface','1','0.10','','','','','0.10','75.00','1','1','2025-11-03 18:57:55','2025-11-03 18:57:55','17615707686074','17615707686074','','314','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('663','12','1','','2','3382935','2025-11-03','','5120','634','PRAGATHI CABLE SERVICES','919482099281','','','ATTTAVARA','MANGALORE','','11','575001','STAR INFOMATIC PVT LTD','917042824884','','OFFICE NO 11','ST MARKS ROAD','','11','560001','Electronic Items','0.00','0.00','0.00','0','Document','Surface','1','5.80','','','','','5.80','660.00','1','1','2025-11-03 18:58:04','2025-11-03 18:58:04','17617206505387','17617206505387','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('664','22','1','','2','3411055','2025-11-03','','5107','635','MALLIKATTA MEDICLAS','917204717711','','','KADRI','MALLIKATTA  MANGALURU','','11','575002','A PREETHI','918197530642','','SHAILINI DENTAL CLINIC','BELAVI','','11','574213','Document','0.00','0.00','0.00','0','Document','Surface','1','0.05','','','','','0.05','50.00','1','1','2025-11-03 18:58:42','2025-11-03 18:58:42','17617169725275','17617169725275','','1068','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('665','10','1','','2','3406737','2025-11-03','','5121','636','K BALAKRISHNAN','918660962719','','','MECON LTD','PANMABUR','','11','575010','BOT MECON LTD FS','919900365478','','DORANDA','RAANCHI','','10','834002','Document','100.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','100.00','1','1','2025-11-03 18:59:17','2025-11-03 18:59:17','17617151801089','17617151801089','','678','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('666','23','1','','4','41895981','2025-11-03','4172','4157','637','EDGAR INFOTECH','','','','3RD FLOOR, RAGHAVENDRA COMPLEX, NEAR A.B.SHETTY CIRCLE, PANDESHWAR, MANGALURU- 575001','','29ARLPJ8489L1ZO','11','575001','SHRI GURUGAHVENDRA CR CO-OP','918202530860','','KADIYALI','','','11','576102','Document','100.00','0.00','0.00','0','Document','Surface','1','11.00','','','','','11.00','693.00','1','1','2025-11-03 18:59:24','2025-12-14 08:36:02','17617221297781','17617221297781','','1639','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','1','0','','','','','','1','');
INSERT INTO `booking` VALUES ('667','23','1','','2','3408519','2025-11-03','','5122','638','JOINT DIRECTOR OF FISHERIERS','919880923401','','','BUNDER','MANGALORE','','23','','NAVIGUN PVT LTD','919656106778','','VALLIKEEZU KABANAD','00','','12','691003','Document','100.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','70.00','1','1','2025-11-03 18:59:37','2025-11-03 18:59:37','17617218175043','17617218175043','NEEN ARCADE','650','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('668','25','1','','2','3388859','2025-11-03','','5123','639','MOHAMMED ALI','919845171151','','','7TH BLOCK','KRISHNAPUR','','11','575014','RAFIQ','919845329305','','AL AMEEN MOTOR WORKS','NR RV COLLEGE OPP MP PETROL BUNK','','11','560059','Document','0.10','0.00','0.00','0','Document','Surface','1','0.01','','','','','0.01','60.00','1','1','2025-11-03 18:59:51','2025-11-03 18:59:51','17617202587270','17617202587270','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('669','26','1','','2','3400869','2025-11-03','','5057','640','pavithra oil','919986466324','','','tkt','mlr','','11','','keerthana','917975029693','','g pr rd','g p r','','11','','oil','100.00','0.00','0.00','0','Document','Surface','1','0.10','','','','','0.10','75.00','1','1','2025-11-03 19:00:14','2025-11-03 19:00:14','17615707686074','17615707686074','','37','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('670','17','1','','2','3404693','2025-11-03','','5124','641','J GANGADHAR','919480660555','','','MANGALORE','','','11','575002','SUJITH','919900327473','','S L V MOTORS','TALAPDY','','11','574219','Document','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','50.00','1','1','2025-11-03 19:01:02','2025-11-03 19:01:02','17617216042295','17617216042295','','1006','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('671','22','1','','2','3411056','2025-11-03','','5107','642','MALLIKATTA MEDICLAS','917204717711','','','KADRI','MALLIKATTA  MANGALURU','','11','575002','GEETHA','917760056705','','NANDINI NIVASA','KURYALA   BANTWALA','','11','574211','Document','0.10','0.00','0.00','0','Document','Surface','1','0.10','','','','','0.10','65.00','1','1','2025-11-03 19:01:33','2025-11-03 19:01:33','17617169725275','17617169725275','','1006','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('672','17','1','','4','41848298','2025-11-03','3875','3874','643','ESSKAY AGENCIES','919886105444','','','SHOP NO.21,2ND FLOOR, ESSEL WILCON,BENDOORWELL,MANGALORE-575005','','29AAAPB8352N1ZG','23','600002','ESSKAY AGENCIES','914428419131','','RAHEJA COMPLEX','ANNA SALAI','','23','60002','Document','0.01','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','70.00','1','1','2025-11-03 19:01:38','2025-12-20 13:01:37','17617216585187','17617216585187','','1931','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','1','1','2025-12-20 13:01:37','','received','','','1','17645841409774');
INSERT INTO `booking` VALUES ('673','23','1','','4','41895982','2025-11-03','4172','4157','644','EDGAR INFOTECH','','','','3RD FLOOR, RAGHAVENDRA COMPLEX, NEAR A.B.SHETTY CIRCLE, PANDESHWAR, MANGALURU- 575001','','29ARLPJ8489L1ZO','11','575001','PADUPANAMBUR SAHAKARI VYAVASAYA SANGHA','919900728360','','NEAR MARKET RD','','','11','576102','Document','100.00','0.00','0.00','0','Document','Surface','1','11.00','','','','','11.00','693.00','1','1','2025-11-03 19:01:53','2025-12-14 08:36:02','17617221297781','17617221297781','','1091','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','1','0','','','','','','1','');
INSERT INTO `booking` VALUES ('674','26','1','','2','3400870','2025-11-03','','5057','645','pavithra oil','919986466324','','','tkt','mlr','','11','','mohd rafi','919148636060','','sindhanur rd','','','11','584124','oil','0.00','0.00','0.00','0','Document','Surface','1','0.10','','','','','0.10','75.00','1','1','2025-11-03 19:02:29','2025-11-03 19:02:29','17615707686074','17615707686074','','134','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('675','10','1','','2','3406738','2025-11-03','','5125','646','HANMANTHA','919535153513','','','MLR','MLR','','11','','GANESH','917624946626','','KYASANKERI','MUNDGOD','','11','581349','Document','500.00','0.00','0.00','0','Document','Surface','1','0.05','','','','','0.05','60.00','1','1','2025-11-03 19:02:39','2025-11-03 19:02:39','17617151801089','17617151801089','','892','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('676','22','1','','2','3411057','2025-11-03','','5107','647','MALLIKATTA MEDICLAS','917204717711','','','KADRI','MALLIKATTA  MANGALURU','','11','575002','VASTHARA LADIES FASHIONS','917899254758','','OPP POLICE STATION','','','11','577111','Document','0.10','0.00','0.00','0','Document','Surface','1','0.20','','','','','0.20','85.00','1','1','2025-11-03 19:03:12','2025-11-03 19:03:12','17617169725275','17617169725275','','3153','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('677','13','1','','2','3404024','2025-11-03','','5126','648','SUNTEC','918242411234','','','CARST','MANGALAORE','','11','575001','GANESH PRINERS','919481140998','','GANDHINAGAR','','','11','574239','Document','10.00','0.00','0.00','0','Document','Surface','1','0.05','','','','','0.05','50.00','1','1','2025-11-03 19:03:43','2025-11-03 19:03:43','17617147018423','17617147018423','','2577','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('678','23','1','','4','41895983','2025-11-03','4172','4157','649','EDGAR INFOTECH','','','','3RD FLOOR, RAGHAVENDRA COMPLEX, NEAR A.B.SHETTY CIRCLE, PANDESHWAR, MANGALURU- 575001','','29ARLPJ8489L1ZO','11','575001','VIJAYA CR CO-OP SOC','917337844299','','BUNTARA BHAVANA','','','11','574217','Document','100.00','0.00','0.00','0','Document','Surface','1','11.00','','','','','11.00','693.00','1','1','2025-11-03 19:03:44','2025-12-14 08:36:02','17617221297781','17617221297781','','3448','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','1','0','','','','','','1','');
INSERT INTO `booking` VALUES ('679','18','1','','2','3385038','2025-11-03','','5127','650','R. GOPIRAM','919480571171','','','AIRPORT  ROAD','PADVINAGADY','','11','575008','R VIGNESH  PRABHU','919842665686','','POHSAPARTMENTS','RATNAVEL  PADAIAN','','23','600107','Document','0.00','0.00','0.00','0','Document','Surface','1','0.59','','','','','0.59','140.00','1','1','2025-11-03 19:03:58','2025-11-03 19:03:58','17617174764463','17617174764463','','1931','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('680','17','1','','2','3404694','2025-11-03','','5128','511','M C GANESH','919341335333','','','BENDOORWELL','','','11','575001','THE TASILDAR','','','MAGISTRATE','','','11','571234','Document','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-03 19:04:28','2025-11-03 19:04:28','17617216042295','17617216042295','','54','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('681','25','1','','2','3388860','2025-11-03','','5129','651','JYOTHISHA MITHRA ONLINE','911998667143','','','HATHWAR COMPLEX','HOSABETTU','','11','575019','MANASVINATHASWAMI','917975988826','','SACST BANANDUR','BIDADI IND AREA','','11','562109','Document','0.00','0.00','0.00','0','Document','Surface','1','0.01','','','','','0.01','60.00','1','1','2025-11-03 19:04:34','2025-11-03 19:04:34','17617202587270','17617202587270','','1131','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('682','26','1','','2','3400871','2025-11-03','','5057','652','pavithra oil','919986466324','','','tkt','mlr','','11','','sayed sadik','919739596313','','mkt rd','','','11','','oil','0.00','0.00','0.00','0','Document','Surface','1','0.10','','','','','0.10','75.00','1','1','2025-11-03 19:04:36','2025-11-03 19:04:36','17615707686074','17615707686074','','859','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('683','23','1','','2','3408520','2025-11-03','','5130','653','HAJI U K EBRAHIM & SONS','919448480482','','','BUNDER','MANGALORE','','23','','S M MARINE PRODUCTS','919342568090','','ESSEL WILLCON BENDOORWELL','KANKANDAY','','11','575002','Document','100.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','100.00','1','1','2025-11-03 19:04:59','2025-11-26 15:56:16','17617218175043','17617218175043','','3453','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('684','17','1','','4','41848299','2025-11-03','3940','3934','654','S.M MARINE PRODUCTS','917353978698','','','ESSEL WILCON,2ND FLOOR,BENDOORWELL CIRCLE,KANKANADY MANGALORE-02','','29ABGFS4895L1Z8','11','575002','ANFAL MARINE PRODUCTS','919035377748','','COLLEGE ROAD','ANKOLA','','11','581314','Document','0.01','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','38.00','1','1','2025-11-03 19:05:28','2025-12-13 16:58:23','17617216585187','17617216585187','','712','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','1','0','','','','','','1','');
INSERT INTO `booking` VALUES ('685','22','1','','2','3411058','2025-11-03','','5131','655','SHASHANK RAO','916332340944','','','LAND LINKS KONCHADY','MANGALURU','','11','575008','V GURAD MARKETING OFFICE','919535090622','','JEEVANBHIMANAGAR','HAL 3RD STAGE','','11','560075','Document','0.01','0.00','0.00','0','Document','Surface','1','0.05','','','','','0.05','60.00','1','1','2025-11-03 19:06:06','2025-11-03 19:06:06','17617169725275','17617169725275','','1036','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('686','13','1','','2','3404025','2025-11-03','','5132','656','MPEE SILKS','919060502055','','','MKT ROAD','MKT ROAD','','11','575001','VIJAY SILK HOUSE','919443415197','','ANANDHANAPTTI CARI STRET','','','23','636006','Document','10.00','0.00','0.00','0','Document','Surface','1','0.05','','','','','0.05','70.00','1','1','2025-11-03 19:07:02','2025-11-03 19:07:02','17617147018423','17617147018423','','1815','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('687','10','1','','2','3406739','2025-11-03','','5133','657','RAINBOW CES','919741967270','','','BEJAI','MLR','','11','575004','NANJAPPA CV','919448316144','','AGRAHARA STREET','CHAMARAJNAGAR','','11','571313','Document','100.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-03 19:07:05','2025-11-03 19:07:05','17617151801089','17617151801089','','184','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('688','6','1','','2','3381540','2025-11-03','','5134','658','SUN MATRIX','919632380128','','','INVENGER TOWER','BALLALBAGH','','11','575003','GOURI SRINIVAS','919980918889','','NEXT TO KONANKUNTE CROSS','METRO STATION','','11','560062','Document','-0.01','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-03 19:07:19','2025-11-03 19:07:19','17617213813089','17617213813089','GOPALAN JEWELS APT','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('689','17','1','','2','3404695','2025-11-03','','5135','873','UDAYA KUMAR SHETTY','919845305867','','','BUNTS HOSTEL ROAD','MANGALORE','','11','575003','K S R T C','919845305867','','DIVISIONAL CONTROLLER','MANGALORE','','11','575001','Document','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','35.00','1','1','2025-11-03 19:07:36','2025-11-26 15:56:16','17617216042295','17617216042295','','3453','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('690','23','1','','2','3408521','2025-11-03','','5136','659','FRANCIC','919739577089','','','ZEE CODE','MANGALOre','','23','','gururaj','917975317697','','7th main road','hrbr layout  kalyan nnagar','','11','560043','Document','100.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-03 19:07:43','2025-11-03 19:07:43','17617218175043','17617218175043','ze code','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('691','25','1','','2','3388861','2025-11-03','','5137','660','JYOTHISHA MITHRA','919986671473','','','HOSABETTU','','','11','575019','VINAY','919008744232','','DAIMOND JUBLI HOSTEL','SREE SIDDAGANGA MATH','','11','572104','Document','0.01','0.00','0.00','0','Document','Surface','1','0.01','','','','','0.01','60.00','1','1','2025-11-03 19:07:48','2025-11-03 19:07:48','17617202587270','17617202587270','','1633','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('692','12','1','','2','3382936','2025-11-03','','5138','511','LISSY','918247743166','','','TENET DIAGNO','FALNIR MANGALORE','','11','575001','ACCOUNTS DEPARTMENT','','','TENET DIAGNO','JAYANAGARA','','11','560070','Document','100.00','0.00','0.00','0','Document','Surface','1','0.12','','','','','0.12','85.00','1','1','2025-11-03 19:08:18','2025-11-03 19:08:18','17617206505387','17617206505387','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('693','16','1','','4','41515305','2025-11-03','334','343','511','CANARA BANK VAMANJOOR','','','','5th Floor, 112, Canara Bank Head Office, JC Road, Town Hall Junction, Nagartapete, Bengaluru, Bengaluru Urban,  560002','','29AAACC6106G1ZX','11','575028','CANARA BANK','','','HUDSON CIRCLE','BANGALORE','','11','560001','Document','100.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','18.00','1','1','2025-11-03 19:08:32','2025-12-18 18:12:26','17617177578387','17617177578387','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','1','1','2025-12-18 18:12:26','','received','','','1','17645844402769');
INSERT INTO `booking` VALUES ('694','22','1','','2','3411059','2025-11-03','','5139','661','S K DISTRIBUTORS','916363261004','','','THE CANARAWORKSHOP COMPOUND','MAROLI MANGALURU','','11','575005','JYOTHI','918049099127','','JAQUAR & CO','REISDENCY ROAD','','11','560025','Document','0.01','0.00','0.00','0','Document','Surface','1','0.05','','','','','0.05','60.00','1','1','2025-11-03 19:08:37','2025-11-03 19:08:37','17617169725275','17617169725275','','1036','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('695','17','1','','4','41848300','2025-11-03','4491','4796','662','YENEPOYA PHARMACEUTICALS AND SURGICALS','917259468855','','','15-3-111/10/11/16, Yenepoya Chember, Near Collectors Gate, Balmatta, Mangaluru,  575002','','29AABFY4656P1ZA','11','575002','GLAXO SMITHCLINE PHARMA LTD','919128600693','','K M MYSORE ROAD','BLR','','11','560059','Document','0.01','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','45.00','1','1','2025-11-03 19:08:37','2025-12-20 12:09:02','17617216585187','17617216585187','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','1','1','2025-12-20 12:09:02','','received','','','1','17645841409774');
INSERT INTO `booking` VALUES ('696','20','1','','2','3418032','2025-11-03','','5140','663','DAYANANDA SHETTY','917338504882','','','MANGALORE','','','11','575003','THANVI','919901877898','','JAWHAR NAVODAYA VIDYALAYA','','','11','','Document','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','50.00','1','1','2025-11-03 19:09:19','2025-11-03 19:09:19','17616544937223','17616544937223','','3175','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('697','13','1','','2','3404026','2025-11-03','','5132','664','MPEE SILKS','919060502055','','','MKT ROAD','MKT ROAD','','11','575001','SHEETAL CRETIONS','919342320763','','A M LANE','','','11','560053','Document','10.00','0.00','0.00','0','Document','Surface','1','0.05','','','','','0.05','60.00','1','1','2025-11-03 19:09:25','2025-11-03 19:09:25','17617147018423','17617147018423','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('698','24','1','','2','3399470','2025-11-03','','5141','665','JANAPRIYA HOSPITAL','918970997979','','','KODAKKAL, PADIL','MANGALORE -','','11','575007','DIST STATICTICAL OFFICER,','918150980633','','KALYANI RAM PALACE','KOTTARA, MANGALORE','','11','575006','Document','0.00','0.00','0.00','0','Document','Surface','1','0.01','','','','','0.01','40.00','1','1','2025-11-03 19:09:56','2025-11-26 15:56:16','17617227922084','17617227922084','','3453','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('699','7','1','','2','3395036','2025-11-03','','5142','666','BASKAR','919900421318','','','KULAI','MANGALORE','','11','575011','ELTHOR  ENERGY  P LTD','919900421318','','KORAMANGALA','BANGALORE','','11','560095','Document','0.00','0.00','0.00','0','Document','Surface','1','0.28','','','','','0.28','105.00','1','1','2025-11-03 19:09:57','2025-11-03 19:09:57','17617199828916','17617199828916','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('700','17','1','','2','3404696','2025-11-03','','5124','667','J GANGADHAR','919480660555','','','MANGALORE','','','11','575002','KUMAR J P','918660094829','','VRUSHVVTHINAGRA','KAMKSHIPALYA','','11','','Document','0.00','0.00','0.00','0','Document','Surface','1','0.35','','','','','0.35','105.00','1','1','2025-11-03 19:10:05','2025-11-03 19:10:05','17617216042295','17617216042295','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('701','23','1','','2','3408522','2025-11-03','','5130','668','HAJI U K EBRAHIM & SONS','919448480482','','','BUNDER','MANGALORE','','23','','bawa fishmeal & oil co','918242420521','','a b shetty circle','00','','11','575001','Document','100.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','100.00','1','1','2025-11-03 19:11:01','2025-11-26 15:56:16','17617218175043','17617218175043','pandeshwara','3453','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('702','22','1','','2','3411060','2025-11-03','','5143','669','J MURALI MAHESHWARI','917899690575','','','HSKATHI NAGAR','MANGALURU','','11','575016','SANDEEP CREATION','911804114330','','D K LANE','CHICKPET  CROSS','','11','560009','Document','0.10','0.00','0.00','0','Document','Surface','1','0.10','','','','','0.10','75.00','1','1','2025-11-03 19:11:33','2025-11-03 19:11:33','17617169725275','17617169725275','','1036','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('703','10','1','','2','3406740','2025-11-03','','5144','670','WIND TECH SYSTEMS','917829589966','','','BAREBAIL BEJAI','MLR','','11','575004','BANK OF BARODA RO','919495926064','','BM ROAD','HASSAN','','11','573201','Document','100.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-03 19:11:36','2025-11-03 19:11:36','17617151801089','17617151801089','','448','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('704','13','1','','2','3404027','2025-11-03','','5132','671','MPEE SILKS','919060502055','','','MKT ROAD','MKT ROAD','','11','575001','M TEX','919880669600','','SINGHVEE COMPLEX','CHICKPETE','','11','560053','Document','10.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-03 19:11:36','2025-11-03 19:11:36','17617147018423','17617147018423','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('705','25','1','','2','3388862','2025-11-03','','5137','672','JYOTHISHA MITHRA','919986671473','','','HOSABETTU','','','11','575019','VENKATESH','917619551656','','NAVADI BUILDING','OPP SHRI RAM TEMPLE','','11','582207','Document','10.00','0.00','0.00','0','Document','Surface','1','0.23','','','','','0.23','85.00','1','1','2025-11-03 19:11:41','2025-11-03 19:11:41','17617202587270','17617202587270','','546','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('706','6','1','','2','3381541','2025-11-03','','5145','673','INVENGER TECHNOLOGIES PVT LTD','918244232777','','','INVENGER TOWER','BALLALBAGH','','11','575003','THE DIRECTOR','914422542236','','CIT CAMPUS','TARAMANI','','23','600113','Document','-0.01','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','70.00','1','1','2025-11-03 19:11:44','2025-11-03 19:11:44','17617213813089','17617213813089','BOARD OF APPRENTICESHIP TRAINING','1931','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('707','7','1','','2','3395037','2025-11-03','','5146','674','CARRYFOUR  LOGISTICS','919945261444','','','BAIKAMPADY','MANGALORE','','11','575011','DRUVDESH  METASTEEL  P LTD','919014477789','','GINGERA','KOPPAL','','11','583231','Document','0.00','0.00','0.00','0','Document','Surface','1','0.01','','','','','0.01','60.00','1','1','2025-11-03 19:12:06','2025-11-03 19:12:06','17617199828916','17617199828916','','394','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('708','24','1','','2','3399471','2025-11-03','','5141','675','JANAPRIYA HOSPITAL','918970997979','','','KODAKKAL, PADIL','MANGALORE -','','11','575007','THE CHIEF REGISTRAR OF BIRTHS & DEATHS','918100008777','','DR B R AMBEDKAR VEEDHI','BANGALORE -  01','','11','560001','Document','0.00','0.00','0.00','0','Document','Surface','1','0.01','','','','','0.01','60.00','1','1','2025-11-03 19:12:46','2025-11-03 19:43:32','17617227922084','17617227922084','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('709','18','1','','2','3385039','2025-11-03','','5147','676','ARUN KUMAR','919380970695','','','NELAMANGALA','BANGALORE','','11','','HINDUSTAN  TARNSPORT','919741519252','','G K  COMPLEX','NEAR  RAILWAY  BRIGDGE','','11','','Document','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','50.00','1','1','2025-11-03 19:12:51','2025-11-03 19:12:51','17617174764463','17617174764463','','3451','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('710','17','1','','4','41848301','2025-11-03','4491','4796','677','YENEPOYA PHARMACEUTICALS AND SURGICALS','917259468855','','','15-3-111/10/11/16, Yenepoya Chember, Near Collectors Gate, Balmatta, Mangaluru,  575002','','29AABFY4656P1ZA','11','575002','ARISTO PHARMA  PVT LTD','918042401999','','PEENYA IND AREA','BLR','','11','560058','Document','0.01','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','45.00','1','1','2025-11-03 19:13:02','2025-12-13 16:58:23','17617216585187','17617216585187','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','1','0','','','','','','1','');
INSERT INTO `booking` VALUES ('711','23','1','','2','3408523','2025-11-03','','5130','678','HAJI U K EBRAHIM & SONS','919448480482','','','BUNDER','MANGALORE','','23','','united marine products','918244256665','','PUMPWELL','00','','11','575002','Document','100.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','100.00','1','1','2025-11-03 19:13:30','2025-11-26 15:56:16','17617218175043','17617218175043','mak park squre','3453','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('712','12','1','','2','3382937','2025-11-03','','5148','679','DR DEVIPRASAD','919900135975','','','DEPT OF OTORNINOLARYNGLOGY','KMC ATTAVARA MANGALORE','','11','575001','DR MUBARAK M KHAN','917057959162','','PLOT NO 102 ANANDA NAGARA','TALEGAON DABHADE','','14','410507','Others','100.00','0.00','0.00','0','Document','Surface','1','0.43','','','','','0.43','170.00','1','1','2025-11-03 19:13:33','2025-11-03 19:13:33','17617206505387','17617206505387','','13','SURGICAL ITEM','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('713','13','1','','2','3404028','2025-11-03','','5149','680','SUKRATHA GRAPHICS','918242426397','','','CARST','','','43','','MANJUSHREI PRITNERS','919731149816','','UJIRE','','','11','574240','Document','10.00','0.00','0.00','0','Document','Surface','1','0.05','','','','','0.05','50.00','1','1','2025-11-03 19:13:33','2025-11-03 19:13:33','17617147018423','17617147018423','','3440','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('714','22','1','','2','3411061','2025-11-03','','5150','681','S  D  HARAKURI','918746907325','','','KMF  DAIRY','KULSHEKAR MANGALURU','','11','575005','ZED DETECTIVE AGENCY','919071430703','','OP LAXMI TALIKES','P B ROAD','','11','580001','Document','0.10','0.00','0.00','0','Document','Surface','1','0.05','','','','','0.05','60.00','1','1','2025-11-03 19:13:41','2025-11-03 19:13:41','17617169725275','17617169725275','','379','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('715','10','1','','2','3406741','2025-11-03','','5151','682','MOTO CONTROLS P LTD','917760862699','','','BEJAI KAPIAKD','MLR','','11','575004','MOTO CONTROLS P LTD','919945078883','','CHANDRA LAYOUT','CBC ROAD','','11','','Document','200.00','0.00','0.00','0','Document','Surface','1','0.40','','','','','0.40','105.00','1','1','2025-11-03 19:14:11','2025-11-03 19:14:11','17617151801089','17617151801089','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('716','7','1','','2','3395038','2025-11-03','','5146','683','CARRYFOUR  LOGISTICS','919945261444','','','BAIKAMPADY','MANGALORE','','11','575011','MS METASTEEL','919606791824','','KOPPAL','KOPPAL','','11','583231','Document','0.00','0.00','0.00','0','Document','Surface','1','0.01','','','','','0.01','60.00','1','1','2025-11-03 19:14:34','2025-11-03 19:14:34','17617199828916','17617199828916','','394','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('717','25','1','','2','3388863','2025-11-03','','5137','684','JYOTHISHA MITHRA','919986671473','','','HOSABETTU','','','11','575019','GANESHA','918861777563','','VARANASI MAIN ROAD','BESIDE BSR TOWER','','11','560036','Document','10.00','0.00','0.00','0','Document','Surface','1','0.33','','','','','0.33','105.00','1','1','2025-11-03 19:14:48','2025-11-03 19:14:48','17617202587270','17617202587270','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('718','20','1','','2','3418033','2025-11-03','','5152','685','HOMEOCARE','919972996499','','','KODIALBAIL','','','11','575003','VIJAYA HARISH','919969810791','','AZAD NAGAR','','','14','400607','Document','0.00','0.00','0.00','0','Document','Surface','1','0.15','','','','','0.15','130.00','1','1','2025-11-03 19:15:12','2025-11-03 19:15:12','17616544937223','17616544937223','','848','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('719','13','1','','2','3404029','2025-11-03','','5149','686','SUKRATHA GRAPHICS','918242426397','','','CARST','','','43','','CHITRA PUBLICATION','919449640694','','HEGDE ROAD','','','11','581343','Document','10.00','0.00','0.00','0','Document','Surface','1','0.05','','','','','0.05','60.00','1','1','2025-11-03 19:15:27','2025-11-03 19:15:27','17617147018423','17617147018423','','165','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('720','24','1','','2','3399472','2025-11-03','','5153','687','IDEAL ROADLINES','919945913135','','','KANNUR POST','MANGALORE','','11','575007','SURYADEV ALLOYS & POWER','918925097979','','ARUMBAKKAM,','CHENNAI -','','23','600106','Document','0.00','0.00','0.00','0','Document','Surface','1','0.01','','','','','0.01','70.00','1','1','2025-11-03 19:15:28','2025-11-03 19:15:28','17617227922084','17617227922084','POONAMALLEE HIGH ROAD,','1931','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('721','16','1','','2','3357231','2025-11-03','','5154','688','ST JOSEPH ENGG COLL','919448823942','','','VAMANJOOR','MANAGLORE','','11','575025','NIDHI','919353715231','','GANDHI NAGAR','CHENNAI','','23','600032','Document','0.00','0.00','0.00','0','Document','Surface','1','0.23','','','','','0.23','95.00','1','1','2025-11-03 19:15:46','2025-12-18 18:27:21','17617177578387','17617177578387','','1931','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','1','2025-12-18 18:27:21','','received','','','0','17645844402769');
INSERT INTO `booking` VALUES ('722','23','1','','2','3408524','2025-11-03','','5155','689','MRS CHARLEEN REBIMBUS','919731531232','','','PANDESHWARA','MANGALORE','','23','','MRS CHARMAINE LOBO','919769693533','','THE ARK','ADACENT TO ST ANTHOYS CHURCH','','14','400055','Document','100.00','0.00','0.00','0','Document','Surface','1','0.50','','','','','0.50','170.00','1','1','2025-11-03 19:16:47','2025-11-03 19:16:47','17617218175043','17617218175043','','57','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('723','25','1','','2','3388864','2025-11-03','','5137','690','JYOTHISHA MITHRA','919986671473','','','HOSABETTU','','','11','575019','SRI BASAVARAJ SHASRI','917406136085','','BA GUDIPALYA','HANUMANTHPURA','','11','572101','Document','10.00','0.00','0.00','0','Document','Surface','1','0.33','','','','','0.33','105.00','1','1','2025-11-03 19:16:59','2025-11-03 19:16:59','17617202587270','17617202587270','','1633','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('724','20','1','','2','3418034','2025-11-03','','5156','691','MASTER STUDIO','919845033099','','','DONGERKERY','','','11','575003','SUKURAJ','919901314211','','BASF','','','11','575014','Document','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','50.00','1','1','2025-11-03 19:17:39','2025-11-03 19:17:39','17616544937223','17616544937223','','3211','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('725','24','1','','2','3399473','2025-11-03','','5153','692','IDEAL ROADLINES','919945913135','','','KANNUR POST','MANGALORE','','11','575007','SPM TRANSPORTS','919043883404','','SALEM MAIN ROAD, KOTHAMABADI','ATTUR','','23','636109','Document','0.00','0.00','0.00','0','Document','Surface','1','0.01','','','','','0.01','70.00','1','1','2025-11-03 19:17:42','2025-11-03 19:17:42','17617227922084','17617227922084','','422','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('726','17','1','','4','41848302','2025-11-03','4491','4796','693','YENEPOYA PHARMACEUTICALS AND SURGICALS','917259468855','','','15-3-111/10/11/16, Yenepoya Chember, Near Collectors Gate, Balmatta, Mangaluru,  575002','','29AABFY4656P1ZA','11','575002','INTAS PHARMA LTD','918049573355','','OFF B G ROAD','SOUTH CITY ROAD','','11','560076','Document','0.01','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','45.00','1','1','2025-11-03 19:17:55','2025-12-13 16:58:23','17617216585187','17617216585187','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','1','0','','','','','','1','');
INSERT INTO `booking` VALUES ('727','10','1','','2','3406742','2025-11-03','','5157','694','PAUL','918971209962','','','GREEN XPERTS','MAROLI','','11','575005','CHINMAY','918144766805','','KUNDALAHALLI','BROOKFIELD','','11','560037','Document','500.00','0.00','0.00','0','Document','Surface','1','0.50','','','','','0.50','105.00','1','1','2025-11-03 19:18:08','2025-11-03 19:18:08','17617151801089','17617151801089','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('728','16','1','','2','3357232','2025-11-03','','5158','93','MUKESH POOJARY','919108769107','','','KAIKA','KAIKAMBA','','11','574151','ABHIJEETABHIJITH','919620422492','','IDFC FIRST BANK','SARASWATHIPURAM MYSORE','','11','570009','Document','0.00','0.00','0.00','0','Document','Surface','1','0.20','','','','','0.20','85.00','1','1','2025-11-03 19:18:50','2025-11-03 19:18:50','17617177578387','17617177578387','','669','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('729','24','1','','2','3399474','2025-11-03','','5153','695','IDEAL ROADLINES','919945913135','','','KANNUR POST','MANGALORE','','11','575007','JAI BHARATH TRANSPORTS','919182619098','','NEW BYPASS CIRCLE,','RENIGUNTA','','1','517520','Document','0.00','0.00','0.00','0','Document','Surface','1','0.01','','','','','0.01','70.00','1','1','2025-11-03 19:19:15','2025-11-03 19:19:15','17617227922084','17617227922084','','1327','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('730','12','1','','2','3382938','2025-11-03','','5159','696','PURPLE SPLASH','918867120577','','','JAPPINAMOGER','MANGALORE','','11','575001','UNNIKRISHNAN K','919747563333','','KAANA VEEDU NARIYANCHERI','KANDOTH PAYYANUR','','12','670307','Books','1000.00','0.00','0.00','0','Document','Surface','1','2.06','','','','','2.06','400.00','1','1','2025-11-03 19:19:30','2025-11-03 19:19:30','17617206505387','17617206505387','','276','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('731','23','1','','2','3408525','2025-11-03','','5130','697','HAJI U K EBRAHIM & SONS','919448480482','','','BUNDER','MANGALORE','','23','','SUPER AQUA TECH','918244268134','','MASTHIKATTE','00','','11','575020','Document','100.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','100.00','1','1','2025-11-03 19:19:34','2025-11-26 15:56:16','17617218175043','17617218175043','','3453','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('732','7','1','','2','3395039','2025-11-03','','5160','698','P M MANIKANDA','917483137644','','','KULAI','MANGALORE','','11','575019','TOWN PANCHAYATH','919449277797','','SULLIA','SULLIA','','11','574239','Document','0.00','0.00','0.00','0','Document','Surface','1','0.01','','','','','0.01','50.00','1','1','2025-11-03 19:19:59','2025-11-03 19:19:59','17617199828916','17617199828916','','2577','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('733','20','1','','2','3418035','2025-11-03','','5161','699','K S SHEKABBA','919108511365','','','ASHOKNAGAR','','','11','575003','HEMAMALINI','919686233779','','ASHRAM ROAD','','','11','560067','Document','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-03 19:20:17','2025-11-03 19:20:17','17616544937223','17616544937223','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('734','24','1','','2','3399475','2025-11-03','','5153','373','IDEAL ROADLINES','919945913135','','','KANNUR POST','MANGALORE','','11','575007','C D TRANSPORTS','919715816556','','SIVANATHAPURAM','MAIN ROAD, CUDDALORE','','25','607003','Document','0.00','0.00','0.00','0','Document','Surface','1','0.01','','','','','0.01','70.00','1','1','2025-11-03 19:21:24','2025-11-03 19:21:24','17617227922084','17617227922084','','326','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('735','10','1','','2','3406743','2025-11-03','','5162','700','RUPESH','918970068749','','','MARNAMIKATTE','MLR','','11','575001','ORIENT BLACKSWAN P LTD','918026690258','','BSK 3 STAGE','KATRIGUPPE','','11','560085','Document','100.00','0.00','0.00','0','Document','Surface','1','0.10','','','','','0.10','75.00','1','1','2025-11-03 19:21:29','2025-11-03 19:21:29','17617151801089','17617151801089','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('736','17','1','','4','41848303','2025-11-03','4491','4796','701','YENEPOYA PHARMACEUTICALS AND SURGICALS','917259468855','','','15-3-111/10/11/16, Yenepoya Chember, Near Collectors Gate, Balmatta, Mangaluru,  575002','','29AABFY4656P1ZA','11','575002','TROIKAA PHARMA LTD','917338336801','','VITRAAG','SUDHAMANAGAR','','11','560027','Document','0.01','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','45.00','1','1','2025-11-03 19:21:48','2025-12-13 16:58:23','17617216585187','17617216585187','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','1','0','','','','','','1','');
INSERT INTO `booking` VALUES ('737','26','1','','2','3400872','2025-11-03','','5163','702','a k panels','919740540721','','','mudipu','','','11','','the automotive resarch assocation of india','912067621564','','sno 102 vetal hill','off paud rfd','','14','411038','plywood sample','0.00','0.00','0.00','0','Document','Surface','1','21.50','','','','','21.50','3630.00','1','1','2025-11-03 19:22:04','2025-11-03 19:22:04','17615707686074','17615707686074','','13','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('738','24','1','','2','3399476','2025-11-03','','5153','331','IDEAL ROADLINES','919945913135','','','KANNUR POST','MANGALORE','','9','575007','SREE SELLIAMMAN TPT','919942590199','','PERUNDURAI VIA','ERODE','','23','638052','Document','0.00','0.00','0.00','0','Document','Surface','1','0.01','','','','','0.01','70.00','1','1','2025-11-03 19:22:31','2025-11-03 19:22:31','17617227922084','17617227922084','','2462','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('739','23','1','','2','3408526','2025-11-03','','5164','703','THE CAMPCO EMPLOYEES','919845939315','','','PANESHWARA','MANGALORE','','23','','SRI ASHWATH KUMAR','916366875028','','ANJANYEYA BUILDING','MAIN ROAD','','11','','Document','100.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','50.00','1','1','2025-11-03 19:22:35','2025-11-03 19:22:35','17617218175043','17617218175043','THE CAMPCO LTD','2577','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('740','12','1','','2','3382939','2025-11-03','','5159','704','PURPLE SPLASH','918867120577','','','JAPPINAMOGER','MANGALORE','','11','575001','NEXUS','918088980151','','KORAMANGALA','SBI COLONY','','11','560024','Books','1000.00','0.00','0.00','0','Document','Surface','1','7.20','','','','','7.20','880.00','1','1','2025-11-03 19:23:27','2025-11-03 19:23:27','17617206505387','17617206505387','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('741','13','1','','2','3404030','2025-11-03','','5165','277','SRINIVAS HOSPITAL','918242478586','','','MANGALOARE','','','11','575001','SHANTHI DSOUZA','918494900306','','MRPL','KUTHETHOOR','','43','575011','Document','10.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','35.00','1','1','2025-11-03 19:23:30','2025-11-03 19:23:30','17617147018423','17617147018423','','3453','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('742','22','1','','2','3411062','2025-11-03','','5166','705','KAMADHENU GAS AGENCIES','918242213102','','','KADRI  TOOL GATE','MANGALURU','','11','575002','SRICHARAKA CONTANIERS P LTD','919535089021','','BAIKAMPADY','IND AREA','','11','575011','Document','0.10','0.00','0.00','0','Document','Surface','1','0.05','','','','','0.05','100.00','1','1','2025-11-03 19:23:31','2025-11-26 15:56:16','17617169725275','17617169725275','','3453','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('743','20','1','','2','3418036','2025-11-03','','5167','511','MAHESH','919448665535','','','VYASNAGAR','','','11','575004','NAGARAJ','','','HEBBANDU','','','11','577301','Document','0.00','0.00','0.00','0','Document','Surface','1','0.15','','','','','0.15','85.00','1','1','2025-11-03 19:23:51','2025-11-03 19:23:51','17616544937223','17616544937223','','382','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('744','24','1','','2','3399477','2025-11-03','','5153','706','IDEAL ROADLINES','919945913135','','','KANNUR POST','MANGALORE','','11','575007',', AMADHAN, VMT TRANSPORT','919486384344','','OLD KATPADI ROAD,','VELLORE -','','23','632004','Document','0.00','0.00','0.00','0','Document','Surface','1','0.01','','','','','0.01','70.00','1','1','2025-11-03 19:24:17','2025-11-03 19:24:17','17617227922084','17617227922084','','14','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('745','20','1','','2','3418037','2025-11-03','','5048','511','MAHESH','','','','VYASNAGAR','','','11','575004','UMESH','','','KULAI','','','11','575019','Document','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','50.00','1','1','2025-11-03 19:25:25','2025-11-03 19:25:25','17616544937223','17616544937223','','3211','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('746','10','1','','2','3406744','2025-11-03','','5108','707','V4 DIGITAL INFOTECH','919845101979','','','YEYYADI','MLR','','11','575008','KISHOR SHETTY','919833782995','','JIO STAR INDIA P LTD','LOWER PAREL WEST','','14','400013','Document','50.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','100.00','1','1','2025-11-03 19:25:43','2025-11-03 19:25:43','17617151801089','17617151801089','','57','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('747','23','1','','2','3408527','2025-11-03','','4597','511','KAVITHA DIGITAL SEVA KENDRA','918310356016','','','PANDESHWARA','MANGALORE','','11','560010','ASHWIN','','','AMBALPADY','00','','11','576103','Document','100.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-03 19:25:44','2025-11-26 16:01:53','17617218175043','17617218175043','ITI FINANCE LTD','1639','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('748','17','1','','4','41848304','2025-11-03','3879','3878','708','HDFC BANK,KANKANADY BRANCH.','919945854169','','','BENDOORWELL,MANGALORE-575001.  8/24, SALCO CENTER, RICHMOND ROAD, BANGALORE,560025','','29AAACH2702H1ZW','11','575002','HDFC BANLK LTD','916363415231','','OPP HOTEL AVATAR','ATTAVAR','','11','575001','Document','0.01','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','20.00','1','1','2025-11-03 19:25:55','2025-12-20 18:11:46','17617216585187','17617216585187','','3453','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','1','1','2025-12-20 12:12:52','','received','','','1','17645841409774');
INSERT INTO `booking` VALUES ('749','13','1','','2','3404031','2025-11-03','','5168','277','SRINIVAS INSTITUTE OF MEDICAL SC','918242425966','','','GHS ROAD','MANGALAORE','','11','575001','CASHLESS RECEVING CENTRE','918494900306','','MEDI ASSIST INSU','HOSUR MAIN ROAD','','43','575011','Document','10.00','0.00','0.00','0','Document','Surface','1','0.43','','','','','0.43','105.00','1','1','2025-11-03 19:26:09','2025-11-03 19:26:09','17617147018423','17617147018423','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('750','22','1','','2','3411063','2025-11-03','','5169','709','RASHMITHA  SUVARNA','918861195408','','','SAIRADHA MOTORS  BENDOOR','MAMGALURU','','11','575002','TVS CREDIT SERVICES LTD','919446642345','','BRISTOL TOWER','GUINDY','','23','600032','Document','0.01','0.00','0.00','0','Document','Surface','1','0.40','','','','','0.40','120.00','1','1','2025-11-03 19:26:12','2025-11-03 19:26:12','17617169725275','17617169725275','','1931','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('751','26','1','','2','3400873','2025-11-03','','5170','710','manish kuthar','917204096079','','','kuthar','','','11','575017','sathish sk','919845108299','','kalmady','mn rd','','11','576108','oil','0.00','0.00','0.00','0','Document','Surface','1','0.50','','','','','0.50','85.00','1','1','2025-11-03 19:26:13','2025-11-03 19:26:13','17615707686074','17615707686074','','772','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('752','24','1','','2','3399478','2025-11-03','','5171','711','SAI SOORYA SURGICALS & PHARMA','917999390884','','','PUMPWEEL ROAD,','KANKANADY, MANGALORE -  2','','11','575002','VIRBAC ANIMAL HEALTH INDIA','919632097111','','GERUPALYA, KUBULGUDU,','KENGERI HOBLI, BANGALORE -','','11','560074','Document','0.00','0.00','0.00','0','Document','Surface','1','0.01','','','','','0.01','60.00','1','1','2025-11-03 19:26:45','2025-11-03 19:26:45','17617227922084','17617227922084','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('753','12','1','','2','3382940','2025-11-03','','5172','712','ROYAL REFRIGERATION','919606714540','','','JEPPU','MANGALORE','','11','575001','SRI MAHALAXMI FANCY ELECTRONICS','918722095862','','MAHADEVI SANKEERNA','YELMUDY','','11','574201','Electronic Items','500.00','0.00','0.00','0','Document','Surface','1','0.64','','','','','0.64','95.00','1','1','2025-11-03 19:27:33','2025-11-03 19:27:33','17617206505387','17617206505387','','1904','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('754','22','1','','2','3411064','2025-11-03','','5173','713','VINAYA T','917892658358','','','SAIRADHA MOTORS  BENDOOR','MANGALURU','','11','575002','TVS CREDIT SERVCIES LTD','919446612345','','BRISTOL TOWER','GUINDY','','23','600032','Document','0.10','0.00','0.00','0','Document','Surface','1','0.60','','','','','0.60','140.00','1','1','2025-11-03 19:28:13','2025-11-03 19:28:13','17617169725275','17617169725275','','1931','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('755','10','1','','2','3406745','2025-11-03','','5108','714','V4 DIGITAL INFOTECH','919845101979','','','YEYYADI','MLR','','11','575008','PRASHNATH JATTANA','919742971777','','KORANGRAPADY','NEAR CJ CHURCH','','11','576101','Document','50.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-03 19:28:27','2025-11-26 16:01:53','17617151801089','17617151801089','','1639','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('756','17','1','','4','41848305','2025-11-03','3879','3878','715','HDFC BANK,KANKANADY BRANCH.','919945854169','','','BENDOORWELL,MANGALORE-575001.  8/24, SALCO CENTER, RICHMOND ROAD, BANGALORE,560025','','29AAACH2702H1ZW','11','560001','ANIL KUIMAR/BHASKAR','916304267900','','NRUPATHUNGA ROAD','BLR','','11','560001','Document','0.01','0.00','0.00','0','Document','Surface','1','0.01','','','','','0.01','29.00','1','1','2025-11-03 19:28:41','2025-12-20 18:11:46','17617216585187','17617216585187','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','1','0','','','','','','1','');
INSERT INTO `booking` VALUES ('757','13','1','','2','3404032','2025-11-03','','5168','277','SRINIVAS INSTITUTE OF MEDICAL SC','918242425966','','','GHS ROAD','MANGALAORE','','11','575001','CLAIMS DEPT','918494900306','','ADITYA BIRLA HEALTH INSU','SENAPATI BAPAT MARD','','43','575011','Document','10.00','0.00','0.00','0','Document','Surface','1','0.10','','','','','0.10','120.00','1','1','2025-11-03 19:28:49','2025-11-03 19:28:49','17617147018423','17617147018423','','57','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('758','24','1','','2','3399479','2025-11-03','','5174','716','SAI SOORYA SURGICAL & PHARMA','917899390884','','','PUMPWELL RIOAD,','MANGALORE','','11','575002','TTK HEALTH CARE LTD','918029620209','','YUESHWANTHPURA INDL AREA','BANGALORE','','11','560022','Document','0.00','0.00','0.00','0','Document','Surface','1','0.01','','','','','0.01','60.00','1','1','2025-11-03 19:28:53','2025-11-03 19:28:53','17617227922084','17617227922084','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('759','23','1','','2','3408528','2025-11-03','','5175','717','MAHADEV OPTICAL','918431537594','','','BUNDER','MANGALOre','','23','','jawahar opticans','918362211820','','00','00','','11','580020','Document','100.00','0.00','0.00','0','Document','Surface','1','0.05','','','','','0.05','60.00','1','1','2025-11-03 19:29:22','2025-11-03 19:29:22','17617218175043','17617218175043','station road','557','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('760','22','1','','2','3411065','2025-11-03','','5173','713','VINAYA T','917892658358','','','SAIRADHA MOTORS  BENDOOR','MANGALURU','','11','575002','TVS CREDIT SERVCIES LTD','919446612345','','ATTN AYAPPA   BRISTOL TOWER','GUINDY','','23','600032','Document','100.00','0.00','0.00','0','Document','Surface','1','0.05','','','','','0.05','70.00','1','1','2025-11-03 19:29:49','2025-11-03 19:29:49','17617169725275','17617169725275','','1931','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('761','20','1','','2','3418038','2025-11-03','','5048','511','US FINANCIAL','','','','DONGERKERY','','','11','575003','BABU','','','YELAHANKA','','','11','560064','Document','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-03 19:29:53','2025-11-03 19:29:53','17616544937223','17616544937223','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('762','13','1','','2','3404033','2025-11-03','','5168','277','SRINIVAS INSTITUTE OF MEDICAL SC','918242425966','','','GHS ROAD','MANGALAORE','','11','575001','VIDAL HEALTH INSU','918494900306','','HOODI RAJAPALAYA','','','43','575011','Document','10.00','0.00','0.00','0','Document','Surface','1','0.30','','','','','0.30','105.00','1','1','2025-11-03 19:30:27','2025-11-03 19:30:27','17617147018423','17617147018423','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('763','24','1','','2','3399480','2025-11-03','','5174','718','SAI SOORYA SURGICAL & PHARMA','917899390884','','','PUMPWELL RIOAD,','MANGALORE','','11','575002','CHEERANS LAB P LTD,','914872421518','','NEW CHURCH STREET,','TRICHUR, KERALA','','12','680001','Document','0.00','0.00','0.00','0','Document','Surface','1','0.01','','','','','0.01','70.00','1','1','2025-11-03 19:30:34','2025-11-03 19:30:34','17617227922084','17617227922084','','1632','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('764','23','1','','2','3408529','2025-11-03','','5175','719','MAHADEV OPTICAL','918431537594','','','BUNDER','MANGALOre','','23','','rose opticals','919481958417','','00','00','','11','575001','Document','100.00','0.00','0.00','0','Document','Surface','1','0.05','','','','','0.05','50.00','1','1','2025-11-03 19:31:25','2025-11-03 19:31:25','17617218175043','17617218175043','opp vijaya bank','3411','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('765','12','1','','2','3382941','2025-11-03','','5176','720','SRI LAKSHMI ENTERFRISES','919364089125','','','WEST GATE ETERNA','MARNAMIKATTA MANGALORE','','11','575001','GAYATHRI ENTERFRISES','919844008305','','PAXAL TOWERS','K R ROAD','','11','560002','Others','210.00','0.00','0.00','0','Document','Surface','1','0.45','','','','','0.45','105.00','1','1','2025-11-03 19:31:28','2025-11-03 19:31:28','17617206505387','17617206505387','','424','SURGICAL ITEM','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('766','13','1','','2','3404034','2025-11-03','','5168','277','SRINIVAS INSTITUTE OF MEDICAL SC','918242425966','','','GHS ROAD','MANGALAORE','','11','575001','NIVA BUPA HEALTH INSU','918494900306','','GAUTAM','','','43','575011','Document','10.00','0.00','0.00','0','Document','Surface','1','0.15','','','','','0.15','130.00','1','1','2025-11-03 19:32:01','2025-11-03 19:32:01','17617147018423','17617147018423','','1551','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('767','20','1','','2','3418039','2025-11-03','','5048','511','OCTAPLUS','','','','KARANGALPADY','','','11','575003','SACHIDANANDA','','','BASAVESHWARNAGAR','','','11','560079','Document','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-03 19:32:15','2025-11-03 19:32:15','17616544937223','17616544937223','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('768','24','1','','2','3399481','2025-11-03','','5177','721','DR A G JAYAKRISHNAN,','919845398763','','','2703, PLANET SKS','KADRI HILL, MANGALORE - 04','','11','575004','C RAMACHANDRAN,','919447152910','','ADVOCATE, ANARGHA,','KPOTTOOLI, KOZHIKODE -','','12','673016','Document','0.00','0.00','0.00','0','Document','Surface','1','0.01','','','','','0.01','70.00','1','1','2025-11-03 19:32:34','2025-11-03 19:32:34','17617227922084','17617227922084','','161','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('769','13','1','','2','3404035','2025-11-03','','5168','277','SRINIVAS INSTITUTE OF MEDICAL SC','918242425966','','','GHS ROAD','MANGALAORE','','11','575001','CARE HEALTH INSU','918494900306','','6TH FLOOR TOWER CYBER PARK','','','43','575011','Document','10.00','0.00','0.00','0','Document','Surface','1','0.15','','','','','0.15','130.00','1','1','2025-11-03 19:34:01','2025-11-03 19:34:01','17617147018423','17617147018423','','631','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('770','23','1','','2','3408530','2025-11-03','','5178','722','FATHIMA CYNTHIA DSOUZA','919448654997','','','PANDESHWARA','MANGALORE','','23','','SHRI BEERESHWAR CO OP CREDIT SOCIERY LTD','917760985536','','SLV PLAZA','00','','11','583103','Document','100.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-03 19:34:12','2025-11-03 19:34:12','17617218175043','17617218175043','EXAMBA','427','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('771','20','1','','2','3418040','2025-11-03','','5048','511','ANUSHA UDAYAVANI','','','','KODIALBAIL','','','11','575003','LATHEESH','','','UDAYAVANI','','','11','','Document','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','50.00','1','1','2025-11-03 19:34:31','2025-11-03 19:34:31','17616544937223','17616544937223','','662','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('772','12','1','','2','3382942','2025-11-03','','5172','723','ROYAL REFRIGERATION','919606714540','','','JEPPU','MANGALORE','','11','575001','SRI DURGA DISTIBUTORS','918762960424','','PANJIGAR','','','11','574212','Electronic Items','500.00','0.00','0.00','0','Document','Surface','1','0.56','','','','','0.56','95.00','1','1','2025-11-03 19:34:59','2025-11-03 19:34:59','17617206505387','17617206505387','','2577','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('773','22','1','','2','3411066','2025-11-03','','5179','724','SHREE SUBRAHMANYA SAH SANGHA','919880968032','','','KULSHEKAR','MANGALURU','','11','575005','SHREE SUBRHMANYA SAH SANGHA','919980968031','','SB BUILDING','BEJAI ROAD','','11','575004','Document','100.00','0.00','0.00','0','Document','Surface','1','0.45','','','','','0.45','170.00','1','1','2025-11-03 19:35:35','2025-11-26 15:56:16','17617169725275','17617169725275','','3453','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('774','13','1','','2','3404036','2025-11-03','','5168','277','SRINIVAS INSTITUTE OF MEDICAL SC','918242425966','','','GHS ROAD','MANGALAORE','','11','575001','TATA AIG CLAIMS','918494900306','','AMEERPET METRO STATION','HYDERABAD','','24','500016','Document','0.00','0.00','0.00','0','Document','Surface','1','0.15','','','','','0.15','95.00','1','1','2025-11-03 19:37:06','2025-11-03 19:37:06','17617147018423','17617147018423','','117','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('775','23','1','','2','3408531','2025-11-03','','5180','725','KAVITHA','919886865477','','','MANGALORE','PANDESHWARA','','23','','MR GANESH R K','918217708709','','MOULY NILAYA','ANSUYAMMA LAYOUT BIDADI','','11','562109','Document','100.00','0.00','0.00','0','Document','Surface','1','0.05','','','','','0.05','60.00','1','1','2025-11-03 19:37:26','2025-11-03 19:37:26','17617218175043','17617218175043','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('776','20','1','','2','3418041','2025-11-03','','5048','511','BHUVANESHWAR','','','','KODIALBAIL','','','11','575003','SHASHIKANTH','','','HIGH COURT','','','11','','Document','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-03 19:37:51','2025-11-03 19:37:51','17616544937223','17616544937223','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('777','22','1','','2','3411067','2025-11-03','','5181','726','SACHIN N S','919148732941','','','U GURAD INDUSTRIES','BIKRNKATTA   MANGALURU','','11','575005','R P SOULTIONS','919845452763','','H39 ABOVE HOTEL  CHAATIMES','HANUMANTHA NAGAR','','11','560019','Document','100.00','0.00','0.00','0','Document','Surface','1','0.45','','','','','0.45','105.00','1','1','2025-11-03 19:38:05','2025-11-03 19:38:05','17617169725275','17617169725275','','1036','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('778','24','1','','2','3399482','2025-11-03','','5182','93','SUSMITHA','919606809597','','','IDFC BANK LTD,','KANKANADY , MANGALORE -','','11','575002','ABHIJEET','919620422492','','IDFC FIRST BANK','SARASWATHIPURAM MYSORE','','11','570009','Document','0.00','0.00','0.00','0','Document','Surface','1','0.18','','','','','0.18','85.00','1','1','2025-11-03 19:38:46','2025-11-03 19:38:46','17617227922084','17617227922084','','669','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('779','10','1','','2','3406746','2025-11-03','','5183','727','pramod bijjur','917892228981','','','ajims','mlr','','23','','PRASANNA BIJJUR','918217862229','','KHANAPUR ROAD','BELGAUM','','11','590006','Document','6000.00','0.00','0.00','0','Document','Surface','1','1.45','','','','','1.45','247.00','1','1','2025-11-03 19:39:03','2025-11-03 19:39:03','17617151801089','17617151801089','','4','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('780','20','1','','2','3418042','2025-11-03','','5048','511','R K HEGDE','','','','MANGALORE','','','11','575003','N K BHAT','','','PUTTIGE','','','11','','Document','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','50.00','1','1','2025-11-03 19:39:51','2025-11-03 19:39:51','17616544937223','17616544937223','','3158','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('781','23','1','','2','3408532','2025-11-03','','5184','728','V L APPLIANCE INDIA PVT LTD','918746991111','','','PANDESWARA','MANGALORE','','23','','TARANGA ELE','919449955955','','ASHWINI COMPLEX','KUMBESHWAR ROAD','','11','585151','Document','100.00','0.00','0.00','0','Document','Surface','1','0.35','','','','','0.35','105.00','1','1','2025-11-03 19:40:02','2025-11-03 19:40:02','17617218175043','17617218175043','','165','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('782','22','1','','2','3411068','2025-11-03','','5185','729','VEDAMAAYU AYURVEDA HOSPITAL','918088806606','','','SANATAN PADAVU HIGH SCHOOL ROAD','BEJAI MANGALURU','','11','575008','SAGAR','917899986349','','RASHMI SADAN  KAMMASANDRA','ELELCTRONIC CITY','','11','560100','Document','100.00','0.00','0.00','0','Document','Surface','1','0.85','','','','','0.85','155.00','1','1','2025-11-03 19:40:46','2025-11-03 19:40:46','17617169725275','17617169725275','','1036','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('783','24','1','','2','3399483','2025-11-03','','5186','93','WEST COAST','919164688188','','','KANKANADY','MANGALORE','','11','575002','ABHIJEET','919620422492','','IDFC FIRST BANK','SARASWATHIPURAM MYSORE','','11','','Document','0.00','0.00','0.00','0','Document','Surface','1','0.80','','','','','0.80','155.00','1','1','2025-11-03 19:40:53','2025-11-03 19:41:37','17617227922084','17617227922084','','669','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('784','13','1','','2','3404037','2025-11-03','','5187','730','FURQAN AHMED','918147818399','','','MANGALORE','MANGALORE','','11','575001','MINU JOHN','912243244324','','SUN PHARMA','GOREGAON','','14','400063','Document','0.00','0.00','0.00','0','Document','Surface','1','0.19','','','','','0.19','130.00','1','1','2025-11-03 19:41:36','2025-11-03 19:41:36','17617147018423','17617147018423','','57','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('785','10','1','','2','3406747','2025-11-03','','5108','731','V4 DIGITAL INFOTECH','919845101979','','','YEYYADI','MLR','','11','575008','RAKESH KUMAR B','919845004546','','SUPER DIGITAL SYSTEM','MADHAVNAGAR','','11','560001','Document','50.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-03 19:42:13','2025-11-03 19:42:13','17617151801089','17617151801089','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('786','23','1','','2','3408533','2025-11-03','','5188','732','KARTHIC KUMAR','918123814765','','','BUNDER','MANGALORE','','23','','SRI RAMADAS MOTOR TRANSPORT LTD','918008548111','','00','00','','1','533001','Document','0.00','0.00','0.00','0','Document','Surface','1','0.45','','','','','0.45','120.00','1','1','2025-11-03 19:42:50','2025-11-03 19:42:50','17617218175043','17617218175043','MAIN ROAD','2471','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('787','20','1','','2','3418043','2025-11-03','','5048','511','MANJUNATH','','','','MANGALORE','','','11','575003','SHEFALI','','','SEEGEHALLI','','','11','560067','Document','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-03 19:43:14','2025-11-03 19:43:14','17616544937223','17616544937223','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('788','10','1','','2','3406748','2025-11-03','','5108','733','V4 DIGITAL INFOTECH','919845101979','','','YEYYADI','MLR','','11','575008','PRAMOD J P','919845128889','','TIMES NETWORK','CHURCH STREET','','11','560001','Document','50.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-03 19:43:59','2025-11-03 19:43:59','17617151801089','17617151801089','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('789','13','1','','2','3404038','2025-11-03','','5187','734','FURQAN AHMED','918147818399','','','MANGALORE','MANGALORE','','11','575001','SUN PHARMA','912266455645','','MAHAKALI CROSS RD','ANDHRI E','','14','400093','Document','0.00','0.00','0.00','0','Document','Surface','1','0.05','','','','','0.05','100.00','1','1','2025-11-03 19:44:05','2025-11-03 19:44:05','17617147018423','17617147018423','','57','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('790','17','1','','4','41848306','2025-11-03','3863','3865','735','CANARA BANK, C.G.','919483510651','','','COLLECTORS GATE BRANCH, BALMATTA, MANGALORE-575001 5th Floor, 112, Canara Bank Head Office, JC Road, Town Hall Junction, Nagartapete, Bengaluru,560002','','29AAACC6106G1ZX','11','575002','CANARA BANK','916363106634','','ACCOUNT SECTION','NRIPATHUNGA ROAD','','11','560002','Document','0.01','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','18.00','1','1','2025-11-03 19:45:10','2025-12-13 16:58:24','17617216585187','17617216585187','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','1','0','','','','','','1','');
INSERT INTO `booking` VALUES ('791','26','1','','2','3400874','2025-11-03','','5189','736','ramachandra','919343457854','','','kinnigolli','','','11','5741414','vice direcitor','919343457854','','gani and bhuvidhyan','kadri','','11','575003','Document','0.00','0.00','0.00','0','Document','Surface','1','0.05','','','','','0.05','35.00','1','1','2025-11-03 19:45:12','2025-11-03 19:45:12','17615707686074','17615707686074','','3453','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('792','10','1','','2','3406749','2025-11-03','','5108','737','V4 DIGITAL INFOTECH','919845101979','','','YEYYADI','MLR','','11','575008','ARUN KUMAR','919845496321','','PUBLIC TV','YESHWANTHPURA','','11','560022','Document','50.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-03 19:45:52','2025-11-03 19:45:52','17617151801089','17617151801089','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('793','23','1','','2','3408534','2025-11-03','','5190','738','K K DISTRIBUTORS LLP','919148987103','','','BUNDER','MANGALORE','','23','','K K DISTRIBUTORS LLP','917353585385','','4TH MAIN 4TH BLOCK','THYAGARANAGAR','','11','560028','Document','100.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-03 19:46:08','2025-11-03 19:46:08','17617218175043','17617218175043','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('794','10','1','','2','3406750','2025-11-03','','5108','737','V4 DIGITAL INFOTECH','919845101979','','','YEYYADI','MLR','','11','575008','RANGANATH','919845496321','','PUBLIC TV','YESHWANTHPURA','','11','560022','Document','50.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-03 19:47:13','2025-11-03 19:47:13','17617151801089','17617151801089','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('795','26','1','','2','3400875','2025-11-03','','5189','736','ramachandra','919343457854','','','kinnigolli','','','11','5741414','station officer','919343457854','','mulki station','mulki station','','11','574154','Document','0.00','0.00','0.00','0','Document','Surface','1','0.05','','','','','0.05','50.00','1','1','2025-11-03 19:48:08','2025-11-03 19:48:08','17615707686074','17615707686074','','744','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('796','23','1','','2','3408535','2025-11-03','','5191','739','ROOPA ENG CORP','919242783800','','','BUNDER','MANGALORE','','23','','LAK ELE H/W & INDU','918792923244','','GAYATHRI EXT','00','','11','573116','Document','100.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-03 19:48:17','2025-11-03 19:48:17','17617218175043','17617218175043','','412','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('797','12','1','','2','3382943','2025-11-03','','5192','740','AASIF AHMED','918296924469','','','JEPPU MASJID ROAD','JAPPINAMOGER MANGALORE','','11','575002','SHOBHA BHAGAWANTH RAO','919036835282','','MEENAKSHI LAYOUT','BANNERGHATTA ROAD','','11','560076','Others','15700.00','0.00','0.00','0','Document','Surface','1','0.89','','','','','0.89','155.00','1','1','2025-11-03 19:48:34','2025-11-03 19:48:34','17617206505387','17617206505387','','424','MEDICENE','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('798','22','1','','2','3411069','2025-11-03','','5193','741','SHAPE LAB','919342658867','','','BALMATTA','MANGALURU','','11','575002','I CARE OPTICALS','918861511921','','SDM EYE HOSPITAL','MAIN ROAD','','11','574214','Document','100.00','0.00','0.00','0','Document','Surface','1','0.25','','','','','0.25','75.00','1','1','2025-11-03 19:49:06','2025-11-03 19:49:06','17617169725275','17617169725275','','3440','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('799','20','1','','2','3418044','2025-11-03','','5048','511','LENSKART','','','','M G ROAD','','','11','575003','HEMAVATHI','','','MUDUSHEDDE','','','11','575028','Document','0.00','0.00','0.00','0','Document','Surface','1','0.20','','','','','0.20','75.00','1','1','2025-11-03 19:49:21','2025-11-03 19:49:21','17616544937223','17616544937223','','853','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('800','10','1','','2','3406751','2025-11-03','','5108','742','V4 DIGITAL INFOTECH','919845101979','','','YEYYADI','MLR','','11','575008','JEEVAN PRAKASH','919845548542','','KESHWAPUR EXTN','KUSUGAL ROAD','','11','580020','Document','50.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-03 19:49:22','2025-11-03 19:49:22','17617151801089','17617151801089','','557','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('801','17','1','','4','41848307','2025-11-03','3929','3923','743','RADHA MEDICALS DENTAL & SURGICAL DIVISION','918202829242','','','SAI RADHA STAR, OPP HITECH  HOSPITAL, AMBALPADY, UDUPI-576103','','29AAGFR4010B1ZP','11','575002','DR. PRAVEEN PARE','919448858150','','NEAR BUS STAND','PUTTUR','','11','574201','Document','0.02','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','46.00','1','1','2025-11-03 19:49:59','2025-12-20 12:22:08','17617216585187','17617216585187','','1904','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','1','1','2025-12-20 12:22:08','','received','','','1','17645841409774');
INSERT INTO `booking` VALUES ('802','26','1','','2','3400876','2025-11-03','','5189','736','ramachandra','919343457854','','','kinnigolli','','','11','5741414','sation officer','919343457854','','nagarika hakku jairi','uvrva store','','11','575006','Document','0.00','0.00','0.00','0','Document','Surface','1','0.05','','','','','0.05','35.00','1','1','2025-11-03 19:50:00','2025-11-03 19:50:00','17615707686074','17615707686074','','3453','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('803','23','1','','2','3408536','2025-11-03','','5191','744','ROOPA ENG CORP','919242783800','','','BUNDER','MANGALORE','','23','','OMKAR ELE','919844621920','','BELLAVI HOBLI','00','','11','572128','Document','100.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-03 19:50:20','2025-11-03 19:50:20','17617218175043','17617218175043','BOMMANAHALLY','1633','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('804','10','1','','2','3406752','2025-11-03','','5108','745','V4 DIGITAL INFOTECH','919845101979','','','YEYYADI','MLR','','11','575008','ULLAS','919847058064','','JIOSTAR INDIA P LTD','CHALLAGHATTA','','11','560071','Document','50.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-03 19:50:54','2025-11-03 19:50:54','17617151801089','17617151801089','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('805','12','1','','2','3382944','2025-11-03','','5192','746','AASIF AHMED','918296924469','','','JEPPU MASJID ROAD','JAPPINAMOGER MANGALORE','','11','575002','VANDANA VITHOBHA','919448651493','','R G MALU APARTMENT','MSK MILL ROAD','','11','585102','Others','11900.00','0.00','0.00','0','Document','Surface','1','1.50','','','','','1.50','247.00','1','1','2025-11-03 19:51:02','2025-11-03 19:51:02','17617206505387','17617206505387','','1195','MEDICINES','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('806','22','1','','2','3411070','2025-11-03','','5193','747','SHAPE LAB','919342658867','','','BALMATTA','MANGALURU','','11','575002','I CARE OPTICALS','918971716178','','OPP  PADIVALS HOTEL','HANUMAN TEMPLE ROAD','','11','574227','Document','100.00','0.00','0.00','0','Document','Surface','1','0.15','','','','','0.15','75.00','1','1','2025-11-03 19:51:43','2025-11-03 19:51:43','17617169725275','17617169725275','','1731','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('807','23','1','','2','3408537','2025-11-03','','5191','511','PRIMETECH TRANSFORMER','919242783800','','','BUNDER','MANGALORE','','23','','SRI LAKSHMI VENKATESHWARA INDU','','','SOUNDARYA INDU AREA','ANDRALLI VILLAGE','','11','560091','Document','100.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-03 19:52:17','2025-11-03 19:52:17','17617218175043','17617218175043','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('808','17','1','','4','41848308','2025-11-03','3929','3923','748','RADHA MEDICALS DENTAL & SURGICAL DIVISION','918202529242','','','SAI RADHA STAR, OPP HITECH  HOSPITAL, AMBALPADY, UDUPI-576103','','29AAGFR4010B1ZP','11','575002','EYE NATION','919845739511','','SYNDICATE CIRCLE','NEAR MANOHAR WINES','','11','576104','Document','0.01','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','46.00','1','1','2025-11-03 19:53:01','2025-12-13 16:58:24','17617216585187','17617216585187','','576104','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','1','0','','','','','','1','');
INSERT INTO `booking` VALUES ('809','20','1','','2','3418045','2025-11-03','','5048','511','PRADEEP','','','','DIST COURT','','','11','575003','CIVIL JUDGE','','','SULLIA','','','11','','Document','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','50.00','1','1','2025-11-03 19:53:28','2025-11-03 19:53:28','17616544937223','17616544937223','','2577','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('810','12','1','','2','3382945','2025-11-03','','5192','749','AASIF AHMED','918296924469','','','JEPPU MASJID ROAD','JAPPINAMOGER MANGALORE','','11','575002','DR PK JAISWAL','919008727049','','DLF WESTEND HEIGHTS','AKSHAY NAGARA BEGUR HOBLI','','11','560068','Others','19080.00','0.00','0.00','0','Document','Surface','1','1.55','','','','','1.55','293.00','1','1','2025-11-03 19:53:41','2025-11-03 19:53:41','17617206505387','17617206505387','','424','MEDICINE','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('811','26','1','','2','3400877','2025-11-03','','5194','750','ben franklin','917618791886','','','dkt','','','11','','eyegear optics india','914046461111','','soudhagar sliver breeze','banjara hills','','1','500034','Document','0.00','0.00','0.00','0','Document','Surface','1','0.10','','','','','0.10','85.00','1','1','2025-11-03 19:53:55','2025-11-03 19:53:55','17615707686074','17615707686074','','117','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('812','22','1','','2','3411071','2025-11-03','','5193','751','SHAPE LAB','919342658867','','','BALMATTA','MANGALURU','','11','575002','I CARE OPTICALS','919731575247','','S D M HOSPITAL AYURVEDA','KUTHPADY','','11','576105','Document','100.00','0.00','0.00','0','Document','Surface','1','0.10','','','','','0.10','65.00','1','1','2025-11-03 19:54:04','2025-11-03 19:54:04','17617169725275','17617169725275','','1639','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('813','23','1','','2','3408538','2025-11-03','','5191','752','PRIMETECH TRANSFORMER','919242783800','','','BUNDER','MANGALORE','','23','','YASHODA','917795261526','','KHEDDA INSUION SYTEM','M G ROAD','00','11','560025','Document','100.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-03 19:54:10','2025-11-03 19:54:10','17617218175043','17617218175043','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('814','13','1','','2','3404039','2025-11-03','','5195','753','M A KRISHNA NAYAK','918242427835','','','CARST','','','11','575001','STERLING FOODS','919945993317','','HAMPANKATTA','','','11','574146','Document','10.00','0.00','0.00','0','Document','Surface','1','0.05','','','','','0.05','35.00','1','1','2025-11-03 19:55:39','2025-11-03 19:55:39','17617147018423','17617147018423','','3453','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('815','23','1','','2','3408539','2025-11-03','','5191','754','ROOPA ENG CORP','919242783800','','','BUNDER','MANGALORE','','23','','NAGVENI','919449780181','','SUTHAKOTE','00','','11','575001','Document','100.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-03 19:56:02','2025-11-03 19:56:02','17617218175043','17617218175043','ROOPA ENG COR','1829','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('816','17','1','','4','41848309','2025-11-03','3929','3923','755','RADHA MEDICALS DENTAL & SURGICAL DIVISION','918202529243','','','SAI RADHA STAR, OPP HITECH  HOSPITAL, AMBALPADY, UDUPI-576103','','29AAGFR4010B1ZP','11','575002','VISIION PLUS PHARMACY','919880774249','','VITTAL ARCADE','VST MARG','','11','576101','Document','0.01','0.00','0.00','1','Document','Surface','1','0.02','','','','','0.02','46.00','1','1','2025-11-03 19:56:57','2025-12-13 16:58:24','17617216585187','17617216585187','','863','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','1','0','','','','','','1','');
INSERT INTO `booking` VALUES ('817','26','1','','2','3400878','2025-11-03','','5196','756','dr gondeva','919964025001','','','kshma','dkt','','11','575018','halekote ramesh','919448130251','','sharadamba estate','mudigere','','11','577132','Document','0.00','0.00','0.00','0','Document','Surface','1','0.23','','','','','0.23','85.00','1','1','2025-11-03 19:57:16','2025-11-03 19:57:16','17615707686074','17615707686074','','186','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('818','20','1','','2','3418046','2025-11-03','','5197','511','VINAYA HOSPITAL','918242494333','','','KARANGALPADY','','','11','575003','ICICI LOMBARD','','','BEGUMPT','','','24','500016','Document','0.00','0.00','0.00','0','Document','Surface','1','0.40','','','','','0.40','120.00','1','1','2025-11-03 19:57:25','2025-11-03 19:57:25','17616544937223','17616544937223','','117','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('819','13','1','','2','3404040','2025-11-03','','5195','753','M A KRISHNA NAYAK','918242427835','','','CARST','','','11','575001','CANARA VIKAS','919945993317','','AIRPORT ROAD','','','11','574146','Document','10.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','35.00','1','1','2025-11-03 19:58:11','2025-11-03 19:58:11','17617147018423','17617147018423','','3453','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('820','23','1','','2','3408540','2025-11-03','','5191','757','SUMAN CONCRETE','919242783800','','','BUNDER','MANGALORE','','23','','BASAVARAJ','919972591461','','SUMAN CONCRETE PRODUCTS','NEAR NANUNDESHWAR TEMPLE','','11','575001','Document','100.00','0.00','0.00','0','Document','Surface','1','0.10','','','','','0.10','75.00','1','1','2025-11-03 19:58:18','2025-11-03 19:58:18','17617218175043','17617218175043','','594','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('821','10','1','','2','3406753','2025-11-03','','5198','758','KEYA A BOLOOR','918310133502','','','CHILIMBI','MLR','','11','575006','RS GODBOLE','919821125447','','SHANTIVAN','BORIVALI EAST','','14','','Document','50.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','100.00','1','1','2025-11-03 19:58:29','2025-11-03 19:58:29','17617151801089','17617151801089','','57','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('822','20','1','','2','3418047','2025-11-03','','5048','511','JOYSTER','','','','LADYHILL','','','11','575006','ARIF','','','EW INTERNATIONAL AIRPORT ROAD','','','11','562157','Document','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-03 20:01:29','2025-11-03 20:01:29','17616544937223','17616544937223','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('823','17','1','','4','41848310','2025-11-03','3855','3857','540','BAJAJ ALLIANZ GENERAL INSURANCE CO LTD','918861670333','','','ESSEL WILCON COMPLEX,ABOVE RADHA MEDICALS,BENDOORWELL,MANGALORE-2 4th Floor, 1/2, Golden Heights, 59th C Cross, RAJAJINAGAR, Bengaluru-560010','','29AABCB5730G1ZT','11','575002','RAKESH MASCARENHAS','919686912316','','COURT ROAD','PUTTUR','','11','574201','Document','0.01','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','14.00','1','1','2025-11-03 20:01:29','2025-12-13 16:58:24','17617216585187','17617216585187','','1904','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','1','0','','','','','','1','');
INSERT INTO `booking` VALUES ('824','13','1','','2','3404041','2025-11-03','','5195','753','M A KRISHNA NAYAK','918242427835','','','CARST','','','11','575001','V M T C LOGISTICS','919945993317','','ANSARI ROAD BUNDER','','','11','574146','Document','10.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','35.00','1','1','2025-11-03 20:01:42','2025-11-03 20:01:42','17617147018423','17617147018423','','3453','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('825','9','1','','2','3283694','2025-11-03','','5199','759','HAMEED','918904112873','','','KANACHUR HOSPITAL','DERALAKATTE','','11','575019','DR VINAYAK','919141481637','','SULLIA','','','11','574239','Others','1000.00','0.00','0.00','0','Parcel','Surface','1','0.24','','','','','0.24','75.00','1','1','2025-11-03 20:03:17','2025-11-03 20:03:17','17617247788137','17617247788137','KVG DENTAL HOSPITAL','2577','MEDECINES','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('826','13','1','','2','3404042','2025-11-03','','5195','753','M A KRISHNA NAYAK','918242427835','','','CARST','','','11','575001','ARUNA FOODS','919945993317','','YEYYADI','','','11','574146','Document','10.00','0.00','0.00','0','Document','Surface','1','0.05','','','','','0.05','35.00','1','1','2025-11-03 20:03:36','2025-11-03 20:03:36','17617147018423','17617147018423','','3453','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('827','10','1','','2','3406754','2025-11-03','','5200','760','SREEKUMAR KR','919845557624','','','MLR','MLR','','11','575006','SANJEEV KOUJULAGI','919448094651','','SAROJ AGENCIES','NEELGIN ROAD','','11','580029','Document','20.00','0.00','0.00','0','Document','Surface','1','0.16','','','','','0.16','85.00','1','1','2025-11-03 20:03:47','2025-11-03 20:03:47','17617151801089','17617151801089','','557','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('828','20','1','','2','3418048','2025-11-03','','5048','511','BATA INDIA','','','','BEJAI','','','11','575003','BATA INDIA','','','B H ROAD','','','11','572101','Document','0.00','0.00','0.00','0','Document','Surface','1','1.00','','','','','1.00','155.00','1','1','2025-11-03 20:05:11','2025-11-03 20:05:11','17616544937223','17616544937223','','1633','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('829','13','1','','2','3404043','2025-11-03','','5195','511','M A KRISHNA NAYAK','918242427835','','','CARST','','','11','575001','SRIKANTH PAI','','','BASAVANGUDI CROSS ROAD','','','11','','Document','10.00','0.00','0.00','0','Document','Surface','1','0.05','','','','','0.05','35.00','1','1','2025-11-03 20:05:15','2025-11-03 20:05:15','17617147018423','17617147018423','','3453','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('830','17','1','','4','41848311','2025-11-03','3855','3857','509','BAJAJ ALLIANZ GENERAL INSURANCE CO LTD','918861670333','','','ESSEL WILCON COMPLEX,ABOVE RADHA MEDICALS,BENDOORWELL,MANGALORE-2 4th Floor, 1/2, Golden Heights, 59th C Cross, RAJAJINAGAR, Bengaluru-560010','','29AABCB5730G1ZT','11','575002','RAMAKRISHNA CREDIT CO OP SOCIETY','919663554852','','UPPINANGADY','UPG','','11','574144','Document','0.01','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','14.00','1','1','2025-11-03 20:05:37','2025-12-13 16:58:24','17617216585187','17617216585187','','2352','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','1','0','','','','','','1','');
INSERT INTO `booking` VALUES ('831','10','1','','2','3406755','2025-11-03','','5201','761','VEERANNA SHETTY','919449856475','','','VIDYANAGAR','HASSAN','','11','573202','EPFO','919945789632','','NEAR KHB OFFICE','CHIKMAGALORE','','11','577102','Document','20.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-03 20:06:45','2025-11-03 20:06:45','17617151801089','17617151801089','','695','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('832','13','1','','2','3404044','2025-11-03','','5195','753','M A KRISHNA NAYAK','918242427835','','','CARST','','','11','575001','the mlr catholic coop','919945993317','','hampankatta','','','11','574146','Document','10.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','35.00','1','1','2025-11-03 20:08:01','2025-11-03 20:08:01','17617147018423','17617147018423','','3453','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('833','17','1','','4','41848312','2025-11-03','3855','3857','762','BAJAJ ALLIANZ GENERAL INSURANCE CO LTD','918861670333','','','ESSEL WILCON COMPLEX,ABOVE RADHA MEDICALS,BENDOORWELL,MANGALORE-2 4th Floor, 1/2, Golden Heights, 59th C Cross, RAJAJINAGAR, Bengaluru-560010','','29AABCB5730G1ZT','11','575002','MADHUKESH RAI','919845226498','','OPP TO COURT ROAD','UDP','','11','574104','Document','0.01','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','14.00','1','1','2025-11-03 20:09:23','2025-12-20 09:30:19','17617216585187','17617216585187','','863','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','1','1','2025-12-20 09:30:19','','received','','','1','17645841409774');
INSERT INTO `booking` VALUES ('834','10','1','','2','3406756','2025-11-03','','5202','763','VISHNU','919945999540','','','SBI AO6','BEJAI MLR','','11','575004','NOUFAL FAZAL','919632365321','','SBI RBO','COLLEGE ROAD','','11','571201','Document','1000.00','0.00','0.00','0','Document','Surface','1','0.80','','','','','0.80','155.00','1','1','2025-11-03 20:10:42','2025-11-03 20:10:42','17617151801089','17617151801089','','332','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('835','20','1','','2','3418049','2025-11-03','','5197','511','VINAYA HOSPITAL','918242494333','','','KARANGALPADY','','','11','575003','MEDI ASST INS','','','BEGUR','','','11','560068','Document','0.00','0.00','0.00','0','Document','Surface','1','0.25','','','','','0.25','85.00','1','1','2025-11-03 20:11:18','2025-11-03 20:11:18','17616544937223','17616544937223','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('836','17','1','','4','41848313','2025-11-03','3884','3883','764','INDUSIND BANK LIMITED,CVFD','919108046807','','','ESSEL WILLCON COMPLEX,2ND FLOOR,BENDOORWELL,KANKANADY,MANGALORE-575002. ground floor, 28, centinary building, M G Road, bangalore,560001','','29AAACI1314G1ZZ','11','575002','BHOOPAL','918242437443','','IBL','BASAVANAGUDI','','11','560019','Document','0.01','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','18.15','1','1','2025-11-03 20:12:49','2025-12-13 16:58:24','17617216585187','17617216585187','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','1','0','','','','','','1','');
INSERT INTO `booking` VALUES ('837','20','1','','2','3418050','2025-11-03','','5203','511','RAJESH LALITHA JEWELLERY','916364594442','','','PVS','','','11','575003','SATHISH','','','T NAGAR','','','23','600017','Document','0.00','0.00','0.00','0','Document','Surface','1','0.15','','','','','0.15','95.00','1','1','2025-11-03 20:14:25','2025-11-03 20:14:25','17616544937223','17616544937223','','1931','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('838','22','1','','2','3411072','2025-11-03','','5204','765','YADAV POOJARY','917338514186','','','BHUVI DENTAL LAB','MANGALURU','','11','575002','ANANDA','918762481944','','APPU MOBILE','MAIN ROAD','','11','573134','Document','100.00','0.00','0.00','0','Document','Surface','1','0.10','','','','','0.10','75.00','1','1','2025-11-03 20:14:28','2025-11-03 20:14:28','17617169725275','17617169725275','','1130','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('839','10','1','','2','3406757','2025-11-03','','5205','766','EAGLEEYE MANPOWER SOL','917411612195','','','BEJAI','MLR','','11','575004','BG RANGANATH','918123911749','','THE CAMPCO FACTORY','KEMMINJE DARBE','','11','574202','Document','100.00','0.00','0.00','0','Document','Surface','1','0.36','','','','','0.36','85.00','1','1','2025-11-03 20:14:36','2025-11-03 20:14:36','17617151801089','17617151801089','','1904','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('840','17','1','','4','41848314','2025-11-03','3884','3883','767','INDUSIND BANK LIMITED,CVFD','919108046807','','','ESSEL WILLCON COMPLEX,2ND FLOOR,BENDOORWELL,KANKANADY,MANGALORE-575002. ground floor, 28, centinary building, M G Road, bangalore,560001','','29AAACI1314G1ZZ','11','575002','JAYANNA','917259033800','','IBL','BASAVANAGUDI','','11','560019','Document','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','18.15','1','1','2025-11-03 20:15:45','2025-12-13 16:58:24','17617216585187','17617216585187','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','1','0','','','','','','1','');
INSERT INTO `booking` VALUES ('841','20','1','','2','3418051','2025-11-03','','5206','511','LALITHA JEWELLERY','918242497788','','','PVS','','','11','575003','ANEES','','','T NAGAR','','','23','600017','Document','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','70.00','1','1','2025-11-03 20:16:52','2025-11-03 20:16:52','17616544937223','17616544937223','','1931','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('842','10','1','','2','3406758','2025-11-03','','5207','768','ORTHOSQUARE DENTAL CLINIC','918147022807','','','KOTTARACROSS','MLR','','11','575004','DENTAL DESIGN STUDIO','918655513383','','MG ROAD','GOREGAON WEST','','14','400104','Document','5000.00','0.00','0.00','0','Document','Surface','1','0.19','','','','','0.19','130.00','1','1','2025-11-03 20:17:18','2025-11-03 20:17:18','17617151801089','17617151801089','','57','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('843','13','1','','2','3404045','2025-11-03','','5195','511','M A KRISHNA NAYAK','918242427835','','','CARST','','','11','575001','aynapse neuro care pltd','','','kannur','padil','','11','575007','Document','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','35.00','1','1','2025-11-03 20:17:36','2025-11-03 20:17:36','17617147018423','17617147018423','','3453','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('844','17','1','','4','41848315','2025-11-03','3925','3919','769','PHARMA4','919448382595','','','1ST FLOOR,F-3 DIVYA-DEEPA ARCADE,BENDOORWELL,MANGALORE-575002','','29AALFP4090J1ZP','11','575002','MANOHAR C N','919900687610','','NEAR SRI HATTI MARAMMA TEMPLE','CTG','','11','577501','Document','0.01','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','41.00','1','1','2025-11-03 20:18:50','2025-12-20 12:19:47','17617216585187','17617216585187','','391','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','1','1','2025-12-20 12:19:47','','received','','','1','17645841409774');
INSERT INTO `booking` VALUES ('845','20','1','','2','3418052','2025-11-03','','5048','511','MURUGA','','','','KANKANADY','','','11','575002','AVINASH','','','KALYAN NAGAR','','','11','577102','Document','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-03 20:19:11','2025-11-03 20:19:11','17616544937223','17616544937223','','696','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('846','13','1','','2','3404046','2025-11-03','','5195','511','M A KRISHNA NAYAK','918242427835','','','CARST','','','11','575001','s c s hospital','','','upper bendoor','','','11','575002','Document','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','35.00','1','1','2025-11-03 20:19:59','2025-11-03 20:19:59','17617147018423','17617147018423','','3453','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('847','10','1','','2','3406759','2025-11-03','','5208','770','RAVINDRA BANGERA','919880992696','','','DIGANTHA MUDRANA','YEYYADI MLR','','11','575008','DEEPTHI SHERIGAR','919920863486','','MULUND WEST','SIDHARTHNAGAR','','14','400080','Document','2000.00','0.00','0.00','0','Document','Surface','1','1.10','','','','','1.10','370.00','1','1','2025-11-03 20:20:18','2025-11-03 20:20:18','17617151801089','17617151801089','','57','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('848','13','1','','2','3404047','2025-11-03','','5195','511','M A KRISHNA NAYAK','918242427835','','','CARST','','','11','575001','A J RESTORENT','','','KUNTIKANA','','','11','575004','Document','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','35.00','1','1','2025-11-03 20:21:32','2025-11-03 20:21:32','17617147018423','17617147018423','','3453','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('849','20','1','','2','3418053','2025-11-03','','5206','511','LALITHA JEWELLERY','918242497788','','','PVS','','','11','575003','ANEES','','','T NAGAR','','','23','600017','Document','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','70.00','1','1','2025-11-03 20:21:47','2025-11-03 20:21:47','17616544937223','17616544937223','','1931','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('850','13','1','','2','3404048','2025-11-03','','5195','511','M A KRISHNA NAYAK','918242427835','','','CARST','','','11','575001','K M C','','','ATTAVARA','','','11','575001','Document','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','35.00','1','1','2025-11-03 20:23:08','2025-11-03 20:23:08','17617147018423','17617147018423','','3453','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('851','10','1','','2','3406760','2025-11-03','','5209','771','DR NAVEEN KUMAR T','919242233065','','','DEREBAIL KONCHADY','MLR','','11','575006','ROOPA ADKA','919867848860','','PARASIKNAGAR','KALWA WEST THANE','','14','400605','Document','500.00','0.00','0.00','0','Document','Surface','1','0.46','','','','','0.46','170.00','1','1','2025-11-03 20:23:32','2025-11-03 20:23:32','17617151801089','17617151801089','','57','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('852','10','1','','2','3406761','2025-11-03','','5209','772','DR NAVEEN KUMAR T','919242233065','','','DEREBAIL KONCHADY','MLR','','11','575006','VISHNU HEBBAR','919845097094','','HEGGANAHALLI','PEENYA','','11','560091','Document','1000.00','0.00','0.00','0','Document','Surface','1','1.00','','','','','1.00','155.00','1','1','2025-11-03 20:25:09','2025-11-03 20:25:09','17617151801089','17617151801089','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('853','20','1','','2','3418054','2025-11-03','','5048','511','POPULAR AUTO','','','','MANGALORE','','','11','575003','POPULAR AUTO','','','AGRAHARA','','','11','570004','Document','0.00','0.00','0.00','0','Document','Surface','1','0.25','','','','','0.25','85.00','1','1','2025-11-03 20:25:16','2025-11-03 20:25:16','17616544937223','17616544937223','','669','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('854','13','1','','2','3404049','2025-11-03','','5195','511','M A KRISHNA NAYAK','918242427835','','','CARST','','','11','575001','PAI SALES P LTD','','','PANDESHWARA','','','11','575001','Document','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','35.00','1','1','2025-11-03 20:25:27','2025-11-03 20:25:27','17617147018423','17617147018423','','3453','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('855','13','1','','2','3404050','2025-11-03','','5195','511','M A KRISHNA NAYAK','918242427835','','','CARST','','','11','575001','VIVANTA MANGALORE PORT ROAD','','','OLD PORT RD','','','11','575001','Document','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','35.00','1','1','2025-11-03 20:26:54','2025-11-03 20:26:54','17617147018423','17617147018423','','3453','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('856','10','1','','2','3406762','2025-11-03','','5210','773','KARTHIK GADIYAR H','919620472990','','','BEJAI KAPIKAD','MLR','','11','575004','SREEDVI CASHEW INDSTRS','919880512644','','MUDAR','BAJAGOLI','','11','574122','Document','20.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','50.00','1','1','2025-11-03 20:27:38','2025-11-03 20:27:38','17617151801089','17617151801089','','829','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('857','13','1','','2','3404051','2025-11-03','','5195','511','M A KRISHNA NAYAK','918242427835','','','CARST','','','11','575001','IPEX TECHNOLOGIES','','','ALAKE','MLR','','11','575001','Document','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','35.00','1','1','2025-11-03 20:28:12','2025-11-03 20:28:12','17617147018423','17617147018423','','3453','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('858','10','1','','2','3406763','2025-11-03','','5210','774','KARTHIK GADIYAR H','919620472990','','','BEJAI KAPIKAD','MLR','','11','575004','SRI PRATHAMESH EXPORTS','919945246589','','BEHIND POLICE STATION','HEBRI','','11','576112','Document','20.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','50.00','1','1','2025-11-03 20:29:11','2025-11-03 20:29:11','17617151801089','17617151801089','','59','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('859','13','1','','2','3404052','2025-11-03','','5195','511','M A KRISHNA NAYAK','918242427835','','','CARST','','','11','575001','PUNJA DISTRIBUTORS','','','BUN','MLR','','11','575001','Document','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','35.00','1','1','2025-11-03 20:29:40','2025-11-03 20:29:40','17617147018423','17617147018423','','3453','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('860','13','1','','2','3404053','2025-11-03','','5195','511','M A KRISHNA NAYAK','918242427835','','','CARST','','','11','575001','B K TYRASPORT','','','ALK','MLR','','11','575001','Document','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','35.00','1','1','2025-11-03 20:31:05','2025-11-03 20:31:05','17617147018423','17617147018423','','3453','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('861','20','1','','2','3418055','2025-11-03','','5048','511','KVC ACADEMY','','','','MANGALORE','','','11','575003','ABHISHEK','','','DVS PU INDEPENDENT COLLEGE','','','11','577201','Document','0.00','0.00','0.00','0','Document','Surface','1','25.00','','','','','25.00','2750.00','1','1','2025-11-03 20:31:19','2025-11-03 20:31:19','17616544937223','17616544937223','','1664','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('862','10','1','','2','3406764','2025-11-03','','5211','775','KCMA','918242223287','','','BEJAI KAPIKAD','MLR','','11','575004','MISMA FOODS','919036409099','','INDI ROAD','VIJAYAPURA','','11','586104','Document','500.00','0.00','0.00','0','Document','Surface','1','0.30','','','','','0.30','105.00','1','1','2025-11-03 20:32:26','2025-11-03 20:32:26','17617151801089','17617151801089','','2357','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('863','13','1','','2','3404054','2025-11-03','','5195','511','M A KRISHNA NAYAK','918242427835','','','CARST','','','11','575001','INDIANA HOSPITAL','','','PWL','MLR','','11','575001','Document','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','35.00','1','1','2025-11-03 20:32:28','2025-11-03 20:32:28','17617147018423','17617147018423','','3453','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('864','13','1','','2','3404055','2025-11-03','','5195','511','M A KRISHNA NAYAK','918242427835','','','CARST','','','11','575001','PAI INT ELE LTD','','','BUNTS HOSTEL','MLR','','11','575003','Document','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','35.00','1','1','2025-11-03 20:34:01','2025-11-03 20:34:01','17617147018423','17617147018423','','3453','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('865','10','1','','2','3406765','2025-11-03','','5211','776','KCMA','918242223287','','','BEJAI KAPIKAD','MLR','','11','575004','MM DRYFRUIT&SPICES','918217654231','','MADHUPURA','AHMEDABAD','','7','380004','Document','500.00','0.00','0.00','0','Document','Surface','1','0.50','','','','','0.50','170.00','1','1','2025-11-03 20:34:12','2025-11-03 20:34:12','17617151801089','17617151801089','','3','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('866','13','1','','2','3404056','2025-11-03','','5195','511','M A KRISHNA NAYAK','918242427835','','','CARST','','','11','575001','A J GRAND ELITE HOTEL','','','YEKKUR','MLR','','11','575002','Document','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','35.00','1','1','2025-11-03 20:36:01','2025-11-03 20:36:01','17617147018423','17617147018423','','3453','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('867','10','1','','2','3406766','2025-11-03','','5211','777','KCMA','918242223287','','','BEJAI KAPIKAD','MLR','','11','575004','AKS TRANS SOL P LTD','918015931947','','OLD KUMBAKONAM ROAD','PANRUTI','','23','607106','Document','1000.00','0.00','0.00','0','Document','Surface','1','2.50','','','','','2.50','448.00','1','1','2025-11-03 20:36:51','2025-11-03 20:36:51','17617151801089','17617151801089','','231','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('868','13','1','','2','3404057','2025-11-03','','5195','511','M A KRISHNA NAYAK','918242427835','','','CARST','','','11','575001','MAHARAJA FAMILY RESTORENT','','','BUNTS HOSTEL','MLR','','11','575003','Document','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','35.00','1','1','2025-11-03 20:37:24','2025-11-03 20:37:24','17617147018423','17617147018423','','3453','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('869','13','1','','2','3404058','2025-11-03','','5195','511','M A KRISHNA NAYAK','918242427835','','','CARST','','','11','575001','SRI KRISHNA MARBAL','','','NR KANNATAKA AGR','MLR','','11','575006','Document','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','35.00','1','1','2025-11-03 20:39:11','2025-11-03 20:39:11','17617147018423','17617147018423','','3453','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('870','20','1','','2','3418056','2025-11-03','','5212','511','JAYARAMA KAR BANK','919482860074','','','KODIPADY','','','11','574220','DEPT OF SAINIK WELFARE','','','URWASTORE','','','11','575006','Document','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','35.00','1','1','2025-11-03 20:40:18','2025-11-03 20:40:18','17616544937223','17616544937223','','3453','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('871','13','1','','2','3404059','2025-11-03','','5195','511','M A KRISHNA NAYAK','918242427835','','','CARST','','','11','575001','ARCHITECT CHRISTOPHER NORONHA','','','PAN','MLR','','11','575001','Document','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','35.00','1','1','2025-11-03 20:40:36','2025-11-03 20:40:36','17617147018423','17617147018423','','3453','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('872','13','1','','2','3404060','2025-11-03','','5195','511','M A KRISHNA NAYAK','918242427835','','','CARST','','','11','575001','PRAKASH RETAIL','','','FAL','MLR','','11','575001','Document','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','35.00','1','1','2025-11-03 20:42:00','2025-11-03 20:42:00','17617147018423','17617147018423','','3453','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('873','13','1','','2','3404061','2025-11-03','','5195','511','M A KRISHNA NAYAK','918242427835','','','CARST','','','11','575001','BHARATH LOGISTICS','','','BPY','MLR','','11','575011','Document','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','35.00','1','1','2025-11-03 20:43:19','2025-11-03 20:43:19','17617147018423','17617147018423','','3453','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('874','13','1','','2','3404062','2025-11-03','','5195','511','M A KRISHNA NAYAK','918242427835','','','CARST','','','11','575001','HIGHLAND HOSPITAL','','','FAL','MLR','','11','575002','Document','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','35.00','1','1','2025-11-03 20:44:31','2025-11-03 20:44:31','17617147018423','17617147018423','','3453','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('875','13','1','','2','3404063','2025-11-03','','5195','511','M A KRISHNA NAYAK','918242427835','','','CARST','','','11','575001','MAURISHKA PALACE','','','VYASA RAO RD','KADRI','','11','575003','Document','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','35.00','1','1','2025-11-03 20:45:59','2025-11-03 20:45:59','17617147018423','17617147018423','','3453','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('876','13','1','','2','3404064','2025-11-03','','5195','511','M A KRISHNA NAYAK','918242427835','','','CARST','','','11','575001','CANARA BANK','','','RO','MANGALORE','','11','575001','Document','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','35.00','1','1','2025-11-03 20:47:39','2025-11-04 14:42:02','17617147018423','17617147018423','','3453','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('877','13','1','','2','3404065','2025-11-03','','5195','511','M A KRISHNA NAYAK','918242427835','','','CARST','','','11','575001','HOTEL SUMAN RESIDENCY','','','KNY','MLR','','11','575002','Document','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','35.00','1','1','2025-11-03 20:49:35','2025-11-03 20:49:35','17617147018423','17617147018423','','3453','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('878','13','1','','2','3404066','2025-11-03','','5195','511','M A KRISHNA NAYAK','918242427835','','','CARST','','','11','575001','SOMAYAJI HOLDING P LTD','','','BUNTS HOSTEL','MLR','','11','575003','Document','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','35.00','1','1','2025-11-03 20:51:17','2025-11-03 20:51:17','17617147018423','17617147018423','','3453','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('879','13','1','','2','3404067','2025-11-03','','5195','511','M A KRISHNA NAYAK','918242427835','','','CARST','','','11','575001','K M C HOSPITAL','','','JYOTHI','MLR','','11','575001','Document','0.00','0.00','0.00','0','Document','Surface','1','0.44','','','','','0.44','75.00','1','1','2025-11-03 20:56:02','2025-11-03 20:56:02','17617147018423','17617147018423','','3453','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('880','13','1','','2','3404068','2025-11-03','','5195','511','M A KRISHNA NAYAK','918242427835','','','CARST','','','11','575001','MEDHA','','','P M RAO RD','GHS','','11','575001','Document','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','35.00','1','1','2025-11-03 21:05:02','2025-11-03 21:05:02','17617147018423','17617147018423','','3453','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('881','13','1','','2','3404069','2025-11-03','','5195','511','M A KRISHNA NAYAK','918242427835','','','CARST','','','11','575001','SRI DHANALAXMI TRA','','','BUN','MLR','','11','575001','Document','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','35.00','1','1','2025-11-03 21:06:15','2025-11-03 21:06:15','17617147018423','17617147018423','','3453','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('882','13','1','','2','3404070','2025-11-03','','5195','511','M A KRISHNA NAYAK','918242427835','','','CARST','','','11','575001','VASANTHA V PAI','','','BUN','MLR','','11','575001','Document','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','35.00','1','1','2025-11-03 21:07:22','2025-11-03 21:07:22','17617147018423','17617147018423','','3453','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('883','13','1','','2','3404071','2025-11-03','','5195','511','M A KRISHNA NAYAK','918242427835','','','CARST','','','11','575001','STEEL HOUSE','','','BUN','MLR','','11','575001','Document','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','35.00','1','1','2025-11-03 21:14:45','2025-11-03 21:14:45','17617147018423','17617147018423','','3453','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('884','13','1','','2','3404072','2025-11-03','','5195','511','M A KRISHNA NAYAK','918242427835','','','CARST','','','11','575001','ESGEE ENT','','','J M RD','BUN MLR','','11','575001','Document','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','35.00','1','1','2025-11-03 21:16:12','2025-11-03 21:16:12','17617147018423','17617147018423','','3453','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('885','13','1','','2','3404073','2025-11-03','','5195','511','M A KRISHNA NAYAK','918242427835','','','CARST','','','11','575001','CEMENT SALES CORP','','','NR S B I','MLR','','11','575001','Document','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','35.00','1','1','2025-11-03 21:17:53','2025-11-03 21:17:53','17617147018423','17617147018423','','3453','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('886','13','1','','2','3404074','2025-11-03','','5195','511','M A KRISHNA NAYAK','918242427835','','','CARST','','','11','575001','KRISHNA NURSING HOME','','','K. PADY','MLR','','11','575003','Document','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','35.00','1','1','2025-11-03 21:19:35','2025-11-03 21:19:35','17617147018423','17617147018423','','3453','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('887','13','1','','2','3404075','2025-11-03','','5195','511','M A KRISHNA NAYAK','918242427835','','','CARST','','','11','575001','RAMDEV CO','','','BUN','MLR','','11','575001','Document','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','35.00','1','1','2025-11-03 21:21:01','2025-11-03 21:21:01','17617147018423','17617147018423','','3453','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('888','13','1','','2','3404076','2025-11-03','','5195','511','M A KRISHNA NAYAK','918242427835','','','CARST','','','11','575001','SKDRDP','','','FAL','MLR','','11','575001','Document','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','35.00','1','1','2025-11-03 21:22:23','2025-11-03 21:22:23','17617147018423','17617147018423','','3453','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('889','13','1','','2','3404077','2025-11-03','','5195','511','M A KRISHNA NAYAK','918242427835','','','CARST','','','11','575001','S K A D S','','','YEYYADI','MLR','','11','575008','Document','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','35.00','1','1','2025-11-03 21:23:42','2025-11-03 21:23:42','17617147018423','17617147018423','','3453','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('890','13','1','','2','3404078','2025-11-03','','5195','511','M A KRISHNA NAYAK','918242427835','','','CARST','','','11','575001','UNITY HEALTH COMLEX','','','KNY','MLR','','11','575002','Document','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','35.00','1','1','2025-11-03 21:25:11','2025-11-03 21:25:11','17617147018423','17617147018423','','3453','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('891','13','1','','2','3404079','2025-11-03','','5195','511','M A KRISHNA NAYAK','918242427835','','','CARST','','','11','575001','K B L BANK','','','HO PWL','MLR','','11','575008','Document','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','35.00','1','1','2025-11-03 21:26:42','2025-11-03 21:26:42','17617147018423','17617147018423','','3453','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('892','9','1','','2','3283695','2025-11-03','','5213','511','MFR CONDTRUCTIONS P LTD','919964195050','','','KULAI','MANGALORE','','11','575019','MFAR','','','KORAMANGALA','4TH BLOCK','','11','560034','Document','0.00','0.00','0.00','0','Document','Surface','1','0.05','','','','','0.05','60.00','1','1','2025-11-03 21:26:59','2025-11-03 21:26:59','17617247788137','17617247788137','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('893','21','1','','2','3393107','2025-11-04','','5214','778','RAJESH R','919845558144','','','WILSON SURVEYORS & AD, GURU PLAZA,','NEAR KSRTC BUS STAND','','11','575006','SHIBU','919842938435','','MCLARENS INSURANCE SURVEYORS & LOSS','17TH D CROSS, INDIRANAGAR 2ND STAGE','','11','560038','Document','100.00','0.00','0.00','0','Document','Surface','1','0.53','','','','','0.53','125.00','1','1','2025-11-04 09:28:53','2025-11-04 09:28:53','17616388051318','17616388051318','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('894','12','1','','2','3382946','2025-11-04','','5215','779','BALWANT SINGH','919902992916','','','ATTAVARA','MANGALORE','','11','575001','L JAVERCHAND JEWELERS P LTD','917639966944','','ST FLOOR ARS KAMADENU NATARAJAPURAM MEENAKSHIPURAM','MEENAKSHIPURAM','','23','629001','Document','10.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','70.00','1','1','2025-11-04 09:41:32','2025-11-04 09:41:32','17617206505387','17617206505387','','473','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('895','13','1','','2','3404080','2025-11-04','','5216','780','AAMIR','919449366769','','','BIBI ALABI ROAD','MANGALORE','','11','575001','AJANTA TIMES','919900474103','','SHRESH SHEE VIHAR ROAD','SHIKARIPURA','','11','577201','Document','0.00','0.00','0.00','0','Document','Surface','1','1.13','','','','','1.13','201.00','1','1','2025-11-04 09:43:35','2025-11-04 09:44:22','17617147018423','17617147018423','','849','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('896','12','1','','2','3382947','2025-11-04','','5215','511','BALWANT SINGH','919902992916','','','ATTAVARA','MANGALORE','','11','575001','GOLD CITY','','','CONVENT ROAD','VADAKARA','','12','673101','Document','10.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','70.00','1','1','2025-11-04 09:43:50','2025-11-04 09:43:50','17617206505387','17617206505387','','1577','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('897','12','1','','2','3382948','2025-11-04','','5215','511','BALWANT SINGH','919902992916','','','ATTAVARA','MANGALORE','','11','575001','SRI LAXMIDAS JEWELERS','','','BANK ROAD','KANNUR','','12','670001','Document','10.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','70.00','1','1','2025-11-04 09:45:40','2025-11-04 09:45:40','17617206505387','17617206505387','KANANS ARCADE','642','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('898','13','1','','2','3404081','2025-11-04','','5217','511','A VINOD KAMATH','919901491992','','','NEW FIELD STREET','MANGALORE','','43','5750001','THE EXECUTIVE OFFICR','','','TTD ADMINISTRIATIVE BUILDING','K T ROAD','','1','517501','Document','0.00','0.00','0.00','0','Document','Surface','1','0.08','','','','','0.08','90.00','1','1','2025-11-04 09:48:46','2025-11-04 09:48:46','17617147018423','17617147018423','','2061','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('899','10','1','','2','3406767','2025-11-04','','5218','781','UDAYASHANKAR BHAT','919449177677','','','MANGALORE','MANGALORE','','11','575004','DHIRENDRA PRASAD','919871221030','','DLF SQUARE','PHASE 2','','8','122002','Document','100.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','100.00','1','1','2025-11-04 09:52:37','2025-11-04 09:52:37','17617151801089','17617151801089','AMWAY INDIA ENTERPRISES PVT LTD','5','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('900','13','1','','2','3404082','2025-11-04','','5219','782','VIVEK BAGADE','919900157668','','','A/3 PARIJNAN GHS','MANGALORE','','11','575001','UDAY BAGADE','919845557111','','RENAISSANCE PROSPERO','BYATARAYANAPUR','','11','560092','Document','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-04 09:53:17','2025-11-04 09:53:17','17617147018423','17617147018423','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('901','20','1','','2','3418057','2025-11-04','','5220','783','NARENDRA KAMATH','919845744368','','','CHILIMBI','MANGALORE','','11','575001','CA B H NAKUL PAI','919880283777','','BEHIND KONCHADY NAGESH SHENOY GROCERY','OPP MANGALA HOSPITAL MALLIKATTA ROAD KADRI','','11','575004','Document','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','40.00','1','1','2025-11-04 09:53:57','2025-11-26 15:56:16','17616388667516','17616388667516','','3453','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('902','13','1','','2','3404083','2025-11-04','','5219','784','VIVEK BAGADE','919900157668','','','A/3 PARIJNAN GHS','MANGALORE','','11','575001','BAGADE NARENDRA','919900566823','','SPECETA CYPRESS','KUNDANAHALLI GATE','','11','560066','Document','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-04 09:55:08','2025-11-04 09:55:08','17617147018423','17617147018423','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('903','13','1','','2','3404084','2025-11-04','','5219','785','VIVEK BAGADE','919900157668','','','A/3 PARIJNAN GHS','MANGALORE','','11','575001','MURALIDHAR RAO BAGADE','919731254888','','DUDENCLAVE LAYOUT','KODICHIKKANAHALLI MAIN ROAD','','11','560076','Document','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-04 09:57:48','2025-11-04 09:57:48','17617147018423','17617147018423','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('904','13','1','','2','3404085','2025-11-04','','5219','786','VIVEK BAGADE','919900157668','','','A/3 PARIJNAN GHS','MANGALORE','','11','575001','MS SARSWATH KAMATH','919632257936','','5613 VEDAVATHI BLOCK','BANASHANKARI 3 RD STAGE','','11','560085','Document','0.00','0.00','0.00','1','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-04 09:59:33','2025-11-04 09:59:33','17617147018423','17617147018423','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('905','13','1','','2','3404086','2025-11-04','','5219','511','VIVEK BAGADE','919900157668','','','A/3 PARIJNAN GHS','MANGALORE','','11','575001','SRI GURUNANDAN K','','','OPP PUNJAB NATIONAL BANK','HSR NAGAR','','11','560054','Document','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-04 10:00:56','2025-11-04 10:00:56','17617147018423','17617147018423','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('906','26','1','','2','3400879','2025-11-04','','5221','787','SUJATHA SHETTY','919845240795','','','FACE CARE TKT','MLR','','11','575017','SAVITHA SHETTY RAJ','919481141777','','FUELS HP PETROL PUMP','PERNE','','11','574325','Document','500.00','0.00','0.00','0','Document','Surface','1','0.16','','','','','0.16','75.00','1','1','2025-11-04 10:02:46','2025-11-04 10:02:46','17615707686074','17615707686074','','783','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('907','13','1','','2','3404087','2025-11-04','','5219','788','VIVEK BAGADE','919900157668','','','A/3 PARIJNAN GHS','MANGALORE','','11','575001','AJITH R TRIKANNAD','919902037518','','A1 BLOCK  2ND MAIN','3RD STAGE VIDYANAGAR','','11','570020','Document','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-04 10:02:52','2025-11-04 10:02:52','17617147018423','17617147018423','','669','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('908','13','1','','2','3404088','2025-11-04','','5219','789','VIVEK BAGADE','919900157668','','','A/3 PARIJNAN GHS','MANGALORE','','11','575001','PUSHPA ANAND KABAD','918141416717','','BESIDES SANDESH PRESS','VASTRAPUR','','7','380015','Document','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','100.00','1','1','2025-11-04 10:04:26','2025-11-04 10:04:26','17617147018423','17617147018423','','3','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('909','13','1','','2','3404089','2025-11-04','','5219','790','VIVEK BAGADE','919900157668','','','A/3 PARIJNAN GHS','MANGALORE','','11','575001','BAGADE ARVIND RAO','919820377653','','YASHODHAM ENCLAVE','GOREGAON (E)','','14','400063','Document','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','100.00','1','1','2025-11-04 10:05:51','2025-11-04 10:05:51','17617147018423','17617147018423','','57','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('910','13','1','','2','3404090','2025-11-04','','5219','791','VIVEK BAGADE','919900157668','','','A/3 PARIJNAN GHS','MANGALORE','','11','575001','SMT SMITHA VIJASHANKAR GAWGOLLY','919978944058','','9/7 SARASWATH COLONY','SANTACRUZ (W)','','14','400054','Document','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','100.00','1','1','2025-11-04 10:07:51','2025-11-04 10:07:51','17617147018423','17617147018423','','57','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('911','13','1','','2','3404091','2025-11-04','','5219','792','VIVEK BAGADE','919900157668','','','A/3 PARIJNAN GHS','MANGALORE','','11','575001','NEENA MURDESHWAR','919820520384','','MARINA ENCLAVE ROAD','JANKALYAN NAGAR  MALAD (W)','','14','400095','Document','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','100.00','1','1','2025-11-04 10:09:17','2025-11-04 10:09:17','17617147018423','17617147018423','','57','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('912','22','1','','2','3411073','2025-11-04','','4612','793','M V ENTERPRISES','918296470054','','','SHOP NO 4 AKSHAYA COMPLEX','MAIN RD KADABA','','11','574221','BLUCROSS ENTERPRISES','919886031100','','S P ROAD CROSS','BANGALORE','','11','560002','Document','0.10','0.00','0.00','0','Document','Surface','1','0.60','','','','','0.60','125.00','1','1','2025-11-04 10:10:15','2025-11-04 10:10:15','17617169725275','17617169725275','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('913','13','1','','2','3404092','2025-11-04','','5219','511','VIVEK BAGADE','919900157668','','','A/3 PARIJNAN GHS','MANGALORE','','11','575001','CHITRA DURGESH KOPPIKAR','','','A-1 KARNATAK SOCIETY','MAHIM','','14','400016','Document','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','100.00','1','1','2025-11-04 10:10:52','2025-11-04 10:10:52','17617147018423','17617147018423','','57','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('914','13','1','','2','3404093','2025-11-04','','5219','794','VIVEK BAGADE','919900157668','','','A/3 PARIJNAN GHS','MANGALORE','','11','575001','MS SUNITHA BAGADE','919833936755','','B-1/9 SARSWATH COLONY','','SANTACRUZ (W)','14','400054','Document','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','100.00','1','1','2025-11-04 10:12:14','2025-11-04 10:12:14','17617147018423','17617147018423','','57','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('915','13','1','','2','3404094','2025-11-04','','5219','795','VIVEK BAGADE','919900157668','','','A/3 PARIJNAN GHS','MANGALORE','','11','575001','JYOTHI GANESH BAGADE','917021359516','','OPP OJAS EYE HOSPITAL THANKURVILL','KANDIVALI EAST','','14','420066','Document','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','100.00','1','1','2025-11-04 10:14:17','2025-11-04 10:14:17','17617147018423','17617147018423','','57','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('916','13','1','','2','3404095','2025-11-04','','5219','796','VIVEK BAGADE','919900157668','','','A/3 PARIJNAN GHS','MANGALORE','','11','575001','SATHISH BILGI','914820787513','','ARURLI ROAD','KANDIVALI (E)','','14','400101','Document','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','100.00','1','1','2025-11-04 10:15:44','2025-11-04 10:15:44','17617147018423','17617147018423','','57','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('917','20','1','','2','3418058','2025-11-04','','5222','797','GIRISH SHETTY','919060979961','','','NEAR MUSEUM ROAD','MANGALORE','','11','575004','ADV SACHIN B S','911991682398','','GURUKRUPA LOWER PALACE #35 1ST MAIN ROAD','SADHASHIVANAGAR GUTHAHALLI','','11','560003','Document','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-04 10:16:57','2025-11-04 10:16:57','17616388667516','17616388667516','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('918','13','1','','2','3404096','2025-11-04','','5219','798','VIVEK BAGADE','919900157668','','','A/3 PARIJNAN GHS','MANGALORE','','11','575001','SRI M SATHISH RAO','919223501231','','2 SIDHRATNAKAR SOCIETY','PRAIBHANAGAR, PRABHADEVI','','14','400025','Document','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','100.00','1','1','2025-11-04 10:17:45','2025-11-04 10:17:45','17617147018423','17617147018423','','57','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('919','17','1','','2','3404697','2025-11-04','','5223','799','DYNA NAZRATH','919820650976','','','KANKANADY','MANGALORE','','11','575002','LILIAN DCOSTA','919820650976','','DHANLAXMI C H S','CHARKOP KHANDWILI','','14','400067','Cloths','0.00','0.00','0.00','0','Document','Surface','1','0.83','','','','','0.83','290.00','1','1','2025-11-04 10:18:12','2025-11-04 10:18:12','17617216042295','17617216042295','','57','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('920','24','1','','2','3399484','2025-11-04','','5224','800','SRI VENKATRAMANA CO OP SOCIETYLTD','918762986830','','','PUMPWELL','MANGALORE -  02','','11','575002','CEO, SHRI VENKATRAMANA CREDIT CO OP SOCIETY','918257232256','','MOGARPANE,','SULLIA -  574239','','11','574239','Document','0.00','0.00','0.00','0','Document','Surface','1','0.01','','','','','0.01','50.00','1','1','2025-11-04 10:18:15','2025-11-04 10:18:15','17617227922084','17617227922084','','2577','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('921','23','1','','2','3408541','2025-11-04','','5225','511','KARAVALI PRINTERS','919480267214','','','AZIZUDDIN RD','MANGALORE','00','11','575001','AM (E & C)','','','PANAMBUR','MANGALORE','00','11','575010','Document','100.00','0.00','0.00','0','Document','Surface','1','0.20','','','','','0.20','130.00','1','1','2025-11-04 10:18:41','2025-11-04 10:18:41','17617218175043','17617218175043','PPU KIOCL LTD','3271','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('922','13','1','','2','3404097','2025-11-04','','5219','801','VIVEK BAGADE','919900157668','','','A/3 PARIJNAN GHS','MANGALORE','','11','575001','ARUN PADBIDRI','919821456563','','NIVAS ROAD SARSWAT COLONY','SANTACRUZ (WEST)','','14','400054','Document','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','100.00','1','1','2025-11-04 10:19:29','2025-11-04 10:19:29','17617147018423','17617147018423','','57','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('923','13','1','','2','3404098','2025-11-04','','5219','802','VIVEK BAGADE','919900157668','','','A/3 PARIJNAN GHS','MANGALORE','','11','575001','MS THARA CHANDWARKAR','919987419496','','B-11 ATHASHRI SOCIETY','MAGARPATTA ROAD  HADAPSAR','','14','411036','Parcel','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','100.00','1','1','2025-11-04 10:21:13','2025-11-04 10:21:13','17617147018423','17617147018423','','13','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('924','10','1','','2','3406768','2025-11-04','','5226','803','RAVISHANKAR','919686342043','','','VAIDYANATHA NAGAR','ATTAVAR','','11','575001','NELSON PINTO','919769961330','','I C COLONY','BORIVALI WEST','','14','400103','Document','100.00','0.00','0.00','0','Document','Surface','1','0.18','','','','','0.18','130.00','1','1','2025-11-04 10:21:16','2025-11-04 10:21:16','17617151801089','17617151801089','A 302 ROYAL TOWER CHS','57','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('925','13','1','','2','3404099','2025-11-04','','5219','804','VIVEK BAGADE','919900157668','','','A/3 PARIJNAN GHS','MANGALORE','','11','575001','MS VIJAYA BAGADE','919860710456','','D3/12 ELITE GARDEN','NAGRAS ROAD, AUNDH','','14','411007','Document','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','100.00','1','1','2025-11-04 10:22:41','2025-11-04 10:22:41','17617147018423','17617147018423','','13','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('926','23','1','','2','3408542','2025-11-04','','5048','511','DISTRICT MINARITY','','','','PANDESHWAR','MANGALORE','','23','','M D','','','RAJAJINAGAR','BANGALORE','','11','560010','Document','100.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-04 10:24:23','2025-11-04 10:24:23','17617218175043','17617218175043','KARNATAKA RAJE TENGIN NARIN DEV','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('927','20','1','','2','3418059','2025-11-04','','5227','511','K PREMNATH','919448159326','','','PVS KALAKUNJA ROAD','KODIALBAIL MANGALORE','','11','575003','SCDCC BANK LT','','','KATIPALLA','KATIPALLA BRANCH','','11','575014','Document','10.00','0.00','0.00','0','Document','Surface','1','0.34','','','','','0.34','85.00','1','1','2025-11-04 10:36:03','2025-11-04 10:36:03','17616388667516','17616388667516','','3211','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('928','22','1','','2','3411074','2025-11-04','','5228','805','manish kumar','919964215189','','','G FLOOR ARHATH ADITHYA RESIDENY','PONNECHERI MASTHIKATTE MOODBIDRI','','11','574222','ARUN KUMAR T R','919902654812','','24047 4T6H FLOOR','B2 T4 PRESTIGE JINDAL CITY BANGALORE','','11','560073','Document','0.10','0.00','0.00','0','Document','Surface','1','0.10','','','','','0.10','75.00','1','1','2025-11-04 10:37:15','2025-11-04 10:37:15','17617169725275','17617169725275','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('929','10','1','','2','3406769','2025-11-04','','5229','806','JAYALAKSHMI  SILKS','918244299999','','','BEJAI KAPIKAD','MANGLAORE','','23','637001','M EASHWAR','917904188721','','TNHB MOHANUR ROAD','NAMAKKAL','','23','637001','Cloths','5000.00','0.00','0.00','0','Document','Surface','1','10.20','','','','','10.20','1375.00','1','1','2025-11-04 10:39:22','2025-11-04 10:39:22','17617151801089','17617151801089','H/ 23 ANBUNAGAR','2424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('930','22','1','','2','3411075','2025-11-04','','5230','807','N SRINIVASA','919916618736','','','RAILWAY Q','PANDESHWARA MANGALORE','','11','575003','SANEKT WAYKER','912266762800','','MACLODS PHARMACEUTICALS','3RD FLOOR ARLANTA ARCADE ANDHERI EAST','','14','400059','Document','0.10','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','100.00','1','1','2025-11-04 10:40:44','2025-11-04 10:40:44','17617169725275','17617169725275','','57','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('931','10','1','','2','3406770','2025-11-04','','5229','808','JAYALAKSHMI  SILKS','918244299999','','','BEJAI KAPIKAD','MANGLAORE','','23','637001','AJITHA','919840793596','','MADAMBAKKAM','CHENNAI','','23','600126','Cloths','5000.00','0.00','0.00','0','Document','Surface','1','5.10','','','','','5.10','750.00','1','1','2025-11-04 10:42:14','2025-11-04 10:42:14','17617151801089','17617151801089','58, PADMAVATHY NAGAR EXTN','1931','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('932','17','1','','2','3404698','2025-11-04','','5231','809','ALBERT MONIS','919980246159','','','KANKANADY','MANGALORE','','6','403401','SUNITHA DSOUZA','918668890482','','SAI NIWAS BUILDING','JOFFIL NAGAR PONDA','','6','403401','Document','0.00','0.00','0.00','0','Document','Surface','1','0.16','','','','','0.16','95.00','1','1','2025-11-04 10:43:48','2025-11-04 10:43:48','17617216042295','17617216042295','','628','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('933','10','1','','2','3406771','2025-11-04','','5232','810','RAJEESH K','919611033760','','','MUMBAI TRAVEL RETAIL PVT LTD','MANGALORE INT AIRPORT','','11','574142','BHAGYASHRI SANAS','918657425221','','FEC GLOBAL LOGISTICS PVT LTD','PREMIER ROAD, GHATKOPAR WEST','','14','400086','Document','100.00','0.00','0.00','0','Document','Surface','1','0.20','','','','','0.20','130.00','1','1','2025-11-04 10:50:14','2025-11-04 10:50:14','17617151801089','17617151801089','FEC CLEARING PVT LTD','57','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('934','23','1','','2','3408543','2025-11-04','','5233','811','PACK MART','919480045140','','','BUNDER','MANGALORE','','23','','PRIME POLYMERS','919845231244','','HOOTAGALLY BELAVADI POST','','','11','570018','Document','100.00','0.00','0.00','0','Document','Surface','1','0.10','','','','','0.10','75.00','1','1','2025-11-04 10:50:18','2025-11-04 10:50:18','17617218175043','17617218175043','HOOTAGALLY INDU AREA','669','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('935','21','1','','2','3393108','2025-11-04','','5234','812','VIKSHITH','918123407875','','','JDS LOGISTICS, KOTTARA','CHOWKI','','11','575006','ESSAKIMUTHU R','918050568839','','JDS LOGISTICS','CHICKATHAYAPPA LAYOUT, CHELKER, KALYAN NAGAR','','11','560043','Document','50.00','0.00','0.00','0','Document','Surface','1','0.05','','','','','0.05','60.00','1','1','2025-11-04 10:50:20','2025-11-04 10:50:20','17616388051318','17616388051318','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('936','26','1','','2','3400880','2025-11-04','','5235','813','ROHITH','917090236578','','','TABLETS INDIA LTD','MLR','','11','575018','MANIVANNAN','911444205000','','TABLETS INDIA LTD','72 MARSHALS RD','','23','600008','Document','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','70.00','1','1','2025-11-04 10:51:33','2025-11-04 10:51:33','17615707686074','17615707686074','','1931','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('937','10','1','','2','3406772','2025-11-04','','5236','814','CAPITAL CONSTRUCTIONS','917338189127','','','MUDRANI HOMES','KAVOOR MANGALORE','','11','575015','TRIDENT BHUMI PROJECTS PVT LTD','919731779640','','SIR C V RAMAN AVENUE','SADASHIVA NAGAR','','11','560080','Document','100.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-04 10:54:08','2025-11-04 10:54:08','17617151801089','17617151801089','NO 103A RANKA ENCLAVE','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('938','8','1','','2','3351497','2025-11-04','','5237','815','ABDUL AZIZ','919164874780','','','DYNAMIC SERVICE STATION','NR FRONTLINE  BAJPE','','11','574142','BINULAL SS','919447886801','','LALBHAVAN  KUTTIYANI PANTHALACODE PO','TRIVANDRUM','','12','695028','Non Doc','0.00','0.00','0.00','0','Document','Surface','1','20.20','','','','','20.20','2625.00','1','1','2025-11-04 10:55:42','2025-11-04 11:45:04','17617178859109','17617178859109','','1960','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('939','20','1','','2','3418060','2025-11-04','','5238','816','PRASHANTH N K','918549952537','','','MANGALORE','','','11','575001','TULIP DIAGNOSTICS P LTD','918042524000','','KASTURI NAGAR','EAST OF NGEF BANGALORE','','11','560043','Document','10.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-04 10:56:47','2025-11-04 10:56:47','17616388667516','17616388667516','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('940','21','1','','2','3393109','2025-11-04','','5239','817','ER KALBAVI RAJENDRA RAO','919448287534','','','PADMA NIVAS, OPP INFOSYS','KOTTARA','','11','575006','S D ANNE GOWDA','919945517462','','ASSOCIATION OF CONSULTIBG CIVIL ENGINEERS','NEAR YEDIYUR CIRCLE','','11','560070','Document','100.00','0.00','0.00','0','Document','Surface','1','0.11','','','','','0.11','85.00','1','1','2025-11-04 11:02:40','2025-11-04 11:02:40','17616388051318','17616388051318','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('941','23','1','','2','3408544','2025-11-04','','5240','818','PRATIK R JOSHU','919601911647','','','KADRI KAMBLA RD','MANGALORE','','11','575001','RAJEMDRA M JOSHI','919687613789','','UMA MARG UNIVERSITY RD','RAJKOT','','7','360005','KEY','200.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','100.00','1','1','2025-11-04 11:03:23','2025-11-04 11:03:23','17617218175043','17617218175043','J K CHOWK','491','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('942','10','1','','2','3406773','2025-11-04','','5241','677','PRANAM SHETTY','919108750856','','','DEVASYA HOUSE','PUDU POST AND VILLAGE, BANTWAL','','11','574143','REETHA','918042401999','','ARISTO PHARMACEUTICALS PVT LTD','PEENYA INDL AREA','','11','560058','Document','100.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-04 11:05:24','2025-11-04 11:05:24','17617151801089','17617151801089','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('943','26','1','','2','3400881','2025-11-04','','5242','819','MAHANTESH N D','918296392863','','','APEX LAB','MLR','','23','','DATA ANALYSIS DEPT','914442225000','','GUINDY','','','23','600032','Document','10.00','0.00','0.00','0','Document','Surface','1','0.13','','','','','0.13','95.00','1','1','2025-11-04 11:07:48','2025-11-04 11:07:48','17615707686074','17615707686074','APEX LAB P LTD','1931','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('944','25','1','','2','3388865','2025-11-04','','5243','820','ANWAR HASAN','919110221385','','','KATIPALLA','MLR','','11','575030','ANJALI MADAN','919148393322','','IND AREA KONAJE','KAMBALAPADAVU','','11','574199','Document','100.00','0.00','0.00','0','Document','Surface','1','0.10','','','','','0.10','65.00','1','1','2025-11-04 11:12:03','2025-11-26 15:56:16','17617202587270','17617202587270','DECCAN PLAST IND','3453','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('945','8','1','','2','3351498','2025-11-04','','5244','511','NITHESH PRASAD','919643678838','','','JOBBY ENGINEERS PVT LTD','BAJPE','','11','574142','AMRITA SADVELKAR','','','JOBBY ENGINEERS PVT LTD LBS MARG','MULUND MUMBAI','','14','400080','Document','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','100.00','1','1','2025-11-04 11:12:57','2025-11-04 11:12:57','17617178859109','17617178859109','','57','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('946','16','1','','2','3357233','2025-11-04','','5245','821','DR T RAMESH MALLY','918105611936','','','KAIKAMBA','MANGALORE','','11','574151','V A RUKMINI','918762686396','','NAZARBAD','MYSORE','','11','570010','Document','100.00','5.00','0.00','0','Document','Surface','1','0.13','','','','','0.13','85.00','1','1','2025-11-04 11:27:39','2025-11-10 11:53:57','17617177578387','17617177578387','','669','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('947','22','1','','2','3411076','2025-11-04','','5246','822','HIMA REFRIGERATION','919164115665','','','YENEPOYA MALL KADRI RD','MANGALORE','','11','575002','MITSUBISHI ELECTRIC INDIA','918147252300','','ESQUIRE CENTRE NO 9 B WING','M G ROAD BANGALORE','','11','560001','Document','0.10','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-04 11:28:16','2025-11-04 11:28:16','17617169725275','17617169725275','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('948','22','1','','2','3411077','2025-11-04','','5247','823','MELWIN P RODRIGUES','919591354973','','','PADEMAR HOUSE','SAJIPANADU POST BANTWAL','','11','574231','THE UNITED INDIA INS','919591354973','','2ND FLOOR SUSHILA SANJIV ENCLAVE','MARKET RD KARKALA','','11','574104','Document','0.10','0.00','0.00','0','Document','Surface','1','0.18','','','','','0.18','75.00','1','1','2025-11-04 11:32:43','2025-11-04 11:32:43','17617169725275','17617169725275','','75','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('949','17','1','','2','3404699','2025-11-04','','5248','824','SUNITHA VAMAN','918970637698','','','PADI','MANGALORE','','11','575002','SHRUTHI KOTIAN','918296760802','','THE BANGALORE CITY CO OP BANK LTD','KUVEMPU NAGAR','','11','570023','Document','0.01','0.00','0.00','0','Document','Surface','1','0.60','','','','','0.60','125.00','1','1','2025-11-04 11:41:47','2025-11-04 11:41:47','17617216042295','17617216042295','','669','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('950','20','1','','2','3418061','2025-11-04','','5249','825','ganesh h p','919980245231','','','KODIALBAIL','','','11','575001','HARISH HALKURTI','919538314850','','LAKSHMESHWAR','','','11','582210','Document','10.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-04 11:42:29','2025-11-04 11:42:29','17616388667516','17616388667516','REVAN SIDDEHSWAR GEN STORE SHIGLI','55','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('951','10','1','','2','3406774','2025-11-04','','5250','677','BHOOSHAN RAI','917483994796','','','MANGALORE','','','11','575004','REETHA','918042401999','','ARISTO PHARMACEUTICALS PVT LTD','PEENYA INDL AREA','','11','560058','Document','100.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-04 11:44:44','2025-11-04 11:44:44','17617151801089','17617151801089','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('952','18','1','','2','3385040','2025-11-04','','5251','826','MADURAI','919611415454','','','TERMINAL THANIRBHAVI','MANGALORE','','11','575010','YASHWANTH KOTIAN','919930020226','','KARMABHOOMI TERRACE','ANDHERI EAST MUMBAI','','14','400093','Document','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','100.00','1','1','2025-11-04 11:45:48','2025-11-04 11:45:48','17621531273939','17621531273939','','57','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('953','20','1','','2','3418062','2025-11-04','','5252','827','ABHIJITH P VAICHAL','918147893555','','','HATHILL LALABAGH MANGALORE','','','11','575006','MOHD TOUSEEF RHG SERVICES PVT LTD','919148028424','','2ND BLOCK HBR LAYOUT','#2010 1ST FLOOR 80FT ROAD MAIN ROAD','','11','560043','Document','10.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-04 11:46:33','2025-11-04 11:46:33','17616388667516','17616388667516','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('954','18','1','','2','3385041','2025-11-04','','5253','828','RUSAID','918431849548','','','LOGISCO MANGALORE','','','11','575013','SRI VENKATARAMANA TRANSPORT','917094436483','','AND LOGISTICES SARAVAMPATTI','COIMBATORE','','23','641035','Document','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','70.00','1','1','2025-11-04 11:50:26','2025-11-04 11:50:26','17621531273939','17621531273939','','535','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('955','25','1','','2','3388866','2025-11-04','','5254','829','K ROSHAN NARAYAN','918495972826','','','ANUGRAHA KADAMBODI','SURATHKAL 575014','','11','575014','MARSSTAR HUBLI','919738594959','','ASHOKPURAM MAHALAXMI LAYOUT','YESHWANTHPUR BANGLORE','','11','560022','Parcel','2200.00','0.00','0.00','0','Document','Surface','1','1.20','','','','','1.20','201.00','1','1','2025-11-04 11:50:37','2025-11-04 11:50:37','17617202587270','17617202587270','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('956','20','1','','2','3418063','2025-11-04','','5255','830','SANTHOSH RAO B','919845084312','','','LANDLINKS TOWNSHIP','MANGALORE','','11','575008','SRI RAMESH PRABHU','919900218177','','SAKSHAMA KARNATAKA DAKSHIN PRANCTH','AMRUTHA SHISHI NIROSHA BUILDING N R COLONY','','11','560004','Document','10.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-04 11:52:44','2025-11-04 11:52:44','17616388667516','17616388667516','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('957','18','1','','2','3385042','2025-11-04','','5253','831','RUSAID','918431849548','','','LOGISCO MANGALORE','','','11','575013','VRAJ CEMENT LLP TDP','919948180963','','AMBEDKAR NAGAR ANANTAPUR','ANDHRAPRADESH','','1','515411','Document','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','70.00','1','1','2025-11-04 11:55:00','2025-11-04 11:55:00','17621531273939','17621531273939','','2517','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('958','26','1','','2','3400882','2025-11-04','','5256','832','mohd naufal','919964841617','','','ullal','mlr','','23','','shree transport','919141571454','','new tharagupet','','','11','560002','Document','10.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-04 11:58:22','2025-11-04 11:58:22','17615707686074','17615707686074','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('959','13','1','','2','3404100','2025-11-04','','5257','833','MANIKANTAN','916363251054','','','CARST','MANGALAORE','','11','575001','GIRISH','919611902479','','CHOKKASANDRA LAKE ROAD','T DASARHALLI','','11','560057','Document','10.00','0.00','0.00','0','Document','Surface','1','0.20','','','','','0.20','90.00','1','1','2025-11-04 11:59:18','2025-11-04 11:59:18','17617147018423','17617147018423','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('960','20','1','','2','3418064','2025-11-04','','5258','834','JAYASHREE P NAYAK','919742506134','','','NEAR SANTHEKATTE','BELTHANGADY','','11','574214','SRI DHANANJAY KUMAR','918197687380','','1ST FLOOR OFFICE #1079/A','DR RAJKUMAR ROAD','','11','560021','Document','10.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-04 11:59:54','2025-11-04 11:59:54','17616388667516','17616388667516','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('961','13','1','','2','3404101','2025-11-04','','5257','835','MANIKANTAN','916363251054','','','CARST','MANGALAORE','','11','575001','DAYAVATHI','919945009744','','BHARATH SEVA KENDRA','','','43','','Document','10.00','0.00','0.00','0','Document','Surface','1','0.20','','','','','0.20','80.00','1','1','2025-11-04 12:03:03','2025-11-04 12:03:03','17617147018423','17617147018423','','3219','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('962','26','1','','2','3400883','2025-11-04','','5259','836','chandrashekar rai','918618963411','','','mlr','','','11','','girish a','919739999203','','amrut dist p ltd','r m r rd','','11','560027','Document','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-04 12:04:09','2025-11-04 12:04:09','17615707686074','17615707686074','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('963','7','1','','2','3395040','2025-11-04','','5260','837','SRI MATHA TRANSPORT','919741566266','','','APMC BUILDING','BAIKAMPADY','','11','575011','ALLWIN TRANSPORT','919442225922','','PARAMATHI','NAMAKKAL','','23','637207','Document','0.00','0.00','0.00','0','Document','Surface','1','0.01','','','','','0.01','70.00','1','1','2025-11-04 12:05:15','2025-11-04 12:05:15','17617199828916','17617199828916','','2424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('964','7','1','','2','3395041','2025-11-04','','5261','838','SRI MATHA TRANSPORT','919742166226','','','APMC BUILDING','BAIKAMPADY','','11','575011','TUTY LORRY BOOK OFFICE','919843125504','','ETTAYAPURAM ROAD','THOOTHUKUDI','','23','628002','Document','0.00','0.00','0.00','0','Document','Surface','1','0.01','','','','','0.01','70.00','1','1','2025-11-04 12:07:52','2025-11-04 12:07:52','17617199828916','17617199828916','','2549','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('965','7','1','','2','3395042','2025-11-04','','5262','839','SRI MATHA TRANSPORT','918220911619','','','APMC BUILDING','BAIKAMPADY','','11','575011','MURALI AND CO','919843035417','','MAIL STREET','COIMBATORE','','23','641001','Document','0.00','0.00','0.00','0','Document','Surface','1','0.01','','','','','0.01','70.00','1','1','2025-11-04 12:13:29','2025-11-04 12:13:29','17617199828916','17617199828916','','535','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('966','23','1','','2','3408545','2025-11-04','','5263','840','CHARAN KUMAR','919481472819','','','PANDESHWARA','','','23','','CHANDRASHEKAR HEGDE','919035917928','','DARBE','','','11','574202','Document','100.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','50.00','1','1','2025-11-04 12:16:26','2025-11-04 12:16:26','17617218175043','17617218175043','PRAVEEN CAPITAL (P) LTD','1904','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('967','22','1','','2','3411078','2025-11-04','','5264','807','SHIVA','918095503952','','','PROCARE MAX','MANGALORE','','11','575003','SURENDRA','912266762800','','MACLODS PHARMACEUTICALS','IST FLOOR ARLANTA ARCADE ANDHERIKURLA RD','','14','400093','Document','0.10','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','100.00','1','1','2025-11-04 12:19:22','2025-11-04 12:19:22','17617169725275','17617169725275','','57','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('968','7','1','','2','3395043','2025-11-04','','5265','841','S S KEROOR','918105643027','','','MANTESH NAGAR','RAMDURG','','11','575011','M SURESH','919443021520','','THIRUNAGAR COLONY','ERODE','','23','638003','Document','0.00','0.00','0.00','0','Document','Surface','1','0.01','','','','','0.01','70.00','1','1','2025-11-04 12:19:50','2025-11-04 12:19:50','17617199828916','17617199828916','','114','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('969','23','1','','2','3408546','2025-11-04','','5266','842','THE CHIEF FIRE STATION OFFICE','918242444046','','','PANDESHWARA','MANGALORE','','23','','DIRECTOR','916363416355','','I A M ROAD','00','','11','560042','Document','100.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-04 12:19:54','2025-11-04 12:19:54','17617218175043','17617218175043','KARNATAKA FIRE OFFICE','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('970','20','1','','2','3418065','2025-11-04','','5267','843','EDELWEISS ASSET MANAGEMENT','919606853541','','','ADHEESH AVENUE BUILDNG','OPP BESANT CLG MANGALORE','','11','575003','RAGHU MURTHY EDELWEISS MUTUAL FUND','919136918713','','8TH FLOOR PRESTIGE MARIDIAN','#20 M G ROAD','','11','560001','Document','10.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-04 12:21:23','2025-11-04 12:21:23','17616388667516','17616388667516','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('971','22','1','','2','3411079','2025-11-04','','5268','844','VASANTHA KARANTH','918971042378','','','SHRIKRIPA KELINJARU VILLAGE','KUPPEPADAVU MANGALORE','','11','575003','AMAR SHETTY','919845569999','','205 BRINDAVAN APTS','HOSUR RD BANGALORE','','11','560030','Document','0.10','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-04 12:28:44','2025-11-04 12:28:44','17617169725275','17617169725275','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('972','22','1','','2','3411080','2025-11-04','','5268','845','DIVYASHREE K','918971042378','','','MAITRI ADITYA GARDEN','MANGALORE','','11','575003','DR VIJAYA SHETTY','919448983422','','SAGAR PRABHA','PRABHA NAGAR MUMBAI','','14','400025','Document','0.10','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','100.00','1','1','2025-11-04 12:31:00','2025-11-04 12:31:00','17617169725275','17617169725275','','57','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('973','20','1','','2','3418066','2025-11-04','','5269','846','PRADHANAMANTRI BHARTIYA JANAUSHADI KENDRA','917975147534','','','PVS KALAKUNJA ROAD','KODIALBAIL MANGALORE','','11','575003','JIIVA RAKSHA SURGICALS','917353374259','','GROUND FLOOR OLD MANANDAWADI ROAD','NACHANAHALLI VILLAGE SRIRAMPURA 2ND STAGE','','11','570023','Document','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-04 12:32:05','2025-11-04 12:32:05','17616388667516','17616388667516','','669','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('974','10','1','','2','3406775','2025-11-04','','5270','847','CALLS INDIA','917353723623','','','BEJAI','MANGALORE','','11','575004','VARADARAJ ENTERPRISES','919380524580','','BSK 3RD STAGE','BANGALORE','','11','560085','Document','100.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-04 12:33:27','2025-11-04 12:33:27','17617151801089','17617151801089','10TH MAIN PAPAIAH GARDEN','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('975','6','1','','2','3381542','2025-11-04','','5271','848','SATHISH M PENGAL','919036719916','','','CHURCH COMPOUND','BOCKKAPTNA','','11','575003','K ABDUL JABBAR','919845820869','','ROOM NO 5005 5TH FLOOR','L H BUILDNG','','11','560001','Document','0.01','0.00','0.00','0','Document','Surface','1','0.20','','','','','0.20','85.00','1','1','2025-11-04 12:33:46','2025-11-04 12:33:46','17617213813089','17617213813089','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('976','24','1','','2','3399485','2025-11-04','','5272','849','MUBARAK BAIG','917892985242','','','JFK BOYS HOSTEL','KANKANADY MANGALORE','','11','575002','MR.SHRIDHAR RAO GUTHULA','917675007861','','ZONAL BUSINESS MANAGER','BACHUPALLY HYDERBAD','','1','500090','Document','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','70.00','1','1','2025-11-04 12:33:53','2025-11-04 12:33:53','17617227102844','17617227102844','','117','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('977','20','1','','2','3418067','2025-11-04','','5273','850','JOHN DSOUZA','919880744685','','','#103 DEVDAN LOWER BENDUR','MANGALORE','','11','575002','SR BEENA ALMEDIA RMI','919967192811','','REGINA PACIS','OPP BYCULLA POLICE STATION MOTISHAH ROAD','','14','400027','Parcel','1000.00','0.00','0.00','0','Document','Surface','1','4.49','','','','','4.49','1410.00','1','1','2025-11-04 12:35:27','2025-11-04 12:35:27','17616388667516','17616388667516','','57','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('978','25','1','','2','3388867','2025-11-04','','5274','851','H MADHUSUDAN RAO','919480010169','','','HOSABETTU','SURATHKAL MANGLORE','','11','575014','H SURENDRA','919447028697','','SHRUTHI','SASTHAMANGALAM TRIVENDRUM','','12','695010','Parcel','400.00','0.00','0.00','0','Document','Surface','1','0.77','','','','','0.77','160.00','1','1','2025-11-04 12:35:35','2025-11-04 12:35:35','17617202587270','17617202587270','','1960','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('979','23','1','','2','3408547','2025-11-04','','5275','852','ABDUL KHADER IDDYA','919448115787','','','PANDESHWARA','MANGALORE','','23','','PULIANI & PULIANI','919900447747','','SUJATHA COMPLEX','GANDHINAGAR','','11','560009','Document','100.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-04 12:35:57','2025-11-04 12:35:57','17617218175043','17617218175043','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('980','20','1','','2','3418068','2025-11-04','','5276','57','VISION TECH','919343573072','','','INDIRA BUILDING','MORGANS GATE MANGALORE','','11','575001','THE PRINIPAL','918494900305','','SAINIK SCHOOL','KUDIGE','','11','571232','Document','10.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-04 12:38:04','2025-11-04 12:38:04','17616388667516','17616388667516','','54','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('981','10','1','','2','3406776','2025-11-04','','5277','853','A RUN KUMAR','918248058830','','','MANGALORE','','','11','575004','LAWRENCE NITHIN','919964951755','','UDAYAGIRI','MYSORE','','11','570019','Document','100.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-04 12:39:46','2025-11-04 12:39:46','17617151801089','17617151801089','#47 , 7TH CROSS','669','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('982','22','1','','2','3411081','2025-11-04','','4765','225','AIRCARE TECHNOLGIES INDIA PVT LTD','919900217000','','','ADARSH ARCADE','MALLIKATTE MANGALORE','','11','575003','PRASHANTH RAJ','919449252865','','SHOP NO 1 SUVARNA ARCADE','B M ROAD','','11','573201','Document','0.10','0.00','0.00','0','Document','Surface','1','0.60','','','','','0.60','125.00','1','1','2025-11-04 12:42:01','2025-11-04 12:42:01','17617169725275','17617169725275','','448','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('983','20','1','','2','3418069','2025-11-04','','5278','854','DEEKSHAN','917337635408','','','JUST DIAL','MANGALORE','','11','575001','THARESH JUST DIAL LTD','918050992345','','#29 SRT STREET','CUNNIGHAM ROAD','','11','560052','Document','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-04 12:44:01','2025-11-04 12:44:01','17616388667516','17616388667516','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('984','24','1','','2','3399486','2025-11-04','','5279','855','AMAR JYOTHI AUTOMOBILES','919448203633','','','PADIL','MANGALORE','','11','575007','MR.PRASHANTH C','919448203633','','BEAN BRIDGE COFFEE TRADERS','MUDIGERE','','11','577132','Parcel','800.00','0.00','0.00','0','Parcel','Surface','1','0.90','','','','','0.90','155.00','1','1','2025-11-04 12:44:12','2025-11-04 12:44:12','17617227102844','17617227102844','','2607','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('985','26','1','','2','3400884','2025-11-04','','5280','856','kinza abhayath','918951656464','','','tkt','mlr','','11','','zareena ibrahim','917338087760','','hotel foodland','k m rd','','11','577132','Document','0.00','0.00','0.00','0','Document','Surface','1','0.83','','','','','0.83','155.00','1','1','2025-11-04 12:44:51','2025-11-04 12:44:51','17615707686074','17615707686074','','2607','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('986','8','1','','2','3351499','2025-11-04','','5281','857','VALENTINE KENNY D CUNHA','919845110060','','','ATTADA','PERMUDE','','11','574509','NEELESH SINHA','919860843158','','LEAGAL HEAD ADANI DIGITAL LAB','SEC 32 GURUGRAM','','8','122001','Document','0.00','0.00','0.00','0','Document','Surface','1','0.10','','','','','0.10','120.00','1','1','2025-11-04 12:47:09','2025-11-04 12:47:09','17617178859109','17617178859109','','5','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('987','24','1','','2','3399487','2025-11-04','','5282','858','SRI MANJUNATH TRANSPORT','917021673044','','','KOTTARA','MANGALORE','','11','575002','MR.SAI KANNAN','918464921931','','KIRLOSKAR FERRSUS IND LTD','HINTAL KOPPAL','','11','583234','Document','10.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-04 12:49:30','2025-11-04 12:49:30','17617227102844','17617227102844','','394','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('988','26','1','','2','3400885','2025-11-04','','5283','859','ashith kumar um','917975989557','','','tkt','mlr','','11','','regent insginia obey tulip','917975989557','','koramangala','5th block','','11','560034','Document','0.00','0.00','0.00','0','Document','Surface','1','0.15','','','','','0.15','85.00','1','1','2025-11-04 12:51:08','2025-11-04 12:51:08','17615707686074','17615707686074','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('989','22','1','','2','3411082','2025-11-04','','5284','860','SHAMPA SHARES','919449132806','','','MALLIKATTE CENTER','MALLIKATTE MANGALORE','','11','575002','SHAREKHAN LTD','912261169450','','GIGAPLEX BLDG NO 09 10TH FLOOR','AIROLI KNOWLEDGE PARK','','14','400708','Document','0.10','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','100.00','1','1','2025-11-04 12:53:17','2025-11-04 12:53:17','17617169725275','17617169725275','','57','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('990','26','1','','2','3400886','2025-11-04','','5285','861','kuthar mlr','918310166728','','','ajjanadka','','','11','','4 corner manpower agency','918453777700','','city center','','','11','576213','Document','10.00','0.00','0.00','0','Document','Surface','1','0.05','','','','','0.05','50.00','1','1','2025-11-04 12:54:20','2025-11-04 12:54:20','17615707686074','17615707686074','','1470','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('991','7','1','','2','3395044','2025-11-04','','5286','862','ZAHID ROADLINES','919845515328','','','BAIKAMPADY','MANGALORE','','11','575011','SRINIVAS','919844305982','','HITECH BLOW MOULDERS P LTD','NAYANDAHALLI','','11','560039','Document','0.00','0.00','0.00','0','Document','Surface','1','0.01','','','','','0.01','60.00','1','1','2025-11-04 12:54:26','2025-11-04 12:54:26','17617199828916','17617199828916','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('992','20','1','','2','3418070','2025-11-04','','5287','863','S P BHUTHE','919448254943','','','PVS KALAKUNJA ROAD','KODIALBAIL MANGALORE','','11','575003','PAWAN S BHUTHE','917760512890','','C BLOCK 122 SJR PLAZZA','CITY DODDAKANNELLI','','11','560035','Document','10.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-04 12:56:09','2025-11-04 12:56:09','17616388667516','17616388667516','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('993','23','1','','2','3408548','2025-11-04','','5288','295','MARUTHI TRDERS','919845939412','','','BUNDER','MANGALORE','','23','','THE ACCOUNTS SECTION','919845939315','','BAIKAMPADY','00','','11','575011','Document','100.00','0.00','0.00','0','Document','Surface','1','0.10','','','','','0.10','120.00','1','1','2025-11-04 12:58:00','2025-11-04 12:58:00','17617218175043','17617218175043','APMC','3210','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('994','10','1','','2','3406777','2025-11-04','','5289','864','ANIL KUMAR HR','919036927266','','','SURAKSHA HOUSE','LAXMI NAGAR BEJAI','','11','575004','SAKTHIVEL B','919894049416','','NEAR NAAL ROAD','KUMBAKONAM','','23','612001','Document','100.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','70.00','1','1','2025-11-04 12:59:46','2025-11-04 12:59:46','17617151801089','17617151801089','PONNUSAMY NAGAR','124','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('995','21','1','','2','3393110','2025-11-04','','5290','865','UMA DEVI','919449817050','','','W/O. LATE A N RAJU','URWA STORE, KOTTARA','','11','575006','THE ADMINISTRATIVE OFFICER','919972061245','','INDIAN INSTITUTE OF ASTROPHYSICS','II BLOCK, KORAMANGALA','','11','560034','Document','100.00','0.00','0.00','0','Document','Surface','1','0.05','','','','','0.05','60.00','1','1','2025-11-04 13:01:12','2025-11-04 13:01:12','17616388051318','17616388051318','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('996','6','1','','2','3381543','2025-11-04','','5291','866','ASHA PRASAD','918317478350','','','MANGALORE','MANGALORE','','43','','ENDO MED TECH P LTD','911122048222','','DDA BUILDNG PLOT #4','LAXMI NAGAR  DELHI','','32','110092','Document','0.01','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','100.00','1','1','2025-11-04 13:02:00','2025-11-04 13:02:00','17617213813089','17617213813089','','1995','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('997','23','1','','2','3408549','2025-11-04','','5292','867','ARCHANA KURREY','919407739399','','','PANDESHWARA','MANGALORE','','23','','DHAVAL PARMAR','918460409596','','PAL;LURUTHY','BOT JUNCTION','','12','682005','Document','100.00','0.00','0.00','0','Document','Surface','1','0.20','','','','','0.20','95.00','1','1','2025-11-04 13:02:21','2025-11-04 13:02:21','17617218175043','17617218175043','BSNL CUSTOMER SERVICE CENTRE','2432','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('998','10','1','','2','3406778','2025-11-04','','5293','868','RAKESH K','919611023407','','','MANOHAR CHOWDHRY & ASSO','NEAR KSRTC BEJAI','','11','575004','VARSHA','919535904906','','BALAJI HOUSE','NEAR KUMODARI MATA','','11','574219','Document','0.00','0.00','0.00','0','Document','Surface','1','1.10','','','','','1.10','140.00','1','1','2025-11-04 13:04:47','2025-11-04 13:04:47','17617151801089','17617151801089','AJJIBETTU SCHOOL','1006','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('999','6','1','','2','3381544','2025-11-04','','5294','869','HARISH','919880773822','','','AMRITHA DHAMA','BEJAI','','43','','POORNIMA','918660812833','','NATIONAL INSURANCE CO LTD','VIDYAPOORVA COMPLEX','','11','576101','Document','0.01','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','50.00','1','1','2025-11-04 13:08:04','2025-11-04 13:08:04','17617213813089','17617213813089','','1639','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1000','10','1','','2','3406779','2025-11-04','','5295','870','CLASSIC TOURS & TRAVELS','919632829551','','','BHAVANI GANESH COMPLEX','BEJAI MANGALORE','','11','575004','TMA PAI HOSPITAL','919964677559','','BRAHMAGIRI','UDUPI','','11','576101','Document','100.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','50.00','1','1','2025-11-04 13:08:08','2025-11-04 13:08:08','17617151801089','17617151801089','OLD TALUK OFFICE','863','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1001','20','1','','2','3418071','2025-11-04','','5296','871','KAMATH CATERES','919845258653','','','NEAR GOKARN MUTT','CAR STREET MANGALORE','','11','575001','DR PRAMOD CHINDER/SHWETHA T G','919945106676','','#1014 GROUND FLOOR JAYANAGAR ENCLVAE','38 CROSS JAYANAGAR 4TH T BLOCK','','11','560041','Parcel','900.00','0.00','0.00','0','Document','Surface','1','2.50','','','','','2.50','431.00','1','1','2025-11-04 13:09:26','2025-11-04 13:09:26','17616388667516','17616388667516','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1002','22','1','','2','3411083','2025-11-04','','5297','872','SHAHIL AKTAR','918011880292','','','KULSHEKHAR','MANGALORE','','11','575005','Rajesh','919591077413','','vasantha first floor','bcmc layout vajarahalli metro stn','','11','560062','Document','0.10','0.00','0.00','0','Document','Surface','1','0.06','','','','','0.06','75.00','1','1','2025-11-04 13:11:22','2025-11-04 13:11:22','17617169725275','17617169725275','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1003','9','1','','2','3283696','2025-11-04','','5298','874','jAYARAJ KA','919746789326','','','A102, ASHOKA PARK APARTMENT','MATDAKANI, 1ST CROSS, GDN','','11','575006','JAYARAJ K.A','919746789326','','BH-422, 81 , HIGH STREET','SECTOR-81, GREATERFARIDABAD','','8','121014','Books','7500.00','0.00','0.00','0','Parcel','Surface','1','11.24','','','','','11.24','1980.00','1','1','2025-11-04 13:12:35','2025-11-04 13:12:35','17617248601364','17617248601364','','625','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1004','10','1','','2','3406780','2025-11-04','','5299','875','RAHUL NAYAK','918310733623','','','KONARK','BHARATHI NAGAR','','11','574004','PANDURANG NAYAK','919901854270','','SARJAPUR MAIN ROAD','BANGALORE','','11','560035','Document','100.00','0.00','0.00','0','Document','Surface','1','0.21','','','','','0.21','90.00','1','1','2025-11-04 13:13:03','2025-11-04 13:13:03','17617151801089','17617151801089','SUNCITY GLORIA APTS','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1005','6','1','','2','3381545','2025-11-04','','5300','876','DR CHAITHNYA SHANBHAG','919845303779','','','DENTAL CARE CENTER','CHILIMBI','','11','','DR RAHUL WAGLE','919326140938','','RADHA ENCLAVE','LSIDRO BAPTISTA RD','','6','403601','Document','0.01','0.00','0.00','0','Document','Surface','1','0.16','','','','','0.16','95.00','1','1','2025-11-04 13:15:27','2025-11-04 13:15:27','17617213813089','17617213813089','','628','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1006','26','1','','2','3400887','2025-11-04','','5301','877','jsi sports intl','918618371434','','','kallapu','tkt','','11','','dheeraj sai krishna','918008942927','','new nallakunta','hyd','','1','500004','Document','4200.00','0.00','0.00','0','Document','Surface','1','4.00','','','','','4.00','736.00','1','1','2025-11-04 13:17:14','2025-11-04 13:17:14','17615707686074','17615707686074','','117','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1007','23','1','','2','3408550','2025-11-04','','4777','878','SUNDRESH','919731805276','','','RTO PANDESHWAR','MANGALORE','','11','575001','MAHESH B','919845145729','','MAIN ROAD','J P NAGAR','','11','560078','Document','100.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-04 13:17:46','2025-11-04 13:17:46','17617218175043','17617218175043','PUTHENAHALLI','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1008','10','1','','2','3406781','2025-11-04','','5302','879','JILU AUTO GAS','919632546543','','','KUNTIKAN','MANGALORE','','11','','K A IQBAL','919448870561','','MARUTI SERVICE POINT','OPP YATRI NIVAS K M ROAD','','11','577124','Document','100.00','0.00','0.00','0','Document','Surface','1','0.30','','','','','0.30','110.00','1','1','2025-11-04 13:19:19','2025-11-04 13:19:19','17617151801089','17617151801089','SAFA MARVA','3297','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1009','22','1','','2','3411084','2025-11-04','','5303','880','SALIL RAO','919945516035','','','507 GUARDIAN GIOVANNI','KULSHEKHAR KALPANE','','11','575005','OPTIMUS MEDICAL SERVICES PVT LTD','919037720813','','FIRST FLOOR KADAVANTHRA RD','EMMANUEL LANE ERNAKULAM','','12','682017','Document','0.10','0.00','0.00','0','Document','Surface','1','2.88','','','','','2.88','544.00','1','1','2025-11-04 13:20:12','2025-11-04 13:20:12','17617169725275','17617169725275','','1761','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1010','13','1','','2','3404102','2025-11-04','','4611','881','MUNISHMUNESH','919980463700','','','GHS ROAD','MANGALORE','','43','575001','SADANAND','919900894097','','NR KPTCL SARVODAYA','','','11','582101','Document','10.00','0.00','0.00','0','Document','Surface','1','0.26','','','','','0.26','110.00','1','1','2025-11-04 13:20:49','2025-11-04 13:20:49','17617147018423','17617147018423','','546','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1011','23','1','','2','3408551','2025-11-04','','4777','882','SUNDRESH','919731805276','','','RTO PANDESHWAR','MANGALORE','','11','575001','MR IBRAHIM','919448211030','','J M ROAD','00','','11','570001','Document','100.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-04 13:21:01','2025-11-04 13:21:01','17617218175043','17617218175043','INSURANCE AGENTS','2607','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1012','23','1','','2','3408552','2025-11-04','','4777','247','SUNDRESH','919731805276','','','RTO PANDESHWAR','MANGALORE','','11','575001','MR SHEKAR BIRWA','919448428822','','BIRWA AUTO CONCULTANTS','NEAR RTO BANNUR','','11','575001','Document','100.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','50.00','1','1','2025-11-04 13:22:26','2025-11-04 13:22:26','17617218175043','17617218175043','','1904','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1013','21','1','','2','3393111','2025-11-04','','5304','883','SUSHMA','916364748859','','','BCWD OFFICE, SHREE DEVIKRUPA','VIVEKANANDA NAGARA, KODICAL','','11','575006','SURAKSHA SECURITY SERVICES','918172251090','','PRASHANTH BUILDING 2ND FLOOR','R C ROAD','','11','573201','Document','100.00','0.00','0.00','0','Document','Surface','1','0.05','','','','','0.05','60.00','1','1','2025-11-04 13:22:33','2025-11-04 13:22:33','17616388051318','17616388051318','','448','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1014','18','1','','2','3385043','2025-11-04','','5305','884','RAJARATHNAM','919448000226','','','KOTTAR  CHOWKI','MALEMAR ROAD MANGALORE','','11','','K N SURESH','919448022424','','LIG 482 K H B COLONY','KALLAHALLI VINOBANAGARA','','11','577204','Document','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-04 13:22:59','2025-11-04 13:22:59','17621531273939','17621531273939','','1829','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1015','10','1','','2','3406782','2025-11-04','','5306','885','MARY LOBO','919242184978','','','URWASTORE','ASHOK NAGAR','','11','','K FIN TECHNOLOGIE SLTD','919242184978','','UNIT BANK OF BARODA','SELENIUM TOWER B PLOT 31-32','','1','500032','Document','100.00','0.00','0.00','0','Document','Surface','1','0.16','','','','','0.16','100.00','1','1','2025-11-04 13:23:59','2025-11-04 13:23:59','17617151801089','17617151801089','','117','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1016','9','1','','2','3283697','2025-11-04','','5307','886','RAJESH KOTIAN','919886896712','','','PREETHI TOWER','2ND FLOOR, URWA MARKET, MLR','','11','575006','SAYEGH PAINT FACTORIES INDIA PVT LTD','919952841982','','BLDG NO.172, 05TH A CROSS','KIADB IND AREA, BOMMASANDRA 01ST PHASE','','11','560099','Document','95000.00','0.00','0.00','0','Document','Surface','1','0.08','','','','','0.08','75.00','1','1','2025-11-04 13:25:14','2025-11-04 13:25:14','17617248601364','17617248601364','','1036','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1017','7','1','','2','3395045','2025-11-04','','5308','887','DEEPAK SALES AND SER','918217314627','','','PANAMBUR','MANGALORE','','11','575011','DEPUTY ELE INSPECTOR','919964495054','','KOTTARACHOWKI','MANGALORE','','11','575006','Document','0.00','0.00','0.00','0','Document','Surface','1','0.01','','','','','0.01','35.00','1','1','2025-11-04 13:25:56','2025-11-04 13:25:56','17617199828916','17617199828916','','3453','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1018','22','1','','2','3411085','2025-11-04','','5309','888','NIKSHITH SUVARNA','918884416669','','','KUWS AND D B','MALLIKATTE MANGALORE','','11','575003','KARTHIK','918050905667','','IPE GLOBAL LTD','H2 KUWS AND D B YADAVAGIRI','','11','570020','Document','0.10','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-04 13:26:03','2025-11-04 13:26:03','17617169725275','17617169725275','','669','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1019','8','1','','2','3351500','2025-11-04','','5310','889','LISHMITHA','916363677334','','','AMBIKA NAGAR','BAJPE','','11','574142','DAMODAR SUVARNA EDUC TRUST','919449937119','','KANKANADY','MANGALORE','','11','575002','Document','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','35.00','1','1','2025-11-04 13:28:01','2025-11-04 13:28:01','17617178859109','17617178859109','','3453','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1020','22','1','','2','3411086','2025-11-04','','5311','890','ADITYA SHETTY','919769490875','','','406 WALK IN ARCADIA','GEORGE MARTIS RD MANGALORE','','11','575002','SAGAR R DOMBALE','919029773955','','GREATSHIP LTD','ONE INTERNATIONAL CENTRE PRABHADEVI WEST','','14','400013','Document','0.10','0.00','0.00','0','Document','Surface','1','0.43','','','','','0.43','170.00','1','1','2025-11-04 13:29:36','2025-11-04 13:29:36','17617169725275','17617169725275','','57','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1021','7','1','','2','3395046','2025-11-04','','4662','891','ANJANEYA TPT','919901907759','','','KA 01 D 0286  KA 40 1599','BAIKAMPADY','','11','575011','SREE VARI TRANSPORT','919443957522','','BOMMASAMUTHIRAN','PAIYUR','','23','635112','Document','0.00','0.00','0.00','0','Document','Surface','1','0.01','','','','','0.01','70.00','1','1','2025-11-04 13:30:31','2025-11-04 13:30:31','17617199828916','17617199828916','','461','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1022','7','1','','2','3395047','2025-11-04','','4662','116','ANJANEYA TPT','919901907759','','','TN 29 BY 0303','BAIKAMPADY','','11','575011','THIRUMALAI VASA LORRY BOOK OFFICE','919443455669','','RAYAKOTTA RING ROAD','HOSUR','','23','635109','Document','0.00','0.00','0.00','0','Document','Surface','1','0.01','','','','','0.01','70.00','1','1','2025-11-04 13:31:23','2025-11-04 13:31:23','17617199828916','17617199828916','','452','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1023','6','1','','2','3381546','2025-11-04','','5312','892','YOGEESH','918971513942','','','MANGALORE','MANGALORE','','43','','PRASAD','919945502526','','WIPRO ENTERPRISES P LTD','OFF BANNERGHTTA RD','','11','560076','Document','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-04 13:34:28','2025-11-04 13:34:28','17617213813089','17617213813089','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1024','20','1','','2','3418072','2025-11-04','','5313','893','shrikanth jadar','919743040575','','','vip inds ltd','MANGALORE','','11','575001','MR SANJAY VIP INDS LTD','919632392324','','11TH K M AREKERE','BANNERGATTA ROAD','','11','560076','Document','10.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-04 13:34:51','2025-11-04 13:34:51','17616388667516','17616388667516','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1025','22','1','','2','3411087','2025-11-04','','5314','894','MAHESH C K','918971958322','','','VRINDAVAN APTS','ARYASAMAJ RD KADRI','','11','575002','GREEN REMEDIES','916364037346','','BESIDES MONDAVI PRESIDENCY','KINNIMULKY','','11','575003','Document','0.10','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','50.00','1','1','2025-11-04 13:36:56','2025-11-04 13:36:56','17617169725275','17617169725275','','863','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1026','10','1','','2','3406783','2025-11-04','','5315','895','SIRAZ','919845591048','','','BEJAI','MANGALORE','','11','575004','ASHWIN','919025599287','','BRIGADE WORLD TRADE CENTER','RAJIV GANDHI SALAI','','23','600096','Document','100.00','0.00','0.00','0','Document','Surface','1','0.22','','','','','0.22','100.00','1','1','2025-11-04 13:41:25','2025-11-04 13:41:25','17617151801089','17617151801089','','1931','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1027','10','1','','2','3406784','2025-11-04','','5315','896','SIRAZ','919845591048','','','BEJAI','MANGALORE','','11','575004','C B HATTI','918792051515','','SCB BIOTECH PVT LTD','NEELGIN ROAD, DESHPANDE NAGAR','','11','580029','Parcel','200.00','0.00','0.00','0','Document','Surface','1','0.42','','','','','0.42','110.00','1','1','2025-11-04 13:43:57','2025-11-04 13:43:57','17617151801089','17617151801089','','557','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1028','23','1','','2','3408553','2025-11-04','','5316','897','SHRI SAI DURGA ELE','919380098047','','','BUNDER','MANGALORE','','23','','LIBIN CHACKO','918590110077','','CHERUPUZHA','00','','12','670511','Document','100.00','0.00','0.00','0','Document','Surface','1','0.25','','','','','0.25','95.00','1','1','2025-11-04 13:45:01','2025-11-04 13:45:01','17617218175043','17617218175043','KALAYAIL HOUSE','642','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1029','20','1','','2','3418073','2025-11-04','','5317','898','RAVI  KUMAR','918217002817','','','PVS BRANCH','MANGALORE','','11','575001','RIYA','919840032517','','BALARAMAN  STREET','ADYAR','','23','600020','Document','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','70.00','1','1','2025-11-04 13:49:33','2025-11-04 13:49:33','17616388667516','17616388667516','','1931','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1030','23','1','','2','3408554','2025-11-04','','5318','899','D CLEAN FACILITYB MANAGEMENT','916361676569','','','PANDESHWAR','MANGALORE','','23','','MR POWER POWAR','918657004710','','BELAPUR ROAD','GAWATE WADI AIROLI','','14','400708','Document','100.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','100.00','1','1','2025-11-04 13:50:09','2025-11-04 13:50:09','17617218175043','17617218175043','RELIABLE TECH PARK','57','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1031','16','1','','2','3357234','2025-11-04','','5319','900','SUMA SHETTY','919986567585','','','KAIKAMBA','MANGALORE','','11','574151','RAKSHA','917892782649','','INFOSYS GATE 2','HEBBAL INDL AREA MYOSRE','','11','570018','Document','100.00','0.00','0.00','0','Document','Surface','1','0.25','','','','','0.25','85.00','1','1','2025-11-04 13:55:46','2025-11-04 13:55:46','17617177578387','17617177578387','','669','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1032','26','1','','2','3400888','2025-11-04','','5320','901','AYSHA','917349567765','','','ULLAL','MLR','','11','','ASHONA','917259350351','','A K MENTION','GURPUR','','11','574140','OIL','100.00','0.00','0.00','0','Document','Surface','1','0.16','','','','','0.16','75.00','1','1','2025-11-04 13:56:15','2025-11-04 13:56:15','17615707686074','17615707686074','','3194','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1033','24','1','','2','3399488','2025-11-04','','5321','902','G HARINARAYANAN','919903935281','','','JALLIGUDDE BAJAL','MANGALORE','','11','575009','MR.AMA=BARISH PISHARODY','919088015456','','JAKKANSANDRA KORAMANGALA','BANGALORE','','11','560034','Parcel','900.00','0.00','0.00','0','Parcel','Surface','1','1.99','','','','','1.99','339.00','1','1','2025-11-04 13:56:27','2025-11-05 10:32:47','17617227102844','17617227102844','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1034','7','1','','2','3395048','2025-11-04','','5322','903','E TECH','919945796674','','','BAIKAMPADY','MANGALORE','','11','575011','SAMSON DSOUZA','919611263447','','HINDUSTAN UNILEVER LTD','WHITEFIELD','','11','560066','Document','0.00','0.00','0.00','0','Document','Surface','1','0.01','','','','','0.01','60.00','1','1','2025-11-04 13:58:45','2025-11-04 13:58:45','17617199828916','17617199828916','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1035','23','1','','2','3408555','2025-11-04','','5323','904','MAIMUNA','917259349827','','','PANDESHWARA','MANGALORE','','23','','MOHAMMED RAVED SHEKH','917259795351','','BHARATH NAGAR CHOWDRY SHOP','BANDRA EAST BKC','','14','400051','Document','100.00','0.00','0.00','0','Document','Surface','1','1.75','','','','','1.75','530.00','1','1','2025-11-04 14:00:26','2025-11-04 14:00:26','17617218175043','17617218175043','CHAWL NO 47','57','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1036','20','1','','2','3418074','2025-11-04','','5324','905','K M  TIME SQUARE','917406767848','','','HAMPANKATTA','MANGALORE','','11','575001','JAYANI P  NAIK','917349343093','','EXPET  PU COLLEGE','VALACHIL','','11','574143','Cloths','100.00','0.00','0.00','0','Document','Surface','1','0.12','','','','','0.12','75.00','1','1','2025-11-04 14:00:58','2025-11-04 14:06:36','17616388667516','17616388667516','','1151','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1037','6','1','','2','3381547','2025-11-04','','5325','906','MANJUNATH B SHET','919945989961','','','MANGALORE','MANGALORE','','11','','PRAKASH SHET','917892189971','','5TH MAIN YERRAYYANAPALYA','R M NAGAR EXTENSION','','11','560016','Document','500.00','0.00','0.00','0','Document','Surface','1','0.25','','','','','0.25','85.00','1','1','2025-11-04 14:02:33','2025-11-04 14:02:33','17617213813089','17617213813089','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1038','18','1','','2','3385044','2025-11-04','','5326','907','JEETHESH','918050101050','','','KULUR KAVOOR','MANGALORE','','11','575013','PANDIYAN','919751101676','','VARADAPPANUR','KALLAKURICHI TAMILNADU','','23','606204','Document','0.00','0.00','0.00','0','Document','Surface','1','1.99','','','','','1.99','352.00','1','1','2025-11-04 14:05:03','2025-11-04 14:05:03','17621531273939','17621531273939','','280','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1039','6','1','','2','3381548','2025-11-04','','5327','908','LOHITH U','918722443401','','','MADHAVA COMPOUND','KUDROLI','','11','','A VISHNUMURTHY RAO','919902760322','','SMITHA HOUSE LAXMINDRA NAGAR','KUNJIBETTU POST','','11','576102','Document','0.01','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','50.00','1','1','2025-11-04 14:07:23','2025-11-04 14:07:23','17617213813089','17617213813089','','1639','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1040','6','1','','2','3381549','2025-11-04','','5327','909','LOHITH U','918722443401','','','MADHAVA COMPOUND','KUDROLI','','11','','MAMTAZ HAIDAR SAB','919108354033','','MOHALLA CHANDAVAR','JELENI','','11','581323','Document','0.01','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-04 14:09:27','2025-11-04 14:09:27','17617213813089','17617213813089','','191','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1041','18','1','','2','3385045','2025-11-04','','5328','910','FORTUNE MARINE SERVICES','919611254498','','','PANJIMOGARU KULUR','MANGALORE','','23','','MOTROTECH MULTISERVICE LLP','919619094093','','DANA BUNDAR MASJID EAST','MUMBAI','','14','400009','Document','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','100.00','1','1','2025-11-04 14:13:26','2025-11-04 14:13:26','17621531273939','17621531273939','','57','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1042','10','1','','2','3406785','2025-11-04','','5329','911','POOJITHA H K','919019871582','','','BHARGAVI GLORIA RESIDENCY','BEJAI MANGALORE','','11','575004','MANOJ','919902184722','','KIMS HOSPITAL','K R ROAD V V PURAM','','11','560004','Parcel','100.00','0.00','0.00','0','Document','Surface','1','0.22','','','','','0.22','85.00','1','1','2025-11-04 14:14:46','2025-11-04 14:14:46','17617151801089','17617151801089','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1043','26','1','','2','3400889','2025-11-04','','5330','912','SHREYAS J','919980687580','','','MOTO FUSION','BEERI MLR','','11','','PALLAVI','919611447461','','IDFC FIRST BK','SARASWATHIPURAM','','11','570009','Document','0.00','0.00','0.00','0','Document','Surface','1','0.42','','','','','0.42','105.00','1','1','2025-11-04 14:15:24','2025-11-04 14:15:24','17615707686074','17615707686074','','669','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1044','6','1','','2','3381550','2025-11-04','','5327','913','LOHITH U','918722443401','','','MADHAVA COMPOUND','KUDROLI','','11','','SUMATHI','919008636449','','GOONJADI','KUNDAPURA','','43','576283','Document','0.01','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','50.00','1','1','2025-11-04 14:15:42','2025-11-04 14:15:42','17617213813089','17617213813089','','3363','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1045','6','1','','2','3381551','2025-11-04','','5327','914','LOHITH U','918722443401','','','MADHAVA COMPOUND','KUDROLI','','11','','LOWERNCE MENDONSA','919611841996','','COMPUND HOUSE','MARKET RD','','11','574115','Document','0.01','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','50.00','1','1','2025-11-04 14:18:00','2025-11-04 14:18:00','17617213813089','17617213813089','','1639','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1046','14','1','','2','3364677','2025-11-04','','4761','915','HEGDE AYURVEDA','919110656146','','','1 ST FLOOR SMART TOWER','NEW BALMATA','','11','575001','EKTA','919342439631','','#415,12 MAIN 4TH B CROSS CANARA BANK LAYOUT','VIDHYARANYAPURAM POST BANGALORE','','11','560097','Document','0.03','0.00','0.00','0','Document','Surface','1','0.26','','','','','0.26','105.00','1','1','2025-11-04 14:18:07','2025-11-04 14:18:07','17617209872567','17617209872567','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1047','22','1','','2','3411088','2025-11-04','','5331','916','MANSOOR','919731942156','','','MANGALORE','MANGALORE','','11','575002','YASHASWI','919611281623','','DAKSHAYANI NILAYA','IDDYA SURATHKAL','','11','575014','Document','0.10','0.00','0.00','0','Document','Surface','1','0.10','','','','','0.10','65.00','1','1','2025-11-04 14:19:22','2025-11-04 14:19:22','17617169725275','17617169725275','','3211','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1048','6','1','','2','3381552','2025-11-04','','5327','917','LOHITH U','918722443401','','','MADHAVA COMPOUND','KUDROLI','','11','','RAMANI KRISHNA','919148373492','','UPPANI','UTTARKANNNADA','','11','581334','Document','0.01','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-04 14:20:41','2025-11-04 14:20:41','17617213813089','17617213813089','','191','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1049','10','1','','2','3406786','2025-11-04','','5332','918','RANJITH','919632774460','','','BEJAI MANGALORE','','','11','575004','SUBHASH AUTOMOBILES','919738637387','','PRANSHI ARCADE','JOURNALIST CLONY','','11','560002','Parcel','100.00','0.00','0.00','0','Document','Surface','1','0.90','','','','','0.90','155.00','1','1','2025-11-04 14:23:45','2025-11-04 14:23:45','17617151801089','17617151801089','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1050','10','1','','2','3406787','2025-11-04','','5333','919','GENTECH DIESEL ENGINEERS','917022011451','','','YEYYADI','MANGALORE','','11','575004','SATYANARAYAN','919784421105','','TAFE MOTORS AND TRACTORS LTD','ITARNA ROAD','','21','301001','Parcel','11000.00','0.00','0.00','0','Document','Surface','1','0.90','','','','','0.90','290.00','1','1','2025-11-04 14:27:49','2025-11-04 14:27:49','17617151801089','17617151801089','','1981','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1051','14','1','','2','3364678','2025-11-04','','4761','920','HEGDE AYURVEDA','919110656146','','','1 ST FLOOR SMART TOWER','NEW BALMATA','','11','575001','VYSHNA V','919686893972','','53,4TH MAIN NEAR GOPI SCHOOL RD','KAMALSHIPALYA EXTENSION','','11','560079','Document','0.01','0.00','0.00','0','Document','Surface','1','0.55','','','','','0.55','125.00','1','1','2025-11-04 14:29:35','2025-11-04 14:29:35','17617209872567','17617209872567','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1052','20','1','','2','3418075','2025-11-04','','5334','921','GANAPAYYA AYURVEDI','919343351600','','','MANGALORE','','','11','575001','SUDARSHAN M STORES','919029171723','','DARSHAN CMS LTD','ZAVER ROAD MULUND WEST','','14','400080','Document','100.00','0.00','0.00','0','Document','Surface','1','0.10','','','','','0.10','120.00','1','1','2025-11-04 14:29:50','2025-11-04 14:29:50','17616388667516','17616388667516','','57','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1053','10','1','','2','3406788','2025-11-04','','5333','922','GENTECH DIESEL ENGINEERS','917022011451','','','YEYYADI','MANGALORE','','11','575004','SHANKAR SHETTY','919741814829','','UDUPI DAIRY','KOLALAGIRI POST , JATHABETTU','','11','576105','Document','100.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','50.00','1','1','2025-11-04 14:30:18','2025-11-04 14:30:18','17617151801089','17617151801089','','863','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1054','21','1','','2','3393112','2025-11-04','','5335','923','PLANET HAVC ASST','919743286920','','','KULUR','MLR','','11','575003','GOKUL','919585322789','','APPOLLO PHARMA','HOSUR RD','','11','560068','Document','100.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-04 14:30:29','2025-11-04 14:30:29','17616388051318','17616388051318','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1055','10','1','','2','3406789','2025-11-04','','5333','924','GENTECH DIESEL ENGINEERS','917022011451','','','YEYYADI','MANGALORE','','11','575004','THE KRISHNA CONSTRUCTION','919481589859','','KENDRIYA VIDYALAYA','PRAGATHI NAGAR','','11','576104','Document','100.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','50.00','1','1','2025-11-04 14:32:24','2025-11-04 14:32:24','17617151801089','17617151801089','','378','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1056','26','1','','2','3400890','2025-11-04','','5336','925','DEEKSHITH KUMAR','918553213440','','','MLR','MLR','','11','575017','SEETHARAMACHANDRA','917996970199','','TILES N SANITARY','NR HONDA SHOW ROOM','','11','581343','Books','0.00','0.00','0.00','0','Document','Surface','1','3.70','','','','','3.70','661.00','1','1','2025-11-04 14:32:36','2025-11-04 14:32:36','17615707686074','17615707686074','','165','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1057','13','1','','2','3404103','2025-11-04','','5337','926','STELNA DESIGNS LLP','919110440617','','','CARSTREET','MANGALORE','','11','575001','RITESH JAIN','919845550165','','DESIGN SHOP','COURT ROAD','','11','576101','Document','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-04 14:34:22','2025-11-26 16:01:53','17617147018423','17617147018423','','1639','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1058','21','1','','2','3393113','2025-11-04','','4755','927','MARIYAM','916366737732','','','PARIJATHA COMMERCIAL APRT','GROUND FLOOR','','11','575006','MADHU B K','919535621251','','KULAKARNI LAYOUT','AUTONAGAR RD','','11','590017','Document','100.00','0.00','0.00','0','Document','Surface','1','0.40','','','','','0.40','105.00','1','1','2025-11-04 14:36:01','2025-11-04 14:36:01','17616388051318','17616388051318','','4','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1059','17','1','','3','21505451','2025-11-03','3910','3905','511','MEDIGLOBE','918147760815','','','3RD FLOOR,\'\'PARIN\'\' COLLECTORS GATE CIRCLE,BALMATTA MANGALURE-1','','29AIGPB0221L1ZL','11','575002','MYTHRI PHARMA','','','WILSON GARDEN','BANGALORE','','11','560001','Document','0.01','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','30.00','1','1','2025-11-04 14:38:11','2025-12-13 16:58:24','17617216042295','17617216042295','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','1','0','','','','','','1','');
INSERT INTO `booking` VALUES ('1060','12','1','','2','3382949','2025-11-04','','5338','928','KPB','918147235525','','','SHARADA YOGA & NAYUROPATHY','MEDICAL COLLEGE TALAPADY','','11','575001','ROOPA HR','918073477247','','NO KL851 11TH CROSS','VRUSHABHAVATHI ROAD APMC ROAD V V NAGAR MANDYA','','11','571401','Non Doc','650.00','0.00','0.00','0','Parcel','Surface','1','1.15','','','','','1.15','201.00','1','1','2025-11-04 14:38:38','2025-11-04 14:38:38','17617206505387','17617206505387','','403','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1061','8','1','','2','3351501','2025-11-04','','5339','929','NISHANTH NT','919443321768','','','MASTEK ENGINEERING PVT LTD','BAIKAMPADY','','11','574142','MASTEK ENGINERING PVT LTD','919597088825','','TAMBARAM EAST','SENTHIL MURUGAN STREET','','23','600059','Document','0.00','0.00','0.00','0','Document','Surface','1','0.14','','','','','0.14','95.00','1','1','2025-11-04 14:39:13','2025-11-04 14:39:13','17617178859109','17617178859109','','1931','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1062','20','1','','2','3418076','2025-11-04','','5340','930','VISHWA KIRAN','918147666185','','','BUNDER','MANGALORE','','11','575001','PANKAJ SAIN QUESS CORP LTD','918619181017','','5TH FLOOR RAGUKUL TOWERS','JAIPUR','','21','302021','Document','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','100.00','1','1','2025-11-04 14:39:38','2025-11-04 14:39:38','17616388667516','17616388667516','','455','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1063','26','1','','2','3400891','2025-11-04','','5341','931','KAUSJHIK','918722522552','','','KOLYA','MLR','','11','','SANKY TECH CONSULT P LTD','919844311378','','TATA NAGAAR','MN RD','','11','560092','Document','10.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-04 14:40:02','2025-11-04 14:40:02','17615707686074','17615707686074','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1064','7','1','','2','3395049','2025-11-04','','5342','26','M KUMAR','919385772103','','','TN 99 B 9101','','','11','575011','SASIKUMAR','919942225565','','VINAYAGAR STREET','NADARMEDU','','23','638002','Document','0.00','0.00','0.00','0','Document','Surface','1','0.01','','','','','0.01','70.00','1','1','2025-11-04 14:41:00','2025-11-04 14:41:00','17617199828916','17617199828916','','114','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1065','17','1','','3','21505452','2025-11-03','3910','3905','511','MEDIGLOBE','918147760815','','','3RD FLOOR,\'\'PARIN\'\' COLLECTORS GATE CIRCLE,BALMATTA MANGALURE-1','','29AIGPB0221L1ZL','11','','M S N LAB','','','BLR','BLR','','11','560001','Document','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','30.00','1','1','2025-11-04 14:46:49','2025-12-13 16:58:24','17617216042295','17617216042295','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','1','0','','','','','','1','');
INSERT INTO `booking` VALUES ('1066','17','1','','2','3404700','2025-11-04','','5343','932','RAKESH R','919901672337','','','ARYA SAMJA ROAD','MANGALORE','','11','575003','RAJALKSHMI','919113059706','','BIDADI','','','11','562109','Document','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-04 14:49:26','2025-11-04 14:49:26','17617216042295','17617216042295','B G S ROAD','1131','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1067','7','1','','2','3395050','2025-11-04','','5344','933','MUTHU','919629182281','','','MANGALORE','','','11','575011','LOKESHWARI TRANSPORT','917418441844','','VAYALANALLUR VILLAGE','CHENNAI','','23','600072','Document','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','70.00','1','1','2025-11-04 14:52:01','2025-11-04 14:52:01','17617199828916','17617199828916','','1931','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1068','17','1','','3','21505454','2025-11-03','3910','3905','511','MEDIGLOBE','918147760815','','','3RD FLOOR,\'\'PARIN\'\' COLLECTORS GATE CIRCLE,BALMATTA MANGALURE-1','','29AIGPB0221L1ZL','11','','TORATTO PHARMA','','','BLR','BLR','','11','575001','Document','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','30.00','1','1','2025-11-04 14:52:20','2025-12-13 16:58:24','17617216042295','17617216042295','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','1','0','','','','','','1','');
INSERT INTO `booking` VALUES ('1069','17','1','','3','21505455','2025-11-03','3910','3905','511','MEDIGLOBE','918147760815','','','3RD FLOOR,\'\'PARIN\'\' COLLECTORS GATE CIRCLE,BALMATTA MANGALURE-1','','29AIGPB0221L1ZL','11','','BASVRAJ MALGENA','','','RATHALLA','HVI','','11','575001','Document','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','36.00','1','1','2025-11-04 14:54:11','2025-12-13 16:58:24','17617216042295','17617216042295','','314','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','1','0','','','','','','1','');
INSERT INTO `booking` VALUES ('1070','20','1','','2','3418077','2025-11-04','','5345','934','PRINCIPAL ALOYSIUS PU CLG','919449759672','','','MANGALORE','','','11','575001','EXCTIVE DIRECTOR KARNATAKA EXAMINATION AUTHORITY','919343793012','','SAMPIGE ROAD','','','11','560012','Document','0.00','0.00','0.00','0','Document','Surface','1','0.16','','','','','0.16','85.00','1','1','2025-11-04 14:54:13','2025-11-04 14:54:13','17616388667516','17616388667516','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1071','25','1','','2','3388868','2025-11-04','','5346','935','PAVAN KUMAR BENNUR','917022092376','','','BEHIND TARA TOWER','SURATHKAL','','11','575014','HDFC BANK LTD','918884225892','','JTK EXTENSION ADICHUNCHANGIRI ROAD','KUVEMPUR NAGAR MYSORE','','11','570023','Document','100.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-04 14:55:30','2025-11-04 14:55:30','17617202587270','17617202587270','','669','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1072','21','1','','2','3393114','2025-11-04','','5423','1060','RAJESH KS','919164856129','','','THE SARASWAT CO-OPERATIVE BANK','CHILIMBI','','11','575006','BOMBAY INTEGRATED SECURITY INDIA LTD','919341008857','','HRBR LAYOUT 1ST BLOCK','KALYAN NAGAR','','11','560043','Document','100.00','0.00','0.00','0','Document','Surface','1','0.05','','','','','0.05','60.00','1','1','2025-11-04 14:55:53','2025-11-04 16:38:06','17616388051318','17616388051318','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1073','14','1','','2','3364679','2025-11-04','','5348','937','CAUVERY KARNATAKA STATE','919845496921','','','ARTS & CRAFTS EMPORIUM','CITY LIGHT BLDG BALMATA RD HAMPANKATTA','','11','575007','THE MANAGING DIRECTOR','919972493108','','KSHDCL COMPLEX NO 45 3RD FLOOR M G RD','BANGALORE','','11','560001','Document','10.00','0.00','0.00','0','Document','Surface','1','0.08','','','','','0.08','75.00','1','1','2025-11-04 14:55:56','2025-11-04 14:55:56','17617209872567','17617209872567','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1074','17','1','','3','21505456','2025-11-03','3910','3905','511','MEDIGLOBE','918147760815','','','3RD FLOOR,\'\'PARIN\'\' COLLECTORS GATE CIRCLE,BALMATTA MANGALURE-1','','29AIGPB0221L1ZL','11','','MANOHAR V','','','LINGDHALLI','GDG','','11','575001','Document','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','36.00','1','1','2025-11-04 14:56:38','2025-12-13 16:58:24','17617216042295','17617216042295','','546','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','1','0','','','','','','1','');
INSERT INTO `booking` VALUES ('1075','23','1','','2','3408556','2025-11-04','','5349','938','GANESH & SUDHIR','919483895148','','','PANDESHWARA','MANGALORE','','23','','HEGDE H/W','919845195935','','ANEKERE','00','','11','574104','Document','100.00','0.00','0.00','0','Document','Surface','1','1.30','','','','','1.30','175.00','1','1','2025-11-04 14:59:39','2025-11-04 14:59:39','17617218175043','17617218175043','MARUTHI BUILILD','75','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1076','16','1','','2','3357235','2025-11-04','','5350','939','SACHIN','919743137722','','','BELTHANGADI','','','11','.','HARSHITH','919352788533','','HOTEL SHREE NATRAJ PERMIT','PUSHPARAJ CHOWK SANGLI','','14','416416','Document','100.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','100.00','1','1','2025-11-04 14:59:47','2025-11-04 14:59:47','17617177578387','17617177578387','','1818','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1077','17','1','','3','21505457','2025-11-03','3910','3905','511','MEDIGLOBE','918147760815','','','3RD FLOOR,\'\'PARIN\'\' COLLECTORS GATE CIRCLE,BALMATTA MANGALURE-1','','29AIGPB0221L1ZL','11','','ANANDRAM BHAT','','','UDP','UDP','','11','575001','Document','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','28.00','1','1','2025-11-04 15:00:00','2025-12-13 16:58:24','17617216042295','17617216042295','','1639','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','1','0','','','','','','1','');
INSERT INTO `booking` VALUES ('1078','23','1','','2','3408557','2025-11-04','','5349','940','GANESH & SUDHIR','919483895148','','','PANDESHWARA','MANGALORE','','23','','KARUNNYA DHARA','918078317292','','BETHANY','PROVINCIAL HOUSE','','12','673017','Document','100.00','0.00','0.00','0','Document','Surface','1','1.50','','','','','1.50','256.00','1','1','2025-11-04 15:01:47','2025-11-04 15:01:47','17617218175043','17617218175043','CHARITABLE TRUST','112','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1079','17','1','','3','21505458','2025-11-03','3910','3905','511','MEDIGLOBE','918147760815','','','3RD FLOOR,\'\'PARIN\'\' COLLECTORS GATE CIRCLE,BALMATTA MANGALURE-1','','29AIGPB0221L1ZL','11','','IRFAN','','','SIRSI','SIRSI','','11','575001','Document','0.00','0.00','0.00','0','Document','Surface','1','0.30','','','','','0.30','51.00','1','1','2025-11-04 15:02:16','2025-12-13 16:58:24','17617216042295','17617216042295','','289','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','1','0','','','','','','1','');
INSERT INTO `booking` VALUES ('1080','9','1','','2','3283698','2025-11-04','','5351','941','ROHAN','919538343572','','','NEAR LALITHA JEWELLERY','PVS , MANGALURU','','11','575003','KARTHIK','918123869557','','429/1 CD RESIDENCY, BEERESHWAR NAGAR','B-BLOCK SF-1, CHUNCHUGATTA ROAD','','11','560062','Non Doc','500.00','0.00','0.00','0','Parcel','Surface','1','0.31','','','','','0.31','105.00','1','1','2025-11-04 15:03:18','2025-11-04 15:03:18','17617248601364','17617248601364','','1036','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1081','22','1','','2','3411089','2025-11-04','','4848','983','VISHRANTH AND KARTHIK','919845422424','','','CA 2ND FLOOR MALLIKATTE CIRCLE','MANGALORE','','11','575002','VISHRANTH AND KARTHICK','917353134562','','CA NO 625 FIRST FLOOR','IST STAGE PADMANABHANAGAR','','11','560070','Document','0.10','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-04 15:33:14','2025-11-04 15:33:14','17617169725275','17617169725275','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1082','13','1','','2','3404104','2025-11-04','','5187','985','FURQAN AHMED','918147818399','','','MANGALORE','MANGALORE','','11','575001','SUNIL R','919880598523','','GOKUL RD','HBL','','11','580030','Document','10.00','0.00','0.00','0','Document','Surface','1','0.12','','','','','0.12','85.00','1','1','2025-11-04 15:45:02','2025-11-04 15:45:02','17617147018423','17617147018423','','557','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1083','18','1','','2','3385046','2025-11-04','','5352','986','SUNIL D SOUZA','919902466605','','','KULUR KAVOOR','MANGALORE','','11','575013','MR N RANGAPPA','919448345446','','KSRTC  BUS STAND','CHIRADUGR','','11','577501','Document','10.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-04 15:59:51','2025-11-04 15:59:51','17621531273939','17621531273939','','391','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1084','20','1','','2','3418078','2025-11-04','','5379','1013','PRAVEEN','918105886687','','','MANGALORE','','','11','575001','SHAILESH PRABHU','917760248897','','SHRESTA AUTO CONSULTANCY','CITY BUS STAND','','11','576101','Document','10.00','0.00','0.00','0','Document','Surface','1','0.13','','','','','0.13','85.00','1','1','2025-11-04 16:00:38','2025-11-26 16:01:53','17616388667516','17616388667516','','1639','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1085','23','1','','2','3408558','2025-11-04','','5355','989','THE BLINGBERRY','918618651963','','','FLANIR','MANGALORE','','23','','JYOTI SHETTY','919663308111','','OPP UDUPI HOTEL','RAMAMURTHY NAGAR','','11','560016','Document','100.00','0.00','0.00','0','Document','Surface','1','0.10','','','','','0.10','75.00','1','1','2025-11-04 16:04:54','2025-11-04 16:04:54','17617218175043','17617218175043','TITAN EYE PLUS','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1086','21','1','','2','3393115','2025-11-04','','5363','997','PAVAN G','917795763348','','','HASANNA CASTLE, PARAPADHE 3RD CROSS','NEAR AKASHA BHAVANA','','11','575015','GOVINDA NAIK','919845642445','','NO. 8, SRI NIVASA, 4TH CROSS','OPP KANTHI SWEETS, KOTHANUR','','11','560077','Document','1000.00','0.00','0.00','0','Document','Surface','1','1.31','','','','','1.31','247.00','1','1','2025-11-04 16:10:38','2025-11-04 16:10:38','17616388051318','17616388051318','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1087','10','1','','2','3406790','2025-11-04','','5364','998','SHARATH KUMAR','919663389389','','','MANGALORE','','','11','575004','LAXMAN','919845671029','','WIPRO GE HELATH CARE','WHITEFIELD','','11','560066','Document','100.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-04 16:10:40','2025-11-04 16:10:40','17617151801089','17617151801089','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1088','23','1','','2','3408559','2025-11-04','','5365','999','NISIMITHA','918296572013','','','PANDESHWARA','MANGALORE','','23','','NR BATA SHOWROOM','919820763613','','100FEET ROAD','HAL 2ND STAGE','','11','560008','Document','100.00','0.00','0.00','0','Document','Surface','1','1.50','','','','','1.50','247.00','1','1','2025-11-04 16:10:52','2025-11-04 16:10:52','17617218175043','17617218175043','SHOP NO 2009','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1089','10','1','','2','3406791','2025-11-04','','5366','1000','RONALD D ALMEIDA','918105540886','','','MINI VIDHANA SOUDHA','HAMPANKATTA','','11','575001','SHRIKANTH K K','919945742884','','HESARAGHATTA ROAD','NAGASANDRA','','11','560073','Document','100.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-04 16:13:48','2025-11-04 16:13:48','17617151801089','17617151801089','NEAR ROYAL FOODS FRESH','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1090','8','1','','2','3351502','2025-11-04','','5368','1002','THILAKRAJ','918147435543','','','PORKODI','BAJPE','','11','574142','SAVITHA SUVARNA','918095326381','','SHIVA NILAYA','DURGA NAGAR','','11','574115','Document','10.00','0.00','0.00','0','Document','Surface','1','0.66','','','','','0.66','95.00','1','1','2025-11-04 16:14:56','2025-11-04 16:14:56','17617178859109','17617178859109','','3452','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1091','10','1','','2','3406792','2025-11-04','','5369','1003','KARTHIK K L','919538474755','','','BANGALORE','','','11','560061','SUNEEL KUMAR','919880925805','','METAGALLI POST','','','11','570016','Document','100.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-04 16:15:54','2025-11-04 16:15:54','17617151801089','17617151801089','TRIVENI ENGINEERING','669','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1092','6','1','','2','3381553','2025-11-04','','5371','1005','G J DHARANENDRA','919844056602','','','MANGALORE','MANGALORE','','23','','PRAFULA','910226250555','','LLOYD HEALTH CARE P LTD','MAROL ANDERI EAST','','14','400059','Document','0.01','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','100.00','1','1','2025-11-04 16:16:36','2025-11-04 16:16:36','17617213813089','17617213813089','','57','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1093','26','1','','2','3400892','2025-11-04','','5375','1009','N M A R L','919945490847','','','MLR','','','11','575022','JANATA FISH MEAL','919902098822','','KOTA','','','11','576201','Document','10.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','50.00','1','1','2025-11-04 16:16:49','2025-11-04 16:16:49','17615707686074','17615707686074','','3363','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1094','23','1','','2','3408560','2025-11-04','','5064','1016','KARTHIK AGENCIES','919845083889','','','PANDESHWARA','MANGALORE','','23','','M/S ADMINISTRIVE MEDICAL OFFICE','919686875108','','00','00','','11','575001','Document','100.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','50.00','1','1','2025-11-04 16:19:19','2025-11-04 16:19:19','17617218175043','17617218175043','TALUK HOSPITAL','2580','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1095','22','1','','2','3411090','2025-11-04','','5382','1017','BHARTI AIRTEL LTD REHMAN','919481338831','','','B H ROAD','SHIMOGA','','11','577201','SHOBA RATHOD','919008063552','','DEPUTY RANGE FOREST OFFICER','HAVERI DIVISION KARJARI RD','','11','581110','Document','0.50','0.00','0.00','0','Document','Surface','1','0.65','','','','','0.65','125.00','1','1','2025-11-04 16:19:45','2025-11-04 16:19:45','17617169725275','17617169725275','','314','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1096','13','1','','2','3404105','2025-11-04','','5385','1020','SRI MOOKAMBIKA TEXTILES','919448300294','','','MARKET ROAD','MARKET ROAD','','11','575001','RONAK TEX FAB','919427830387','','ABHISHEK TEXTILES MKT RING ROAD','','','7','395007','Document','10.00','0.00','0.00','0','Document','Surface','1','0.05','','','','','0.05','100.00','1','1','2025-11-04 16:20:38','2025-11-04 16:20:38','17617147018423','17617147018423','','163','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1097','14','1','','2','3364680','2025-11-04','','5386','1021','MOIDEEN K','919448932499','','','HOTEL BTIGADE ROYAL','L H H ROAD HAMPANKATTA','','11','575001','MR K S RAGHU','919880800460','','NALAPAD CHEMBRS','ASHOK NAGAR','','560025','560025','Document','10.00','0.00','0.00','0','Document','Surface','1','0.04','','','','','0.04','60.00','1','1','2025-11-04 16:20:47','2025-11-04 16:20:47','17617209872567','17617209872567','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1098','16','1','','4','41515306','2025-11-04','358','367','1027','NIXIES METERS PRIVATE LIMITED','919663520764','','','EPIP Industrial Area, Block No 32,  Ganjimatta, Gurupura Hobli, Mangalore, 574144','','29AAFCN9109H1Z6','11','574144','P DAMODAR RAJU','919738409658','','BANNERGHATTA ROAD','BANGALORE','','11','5','Parcel','500.00','0.00','0.00','0','Document','Surface','1','2.00','','','','','2.00','339.00','1','1','2025-11-04 16:23:59','2025-12-13 16:58:24','17617177578387','17617177578387','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','1','0','','','','','','1','');
INSERT INTO `booking` VALUES ('1099','23','1','','2','3408561','2025-11-04','','5390','1028','HOUSE OF PATAUDI','918921289924','','','PANDESHWARA','MANGALORE','','23','','HOUSE OF PATAUDI','918921289924','','BYATARAYANAPURA','YELAHANKA','','11','560092','Document','100.00','0.00','0.00','0','Document','Surface','1','0.80','','','','','0.80','155.00','1','1','2025-11-04 16:24:40','2025-11-04 16:24:40','17617218175043','17617218175043','PHOENIX MALL OF ASIA','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1100','12','1','','2','3382950','2025-11-04','','5391','1029','VINESH','919844104820','','','ATTAVARA','MANGALORE','','11','','ARIF SAB','919741439593','','1286/2 INDIRA NAGAR 1ST CROSS','MALEBANNUR','','11','577530','Document','10.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-04 16:26:20','2025-11-04 16:26:20','17617206505387','17617206505387','','2545','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1101','22','1','','2','3411091','2025-11-04','','5393','1031','SUREKA KAMATH','919940057245','','','ANIRADHA KARI RD','MANGALORE','','11','575003','ART HOUZ','917397745684','','NO 123 STERLING RD NUNGAMBAKKAM','CHENNAI','','23','600034','Document','0.10','0.00','0.00','0','Document','Surface','1','0.43','','','','','0.43','120.00','1','1','2025-11-04 16:26:33','2025-11-04 16:28:27','17617169725275','17617169725275','','1931','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1102','16','1','','4','41515307','2025-11-04','345','354','1032','KARNATAKA BANK MUCHUR','','','','GROUND FLOOR,MAIN ROAD, MACHUR VILLAGE  574144','','29AABCT5589K1ZL','11','574144','KARNATAKA BANK MUCHUR','91919','','MAIN ROAD','MOODBIDRI','','11','574227','Document','100.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','24.00','1','1','2025-11-04 16:26:58','2025-12-22 12:56:50','17617177578387','17617177578387','','1068','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','1','0','','','','','','1','');
INSERT INTO `booking` VALUES ('1103','13','1','','2','3404106','2025-11-04','','5402','1041','PAAVANI SILK AND FAB','918242440310','','','GHS ROAD','MANGALORE','','11','575001','GEETHA SHETTY','919768130997','','A WING FLAT NO 1003, ROCK ENCLAVE','HINDUSTAN NAKA AB YES BANK KANDIVALLI W','','14','400067','Document','25000.00','0.00','0.00','0','Document','Surface','1','24.00','','','','','24.00','3960.00','1','1','2025-11-04 16:29:06','2025-11-04 16:29:06','17617147018423','17617147018423','','57','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1104','20','1','','2','3418079','2025-11-04','','5408','1047','ASHOK SHETTY','919900254755','','','KODILABIL','','','11','575001','MEERA RAI','919900839859','','3\\5 KINGSTON COURT','2ND FLOOR 2ND CROSS VIVEKANADA NAGAR','','11','560033','Food Items','300.00','0.00','0.00','0','Document','Surface','1','3.35','','','','','3.35','615.00','1','1','2025-11-04 16:30:47','2025-11-04 16:30:47','17616388667516','17616388667516','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1105','8','1','','2','3351503','2025-11-04','','5412','392','DENA FURNITURE','918494900302','','','MAIN ROAD','BAJPE','','11','574142','M C C BANK','918494900302','','MAIN ROAD','KINNIGOLI','','11','574150','Document','10.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','40.00','1','1','2025-11-04 16:32:14','2025-11-04 16:32:14','17617178859109','17617178859109','','781','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1106','13','1','','2','3404107','2025-11-04','','5420','1057','PAAVANI SILK','919482531310','','','GHS ROAD','GHS ROAD','','11','575001','PAPPAYE TEXTILES','919600872855','','KAKAPALAYAM MAIN ROAD PERUMAGOUNDAMPATTI','ELAMPILLAI','','23','637502','Document','10.00','0.00','0.00','0','Document','Surface','1','0.55','','','','','0.55','80.00','1','1','2025-11-04 16:33:56','2025-11-04 16:33:56','17617147018423','17617147018423','','1815','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1107','26','1','','2','3400893','2025-11-04','','5421','1058','SUHAN M','919591480055','','','MLR','MLR','','11','575017','JAYASHANKER','919448507951','','BENSON TOWN','ANJANAPPA BLOCK','','11','560046','Document','10.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-04 16:34:13','2025-11-04 16:34:13','17615707686074','17615707686074','MARTRIKZ','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1108','8','1','','2','3351504','2025-11-04','','5422','1059','VASANTH','919880876257','','','SWAMILAPADAV','PERMUDE','','11','574142','CARMELITE  SISTERS OF CHARITY SO','916351152148','','OFF MAHAKALI CAVES ROAD','ANDHERI EAST','','14','400093','Document','100.00','0.00','0.00','0','Document','Surface','1','0.05','','','','','0.05','100.00','1','1','2025-11-04 16:35:30','2025-11-04 16:35:30','17617178859109','17617178859109','','57','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1109','25','1','','2','3388869','2025-11-04','','5008','472','CONSOLIDATED CONSTRUCTION','918971363646','','','MUKKA','SURATHAKAL','','11','575001','CONSOLIDATED CONSTRUCTION','917013707833','','J P NAGAR','DOLLARS COLONY','','11','560078','Document','100.00','0.00','0.00','0','Document','Surface','1','0.20','','','','','0.20','85.00','1','1','2025-11-04 16:38:51','2025-11-04 16:38:51','17617202587270','17617202587270','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1110','24','1','','2','3399489','2025-11-04','','5425','1062','BRIJESH RAI','919740060633','','','PUMPWELL','MANGALORE','','11','575002','LILITHA EMISSION CENTRE','917026184688','','OPP RYAN INTERNATIONAL SCHOOL','KULAI MANGALORE','','11','575019','Document','10.00','0.00','0.00','0','Document','Surface','1','0.05','','','','','0.05','50.00','1','1','2025-11-04 16:42:02','2025-11-26 15:56:16','17617227102844','17617227102844','','3453','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1111','12','1','','2','3382951','2025-11-04','','5426','1063','MILLION AQUTICS','918884687700','','','PADALNE','KUSHEKAR','','11','575001','MANJUNATH','917019989479','','OFFICE OF DEPUTY COMMISIONERS','OF POLICE WHITEFEILD DIVISION','','11','560066','Document','500.00','0.00','0.00','0','Document','Surface','1','1.30','','','','','1.30','247.00','1','1','2025-11-04 16:43:57','2025-11-04 16:43:57','17617206505387','17617206505387','CRIME SECTION','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1112','24','1','','2','3399490','2025-11-04','','5425','1066','BRIJESH RAI','919740060633','','','PUMPWELL','MANGALORE','','11','575002','RAMESH SHETTY','919845515778','','ARCHANA ASSOCIATES','KADRI MANGALORE','','11','575005','Document','10.00','0.00','0.00','0','Document','Surface','1','0.05','','','','','0.05','50.00','1','1','2025-11-04 16:45:00','2025-11-26 15:56:16','17617227102844','17617227102844','','3453','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1113','10','1','','2','3406793','2025-11-04','','5427','1067','VAMANAN NAIR E','919449821380','','','NEKKILAGUDDA','ASWATHAKATTE','','11','575006','VIDAL HEALTH INSURANCE TPA','919449821380','','GOPALAN GLOBE AXIS BLOCK','ITPL MAIN ROAD','','11','560066','Document','100.00','0.00','0.00','0','Document','Surface','1','0.10','','','','','0.10','70.00','1','1','2025-11-04 16:45:42','2025-11-04 16:45:42','17617151801089','17617151801089','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1114','21','1','','2','3393116','2025-11-04','','5428','1068','GANESH','918431909748','','','TEKNI ELEVATORS','KOTEKANI','','11','575006','H R MANJUNATH','916360289108','','K R RD','BANASHANKARI','','11','560070','Document','100.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-04 16:46:01','2025-11-04 16:46:01','17616388051318','17616388051318','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1115','8','1','','4','41616350','2025-11-04','393','402','1069','GADRE MARINE EXPORT PRIVATE LIMITEDAD290725004221E','','','','PLOT NO.IP-32 & IP-33, MANGALORE  SPECIAL ECONOMIC ZONE BAJPE POST & VILLAGE,  MANGALORE-574142','','29AABCG4138R2Z0','11','','K V N KUTTY','918296557187','','DR AMIN CONTROLLERS  PVT LTD','TTC INDL AREA MIDC','','14','400710','Document','10.00','0.00','0.00','0','Parcel','Surface','1','0.14','','','','','0.14','103.00','1','1','2025-11-04 16:46:07','2025-12-17 14:31:37','17617178859109','17617229594029','','57','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','1','0','','','','','','1','');
INSERT INTO `booking` VALUES ('1116','23','1','','2','3408562','2025-11-04','','5429','1070','CA M B RAMA BHAT','919448131495','','','CHARTERED ACCOUNTANT','BUNDER','','11','','THE BADAGABETTU CREDIT CO OP SOCIETY LTD','919353045915','','MAIN ROAD','MALPE','','11','','Document','100.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','50.00','1','1','2025-11-04 16:46:54','2025-11-04 16:46:54','17617218175043','17617218175043','','1639','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1117','13','1','','2','3404108','2025-11-04','','5437','1078','SUJIR OPTICALS','918242440392','','','GHS ROAD','','','11','575001','GEETHA S KAMATH','918299601263','','OPP GOVT SCHOOL','BALPA','','11','574232','Document','10.00','0.00','0.00','0','Document','Surface','1','0.25','','','','','0.25','60.00','1','1','2025-11-04 16:49:19','2025-11-04 16:49:19','17617147018423','17617147018423','','3411','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1118','20','1','','2','3418080','2025-11-04','','5439','1080','ELEGENT OFFICE SYSTEMS','916364036688','','','MAHENDRA ARCADE KR RD','','','11','575003','SASANKA BHUVANAGIRI','919052034003','','ABOVE JAYANTHI ELELCTRICALS','ARUNDELPET','','1','522002','Parcel','800.00','0.00','0.00','0','Document','Surface','1','0.19','','','','','0.19','95.00','1','1','2025-11-04 16:49:32','2025-11-04 16:49:32','17616388667516','17616388667516','','552','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1119','16','1','','2','3357236','2025-11-04','','5440','1081','TASLEEMA','917353395707','','','KAIKAMBA','MANGALORE','','11','574151','UMRA SAYEED','916361308919','','THADAMBAIL','SURATHKAL','','11','575025','Document','500.00','0.00','0.00','0','Document','Surface','1','0.16','','','','','0.16','65.00','1','1','2025-11-04 16:49:37','2025-11-04 16:49:37','17617177578387','17617177578387','','3453','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1120','8','1','','4','41616351','2025-11-04','393','402','1091','GADRE MARINE EXPORT PRIVATE LIMITEDAD290725004221E','','','','PLOT NO.IP-32 & IP-33, MANGALORE  SPECIAL ECONOMIC ZONE BAJPE POST & VILLAGE,  MANGALORE-574142','','29AABCG4138R2Z0','11','574142','JAYANARAYANA','917736234657','','CSEZ','KAKKANAD','','12','682037','Non Doc','500.00','0.00','0.00','0','Document','Surface','1','1.40','','','','','1.40','268.00','1','1','2025-11-04 16:52:42','2025-12-17 14:27:52','17617178859109','17617178859109','','2432','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','1','0','','','','','','1','');
INSERT INTO `booking` VALUES ('1121','13','1','','2','3404109','2025-11-04','','5451','1093','V CARE SYSTEMS','919448887558','','','CARST','MANGALOARE','','11','575001','IT WORLD','919447646401','','CITY CENTRE BUILDING','','','12','670001','Document','10.00','0.00','0.00','0','Document','Surface','1','0.26','','','','','0.26','120.00','1','1','2025-11-04 16:53:02','2025-11-04 16:53:02','17617147018423','17617147018423','','1062','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1122','20','1','','2','3418081','2025-11-04','','5452','1094','HARISH','919035923329','','','KRITHI ENT','MANGALORE','','11','575001','DAIRY CLASSIC ICE CREAMS PLTD','919739001527','','55 8TH MAIN JC INDUTRIAL ESTATE','YELECHENAHALLI','','11','560029','Document','10.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-04 16:53:17','2025-11-04 16:53:17','17616388667516','17616388667516','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1123','16','1','','2','3357237','2025-11-04','','5453','1095','DR JAGADEESH','919448858534','','','SJEC','VAMANJOOR','','11','575028','DR SATHISH','917348856029','','MITE','BADAGA MIJAR','','11','574225','Document','100.00','0.00','0.00','0','Document','Surface','1','0.10','','','','','0.10','65.00','1','1','2025-11-04 16:53:22','2025-11-04 16:53:22','17617177578387','17617177578387','','1068','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1124','8','1','','4','41616352','2025-11-04','393','402','1091','GADRE MARINE EXPORT PRIVATE LIMITEDAD290725004221E','','','','PLOT NO.IP-32 & IP-33, MANGALORE  SPECIAL ECONOMIC ZONE BAJPE POST & VILLAGE,  MANGALORE-574142','','29AABCG4138R2Z0','11','574142','HEMALATHA','917736234657','','CSEZ','KAKKANAD','','12','682037','Non Doc','500.00','0.00','0.00','0','Document','Surface','1','1.40','','','','','1.40','268.00','1','1','2025-11-04 16:54:46','2025-12-17 14:27:52','17617178859109','17617178859109','','2432','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','1','0','','','','','','1','');
INSERT INTO `booking` VALUES ('1125','20','1','','2','3418082','2025-11-04','','5457','1099','BHASKER M','919743665666','','','MANGALORE','MANGALORE','','11','575001','C M MACHAYYA','919886732825','','GANGANAGAR EXT HEBBAL BINNY MILL RD','BANGALORE NORTH','','11','560032','Document','10.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-04 16:55:17','2025-11-04 16:55:17','17616388667516','17616388667516','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1126','10','1','','2','3406794','2025-11-04','','5458','1100','SURESH D PALLI','919964025942','','','HOSADIGANTHA','BEJAI MANGALORE','','11','575004','KARNATAKA MADYAMA ACADEMY','919964025942','','DR B R AMBEDKAR VEEDHI','BANGALORE','','11','560001','Document','10.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-04 16:55:32','2025-11-04 16:55:32','17617151801089','17617151801089','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1127','8','1','','4','41616353','2025-11-04','393','402','1091','GADRE MARINE EXPORT PRIVATE LIMITEDAD290725004221E','','','','PLOT NO.IP-32 & IP-33, MANGALORE  SPECIAL ECONOMIC ZONE BAJPE POST & VILLAGE,  MANGALORE-574142','','29AABCG4138R2Z0','11','574142','ANNAPURNESHWARI AMMA','917736234657','','CSEZ','KAKKANAD','','12','682037','Non Doc','500.00','0.00','0.00','0','Document','Surface','1','1.40','','','','','1.40','268.00','1','1','2025-11-04 16:56:16','2025-12-17 14:27:52','17617178859109','17617178859109','','2432','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','1','0','','','','','','1','');
INSERT INTO `booking` VALUES ('1128','8','1','','4','41616354','2025-11-04','393','402','1091','GADRE MARINE EXPORT PRIVATE LIMITEDAD290725004221E','','','','PLOT NO.IP-32 & IP-33, MANGALORE  SPECIAL ECONOMIC ZONE BAJPE POST & VILLAGE,  MANGALORE-574142','','29AABCG4138R2Z0','11','574142','SUBAIR','917736234657','','CSEZ','KAKKANAD','','12','682037','Non Doc','500.00','0.00','0.00','0','Document','Surface','1','1.40','','','','','1.40','268.00','1','1','2025-11-04 16:58:00','2025-12-17 14:27:52','17617178859109','17617178859109','','2432','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','1','0','','','','','','1','');
INSERT INTO `booking` VALUES ('1129','16','1','','4','41515308','2025-11-04','345','354','1032','KARNATAKA BANK MUCHUR','91919','','','GROUND FLOOR,MAIN ROAD, MACHUR VILLAGE  574144','','29AABCT5589K1ZL','11','574144','KARNATAKA BANK','91919','','KANKANADY','MANGALORE','','11','575002','Document','100.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','19.00','1','1','2025-11-04 16:58:45','2025-12-22 12:56:51','17617177578387','17617177578387','','3453','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','1','0','','','','','','1','');
INSERT INTO `booking` VALUES ('1130','10','1','','2','3406795','2025-11-04','','5473','1115','SONY PLYWOOD','919731640777','','','NEAR MADHUVAN BAR','YEYYADI','','11','575008','JRD ENTERPRISES','918879500152','','ABOVE NEAR DOCOR MG','GOREGAON','','14','400104','Parcel','100.00','0.00','0.00','0','Document','Surface','1','1.40','','','','','1.40','450.00','1','1','2025-11-04 16:58:45','2025-11-04 16:58:45','17617151801089','17617151801089','','57','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1131','24','1','','2','3399491','2025-11-04','','5425','1118','BRIJESH RAI','919740060633','','','PUMPWELL','MANGALORE','','11','575002','KALANDAR ABDUL KAREE','919663338101','','KPADIL E.T.C','PUTTUR','','11','574201','Document','10.00','0.00','0.00','0','Document','Surface','1','0.05','','','','','0.05','50.00','1','1','2025-11-04 16:59:17','2025-11-04 16:59:17','17617227102844','17617227102844','','1904','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1132','12','1','','2','3382952','2025-11-04','','5426','1123','MILLION AQUTICS','918884687700','','','PADALNE','KUSHEKAR','','11','575001','ABHI','919620844456','','B/H MATRUCHAYA AMRUTHAHALLI','BANGALORE','','11','560092','Parcel','500.00','0.00','0.00','0','Document','Surface','1','1.27','','','','','1.27','247.00','1','1','2025-11-04 17:01:14','2025-11-04 17:01:14','17617206505387','17617206505387','RISHA MANSION 5TH CROSS TATACAVVERY LAYOUT','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1133','23','1','','2','3408563','2025-11-04','','5480','1124','NIKHIL PUTHRAN','919845257028','','','KUSHEKUNJ APT','MANNAGUDDA','','11','575003','G SAMPAT KUMAR','919922734567','','SWANLAKE APTS','KUKATPALLY','','5','500072','Document','100.00','0.00','0.00','0','Document','Surface','1','0.11','','','','','0.11','95.00','1','1','2025-11-04 17:01:34','2025-11-04 17:01:34','17617218175043','17617218175043','','117','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1134','20','1','','2','3418083','2025-11-04','','5482','1126','SUSHAN','916360501715','','','KULSHEKAR','MANGALORE','','11','575001','NAVIRAJ','919653366459','','HOTEL SPICES','PLOT NO 93 SECTOR3','','14','400709','Document','10.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','100.00','1','1','2025-11-04 17:03:23','2025-11-04 17:03:23','17616388667516','17616388667516','','57','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1135','10','1','','2','3406796','2025-11-04','','5485','1133','MANGALORE HIQ STATION','919964216328','','','KADRI HILLS','MANGALORE','','11','575004','MERCY NORONHA','919964216328','','KUTHETHOOR','','','11','575030','Document','100.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','50.00','1','1','2025-11-04 17:04:49','2025-11-04 17:04:49','17617151801089','17617151801089','MRPL','1573','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1136','8','1','','4','41616355','2025-11-04','393','402','1135','GADRE MARINE EXPORT PRIVATE LIMITEDAD290725004221E','','','','PLOT NO.IP-32 & IP-33, MANGALORE  SPECIAL ECONOMIC ZONE BAJPE POST & VILLAGE,  MANGALORE-574142','','29AABCG4138R2Z0','11','','ROHITH JIVAN DEVADIGA','917506121733','','MAERSK INDIA PVT LTD','12TH FLR BLOCK B  WEST  GATE  S G ROAD','','7','380051','Document','500.00','0.00','0.00','0','Parcel','Surface','1','0.85','','','','','0.85','247.00','1','1','2025-11-04 17:04:55','2025-12-17 14:36:01','17617178859109','17617229594029','','3','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','1','0','','','','','','1','');
INSERT INTO `booking` VALUES ('1137','25','1','','2','3388870','2025-11-04','','5488','1137','V SELVAM','919600713510','','','FIVE STAR','SKL','','11','575014','SATHISH TRT','918015591491','','PARAMATHI ROAD','SP PUDUR NAMAKKAL','','23','637001','Document','100.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','70.00','1','1','2025-11-04 17:05:25','2025-11-04 17:05:25','17617202587270','17617202587270','','2424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1138','20','1','','2','3418084','2025-11-04','','5489','1138','KISHORE','919900781636','','','MANGALORE','','','11','575001','DRRAJESH BHAT','918660336352','','SURYA HOSPITAL','','','11','574241','Document','10.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','50.00','1','1','2025-11-04 17:05:41','2025-11-04 17:05:41','17616388667516','17616388667516','','2352','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1139','24','1','','2','3399492','2025-11-04','','5490','1146','ROLOPO ENTERPRISES PVT LTD','917618785157','','','PADIL CROSS RD','BAJAL MANGALORE','','11','575007','AADHYA DISTRIBUTORS','919483148102','','B.S.P ASSOCIATES','BRAHMAVAR','','11','576101','Parcel','866.00','0.00','0.00','0','Parcel','Surface','1','4.82','','','','','4.82','665.00','1','1','2025-11-04 17:07:14','2025-11-04 17:07:14','17617227102844','17617227102844','','1470','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1140','20','1','','2','3418085','2025-11-04','','5489','1148','KISHORE','919900781636','','','MANGALORE','','','11','575001','DR SURENDRA SHETTY','917892158430','','MALPE NURSING HOME','','','11','576101','Document','10.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','50.00','1','1','2025-11-04 17:07:32','2025-11-04 17:07:32','17616388667516','17616388667516','','1639','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1141','25','1','','2','3388871','2025-11-04','','5491','1149','SHAKTHIVEL','919486388179','','','FIVE STAR SUPER','KANA SURATHKAL','','11','575014','ARUN REVANTH TRT','919600426812','','PARAMATHI ROAD','NAMAKKAL','','23','637001','Document','100.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','70.00','1','1','2025-11-04 17:08:07','2025-11-04 17:08:07','17617202587270','17617202587270','','2424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1142','22','1','','2','3411092','2025-11-04','','5492','1153','SREE GANESH PHARMACEUTICals','919902713363','','','g floor v s com YEYYADI','MANGALORE','','11','575008','SHREE DAMODAR MEDICALS','918746897970','','SHOP NO 11 MANKI GROUND COMPLEX','NH 17 KUMTA','','11','581343','Document','0.10','0.00','0.00','0','Document','Surface','1','0.43','','','','','0.43','105.00','1','1','2025-11-04 17:09:54','2025-11-04 17:09:54','17617169725275','17617169725275','','165','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1143','10','1','','2','3406797','2025-11-04','','5485','1133','MANGALORE HIQ STATION','919964216328','','','KADRI HILLS','MANGALORE','','11','575004','MRPL','919964216328','','KUTHETHOOR','','','11','575030','Document','100.00','0.00','0.00','0','Document','Surface','1','0.20','','','','','0.20','75.00','1','1','2025-11-04 17:10:01','2025-11-04 17:10:01','17617151801089','17617151801089','','1573','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1144','8','1','','4','41616356','2025-11-04','393','402','1135','GADRE MARINE EXPORT PRIVATE LIMITEDAD290725004221E','','','','PLOT NO.IP-32 & IP-33, MANGALORE  SPECIAL ECONOMIC ZONE BAJPE POST & VILLAGE,  MANGALORE-574142','','29AABCG4138R2Z0','11','','ROHITH JIVAN DEVADIGA','917506121733','','MAERSK INDIA PVT LTD','12TH FLR BLOCK B  WEST  GATE  S G ROAD','','7','380051','Document','500.00','0.00','0.00','0','Parcel','Surface','1','0.85','','','','','0.85','247.00','1','1','2025-11-04 17:10:39','2025-12-17 14:36:32','17617178859109','17617229594029','','3','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','1','0','','','','','','1','');
INSERT INTO `booking` VALUES ('1145','20','1','','2','3418086','2025-11-04','','5494','1155','SHRIDEVI','918050634981','','','HALEYANAGDY','','','11','574146','HARIPRASAD','919481566971','','#281 3RD MAIN 4TH CROSS','NANDINI LAYOUT','','11','560096','Document','10.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-04 17:10:42','2025-11-04 17:10:42','17616388667516','17616388667516','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1146','23','1','','2','3408564','2025-11-04','','5495','1156','PRABHAKAR RAO','919019081265','','','JEPPU MANGALORE','00','','23','','ANIL RAO','917411470332','','SECTOR 34B','KHARGAR','','14','410210','Document','100.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','100.00','1','1','2025-11-04 17:10:59','2025-11-04 17:10:59','17617218175043','17617218175043','SAI MANNAT APAR','57','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1147','24','1','','2','3399493','2025-11-04','','5496','1157','JOHN FERNCIS','919606075102','','','PUMPWELL','MANGALORE','','11','575002','GOVIND SRINIVAS','919606905672','','MOUNT ROOFING AND SYSTEMS PVT LTD','MAGADI MAIN RD BANGALORE','','11','560091','Document','10.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-04 17:11:18','2025-11-06 11:19:14','17617227102844','17617227102844','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1148','25','1','','2','3388872','2025-11-04','','5497','1158','MURUGAN','919708482113','','','FIVE STAR SUPER','KANA SURATHKAL','','11','575014','ANU TRT','919443715144','','PARAMATHI ROAD','NAMAKKAL','','23','637001','Document','100.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','70.00','1','1','2025-11-04 17:12:17','2025-11-04 17:12:17','17617202587270','17617202587270','','2424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1149','22','1','','2','3411093','2025-11-04','','5498','1159','NIDHI ENTERPRISES','919632517414','','','KRR ROAD KADRI','MANGALORE','','11','575003','HINDWARE LTD','919220909011','','NO 161 IST FLOOR IST MAIN','SHESHADRIPURAM BANGALORE','','11','560020','Document','0.10','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-04 17:13:27','2025-11-04 17:13:27','17617169725275','17617169725275','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1150','10','1','','2','3406798','2025-11-04','','5499','1160','K THIMAPPA','919480469387','','','MANGALORE GANESH BEEDI WORKS','MANGALORE','','11','575004','NIKHIL G','919986696899','','MANGALORE GANESH BEEDI WORKS','VINOBHA ROAD','','11','577005','Document','10.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-04 17:13:50','2025-11-04 17:13:50','17617151801089','17617151801089','','669','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1151','8','1','','4','41616357','2025-11-04','4496','4864','1163','MANGALORE SEZ LIMITED  AD290725004221E','','','','Plot No U-1, Sy.No 168/3A, Administrative Building,, Mangalore Special Economic Zone, Bajpe Village 574142','','29AAECM8545K1ZV','11','574142','THE DEPUTY COMMISSIONER','918242885503','','D C OFFICE','PADIL MANGALORE','','11','575007','Document','20.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','24.00','1','1','2025-11-04 17:14:07','2025-12-18 18:53:15','17617178859109','17617178859109','','3453','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','1','1','2025-12-18 18:53:15','','received','','','1','17645844402769');
INSERT INTO `booking` VALUES ('1152','6','1','','2','3381554','2025-11-04','','5501','1166','LOKESH V PUTHRAN','919741595898','','','VADIRAJA NAGARA','ALAKE MANGALORE','','11','575003','GANESH CHIDAMBARAM','919840775075','','LAKSHMISEWAMY RD','K K NAGAR','','23','600078','Document','0.01','0.00','0.00','0','Document','Surface','1','1.00','','','','','1.00','160.00','1','1','2025-11-04 17:14:19','2025-11-04 17:14:19','17617213813089','17617213813089','','1931','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1153','14','1','','2','3364681','2025-11-04','','5502','1167','NISHMITHA','918242413901','','','BANK OF BARODA Z O','MSRS RD MANGALORE','','11','575003','M B PAI','919611585822','','GUDIGARGALLI','COURT RD','','11','581343','Document','10.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-04 17:14:41','2025-11-04 17:14:41','17617209872567','17617209872567','','165','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1154','20','1','','2','3418087','2025-11-04','','5503','1168','SOUZA & PICARDO ENVIRO SOLUTIONS','919448284201','','','FALNIR RD','HIGHLANDS','','11','575001','KARNATAKA POULTRY FARMERS AND BREEDERS','919035473811','','KVAFSU VETERNINARY','COLLEGE CAMPUS HEBBAL','','11','560024','Food Items','20.00','0.00','0.00','0','Parcel','Surface','1','1.30','','','','','1.30','250.00','1','1','2025-11-04 17:14:54','2025-11-04 17:14:54','17616388667516','17616388667516','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1155','13','1','','2','3404110','2025-11-04','','4814','1169','SANNITH','918494900306','','','CARST','MANGALORE','','43','575001','UNITRON BIO MEDICALS','919449009531','','J P NAGAR','','','11','560078','Document','10.00','0.00','0.00','0','Document','Surface','1','7.70','','','','','7.70','880.00','1','1','2025-11-04 17:15:10','2025-11-04 17:15:10','17617147018423','17617147018423','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1156','21','1','','2','3393117','2025-11-04','','5504','865','M SHRIKRISHNA BHAT','919449013909','','','EVARA GUARDIAN BALWAN RESY','3RD CROSS, MALEMAR RD','','11','575006','THE MANAGER','919972061245','','LIC OF INDIA','DIVISIONAL OFFICE','','11','576101','Document','100.00','0.00','0.00','0','Document','Surface','1','0.05','','','','','0.05','50.00','1','1','2025-11-04 17:15:21','2025-11-04 17:15:21','17616388051318','17616388051318','','1639','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1157','10','1','','2','3406799','2025-11-04','','5505','1170','PRASAD MOTORS','919448121210','','','BEJAI NEW ROAD','MANGLAORE','','11','575004','M P VENKATA KRISHNAN','918026664533','','DAIRY CLASSIC ICE CREAMS PVT LTD','KANAKPURA ROAD','','11','560062','Document','10.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-04 17:15:57','2025-11-04 17:15:57','17617151801089','17617151801089','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1158','16','1','','2','3357238','2025-11-04','','5506','1171','R D SHETTY','919819393136','','','GANJIMUTT','MANGALORE','','11','574144','SWASTIK PACKAGING','918828139884','','INDL PARK','VIRAR EAST','','14','401305','Parcel','200.00','0.00','0.00','0','Document','Surface','1','0.72','','','','','0.72','230.00','1','1','2025-11-04 17:16:30','2025-11-04 17:16:30','17617177578387','17617177578387','','57','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1159','23','1','','2','3408565','2025-11-04','','5507','1172','YOUTH FACE','918105749450','','','PANDESHWARA','MANGALORE','','23','','SAABITHA','917204863719','','OPP BLUE STAR SCHOOL','BILEKHALLI','','11','560076','Document','100.00','0.00','0.00','0','Document','Surface','1','0.25','','','','','0.25','85.00','1','1','2025-11-04 17:16:34','2025-11-04 17:16:34','17617218175043','17617218175043','CHIDO GIFT & STATIONARY','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1160','20','1','','2','3418088','2025-11-04','','5508','1174','ARVIND NAYAK','917090823757','','','PVS CENTENARY BLDG','KODILABIL','','11','575001','DIRECTOR FINANCE','917090823757','','MAHE MANIPAL MANIPAL ACADEMY','HIGHER EDU','','11','576104','Document','10.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','50.00','1','1','2025-11-04 17:16:46','2025-11-04 17:16:46','17616388667516','17616388667516','','662','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1161','22','1','','2','3411094','2025-11-04','','5000','1176','SHIMNITH INDIA PVT LTD','918495068417','','','MANGALORE','MANGALORE','','11','575003','KELLA MOTORS LLP','919148727970','','NEAR BALAJI SHOWROOM','KUMTA','','11','581343','Document','0.50','0.00','0.00','0','Document','Surface','1','0.80','','','','','0.80','155.00','1','1','2025-11-04 17:17:48','2025-11-04 17:17:48','17617169725275','17617169725275','','165','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1162','24','1','','2','3399494','2025-11-04','','5509','1177','SUSHMITHA','919148745426','','','PUMPWELL','MANGALORE','','11','575002','RAHULRAJ PRAKASH','919743219511','','OPP HORTICALUTURE DEPT','HOLENARASIPUR','','11','573211','Parcel','321.00','0.00','0.00','0','Parcel','Surface','1','0.48','','','','','0.48','105.00','1','1','2025-11-04 17:18:05','2025-11-04 17:18:05','17617227102844','17617227102844','','0','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1163','20','1','','2','3418089','2025-11-04','','5508','1180','ARVIND NAYAK','917090823757','','','PVS CENTENARY BLDG','KODILABIL','','11','575001','BLS INTERNATIONAL','911111111111','','B11 BASEMNT DALMAL TOWER','NARIMAN POINT','','14','400021','Document','10.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','100.00','1','1','2025-11-04 17:18:37','2025-11-04 17:18:37','17616388667516','17616388667516','','57','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1164','21','1','','2','3393118','2025-11-04','','5510','1181','VEENU LADDER','919731944648','','','RELIANCE PETROL PUMP','KOTTARA','','11','575006','CASTLE FURNITURE','917012322821','','KANDOTH','OPPO KOORUMBA TEMPLE','','12','670307','Document','100.00','0.00','0.00','0','Document','Surface','1','0.05','','','','','0.05','70.00','1','1','2025-11-04 17:18:37','2025-11-04 17:18:37','17616388051318','17616388051318','','1908','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1165','10','1','','2','3406800','2025-11-04','','5511','1182','TANIYA MOTORS','918050156888','','','NEAR YENEPOYA SHCOOL','MANGALORE','','11','575001','SHIVA KUMAR V','917305362581','','T I CLEAN MOBILITY PVT LTD','CTH ROAD','','23','600053','Parcel','100.00','0.00','0.00','0','Document','Surface','1','0.30','','','','','0.30','120.00','1','1','2025-11-04 17:19:10','2025-11-04 17:19:10','17617151801089','17617151801089','','1931','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1166','22','1','','2','3411095','2025-11-04','','5004','464','SHIMNIT INDIA PVT LTD','916362238497','','','MALLIKATTE','MANGALORE','','11','575003','SAI RADHA MOTORS','918202525579','','BHAKTI TOWER','VIDYASAMUDRA THIRTHA RD KALSANKA','','11','576101','Document','0.50','0.00','0.00','0','Document','Surface','1','5.25','','','','','5.25','510.00','1','1','2025-11-04 17:19:23','2025-11-04 17:19:23','17617169725275','17617169725275','','1639','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1167','13','1','','2','3404111','2025-11-04','','5512','1183','J J ENT','917760202626','','','CARST MLR','','','11','575001','COASTASIA HOTELS','919972596452','','BENJANPADAVU','','','11','575001','Document','0.00','0.00','0.00','0','Document','Surface','1','0.05','','','','','0.05','50.00','1','1','2025-11-04 17:19:38','2025-11-04 17:19:38','17617147018423','17617147018423','','3453','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1168','20','1','','2','3418090','2025-11-04','','5062','1184','BRIGHT SECURITY SERVICES','918904045574','','','KODIALBAIL','','','11','575001','BIGBAGS INTERNATIONAL PLTD','919964160416','','BEELAYA UILPADY VILLAGE','EPIP INDUTRIAL AREA','','11','575001','Document','10.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','50.00','1','1','2025-11-04 17:20:14','2025-11-04 17:20:14','17616388667516','17616388667516','','3254','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1169','6','1','','2','3381555','2025-11-04','','5501','1186','LOKESH V PUTHRAN','919741595898','','','VADIRAJA NAGARA','ALAKE MANGALORE','','11','575003','DINESH','919448696963','','ARCHITEET &ENGINEER','BYPASS RD PUTTUR','','11','574201','Document','0.00','0.00','0.00','0','Document','Surface','1','0.75','','','','','0.75','95.00','1','1','2025-11-04 17:21:09','2025-11-04 17:21:09','17617213813089','17617213813089','','1904','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1170','21','1','','2','3393119','2025-11-04','','5513','1187','SKANDA BHAT','919148964196','','','ARTHA WEBLABS','KOTTARA','','11','575006','SHASHANK BHAT','917406235803','','HOUSE NO. 109 SRINIVASA NILAYA','KUMARSWAMI LAYOUT','','11','560078','Document','100.00','0.00','0.00','0','Document','Surface','1','0.21','','','','','0.21','85.00','1','1','2025-11-04 17:23:35','2025-11-04 17:23:35','17616388051318','17616388051318','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1171','24','1','','2','3399495','2025-11-04','','5425','1188','BRIJESH RAI','919740060633','','','PUMPWELL','MANGALORE','','11','575002','SUHAS BALLAL','919880164742','','SRI MAHAVEERA E.T.C','SHIRTHADY MOODABIDRI','','11','574236','Parcel','10.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','50.00','1','1','2025-11-04 17:23:41','2025-11-04 17:23:41','17617227102844','17617227102844','','1731','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1172','10','1','','2','3406801','2025-11-04','','5514','1189','SMART TECH','916362701302','','','GURU PLAZA','BEJAI MANGALORE','','11','575004','V GROUPS','919110467054','','MANDAVI TRADE CENTRE','MG ROAD KADIYALI','','11','576102','Document','100.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','50.00','1','1','2025-11-04 17:23:48','2025-11-04 17:23:48','17617151801089','17617151801089','','1639','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1173','23','1','','2','3408566','2025-11-04','','5507','1190','YOUTH FACE','918105749450','','','PANDESHWARA','MANGALORE','','23','','SAKSHI RANJANE','917721860969','','AKURDI','00','','14','411035','Document','100.00','0.00','0.00','0','Document','Surface','1','0.05','','','','','0.05','100.00','1','1','2025-11-04 17:23:51','2025-11-04 17:23:51','17617218175043','17617218175043','WORK SAKSHIS KITCHEN','13','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1174','22','1','','2','3411096','2025-11-04','','5515','1191','R ASHNA SHETTY','918197488336','','','PRESTIGE  VALLEY CREST','BEJAI','','11','575003','BALAKRISHNA SHETTY','919845509311','','KRISHNA','HIRIYANGADY KARKALA','','11','574104','Document','0.10','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','50.00','1','1','2025-11-04 17:24:00','2025-11-04 17:24:00','17617169725275','17617169725275','','75','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1175','20','1','','2','3418091','2025-11-04','','5062','1192','BRIGHT SECURITY SERVICES','918904045574','','','KODIALBAIL','','','11','575001','PSN AUTOMOTIVE MARKETING','912222222222','','NR SOMANATHA KATTE','ADYAR','','11','575001','Document','10.00','0.00','0.00','0','Document','Surface','1','0.10','','','','','0.10','65.00','1','1','2025-11-04 17:24:04','2025-11-04 17:24:04','17616388667516','17616388667516','','56','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1176','23','1','','2','3408567','2025-11-04','','5516','1193','MRS HIMA URMILA SHETTY','919480533240','','','PANDESHWARA','MANGALORE','','23','','MR MUKESH RAI','917024566229','','DILIP BUILD CO LTD','CHEENA BHASTHE KOLAR ROAD','','13','462016','Document','100.00','0.00','0.00','0','Document','Surface','1','0.01','','','','','0.01','100.00','1','1','2025-11-04 17:26:00','2025-11-04 17:26:00','17617218175043','17617218175043','FINANCE & ACCOUNTS','211','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1177','21','1','','2','3393120','2025-11-04','','5517','1194','ANANDKUMAR SHETTY','919902944311','','','HABITAT, PRASHANTH NAGAR','DEREBAIL','','11','575006','ANANDKUMAR SHETTY','919902944311','','NO. 49, TROPICAL PARADISE LAYOUT','SILVER COUNTY RD','','11','560068','Document','100.00','0.00','0.00','0','Document','Surface','1','0.13','','','','','0.13','85.00','1','1','2025-11-04 17:26:43','2025-11-04 17:26:43','17616388051318','17616388051318','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1178','24','1','','2','3399496','2025-11-04','','5425','1195','BRIJESH RAI','919740060633','','','PUMPWELL','MANGALORE','','11','575002','SRI KARTHIKEYA TYRES','918073344848','','BOBBAKERI','VITTLA','','11','574243','Document','10.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','50.00','1','1','2025-11-04 17:26:53','2025-11-04 17:26:53','17617227102844','17617227102844','','1103','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1179','20','1','','2','3418092','2025-11-04','','5508','1196','ARVIND NAYAK','917090823757','','','PVS CENTENARY BLDG','KODILABIL','','11','575001','ABBVIE THERAPEUTICS INDIA','913333333333','','PRESTIGE OBLISK','KASTUBA RD','','11','560001','Document','10.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-04 17:27:09','2025-11-04 17:27:09','17616388667516','17616388667516','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1180','14','1','','2','3364682','2025-11-04','','4999','1197','RAMESH R','919886948138','','','ESSEL TOWER 2 ND FLOOR','BUNTS HOSTEL CIRCLE MANGALORE','','11','575003','KISHORE','918105942643','','AXIS BANK LTD SRI BASAVESWARA COMPLEX','100 FT RD RAJENDRA NAGAR','','11','577201','Document','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-04 17:27:41','2025-11-04 17:27:41','17617209872567','17617209872567','','1829','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1181','23','1','','2','3408568','2025-11-04','','5516','1198','MRS HIMA URMILA SHETTY','919480533240','','','PANDESHWARA','MANGALORE','','23','','VINOD KUMAR SINGH','917024599449','','THODAR VILLAGE','00','','11','574225','Document','100.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','50.00','1','1','2025-11-04 17:27:52','2025-11-04 17:27:52','17617218175043','17617218175043','M/S DELIP BUILD','1068','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1182','25','1','','2','3388873','2025-11-04','','5518','1199','SATHISH SHETTIGAR','919481764273','','','KRISHNAPURA 5TH BLOCK','SKL','','11','575014','GANESHA SHETIGAR','919972664359','','BADAMANE','VARAMBALLI SALIKERE UDUPI','','11','576213','Parcel','1200.00','0.00','0.00','0','Document','Surface','1','1.40','','','','','1.40','180.00','1','1','2025-11-04 17:28:03','2025-11-04 17:28:03','17617202587270','17617202587270','','1639','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1183','17','1','','2','3404701','2025-11-04','','5519','1200','PROF DR K NILAN SHETTY','919481446634','','','MANGALORE','BALMATTA ROAD','','11','575002','ANUSHRUTHA','919980508451','','DOOPNHALLI','INDIRANAGRA','','11','560008','Document','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-04 17:28:59','2025-11-04 17:28:59','17617216042295','17617216042295','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1184','10','1','','2','3406802','2025-11-04','','5520','1201','DAVID','919945923459','','','NEAR KPT','OPP MANJUNATHA STORE','','11','575004','DAPHNE','919741166459','','SRI KALYANI P G FOR LADIES','RHB COLONY, MAHADEVAPURA','','11','560048','Document','10.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-04 17:29:28','2025-11-04 17:29:28','17617151801089','17617151801089','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1185','12','1','','2','3382953','2025-11-04','','5426','1202','MILLION AQUTICS','918884687700','','','PADALNE','KUSHEKAR','','11','575001','VIGNESH K','919035762951','','99 5TH CROSS HROUND FLOOR','SHABARI NAGAR LAYOUT','','11','560077','Parcel','500.00','0.00','0.00','0','Document','Surface','1','2.11','','','','','2.11','385.00','1','1','2025-11-04 17:30:25','2025-11-04 17:30:25','17617205145666','17617205145666','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1186','25','1','','2','3388874','2025-11-04','','5521','1203','ARPITHA','918453639311','','','SURATHKAL','MANGLORE','','11','575014','VANI SANTHOSH','917771099940','','SHEWALWADI','HADAPSAR PUNE','','14','412307','Parcel','500.00','0.00','0.00','0','Document','Surface','1','0.25','','','','','0.25','130.00','1','1','2025-11-04 17:30:41','2025-11-04 17:30:41','17617202587270','17617202587270','','13','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1187','23','1','','2','3408569','2025-11-04','','5507','1204','YOUTH FACE','918105749450','','','PANDESHWARA','MANGALORE','','23','','GOWTHAM K N','917760142354','','CHANNAPATNA','00','','11','573201','Document','100.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-04 17:31:29','2025-11-04 17:31:29','17617218175043','17617218175043','KHB LAYOUT','448','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1188','6','1','','2','3381556','2025-11-04','','5501','1205','LOKESH V PUTHRAN','919741595898','','','VADIRAJA NAGARA','ALAKE MANGALORE','','11','575003','DEVI PRASAD S','919845761845','','ABBAKKA NAGAR','MAIN RD KOTTARA','','11','575006','Document','0.01','0.00','0.00','0','Document','Surface','1','0.75','','','','','0.75','85.00','1','1','2025-11-04 17:31:43','2025-11-04 17:31:43','17617213813089','17617213813089','','3453','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1189','17','1','','2','3404702','2025-11-04','','5522','1206','MEENA KAHDKA','918197810779','','','MANGALORE','','','11','575002','G RAVI SHNKAR SHASTHRY','919448022217','','ADVOCATE','NEAR H D F C BANK','','11','560020','Document','0.00','0.00','0.00','0','Document','Surface','1','0.84','','','','','0.84','155.00','1','1','2025-11-04 17:33:30','2025-11-04 17:33:30','17617216042295','17617216042295','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1190','25','1','','2','3388875','2025-11-04','','5523','1207','SRI THIRUMALA INDIAN GAS','918242485196','','','KAVOOR SURATHKAL','SKL','','11','575014','HARDEV SINGH BADDHAN','919845679002','','IOCL','MISSION ROAD SAMPANGI RAMA NAGAR BLR','','11','560027','Document','100.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-04 17:34:25','2025-11-04 17:34:25','17617202587270','17617202587270','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1191','14','1','','2','3364683','2025-11-04','','5524','1208','BHARATH BANK','918242421076','','','CLASSIQUE ARCADE','HAMPANKATTA','','11','575001','BHARATH BANK CO OP BANK','918242421076','','VISHWAS TOWERS','NEAR TQ OFFICE COURT BACK RD','','11','576101','Document','0.00','0.00','0.00','0','Document','Surface','1','0.10','','','','','0.10','65.00','1','1','2025-11-04 17:35:37','2025-11-04 17:35:37','17617209872567','17617209872567','','1639','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1192','17','1','','2','3404703','2025-11-04','','5522','1206','AIRAMMA','918197810779','','','MANGALORE','','','11','575002','G RAVI SHNKAR SHASTHRY','919448022217','','ADVOCATE','NEAR H D F C BANK','','11','560020','Document','0.00','0.00','0.00','0','Document','Surface','1','0.32','','','','','0.32','105.00','1','1','2025-11-04 17:35:42','2025-11-04 17:35:42','17617216042295','17617216042295','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1193','20','1','','2','3418093','2025-11-04','','5508','1174','ARVIND NAYAK','917090823757','','','PVS CENTENARY BLDG','KODILABIL','','11','575001','R R DONNELLY INDIA PVT LTD','917090823757','','RA PURAM','CHENNAI','','23','600028','Document','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','70.00','1','1','2025-11-04 17:35:49','2025-11-04 17:35:49','17616388667516','17616388667516','','1931','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1194','13','1','','2','3404112','2025-11-04','','5512','1209','J J ENT','917760202626','','','CARST MLR','','','11','575001','LANDS FLAVOUR','919880328395','','ADYAR','MANGALORE','','11','575001','Document','10.00','0.00','0.00','0','Document','Surface','1','0.05','','','','','0.05','50.00','1','1','2025-11-04 17:36:09','2025-11-04 17:36:09','17617147018423','17617147018423','','3453','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1195','23','1','','2','3408570','2025-11-04','','5525','1210','SHRISHA P','919995354951','','','PANDESHWARA','00','','23','','RUNAID M C','918547330714','','PUNCHIRAMUKKU','RAMANTHALI','','12','670308','Document','100.00','0.00','0.00','0','Document','Surface','1','0.30','','','','','0.30','120.00','1','1','2025-11-04 17:37:15','2025-11-04 17:37:15','17617218175043','17617218175043','M C HOUSE','642','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1196','9','1','','2','3283699','2025-11-04','','5526','1211','OM SAI CARRIERS','919880879491','','','SB ROAD, BOLOOR','MANGALURU','','11','575006','UMIYA TRANSPORT CO','919825990971','','NEAR SARVODAYA SAT ISABGAL','KOKOSHICHA , UMIYA COMPLEX, SIDDPUR','','7','384151','Document','10.00','0.00','0.00','0','Document','Air','1','0.02','','','','','0.02','100.00','1','1','2025-11-04 17:37:28','2025-11-04 17:37:28','17617248601364','17617248601364','','381','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1197','7','1','','2','3395051','2025-11-04','','5527','1212','MATHA METAL WORKS','919845155538','','','BAIKAMPADY','MANGALORE','','11','575001','BHUVANESH ENG','919845414095','','KARUNJI INFRAST P LTD','AMBETADKA','','11','574201','Document','0.01','0.00','0.00','0','Document','Surface','1','0.01','','','','','0.01','50.00','1','1','2025-11-04 17:39:34','2025-11-04 17:39:34','17617199828916','17617199828916','','2577','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1198','22','1','','2','3411097','2025-11-04','','5528','1213','YATHEESH SHETTY','917975012673','','','MANGALURU','CITY HOSPITAL  KADRI','','11','575002','RAJESH NAYAK','918970787072','','25TH FLOOR AMAZONE INDIA','DR RAJKUMAR ROAD','','11','560055','Document','100.00','0.00','0.00','0','Document','Surface','1','0.15','','','','','0.15','85.00','1','1','2025-11-04 17:39:38','2025-11-04 17:39:38','17617169725275','17617169725275','','1036','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1199','23','1','','2','3408571','2025-11-04','','5507','1214','YOUTH FACE','918105749450','','','PANDESHWARA','MANGALORE','','23','','SAHIL IRANI','917386951070','','NEAR BUS STOP','PADMINI PG','','11','560034','Document','100.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-04 17:40:00','2025-11-04 17:40:00','17617218175043','17617218175043','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1200','14','1','','2','3364684','2025-11-04','','5529','1215','GOPAL KRISHNA BHAT','918951331725','','','CO OPTEX MOOKAMBIKA','BALMATA RD','','11','575001','K DEENA DAYALAN SIR','919480231223','','SHIVAJI NAGAR','BANGALORE','','11','560001','Document','0.01','0.00','0.00','0','Document','Surface','1','0.07','','','','','0.07','75.00','1','1','2025-11-04 17:40:19','2025-11-04 17:40:19','17617209872567','17617209872567','NO6 4 TH CROSS DHARMARAJA KOVIL STREET','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1201','22','1','','2','3411098','2025-11-04','','5535','1224','ASIAN POWER SYSTEMS','919448500612','','','BIKRNKATTA','MANGALURU','','11','575005','SWITCHING POWER CONVERSION P LTD','918028376545','','BDA  IND  SUB','PEENYA','','11','560058','Document','100.00','0.00','0.00','0','Document','Surface','1','0.40','','','','','0.40','105.00','1','1','2025-11-04 17:40:41','2025-11-04 17:43:55','17617169725275','17617169725275','','1036','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1202','18','1','','2','3385047','2025-11-04','','5532','1218','JUPITER SEA AND AIR SERVICES PVT LTD','919343011337','','','KULUR KAVOOR ROAD MANGALORE','','','11','575013','MR KIRAN','919900060611','','M/S SLN COFFEE AND SPICES EXPORTS','PVT LTD, KIADB INDUSTRIAL KUSHALNAGAR','','11','571234','Document','10.00','0.00','0.00','0','Document','Surface','1','0.23','','','','','0.23','85.00','1','1','2025-11-04 17:41:11','2025-11-04 17:41:11','17621531273939','17621531273939','','54','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1203','6','1','','2','3381557','2025-11-04','','5533','1219','M SHRIKUMAR','919482562860','','','MANGALORE','MANGALORE','','43','','LIFE INSURANCE CORPRATE OF INDIA','919482562860','','K R PURAM BRANCH','OLD MADRAS RD','','11','','Document','0.01','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-04 17:41:15','2025-11-04 17:41:15','17617213813089','17617213813089','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1204','20','1','','2','3418094','2025-11-04','','5508','1174','ARVIND NAYAK','917090823757','','','PVS CENTENARY BLDG','KODILABIL','','11','575001','PRESTIGE ESTATE PROJECT LTD','917090823757','','MAIN GUARD CROSS ROAD','','','11','560001','Document','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-04 17:41:49','2025-11-04 17:41:49','17616388667516','17616388667516','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1205','21','1','','2','3393121','2025-11-04','','5534','1220','MAPS','918904364762','','','KOTTARA','MLR','','11','575006','VASUDEVA B','919845713866','','GOVT PRE UNIVERSITY COLLGE','KARNAD','','11','574154','Document','100.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','50.00','1','1','2025-11-04 17:41:58','2025-11-04 17:41:58','17616388051318','17616388051318','','744','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1206','23','1','','2','3408572','2025-11-04','','5507','1221','YOUTH FACE','918105749450','','','PANDESHWARA','MANGALORE','','23','','santharam','919894162685','','KRISHNARAJPURAM','ARUGUL','','23','628001','Document','100.00','0.00','0.00','0','Document','Surface','1','0.25','','','','','0.25','95.00','1','1','2025-11-04 17:42:39','2025-11-04 17:42:39','17617218175043','17617218175043','st thomas COLLEGE','2549','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1207','14','1','','2','3364685','2025-11-04','','5529','1222','GOPAL KRISHNA BHAT','918951331725','','','CO OPTEX MOOKAMBIKA','BALMATA RD','','11','575001','RAJASHEKAR','918880004022','','NO12 MALLIKYATHANA HALLI VILLEG','SHIVANASAMUDRAM BLAFF POSTMALAVALLI TQ','','11','571430','Document','0.00','0.00','0.00','0','Document','Surface','1','0.07','','','','','0.07','75.00','1','1','2025-11-04 17:43:25','2025-11-04 17:43:25','17617209872567','17617209872567','','403','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1208','20','1','','2','3418095','2025-11-04','','5508','1223','ARVIND NAYAK','917090823757','','','PVS CENTENARY BLDG','KODILABIL','','11','575001','NARAYAN MANJREKAR','919029392001','','A/207 BHAVESHWAR ARACADE LBS MARG','SHREYAS CINEMA GHATKOPAR','','14','400086','Document','0.00','0.00','0.00','0','Document','Surface','1','0.24','','','','','0.24','130.00','1','1','2025-11-04 17:43:37','2025-11-04 17:43:37','17616388667516','17616388667516','','57','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1209','25','1','','2','3388876','2025-11-04','','5536','1225','RAKESH KUMAR SAHU','918130025446','','','HOSABETTU','SURATHKAL','','11','575019','VARUNA GROUP','919205599971','','VARUNA INTEGRETED LOGISTICS','SECTOR 37','','8','122001','Document','100.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','100.00','1','1','2025-11-04 17:44:05','2025-11-04 17:44:05','17617202587270','17617202587270','','5','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1210','17','1','','2','3404704','2025-11-04','','5537','511','KAMALKSHA P','919448503385','','','ADVOCATE','KANKANADY MANGALORE','','11','575002','SHIKHA SINGH','','','CARE HEALTH INS','GDF COURSE ROAD','','8','122009','Document','0.01','0.00','0.00','0','Document','Surface','1','0.10','','','','','0.10','120.00','1','1','2025-11-04 17:44:10','2025-11-04 17:44:10','17617216042295','17617216042295','','5','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1211','13','1','','2','3404113','2025-11-04','','5512','1226','J J ENT','917760202626','','','CARST MLR','','','11','575001','PROMINENT JEWEL','917996889545','','B M ROAD','MANGALORE','','11','560001','Document','10.00','0.00','0.00','0','Document','Surface','1','0.05','','','','','0.05','60.00','1','1','2025-11-04 17:44:23','2025-11-04 17:44:23','17617147018423','17617147018423','','448','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1212','22','1','','2','3411099','2025-11-04','','5538','553','DR KRISHNAPRASAD','919448529048','','','PA COLLEGE OF ENGI','NADUPADAVU MANGALORE','','11','574153','registrar evaluation','918312498136','','VISVESVARAYA TECHNOLOGICAL UNIVERSITY','jnana sangama','','11','590018','Document','0.10','0.00','0.00','0','Document','Surface','1','0.07','','','','','0.07','75.00','1','1','2025-11-04 17:44:55','2025-11-04 17:44:55','17617169725275','17617169725275','','4','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1213','8','1','','4','41616358','2025-11-04','426','435','511','S K D R D P  B.C.TRUST(R)BAJPE','','','','VII 14, SKDRDP BC TRUST DHARMASHREE BUILDING, Dharmasthala, Dharmasthala, Dakshina Kannada, Karnataka, 574216','','29AATTS5755P1Z3','11','574142','MICRO INS OFFICE','','','LIC DIV','AJJARKADU UDUPI','','11','574101','Document','10.00','0.00','0.00','0','Document','Surface','1','4.11','','','','','4.11','358.00','1','1','2025-11-04 17:45:01','2025-12-18 18:50:49','17617178859109','17617178859109','','1639','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','1','1','2025-12-18 18:50:49','','received','','','1','17645844402769');
INSERT INTO `booking` VALUES ('1214','23','1','','2','3408573','2025-11-04','','5507','1227','YOUTH FACE','918105749450','','','PANDESHWARA','MANGALORE','','23','','LATA HAKE','919359888144','','KRUPA NIWAS','CHICHWAD','','14','411033','Document','100.00','0.00','0.00','0','Document','Surface','1','0.20','','','','','0.20','130.00','1','1','2025-11-04 17:45:25','2025-11-04 17:45:25','17617218175043','17617218175043','MUNJOBA VASAHAT','13','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1215','6','1','','2','3381558','2025-11-04','','5539','1228','DILIP','919886831849','','','SHREE GANESH TRANSPORT','BOLOOR','','43','','INDRAS AGENCIES P LTD','919739430495','','5TH MAINRD','CHAMARAJPET','','11','560018','Document','0.01','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-04 17:45:30','2025-11-04 17:45:30','17617213813089','17617213813089','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1216','22','1','','2','3411100','2025-11-04','','5538','553','DR KRISHNAPRASAD','919448529048','','','PA COLLEGE OF ENGI','NADUPADAVU MANGALORE','','11','574153','registrar evaluation','918312498136','','V T U','jnana sangama','','11','590018','Document','0.10','0.00','0.00','0','Document','Surface','1','0.07','','','','','0.07','75.00','1','1','2025-11-04 17:46:22','2025-11-04 17:46:22','17617169725275','17617169725275','','4','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1217','21','1','','2','3393122','2025-11-04','','5540','1229','AJITH SHET','919342437555','','','CHILIMBI','MLR','','11','575006','DARASHAN','917892414297','','ADR HELTH CARE','JAYANAGAR','','11','577201','Document','100.00','0.00','0.00','0','Document','Surface','1','4.51','','','','','4.51','845.00','1','1','2025-11-04 17:46:30','2025-11-04 17:46:30','17616388051318','17616388051318','','1829','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1218','17','1','','2','3404705','2025-11-04','','5541','1230','BEUMONDE','919591799455','','','KANKANDY','MANGALORE','','11','575002','ASHRAF K M','919731764986','','MUNCIPALITY COMPLEX','KASARGOD','','12','671121','Document','0.00','0.00','0.00','0','Document','Surface','1','0.10','','','','','0.10','85.00','1','1','2025-11-04 17:47:00','2025-11-04 17:47:00','17617216042295','17617216042295','','1062','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1219','20','1','','2','3418096','2025-11-04','','5542','1231','BRIGHTWAY INDIA CONSULTANCY','919148704688','','','KODIALBAIL','','','11','575003','SHELL INDIA MARKETS PVT LTD','919599777287','','DEVANAHALLI INDS PARK','','','11','562149','Document','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-04 17:47:24','2025-11-04 17:47:24','17616388667516','17616388667516','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1220','23','1','','2','3408574','2025-11-04','','5507','1232','YOUTH FACE','918105749450','','','PANDESHWARA','MANGALORE','','23','','NOOR SABA','919739989843','','A R BUILDERS','RBI COLONY JAYANAGAR','','11','560011','Document','100.00','0.00','0.00','0','Document','Surface','1','0.05','','','','','0.05','60.00','1','1','2025-11-04 17:47:38','2025-11-04 17:47:38','17617218175043','17617218175043','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1221','13','1','','2','3404114','2025-11-04','','5512','1233','ROYAL ENT','917760202626','','','CARST MLR','','','43','575001','NVS STORES','919845668030','','BEHIND NET CAMPUS','KEMMANNU TEMPLE','','11','574110','Document','10.00','0.00','0.00','0','Document','Surface','1','0.05','','','','','0.05','50.00','1','1','2025-11-04 17:47:38','2025-11-04 17:47:38','17617147018423','17617147018423','','738','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1222','22','1','','2','3411101','2025-11-04','','5538','553','DR KRISHNAPRASAD','919448529048','','','PA COLLEGE OF ENGI','NADUPADAVU MANGALORE','','11','574153','registrar evaluation','918312498136','','vtu','jnana sangama','','11','','Document','0.10','0.00','0.00','0','Document','Surface','1','0.07','','','','','0.07','75.00','1','1','2025-11-04 17:47:42','2025-11-04 17:47:42','17617169725275','17617169725275','','4','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1223','7','1','','2','3395052','2025-11-04','','5543','1234','MANGALA BIOTECH','918242407245','','','BAIKAMPADY IND AREA','MANGALORE','','11','575011','KAVITHA','916364886184','','DEEPTHY LAB','PEENYA','','11','560058','Document','0.01','0.00','0.00','0','Document','Surface','1','0.95','','','','','0.95','160.00','1','1','2025-11-04 17:47:44','2025-11-04 17:47:44','17617199828916','17617199828916','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1224','14','1','','2','3364686','2025-11-04','','5529','1235','GOPAL KRISHNA BHAT','918951331725','','','CO OPTEX MOOKAMBIKA','BALMATA RD','','11','575001','SRI MANICKAM SIR','919940884498','','CO OPTEX R O P B NO 10','CO OPTEX BLDG','','23','607002','Document','0.00','0.00','0.00','0','Document','Surface','1','0.07','','','','','0.07','85.00','1','1','2025-11-04 17:47:52','2025-11-04 17:47:52','17617209872567','17617209872567','','326','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1225','8','1','','4','41616359','2025-11-04','434','443','511','STATE BANK OF INDIA  BAJPE','','','','MAIN ROAD NEAR BAJPE POLICE STATION BAJPE','','29AAACS8577K3ZJ','11','574142','DGM SBI','','','BEJAI CHURCH RD','MANGALORE','','11','575001','Document','10.00','0.00','0.00','0','Document','Surface','1','1.53','','','','','1.53','33.00','1','1','2025-11-04 17:48:24','2025-12-13 16:58:25','17617178859109','17617178859109','','3453','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','1','0','','','','','','1','');
INSERT INTO `booking` VALUES ('1226','24','1','','2','3399497','2025-11-04','','5544','1236','NIRMAL KUMAR','917002148822','','','MAROLI','MANGALORE','','11','575005','M.CHANDRA SEKHAR','919989390665','','KARNATAKA BANK LTD','BY PASS RD KADIRI','','1','515591','Document','10.00','0.00','0.00','0','Parcel','Surface','1','0.02','','','','','0.02','70.00','1','1','2025-11-04 17:48:56','2025-11-04 17:48:56','17617227102844','17617227102844','','118','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1227','22','1','','2','3411102','2025-11-04','','5538','553','DR KRISHNAPRASAD','919448529048','','','PA COLLEGE OF ENGI','NADUPADAVU MANGALORE','','11','574153','registrar evaluation','918312498136','','vtu','jnana sangama','','11','','Document','0.10','0.00','0.00','0','Document','Surface','1','0.07','','','','','0.07','75.00','1','1','2025-11-04 17:49:01','2025-11-04 17:49:01','17617169725275','17617169725275','','4','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1228','6','1','','2','3381559','2025-11-04','','5545','1237','PAWAN KUMAR','919845131458','','','ASHOK NAGAR','MANGALORE','','11','','SANGEETHA','912226592381','','SWITZ INTERNATIONAL P LTD','BALARAMA BANDRA KURLA','','14','400051','Document','0.01','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','100.00','1','1','2025-11-04 17:49:03','2025-11-04 17:49:03','17617213813089','17617213813089','','57','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1229','20','1','','2','3418097','2025-11-04','','5546','1238','BRIGHTWAY INDIA CONSULTANCY','917338505225','','','MANGALORE','','','11','575003','HARI KUMAR','919901789610','','MRPL','KUTHETHOOR','','11','575030','Document','0.00','0.00','0.00','0','Document','Surface','1','0.90','','','','','0.90','105.00','1','1','2025-11-04 17:49:17','2025-11-04 17:49:17','17616388667516','17616388667516','','3211','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1230','7','1','','2','3395053','2025-11-04','','4679','1239','M R TRANSPORT','917204081998','','','BAIKAMPADY','MANGALORE','','11','575011','NEW LUCKY TPT','919880964852','','OLD PB ROAD','SANKESHWAR','','11','591313','Document','0.01','0.00','0.00','0','Document','Surface','1','0.01','','','','','0.01','60.00','1','1','2025-11-04 17:49:22','2025-11-04 17:49:22','17617199828916','17617199828916','','4','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1231','13','1','','2','3404115','2025-11-04','','5512','1240','ROYAL ENT','917760202626','','','CARST MLR','MANGALORE','','11','575001','WEIWO TELECOM SERV','919380990640','','PGS TOWER JEWEL ROACK ROAD','','','11','575001','Document','10.00','0.00','0.00','0','Document','Surface','1','0.05','','','','','0.05','60.00','1','1','2025-11-04 17:49:27','2025-11-04 17:49:27','17617147018423','17617147018423','','1829','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1232','25','1','','2','3388877','2025-11-04','','5547','1241','SUPRA PACIFIC','917353255537','','','HNGC ICON TOWER','MAIN ROAD SURATHKAL','','11','575014','RAJIMOL K R','918921989132','','SUPRA PACIFIC FINANCIAL','THRIKKAKARA ERNAKULAM','','12','682021','Document','100.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','70.00','1','1','2025-11-04 17:49:39','2025-11-04 17:49:39','17617202587270','17617202587270','','1930','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1233','22','1','','2','3411103','2025-11-04','','5538','553','DR KRISHNAPRASAD','919448529048','','','PA COLLEGE OF ENGI','NADUPADAVU MANGALORE','','11','574153','registrar evaluation','918312498136','','vtu','jnana sangama','','11','','Document','0.10','0.00','0.00','0','Document','Surface','1','0.07','','','','','0.07','75.00','1','1','2025-11-04 17:49:56','2025-11-04 17:49:56','17617169725275','17617169725275','','4','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1234','23','1','','2','3408575','2025-11-04','','5507','1242','YOUTH FACE','918105749450','','','PANDESHWARA','MANGALORE','','23','','RUBEENA','919663588119','','KUDROLI','','','11','575003','Document','100.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','35.00','1','1','2025-11-04 17:50:04','2025-11-04 17:50:04','17617218175043','17617218175043','','3453','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1235','17','1','','2','3404706','2025-11-04','','5548','1243','GEO PRECISE','919880725733','','','MANGALORE','','','11','575002','AEGS LOGESTIC','919969562036','','NMPA','BAIKMPADY','','11','575010','Document','0.01','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','30.00','1','1','2025-11-04 17:50:17','2025-11-26 15:56:16','17617216042295','17617216042295','','3453','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1236','14','1','','2','3364687','2025-11-04','','5529','1244','GOPAL KRISHNA BHAT','918951331725','','','CO OPTEX MOOKAMBIKA','BALMATA RD','','11','575001','MR GOPAL ARUNCHALAM SIR','919150285300','','NO 256  ROMANAR STREET','SHANMUGA NAGAR','','23','631502','Document','0.00','0.00','0.00','0','Document','Surface','1','0.07','','','','','0.07','85.00','1','1','2025-11-04 17:50:46','2025-11-04 17:50:46','17617209872567','17617209872567','','3094','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1237','8','1','','4','41616360','2025-11-04','390','399','1245','CARDOLITE SPECIALTY CHEMICALS INDIA  LLP(ARN)AD290725004221E','','','','PLOT NO IP-1 & IP-2, MANGALORE SPECIAL ECONOMIC ZONE (MSEZ) PAILA, BAJPE VILLAGE & POST, MANGALORE-574142','','29AAJFC3620M2Z7','11','574142','SATYAPRASAD','917760978790','','RESUSTAINABILITY INDL SOLUC  LTD','KIADB  1ST PHASE','','11','572128','Non Doc','500.00','0.00','0.00','0','Document','Surface','1','3.44','','','','','3.44','554.00','1','1','2025-11-04 17:50:54','2025-12-13 16:58:25','17617178859109','17617178859109','','1633','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','1','0','','','','','','1','');
INSERT INTO `booking` VALUES ('1238','20','1','','2','3418098','2025-11-04','','5549','1246','BRIGHTWAY INDIA CONSULATNCY','917349216896','','','MANGALORE','','','11','575003','IRANNA SURYAKANTH PATIL','918123382013','','NEAR JSS HOSPITAL','VIJAYAPUR','','11','586104','Document','0.00','0.00','0.00','0','Document','Surface','1','1.10','','','','','1.10','201.00','1','1','2025-11-04 17:51:08','2025-11-04 17:51:08','17616388667516','17616388667516','','2357','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1239','13','1','','2','3404116','2025-11-04','','5512','1247','ROYAL ENT','917760202626','','','CARST MLR','MANGALORE','','11','575001','SPV ONE ENERGY','919731057734','','KALTHUR HEBRI','','','11','576215','Document','10.00','0.00','0.00','0','Document','Surface','1','0.05','','','','','0.05','50.00','1','1','2025-11-04 17:51:34','2025-11-04 17:51:34','17617147018423','17617147018423','','3030','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1240','23','1','','2','3408576','2025-11-04','','5507','1248','YOUTH FACE','918105749450','','','PANDESHWARA','MANGALORE','','23','','TASMIYA','918088052015','','SHREE LAXMI GANESH','JARKALA','','11','575001','Document','100.00','0.00','0.00','0','Document','Surface','1','0.25','','','','','0.25','75.00','1','1','2025-11-04 17:51:53','2025-11-04 17:51:53','17617218175043','17617218175043','','75','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1241','8','1','','4','41616361','2025-11-04','426','435','511','S K D R D P  B.C.TRUST(R)BAJPE','','','','VII 14, SKDRDP BC TRUST DHARMASHREE BUILDING, Dharmasthala, Dharmasthala, Dakshina Kannada, Karnataka, 574216','','29AATTS5755P1Z3','23','57142','S K D R D P','','','PRK DEPT','DHARMASTHALA','','11','574216','Document','10.00','0.00','0.00','0','Document','Surface','1','0.15','','','','','0.15','22.00','1','1','2025-11-04 17:53:02','2025-12-13 16:58:25','17617178859109','17617178859109','','416','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','1','0','','','','','','1','');
INSERT INTO `booking` VALUES ('1242','7','1','','2','3395054','2025-11-04','','5543','1234','MANGALA BIOTECH','918242407245','','','BAIKAMPADY IND AREA','MANGALORE','','11','575011','KAVITHA','916364886184','','DEEPTHY LAB','PEENYA','','11','560058','Document','0.01','0.00','0.00','0','Document','Surface','1','0.72','','','','','0.72','130.00','1','1','2025-11-04 17:53:07','2025-11-04 17:53:07','17617199828916','17617199828916','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1243','16','1','','4','41515309','2025-11-04','329','338','511','CANARA BANK GANJIMUTT (SY BK)','','','','5th Floor, 112, Canara Bank Head Office, JC Road, Town Hall Junction, Nagartapete, Bengaluru, Bengaluru Urban, , 560002','','29AAACC6106G1ZX','11','574144','CANARA BANK','','','BANAGALORE','','','11','560001','Document','100.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','18.00','1','1','2025-11-04 17:53:09','2025-12-13 16:58:25','17617177578387','17617177578387','HUDSON CIRCLE','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','1','0','','','','','','1','');
INSERT INTO `booking` VALUES ('1244','17','1','','2','3404707','2025-11-04','','5048','1249','PRASANNA BHAT','','','','MITSUBISHI ELEVATOR','','','11','575002','KRISHNAMURTHY','918022252548','','MITSUBISHI ELEVATOR','RAJBHAVAN ROAD','','11','560001','Document','0.00','0.00','0.00','0','Document','Surface','1','0.08','','','','','0.08','75.00','1','1','2025-11-04 17:53:36','2025-11-04 17:53:36','17617216042295','17617216042295','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1245','21','1','','2','3393123','2025-11-04','','5550','1250','INLAND WORLD LOGISICS PVT LTD','918979965215','','','KOTTARA','MLR','','11','575006','WINNY VALDER','919483532127','','MRPL','KUTHETTUR','','11','575030','Document','100.00','0.00','0.00','0','Document','Surface','1','0.18','','','','','0.18','75.00','1','1','2025-11-04 17:53:41','2025-11-04 17:53:41','17616388051318','17616388051318','','1573','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1246','10','1','','2','3406803','2025-11-04','','5551','1251','ROHITH DEVADIGA B','919591804888','','','TSI','MANGALORE','','11','575004','MANJUNATH','919663198463','','SIDDARTH ASSOCITES','MYSORE ROAD','','11','560001','Document','10.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-04 17:53:55','2025-11-04 17:53:55','17617151801089','17617151801089','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1247','20','1','','2','3418099','2025-11-04','','5552','1252','SHARATH KUMAR ADVOCATE','919844134248','','','MANGALORE','','','11','575001','SAVITHA B','919880332265','','GANESH GARDEN PHASE','BANGALORE','','11','562149','Document','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-04 17:54:20','2025-11-04 17:55:08','17616388667516','17616388667516','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1248','22','1','','2','3411104','2025-11-04','','5553','1253','SUKHIRAJ SHETTY','917760380919','','','KADRI','MANGALURU','','11','575003','SRIKANTH  G M','918971378497','','ASM IB  KARUR VYSYA BANK','B M ROAD','','11','573201','Document','100.00','0.00','0.00','0','Document','Surface','1','0.10','','','','','0.10','75.00','1','1','2025-11-04 17:54:44','2025-11-04 17:54:44','17617169725275','17617169725275','','448','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1249','16','1','','4','41515310','2025-11-04','349','358','511','M.MADHAVARAYA  PRABHU','','','','4-174,4-173,4-177/2, MUDUPERAR, MUDUPERAR, MUDUPERAR, Dakshina Kannada, 574151','','29AKDPP2877M1ZE','11','574151','APMC','','','BAIKAMPADY','MANGALORE','','11','575001','Document','100.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','35.00','1','1','2025-11-04 17:55:22','2025-12-13 16:58:25','17617177578387','17617177578387','','3453','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','1','0','','','','','','1','');
INSERT INTO `booking` VALUES ('1250','17','1','','2','3404708','2025-11-04','','5554','1254','HEALTH MART','919986469343','','','BALMATTA NEW ROAD','MANGALORE','','11','575002','ASHRAYA HOSPITAL','919448234260','','NAIDU STREET','','','11','577101','Document','0.00','0.00','0.00','0','Document','Surface','1','0.20','','','','','0.20','85.00','1','1','2025-11-04 17:56:00','2025-11-04 17:56:00','17617216042295','17617216042295','','695','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1251','8','1','','4','41616362','2025-11-04','435','444','511','STATE BANK OF INDIA  KINNIGOLI','','','','65, State Bank of India, Local Head Office, St. Marks Road, Bengaluru, Bengaluru Urban,  560001','','29AAACS8577K3ZJ','11','574150','S B I','','','R  B O','MANGALORE','','11','575001','Document','20.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','9.00','1','1','2025-11-04 17:56:45','2025-12-13 16:58:25','17617178859109','17617178859109','','3453','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','1','0','','','','','','1','');
INSERT INTO `booking` VALUES ('1252','16','1','','4','41515311','2025-11-04','349','358','511','M.MADHAVARAYA  PRABHU','','','','4-174,4-173,4-177/2, MUDUPERAR, MUDUPERAR, MUDUPERAR, Dakshina Kannada, 574151','','29AKDPP2877M1ZE','11','574151','APMC','','','BAIKAMPADY','MANGALORE','','11','575001','Document','100.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','35.00','1','1','2025-11-04 17:56:51','2025-12-13 16:58:25','17617177578387','17617177578387','','3453','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','1','0','','','','','','1','');
INSERT INTO `booking` VALUES ('1253','10','1','','2','3406804','2025-11-04','','5555','1255','DR K DEEPAK PAI','919845231224','','','GURU PLAZA','BEJAI MANGALORE','','11','575004','ANAPPA PRABHU','919448214663','','NATIONAL INS CO LTD','PO JODUMARGA','','11','574219','Document','10.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','50.00','1','1','2025-11-04 17:57:02','2025-11-04 17:57:02','17617151801089','17617151801089','','1006','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1254','23','1','','2','3408577','2025-11-04','','5507','1256','YOUTH FACE','918105749450','','','PANDESHWARA','MANGALORE','','23','','KRISHNA KRISH','919740118921','','GARUDACHAR PAIYA','MAHADEVPURA','','11','560048','Document','100.00','0.00','0.00','0','Document','Surface','1','0.05','','','','','0.05','60.00','1','1','2025-11-04 17:57:03','2025-11-04 17:57:03','17617218175043','17617218175043','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1255','12','1','','2','3382955','2025-11-04','','5556','1257','LIFE SAFE','919901892079','','','FALNIR','','','11','575002','DEVARAJ','919741185714','','SAMPIGAMMA KRUPE','HALEBEEDU ROAD SALAGAME','','11','573219','Document','4700.00','0.00','0.00','0','Document','Surface','1','0.25','','','','','0.25','85.00','1','1','2025-11-04 17:57:33','2025-11-04 17:57:33','17617206505387','17617206505387','','3295','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1256','21','1','','2','3393124','2025-11-04','','5557','1258','THEJASRI','919901070053','','','URWASTORE','MLR','','11','575006','VIYAYAU J','919661119130','','TALL GATE','MYS RD','','11','560026','Document','0.10','0.00','0.00','0','Document','Surface','1','0.10','','','','','0.10','75.00','1','1','2025-11-04 17:57:44','2025-11-04 17:57:44','17616388051318','17616388051318','EVEREST PLY VENEERS PVT LTD','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1257','13','1','','2','3404117','2025-11-04','','5512','1259','ROYAL ENT','917760202626','','','CARST MLR','','','43','575001','SREENASH BUSINESS SOLUTIONS','919845892294','','PRIME CITY CENTRE MALL','','','11','574104','Document','0.00','0.00','0.00','0','Document','Surface','1','0.05','','','','','0.05','50.00','1','1','2025-11-04 17:58:00','2025-11-04 17:58:00','17617147018423','17617147018423','','75','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1258','8','1','','4','41616363','2025-11-04','435','444','511','STATE BANK OF INDIA  KINNIGOLI','','','','65, State Bank of India, Local Head Office, St. Marks Road, Bengaluru, Bengaluru Urban,  560001','','29AAACS8577K3ZJ','11','574142','S  B I','','','FOCAL POINT BRANCH','BANGALORE','','11','560009','Document','10.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','14.00','1','1','2025-11-04 17:58:34','2025-12-13 16:58:25','17617178859109','17617178859109','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','1','0','','','','','','1','');
INSERT INTO `booking` VALUES ('1259','16','1','','4','41515312','2025-11-04','349','358','1260','M.MADHAVARAYA  PRABHU','','','','4-174,4-173,4-177/2, MUDUPERAR, MUDUPERAR, MUDUPERAR, Dakshina Kannada, 574151','','29AKDPP2877M1ZE','11','574151','PUNARNAVA INS BROKING','919483185516','','KODILABAIL','MANGALORE','','11','575003','Document','100.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','35.00','1','1','2025-11-04 17:58:38','2025-12-13 16:58:25','17617177578387','17617177578387','','3453','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','1','0','','','','','','1','');
INSERT INTO `booking` VALUES ('1260','23','1','','2','3408578','2025-11-04','','5507','1261','YOUTH FACE','918105749450','','','PANDESHWARA','MANGALORE','','23','','PAVITRA','918971560639','','DODDAMANI COLONY','KRISTEN COLONY','00','11','580063','Document','100.00','0.00','0.00','0','Document','Surface','1','0.25','','','','','0.25','85.00','1','1','2025-11-04 17:58:51','2025-11-04 17:58:51','17617218175043','17617218175043','','557','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1261','17','1','','2','3404709','2025-11-04','','5558','1262','AZIS AHMMED','919448205206','','','MANGALORE','','','11','575002','COMPASS LOGESTIC INTL','919972679339','','OPP JAKKUR','','','11','560064','Document','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-04 17:58:56','2025-11-04 17:58:56','17617216042295','17617216042295','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1262','13','1','','2','3404118','2025-11-04','','5512','1263','ROYAL ENT','917760202626','','','CARST MLR','','','11','575001','HITECH MEDICARE HOSPITAL','917019802811','','NEAR SHAMILI AUDITORIE','','','11','575001','Document','10.00','0.00','0.00','0','Document','Surface','1','0.05','','','','','0.05','50.00','1','1','2025-11-04 17:59:41','2025-11-04 17:59:41','17617147018423','17617147018423','','1639','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1263','16','1','','4','41515313','2025-11-04','354','363','511','MESCOM KAIKAMBA','','','','1557, MESCOM BHAVANA, KAVOOR CROSS ROAD, BEJAI, MANGALURU, Dakshina Kannada, 575004','','29AADCM7029H1ZA','11','574151','MESCOM','','','CORP OFFICE','MANGALORE','','11','575001','Document','100.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','17.00','1','1','2025-11-04 18:00:06','2025-12-13 16:58:25','17617177578387','17617177578387','','3453','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','1','0','','','','','','1','');
INSERT INTO `booking` VALUES ('1264','22','1','','2','3411105','2025-11-04','','5559','1264','RAVIRAJ MURLAI TECREATIL P LTD','919150016573','','','KADRI','MANGALURU','','11','575002','PSR SILK SAREES IND P LTD','919422249869','','942 CROSS CUT ROAD','GANDHIPURAM','','23','641012','Document','100.00','0.00','0.00','0','Document','Surface','1','0.25','','','','','0.25','95.00','1','1','2025-11-04 18:00:35','2025-11-04 18:00:35','17617169725275','17617169725275','','535','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1265','20','1','','2','3418100','2025-11-04','','5560','1265','PRASHANTH HEGDE','919880479768','','','ASHOKNAGAR','MANGALORE','','11','575006','MILIND JADHAV','911922074872','','ABBOTT HEALTH CARE PVT LTD','BANDRA EAST','','14','400051','Document','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','100.00','1','1','2025-11-04 18:01:03','2025-11-04 18:01:03','17616388667516','17616388667516','','57','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1266','17','1','','2','3404710','2025-11-04','','5554','1266','HEALTH MART','919986469343','','','BALMATTA NEW ROAD','MANGALORE','','11','575002','SARJI HOSPITAL','919659371897','','DURGIFUDI','','','11','577201','Document','0.00','0.00','0.00','0','Document','Surface','1','0.20','','','','','0.20','85.00','1','1','2025-11-04 18:01:04','2025-11-04 18:01:04','17617216042295','17617216042295','','1829','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1267','13','1','','2','3404119','2025-11-04','','5512','1267','ROYAL ENT','917760202626','','','CARST MLR','','','11','575001','RNS GUEST HOUSE','919611035215','','RNR RESIDENCY','','','11','560001','Document','10.00','0.00','0.00','0','Document','Surface','1','0.05','','','','','0.05','60.00','1','1','2025-11-04 18:01:05','2025-11-04 18:01:05','17617147018423','17617147018423','','994','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1268','23','1','','2','3408579','2025-11-04','','5507','1268','YOUTH FACE','918105749450','','','PANDESHWARA','MANGALORE','','23','','PRAJWAL','919008000490','','HANUMAN LAYOUT','JALAHALLI VILLAGE','','11','560013','Document','100.00','0.00','0.00','0','Document','Surface','1','0.70','','','','','0.70','125.00','1','1','2025-11-04 18:01:11','2025-11-04 18:01:11','17617218175043','17617218175043','PRAJWAL SDOUZA','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1269','16','1','','4','41515314','2025-11-04','367','376','511','SRI GOKARNANATH CO-OPERATIVE BANK LIMITED(KAI)','','','','1ST FLOOR, 8-2-138/110, SRI GURUKRIPA, SRI GOKARNANATH TEMPLE ROAD, KUDROLI, Dakshina Kannada,  575003','','29AAAAS5647N1ZU','11','575028','SRI GOKARNATHA CO-P BANK','','','KUDROLI','MANGALORE','','11','575003','Document','100.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','19.00','1','1','2025-11-04 18:01:26','2025-12-18 18:19:34','17617177578387','17617177578387','','3453','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','1','1','2025-12-18 18:19:34','','received','','','1','17645844402769');
INSERT INTO `booking` VALUES ('1270','8','1','','4','41616364','2025-11-04','388','397','1269','CANARA LIGHTING','','','','MULKI KINNIGOLI, AIRPORT ROAD, MANGALORE, Dakshina Kannada,  574150','','29AAACC6921B1Z0','11','574150','RUBAN','919442291395','','KARUNYA  INSTITUE','KARUNYA NAGAR','','23','641114','Document','10.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','32.00','1','1','2025-11-04 18:02:31','2025-12-13 16:58:25','17617178859109','17617178859109','','535','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','1','0','','','','','','1','');
INSERT INTO `booking` VALUES ('1271','13','1','','2','3404120','2025-11-04','','5561','1270','ROYAL ENT','919945484595','','','CARST','','','11','575001','ICICI BANK','917760599020','','MAIN ROAD','','','11','576104','Document','10.00','0.00','0.00','0','Document','Surface','1','0.05','','','','','0.05','50.00','1','1','2025-11-04 18:02:45','2025-11-04 18:02:45','17617147018423','17617147018423','','1639','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1272','20','1','','2','3418101','2025-11-04','','5562','1271','BABACHANDRA','919481578703','','','KODIALBAIL MANGALORE','','','11','575001','KAMLESH G','919911773688','','SMC GLOBAL SEC LTD','NEAR PURAVANKARA HDFC BANK','','11','560042','Document','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-04 18:02:54','2025-11-04 18:02:54','17616388667516','17616388667516','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1273','16','1','','4','41515315','2025-11-04','334','343','511','CANARA BANK VAMANJOOR','','','','5th Floor, 112, Canara Bank Head Office, JC Road, Town Hall Junction, Nagartapete, Bengaluru, Bengaluru Urban,  560002','','29AAACC6106G1ZX','11','','CANARA BANK','','','HUDSON CIRCLE','BANGALORE','','11','560001','Document','100.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','18.00','1','1','2025-11-04 18:03:06','2025-12-18 18:12:32','17617177578387','17617229594029','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','1','1','2025-12-18 18:12:32','','received','','','1','17645844402769');
INSERT INTO `booking` VALUES ('1274','23','1','','2','3408580','2025-11-04','','5507','1272','YOUTH FACE','918105749450','','','PANDESHWARA','MANGALORE','','23','','SELCIYA','919677969420','','THARUVAKULAM','00','','23','628105','Document','100.00','0.00','0.00','0','Document','Surface','1','1.00','','','','','1.00','160.00','1','1','2025-11-04 18:03:09','2025-11-04 18:03:09','17617218175043','17617218175043','KAMRAJ NAGAR','2549','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1275','17','1','','2','3404711','2025-11-04','','5563','1273','BHIMA GOLD PVT LTD','918242981111','','','BENDOOR','MANGALORE','','11','575002','RAJA RAO','918245301013','','KORAMNGALA','','','11','560034','Document','0.01','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-04 18:03:48','2025-11-04 18:03:48','17617216042295','17617216042295','BHIMA GOLD PVT LTD','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1276','22','1','','2','3411106','2025-11-04','','5564','1274','NAVEEN PRAKASH SOANS','918050356065','','','SHIVBAGH','MANGALURU','','11','575005','HETERO HEALTHCARE LTD','919226849337','','A202  DIPTI CLASSIC','ANDHERI EAST','','14','400093','Document','100.00','0.00','0.00','0','Document','Surface','1','0.05','','','','','0.05','100.00','1','1','2025-11-04 18:04:10','2025-11-04 18:04:10','17617169725275','17617169725275','','57','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1277','25','1','','2','3388878','2025-11-04','','5565','1275','M HANEEF','919880303931','','','KANA SURATHKAL','','','11','575014','K P POCKER','919447120417','','LAILA BUILDING EAST','NADAKKAV KOZIKODE','','12','673008','Document','100.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','70.00','1','1','2025-11-04 18:04:19','2025-11-04 18:04:19','17617202587270','17617202587270','','161','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1278','8','1','','4','41616365','2025-11-04','425','434','511','S C D C C BANK DAMASKATTE','','','','ANNAPOORNESHWARI AIKALA POST DAMASKATTE','','29AABAT6621N2ZZ','11','574142','SCDCC BANK','','','HO','KBL MANGALORE','','11','575001','Document','10.00','0.00','0.00','0','Document','Surface','1','0.21','','','','','0.21','14.70','1','1','2025-11-04 18:04:26','2025-12-22 13:12:47','17617178859109','17617178859109','','3453','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','1','0','','','','','','1','');
INSERT INTO `booking` VALUES ('1279','14','1','','2','3364688','2025-11-04','','5524','1208','BHARATH BANK','918242421076','','','CLASSIQUE ARCADE','HAMPANKATTA','','11','575001','BHARATH BANK CO OP BANK','918242421076','','MULTI STATE SCHEDULED BANK','VEENU SKY PLAZA','','11','574227','Document','0.00','0.00','0.00','0','Document','Surface','1','0.10','','','','','0.10','65.00','1','1','2025-11-04 18:04:28','2025-11-04 18:04:28','17617209872567','17617209872567','','1068','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1280','13','1','','2','3404121','2025-11-04','','5512','1276','ROYAL ENT','917760202626','','','CARST MLR','','','11','575001','ICICI BANK','919271850559','','OPP TALUK OFFICE','','','11','576101','Document','10.00','0.00','0.00','0','Document','Surface','1','0.05','','','','','0.05','50.00','1','1','2025-11-04 18:04:41','2025-11-04 18:04:41','17617147018423','17617147018423','','1639','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1281','23','1','','2','3408581','2025-11-04','','5507','1277','YOUTH FACE','918105749450','','','PANDESHWARA','MANGALORE','','23','','THOUSIF','917760540725','','PRAKASH NAGAR','00','','11','560021','Document','100.00','0.00','0.00','0','Document','Surface','1','0.60','','','','','0.60','125.00','1','1','2025-11-04 18:06:08','2025-11-04 18:06:08','17617218175043','17617218175043','ROYALE AURA INN','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1282','20','1','','2','3418102','2025-11-04','','5566','1278','HARISH KAMATH','919036652737','','','KODIALBAIL','MANGALORE','','11','575001','USMAN','919632957779','','ESTEEM ELEVATORS GOLDEN PLAZA','OLD BANK ROAD LIC COLONY','','11','574106','Document','0.00','0.00','0.00','0','Document','Surface','1','0.45','','','','','0.45','85.00','1','1','2025-11-04 18:06:23','2025-11-04 18:06:23','17616388667516','17616388667516','','1639','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1283','17','1','','2','3404712','2025-11-04','','4980','511','S C S HOSPITAL PVT LTD','918242881100','','','UPPER BENDOOR','MANGALORE','','11','','MEDI ASSIT INDIA PVT LTD','','','HOSUR MAIN ROAD','','','11','560068','Document','0.00','0.00','0.00','0','Document','Surface','1','0.14','','','','','0.14','90.00','1','1','2025-11-04 18:06:28','2025-11-04 18:06:28','17617216042295','17617216042295','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1284','8','1','','4','41616366','2025-11-04','397','406','511','INDIAN OIL CORPORATION  LTD  BAJPE(VENDERCODE-10117164)','','','','No-29, INDIAN OIL BHAVAN, P.KALINGA RAO ROAD, MISSION ROAD, Bengaluru Urban, 560027','','29AAACI1681G1ZL','11','574142','ADITHYA NAMDEV','','','IOCL','BANGALORE','','11','560063','Document','10.00','0.00','0.00','0','Document','Surface','1','1.49','','','','','1.49','171.00','1','1','2025-11-04 18:07:02','2025-12-13 16:58:26','17617178859109','17617178859109','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','1','0','','','','','','1','');
INSERT INTO `booking` VALUES ('1285','23','1','','2','3408582','2025-11-04','','5507','1279','YOUTH FACE','918105749450','','','PANDESHWARA','MANGALORE','','23','','SHAMA AFREEN','919680896714','','NEAR PLANTING MACHINE','00','','11','571101','Document','100.00','0.00','0.00','0','Document','Surface','1','0.75','','','','','0.75','125.00','1','1','2025-11-04 18:07:49','2025-11-04 18:07:49','17617218175043','17617218175043','J P NAGAR','995','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1286','13','1','','2','3404122','2025-11-04','','5561','1280','ROYAL ENT','919945484595','','','CARST','','','11','575001','OCEAN PEARL HOTEL PVT LTD','919900089455','','UDUPI MANIPAL ROAD','KALSANKA','','11','576101','Document','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','50.00','1','1','2025-11-04 18:07:55','2025-11-04 18:07:55','17617147018423','17617147018423','','1639','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1287','10','1','','2','3406805','2025-11-04','','5567','1281','CITY ENTERPRISES','919741159218','','','NEERMARGA','MANGALORE','','11','575004','SHAIK JAKEER','919966074127','','PANASONIC LIFE SOLUTIONS','LONG FORD ROAD','','11','560025','Document','10.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-04 18:08:01','2025-11-04 18:08:01','17617151801089','17617151801089','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1288','22','1','','2','3411107','2025-11-04','','5568','1282','NAGABHUSHAN','919448177653','','','KADRI SHIVBAGH','MANGALURU','','11','575002','MADHUSUDANA K A','918277024099','','KANTHI NIVASA','GOPALA','','11','577205','Document','100.00','0.00','0.00','0','Document','Surface','1','0.05','','','','','0.05','60.00','1','1','2025-11-04 18:08:15','2025-11-04 18:08:15','17617169725275','17617169725275','','1829','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1289','8','1','','4','41616367','2025-11-04','412','421','511','M C C BANK KINNIGOLI','','','','14-6-685,686, MCC Bank Building, ST.ALOYSIUS COLLEGE ROAD, Hampankatta, Mangalore, Dakshina Kannada,  575001','','29AAAAT5268Q1ZM','11','574150','M C C BANK','','','A O','MANGALORE','','11','575001','Document','10.00','0.00','0.00','0','Document','Surface','1','0.10','','','','','0.10','25.00','1','1','2025-11-04 18:08:28','2025-12-18 18:45:03','17617178859109','17617178859109','','3453','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','1','1','2025-12-18 18:45:03','','received','','','1','17645844402769');
INSERT INTO `booking` VALUES ('1290','20','1','','2','3418103','2025-11-04','','5566','1283','HARISH KAMATH','919036652737','','','KODIALBAIL','MANGALORE','','11','575001','THE ADMINISTATOR','919902009289','','SRI SRINGERI MATH','SRINGERI','','11','577139','Document','0.00','0.00','0.00','0','Document','Surface','1','0.37','','','','','0.37','105.00','1','1','2025-11-04 18:08:39','2025-11-04 18:08:39','17616388667516','17616388667516','','1829','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1291','17','1','','2','3404713','2025-11-04','','4980','1284','S C S HOSPITAL PVT LTD','918242881100','','','UPPER BENDOOR','MANGALORE','','11','','PARAMOUNT HEALTH INS TPA','912240004213','','ANDHERI','','','14','400059','Document','0.00','0.00','0.00','0','Document','Surface','1','0.19','','','','','0.19','130.00','1','1','2025-11-04 18:08:40','2025-11-04 18:08:40','17617216042295','17617216042295','','57','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1292','14','1','','2','3364689','2025-11-04','','5569','1285','HIMALAYA WELNESS CO','918242443887','','','ROYAL UTILITY TOWERS K S RAO RD','MANGALORE','','11','575001','MANJUNATH','919741816343','','HMALAYA WELNESS CO','NO 861 SATELITE TOWN  KENGERI','','11','560060','Document','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-04 18:08:43','2025-11-04 18:08:43','17617209872567','17617209872567','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1293','20','1','','2','3418104','2025-11-04','','5566','1286','HARISH KAMATH','919036652737','','','KODIALBAIL','MANGALORE','','11','575001','RAGHUNATHAN','919448129688','','RAJAJINAGAR','','','11','560023','Document','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-04 18:09:41','2025-11-04 18:09:41','17616388667516','17616388667516','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1294','9','1','','2','3283700','2025-11-04','','5570','1287','GANESH K','919343569129','','','FLAT NO .101, BENCO APARTMENT','CHILIMBI NEAR SHIRDI SAI BABA','','11','575006','SACHIN ADITHYA RAMESH','919008692678','','AP11, BRAHMAGUPTA BUILDING','TIFR RESIDENTIAL COMPLEX','','14','400005','Books','2000.00','0.00','0.00','0','Parcel','Surface','1','2.00','','','','','2.00','610.00','1','1','2025-11-04 18:09:49','2025-11-04 18:09:49','17617248601364','17617248601364','','57','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1295','8','1','','4','41616368','2025-11-04','413','422','511','M.C.C BANK BAJPE','','','','BAJPE','','29AAAAT5268Q1ZM','11','574142','M C C BANK','','','A O','MANGALORE','','11','575001','Document','10.00','0.00','0.00','0','Document','Surface','1','0.05','','','','','0.05','25.00','1','1','2025-11-04 18:09:53','2025-12-13 16:58:26','17617178859109','17617178859109','','3453','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','1','0','','','','','','1','');
INSERT INTO `booking` VALUES ('1296','23','1','','2','3408583','2025-11-04','','5507','1288','YOUTH FACE','918105749450','','','PANDESHWARA','MANGALORE','','23','','UNAIS','917025039386','','OUDH GALLERY','FORUM MALL','','12','679576','Document','100.00','0.00','0.00','0','Document','Surface','1','2.10','','','','','2.10','400.00','1','1','2025-11-04 18:10:01','2025-11-04 18:10:01','17617218175043','17617218175043','','284','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1297','10','1','','2','3406806','2025-11-04','','5571','1289','JOEL MENEZES','919743554396','','','AIRPORT ROAD','MARYHILL','','11','575008','SANTOSH PAI','919562253417','','HONDA MATRIX','NEAR SBI BANK','','11','574214','Document','10.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','50.00','1','1','2025-11-04 18:11:17','2025-11-04 18:11:17','17617151801089','17617151801089','','2580','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1298','8','1','','4','41616369','2025-11-04','435','444','511','STATE BANK OF INDIA  KINNIGOLI','','','','65, State Bank of India, Local Head Office, St. Marks Road, Bengaluru, Bengaluru Urban,  560001','','29AAACS8577K3ZJ','11','574150','S B I','','','SMEC BEJAI','MANGALORE','','11','575001','Document','10.00','0.00','0.00','0','Document','Surface','1','0.05','','','','','0.05','9.00','1','1','2025-11-04 18:11:18','2025-12-13 16:58:26','17617178859109','17617178859109','','3453','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','1','0','','','','','','1','');
INSERT INTO `booking` VALUES ('1299','20','1','','2','3418105','2025-11-04','','4905','1290','PRASHANTH','919738287177','','','KODIALBAIL','','','11','575003','GANESH SHRIYAN','917738389232','','NEXT TO ARACDE BUILDING','MIRA ROAD','','14','401107','Parcel','2420.00','0.00','0.00','0','Document','Surface','1','0.65','','','','','0.65','230.00','1','1','2025-11-04 18:12:03','2025-11-04 18:12:03','17616388667516','17616388667516','','57','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1300','23','1','','2','3408584','2025-11-04','','5507','1291','YOUTH FACE','918105749450','','','PANDESHWARA','MANGALORE','','23','','MOHAMMED SHAMINI','917204576458','','MAIMUNA BUILD','MAIN ROAD','00','11','581301','Document','100.00','0.00','0.00','0','Document','Surface','1','1.40','','','','','1.40','247.00','1','1','2025-11-04 18:12:12','2025-11-04 18:12:12','17617218175043','17617218175043','','296','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1301','8','1','','4','41616370','2025-11-04','388','397','1292','CANARA LIGHTING','','','','MULKI KINNIGOLI, AIRPORT ROAD, MANGALORE, Dakshina Kannada,  574150','','29AAACC6921B1Z0','11','574150','VISHNU SHARMA','918750067141','','CANARA LIGHTING','BSI BUSINESS PARK','','26','201301','Document','10.00','0.00','0.00','0','Document','Surface','1','0.05','','','','','0.05','46.00','1','1','2025-11-04 18:13:14','2025-12-13 16:58:26','17617178859109','17617178859109','','226','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','1','0','','','','','','1','');
INSERT INTO `booking` VALUES ('1302','13','1','','2','3404123','2025-11-04','','5572','1293','V CARE SYSTEMS','919448249725','','','CARSTREET','MANGALORE','','11','575001','PREMIER SYSTEM','919686388944','','PAMPA MAHAKAVI ROAD','SHANKARAPURA M','','11','560004','Document','0.00','0.00','0.00','0','Document','Surface','1','0.46','','','','','0.46','105.00','1','1','2025-11-04 18:13:40','2025-11-04 18:13:40','17617147018423','17617147018423','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1303','23','1','','2','3408585','2025-11-04','','5507','1294','YOUTH FACE','918105749450','','','PANDESHWARA','MANGALORE','','23','','MUSTHAFA ANGADI','918792492771','','GANDHI NAGAR','RAILWAY LINE','','11','581325','Document','100.00','0.00','0.00','0','Document','Surface','1','1.50','','','','','1.50','247.00','1','1','2025-11-04 18:13:43','2025-11-04 18:13:43','17617218175043','17617218175043','','390','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1304','12','1','','2','3382956','2025-11-04','','5573','1295','BRILANT IT SOLUTION P LTD','917799406543','','','BRILYANT IT SOLUTION P LTD','CBI COLONY HYDERBAD','','23','500081','CHTHAN NAIK','919483803653','','NR MAHALINGESHWARA TEMPLE PALLI','PALLI','','11','574244','Document','3255.00','0.00','0.00','0','Document','Surface','1','1.26','','','','','1.26','175.00','1','1','2025-11-04 18:13:45','2025-11-04 18:28:24','17617206505387','17617206505387','MOODUKALLAPU MANE PALLI POST','75','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1305','22','1','','2','3411108','2025-11-04','','5574','1296','I NEEDS OPTICALS','917892887713','','','KADRI','MANGALURU','','11','575002','SHIVANAD','919886660452','','L901 RAJ LAKE VIEW','29TH MAIN 2N D STAGE','','11','560076','Document','100.00','0.00','0.00','0','Document','Surface','1','0.15','','','','','0.15','85.00','1','1','2025-11-04 18:13:56','2025-11-04 18:13:56','17617169725275','17617169725275','','1036','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1306','20','1','','2','3418106','2025-11-04','','5575','1297','MOHAN KUMAR','918762306384','','','KODIALBAIL','KODIALBAIL MANGALORE','','11','575001','SAVI FOOTWEAR','917892836405','','UNION BANK ROAD','UPPINANGADY','','11','574241','Document','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','50.00','1','1','2025-11-04 18:14:01','2025-11-04 18:14:01','17616388667516','17616388667516','','2352','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1307','24','1','','2','3399499','2025-11-04','','4859','1298','DR AGARWAL EYE HOSPITAL','918884008562','','','PUMPWELL','MANGALORE','','11','575002','THE INDIANA HOSPITAL SUPPLIES CO','919841081814','','NOWROJI ROAD','CHETPET CHENNAI','','23','600031','Parcel','0.00','0.00','0.00','0','Document','Surface','1','0.28','','','','','0.28','120.00','1','1','2025-11-04 18:14:36','2025-11-04 18:14:36','17617227711727','17617227711727','','1931','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1308','25','1','','2','3388879','2025-11-04','','5576','1299','PAWAN TRT','919008371354','','','NR VENUS HOSPITAL','SURATHKAL','','11','575014','ANNA BULK CARRIERS','912228117008','','GUPTA ARCADE','MAYAPURI NEW DELHI','','32','110064','Document','100.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','100.00','1','1','2025-11-04 18:14:43','2025-11-04 18:14:43','17617202587270','17617202587270','','1995','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1309','20','1','','2','3418107','2025-11-04','','5028','1300','ANEEZ','919164402530','','','JYOTHI','MANGALORE','','11','575001','SRI PRASAD K S','919448441442','','BELTHANGADY','','','11','574214','Document','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','50.00','1','1','2025-11-04 18:15:32','2025-11-04 18:15:32','17616388667516','17616388667516','','2580','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1310','23','1','','2','3408586','2025-11-04','','5507','1301','YOUTH FACE','918105749450','','','PANDESHWARA','MANGALORE','','23','','NUSARATH','917397028793','','NEAR M S COVERING','M C','','23','614701','Document','100.00','0.00','0.00','0','Document','Surface','1','2.10','','','','','2.10','400.00','1','1','2025-11-04 18:16:11','2025-11-04 18:16:11','17617218175043','17617218175043','EAST STREET','1854','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1311','8','1','','2','3351505','2025-11-04','','5048','1302','SANDEEP S AMIN','','','','KALLODI','BAJPE','','11','574142','RABIYA','919945865124','','MANGALORE','MR BHAT LANR','','11','575001','Document','10.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','35.00','1','1','2025-11-04 18:16:15','2025-11-26 15:56:16','17617178859109','17617178859109','JEPPU','3453','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1312','20','1','','2','3418108','2025-11-04','','5577','1303','D K TPT AND LOG','918904067498','','','NAGORI','','','11','575002','NANDANESHWAR ROADLINES','918904811376','','BAIKAMPADY','','','11','575011','Document','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','40.00','1','1','2025-11-04 18:17:28','2025-11-04 18:17:28','17616388667516','17616388667516','','3453','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1313','14','1','','2','3364690','2025-11-04','','5578','1304','ESSAM ENTERPRISES','918242440199','','','CLASSIC ARACADE','K S RAO RD MANGALORE','','11','575001','HDFC BANK LTD','918242440200','','CMS GOI BONDS 2 ND FLOOR GKS TECHNOLOGY PARK NO 94','SP ESTATE BUS STAND MAIN ROAD','','23','600058','Document','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','70.00','1','1','2025-11-04 18:17:36','2025-11-04 18:17:36','17617209872567','17617209872567','','1931','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1314','22','1','','2','3411109','2025-11-04','','5579','1305','CONFIDENT DENTAL LAB','918546802623','','','BALMATTA','MANGALURU','','11','575001','DR PADMA PRIYA','919448253991','','MAIN ROAD','','','11','574241','Document','300.00','0.00','0.00','1','Document','Surface','1','0.40','','','','','0.40','85.00','1','1','2025-11-04 18:17:43','2025-11-04 18:17:43','17617169725275','17617169725275','','2352','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1315','24','1','','2','3399500','2025-11-04','','5580','259','SHAKTHI LIFE LINE','918431904164','','','KANKANADY','MANGALORE','','11','575002','DR RASHMI','919880570058','','VIDHYANAGR','SHIMOGA','','11','577201','Parcel','0.00','0.00','0.00','0','Document','Surface','1','1.50','','','','','1.50','250.00','1','1','2025-11-04 18:17:57','2025-11-04 18:17:57','17617227711727','17617227711727','','1829','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1316','23','1','','2','3408587','2025-11-04','','5507','1306','YOUTH FACE','918105749450','','','PANDESHWARA','MANGALORE','','23','','ANIL NAYAK','918073350373','','KUDUVATHI VILLAGE','00','','11','562103','Document','100.00','0.00','0.00','0','Document','Surface','1','4.85','','','','','4.85','891.00','1','1','2025-11-04 18:18:11','2025-11-04 18:18:11','17617218175043','17617218175043','','90','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1317','8','1','','2','3351506','2025-11-04','','5581','1307','SHIFALI OPTICALS','919845213545','','','MAIN RD','KINNIGOLI','','11','574150','RAO ASSOCIATES','918722155558','','KADRI ROAD','MANGALORE','','11','575002','Document','10.00','0.00','0.00','0','Document','Surface','1','0.21','','','','','0.21','65.00','1','1','2025-11-04 18:19:24','2025-11-26 15:56:16','17617178859109','17617178859109','','3453','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1318','25','1','','2','3388880','2025-11-04','','5576','1308','PAWAN TRT','919008371354','','','NR VENUS HOSPITAL','SURATHKAL','','11','575014','CARDOLITE SPECIALITY','918242888316','','PAILA BAJPE','BAJPE','','11','574142','Document','100.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','50.00','1','1','2025-11-04 18:19:25','2025-11-26 15:56:16','17617202587270','17617202587270','','3453','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1319','16','1','','2','3357239','2025-11-04','','5582','1309','MOHD ASHWAR','917624838733','','','KAIKAMBA','MANGALORE','','11','574151','ASHWIN HEGDE','919482851562','','BYPASS','URLANDY','','11','574201','Document','100.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','50.00','1','1','2025-11-04 18:19:31','2025-11-04 18:19:31','17617177578387','17617177578387','','1904','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1320','23','1','','2','3408588','2025-11-04','','5583','1310','CHETHAN KUMAR','919900311535','','','PANDESHWARA','','','23','','RAGHAVENDRA SHETTY','919008100193','','KATRIGUPPE VILLAGE','BSK 3RD STAGE','','11','560085','Document','100.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-04 18:19:54','2025-11-04 18:19:54','17617218175043','17617218175043','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1321','22','1','','2','3411110','2025-11-04','','5579','1311','CONFIDENT DENTAL LAB','918546802623','','','BALMATTA','MANGALURU','','11','575001','DR ANJANA BHAT','919902940582','','SOORYAMBAIL COMPLEX','NR ADITYA HOTEL','','11','574241','Document','100.00','0.00','0.00','0','Document','Surface','1','0.15','','','','','0.15','75.00','1','1','2025-11-04 18:19:58','2025-11-04 18:19:58','17617169725275','17617169725275','','2352','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1322','17','1','','2','3404714','2025-11-04','','5584','1312','NAYANCHANDRA','919845818462','','','MANGALORE','','','11','575002','VIMAL PARASHAR','919711337765','','ALLIED NIPPON PVT LTD','SHAIBAD','','26','201010','Document','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','100.00','1','1','2025-11-04 18:20:07','2025-11-04 18:20:07','17617216042295','17617216042295','','547','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1323','14','1','','2','3364691','2025-11-04','','5585','1313','HOTEL POONJA INTL','919980000796','','','K S RAO RD','MANGALORE','','11','575001','BSNL OFFICE','919901944588','','TELECOM HOUSE','TELECOM RD PANDESWAR','','11','575001','Document','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','35.00','1','1','2025-11-04 18:20:42','2025-11-04 18:20:42','17617209872567','17617209872567','','3453','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1324','18','1','','2','3385048','2025-11-04','','5586','1314','JACWAYS LOGISTICES LLP','917019658642','','','COMMERCE CENETRE KULUR','MANGALORE','','11','575013','WESTERN COFFEE COURERS AND EXPORTS','919108983194','','SADASHIVA NAGAR BANGALORE','','','11','560080','Document','10.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-04 18:20:53','2025-11-04 18:20:53','17621531273939','17621531273939','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1325','24','1','','2','3399501','2025-11-04','','5587','1315','RADIANT ROOTS','919606013845','','','KANKANADY','MANGALORE','','11','575002','ANIL PAVAGADA','919148671930','','SHANTHI NAGAR','PAVAGADA','','11','561202','Parcel','0.00','0.00','0.00','0','Document','Surface','1','0.24','','','','','0.24','90.00','1','1','2025-11-04 18:21:02','2025-11-04 18:21:02','17617227711727','17617227711727','','2038','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1326','10','1','','2','3406807','2025-11-04','','5588','1316','JAI PRAKASH RAI','918242452175','','','PREMIER SECURITY SERVICES','LALBAGH MLR','','11','575003','SBI','919483172829','','RACE COURSE ROAD','MADIKERI','','11','571201','Document','50.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-04 18:21:32','2025-11-04 18:21:32','17617151801089','17617151801089','','332','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1327','8','1','','2','3351507','2025-11-04','','5589','1317','D SOUZA INVESTMENT','917411879546','','','TALIPADY VILLEGE','KINNIGOLI','','11','574150','NANDINI PSS LTD','918147845641','','AJAR POST','KATEEL','','11','574148','Document','10.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','50.00','1','1','2025-11-04 18:21:47','2025-11-04 18:21:47','17617178859109','17617178859109','','3226','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1328','25','1','','2','3388881','2025-11-04','','5590','1318','MAHALAXMI CO OP BANK','918618871896','','','MARIGUDI ROAD','SURATHKAL','','11','575014','MAHALAXMI CO OP BANK','918202522010','','KALMANJE TOWER','AJJARKAD UDUPI','','11','576101','Document','100.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','50.00','1','1','2025-11-04 18:22:26','2025-11-04 18:22:26','17617202587270','17617202587270','','1639','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1329','26','1','','2','3400894','2025-11-04','','5591','1319','THE BHARTH ACADAMY','919019005030','','','BLUE BERRY HILLS','YEYYADI RD','','11','575008','LOGIQDIS','919137675389','','NM JOSHI MARG','LOWER PAREL','','14','400013','Document','0.00','0.00','0.00','0','Document','Surface','1','2.25','','','','','2.25','690.00','1','1','2025-11-04 18:22:51','2025-11-04 18:22:51','17615707686074','17615707686074','','57','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1330','13','1','','2','3404124','2025-11-04','','5592','277','8242427309','918242427309','','','TARA HOSPITAL','GHS ROAD','','11','575001','BAJAJ ALLIANS INSU','918494900306','','BEHIND WIKFELD IT PARK','PUNE','','14','411014','Document','0.00','0.00','0.00','0','Document','Surface','1','0.21','','','','','0.21','130.00','1','1','2025-11-04 18:23:10','2025-11-04 18:23:10','17617147018423','17617147018423','','13','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1331','14','1','','2','3364692','2025-11-04','','5593','1320','S K H INDUSTRIES','919740030322','','','H O CLASIC ARACADE','K S RAO RD MANGALORE','','11','575001','MANGALORE GANESH BEEDI WORKS','918212420241','','HEAD OFFICE','VINOBA ROAD','','11','570005','Document','0.00','0.00','0.00','0','Document','Surface','1','0.08','','','','','0.08','75.00','1','1','2025-11-04 18:23:35','2025-11-04 18:23:35','17617209872567','17617209872567','','669','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1332','22','1','','2','3411111','2025-11-04','','5594','1321','CHANDRAKIRAN K Y','918242211395','','','KADRI','MANGALURU','','11','575002','PREETHA','919449840052','','SBI  CHIEF MANAGER','A O','','11','580020','Document','100.00','0.00','0.00','0','Document','Surface','1','0.15','','','','','0.15','85.00','1','1','2025-11-04 18:23:41','2025-11-04 18:23:41','17617169725275','17617169725275','','557','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1333','24','1','','2','3399502','2025-11-04','','5595','1322','INDIANA PHARMACY','919747083183','','','PUMPWELL','MANGALORE','','11','575002','SANTHOSH KUMAR','919495295566','','ERANHOLI PO','TELLICHERRY, KERALA','','12','670107','Document','0.00','0.00','0.00','0','Document','Surface','1','0.06','','','','','0.06','90.00','1','1','2025-11-04 18:24:11','2025-11-04 18:24:11','17617227711727','17617227711727','','276','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1334','8','1','','2','3351508','2025-11-04','','5596','1323','YUGAPURUSHA','918242295423','','','MAIN RD','KINNIGOLI','','11','574150','SHRIPATHI BHAT','919945260411','','GANDHINAGAR','MOODBIDRI','','11','574227','Document','1.00','0.00','0.00','0','Document','Surface','1','0.48','','','','','0.48','80.00','1','1','2025-11-04 18:24:13','2025-11-04 18:24:13','17617178859109','17617178859109','','1731','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1335','10','1','','2','3406808','2025-11-04','','5597','1324','GS HEGDE','919916387089','','','KARAVALI FITNESS MLR','SURATHKAL','','11','575014','SAWANTH','919930613073','','IIPS','DEONAR GOVANDI STATION ROAD','','14','400088','Document','50.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','100.00','1','1','2025-11-04 18:24:22','2025-11-04 18:24:22','17617151801089','17617151801089','','57','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1336','21','1','','2','3393125','2025-11-04','','5598','1325','LAKSHNESH SHETTY','919901719197','','','KOTTARA','MLR','','11','575006','BHAVITH KAMATH K','917760407785','','MARITHILANE','HARUSHCHANDRA RD','','11','576101','Document','100.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','50.00','1','1','2025-11-04 18:24:24','2025-11-04 18:24:24','17616388051318','17616388051318','','1639','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1337','20','1','','2','3418109','2025-11-04','','5599','1326','JYOTHI ELELCTRICALS','918660652455','','','JYOTHI BUIDL','MAIDAN RD','','11','575001','SIRAJIDDIN','919448713968','','HOTEL SWANA REGENCY','BM RD','','11','573201','Document','0.00','0.00','0.00','0','Document','Surface','1','0.15','','','','','0.15','85.00','1','1','2025-11-04 18:24:35','2025-11-04 18:24:35','17616388667516','17616388667516','','448','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1338','17','1','','2','3404715','2025-11-04','','5600','511','CHANDRASHEKAR HOLLA','919945062119','','','MANGALORE','','','11','575002','CHANDRASHEKAR PRABHU','','','LEGAL CONSULTANT','MADHAV NAGAR','','11','576104','Document','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','50.00','1','1','2025-11-04 18:24:41','2025-11-04 18:24:41','17617216042295','17617216042295','','662','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1339','13','1','','2','3404125','2025-11-04','','5592','277','8242427309','918242427309','','','TARA HOSPITAL','GHS ROAD','','11','575001','VOLO HEALTH INSU','918494900306','','SAKET METRO STATION','','','39','575011','Document','10.00','0.00','0.00','0','Document','Surface','1','0.26','','','','','0.26','170.00','1','1','2025-11-04 18:25:03','2025-11-04 18:25:03','17617147018423','17617147018423','','1995','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1340','23','1','','2','3408589','2025-11-04','','5601','1327','ZAKARIYA','919964538383','','','EXECL MISCHIEF MALL','MANGALORE','','23','','V V VIJAY KUMAR','919972033248','','VASUDEVARAHALLI','BHYARANAYAKANAHALLI','','11','572201','Document','100.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-04 18:25:29','2025-11-04 18:25:29','17617218175043','17617218175043','','1633','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1341','18','1','','2','3385049','2025-11-04','','5602','1328','SAMSHEED','918050589421','','','VIDYA NAGAR KULUR','MANGALORE','','11','575013','JOGI HARI KRISHNA','918790493422','','NEHARU NAGAR AMBIKA TIMBER','KASIBUGGA','','1','532222','Document','10.00','0.00','0.00','0','Document','Surface','1','2.24','','','','','2.24','400.00','1','1','2025-11-04 18:25:44','2025-11-04 18:25:44','17621531273939','17621531273939','','2045','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1342','25','1','','2','3388882','2025-11-04','','5603','1329','ADITHYA NITK','918660572593','','','SURATHKAL','MLR','','11','575014','C MANJUNATH','919482911678','','ASHOK NAGAR 2ND CROSS','SHIMOGA','','11','576001','Document','100.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-04 18:25:50','2025-11-04 18:25:50','17617202587270','17617202587270','','1829','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1343','8','1','','2','3351509','2025-11-04','','5604','1330','ND SONS ENGINEERS PVT LTD','918971020996','','','BAIKAMPADY','MANGALORE','','23','','UMESH ACHARYA','919663698628','','ANEKAL TALUK','BANGALORE','','11','560099','Document','1.00','0.00','0.00','0','Document','Surface','1','0.10','','','','','0.10','75.00','1','1','2025-11-04 18:26:07','2025-11-04 18:26:07','17617178859109','17617178859109','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1344','10','1','','2','3406809','2025-11-04','','5205','1331','EAGLEEYE MANPOWER SOL','917411612195','','','BEJAI','MLR','','11','575004','BG RANGANATH','919243307941','','CAMPCO CHOCALATE FACTORY','KEMMINJE DARBE','','11','574202','Document','50.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','50.00','1','1','2025-11-04 18:26:33','2025-11-04 18:26:33','17617151801089','17617151801089','','1904','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1345','22','1','','2','3411112','2025-11-04','','5605','1332','NEW HIMLAYA ROADLINES','919880277995','','','NANTHOOR','MANGALURU','','11','575004','TCI FREIGHT LTD','919341018592','','BAIKAMPADY','MANGALURU','','11','575011','Document','100.00','0.00','0.00','0','Document','Surface','1','0.05','','','','','0.05','35.00','1','1','2025-11-04 18:27:11','2025-11-04 18:27:11','17617169725275','17617169725275','','3453','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1346','23','1','','2','3408590','2025-11-04','','5601','1333','ZAKARIYA','919964538383','','','EXECL MISCHIEF MALL','MANGALORE','','23','','RAVI KUMAR','917676771344','','3RD CROSS','00','','11','580001','Document','100.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-04 18:27:12','2025-11-04 18:27:12','17617218175043','17617218175043','JAYANAGAR','379','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1347','14','1','','2','3364693','2025-11-04','','5606','1334','ESSAM ENT','918242440200','','','K S RAO RD','MANGALORE','','11','575001','P VENKATRAMA & JAYASHREE','916263027707','','F 206 SAI SREENIVASA HOMES APT','ELECTRONIC CITY','','11','560100','Document','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-04 18:27:41','2025-11-04 18:27:41','17617209872567','17617209872567','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1348','17','1','','2','3404716','2025-11-04','','5600','1335','CHANDRASHEKAR HOLLA','919945062119','','','MANGALORE','','','11','575002','ACDEMY OF LIBRAL EDUCATION','919945062118','','KURUNJI BAGH','','','11','574327','Document','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','50.00','1','1','2025-11-04 18:28:31','2025-11-04 18:28:31','17617216042295','17617216042295','','2577','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1349','23','1','','2','3408591','2025-11-04','','5601','1336','ZAKARIYA','919964538383','','','EXECL MISCHIEF MALL','MANGALORE','','23','','MANJUNATH VALE','917899097829','','SURANAGADDE','00','','11','577401','Document','100.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-04 18:28:41','2025-11-04 18:28:41','17617218175043','17617218175043','BIN VALLE ARJUNA','2052','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1350','22','1','','2','3411113','2025-11-04','','5605','1337','NEW HIMLAYA ROADLINES','919880277995','','','NANTHOOR','MANGALURU','','11','575004','PRAKASH PARECL SERVICES','919880519631','','BRAHMAVRA','UDUPI','','11','576213','Document','100.00','0.00','0.00','0','Document','Surface','1','0.05','','','','','0.05','50.00','1','1','2025-11-04 18:28:50','2025-11-04 18:28:50','17617169725275','17617169725275','','1639','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1351','25','1','','2','3388883','2025-11-04','','5607','1338','SAKTHIVEL','919611098851','','','FIVE STAR','SKL','','11','575014','SRI TRT','919443131897','','BHARATHI COMPLEX','VALLUVAR NAMAKKAL','','23','637001','Document','100.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','70.00','1','1','2025-11-04 18:28:58','2025-11-04 18:28:58','17617202587270','17617202587270','','2424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1352','13','1','','2','3404126','2025-11-04','','4814','277','TARA HOSPITAL','918494900306','','','CARST','MANGALORE','','43','575001','THE CLAI DEPT','918494900306','','VIPUL TECH SQUARE','','','43','575011','Document','10.00','0.00','0.00','0','Document','Surface','1','0.57','','','','','0.57','230.00','1','1','2025-11-04 18:29:06','2025-11-04 18:29:06','17617147018423','17617147018423','','5','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1353','8','1','','2','3351510','2025-11-04','','5608','1339','JEEVITH K M','918904605830','','','ADANI AVIATION FUEL SER LTD','BAJPE','','11','574142','DHAYANITHI S','918072036017','','INDIAN OIL SKY TANKING','DEVANHALLI','','11','560300','Document','1.00','0.00','0.00','0','Document','Surface','1','0.21','','','','','0.21','85.00','1','1','2025-11-04 18:29:38','2025-11-04 18:29:38','17617178859109','17617178859109','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1354','10','1','','2','3406810','2025-11-04','','5205','1340','EAGLEEYE MANPOWER SOL','917411612195','','','BEJAI','MLR','','11','575004','SIRI SAMRUDDHI GOLD PALACE','918047054099','','YELAHANKA NEW TOWN','BANGALORE','','11','560064','Document','50.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-04 18:29:42','2025-11-04 18:29:42','17617151801089','17617151801089','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1355','17','1','','2','3404717','2025-11-04','','5600','511','CHANDRASHEKAR HOLLA','919945062119','','','MANGALORE','','','11','575002','A J HOSPITAL','','','KUNTIKANA','MANGALORE','','11','575004','Document','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','35.00','1','1','2025-11-04 18:30:03','2025-11-26 15:56:16','17617216042295','17617216042295','','3453','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1356','23','1','','2','3408592','2025-11-04','','5601','1341','ZAKARIYA','919964538383','','','EXECL MISCHIEF MALL','MANGALORE','','23','','DHANUSH','919353728148','','LIG SITE','NIRAVARI ILAKHE','','11','571124','Document','100.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-04 18:30:57','2025-11-04 18:30:57','17617218175043','17617218175043','','855','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1357','22','1','','2','3411114','2025-11-04','','5609','1342','SHAREEN  DSOUZA','919845170074','','','402 DAFFODIL BENDOOR','MANGALURU','','11','575002','ADITYA SINGH','918197422285','','8102 OMARA PRESTIGE  MONTE CARLO','YELAHANKA','','11','560064','Document','100.00','0.00','0.00','0','Document','Surface','1','0.15','','','','','0.15','85.00','1','1','2025-11-04 18:31:18','2025-11-04 18:31:18','17617169725275','17617169725275','','1036','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1358','10','1','','2','3406811','2025-11-04','','5205','1343','EAGLEEYE MANPOWER SOL','917411612195','','','BEJAI','MLR','','11','575004','KAL RADIO LTD','917411689632','','JAYALAXMI VILAS ROAD','CHAMARAJAPURAM','','11','570005','Document','50.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-04 18:31:22','2025-11-04 18:31:22','17617151801089','17617151801089','','669','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1359','13','1','','2','3404127','2025-11-04','','5592','277','8242427309','918242427309','','','TARA HOSPITAL','GHS ROAD','','11','575001','VIDAL HEALTH INSU','918494900306','','EPIP ZONE','WHITEFILED','','11','575011','Document','10.00','0.00','0.00','0','Document','Surface','1','0.12','','','','','0.12','85.00','1','1','2025-11-04 18:31:30','2025-11-04 18:31:30','17617147018423','17617147018423','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1360','14','1','','2','3364694','2025-11-04','','4901','1344','CROWN RUBBERSTAMP LTD','919964697480','','','SOUZA RACADE','BALMATA ROAD','','11','575001','THE PRINCIPAL','919740569138','','MADANTHYAR','SACRED HEART COLLEGE','','11','574224','Document','0.00','0.00','0.00','0','Document','Surface','1','0.05','','','','','0.05','50.00','1','1','2025-11-04 18:31:35','2025-11-04 18:31:35','17617209872567','17617209872567','','851','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1361','26','1','','2','3400895','2025-11-04','','5610','1345','VIYADDRONY TECHNLOGY','917573093336','','','NADIKUDRU','UDUPI','','11','574103','CA KARTHIK HEGDE','919844901879','','VINUTHAVISTA','NAGARBHAVI MAIN RD','','11','560072','Document','0.00','0.00','0.00','0','Document','Surface','1','0.35','','','','','0.35','105.00','1','1','2025-11-04 18:31:47','2025-11-04 18:31:47','17615707686074','17615707686074','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1362','25','1','','2','3388884','2025-11-04','','5092','1346','UMESH','918971037269','','','SKL','SKL','','11','575014','SANKARI ROADWAYS','919865997711','','EBENEZER COLONY','SALEM','','23','637301','Document','100.00','0.00','0.00','0','Document','Surface','1','0.10','','','','','0.10','85.00','1','1','2025-11-04 18:31:54','2025-11-04 18:31:54','17617202587270','17617202587270','','1815','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1363','24','1','','2','3399498','2025-11-04','','5425','1347','BRIJESH RAI','919740060633','','','PUMPWELL','MANGALORE','','11','575002','VIVEKA G R','918904647168','','V R E.T.C','BALLARE SULLIA','','11','574212','Document','10.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','50.00','1','1','2025-11-04 18:32:19','2025-11-04 18:32:19','17617227102844','17617227102844','','2577','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1364','8','1','','2','3351511','2025-11-04','','5611','1348','USHA','918748870879','','','KATEEL V S S','KATEEL','','11','574142','KOUSHIK G','919880220899','','GUNAVANTE RD','KOPPA','','11','577126','Document','1.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-04 18:32:52','2025-11-04 18:32:52','17617178859109','17617178859109','','859','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1365','21','1','','2','3393126','2025-11-04','','5612','1349','ADAIKKALAVAN','919884609158','','','PM MRPL','TANNIRBHAVI','','11','575010','SANTHOSH KUMAR A','910446123220','','VA TECH','200 FEET RD','','23','600117','Document','100.00','0.00','0.00','0','Document','Surface','1','0.26','','','','','0.26','120.00','1','1','2025-11-04 18:33:05','2025-11-04 18:33:05','17616388051318','17616388051318','','1931','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1366','23','1','','2','3408593','2025-11-04','','5601','1350','ZAKARIYA','919964538383','','','EXECL MISCHIEF MALL','MANGALORE','','23','','SUBHASH','919845802757','','SUNNADA BEEDHI','BETADAPURA VILLAGE','PRIRIYAPATNA','11','571102','Document','100.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-04 18:33:29','2025-11-04 18:33:29','17617218175043','17617218175043','','669','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1367','20','1','','2','3418110','2025-11-04','','5613','1351','BHAVANA KAMATH','919972570655','','','ATTAVARA SUB DIV','ATTAVARA','','11','575001','CORP SERVICES PLTD','918023183399','','3RD MAIN RD GNANAJYOTHI NAGAR','RING RD','','11','560056','Document','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-04 18:34:05','2025-11-04 18:34:05','17617138462770','17617138462770','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1368','12','1','','2','3382957','2025-11-04','','5614','1352','DR SUHEL SINGH','919935204060','','','43 SINGAPURA LAYOUT','3RD CROSS VIDYANYAPURA BNAGALORE','','11','560097','AYUSH YADAV','917522002210','','ROOM NO209 SANKALP HOSTEL','KESHEMA CAMPUS KS HEGDE MEDICAL ACAFEMY DERLAKATTE','','11','575018','Document','0.00','0.00','0.00','0','Document','Surface','1','4.10','','','','','4.10','700.00','1','1','2025-11-04 18:34:16','2025-11-04 18:34:16','17617206505387','17617206505387','','3453','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1369','25','1','','2','3388885','2025-11-04','','5615','1353','N R TRT','918147726903','','','KANA','KANA MANGLORE','','11','575014','NEW OLOG LOGISTICS','916380968657','','YESHWANTHPUR','BANGLORE','','11','560020','Document','10.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-04 18:34:32','2025-11-04 18:34:32','17617202587270','17617202587270','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1370','23','1','','2','3408594','2025-11-04','','5601','1354','ZAKARIYA','919964538383','','','EXECL MISCHIEF MALL','MANGALORE','','23','','A N HEMANTH KUMAR','919743350139','','ARALIKERE POST','CHAIRMEN STREET','','11','572227','Document','100.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-04 18:35:00','2025-11-04 18:35:00','17617218175043','17617218175043','','2063','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1371','13','1','','2','3404128','2025-11-04','','5616','1355','REEM DATES','919535152948','','','CITY CENTEHALL','','','11','575001','SURESH S','919740139256','','ANNAPOORNESHWARI NAGAR','','','11','560072','Document','10.00','0.00','0.00','0','Document','Surface','1','5.28','','','','','5.28','450.00','1','1','2025-11-04 18:35:07','2025-11-04 18:35:07','17617147018423','17617147018423','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1372','10','1','','2','3406812','2025-11-04','','5617','1356','DR RUDRAGOUDA R','919880244358','','','AJIDS','KUNTIKAN MLR','','11','575004','SHIVARUDRAGOUDA R','919902103547','','BHYRAPURA HEALING CO','SIRIGERI CROSS','','11','583120','Document','250.00','0.00','0.00','0','Document','Surface','1','0.17','','','','','0.17','85.00','1','1','2025-11-04 18:35:20','2025-11-04 18:35:20','17617151801089','17617151801089','','1058','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1373','22','1','','2','3411115','2025-11-04','','5107','1357','MALLIKATTA MEDICLAS','917204717711','','','KADRI','MALLIKATTA  MANGALURU','','11','575002','SKANDA ACHARYA','919164405684','','202 BALAJI APTS','UDAYAVARA','','11','574118','Document','100.00','0.00','0.00','0','Document','Surface','1','0.05','','','','','0.05','50.00','1','1','2025-11-04 18:35:51','2025-11-04 18:35:51','17617169725275','17617169725275','','1639','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1374','6','1','','2','3381560','2025-11-04','','5618','1358','CONCESSAO ENTER','918242495254','','','NERA ALAKE BRIDGE','MANGALORE','','43','','BHADRA PAPER MILLS LTD','918282240016','','BOMMANAHALLI','BARANDUR POST','','11','577245','Document','0.01','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-04 18:35:59','2025-11-04 18:35:59','17617213813089','17617213813089','','3333','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1375','8','1','','2','3351512','2025-11-04','','4882','1359','SIMSON GUN HOUSE','919845406483','','','A AND A DLR','BAJPE','','11','574142','S JAGADISH','919449137994','','LOVELY LADIES TAILORE','BALEHONNUR','','11','577112','Document','1.00','0.00','0.00','0','Document','Surface','1','0.35','','','','','0.35','105.00','1','1','2025-11-04 18:36:43','2025-11-04 18:36:43','17617178859109','17617178859109','','1422','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1376','25','1','','2','3388886','2025-11-04','','5619','1360','ESWARAN','919043513626','','','MANGLORE','SKL','','11','575014','APR TRT','919443266615','','SP PUDUR','NAMAKKAL','','23','637001','Document','100.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','70.00','1','1','2025-11-04 18:36:56','2025-11-04 18:36:56','17617202587270','17617202587270','','2424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1377','21','1','','2','3393127','2025-11-04','','5620','1361','SHAKTHI LOGISTICS','919104747967','','','KOTTARA','MLR','','11','575006','NITCO LTD','918657558343','','OVER BRIDGE','DHUNA','','7','363621','Document','100.00','0.00','0.00','0','Document','Surface','1','0.09','','','','','0.09','120.00','1','1','2025-11-04 18:37:05','2025-11-04 18:38:32','17616388051318','17616388051318','','590','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1378','23','1','','2','3408595','2025-11-04','','5601','1362','ZAKARIYA','919964538383','','','EXECL MISCHIEF MALL','MANGALORE','','23','','G KUMAR','918971712530','','MULBAGAL POST','00','','11','563131','Document','100.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-04 18:37:07','2025-11-04 18:37:07','17617218175043','17617218175043','NEW A G COLONY','574','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1379','6','1','','2','3381561','2025-11-04','','5618','1363','CONCESSAO ENTER','918242495254','','','NERA ALAKE BRIDGE','MANGALORE','','43','','SHREE PAPERS','919986662608','','NEW THARAGUPETE','3RD MAIN RD','','11','560002','Document','0.01','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-04 18:38:11','2025-11-04 18:38:11','17617213813089','17617213813089','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1380','16','1','','2','3357240','2025-11-04','','5621','1364','GLOBAL PNEUMATICS','918867660134','','','YEYYADI','MANGALORE','','11','575015','MANOJ KUMAR','918202205000','','MANIPAL PAYMENT','PRESS CORNER','','11','576104','Document','1.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','50.00','1','1','2025-11-04 18:38:20','2025-11-04 18:38:20','17617177578387','17617177578387','','662','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1381','10','1','','2','3406813','2025-11-04','','5209','1365','DR NAVEEN KUMAR T','919242233065','','','DEREBAIL KONCHADY','MLR','','11','575006','JYOTHI SEQUIERA','919108834315','','CHAKALA','ANDHERI EAST','','14','400099','Document','500.00','0.00','0.00','0','Document','Surface','1','0.25','','','','','0.25','130.00','1','1','2025-11-04 18:38:25','2025-11-04 18:38:25','17617151801089','17617151801089','','57','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1382','8','1','','4','41616371','2025-11-04','388','397','1366','CANARA LIGHTING','','','','MULKI KINNIGOLI, AIRPORT ROAD, MANGALORE, Dakshina Kannada,  574150','','29AAACC6921B1Z0','11','574150','RAHUL DAS','918910460539','','CANARA LIGHT9ING IND PVT LTD','KMDA PLOT NO GA 37','','28','700107','Document','1.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','46.00','1','1','2025-11-04 18:38:47','2025-12-13 16:58:26','17617178859109','17617178859109','','2666','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','1','0','','','','','','1','');
INSERT INTO `booking` VALUES ('1383','13','1','','2','3404129','2025-11-04','','5627','1367','MOLIDHARAN','917483065602','','','MANGALORE','','','11','575011','BHUVI GRAM','919448608078','','KBP SHENOY COMPLEX','','','11','574104','Document','10.00','0.00','0.00','0','Document','Surface','1','0.15','','','','','0.15','80.00','1','1','2025-11-04 18:39:49','2025-11-04 18:43:40','17617147018423','17617147018423','','75','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1384','25','1','','2','3388887','2025-11-04','','5623','1368','TARACHANDRA','919944269997','','','NSB TRT','KANA SKL','','11','575014','SRINIVASAN','919345481602','','KAMALAM GANESAN NAGAR','TIRUPATIPURAM CUDDALORE','','23','607401','Parcel','1000.00','0.00','0.00','0','Document','Surface','1','0.60','','','','','0.60','140.00','1','1','2025-11-04 18:40:10','2025-11-04 18:40:10','17617202587270','17617202587270','','326','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1385','24','1','','2','3399503','2025-11-04','','5425','1369','BRIJESH RAI','919740060633','','','PUMPWELL','MANGALORE','','11','575002','KSITEJ SOMAYAJI','919164703446','','GAJANANA E.T.C','B.C ROAS BY PASS RD BANTWAL','','11','574219','Document','10.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','50.00','1','1','2025-11-04 18:40:18','2025-11-04 18:40:18','17617227102844','17617227102844','','783','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1386','22','1','','2','3411116','2025-11-04','','5624','1370','R LOGIC TEHCNOLOGY SERVICES','918246816949','','','SAMSUNG AUTH MISSION COMPOUND','MANGALURU','','23','574005','R LOGIC  TEHCNOLOGY SERVICES','918073924239','','KANAKAPURA MAIN ROAD','SRIN IVSAA IND ETSTES','','11','560062','Document','100.00','0.00','0.00','0','Document','Surface','1','0.05','','','','','0.05','60.00','1','1','2025-11-04 18:40:30','2025-11-04 18:40:30','17617169725275','17617169725275','','1036','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1387','8','1','','4','41616372','2025-11-04','394','403','1371','H P C L BAJPE','','','','No. 77, POST BOX No. 1610, OLD MADRAS ROAD, DOORAVANI NAGAR, KRISHNARAJA PURAM, Bengaluru Urban,  560016','','29AAACH1118B1Z8','11','','RN SHIVA KUMAR','917795353765','','HPCL','DOORVANI NAGAR','','11','560016','Document','1.00','0.00','0.00','0','Document','Surface','1','0.05','','','','','0.05','31.00','1','1','2025-11-04 18:40:48','2025-12-17 16:59:41','17617178859109','17617229594029','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','1','0','','','','','','1','');
INSERT INTO `booking` VALUES ('1388','10','1','','2','3406814','2025-11-04','','5209','1372','DR NAVEEN KUMAR T','919242233065','','','DEREBAIL KONCHADY','MLR','','11','575006','SHANTHALA SATHISH','919482213372','','SHREYAS COLONY','JP NAGAR','','11','560078','Document','1000.00','0.00','0.00','0','Document','Surface','1','0.70','','','','','0.70','125.00','1','1','2025-11-04 18:40:53','2025-11-04 18:40:53','17617151801089','17617151801089','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1389','6','1','','2','3381562','2025-11-04','','5625','1373','CRYSTAL ENTERISES','919901087254','','','BOLOOR','MANGALORE','','43','','GVG MILLS P LTD','910425222411','','SIKNADER BATOCHA STREET','GANDHI NAGAR','','23','642154','Document','0.01','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','70.00','1','1','2025-11-04 18:41:24','2025-11-04 18:41:24','17617213813089','17617213813089','','1638','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1390','21','1','','2','3393128','2025-11-04','','5626','1374','NITHYANADA AGENCIES','918494949062','','','DADDALKAD','MLR','','11','575006','NAGESH','918026986021','','V GUARD IND LTD','KUMBALGODU','','11','560074','Document','100.00','0.00','0.00','0','Document','Surface','1','1.08','','','','','1.08','201.00','1','1','2025-11-04 18:41:50','2025-11-04 18:41:50','17616388051318','17616388051318','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1391','8','1','','4','41616373','2025-11-04','434','443','511','STATE BANK OF INDIA  BAJPE','','','','MAIN ROAD NEAR BAJPE POLICE STATION BAJPE','','29AAACS8577K3ZJ','11','574142','S B I','','','SMEC','BEJAI','','11','575001','Document','1.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','9.00','1','1','2025-11-04 18:42:17','2025-12-13 16:58:26','17617178859109','17617178859109','','3453','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','1','0','','','','','','1','');
INSERT INTO `booking` VALUES ('1392','10','1','','2','3406815','2025-11-04','','5209','1375','DR NAVEEN KUMAR T','919242233065','','','DEREBAIL KONCHADY','MLR','','11','575006','VINOD BHAT','919535966178','','IIS','BLR','','11','560012','Document','1000.00','0.00','0.00','0','Document','Surface','1','0.95','','','','','0.95','155.00','1','1','2025-11-04 18:42:54','2025-11-04 18:42:54','17617151801089','17617151801089','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1393','8','1','','4','41616374','2025-11-04','434','443','511','STATE BANK OF INDIA  BAJPE','','','','MAIN ROAD NEAR BAJPE POLICE STATION BAJPE','','29AAACS8577K3ZJ','11','574142','S B I','','','RACPC','YEYYADI','','11','575008','Document','1.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','9.00','1','1','2025-11-04 18:43:39','2025-12-13 16:58:26','17617178859109','17617178859109','','3453','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','1','0','','','','','','1','');
INSERT INTO `booking` VALUES ('1394','24','1','','2','3399504','2025-11-04','','5425','1376','BRIJESH RAI','919740060633','','','PUMPWELL','MANGALORE','','11','575002','ASHIK SHETTY','917760476036','','INSURENCE ZONE E.TC','RING ROAD MOODABIDRI','','11','574227','Document','10.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','50.00','1','1','2025-11-04 18:43:53','2025-11-04 18:43:53','17617227102844','17617227102844','','1068','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1395','6','1','','2','3381563','2025-11-04','','5625','1377','CRYSTAL ENTERISES','919901087254','','','BOLOOR','MANGALORE','','43','','SRIPATHI PAPER AND BOARD P LTD','914295243463','','RAJAN NAGAR','PADUVALLI POST','','23','638401','Document','0.02','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','70.00','1','1','2025-11-04 18:44:10','2025-11-04 18:44:10','17617213813089','17617213813089','','1820','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1396','26','1','','2','3400896','2025-11-04','','5628','1378','LATHESH','919364895126','','','MLR','','','11','575022','SUSHIL KUMAR PANDITHA','918951163640','','AMARYLIIS HEALTH CARE','HSR LAYOOUT','','11','560102','Document','0.00','0.00','0.00','0','Document','Surface','1','0.05','','','','','0.05','60.00','1','1','2025-11-04 18:44:10','2025-11-04 18:44:10','17615707686074','17615707686074','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1397','22','1','','2','3411117','2025-11-04','','5107','1379','MALLIKATTA MEDICLAS','917204717711','','','KADRI','MALLIKATTA  MANGALURU','','11','575002','PARWATHI','919741395417','','HOIGEKERE HOUSE','307','','11','574221','Document','100.00','0.00','0.00','0','Document','Surface','1','0.05','','','','','0.05','50.00','1','1','2025-11-04 18:44:22','2025-11-04 18:44:22','17617169725275','17617169725275','','3411','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1398','21','1','','2','3393129','2025-11-04','','5620','1361','SHAKTHI LOGISTICS','919104747967','','','KOTTARA','MLR','','11','575006','NITCO LTD','918657558343','','OVER BRIDGE','DHUNA','','7','363621','Document','100.00','0.00','0.00','0','Document','Surface','1','0.12','','','','','0.12','130.00','1','1','2025-11-04 18:44:24','2025-11-04 18:44:24','17616388051318','17616388051318','','590','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1399','16','1','','2','3357241','2025-11-04','','5158','93','MUKESH POOJARY','919108769107','','','KAIKAMBA','MANGALORE','','11','574151','ABHIJEET','919620422492','','IDFC FIRST BANK','SARASWATHIPURAM MYSORE','','11','570009','Document','100.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-04 18:44:41','2025-11-04 18:44:41','17617177578387','17617177578387','','669','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1400','13','1','','2','3404130','2025-11-04','','5622','1367','SIDDIQ IDMA','918618122387','','','ULLAIBETTU','','','11','575011','ZAINUL ABID','919448608078','','KUKKUNDOOR','','','11','576117','Document','10.00','0.00','0.00','0','Document','Surface','1','0.60','','','','','0.60','60.00','1','1','2025-11-04 18:45:00','2025-11-04 18:45:00','17617147018423','17617147018423','','1639','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1401','8','1','','4','41616375','2025-11-04','434','443','511','STATE BANK OF INDIA  BAJPE','','','','MAIN ROAD NEAR BAJPE POLICE STATION BAJPE','','29AAACS8577K3ZJ','11','574142','SMITHA KISHORE HSG PVT LTD','','','BUNTS HOSTEL','MANGALORE','','11','575001','Document','1.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','9.00','1','1','2025-11-04 18:45:08','2025-12-13 16:58:26','17617178859109','17617178859109','','3453','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','1','0','','','','','','1','');
INSERT INTO `booking` VALUES ('1402','20','1','','2','3418111','2025-11-04','','5629','1380','NAVEEN MANGALORE','919341251666','','','CARZEISS','MANGALORE','','11','575001','BRIGHT VISION CARE','919901744530','','BRUNDAVANA KATTADA','NR TARUN MOTORS','','11','577124','Parcel','100.00','0.00','0.00','0','Document','Surface','1','0.28','','','','','0.28','105.00','1','1','2025-11-04 18:45:21','2025-11-04 18:45:21','17617138462770','17617138462770','','3297','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1403','23','1','','2','3408596','2025-11-04','','5630','1381','ABDUL KHADER IDDYA','919900447747','','','BUNDER','MANGALORE','','23','','SHAABBIR & GANESH','919740541777','','KUNJIBETTU','00','','11','576102','Document','100.00','0.00','0.00','0','Document','Surface','1','2.50','','','','','2.50','315.00','1','1','2025-11-04 18:45:29','2025-11-04 18:45:29','17617218175043','17617218175043','BALAKRISHNA TOWERS','1639','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1404','22','1','','2','3411118','2025-11-04','','5107','1382','MALLIKATTA MEDICLAS','917204717711','','','KADRI','MALLIKATTA  MANGALURU','','11','575002','MOHAMMED NAWAZ','917259111203','','AZIZ MANZIL','PADUBETTU','','11','574111','Document','0.00','0.00','0.00','0','Document','Surface','1','0.45','','','','','0.45','85.00','1','1','2025-11-04 18:45:43','2025-11-04 18:45:43','17617169725275','17617169725275','','2319','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1405','17','1','','2','3404718','2025-11-04','','5048','1383','SANGEETHA','','','','AXIS MAX LIFE','','','11','575002','SUDHEENDRA','911903710463','','MAX WOTH ASSO','WEST NADAKV','','12','673011','Document','0.00','0.00','0.00','0','Document','Surface','1','1.35','','','','','1.35','260.00','1','1','2025-11-04 18:45:43','2025-11-04 18:45:43','17617216042295','17617216042295','','161','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1406','24','1','','2','3399505','2025-11-04','','5425','1384','BRIJESH RAI','919740060633','','','PUMPWELL','MANGALORE','','11','575002','RASHMITHA','919902672257','','SRI GANESH E T C','SANGABETTU SIDDAKATTE BANTWAL','','11','574237','Document','10.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','50.00','1','1','2025-11-04 18:46:07','2025-11-04 18:46:07','17617227102844','17617227102844','','783','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1407','8','1','','4','41616376','2025-11-04','434','443','511','STATE BANK OF INDIA  BAJPE','','','','MAIN ROAD NEAR BAJPE POLICE STATION BAJPE','','29AAACS8577K3ZJ','11','574142','S B I','','','HR MANAGER','R B O','','11','575006','Document','1.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','9.00','1','1','2025-11-04 18:46:25','2025-12-13 16:58:26','17617178859109','17617178859109','','3453','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','1','0','','','','','','1','');
INSERT INTO `booking` VALUES ('1408','13','1','','2','3404131','2025-11-04','','5631','1385','VINODHANDRA','916363951524','','','CARST','','','43','','MALLIKARJUN BASAPPA','919342828661','','BEHIND KAMREDDY','','','11','584122','Document','10.00','0.00','0.00','0','Document','Surface','1','0.16','','','','','0.16','80.00','1','1','2025-11-04 18:47:06','2025-11-04 18:47:06','17617147018423','17617147018423','','134','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1409','10','1','','2','3406816','2025-11-04','','5632','1386','ANISHA','919972150756','','','BONDEL','MLR','','11','575008','REKHA GANESH','919995221850','','DREAMS LANE CHATARI','TRIPUNITHURA','','12','682301','Document','500.00','0.00','0.00','0','Document','Surface','1','0.47','','','','','0.47','120.00','1','1','2025-11-04 18:47:07','2025-11-04 18:47:07','17617151801089','17617151801089','','1930','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1410','23','1','','2','3408597','2025-11-04','','5633','1387','MAHADEV OPTICALS','916364634575','','','BUNDER','','','23','','ANUGRAHA OPTICALS','916364634575','','00','00','','11','575001','Document','100.00','0.00','0.00','0','Document','Surface','1','0.05','','','','','0.05','50.00','1','1','2025-11-04 18:47:42','2025-11-04 18:47:42','17617218175043','17617218175043','00','3440','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1411','17','1','','2','3404719','2025-11-04','','5124','1388','J GANGADHAR','919480660555','','','MANGALORE','','','11','575002','SAIF','919945123166','','CLASSIC MOTOR','KALPETH','','11','580028','Document','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-04 18:47:56','2025-11-04 18:47:56','17617216042295','17617216042295','','557','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1412','22','1','','2','3411119','2025-11-04','','5634','1389','SHREYA HEARING CLINIC','919686449425','','','KADRI','MANGALURU','','11','575003','ZAINUL ABIDIN','919980920234','','AL AJAIB','MADDINA COLONY','','11','581320','Document','100.00','0.00','0.00','0','Document','Surface','1','0.07','','','','','0.07','75.00','1','1','2025-11-04 18:47:56','2025-11-04 18:47:56','17617169725275','17617169725275','','1689','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1413','6','1','','2','3381564','2025-11-04','','5635','1390','DEEKSHA','918296039343','','','APOLLO PHARAMCY','ASHOK NAGAR','','43','','KIRAN','919900054842','','APOLLO PHARAMA LTD','HOSUR RD','','11','560068','Document','0.01','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-04 18:47:56','2025-11-04 18:47:56','17617213813089','17617213813089','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1414','8','1','','4','41616377','2025-11-04','395','404','511','HDFC BANK LIMITED BAJPE','','','','8/24, SALCO CENTER, RICHMOND ROAD, BANGALORE, Bengaluru Urban, 560025','','29AAACH2702H1ZW','11','574142','LAXMI U','','','HDFC BANK','MANGALORE','','11','575001','Document','1.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','20.00','1','1','2025-11-04 18:48:22','2025-12-18 18:47:22','17617178859109','17617178859109','','3453','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','1','1','2025-12-18 18:47:22','','received','','','1','17645844402769');
INSERT INTO `booking` VALUES ('1415','20','1','','2','3418112','2025-11-04','','5197','1391','VINAYA HOSPITAL','918242494333','','','KARANGALPADY','','','11','575003','MEDI  ASSIST TPA PLTD','918022068666','','CASHELESS PROCESSING CENTRE','MAIN RD BEGUR POST','','11','560068','Document','0.00','0.00','0.00','0','Document','Surface','1','0.10','','','','','0.10','75.00','1','1','2025-11-04 18:48:23','2025-11-04 18:48:23','17617138462770','17617138462770','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1416','18','1','','2','3385050','2025-11-04','','5636','1392','ZAHRAH MINING&TRADING CORP','916362635227','','','COMMERCE  CENTRE','KULUR','','11','575013','UTHRAA  B','919489080521','','THE  INDIA  CEMENT  LTD','SHANKAR  NAGAR  TIRUNAVELI','','23','627357','Document','10.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','70.00','1','1','2025-11-04 18:48:33','2025-11-04 18:48:33','17617174764463','17617174764463','','280','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1417','25','1','','2','3388888','2025-11-04','','5048','1393','AUTO MATRIX','','','','SKL','','','39','','AUTO MATRIX','919740322859','','CKM','','','11','577101','Parcel','0.00','0.00','0.00','0','Document','Surface','1','1.03','','','','','1.03','201.00','1','1','2025-11-04 18:49:09','2025-11-04 18:49:09','17617202587270','17617202587270','KOTE','695','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1418','10','1','','2','3406817','2025-11-04','','5632','1394','ANISHA','919972150756','','','BONDEL','MLR','','11','575008','SWATHI PUNEETH','919900643037','','MADAPADI HOUSE','THENKAYEDAPADAVU','','11','574144','Document','500.00','0.00','0.00','0','Document','Surface','1','0.50','','','','','0.50','85.00','1','1','2025-11-04 18:50:03','2025-11-04 18:50:03','17617151801089','17617151801089','','3256','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1419','8','1','','4','41616378','2025-11-04','377','386','511','BAJPE VYAVASAYA SEVA SAHAKARI BANK','','','','3-127, Main Road Bajpe, Bajpe, Dakshina Kannada, Karnataka, 574142','','29AABAB1620R1ZL','11','574142','LIC OF INDIA','','','MAIN RD','MULKY','','11','574141','Document','1.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','23.00','1','1','2025-11-04 18:50:07','2025-12-17 12:13:50','17617178859109','17617178859109','','744','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','1','0','','','','','','1','');
INSERT INTO `booking` VALUES ('1420','13','1','','2','3404132','2025-11-04','','5637','1395','PAINT PLUS','919845289546','','','MANGALORE','','','11','575001','PON PURE CHEMICAL','919448289354','','NAGASANDRA','','','11','560073','Document','10.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-04 18:50:11','2025-11-04 18:50:11','17617147018423','17617147018423','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1421','25','1','','2','3388889','2025-11-04','','5048','1393','AUTO MATRIX','','','','SKL','','','11','575014','AUTO MATRIX','919740322859','','CKM','','','11','577101','Parcel','0.00','0.00','0.00','0','Document','Surface','1','0.39','','','','','0.39','105.00','1','1','2025-11-04 18:51:00','2025-11-04 18:51:00','17617202587270','17617202587270','','186','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1422','20','1','','2','3418113','2025-11-04','','5638','1396','UMESH SUVERNA','919844161702','','','NR NAVABHARTAH CIRCLE','MANGALORE','','11','575001','NAVEEN KUMAR','919742036407','','SAKALA OPERATORS','END POINT','','11','576101','Document','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','50.00','1','1','2025-11-04 18:51:05','2025-11-04 18:51:05','17617138462770','17617138462770','','662','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1423','22','1','','2','3411120','2025-11-04','','5634','1397','SHREYA HEARING CLINIC','919686449425','','','KADRI','MANGALURU','','11','575003','DAYA SPL SCHOOL','918197069094','','VINUKTHI','LAILA','','11','574214','Document','100.00','0.00','0.00','0','Document','Surface','1','0.05','','','','','0.05','50.00','1','1','2025-11-04 18:51:30','2025-11-04 18:51:30','17617169725275','17617169725275','','2580','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1424','6','1','','2','3381565','2025-11-04','','5145','1398','INVENGER TECHNOLOGIES PVT LTD','918244232777','','','INVENGER TOWER','BALLALBAGH','','11','575003','PROTEAN EGOV TECH LTD','918096078080','','SAPPHIRE CHAMBERS','BANER RD BANER','','14','411045','Document','0.01','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','100.00','1','1','2025-11-04 18:51:50','2025-11-04 18:51:50','17617213813089','17617213813089','','13','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1425','17','1','','2','3404720','2025-11-04','','5639','1399','CHETHAN L KULAL','919880698555','','','MANGALORE','','','11','575002','REBIRTH HEALTHCARE','916362795025','','CHAMRAJPET','','','11','560018','Document','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-04 18:51:56','2025-11-04 18:52:52','17617216042295','17617216042295','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1426','8','1','','4','41616379','2025-11-04','425','434','511','S C D C C BANK DAMASKATTE','','','','ANNAPOORNESHWARI AIKALA POST DAMASKATTE','','29AABAT6621N2ZZ','11','574150','SCDCC BANK LTD','','','H O','MANGALORE','','11','575001','Document','0.02','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','14.70','1','1','2025-11-04 18:51:57','2025-12-22 13:12:47','17617178859109','17617178859109','','3453','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','1','0','','','','','','1','');
INSERT INTO `booking` VALUES ('1427','12','1','','2','3382958','2025-11-04','','5640','1400','SNM LOGITS','918904706472','','','ATTAVARA','MANGALORE','','11','575001','ASST EXCU ENGG','919844926531','','ZILLA PANCHAYATH BLDG','BANNANJE','','11','576101','DOX','100.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','50.00','1','1','2025-11-04 18:52:17','2025-11-04 18:52:17','17617206505387','17617206505387','','1639','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1428','23','1','','2','3408598','2025-11-04','','5641','1401','NATIONAL ENTERPRISESE','918244286543','','','BUNDER','MANGALORE','','23','','SUNTEK STATIONERS PVT LTD','918043500510','','LALBAGH ROAD','00','','11','560027','Document','100.00','0.00','0.00','0','Document','Surface','1','1.50','','','','','1.50','247.00','1','1','2025-11-04 18:52:28','2025-11-05 11:40:19','17617218175043','17617218175043','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1429','13','1','','2','3404133','2025-11-04','','5642','1402','NAYSAR VINOD SHAH','911993051130','','','MANGALORE','','','11','575011','MAGICUCCO PVT','919113502189','','RAJAJINAGAR','','','11','560010','Document','10.00','0.00','0.00','0','Document','Surface','1','0.05','','','','','0.05','60.00','1','1','2025-11-04 18:52:31','2025-11-04 18:52:31','17617147018423','17617147018423','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1430','10','1','','2','3406818','2025-11-04','','5632','1403','ANISHA','919972150756','','','BONDEL','MLR','','11','575008','KAVITHA SETHU','919496175127','','SARASWATHY BHAVAN','THATHAMPALLY','','12','688013','Document','500.00','0.00','0.00','0','Document','Surface','1','0.50','','','','','0.50','120.00','1','1','2025-11-04 18:52:47','2025-11-04 18:52:47','17617151801089','17617151801089','','1095','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1431','22','1','','2','3411121','2025-11-04','','5643','1404','BHARATH BEEDI WORKS P LTD','918242443430','','','KADRI','MANGALURU','','11','575003','ANIL BALIRAM MORE','917030035333','','BWING  3RD FLKOOR','GOLANI MARKET','','14','425001','Document','100.00','0.00','0.00','0','Document','Surface','1','0.05','','','','','0.05','100.00','1','1','2025-11-04 18:53:47','2025-11-04 18:53:47','17617169725275','17617169725275','','285','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1432','8','1','','4','41616380','2025-11-04','425','434','511','S C D C C BANK DAMASKATTE','','','','ANNAPOORNESHWARI AIKALA POST DAMASKATTE','','29AABAT6621N2ZZ','11','574150','VINUTHA','','','SCDCC BANK LTD','HO','','11','575001','Document','1.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','14.70','1','1','2025-11-04 18:54:10','2025-12-22 13:12:47','17617178859109','17617178859109','','3453','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','1','0','','','','','','1','');
INSERT INTO `booking` VALUES ('1433','13','1','','2','3404134','2025-11-04','','5644','1405','SOURSHTRA CLOTH','918147144577','','','MARKET ROAD','','','11','575001','MANSI NAYAK','918147144577','','ST JOSEPH ENGG','','','11','574101','Document','10.00','0.00','0.00','0','Document','Surface','1','0.47','','','','','0.47','90.00','1','1','2025-11-04 18:54:23','2025-11-04 18:54:23','17617147018423','17617147018423','','853','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1434','6','1','','2','3381566','2025-11-04','','5645','1406','PRADEEP','918152036440','','','MANGALORE','MANGALORE','','11','','NAGARAJA P','917743010037','','4TH MAIN','SUBBANNA GARDEN','','11','560040','Document','0.01','0.00','0.00','0','Document','Surface','1','0.15','','','','','0.15','85.00','1','1','2025-11-04 18:54:27','2025-11-04 18:54:27','17617213813089','17617213813089','','1036','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1435','12','1','','2','3382959','2025-11-04','','5640','1400','SNM LOGITS','918904706472','','','ATTAVARA','MANGALORE','','11','575001','EXCUTIVE ENGG','919844926531','','SHAMILI HALL','AMBALPADY','','11','576210','Document','100.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','50.00','1','1','2025-11-04 18:54:44','2025-11-04 18:54:44','17617206505387','17617206505387','','1639','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1436','25','1','','2','3388890','2025-11-04','','5048','1407','AUTO MATRIX','','','','SKL','','','11','575014','AUTO MATRIX','919243318488','','BEJAI','BEJAI','','11','575004','Parcel','0.00','0.00','0.00','0','Document','Surface','1','0.32','','','','','0.32','75.00','1','1','2025-11-04 18:54:47','2025-11-04 18:54:47','17617202587270','17617202587270','','3453','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1437','10','1','','2','3406819','2025-11-04','','5632','1408','ANISHA','919972150756','','','BONDEL','MLR','','11','575008','JAYASHREE M','919847728090','','KRISHNA BHAVAN','AMARAVATHY FORT KOCHI','','12','682001','Laptop','750.00','0.00','0.00','0','Document','Surface','1','1.00','','','','','1.00','160.00','1','1','2025-11-04 18:55:17','2025-11-04 18:55:17','17617151801089','17617151801089','','2432','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1438','22','1','','2','3411122','2025-11-04','','5646','1409','PRAIYANKA RAO','919844636380','','','NEXA KADRI','MANGALURU','','11','575003','DR RASHMI NAYAK','919845555454','','YENEAPOYA FERTILTY DEPT','Y M C  HOSPITAL','','11','575018','Document','100.00','0.00','0.00','0','Document','Surface','1','0.05','','','','','0.05','50.00','1','1','2025-11-04 18:55:49','2025-11-04 18:55:49','17617169725275','17617169725275','','3171','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1439','13','1','','2','3404135','2025-11-04','','4720','1410','northern sky','918242429339','','','j v building','mangalore','','43','575001','SHIYAK GUBBI','918123309586','','KOTHANUR','','','11','575001','Document','10.00','0.00','0.00','0','Document','Surface','1','0.05','','','','','0.05','60.00','1','1','2025-11-04 18:56:32','2025-11-04 18:56:32','17617147018423','17617147018423','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1440','20','1','','2','3418114','2025-11-04','','5638','1411','UMESH SUVERNA','919844161702','','','NR NAVABHARTAH CIRCLE','MANGALORE','','11','575001','RAGHUPATHI PAI','919448216083','','NR RTO','BANNUR','','11','574201','Document','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','50.00','1','1','2025-11-04 18:56:47','2025-11-04 18:56:47','17617138462770','17617138462770','','1904','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1441','23','1','','2','3408599','2025-11-04','','5164','1412','POONAM','919845939315','','','UBI','MANGALORE','','23','','RANGWALA','919636084034','','RAJWADI POSHAK GHAR','12OFF NAGAR NIGAM','TOWN HALL MAIN ROAD','21','313001','Document','100.00','0.00','0.00','0','Document','Surface','1','0.80','','','','','0.80','290.00','1','1','2025-11-04 18:57:03','2025-11-04 18:57:03','17617218175043','17617218175043','','272','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1442','25','1','','2','3388891','2025-11-04','','5647','1413','KUMAR S','918152973106','','','SKL','','','11','575014','RAJASHREE PRABHU','919148202271','','INDUS TOWER PVT','SUBRAMANYA ARCADE','','11','560029','Document','0.00','0.00','0.00','0','Document','Surface','1','0.01','','','','','0.01','60.00','1','1','2025-11-04 18:57:16','2025-11-04 18:57:16','17617202587270','17617202587270','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1443','8','1','','4','41616381','2025-11-04','432','441','1414','ST MILAGRES CREDIT SOUHARDHA CO-OP LTD.,KARWAR(BAJPE)','','','','t Milagres Credit Souharda, co op society limited, Keshava Shet Road, Karwar, Uttara Kannada , 581304','','29AACAS0079A1ZR','11','574142','ST MILAGRES CR CO OP','918382223600','','SONARWADA','KARWAR','','11','581304','Document','1.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','42.00','1','1','2025-11-04 18:57:40','2025-12-13 16:58:27','17617178859109','17617178859109','','296','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','1','0','','','','','','1','');
INSERT INTO `booking` VALUES ('1444','22','1','','2','3411123','2025-11-04','','5648','1415','DHANAJAY','918310675912','','','BIKRNKATTA','MANGALURU','','11','575005','K KANNAIHA','919008949675','','1ST CROSS A S STREET','MAGADI ROAD','','11','560023','Document','200.00','0.00','0.00','0','Document','Surface','1','0.80','','','','','0.80','155.00','1','1','2025-11-04 18:57:45','2025-11-04 18:57:45','17617169725275','17617169725275','','1036','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1445','20','1','','2','3418115','2025-11-04','','5638','1416','UMESH SUVERNA','919844161702','','','NR NAVABHARTAH CIRCLE','MANGALORE','','11','575001','SHEKAR POOJARY','919902206999','','BIRWA XEROX CENTER','NR RTO','','11','574201','Document','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','50.00','1','1','2025-11-04 18:58:10','2025-11-04 18:58:10','17617138462770','17617138462770','','783','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1446','6','1','','2','3381567','2025-11-04','','5649','1417','SAJID','919945329195','','','MANGALORE','MANGALORE','','43','','SAMEEN','919986054446','','CONSULT AND SERVIC','SIDDAPURA RD  JAYANAGARA','','11','560011','Document','0.01','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-04 18:58:32','2025-11-04 18:58:32','17617213813089','17617213813089','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1447','12','1','','2','3382960','2025-11-04','','4591','1418','SUREKHA K','919880631437','','','MANGALA CARGO CARRIERS','MONKY STAND MANGALORE','','11','','VENKAT RAO','918951264865','','DASANAPURA HOBLI','ADAKMANEHALLI','','11','562123','Document','0.00','0.00','0.00','0','Document','Surface','1','0.08','','','','','0.08','75.00','1','1','2025-11-04 18:58:59','2025-11-04 18:58:59','17617206505387','17617206505387','SCORPIAN EXPRESS P LTD','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1448','8','1','','4','41616382','2025-11-04','382','391','511','BANK OF BARODA KINNIGOLI','','','','3, BANK OF BARODA, NITESH LEXINGTON AVENUE, BRIGADE ROAD, BENGALURU, Bengaluru Urban,560025','','29AAACB1534F3Z0','11','574150','SOHAN','','','B O B','JYOTHI','','11','575001','Document','1.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','15.00','1','1','2025-11-04 18:59:14','2025-12-18 18:49:37','17617178859109','17617178859109','','3453','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','1','1','2025-12-18 18:49:37','','received','','','1','17645844402769');
INSERT INTO `booking` VALUES ('1449','13','1','','2','3404136','2025-11-04','','5650','1419','NET COM SOLUTIONS','919686793298','','','MANGALORE','','','11','575001','PARSAN TECHNOLOGIES','919870338387','','NARIMAN POINT','','','14','400021','Document','10.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','100.00','1','1','2025-11-04 18:59:21','2025-11-04 18:59:21','17617147018423','17617147018423','','57','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1450','24','1','','2','3399507','2025-11-04','','5425','1420','BRIJESH RAI','919740060633','','','PUMPWELL','MANGALORE','','10','575002','MORAS EMISSION CENTER','919449025877','','PREETHI COMNPLEX, KALLADKA','BANTWAL TQ -','','11','574222','Document','0.00','0.00','0.00','0','Document','Surface','1','0.01','','','','','0.01','50.00','1','1','2025-11-04 18:59:54','2025-11-04 18:59:54','17617227711727','17617227711727','P','3193','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1451','20','1','','2','3418116','2025-11-04','','5651','1421','SHRIKANTH NAYAK','919611203217','','','KODILABIAL','MANGALORE','','11','575001','PRASHANTH SHENOY','919901420550','','SHENOY BUILD','PALIMAR','','11','574201','Parcel','100.00','0.00','0.00','0','Document','Surface','1','0.17','','','','','0.17','75.00','1','1','2025-11-04 18:59:58','2025-11-04 18:59:58','17617138462770','17617138462770','','2319','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1452','9','1','','2','3283701','2025-11-04','','5652','1422','SRI GURU KRIPA ENTP','919845085687','','','BYKAMPADY INDUSTRIAL AREA','MANAGLORE','','11','575001','VIJAY MIS','919108466844','','JC INDUSTRIAL ESTATE','KANKAPURA ROAD','','11','560062','Document','0.00','0.00','0.00','0','Document','Surface','1','0.10','','','','','0.10','75.00','1','1','2025-11-04 19:00:24','2025-11-04 19:00:24','17617247788137','17617247788137','DAIRY CLASSIC ICR CREAMS','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1453','10','1','','2','3406820','2025-11-04','','5108','1423','V4 DIGITAL INFOTECH','919845101979','','','YEYYADI','MLR','','11','575008','VENKAT SARADHI TALASIA','919966418595','','ZEE ENT LTD','JUBILEE HILLS','','1','500033','Document','50.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','70.00','1','1','2025-11-04 19:00:24','2025-11-04 19:00:24','17617151801089','17617151801089','','117','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1454','8','1','','4','41616383','2025-11-04','395','404','511','HDFC BANK LIMITED BAJPE','','','','8/24, SALCO CENTER, RICHMOND ROAD, BANGALORE, Bengaluru Urban, 560025','','29AAACH2702H1ZW','11','574142','HDFC BANK','','','SARASWATHIPURAM','MYSORE','','11','570009','Document','1.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','29.00','1','1','2025-11-04 19:01:03','2025-12-13 16:58:27','17617178859109','17617178859109','','669','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','1','0','','','','','','1','');
INSERT INTO `booking` VALUES ('1455','12','1','','2','3382961','2025-11-04','','5653','1424','ARTHUR ROY RODRIGUES','919844042965','','','G1 ROSHNY APT STURCOK RD','MANGALORE','','11','575001','MRS GEETHA GS','919449066132','','MUDIGERE','','','11','','Document','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-04 19:01:16','2025-11-04 19:01:16','17617206505387','17617206505387','LIC OF INDIA','2607','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1456','25','1','','2','3388892','2025-11-04','','5654','1425','HARISHCHANDRA N SUVARNA','919964157720','','','MARUTHINAGAR H','HOSABETTU','','11','575019','AGARWAL COAL CORP PVT','919753069330','','YESHWANT COLONY','','','13','452003','Document','0.00','0.00','0.00','0','Document','Surface','1','0.01','','','','','0.01','100.00','1','1','2025-11-04 19:01:43','2025-11-04 19:01:43','17617202587270','17617202587270','','558','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1457','22','1','','2','3411124','2025-11-04','','5097','1426','NEW ALL INDIA ROADLINES','919900001516','','','NANTHOOR','MANGALURU','','11','575004','SHREE TRANS CORP','919945961524','','IND AREA','NR TAXI CAMPUS ROAD','','11','576104','Document','100.00','0.00','0.00','0','Document','Surface','1','0.05','','','','','0.05','50.00','1','1','2025-11-04 19:01:51','2025-11-04 19:01:51','17617169725275','17617169725275','','662','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1458','13','1','','2','3404137','2025-11-04','','5655','277','J V SONA AND CO','918242423439','','','HAMPANKATTA','','','11','575001','UNITED MOTORS','918494900306','','MALLANDUR ROAD','BAIKAMPADY','','11','575011','Document','10.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-04 19:01:56','2025-11-04 19:01:56','17617147018423','17617147018423','','186','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1459','10','1','','2','3406821','2025-11-04','','5108','1427','V4 DIGITAL INFOTECH','919845101979','','','YEYYADI','MLR','','11','575008','SRINIVASAN','919739692555','','ZEE ENT LTD','MG ROAD','','11','560001','Document','50.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-04 19:02:21','2025-11-04 19:02:21','17617151801089','17617151801089','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1460','23','1','','2','3408600','2025-11-04','','5656','1428','SAMSHAD','918080260101','','','PANDESHWARA','','','23','','ARAVIND R','919074852992','','JAWAHARALAL NEHARU ROAD','ANNA NAGAR','','23','600040','Document','100.00','0.00','0.00','0','Document','Surface','1','0.90','','','','','0.90','160.00','1','1','2025-11-04 19:02:57','2025-11-04 19:02:57','17617218175043','17617218175043','V R MALL','1931','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1461','22','1','','2','3411125','2025-11-04','','5097','1429','NEW ALL INDIA ROADLINES','919900001516','','','NANTHOOR','MANGALURU','','11','575004','SRI MANGALA ROADWAYS','919840059293','','KOYAMBEDU','RAMAKRISHNA WEIGH BRDIGE','','23','600107','Document','100.00','0.00','0.00','0','Document','Surface','1','0.05','','','','','0.05','70.00','1','1','2025-11-04 19:04:04','2025-11-04 19:04:04','17617169725275','17617169725275','','1931','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1462','24','1','','2','3399508','2025-11-04','','5425','1430','BRIJESH RAI','919740060633','','','PUMPWELL','MANGALORE','','11','575002','NISHANTH RAI','917619172452','','N R EMMISSION CENTER,','KABADA -  574221','','11','574221','Document','0.00','0.00','0.00','0','Document','Surface','1','0.01','','','','','0.01','50.00','1','1','2025-11-04 19:04:23','2025-11-04 19:04:23','17617227711727','17617227711727','','3411','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1463','10','1','','2','3406822','2025-11-04','','5108','1431','V4 DIGITAL INFOTECH','919845101979','','','YEYYADI','MLR','','11','575008','RAMAKRISHNAN','919900158876','','CULVER MAX ENT P LTD','DICKENSON ROAD','','11','560042','Document','50.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-04 19:04:33','2025-11-04 19:04:33','17617151801089','17617151801089','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1464','13','1','','2','3404138','2025-11-04','','5219','1432','VIVEK BAGADE','919900157668','','','A/3 PARIJNAN GHS','MANGALORE','','11','575001','SHIVSHNAKAR BAGADE','919890137693','','GACHIBOWLI','','','23','500032','Document','10.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','70.00','1','1','2025-11-04 19:04:33','2025-11-04 19:04:33','17617147018423','17617147018423','','117','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1465','17','1','','2','3404721','2025-11-04','','5657','93','PRAVEEN ACHARI','918310199577','','','MANGALORE','IDFC BANK','','11','575002','ABHIJEET','919620422492','','IDFC FIRST BANK','SARASWATHIPURAM MYSORE','','11','','Document','0.00','0.00','0.00','0','Document','Surface','1','1.14','','','','','1.14','200.00','1','1','2025-11-04 19:05:01','2025-11-04 19:05:01','17617216042295','17617216042295','','669','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1466','12','1','','2','3382962','2025-11-04','','5658','511','VAISHNAVI EXPRESS CARGO','916364749737','','','MORGANSGATE','','','11','575001','BELTHANGADY TQ RUBBER GROWERS','','','UJIRE','','','11','','Document','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','50.00','1','1','2025-11-04 19:05:13','2025-11-04 19:05:13','17617206505387','17617206505387','MKTING & PROCESSING CO-OP','3440','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1467','6','1','','2','3381568','2025-11-04','','5659','1433','SATHYANARAYNA SHENOY','918217477354','','','PALGUNI NAGAR','DAMBEL','','43','','P G RAMAKRISHNAIAH','919880904056','','DODDAMMA TEMPLE','MADDANI NAGAR','','11','560090','Document','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-04 19:05:40','2025-11-04 19:05:40','17617213813089','17617213813089','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1468','20','1','','2','3418117','2025-11-04','','5660','1434','AMITH','911990039618','','','KODILABIL','MANGALORE','','11','575001','SHAHSIKALA','919206942446','','NAVAPRIYA LAYOUT','DODDAKALASANDRA','','11','560062','Document','0.00','0.00','0.00','0','Document','Surface','1','0.12','','','','','0.12','85.00','1','1','2025-11-04 19:05:44','2025-11-04 19:05:44','17617138462770','17617138462770','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1469','13','1','','2','3404139','2025-11-04','','5219','1435','VIVEK BAGADE','919900157668','','','A/3 PARIJNAN GHS','MANGALORE','','11','575001','AMITH KOMBRABIAL','919900157668','','TANKROA HINKAL','','','11','570017','Document','10.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-04 19:06:05','2025-11-04 19:06:05','17617147018423','17617147018423','','669','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1470','23','1','','2','3408601','2025-11-04','','5661','1436','SAHAR JEWELLARY','917019269138','','','PANDESHWARA','MANGALORE','','23','','ACI','919740772110','','DWARKA','00','','32','110078','Document','100.00','0.00','0.00','0','Document','Surface','1','0.10','','','','','0.10','120.00','1','1','2025-11-04 19:06:24','2025-11-04 19:06:24','17617218175043','17617218175043','FNB APART C 201','541','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1471','10','1','','2','3406823','2025-11-04','','5662','1437','DINESH SHETTY','917305939076','','','YEKKAR','MLR','','11','574509','SRI BALAJI PLASTICS','916500755600','','VADAMADURAI','COIMBATORE','','23','641017','Document','50.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','70.00','1','1','2025-11-04 19:06:44','2025-11-04 19:06:44','17617151801089','17617151801089','','535','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1472','22','1','','2','3411126','2025-11-04','','5097','1438','NEW ALL INDIA ROADLINES','919900001516','','','NANTHOOR  MH41AU1328','MANGALURU','','11','575004','SAKSHI TRANSPORT SERVICES','919892287369','','VASHI','OP KUBER HOTEL','','14','400705','Document','100.00','0.00','0.00','0','Document','Surface','1','0.05','','','','','0.05','100.00','1','1','2025-11-04 19:06:55','2025-11-04 19:06:55','17617169725275','17617169725275','','57','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1473','24','1','','2','3399509','2025-11-04','','5425','1439','BRIJESH RAI','919740060633','','','PUMPWELL','MANGALORE','','11','575002','PUNEETH C M,','919164477477','','SMART CARD & ETC','BONDEL MANGALORE','','11','575008','Document','0.00','0.00','0.00','0','Document','Surface','1','0.01','','','','','0.01','50.00','1','1','2025-11-04 19:07:37','2025-11-04 19:07:37','17617227922084','17617227922084','','3453','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1474','12','1','','2','3382963','2025-11-04','','5663','511','DURGA DISTRIBUTORS','918722988000','','','BOLARA','MANGALORE','','11','575001','M/S RAPITO INTERNATIONAL','','','NO36/2 FIRST FLOOR 2ND CROSS','KUMARAPARK WEST','','11','560020','Document','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-04 19:07:56','2025-11-04 19:07:56','17617206505387','17617206505387','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1475','13','1','','2','3404140','2025-11-04','','5126','1440','SUNTEC','918242411234','','','CARST','MANGALAORE','','11','575001','NANDADEEPA ENT','918496829459','','PUNJALKATTE','','','43','574233','Document','10.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','50.00','1','1','2025-11-04 19:08:52','2025-11-04 19:08:52','17617147018423','17617147018423','','75','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1476','23','1','','2','3408602','2025-11-04','','5656','1441','SAMSHAD','918080260101','','','PANDESHWARA','','','23','','BIJU ANAND','919495329030','','CHAVARA','','','12','691585','Document','100.00','0.00','0.00','0','Document','Surface','1','0.40','','','','','0.40','120.00','1','1','2025-11-04 19:09:00','2025-11-04 19:09:00','17617218175043','17617218175043','VATTA THARA MUKUNDAPURM','650','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1477','10','1','','2','3406824','2025-11-04','','5108','1442','V4 DIGITAL INFOTECH','919845101979','','','YEYYADI','MLR','','11','575008','SHAFFIULLA SHERIF','919900053955','','SUN DIST SER P LTD','BRUNTON ROAD MG ROAD','','11','560025','Document','50.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-04 19:09:05','2025-11-04 19:09:05','17617151801089','17617151801089','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1478','20','1','','2','3418118','2025-11-04','','5664','1443','BRIJESH','918169146589','','','KBL ELFRMS DEPT','KODILABIL','','11','575001','MORE GAJANAN','918169146589','','KARNATAKA BANKA LTD','UDHNA DARWAJA RING RD','','7','395002','Document','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','100.00','1','1','2025-11-04 19:09:36','2025-11-04 19:09:36','17617138462770','17617138462770','','163','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1479','13','1','','2','3404141','2025-11-04','','5126','648','SUNTEC','918242411234','','','CARST','MANGALAORE','','11','575001','GANESH PRINERS','919481140998','','GANDHINAGAR','','','11','574239','Document','10.00','0.00','0.00','0','Document','Surface','1','0.05','','','','','0.05','50.00','1','1','2025-11-04 19:09:54','2025-11-04 19:09:54','17617147018423','17617147018423','','2577','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1480','12','1','','2','3382964','2025-11-04','','5048','1444','PRESTO FOODS CORP','','','','JEPPU','MANGALORE','','11','575001','GURU RAGHAVENDRA FIANNCE','919845577751','','THOKKOTTU','MANGALORE','','11','575001','Document','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','50.00','1','1','2025-11-04 19:10:35','2025-11-04 19:10:35','17617206505387','17617206505387','','3179','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1481','21','1','','2','3393130','2025-11-04','','5665','1445','DURGA FURNITURE','919845080669','','','KODIKAL','MLR','','11','575006','BANK OF BARODA','910842245118','','R O','B M RD','','11','573201','Document','100.00','0.00','0.00','0','Document','Surface','1','0.10','','','','','0.10','75.00','1','1','2025-11-04 19:10:35','2025-11-04 19:10:35','17616388051318','17616388051318','','448','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1482','20','1','','2','3418119','2025-11-04','','5666','1446','PRASHANTH SHET','917676967566','','','KBL RETAIL CENTRE','KODILABIL','','23','','KARNATAKA BANK','919482395015','','KAMALASHRI TOWERS','BAZARRD','','11','574154','Document','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-04 19:11:15','2025-11-04 19:11:15','17617138462770','17617138462770','','191','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1483','7','1','','2','3395055','2025-11-04','','5667','1447','TRANSLINK','919741055679','','','BAIKAMAPADY','MANGALORE','','11','575011','PRAKASH  TPT  CORP','919124001380','','BASAWESHARA  NAGAR','TORANGALLU','','11','583123','Document','10.00','0.00','0.00','0','Document','Surface','1','0.01','','','','','0.01','60.00','1','1','2025-11-04 19:11:49','2025-11-04 19:11:49','17617199828916','17617199828916','','427','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1484','23','1','','2','3408603','2025-11-04','','5668','1448','KILLER BRANDS','919108150216','','','PANDESHWARA','MANGALORE','','23','','KILLER BRANDS','918287501130','','MANTRI MALL','MALLESHWARA','','11','560003','Document','100.00','0.00','0.00','0','Document','Surface','1','2.50','','','','','2.50','431.00','1','1','2025-11-04 19:12:07','2025-11-04 19:12:07','17617218175043','17617218175043','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1485','13','1','','2','3404142','2025-11-04','','5669','1449','MANTRA','911735357544','','','CARST','','','11','575001','DIGVIJAY SINGH','917000995043','','NEAR BANESHWARKUND','','','13','452015','Document','10.00','0.00','0.00','0','Document','Surface','1','0.46','','','','','0.46','170.00','1','1','2025-11-04 19:12:24','2025-11-04 19:12:24','17617147018423','17617147018423','','558','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1486','12','1','','2','3382965','2025-11-04','','5670','511','ICAR','919481960311','','','CMFRI','HOIGEBAZAR','','11','575001','ICAR CMFRI','','','P B NO 1603','ERNAKULAM','','12','682018','Document','10.00','0.00','0.00','0','Document','Surface','1','0.31','','','','','0.31','120.00','1','1','2025-11-04 19:12:54','2025-11-04 19:12:54','17617206505387','17617206505387','','2432','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1487','24','1','','2','3399506','2025-11-04','','5425','1450','BRIJESH RAI','919740060633','','','PUMPWELL','MANGALORE','','11','575002','laxmana','918277164229','','manjushree etc and auto works','KOKKADA, BELTHANGADY','','11','574198','Document','0.00','0.00','0.00','0','Document','Surface','1','0.01','','','','','0.01','50.00','1','1','2025-11-04 19:12:56','2025-11-04 19:12:56','17617227922084','17617227922084','','2580','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1488','7','1','','2','3395056','2025-11-04','','5667','1451','TRANSLINK','919741055679','','','BAIKAMAPADY','MANGALORE','','11','575011','SANVI  ROADLINES','919980820073','','TANDUR ROAD','KALBURGI','','11','585301','Document','10.00','0.00','0.00','0','Document','Surface','1','0.01','','','','','0.01','60.00','1','1','2025-11-04 19:13:40','2025-11-04 19:13:40','17617199828916','17617199828916','','1195','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1489','10','1','','2','3406825','2025-11-04','','5671','1452','SANATH KUMAR K','919061627592','','','MLR','MLR','','11','575002','EMCURE PHARMACEUTICALS','919980304949','','HEROHALLI EXTN','MAGADI ROAD','','11','560091','Document','50.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-04 19:13:57','2025-11-04 19:13:57','17617151801089','17617151801089','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1490','20','1','','2','3418120','2025-11-04','','5672','1453','KANIPURA DESIGNS','919980269800','','','MANGALORE','NAVABHARATH CIRCE','','11','575001','DHANALAKSHMI BANK','919539007098','','HOTEL APSARA RESIDENCY','OPP KSRTC BUS STAND','','12','670001','Document','0.00','0.00','0.00','0','Document','Surface','1','0.23','','','','','0.23','95.00','1','1','2025-11-04 19:14:02','2025-11-04 19:14:02','17617138462770','17617138462770','','1062','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1491','13','1','','2','3404143','2025-11-04','','5673','277','FATHIMA TRDERS','918123007080','','','MKT ROAD','','','11','575001','BHARATH BEEDI WORKS','918494900306','','BHARATH LOGIESTCS','BAIKAMPADY','','11','575011','Document','10.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','30.00','1','1','2025-11-04 19:14:33','2025-11-26 15:56:16','17617147018423','17617147018423','','3453','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1492','12','1','','2','3382966','2025-11-04','','5670','511','ICAR','919481960311','','','CMFRI','HOIGEBAZAR','','11','575001','I C A R C M F R I','','','P B NO 1603','ERNAKULAM PO','','12','682018','Document','10.00','0.00','0.00','0','Document','Surface','1','0.23','','','','','0.23','95.00','1','1','2025-11-04 19:14:37','2025-11-04 19:14:37','17617206505387','17617206505387','','2432','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1493','24','1','','2','3399510','2025-11-04','','5425','1454','BRIJESH RAI','919740060633','','','PUMPWELL','MANGALORE','','11','575002','POWER CELL BATTEIRIES','919481971380','','BAJAGOLI','KARKALA','','11','574122','Document','0.00','0.00','0.00','0','Document','Surface','1','0.01','','','','','0.01','50.00','1','1','2025-11-04 19:15:05','2025-11-04 19:15:05','17617227922084','17617227922084','','75','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1494','7','1','','2','3395057','2025-11-04','','5667','1455','TRANSLINK','919741055679','','','BAIKAMAPADY','MANGALORE','','11','575011','RITCO  LOGISTICS  LTD','919319437770','','UDYOG  VIHAR','GURGAON','','8','122016','Document','10.00','0.00','0.00','0','Document','Surface','1','0.01','','','','','0.01','100.00','1','1','2025-11-04 19:15:18','2025-11-04 19:15:18','17617199828916','17617199828916','','5','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1495','23','1','','2','3408604','2025-11-04','','5674','1456','BATA INDIA LTD','919845528474','','','PANDESHWARA','MANGALORE','','23','','BATA INDIA LTD','917019488210','','PETLABURGE ROAD','00','','11','575001','Document','100.00','0.00','0.00','0','Document','Surface','1','1.00','','','','','1.00','155.00','1','1','2025-11-04 19:15:27','2025-11-04 19:15:27','17617218175043','17617218175043','','134','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1496','10','1','','2','3406826','2025-11-04','','5675','1457','H SANTHOSH GADIYAR','919844042399','','','BEJAI KAPIKAD','MLR','','11','575004','SHESADRI CASHEWS','919880026642','','AYYAPPANAGAR','KUKKUNDUR','','11','576117','Document','50.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','50.00','1','1','2025-11-04 19:16:14','2025-11-04 19:16:14','17617151801089','17617151801089','','75','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1497','7','1','','2','3395058','2025-11-04','','5667','1458','TRANSLINK','919741055679','','','BAIKAMAPADY','MANGALORE','','11','575011','MAHABOOB BASHA','919886979600','','AZAD  NAGAR','CHITRADURGA','','11','577501','Document','10.00','0.00','0.00','0','Document','Surface','1','0.01','','','','','0.01','60.00','1','1','2025-11-04 19:16:35','2025-11-04 19:16:35','17617199828916','17617199828916','','391','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1498','13','1','','2','3404144','2025-11-04','','5676','1459','MAHADEV TELECOM','918951534339','','','MKT ROAD','','','11','575001','M T STAR','917738633250','','BHIWANIWALA','','','14','400004','Document','10.00','0.00','0.00','0','Document','Surface','1','2.10','','','','','2.10','160.00','1','1','2025-11-04 19:17:13','2025-11-04 19:17:13','17617147018423','17617147018423','','57','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1499','12','1','','2','3382967','2025-11-04','','5677','1460','MANJARI FOODS','919880564474','','','FERRY ROAD','BORARA MANGALORE','','11','575001','SRI VENKATESHWARAPAKING','919731988969','','NO228 2ND MAIN 11TH MAIN','3RD PHASE PEENYA INDL AREA','','11','560058','Parcel','2000.00','0.00','0.00','0','Document','Surface','1','1.13','','','','','1.13','201.00','1','1','2025-11-04 19:17:31','2025-11-04 19:17:31','17617206505387','17617206505387','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1500','7','1','','2','3395059','2025-11-04','','5667','1461','TRANSLINK','919741055679','','','BAIKAMAPADY','MANGALORE','','11','575011','ACID  INDIA','919952965753','','MAIN ROAD','CHENNAI','','23','600095','Document','0.00','0.00','0.00','0','Document','Surface','1','0.01','','','','','0.01','70.00','1','1','2025-11-04 19:17:41','2025-11-04 19:17:41','17617199828916','17617199828916','','1931','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1501','20','1','','2','3418121','2025-11-04','','5678','1462','EKANATH NAYAK','919343342926','','','V T RD','MANAGLORE','','11','575001','SANTHOSH KUMAR','919449477748','','LAXMI NARAYANA NAGAR','SARASWATHI VIDHYA MANDIR','','11','581334','Parcel','500.00','0.00','0.00','0','Document','Surface','1','0.50','','','','','0.50','105.00','1','1','2025-11-04 19:18:01','2025-11-04 19:18:01','17617138462770','17617138462770','','191','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1502','10','1','','2','3406827','2025-11-04','','5675','1463','H SANTHOSH GADIYAR','919844042399','','','BEJAI KAPIKAD','MLR','','11','575004','SHRI SUDHINDRA CASHEWS','918277103867','','BANDIMATA SEETHANADI','NADPAL HEBRI','','11','576112','Document','50.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','50.00','1','1','2025-11-04 19:18:05','2025-11-04 19:18:05','17617151801089','17617151801089','','59','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1503','23','1','','2','3408605','2025-11-04','','5679','1464','BATA INDIA LTD','919845528747','','','PANDESHWAR','MANGALORE','','23','','BATA INDIA LTD','919886284983','','INFANTRY ROAD','00','','583104','','Document','100.00','0.00','0.00','0','Document','Surface','1','1.00','','','','','1.00','155.00','1','1','2025-11-04 19:18:18','2025-11-04 19:18:18','17617218175043','17617218175043','','427','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1504','25','1','','2','3388893','2025-11-04','','5023','496','JAYAKUMAR K','919937373104','','','KANA SURATHKAL','MANGLORE','','26','575014','PRABHAKAR KATIYAR','918240577839','','BHAWAN','GURGAON','','2','122001','Document','100.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','100.00','1','1','2025-11-04 19:18:44','2025-11-04 19:18:44','17617202587270','17617202587270','','2043','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1505','22','1','','2','3411127','2025-11-04','','5680','1465','GLOBAL  TOURS TARVELS','918951511036','','','JAYAVARMA CENTRE','MALLIKATTA MANGALURU','','11','575002','DAIKIN  AIR CONDTIONING  INDIA P LTD','918951923326','','EMBASSY VAJRAM ONYX','DEVARABISANHALLI','','11','560103','Document','100.00','0.00','0.00','0','Document','Surface','1','0.05','','','','','0.05','60.00','1','1','2025-11-04 19:19:12','2025-11-04 19:19:12','17617169725275','17617169725275','','1036','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1506','13','1','','2','3404145','2025-11-04','','5676','1466','MAHADEV TELECOM','918951534339','','','MKT ROAD','','','11','575001','MABENDRA KUMAR','917727952102','','NEAR APSARA TALIES','','','14','400007','Document','10.00','0.00','0.00','0','Document','Surface','1','7.00','','','','','7.00','560.00','1','1','2025-11-04 19:19:17','2025-11-04 19:19:17','17617147018423','17617147018423','','57','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1507','12','1','','2','3382968','2025-11-04','','5681','1467','TECHZONE SERVICES','919072612533','','','JEPPU','MANGALORE','','11','575001','TECHZONE SERVICE','919895765423','','CHALAD ROAD','KOZIKUNNU KANNUR','','12','670001','Parcel','350.00','0.00','0.00','0','Document','Surface','1','0.30','','','','','0.30','120.00','1','1','2025-11-04 19:20:19','2025-11-04 19:20:19','17617206505387','17617206505387','KCM APPLIANCES P LTD','642','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1508','24','1','','2','3399511','2025-11-04','','5425','1468','BRIJESH RAI','919740060633','','','PUMPWELL','MANGALORE','','11','575002','ARJUN SHETTY','918660639699','','SRI DURGA ETC AND WHEEL CARE','GOPALA GOWDA EXT SHIMOGA','','11','577205','Document','0.00','0.00','0.00','0','Document','Surface','1','0.01','','','','','0.01','60.00','1','1','2025-11-04 19:21:07','2025-11-05 10:41:39','17617227102844','17617227102844','','1829','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1509','23','1','','2','3408606','2025-11-04','','5682','1469','M/S DEEPALI TRDAERS','919945886677','','','BUNDER','MANGALORE','','23','','KAMATH PHOVA MILLS','919845207370','','SANOOR','00','','11','574114','Document','100.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','50.00','1','1','2025-11-04 19:21:11','2025-11-04 19:21:11','17617218175043','17617218175043','','75','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1510','22','1','','2','3411128','2025-11-04','','5605','1470','NEW HIMLAYA ROADLINES','919880277995','','','NANTHOOR','MANGALURU','','11','575004','PAWAN NAYAK','917022280415','','SANDHYA ENTERPRISES','JADURASTHE','','11','576117','Document','100.00','0.00','0.00','0','Document','Surface','1','0.05','','','','','0.05','50.00','1','1','2025-11-04 19:21:25','2025-11-04 19:21:25','17617169725275','17617169725275','','75','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1511','10','1','','2','3406828','2025-11-04','','5683','1471','SUPRA LIGHTS','918244258309','','','BEJAI KAPIKAD','MLR','','11','575004','MEHTA ELECTRICALS','919035258405','','HURIOPET','CHIKPET','','11','560053','Document','300.00','0.00','0.00','0','Document','Surface','1','0.25','','','','','0.25','85.00','1','1','2025-11-04 19:22:19','2025-11-04 19:22:19','17617151801089','17617151801089','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1512','13','1','','2','3404146','2025-11-04','','5676','1472','MAHADEV TELECOM','918951534339','','','MKT ROAD','','','11','575001','TOTAL BATTERY','919821608982','','SINGH RAST','KARNAL BAGH','','32','110005','Document','10.00','0.00','0.00','0','Document','Surface','1','3.37','','','','','3.37','1090.00','1','1','2025-11-04 19:22:43','2025-11-04 19:22:43','17617147018423','17617147018423','','1995','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1513','24','1','','2','3399512','2025-11-04','','5425','1473','BRIJESH RAI','919740060633','','','PUMPWELL','MANGALORE','','11','575002','ANWAR SADIQ','919535891099','','DHARMASHASTHA ETC','KAIKAMBA B C ROAD','','11','574219','Document','0.00','0.00','0.00','0','Document','Surface','1','0.01','','','','','0.01','50.00','1','1','2025-11-04 19:22:59','2025-11-04 19:22:59','17617227102844','17617227102844','','1006','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1514','23','1','','2','3408607','2025-11-04','','5684','1474','PAI CO','919620008035','','','BUNDER','','','23','','THE SECRETRY','919539708030','','APMC','BAIKAMPADY','0','11','575001','Document','100.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','35.00','1','1','2025-11-04 19:23:56','2025-11-04 19:23:56','17617218175043','17617218175043','','3453','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1515','22','1','','2','3411129','2025-11-04','','5605','1475','NEW HIMLAYA ROADLINES','919880277995','','','NANTHOOR','MANGALURU','','11','575004','D P MARKETTING','919885741101','','BALAJI ROOF IND','NITTE','','11','574110','Document','100.00','0.00','0.00','0','Document','Surface','1','0.05','','','','','0.05','50.00','1','1','2025-11-04 19:24:14','2025-11-04 19:24:14','17617169725275','17617169725275','','75','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1516','24','1','','2','3399513','2025-11-04','','5425','1476','BRIJESH RAI','919740060633','','','PUMPWELL','MANGALORE','','11','575002','K S NIRANJAN','919448725848','','SEETHA SRI RAMA ETC','VENOOR BELTHANGADY','','11','574242','Document','0.00','0.00','0.00','0','Document','Surface','1','0.01','','','','','0.01','50.00','1','1','2025-11-04 19:24:42','2025-11-04 19:24:42','17617227102844','17617227102844','','1102','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1517','25','1','','2','3388894','2025-11-04','','5685','1477','SUDHINDRA','919962606831','','','SKL','MLR','','11','575014','SCDCC BANK','919353032068','','MLR','','','11','574150','Document','100.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','50.00','1','1','2025-11-04 19:25:24','2025-11-04 19:25:24','17617202587270','17617202587270','KINNIGOLI','781','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1518','13','1','','2','3404147','2025-11-04','','5686','1478','SADGURU ELE','918296621730','','','MKT ROAD','','','11','575001','pro verniyeres','919886402971','','sudhaman nagar','','','11','560027','Document','10.00','0.00','0.00','0','Document','Surface','1','0.66','','','','','0.66','125.00','1','1','2025-11-04 19:25:48','2025-11-04 19:25:48','17617147018423','17617147018423','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1519','22','1','','2','3411130','2025-11-04','','5687','1479','DR NSAM P U COLLEGE','918242224220','','','NANTHOOR','MANGALURU','','11','575004','THE RECEPTIONST','918242222964','','NITTE EDUCTAION TRUST','MAIN ROAD','','11','575018','Document','100.00','0.00','0.00','0','Document','Surface','1','0.35','','','','','0.35','85.00','1','1','2025-11-04 19:26:17','2025-11-04 19:26:17','17617169725275','17617169725275','','3171','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1520','23','1','','2','3408608','2025-11-04','','5688','1480','SABITH FOOTEWEAR','919845032841','','','BUNDER','MANGALORE','','23','','BRITE FOOTWEAR CO','919412271316','','PRAKASH WANTI PALACE','00.','','26','282003','Document','100.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','100.00','1','1','2025-11-04 19:26:31','2025-11-04 19:26:31','17617218175043','17617218175043','','2','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1521','24','1','','2','3399514','2025-11-04','','5425','1481','BRIJESH RAI','919740060633','','','PUMPWELL','MANGALORE','','11','575002','KIRAN A','919591949758','','ULLATHI COMPEX MAIN ROAD','KAKKINJE BELTHANGADY','','11','574228','Document','0.00','0.00','0.00','0','Document','Surface','1','0.01','','','','','0.01','50.00','1','1','2025-11-04 19:26:43','2025-11-04 19:26:43','17617227102844','17617227102844','','2580','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1522','10','1','','2','3406829','2025-11-04','','5689','1482','JYOTHI M','916363779733','','','TVS CREDIT SERVICES LTD','BEJAI KAPIKAD MLR','','11','575004','TVS CREDIT SERVICES LTD','914466123456','','GUINDY','CHENNAI','','23','600032','Document','200.00','0.00','0.00','0','Document','Surface','1','2.40','','','','','2.40','448.00','1','1','2025-11-04 19:27:50','2025-11-04 19:27:50','17617151801089','17617151801089','','1931','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1523','23','1','','2','3408609','2025-11-04','','5690','1483','GAJANA ROADLINES','918244268134','','','BUNDER','MANGALORE','','23','','B T RUBBER GROWES','918256236703','','NEAR BUS STAND','00','','11','575001','Document','100.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','50.00','1','1','2025-11-04 19:28:12','2025-11-04 19:28:12','17617218175043','17617218175043','','3440','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1524','13','1','','2','3404148','2025-11-04','','5691','1484','yogish ele','919845007972','','','mkt','','','23','','skyway interantional','918041519911','','p p lane','','','11','560002','Document','10.00','0.00','0.00','0','Document','Surface','1','0.66','','','','','0.66','125.00','1','1','2025-11-04 19:28:20','2025-11-04 19:28:20','17617147018423','17617147018423','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1525','12','1','','2','3382969','2025-11-04','','5692','1485','INARA MEDICAL','916363211791','','','FALNIR','MANGALORE','','11','575001','SEEMA BANU','918105461973','','MAKAN ROAD','SAKLESHPURA','','11','573134','Document','1000.00','0.00','0.00','0','Document','Surface','1','0.10','','','','','0.10','75.00','1','1','2025-11-04 19:28:24','2025-11-04 19:28:24','17617206505387','17617206505387','','2050','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1526','20','1','','2','3418122','2025-11-04','','5693','1486','JINENDRA KUMAR','919448157788','','','KUDUMAL RANGA RAO RD','MANGALORE','','11','575001','N Y ADHIKARAY','919845518229','','NO 14 SHIRUR PARK RD','SHESHADRIPURAM','','11','560020','Document','0.00','0.00','0.00','0','Document','Surface','1','0.10','','','','','0.10','75.00','1','1','2025-11-04 19:28:46','2025-11-04 19:28:46','17617138462770','17617138462770','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1527','22','1','','2','3411131','2025-11-04','','5694','713','SHETHA','919036797852','','','SAIRADHA MOTORS  BENDOOR','MANGALURU','','11','575002','TVS CREDIT SERVCIES LTD','919446612345','','BRISTOL TOWER','GUINDY','','23','600032','Document','100.00','0.00','0.00','0','Document','Surface','1','1.20','','','','','1.20','208.00','1','1','2025-11-04 19:28:51','2025-11-04 19:28:51','17617169725275','17617169725275','','1931','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1528','24','1','','2','3399515','2025-11-04','','5425','1487','BRIJESH RAI','919740060633','','','PUMPWELL','MANGALORE','','11','575002','SUBASH SHETTY','919611452329','','KOLNADU COMMUNICATION AND ETC','KOLNADU BANTWAL','','11','574323','Document','0.00','0.00','0.00','0','Document','Surface','1','0.01','','','','','0.01','50.00','1','1','2025-11-04 19:28:53','2025-11-04 19:28:53','17617227102844','17617227102844','','783','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1529','23','1','','2','3408610','2025-11-04','','4769','1488','JAYANTHIMALA','919916644540','','','PANDESHWARA','MANGALORE','','11','575001','DHIRN PARAMALE','919845620832','','GUTHIHGAR','00','','11','574218','Document','100.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','50.00','1','1','2025-11-04 19:29:47','2025-11-04 19:29:47','17617218175043','17617218175043','NADUGALLU','2577','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1530','24','1','','2','3399516','2025-11-04','','5425','1489','BRIJESH RAI','919740060633','','','PUMPWELL','MANGALORE','','11','575002','SUDHAKAR RAI','919844989273','','KATTAVU INSURANCE','DARBE PUTTUR','','11','575202','Document','0.00','0.00','0.00','0','Document','Surface','1','0.01','','','','','0.01','50.00','1','1','2025-11-04 19:30:17','2025-11-04 19:30:17','17617227102844','17617227102844','','1904','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1531','13','1','','2','3404149','2025-11-04','','5695','511','INDIAN RED CROSS','918242410787','','','MLR','MLR','','11','575001','ASS DRUG CONTROLLER','','','KNY MLR','MLR','','11','575001','1.','10.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','35.00','1','1','2025-11-04 19:31:02','2025-11-04 19:31:02','17617147018423','17617147018423','','3453','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1532','23','1','','2','3408611','2025-11-04','','4769','1490','JAYANTHIMALA','919916644540','','','PANDESHWARA','MANGALORE','','11','575001','CHITHRANJAN K P','918129551327','','LAKSHMI ANAND','BALLEER ERIYAL','','12','671124','Document','100.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','70.00','1','1','2025-11-04 19:31:26','2025-11-04 19:31:26','17617218175043','17617218175043','','1062','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1533','22','1','','2','3411132','2025-11-04','','5079','573','RDL','919901405540','','','KADRI','LOBO LANE MANAGLURU','','11','575002','DR AIRANI','919945704039','','ADC','MAIN ROAD','','11','581401','Document','100.00','0.00','0.00','0','Document','Surface','1','0.80','','','','','0.80','155.00','1','1','2025-11-04 19:31:32','2025-11-04 19:31:32','17617169725275','17617169725275','','289','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1534','24','1','','2','3399517','2025-11-04','','5425','1491','BRIJESH RAI','919740060633','','','PUMPWELL','MANGALORE','','11','575002','RAGHAVENDRA BHAT','919663117594','','SRI DURGA ETC','BHAVANI COMPLEX MULKY','','11','574154','Document','0.00','0.00','0.00','0','Document','Surface','1','0.01','','','','','0.01','50.00','1','1','2025-11-04 19:31:46','2025-11-04 19:31:46','17617227102844','17617227102844','','744','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1535','23','1','','2','3408612','2025-11-04','','4769','237','JAYANTHIMALA','919916644540','','','PANDESHWARA','MANGALORE','','11','575001','BALACHANDRA','918028015700','','SIVANTOS INDIA PVT LTD','DODDENAKKUNDI','','11','560048','Document','100.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-04 19:32:25','2025-11-04 19:32:25','17617218175043','17617218175043','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1536','24','1','','2','3399518','2025-11-04','','5425','1492','BRIJESH RAI','919740060633','','','PUMPWELL','MANGALORE','','11','575002','SANTHOSH DSOUZA','919844224064','','H H ETC IOCL PUMP','KUTTAR PADAVU','','11','575018','Document','0.00','0.00','0.00','0','Document','Surface','1','0.01','','','','','0.01','50.00','1','1','2025-11-04 19:33:22','2025-11-04 19:33:22','17617227102844','17617227102844','','3171','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1537','22','1','','2','3411133','2025-11-04','','5696','1493','VINDHYA ASSOCIATES','919449770844','','','KULSHEKAR','MANGALURU','','11','575005','AGRICUITURAL SERVICES','916361418032','','DEVELOPMENTS CO OP SCOEITY','MAIN ROAD','','11','581402','Document','100.00','0.00','0.00','0','Document','Surface','1','0.45','','','','','0.45','105.00','1','1','2025-11-04 19:33:40','2025-11-04 19:33:40','17617169725275','17617169725275','','289','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1538','13','1','','2','3404150','2025-11-04','','5695','511','INDIAN RED CROSS','918242410787','','','MLR','MLR','','11','575001','DIST HEALTH WELFARE OFF','','','MLR','MLR','','11','575001','Document','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','35.00','1','1','2025-11-04 19:33:50','2025-11-04 19:33:50','17617147018423','17617147018423','','3453','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1539','23','1','','2','3408613','2025-11-04','','5191','1494','ROOPA ENG CORP','919242783800','','','BUNDER','MANGALORE','','23','','CHENNA MALLIKA PRASAD','918247739707','','ROOPA ENGINE COR','CALICUT ROAD','','11','571111','Document','100.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-04 19:34:00','2025-11-04 19:34:00','17617218175043','17617218175043','','37','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1540','24','1','','2','3399519','2025-11-04','','5425','1495','BRIJESH RAI','919740060633','','','PUMPWELL','MANGALORE','','11','575002','THEJAKSHI P','918722613054','','SRI BALAJI EMMISSION','KARNAD MULKY','','11','574103','Document','0.00','0.00','0.00','0','Document','Surface','1','0.01','','','','','0.01','50.00','1','1','2025-11-04 19:34:47','2025-11-04 19:34:47','17617227102844','17617227102844','','744','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1541','13','1','','2','3404151','2025-11-04','','5695','511','INDIAN RED CROSS','918242410787','','','MLR','MLR','','11','575001','DAPCU','','','DIST PROGRAM OFF','MLR','','11','575001','Document','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','35.00','1','1','2025-11-04 19:35:41','2025-11-04 19:35:41','17617147018423','17617147018423','','3453','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1542','23','1','','2','3408614','2025-11-04','','5697','1496','RAJESH RAO','919591812080','','','KCOGF','PANDESWHARA','','23','','GURUSWAMI','919591812031','','KCOGF LTD','SHIVAJINAGAR','','11','560080','Document','100.00','0.00','0.00','0','Document','Surface','1','0.20','','','','','0.20','85.00','1','1','2025-11-04 19:35:55','2025-11-04 19:35:55','17617218175043','17617218175043','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1543','24','1','','2','3399520','2025-11-04','','5425','1497','BRIJESH RAI','919740060633','','','PUMPWELL','MANGALORE','','11','575002','BHARATH RAJ K','919809087321','','BALAJI ETC PUTTIGE','MOODABIDRE','','11','574253','Document','0.00','0.00','0.00','0','Document','Surface','1','0.01','','','','','0.01','50.00','1','1','2025-11-04 19:36:03','2025-11-04 19:36:03','17617227102844','17617227102844','','3158','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1544','21','1','','2','3393131','2025-11-04','','5698','1498','G 4S SECURE','919591999759','','','ASHOKNAGAR','MLR','','11','575006','SAVITA V B','919535387312','','LAXMI NAGAR','RAJENDRA BULDG','','11','580021','Document','100.00','0.00','0.00','0','Document','Surface','1','0.52','','','','','0.52','125.00','1','1','2025-11-04 19:36:18','2025-11-04 19:36:18','17616388051318','17616388051318','','1125','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1545','22','1','','2','3411134','2025-11-04','','5696','1499','VINDHYA ASSOCIATES','919449770844','','','KULSHEKAR','MANGALURU','','11','575005','KRISSAN AGRI SOLUTIONS','919567452500','','NR  PAKKAUMAR  TEHRATE','CHARUVATHUR','','12','671313','Document','100.00','0.00','0.00','0','Document','Surface','1','0.75','','','','','0.75','140.00','1','1','2025-11-04 19:36:22','2025-11-04 19:36:22','17617169725275','17617169725275','','1062','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1546','10','1','','2','3406830','2025-11-04','','5699','1500','ORGANIC STORE','918660996056','','','MLR','MLR','','11','575002','ANUP','919819469656','','KANDIVALI WEST','MUMBAI','','14','40067','Document','500.00','0.00','0.00','0','Document','Surface','1','0.50','','','','','0.50','170.00','1','1','2025-11-04 19:36:40','2025-11-04 19:36:40','17617151801089','17617151801089','','57','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1547','13','1','','2','3404152','2025-11-04','','5695','511','INDIAN RED CROSS','918242410787','','','MLR','MLR','','11','575001','INDIAN RED CROSS SOC','','','RED CROSS BHAVAN','BLR','','11','560001','Document','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-04 19:37:40','2025-11-04 19:37:40','17617147018423','17617147018423','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1548','10','1','','2','3406831','2025-11-04','','5699','1501','ORGANIC STORE','918660996056','','','MLR','MLR','','11','575002','HARAPANAHALLI','919481231829','','VIVEKANANDANAGAR','GOKUL ROAD','','11','580030','Document','500.00','0.00','0.00','0','Document','Surface','1','0.50','','','','','0.50','105.00','1','1','2025-11-04 19:38:19','2025-11-04 19:38:19','17617151801089','17617151801089','','557','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1549','24','1','','2','3399521','2025-11-04','','5425','1502','BRIJESH RAI','919740060633','','','PUMPWELL','MANGALORE','','11','575002','DINESH UPADHYAYA','918951080715','','PANAMBUR SERVICE STATION','PANAMBUR MANGALORE','','11','575010','Document','0.00','0.00','0.00','0','Document','Surface','1','0.06','','','','','0.06','55.00','1','1','2025-11-04 19:38:22','2025-11-04 19:38:22','17617227102844','17617227102844','','3453','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1550','23','1','','2','3408615','2025-11-04','','5700','1503','DEEPAK','917353551356','','','MUFTI','MANGALORE','','23','','SADAT','918660995741','','CREDO BRANDS MARKETING LTD','COMMERCIAL STREET','','11','','Document','100.00','0.00','0.00','0','Document','Surface','1','0.10','','','','','0.10','75.00','1','1','2025-11-04 19:39:04','2025-11-04 19:39:04','17617218175043','17617218175043','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1551','18','1','','2','3385051','2025-11-04','','5701','1504','MANISH  SHETTY','916361580416','','','KA20AC 6028','MANGALORE','','11','575013','SHREE  COMMUNICTION','919611987286','','SAI  PHOTOGRAPY','MAHANTESH  NAGAR','','11','590016','Document','10.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-04 19:39:33','2025-11-10 13:34:06','17617174764463','17621531273939','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1552','24','1','','2','3399522','2025-11-04','','5425','1505','BRIJESH RAI','919740060633','','','PUMPWELL','MANGALORE','','11','575002','PRABHU AUTO FUELS','919900639494','','INDIAN OIL PUMP','UDUPI','','11','576201','Document','0.00','0.00','0.00','0','Document','Surface','1','0.01','','','','','0.01','50.00','1','1','2025-11-04 19:39:44','2025-11-04 19:39:44','17617227102844','17617227102844','','1639','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1553','10','1','','2','3406832','2025-11-04','','5699','1506','ORGANIC STORE','918660996056','','','MLR','MLR','','11','575002','SHIVAKUMAR NAIK','919206013646','','RR LAYOUT','NAGAVANAHALLI','','11','560056','Document','500.00','0.00','0.00','0','Document','Surface','1','1.00','','','','','1.00','155.00','1','1','2025-11-04 19:40:04','2025-11-04 19:40:04','17617151801089','17617151801089','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1554','13','1','','2','3404153','2025-11-04','','5695','511','INDIAN RED CROSS','918242410787','','','MLR','MLR','','11','575001','GRUGE CONTROLLER','','','PALACE RD','BLR','','11','560001','Document','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-04 19:40:28','2025-11-04 19:40:28','17617147018423','17617147018423','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1555','24','1','','2','3399523','2025-11-04','','5425','1507','BRIJESH RAI','919740060633','','','PUMPWELL','MANGALORE','','11','575002','DAMODHAR KULAL','919448624589','','SRI MATHA ETC SAHAKARI SANGA','KALLARE DARBE','','11','574202','Document','0.00','0.00','0.00','0','Document','Surface','1','0.01','','','','','0.01','50.00','1','1','2025-11-04 19:41:06','2025-11-04 19:41:06','17617227102844','17617227102844','','1904','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1556','10','1','','2','3406833','2025-11-04','','5699','1508','ORGANIC STORE','918660996056','','','MLR','MLR','','11','575002','T MALLIKARJUNA','919884596087','','SRINAGAR COLONY','MEDICAL COLLEGE ROAD','','23','613004','Document','1000.00','0.00','0.00','0','Document','Surface','1','2.00','','','','','2.00','352.00','1','1','2025-11-04 19:41:52','2025-11-04 19:41:52','17617151801089','17617151801089','','1854','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1557','22','1','','2','3411135','2025-11-04','','5193','1509','SHAPE LAB','919342658867','','','BALMATTA','MANGALURU','','11','575002','I CARE OPTICALS','919108847191','','SDM MEDICAL HOSPITAL','SATTUR','','11','580009','Document','100.00','0.00','0.00','0','Document','Surface','1','0.65','','','','','0.65','125.00','1','1','2025-11-04 19:41:59','2025-11-04 19:41:59','17617169725275','17617169725275','','379','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1558','24','1','','2','3399524','2025-11-04','','5425','1510','BRIJESH RAI','919740060633','','','PUMPWELL','MANGALORE','','11','575002','DEEKSHITH KUMAR','917996895446','','SAMRUDDHI ETC','KADABA','','11','574230','Document','0.00','0.00','0.00','0','Document','Surface','1','0.01','','','','','0.01','50.00','1','1','2025-11-04 19:42:40','2025-11-04 19:42:40','17617227102844','17617227102844','','3411','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1559','13','1','','2','3404154','2025-11-04','','5048','1511','APPOLO PHARMA','','','','CAR ST','MLR','','11','575001','APPOLO PHARMA','919986921425','','HEAD POST OFF RD','KMT','','11','581343','Document','0.00','0.00','0.00','0','Document','Surface','1','0.36','','','','','0.36','105.00','1','1','2025-11-04 19:43:06','2025-11-04 19:43:06','17617147018423','17617147018423','','165','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1560','22','1','','2','3411136','2025-11-04','','5193','1513','SHAPE LAB','919342658867','','','BALMATTA','MANGALURU','','11','575002','I CARE OPTICALS','917483732352','','OPP KSRETC','MAIN ROAD','','11','574214','Document','100.00','0.00','0.00','0','Document','Surface','1','0.25','','','','','0.25','75.00','1','1','2025-11-04 19:43:27','2025-11-04 19:43:27','17617169725275','17617169725275','','2580','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1561','23','1','','2','3408616','2025-11-04','','5702','1515','BIBIN JOSE','919448047385','','','HAMPANKATTA','MANGALORE','','23','','VIPIN JOSEPJ C J','917026701357','','KANNAMALY P O','CHIRAMEL','','12','682008','Document','100.00','0.00','0.00','0','Document','Surface','1','0.35','','','','','0.35','120.00','1','1','2025-11-04 19:43:36','2025-11-04 19:43:36','17617218175043','17617218175043','','2432','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1562','18','1','','2','3385052','2025-11-04','','5701','1516','MANISH  SHETTY','916361580416','','','KA20AC 6028','MANGALORE','','11','575013','SRI KANNA  LORRY  BOOKING','919786025652','','PADUR  PODIAPURAM','TUTICORENI','','23','628002','Laptop','10.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','70.00','1','1','2025-11-04 19:43:58','2025-12-05 14:48:14','17617174764463','17621531273939','','1635','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1563','24','1','','2','3399525','2025-11-04','','5425','1517','BRIJESH RAI','919740060633','','','PUMPWELL','MANGALORE','','11','575002','ROOPALATHA SHETTY','917022711915','','ROHINI FUELS AND ETC','KARAVALI JN UDUPI','','11','576101','Document','0.00','0.00','0.00','0','Document','Surface','1','0.01','','','','','0.01','50.00','1','1','2025-11-04 19:44:05','2025-11-04 19:44:05','17617227102844','17617227102844','','1639','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1564','12','1','','2','3382970','2025-11-04','','5176','1518','SRI LAKSHMI ENTERFRISES','919364089125','','','WEST GATE ETERNA','MARNAMIKATTA MANGALORE','','11','575001','VEENA NARASIMHA GOWDA','917760399928','','HARUMULE','KODANI HONNAVARA','','11','581423','Document','1000.00','0.00','0.00','0','Document','Surface','1','0.29','','','','','0.29','105.00','1','1','2025-11-04 19:45:13','2025-11-04 19:45:13','17617206505387','17617206505387','','191','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1565','13','1','','2','3404155','2025-11-04','','4788','511','M BABA PAI','918242496499','','','CARSTREET','MANGALORE','','11','575001','IDEAL TRA','','','BOLOOR','MLR','','11','575003','Document','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','35.00','1','1','2025-11-04 19:45:23','2025-11-04 19:45:23','17617147018423','17617147018423','','3453','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1566','24','1','','2','3399526','2025-11-04','','5425','1519','BRIJESH RAI','919740060633','','','PUMPWELL','MANGALORE','','11','575002','CHETHAN SRI GOPALKRISHNA ETC','919880875666','','NOORA COMPLEX','FARANGIPETE','','11','574143','Document','0.00','0.00','0.00','0','Document','Surface','1','0.01','','','','','0.01','50.00','1','1','2025-11-04 19:45:27','2025-11-04 19:45:27','17617227102844','17617227102844','','3190','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1567','22','1','','2','3411137','2025-11-04','','5193','1520','SHAPE LAB','919342658867','','','BALMATTA','MANGALURU','','11','575002','I CARE OPTICALS','917349675158','','SDM SYUR HOSPITAL','KUMBALGODU','','11','560074','Document','100.00','0.00','0.00','0','Document','Surface','1','0.35','','','','','0.35','105.00','1','1','2025-11-04 19:45:34','2025-11-04 19:45:34','17617169725275','17617169725275','','1036','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1568','20','1','','2','3418123','2025-11-04','','5703','1521','DR LAWERENCE U FERNADES','919449102115','','','SAHYADRI COLLEGE OF ENGG','MANGALORE','','11','575001','THE DEAN','919449102115','','MALNAD COLLEGE OF ENGINEERING','SALGAME RD','','11','573202','Document','0.00','0.00','0.00','0','Document','Surface','1','0.10','','','','','0.10','75.00','1','1','2025-11-04 19:45:56','2025-11-04 19:45:56','17617138462770','17617138462770','','448','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1569','22','1','','2','3411138','2025-11-04','','5193','747','SHAPE LAB','919342658867','','','BALMATTA','MANGALURU','','11','575002','I CARE OPTICALS','918971716178','','OPP  PADIVALS HOTEL','HANUMAN TEMPLE ROAD','','11','574227','Document','100.00','0.00','0.00','0','Document','Surface','1','0.10','','','','','0.10','65.00','1','1','2025-11-04 19:46:55','2025-11-04 19:46:55','17617169725275','17617169725275','','1731','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1570','10','1','','2','3406834','2025-11-04','','5704','1522','SANTHOSH SHETTY','919865773131','','','UDUPI','UDP','','11','576101','ACCOCIATED ROAD CARRIERS LTD','917995000601','','SN HIGH ROAD','SRIPURAM','','23','627001','Document','50.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','70.00','1','1','2025-11-04 19:46:59','2025-11-04 19:46:59','17617151801089','17617151801089','','2060','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1571','23','1','','2','3408617','2025-11-04','','5705','1523','POLICE SUB INSPECTOR','919535931034','','','POLICE FOREST MOBILE SQUAD','MANGALORE','','23','','SUPE OF POLICE','919741819080','','CID FOREST CELL','NEAR VIJAYA VINAYAKA TEMPLE','','11','571201','Document','0.00','0.00','0.00','0','Document','Surface','1','0.25','','','','','0.25','85.00','1','1','2025-11-04 19:47:02','2025-11-04 19:47:02','17617218175043','17617218175043','','332','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1572','12','1','','2','3382971','2025-11-04','','5176','1524','SRI LAKSHMI ENTERFRISES','919364089125','','','WEST GATE ETERNA','MARNAMIKATTA MANGALORE','','11','575001','MAHESH','918277234911','','SANTHALLI POST','SOMWARPET','','11','571236','Document','1000.00','0.00','0.00','0','Document','Surface','1','0.17','','','','','0.17','85.00','1','1','2025-11-04 19:47:29','2025-11-04 19:47:29','17617206505387','17617206505387','','2335','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1573','24','1','','2','3399527','2025-11-04','','5425','1525','BRIJESH RAI','919740060633','','','PUMPWELL','MANGALORE','','11','575002','GOPAL POOJARY','919739768762','','ADDHYA ETC SAIBARAKATTE','UDUPI','','11','576101','Document','0.00','0.00','0.00','0','Document','Surface','1','0.01','','','','','0.01','50.00','1','1','2025-11-04 19:47:33','2025-11-04 19:47:33','17617227102844','17617227102844','','1639','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1574','13','1','','2','3404156','2025-11-04','','5048','1526','HDB FINANCIAL','','','','CAR ST MLR','MLR','','11','575001','SATHISH','919164242102','','HDB FINANCIAL','R G RD','','11','577101','Document','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-04 19:47:37','2025-11-04 19:47:37','17617147018423','17617147018423','','696','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1575','20','1','','2','3418124','2025-11-04','','5706','93','SUSHMITHA SHETTY','919741211791','','','MATRIX AUTO','KODILABIL','','11','575001','ABHIJEET','919620422492','','IDFC FIRST BANK','SARASWATHIPURAM MYSORE','','11','','Document','0.00','0.00','0.00','0','Document','Surface','1','0.44','','','','','0.44','105.00','1','1','2025-11-04 19:47:53','2025-11-04 19:47:53','17617138462770','17617138462770','','669','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1576','22','1','','2','3411139','2025-11-04','','5193','1527','SHAPE LAB','919342658867','','','BALMATTA','MANGALURU','','11','575002','I  CARE OPTICALS','918861930394','','B M ROAD','THANIREUHALLA','','11','573201','Document','100.00','0.00','0.00','0','Document','Surface','1','0.05','','','','','0.05','60.00','1','1','2025-11-04 19:48:40','2025-11-04 19:48:40','17617169725275','17617169725275','','448','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1577','10','1','','2','3406835','2025-11-04','','5704','1528','SANTHOSH SHETTY','919865773131','','','UDUPI','UDP','','11','576101','RANJITYH KUMAR MG','919035842708','','SRI INDRA TRANSPORT','CHIKKABALLAPUR','','11','562101','Document','100.00','0.00','0.00','0','Document','Surface','1','0.32','','','','','0.32','105.00','1','1','2025-11-04 19:48:49','2025-11-04 19:48:49','17617151801089','17617151801089','','1070','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1578','24','1','','2','3399528','2025-11-04','','5425','1529','BRIJESH RAI','919740060633','','','PUMPWELL','MANGALORE','','11','575002','PRADEEP KUMAR','919686793508','','B PLEASENT ETC','SIDDAPURA','','11','576229','Document','0.00','0.00','0.00','0','Document','Surface','1','0.01','','','','','0.01','50.00','1','1','2025-11-04 19:49:02','2025-11-04 19:49:02','17617227102844','17617227102844','','1588','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1579','22','1','','2','3411140','2025-11-04','','5193','741','SHAPE LAB','919342658867','','','BALMATTA','MANGALURU','','11','575002','I CARE OPTICALS','918861511921','','SDM EYE HOSPITAL','MAIN ROAD','','11','574214','Document','100.00','0.00','0.00','0','Document','Surface','1','0.05','','','','','0.05','50.00','1','1','2025-11-04 19:49:52','2025-11-04 19:49:52','17617169725275','17617169725275','','3440','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1580','13','1','','2','3404157','2025-11-04','','5707','1530','RAJESH KUDVA','919900919377','','','CAR ST','MLR','','11','575001','KESHAVA BHAT','919845061565','','SADASHIVA NAGAR','BLR','','11','560003','Document','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-04 19:49:57','2025-11-04 19:49:57','17617147018423','17617147018423','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1581','20','1','','2','3418125','2025-11-04','','4879','1531','KUDLA MEDICALS','919740558496','','','BALMATA NEW ROAD','MANGALORE','','11','575001','GOWRI POOJARY','919591336633','','GURU NAGAR SATHR MKT','SHIRURU','','11','576228','Parcel','2549.00','0.00','0.00','0','Document','Surface','1','0.10','','','','','0.10','65.00','1','1','2025-11-04 19:50:09','2025-11-04 19:50:09','17617138462770','17617138462770','','1639','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1582','24','1','','2','3399529','2025-11-04','','5425','1532','BRIJESH RAI','919740060633','','','PUMPWELL','MANGALORE','','11','575002','RATHAN KUMAR','917022282196','','GYAN ENTERPRISES AND ETC','HALEANGADY-','','11','574146','Document','0.00','0.00','0.00','0','Document','Surface','1','0.01','','','','','0.01','50.00','1','1','2025-11-04 19:50:26','2025-11-04 19:50:26','17617227102844','17617227102844','','3392','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1583','10','1','','2','3406836','2025-11-04','','5211','1533','KCMA','918242223287','','','BEJAI KAPIKAD','MLR','','11','575004','TOINEHA ENTERPRISES','919994561234','','CHANDBOLE BAZAR','JAIPUR','','21','302001','Document','200.00','0.00','0.00','0','Document','Surface','1','0.31','','','','','0.31','170.00','1','1','2025-11-04 19:51:23','2025-11-04 19:51:23','17617151801089','17617151801089','','455','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1584','22','1','','2','3411141','2025-11-04','','5193','1534','SHAPE LAB','919342658867','','','BALMATTA','MANGALURU','','11','575002','I  CARE OPTICALS','918242457988','','SDM AYUR COLLEGE','UDYAVARA','','11','576105','Document','100.00','0.00','0.00','0','Document','Surface','1','0.05','','','','','0.05','50.00','1','1','2025-11-04 19:51:29','2025-11-04 19:51:29','17617169725275','17617169725275','','1639','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1585','24','1','','2','3399530','2025-11-04','','5425','1535','BRIJESH RAI','919740060633','','','PUMPWELL','MANGALORE','','11','575002','SANTHOSH KUMAR','919740167315','','BENAKA ETC','KADABA','','11','574221','Document','0.00','0.00','0.00','0','Document','Surface','1','0.01','','','','','0.01','50.00','1','1','2025-11-04 19:52:05','2025-11-04 19:52:05','17617227102844','17617227102844','','3411','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1586','13','1','','2','3404158','2025-11-04','','5048','1536','dr manjunath kamath','','','','CARSTREET','MANGALORE','','11','575001','MOHAMMED ZAHEEL UDDIN','918688295550','','BAHADURPURA','HYDERBAD','','1','500064','Document','0.00','0.00','0.00','0','Document','Surface','1','0.15','','','','','0.15','100.00','1','1','2025-11-04 19:52:23','2025-11-04 19:52:23','17617147018423','17617147018423','','117','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1587','20','1','','2','3418126','2025-11-04','','4879','1537','KUDLA MEDICALS','919740558496','','','BALMATA NEW ROAD','MANGALORE','','11','575001','SUDHEER','919964025927','','BHARATH SINGH MARG','KINNIMULKI','','11','576101','Parcel','5379.00','0.00','0.00','0','Document','Surface','1','0.40','','','','','0.40','85.00','1','1','2025-11-04 19:52:37','2025-11-04 19:52:37','17617138462770','17617138462770','','1639','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1588','10','1','','2','3406837','2025-11-04','','5211','1538','KCMA','918242223287','','','BEJAI KAPIKAD','MLR','','11','575004','KANDOI BHOGILAL MULCHAND','919994651234','','KANDOI OLE','MANCK CHOCK','','7','380001','Document','200.00','0.00','0.00','0','Document','Surface','1','0.25','','','','','0.25','130.00','1','1','2025-11-04 19:53:18','2025-11-04 19:53:18','17617151801089','17617151801089','','3','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1589','22','1','','2','3411142','2025-11-04','','5708','1539','VEDAMAYYU AYUR MULTI SPL HOSPITAL','918242212956','','','PADAVU HIGH SCHOOL ROAD','MANGALURU','','11','575004','VIJAYANANDAN M NAIK','911815020355','','MELINA MANE','30 325   POST','','11','574221','Document','100.00','0.00','0.00','0','Document','Surface','1','1.80','','','','','1.80','245.00','1','1','2025-11-04 19:53:58','2025-11-04 19:53:58','17617169725275','17617169725275','','3411','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1590','24','1','','2','3399531','2025-11-04','','5425','1540','BRIJESH RAI','919740060633','','','PUMPWELL','MANGALORE','','11','575002','NAGRAJ MAIYA','919741595878','','MULLIKATTE','KUNDAPURA','','11','576247','Document','0.00','0.00','0.00','0','Document','Surface','1','0.01','','','','','0.01','50.00','1','1','2025-11-04 19:54:04','2025-11-04 19:54:04','17617227102844','17617227102844','SUBRAHMANYA ENTERPRISES','1588','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1591','10','1','','2','3406838','2025-11-04','','5211','1541','KCMA','918242223287','','','BEJAI KAPIKAD','MLR','','11','575004','SANJAY BROTHERS','919991234654','','SIYANGANJ','INDORE','','13','452001','Document','200.00','0.00','0.00','0','Document','Surface','1','0.25','','','','','0.25','130.00','1','1','2025-11-04 19:55:11','2025-11-04 19:55:11','17617151801089','17617151801089','','558','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1592','13','1','','2','3404159','2025-11-04','','5709','1542','KARTHI KUMAR','919740076130','','','CARST','MLR','','11','575001','RAKESH KUMAR B S','919740515468','','KATHEGUPPA','BLR','','11','560085','Document','0.00','0.00','0.00','0','Document','Surface','1','0.10','','','','','0.10','80.00','1','1','2025-11-04 19:55:22','2025-11-04 19:55:22','17617147018423','17617147018423','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1593','24','1','','2','3399532','2025-11-04','','5425','1543','BRIJESH RAI','919740060633','','','PUMPWELL','MANGALORE','','11','575002','VITTAL RAI','919449639126','','SHWETHA XEROX AND ETC','ISHWARAMANGALA PUTTUR','','11','574313','Document','0.00','0.00','0.00','0','Document','Surface','1','0.01','','','','','0.01','50.00','1','1','2025-11-04 19:55:49','2025-11-04 19:55:49','17617227102844','17617227102844','','1904','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1594','20','1','','2','3418127','2025-11-04','','5710','1544','POPULAR AUTO DEALERS','919972724840','','','KODILABIL','MANGALORE','','11','575001','POPULAR AUTO DEALERS','916364897579','','PLOT NO 118 1ST CROSS','AUTO COMPLEX','','11','577204','Document','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-04 19:55:53','2025-11-04 19:55:53','17617138462770','17617138462770','','1829','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1595','10','1','','2','3406839','2025-11-04','','5211','1545','KCMA','918242223287','','','BEJAI KAPIKAD','MLR','','11','575004','GANESH&CO','919998563214','','BAROHJI KA RASTRA','JAIPUR','','21','302001','Document','100.00','0.00','0.00','0','Document','Surface','1','0.18','','','','','0.18','130.00','1','1','2025-11-04 19:56:51','2025-11-04 19:56:51','17617151801089','17617151801089','','455','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1596','18','1','','2','3385053','2025-11-04','','5711','1546','SRI  GAJANANA  TRADERS','919448143878','','','C F A','MANGALORE  23','','11','575015','CALEB  RAJKUMAR','917338816602','','SCM','MYLAPORE  CHENNAI','','23','','Document','10.00','0.00','0.00','0','Document','Surface','1','0.20','','','','','0.20','70.00','1','1','2025-11-04 19:57:22','2025-11-04 19:57:22','17617174764463','17617174764463','','3453','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1597','20','1','','2','3418128','2025-11-04','','5206','1547','LALITHA JEWELLERY','918242497788','','','PVS','','','11','575003','ARUN','914428349860','','LALITHA JEWELLORY MART PLTD','HABIBULLAH RD T NAGAR','','23','600017','Document','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','70.00','1','1','2025-11-04 19:57:48','2025-11-04 19:57:48','17617138462770','17617138462770','','1931','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1598','18','1','','2','3385054','2025-11-04','','5767','1625','MANGALORE  EARTHMOVERS','917795000600','','','HOTEL  RATHANA KULUR','MANGALORE','','11','575013','MOHAMMED  RAFEE','918148923699','','SMR  ENTEREPRESS','ALTHUR  PALKADA','','12','678543','Document','10.00','0.00','0.00','0','Document','Surface','1','0.45','','','','','0.45','120.00','1','1','2025-11-04 19:58:02','2025-11-05 11:06:05','17617174764463','17617174764463','','276','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1599','13','1','','2','3404160','2025-11-04','','5712','1548','JAYARAJ RAI','919449283093','','','P M RAO RD','MLR','','11','575001','RAJARAM SOORYAMBAIL','919845928053','','NEW AGARWAL','VYALIKAVAL','','11','560085','Document','0.00','0.00','0.00','0','Document','Surface','1','0.60','','','','','0.60','130.00','1','1','2025-11-04 19:58:24','2025-11-04 19:58:24','17617147018423','17617147018423','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1600','10','1','','2','3406840','2025-11-04','','5211','1549','KCMA','918242223287','','','BEJAI KAPIKAD','MLR','','11','575004','SAI P RAJ&SONS','919996321265','','RAMGANJ NAYAGANJ','KANPUR','','26','208001','Document','100.00','0.00','0.00','0','Document','Surface','1','0.25','','','','','0.25','130.00','1','1','2025-11-04 19:59:09','2025-11-04 19:59:09','17617151801089','17617151801089','','458','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1601','24','1','','2','3399533','2025-11-04','','5425','1550','BRIJESH RAI','919740060633','','','PUMPWELL','MANGALORE','','11','575002','DINAKAR KULAL','917795104973','','VIGNESH AUTO WORKS','KANNUR MANGALORE','','11','575007','Document','0.00','0.00','0.00','0','Document','Surface','1','0.01','','','','','0.01','50.00','1','1','2025-11-04 19:59:43','2025-11-04 19:59:43','17617227102844','17617227102844','','3146','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1602','10','1','','2','3406841','2025-11-04','','5211','1551','KCMA','918242223287','','','BEJAI KAPIKAD','MLR','','11','575004','GANDHI KANTILAL CHIMANLAL','919996325654','','SARDAR MARKET YARD','HATHIKANA','','26','208002','Document','150.00','0.00','0.00','0','Document','Surface','1','0.25','','','','','0.25','130.00','1','1','2025-11-04 20:00:41','2025-11-04 20:00:41','17617151801089','17617151801089','','1936','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1603','13','1','','2','3404161','2025-11-04','','5713','1552','SAPNA SAREE','919945449035','','','MKT RD','MLR','','11','575001','AJANTHA SILKS MILLS','919377937241','','RING RD','SRT','','7','365002','Document','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','100.00','1','1','2025-11-04 20:00:42','2025-11-04 20:00:42','17617147018423','17617147018423','','163','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1604','20','1','','2','3418129','2025-11-04','','5714','1553','PRAJWAL PURANIK','918242492275','','','SRCC HO','BUNST HOSTEL CIRCEL','','11','575003','ASHWINI UPADHYA','917875393013','','ANANADAMAYA','RAJATHAGIRI SUBHASH NAGAR','','11','574105','Document','0.00','0.00','0.00','0','Document','Surface','1','0.23','','','','','0.23','75.00','1','1','2025-11-04 20:00:43','2025-11-04 20:00:43','17617138462770','17617138462770','','1639','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1605','23','1','','2','3408618','2025-11-04','','5715','1554','LISA MATHIAS','919448383144','','','LOWER BENDOOR','MANGALORE','','23','','DR DIPTI MATHAIS','919663070406','','ST JOHN BAPTIST ROAD','BANDRA WEST','','14','400050','Document','100.00','0.00','0.00','0','Document','Surface','1','3.72','','','','','3.72','1170.00','1','1','2025-11-04 20:00:44','2025-11-04 20:00:44','17617218175043','17617218175043','GLAXO ASHIANA APART','57','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1606','24','1','','2','3399534','2025-11-04','','5425','1555','BRIJESH RAI','919740060633','','','PUMPWELL','MANGALORE','','11','575002','ROHIT KUMAR','918431849834','','SRI MATHA ETC','SURATHKAL MANGALORE','','11','575030','Document','0.00','0.00','0.00','0','Document','Surface','1','0.01','','','','','0.01','50.00','1','1','2025-11-04 20:01:01','2025-11-04 20:01:01','17617227102844','17617227102844','','3211','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1607','24','1','','2','3399535','2025-11-04','','5425','1556','BRIJESH RAI','919740060633','','','PUMPWELL','MANGALORE','','11','575002','ATHAULLAH D','917022470655','','UNITED AUTO CARS AND ETC','UPPINANGADY','','11','574241','Document','0.00','0.00','0.00','0','Document','Surface','1','0.01','','','','','0.01','50.00','1','1','2025-11-04 20:02:26','2025-11-04 20:02:26','17617227102844','17617227102844','','2352','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1608','13','1','','2','3404162','2025-11-04','','5713','1557','SAPNA SAREE','919945449035','','','MKT RD','MLR','','11','575001','JYOTHI AGE','919327676049','','RING RD','SRT','','7','395002','Document','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','100.00','1','1','2025-11-04 20:02:29','2025-11-04 20:02:29','17617147018423','17617147018423','','163','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1609','10','1','','2','3406842','2025-11-04','','5211','1558','KCMA','918242223287','','','BEJAI KAPIKAD','MLR','','11','575004','MS FOODS','919663632145','','CHANDPOLE','BORDIKE KUEKA RASTA','','21','302001','Document','100.00','0.00','0.00','0','Document','Surface','1','0.31','','','','','0.31','170.00','1','1','2025-11-04 20:02:38','2025-11-04 20:02:38','17617151801089','17617151801089','','455','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1610','23','1','','2','3408619','2025-11-04','','5715','1554','LISA MATHIAS','919448383144','','','LOWER BENDOOR','MANGALORE','','23','','DR DIPTI MATHAIS','919663070406','','ST JOHN BAPTIST ROAD','BANDRA WEST','','14','400050','Document','100.00','0.00','0.00','0','Document','Surface','1','15.00','','','','','15.00','2475.00','1','1','2025-11-04 20:03:19','2025-11-04 20:03:19','17617218175043','17617218175043','','57','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1611','10','1','','2','3406843','2025-11-04','','5211','1559','KCMA','918242223287','','','BEJAI KAPIKAD','MLR','','11','575004','GANESH ENTERPRISES','919663621326','','DEENANATHJIKI GALI','JAIPUR','','21','302001','Document','100.00','0.00','0.00','0','Document','Surface','1','0.37','','','','','0.37','170.00','1','1','2025-11-04 20:04:22','2025-11-04 20:04:22','17617151801089','17617151801089','','455','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1612','13','1','','2','3404163','2025-11-04','','5716','1560','SHALIMAR DRESS','918242427116','','','MKT RD','MLR','','11','575001','ARIHANT APP','919850043383','','ADGON CIRCLR','AMD','','7','380016','Document','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','100.00','1','1','2025-11-04 20:04:34','2025-11-04 20:04:34','17617147018423','17617147018423','','3','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1613','20','1','','2','3418130','2025-11-04','','5717','1561','KP RAGHUCANDRA RA RAO','919448072937','','','GANDHI NAGAR','KAVOOR','','11','575001','RAMESH PS','919008951471','','VASU LAYOUT','RAMAKRISHNA NAGAR','','11','570023','Parcel','1200.00','0.00','0.00','0','Document','Surface','1','10.00','','','','','10.00','1100.00','1','1','2025-11-04 20:05:28','2025-11-04 20:05:28','17617138462770','17617138462770','','669','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1614','10','1','','2','3406844','2025-11-04','','5211','1562','KCMA','918242223287','','','BEJAI KAPIKAD','MLR','','11','575004','JAGDISH KUMAR VARLANI','919036523651','','SANJAY BROTHERS','SIYAGANJ','','13','452001','Document','100.00','0.00','0.00','0','Document','Surface','1','0.47','','','','','0.47','170.00','1','1','2025-11-04 20:05:50','2025-11-04 20:05:50','17617151801089','17617151801089','','558','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1615','22','1','','2','3411143','2025-11-04','','5718','1563','PRECISE INTERORS','919448482883','','','KADRI','MANGALURU','','11','575002','THE AGM MANAGER','919495233405','','CANARA BANK   CO GENERAL  SETION','WEST NADAKKAVU','','12','673011','Document','100.00','0.00','0.00','0','Document','Surface','1','0.20','','','','','0.20','95.00','1','1','2025-11-04 20:05:57','2025-11-04 20:05:57','17617169725275','17617169725275','','112','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1616','24','1','','2','3399536','2025-11-04','','5182','93','SUSMITHA','919606809597','','','IDFC BANK LTD,','KANKANADY , MANGALORE -','','11','575002','ABHIJEET','919620422492','','IDFC FIRST BANK','SARASWATHIPURAM MYSORE','','11','575009','Document','0.00','0.00','0.00','0','Document','Surface','1','1.47','','','','','1.47','247.00','1','1','2025-11-04 20:07:07','2025-11-04 20:07:07','17617227102844','17617227102844','','669','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1617','13','1','','2','3404164','2025-11-04','','5165','511','SRINIVAS HOSPITAL','918242478586','','','MANGALOARE','','','11','575001','INSPECTORE OF EXCISE','','','MARY HILL','MLR','','11','575001','Document','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','35.00','1','1','2025-11-04 20:07:12','2025-11-04 20:07:12','17617147018423','17617147018423','','3453','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1618','10','1','','2','3406845','2025-11-04','','5211','511','KCMA','918242223287','','','BEJAI KAPIKAD','MLR','','11','575004','GIRISH NAYAK','','','SRI MAHALASA ENT','CHAMARAJPET','','11','560018','Document','100.00','0.00','0.00','0','Document','Surface','1','0.32','','','','','0.32','105.00','1','1','2025-11-04 20:07:13','2025-11-04 20:07:13','17617151801089','17617151801089','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1619','18','1','','2','3385055','2025-11-04','','5721','1566','SHEKAR','919164347756','','','IOCL','PANAMBUR  99','','11','575010','KAMALA','919611234434','','COOLL  JOINT FAST FOOD','4TH  BLOCK  JAYANAGAR BANGALORE','','11','560010','Document','0.10','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-04 20:07:17','2025-11-04 20:07:17','17617174764463','17617174764463','','2043','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1620','22','1','','2','3411144','2025-11-04','','5718','1567','PRECISE INTERORS','919448482883','','','KADRI','MANGALURU','','11','575002','THE AG M','919495233440','','UNION BANK OF INDIA   RO','NR HIGH COURT','','11','585103','Document','100.00','0.00','0.00','0','Document','Surface','1','0.20','','','','','0.20','85.00','1','1','2025-11-04 20:07:30','2025-11-04 20:07:30','17617169725275','17617169725275','','445','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1621','10','1','','2','3406846','2025-11-04','','5211','1568','KCMA','918242223287','','','BEJAI KAPIKAD','MLR','','11','575004','GOKUL G SONS','919032132653','','KATRA ISHWAR BHAVAN','KHARI BOALI','','32','110006','Document','100.00','0.00','0.00','0','Document','Surface','1','0.30','','','','','0.30','170.00','1','1','2025-11-04 20:09:15','2025-11-04 20:09:15','17617151801089','17617151801089','','1995','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1622','13','1','','2','3404165','2025-11-04','','5168','1569','A R ARAO','918242425966','','','GHS ROAD','MANGALAORE','','11','575001','NARESH SHENOY','919880714931','','CHARANTHIPET','MKY','','11','574154','Document','0.00','0.00','0.00','0','Document','Surface','1','1.00','','','','','1.00','105.00','1','1','2025-11-04 20:09:35','2025-11-04 20:09:35','17617147018423','17617147018423','','744','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1623','24','1','','2','3399537','2025-11-04','','5722','1570','YASHWIN','919663291593','','','KANNUR','MANGALORE','','11','575007','NISHMITHA','917795182843','','ARYANS HOME PG FOR LADIES','NAGAWARA, BANGALORE','','11','560045','Document','0.00','0.00','0.00','0','Document','Surface','1','0.40','','','','','0.40','110.00','1','1','2025-11-04 20:10:27','2025-11-04 20:10:27','17617227102844','17617227102844','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1624','13','1','','2','3404166','2025-11-04','','5168','1571','A R ARAO','918242425966','','','GHS ROAD','MANGALAORE','','11','575001','HARISH SHENOY','919444869252','','CHARANTHIPET','MKY','','11','574154','Document','0.00','0.00','0.00','0','Document','Surface','1','1.50','','','','','1.50','175.00','1','1','2025-11-04 20:11:52','2025-11-04 20:11:52','17617147018423','17617147018423','','744','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1625','24','1','','2','3399538','2025-11-04','','5723','93','WEST COAST','919513353898','','','KANKANADY','MANGALORE','','11','575002','ABHIJEET','919620422492','','IDFC FIRST BANK','SARASWATHIPURAM MYSORE','','11','570009','Document','0.00','0.00','0.00','0','Document','Surface','1','0.01','','','','','0.01','60.00','1','1','2025-11-04 20:12:37','2025-11-04 20:12:37','17617227102844','17617227102844','','669','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1626','18','1','','2','3385056','2025-11-04','','5724','1572','MAMATHA ANIL','919241142474','','','K I O C L','PANABUR  99','','11','575015','PRANAMYA ANIL','917406502484','','VINODINI  HOSTEL','MALAVIYA  MNIT','','21','302017','Document','10.00','0.00','0.00','0','Document','Surface','1','0.45','','','','','0.45','170.00','1','1','2025-11-04 20:13:20','2025-11-04 20:13:20','17617174764463','17617174764463','','2040','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1627','10','1','','2','3406847','2025-11-04','','5211','1573','KCMA','918242223287','','','BEJAI KAPIKAD','MLR','','11','575004','SATHISH KUMAR&BROS','919996323214','','KATRA ISHWAR BHAVAN','KHARI BOLAI','','32','110006','Document','100.00','0.00','0.00','0','Document','Surface','1','0.30','','','','','0.30','170.00','1','1','2025-11-04 20:14:20','2025-11-04 20:14:20','17617151801089','17617151801089','','1995','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1628','24','1','','2','3399539','2025-11-04','','5725','1574','NFORCE INFRASCTURE INDIA','919845081878','','','KANKANADY','MANGALORE -  02','','11','575002','T RAJASHEKARAN','914461325378','','INDUSIND BANK LTD','KARAPAKKAM , CHENNAI','','23','600097','Document','0.00','0.00','0.00','0','Document','Surface','1','0.01','','','','','0.01','70.00','1','1','2025-11-04 20:14:45','2025-11-04 20:14:45','17617227102844','17617227102844','','1931','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1629','20','1','','2','3418131','2025-11-04','','5726','1575','RAGHURAM','918197982752','','','ASHOK NAGAR','MANGALORE','','11','575001','HDFC BANK CARDS DIV','918197982752','','PO BOX 8654','THIRUVANNIMIYUR PO','','23','600041','Document','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','70.00','1','1','2025-11-04 20:15:39','2025-11-04 20:15:39','17617138462770','17617138462770','','1931','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1630','10','1','','2','3406848','2025-11-04','','5211','1576','KCMA','918242223287','','','BEJAI KAPIKAD','MLR','','11','575004','JK ENTERPRISES','919603265321','','KATRA ISHWAR BHAVAN','KHARI BOALI','','32','110006','Document','20.00','0.00','0.00','0','Document','Surface','1','0.33','','','','','0.33','170.00','1','1','2025-11-04 20:15:58','2025-11-04 20:15:58','17617151801089','17617151801089','','1995','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1631','24','1','','2','3399540','2025-11-04','','5727','511','YENEPOYA NURSING HOME','918244260155','','','KANKANADY','MANGALORE -  02','','11','575002','THE CHIEF REG OF BIRTHS','','','DR B R AMBEDKAR VEEDHI','BANGALORE','','11','575001','Document','0.00','0.00','0.00','0','Document','Surface','1','0.01','','','','','0.01','60.00','1','1','2025-11-04 20:17:01','2025-11-04 20:17:01','17617227102844','17617227102844','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1632','20','1','','2','3418132','2025-11-04','','5728','1577','ALWIN ANTONY','919902550654','','','HDFC BANK LTD','MG RD','','11','575001','SBI','919902550654','','ASSIAGOLI PO','MANJANADY','','11','574199','Document','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','50.00','1','1','2025-11-04 20:17:35','2025-11-04 20:17:35','17617138462770','17617138462770','','3176','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1633','10','1','','2','3406849','2025-11-04','','5211','1578','KCMA','918242223287','','','BEJAI KAPIKAD','MLR','','11','575004','GROOVERSONS INTERNATIONAL','919036532125','','KATRA ISHWAR BHAVAN','KHARI BOALI','','32','110006','Document','100.00','0.00','0.00','0','Document','Surface','1','0.31','','','','','0.31','170.00','1','1','2025-11-04 20:17:42','2025-11-04 20:17:42','17617151801089','17617151801089','','1995','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1634','18','1','','2','3385057','2025-11-04','','5729','1579','APOLLO  P','917022154287','','','KAVOOR','MANGALORE  23','','11','575015','SANJYA','917022154287','','APOLLO  P','HUSUR  ROAD','','11','560068','Document','10.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-04 20:18:02','2025-11-04 20:18:02','17617174764463','17617174764463','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1635','10','1','','2','3406850','2025-11-04','','5211','1580','KCMA','918242223287','','','BEJAI KAPIKAD','MLR','','11','575004','BASHESHARLAL AMITH KUMAR','919036423654','','KATRA ISHWAR BHAVAN','KHARI BOALI','','32','110006','Document','100.00','0.00','0.00','0','Document','Surface','1','0.38','','','','','0.38','170.00','1','1','2025-11-04 20:19:36','2025-11-04 20:19:36','17617151801089','17617151801089','','1995','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1636','20','1','','2','3418133','2025-11-04','','5730','1581','RAGHAVENDRA ASSOCITES','919844061967','','','KODILABIL','MANGALORE','','11','575001','KARNATAKA BANK','919844061967','','BULL TEMPLE RD','CREDIT MARKETING DEPTMNT','','11','560010','Document','0.00','0.00','0.00','0','Document','Surface','1','0.10','','','','','0.10','75.00','1','1','2025-11-04 20:19:54','2025-11-04 20:19:54','17617138462770','17617138462770','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1637','24','1','','2','3399541','2025-11-04','','5731','511','VSK ENTERPRISES','919448464433','','','PUMPWELL','MANGALORE -  02','','11','575002','NARASIMHA RAJU','','','AMARARAJA ENERGY AND MOBILITY','GACHIBOWLI','','24','500032','Document','0.00','0.00','0.00','0','Document','Surface','1','0.01','','','','','0.01','70.00','1','1','2025-11-04 20:20:26','2025-11-04 20:20:26','17617227102844','17617227102844','','117','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1638','20','1','','2','3418134','2025-11-04','','5730','1582','RAGHAVENDRA ASSOCITES','919844061967','','','KODILABIL','MANGALORE','','11','575001','NITHESH','918105867208','','THIMMA DEVADIGA','JAJI HOUSE VODERHOBLI','','11','576101','Document','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','50.00','1','1','2025-11-04 20:21:09','2025-11-04 20:21:09','17617138462770','17617138462770','','3363','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1639','10','1','','2','3406851','2025-11-04','','5211','1583','KCMA','918242223287','','','BEJAI KAPIKAD','MLR','','11','575004','DEV TRADING CO','919036596325','','VK1 AREA','JAIPUR','','21','302013','Document','100.00','0.00','0.00','0','Document','Surface','1','0.34','','','','','0.34','170.00','1','1','2025-11-04 20:21:50','2025-11-04 20:21:50','17617151801089','17617151801089','','455','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1640','24','1','','2','3399542','2025-11-04','','4985','1584','MAK PLYWOOD IND PVT LTD','918296966727','','','PUMPWELL','MANGALORE','','11','575002','G MALYADRI','918951777627','','POLITHA SMART SOLUTUIONS','M G ROAD VIJAYAWADA','','1','520010','Document','0.00','0.00','0.00','0','Document','Surface','1','0.01','','','','','0.01','70.00','1','1','2025-11-04 20:22:18','2025-11-04 20:22:18','17617227102844','17617227102844','','494','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1641','24','1','','2','3399543','2025-11-04','','4985','426','MAK PLYWOOD IND PVT LTD','918296966727','','','PUMPWELL','MANGALORE','','11','575002','JESS .MADAM','918147687727','','MAK PLYWOOD IND PVT LTD','RICHMOND TOWN BANGALORE','','11','560025','Document','0.00','0.00','0.00','0','Document','Surface','1','0.01','','','','','0.01','60.00','1','1','2025-11-04 20:23:22','2025-11-04 20:23:22','17617227102844','17617227102844','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1642','10','1','','2','3406852','2025-11-04','','5211','1585','KCMA','918242223287','','','BEJAI KAPIKAD','MLR','','11','575004','CHAPPAN BHOG','919606543241','','APNA BAZAR SARDAR','LUCKNOW','','26','226002','Document','100.00','0.00','0.00','0','Document','Surface','1','0.25','','','','','0.25','130.00','1','1','2025-11-04 20:24:21','2025-11-04 20:24:21','17617151801089','17617151801089','','658','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1643','10','1','','2','3406853','2025-11-04','','5211','1586','KCMA','918242223287','','','BEJAI KAPIKAD','MLR','','11','575004','KESHA V TRADERS','919602321253','','WASEEM COMPLEX','LUCKNOW','','26','226003','Document','100.00','0.00','0.00','0','Document','Surface','1','0.25','','','','','0.25','130.00','1','1','2025-11-04 20:25:47','2025-11-04 20:25:47','17617151801089','17617151801089','','658','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1644','24','1','','2','3399544','2025-11-04','','5732','1587','FRANCIS DSOUZA','919972316262','','','PUTTUR TQ','DK','','11','574262','DR HARSHACARDHANA B G','917568621591','','MANIPAL UNIVERSITY JAIPUR','DEHMI KALAN POSTJAIPUR','','21','303007','Document','0.00','0.00','0.00','0','Document','Surface','1','0.01','','','','','0.01','100.00','1','1','2025-11-04 20:26:47','2025-11-04 20:26:47','17617227922084','17617227922084','','455','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1645','10','1','','2','3406854','2025-11-04','','5211','1588','KCMA','918242223287','','','BEJAI KAPIKAD','MLR','','11','575004','RAMKISHAN PRAKASH CHAND','919880023654','','KRISHI MANDI','MANDORE ROAD','','21','342007','Document','100.00','0.00','0.00','0','Document','Surface','1','0.30','','','','','0.30','170.00','1','1','2025-11-04 20:27:32','2025-11-04 20:27:32','17617151801089','17617151801089','','279','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1646','24','1','','2','3399545','2025-11-04','','5141','511','JANAPRIYA HOSPITAL','918970997979','','','KODAKKAL, PADIL','MANGALORE -','','11','575007','MAMATHA REBELLO','','','CHANDRA KUTIMA 04,','ATTAVARA, MANGALORE','','11','575001','Document','0.00','0.00','0.00','0','Document','Surface','1','0.01','','','','','0.01','40.00','1','1','2025-11-04 20:28:51','2025-11-04 20:28:51','17617227922084','17617227922084','','3453','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1647','10','1','','2','3406855','2025-11-04','','5211','1589','KCMA','918242223287','','','BEJAI KAPIKAD','MLR','','11','575004','VIJAYALAXMI TRADING CO','919663658964','','PAL ROAD','MASURIA','','21','342003','Document','100.00','0.00','0.00','0','Document','Surface','1','0.30','','','','','0.30','170.00','1','1','2025-11-04 20:28:55','2025-11-04 20:28:55','17617151801089','17617151801089','','279','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1648','24','1','','2','3399546','2025-11-04','','5733','511','JANAPRIYA HOSPITAL','918296269977','','','KODAKKAL,','PADIL  MANGALORE','','11','575007','CARE HEALTH INSURANCE LTD','','','GURGAON 122001','','','8','122001','Document','0.00','0.00','0.00','0','Document','Surface','1','0.01','','','','','0.01','100.00','1','1','2025-11-04 20:30:31','2025-11-04 20:30:31','17617227922084','17617227922084','UNITECH CYBER PARK SECTOR- 39','5','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1649','9','1','','2','3283702','2025-11-04','','5734','1590','SHREE PADMADURGA INTERIOR','919972724617','','','NEAR SHREE GANESH BHAJANA MANDIRA','KODIKAL','','11','575006','BANK OF BARODA','919945398113','','B M ROAD','','','11','573201','Document','0.00','0.00','0.00','0','Document','Surface','1','0.11','','','','','0.11','85.00','1','1','2025-11-04 20:37:09','2025-11-04 20:37:09','17617247788137','17617247788137','BEHIND APMC YARD','448','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1650','25','1','','2','3388895','2025-11-05','','5735','1591','subhaschandra  shetty','919448147020','','','akash','kulai','','11','575014','prasad  power eng','917722070496','','yeyyadi','mangalore','','11','575008','Document','100.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','100.00','1','1','2025-11-05 09:22:31','2025-11-26 15:56:16','17617202587270','17617202587270','','3453','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1651','17','1','','2','3404722','2025-11-05','','5048','1592','master driving school','','','','kankanady','','','11','575002','gundanna prabhu','919880006060','','next to car parking','shiribeedu','','11','576101','Document','0.01','0.00','0.00','0','Document','Surface','1','0.10','','','','','0.10','65.00','1','1','2025-11-05 09:23:44','2025-11-05 09:23:44','17617216585187','17617216585187','','863','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1652','8','1','','2','3351513','2025-11-05','','5736','1593','ROHITH','919964244195','','','PURAN NIVAS','PERMUDE','','11','574509','MOHINI CHANDRASHEKAR','919740548734','','HERGA C A BANK','KUNJIBETTU','','11','576102','Non Doc','100.00','0.00','0.00','0','Document','Surface','1','0.48','','','','','0.48','85.00','1','1','2025-11-05 09:25:00','2025-11-05 09:25:00','17617178859109','17617178859109','','1639','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1653','25','1','','2','3388896','2025-11-05','','5735','1594','subhaschandra  shetty','919448147020','','','akash','kulai','','11','575014','modern AGRO TRADERS','919448488872','','BUNDER','MLR','','11','575001','Document','100.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','100.00','1','1','2025-11-05 09:31:34','2025-11-26 15:56:16','17617202587270','17617202587270','','3453','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1654','6','1','','2','3381569','2025-11-05','','5737','1595','VAMAN NAYAK','919845148204','','','HAMAPNAKATTA','VAMAN NAYAK HAMPANKATTA','','11','575001','M R SEEMA','919481179008','','PADMAVATHI GIRLS HOSTEL','KALLABETTU MOODABIDRI','','11','574227','Document','0.00','0.00','0.00','0','Document','Surface','1','0.10','','','','','0.10','65.00','1','1','2025-11-05 09:32:28','2025-11-05 09:32:28','17617213813089','17617213813089','','1068','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1655','6','1','','2','3381570','2025-11-05','','5738','1596','S RANJAN KUMAR','919789007994','','','ALAKE','MANGALORE','','11','575003','S RANJANA KUMAR','919789007994','','NO 13 2ND STREET','CAMRANPET PALLIKONDA','','23','635809','Parcel','0.00','0.00','0.00','0','Document','Surface','1','2.90','','','','','2.90','544.00','1','1','2025-11-05 09:42:12','2025-11-05 09:42:12','17617213813089','17617213813089','','14','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1656','10','1','','2','3406856','2025-11-05','','5739','1597','RAMACHANDRA BHAT','919740022668','','','PADMASHREE','BEJAI NODU','','11','575004','BHAGYA LAXMI HEGEE','918217357242','','SNEHA KUNJA TRUST','KASARKOD','','11','571342','Document','10.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-05 09:53:27','2025-11-05 09:53:27','17617151801089','17617151801089','','191','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1657','21','1','','2','3393132','2025-11-05','','5740','452','PRANAV PRAKASH','919353487809','','','DRIDHA KODICAL 8D CROSS','KODIKAL','','11','575006','ACADEMIC EVALUATION CENTRE(APS INDIA)','918494900188','','GATE NO. 3, DLTA COMPLEX','R K KHANNA STADIUM, AFRICA AVENUE','','32','110029','Document','100.00','0.00','0.00','0','Document','Surface','1','0.12','','','','','0.12','130.00','1','1','2025-11-05 10:00:59','2025-11-05 10:00:59','17616388051318','17616388051318','','1995','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1658','20','1','','2','3418135','2025-11-05','','5741','1598','SUDHAKAR RAI','919449051401','','','KODIALBAIL MANGALORE','','','11','575003','SUBOD SHETTY','919880039880','','7TH BLOCK BSK 3RD STAGE','BANGALORE','','11','560085','Document','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-05 10:02:18','2025-11-05 10:02:18','17616388667516','17616388667516','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1659','21','1','','2','3393133','2025-11-05','','5742','1599','CANARA TRADING CORPORATION','916364587711','','','PANDURANGA PRASAD','ROSARIO CHURCH ROAD','','11','575006','PRATHIK H','919908337750','','CAPER INDIA PVT LTD','NO. 3, AKBARI BANU RURAL GODOWN, DASANAPURA VILALGE','','11','562123','Document','100.00','0.00','0.00','0','Document','Surface','1','0.05','','','','','0.05','60.00','1','1','2025-11-05 10:03:55','2025-11-05 10:03:55','17616388051318','17616388051318','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1660','12','1','','2','3382972','2025-11-05','','5743','1600','VIKRAM','919164033185','','','SHAKTI NAGAR','MANGALORE','','11','575001','GIREESH','918129290108','','KANNUR','','','12','670009','Parcel','500.00','0.00','0.00','0','Parcel','Surface','1','2.89','','','','','2.89','544.00','1','1','2025-11-05 10:05:02','2025-11-05 10:05:02','17617206505387','17617206505387','G K HOUSE VELLAKAL','642','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1661','16','1','','2','3357242','2025-11-05','','5744','1601','RAVI KUMAR','918722570510','','','KAIKAMBA','','','11','574151','KULWANTH ENGINEERS','917259790300','','NAGARABHAVI RING ROAD','BANGALORE','','11','560072','Document','100.00','0.00','0.00','0','Document','Surface','1','0.80','','','','','0.80','155.00','1','1','2025-11-05 10:08:32','2025-11-05 10:08:32','17617177578387','17617177578387','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1662','26','1','','2','3400897','2025-11-05','','5745','1602','thousif ali','917259902662','','','ullal mlr','','','11','','richmond town','918296966727','','alexandria street','','','11','560025','Document','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-05 10:10:20','2025-11-05 10:10:20','17615707686074','17615707686074','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1663','25','1','','2','3388898','2025-11-05','','5746','1603','devappa','918217484652','','','SKL','MLR','','11','575014','ULLESH CHAVADI','919449516001','','VEMKATESHWARA','','','11','584128','Document','100.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-05 10:13:58','2025-11-05 10:13:58','17617203788775','17617203788775','BALAJI NILAYA','2055','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1664','16','1','','2','3357243','2025-11-05','','5747','1604','MOHAN CHANDRA','919743979098','','','JASMIN TAILOR','KAIKAMBA','','11','574151','ANOOP A BELLAVI','919148679607','','UTTARAHALLI','BANAGLORE','','11','560061','Document','1000.00','0.00','0.00','0','Document','Surface','1','0.50','','','','','0.50','105.00','1','1','2025-11-05 10:14:55','2025-11-05 10:14:55','17617177578387','17617177578387','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1665','16','1','','2','3357244','2025-11-05','','5747','1604','MOHAN CHANDRA','919743979098','','','JASMIN TAILOR','KAIKAMBA','','11','574151','ANOOP A BELLAVI','919148679607','','UTTARAHALLI','BANAGLORE','','11','560061','Document','2000.00','0.00','0.00','0','Document','Surface','1','4.00','','','','','4.00','707.00','1','1','2025-11-05 10:16:48','2025-11-05 10:16:48','17617177578387','17617177578387','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1666','16','1','','2','3357245','2025-11-05','','5747','1605','MOHAN CHANDRA','919743979098','','','JASMIN TAILOR','KAIKAMBA','','11','574151','JEEVAN','919353779419','','VIJAY NAGAR','BANGALORE','','11','560040','Document','500.00','0.00','0.00','0','Document','Surface','1','1.00','','','','','1.00','155.00','1','1','2025-11-05 10:19:26','2025-11-05 10:19:26','17617177578387','17617177578387','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1667','25','1','','2','3388897','2025-11-05','','5748','1482','SOUNDARYA','918050481932','','','R V MOTORS','SURATHKAL','','11','575014','TVS CREDIT SERVICES LTD','914466123456','','GUINDY','CHENNAI','','23','600032','Document','100.00','0.00','0.00','0','Document','Surface','1','0.50','','','','','0.50','120.00','1','1','2025-11-05 10:24:50','2025-11-05 10:24:50','17617202587270','17617202587270','','1931','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1668','22','1','','2','3411145','2025-11-05','','5749','1606','GANESH','919480735118','','','KAVOOR','MANGALORE','','11','575003','INDCHEMIE HEALTH SPECIALITIES','919743566269','','NAGASANDRA VILLAGE','TUMKUR RD BANGALORE','','11','560073','Document','0.10','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-05 10:28:13','2025-11-05 10:28:13','17617169725275','17617169725275','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1669','23','1','','2','3408620','2025-11-05','','5750','1607','LIKHITH KUMAR','917349783653','','','PANDESHWAR','MANGALORE','','23','','ARUN KUMAR','919500031043','','MAYA APPLIANCE PVT TD','HIGH WAY AGGAIAM','','23','600097','Document','100.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','70.00','1','1','2025-11-05 10:30:07','2025-11-05 10:30:07','17617218175043','17617218175043','','1931','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1670','16','1','','2','3357246','2025-11-05','','5751','1608','VARUN LOYED DSOUZA','919481271999','','','MOODUPERAR','GANJIMUTT','','11','574144','EXICOM ENERGY SYSTEMS P LTD','919100634194','','YELAHANKA','BANAGLORE','','11','560065','Document','45000.00','0.00','0.00','0','Document','Surface','1','12.50','','','','','12.50','1430.00','1','1','2025-11-05 10:30:29','2025-11-05 10:30:29','17617177578387','17617177578387','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1671','20','1','','2','3418136','2025-11-05','','5227','511','K PREMNATH','919448159326','','','PVS KALAKUNJA ROAD','KODIALBAIL MANGALORE','','11','575003','THE JOINT REGISTRAR OF CO OP SCTY','','','MYSORE DIVISION MYSORE','NEW SAYYAJI RAO ROAD','','11','570024','Document','0.00','0.00','0.00','0','Document','Surface','1','0.17','','','','','0.17','85.00','1','1','2025-11-05 10:30:42','2025-11-05 10:30:42','17616388667516','17616388667516','','669','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1672','21','1','','2','3393134','2025-11-05','','5752','1609','GAUTHAM SUVARNA','919886832057','','','308 MANDARA EXCELLENCY','OPP INFOSYS','','11','575006','SRAVANI','919962262656','','BUKKAVARI STREET','NEAR BALABHANU VIDYALAYA','','1','521001','Document','100.00','0.00','0.00','0','Document','Surface','1','0.11','','','','','0.11','95.00','1','1','2025-11-05 10:30:48','2025-11-05 10:30:48','17616388051318','17616388051318','','822','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1673','23','1','','2','3408621','2025-11-05','','5690','1610','SPECIAL LAND ACQUISTION OFFICER','918244268134','','','N H A OF INDIA','MANGALORE','','23','','PRAKASH ANGADI','919513629919','','SESHADRIPURAM','00','','11','560020','Document','100.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-05 10:32:47','2025-11-05 10:32:47','17617218175043','17617218175043','ANGADI & CO','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1674','23','1','','2','3408622','2025-11-05','','5690','295','SPECIAL LAND ACQUISTION OFFICER','918244268134','','','N H A OF INDIA','MANGALORE','','23','','M/S NITHYA & CO','919845939315','','LAW FIRM','KANASU COMPLEX','','11','560001','Document','100.00','0.00','0.00','0','Document','Surface','1','0.25','','','','','0.25','85.00','1','1','2025-11-05 10:35:15','2025-11-05 10:35:15','17617218175043','17617218175043','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1675','7','1','','2','3395060','2025-11-05','','5753','1611','RICHARD SEQUEIRA','919702945018','','','MARIAN LAKE FRONT','KULAI','','11','575019','MELROY DSOUZA','919930664437','','MANAR CASTLE BLDG','ABOVE BIRDS CAKE SHOP','','14','400064','Document','0.01','0.00','0.00','0','Document','Surface','1','0.18','','','','','0.18','130.00','1','1','2025-11-05 10:40:43','2025-11-05 10:40:43','17617199828916','17617199828916','','57','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1676','23','1','','2','3408623','2025-11-05','','5754','1612','IRSHAD B I','919633983063','','','PANDESHWARA','MANGALORE','','23','','LNN LEGAL','918746965652','','DIVYA MAPLE','MALLESHWARAM','','11','560055','Document','100.00','0.00','0.00','0','Document','Surface','1','0.50','','','','','0.50','105.00','1','1','2025-11-05 10:41:45','2025-11-05 10:41:45','17617218175043','17617218175043','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1677','17','1','','2','3404723','2025-11-05','','5755','1613','PRATHIK B SHETTY','917259353832','','','MANGALORE','KAVOOR','','11','575013','H NAZEER','916361515622','','JOSHIGALLI','NEAR HANUMAN TEMPLE \\','','11','587125','Document','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-05 10:43:28','2025-11-05 10:43:28','17617216042295','17617216042295','','2921','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1678','20','1','','2','3418137','2025-11-05','','5756','1614','LATHA A ADVOCATE','919480654101','','','#802, 8TH FLOOR','APEKSHA RESIDENCY MANNAGUDDA MANGALORE','','11','575001','FRANCIS K V ADVOCATE','919449258110','','ANURAGH COMPLEX','BELTHANGADY','','11','574214','Document','0.00','0.00','0.00','0','Document','Surface','1','0.10','','','','','0.10','65.00','1','1','2025-11-05 10:44:15','2025-11-05 10:44:15','17616388667516','17616388667516','','2580','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1679','20','1','','2','3418138','2025-11-05','','5756','1614','LATHA A ADVOCATE','919480654101','','','#802, 8TH FLOOR','APEKSHA RESIDENCY MANNAGUDDA MANGALORE','','11','575001','FRANCIS K V ADVOCATE','919449258110','','ANURAGH COMPLEX','BELTHANGADY','','11','574214','Document','0.00','0.00','0.00','0','Document','Surface','1','0.20','','','','','0.20','75.00','1','1','2025-11-05 10:45:30','2025-11-05 10:45:30','17616388667516','17616388667516','','2580','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1680','10','1','','2','3406857','2025-11-05','','5757','1615','ISRA MEDICALS','919036465618','','','ANUGRAHA COMPLEX','BEJAI MANGALORE','','11','575004','G C KRISHNA','919036737364','','PENSION LANE','VISHWARKUPA','','11','571201','Parcel','100.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-05 10:46:36','2025-11-05 10:46:36','17617151801089','17617151801089','','332','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1681','10','1','','2','3406858','2025-11-05','','5758','1616','DEVENDRA','918217558672','','','BEJAI KAPIKAD','7TH CROSS','','11','575004','VIJAYA KRISHNA BHAT','918217558672','','CENTRAL CHEMBERS','2ND MAIN ROAD, GANDHI NAGAR','','11','560009','Document','10.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-05 10:49:53','2025-11-05 10:49:53','17617151801089','17617151801089','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1682','13','1','','2','3404167','2025-11-05','','5759','1617','HARISH SHETTY','919945315553','','','CAST','MANGALAORE','','11','575011','NARAYANA REDDY','919900888988','','KPT SLV DURGA APRT','NANAJAPPA LAYOUT VIDYARAYANPURA','','11','560097','Document','10.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-05 10:52:03','2025-11-05 10:52:03','17617147018423','17617147018423','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1683','25','1','','2','3388899','2025-11-05','','5760','1618','KUSHALAKSHI','917353457805','','','PADUPADAVU','KUTHETHOOR MANGLORE','','11','575014','VIJAYA KARNATAKA','918242222222','','M G ROAD','MANGLORE','','11','575001','Document','100.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','35.00','1','1','2025-11-05 10:52:25','2025-11-05 10:52:25','17617202587270','17617202587270','','3453','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1684','17','1','','3','21505459','2025-11-03','3910','3905','511','MEDIGLOBE','918147760815','','','3RD FLOOR,\'\'PARIN\'\' COLLECTORS GATE CIRCLE,BALMATTA MANGALURE-1','','29AIGPB0221L1ZL','11','575001','TORENT PHARMA','','','BANGALORE','','','11','560001','Document','0.00','0.00','0.00','0','Document','Surface','1','0.01','','','','','0.01','30.00','1','1','2025-11-05 10:52:30','2025-12-13 16:58:27','17617216042295','17617216042295','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','1','0','','','','','','1','');
INSERT INTO `booking` VALUES ('1685','21','1','','2','3393135','2025-11-05','','5018','1619','ABHISHEK','918277688146','','','MALEMAR','MLR','','11','575006','SANTOSH','919739050608','','S/O. YELLAPPA KG','GANANAGANOTRI CONVENT SCHOOL','','11','580031','Document','100.00','0.00','0.00','0','Document','Surface','1','0.07','','','','','0.07','75.00','1','1','2025-11-05 10:53:54','2025-11-05 10:53:54','17616388051318','17616388051318','','557','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1686','17','1','','3','21505460','2025-11-03','3910','3905','511','MEDIGLOBE','918147760815','','','3RD FLOOR,\'\'PARIN\'\' COLLECTORS GATE CIRCLE,BALMATTA MANGALURE-1','','29AIGPB0221L1ZL','11','575002','JYOTHIRAM DEVADIGA','','','KARWAR','','','11','560001','Document','0.01','0.00','0.00','0','Document','Surface','1','0.30','','','','','0.30','51.00','1','1','2025-11-05 10:54:24','2025-12-13 16:58:27','17617216042295','17617216042295','','296','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','1','0','','','','','','1','');
INSERT INTO `booking` VALUES ('1687','17','1','','3','21505461','2025-11-03','3910','3905','511','MEDIGLOBE','918147760815','','','3RD FLOOR,\'\'PARIN\'\' COLLECTORS GATE CIRCLE,BALMATTA MANGALURE-1','','29AIGPB0221L1ZL','11','575002','EMCHERE PHARMA','','','BANGALORE','','','11','560001','Document','0.01','0.00','0.00','0','Document','Surface','1','0.20','','','','','0.20','30.00','1','1','2025-11-05 10:56:51','2025-12-13 16:58:27','17617216042295','17617216042295','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','1','0','','','','','','1','');
INSERT INTO `booking` VALUES ('1688','17','1','','3','21505462','2025-11-03','3910','3905','511','MEDIGLOBE','918147760815','','','3RD FLOOR,\'\'PARIN\'\' COLLECTORS GATE CIRCLE,BALMATTA MANGALURE-1','','29AIGPB0221L1ZL','11','','TROKIA PHARMA','','','BLR','BLR','','11','575001','Document','0.00','0.00','0.00','0','Document','Surface','1','0.20','','','','','0.20','30.00','1','1','2025-11-05 10:58:17','2025-12-13 16:58:27','17617216042295','17617216042295','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','1','0','','','','','','1','');
INSERT INTO `booking` VALUES ('1689','6','1','','2','3381571','2025-11-05','','5761','511','NAMMA TV','919945649699','','','KULAI','MANGALORE','','11','575001','9443062243','','','KRISHNA &CO','BHARATHI PURAM VAIRAM NAGAR','','23','641664','Document','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','70.00','1','1','2025-11-05 11:00:02','2025-11-05 11:00:02','17617213813089','17617213813089','','535','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1690','20','1','','2','3418139','2025-11-05','','5762','1620','PRABHAKAR ADAPA','918217088169','','','SAI PALACE APTS 102','MANNAGUDDA ROAD BALLALBAGH','','11','575003','ANIKET MOHAN THITE','919987508248','','#61 WAGH APTS 3','VILE PARLE EAST','','14','400057','Document','0.00','0.00','0.00','0','Document','Surface','1','0.05','','','','','0.05','100.00','1','1','2025-11-05 11:00:34','2025-11-05 11:00:34','17616388667516','17616388667516','','57','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1691','17','1','','3','21505463','2025-11-03','3910','3905','511','MEDIGLOBE','918147760815','','','3RD FLOOR,\'\'PARIN\'\' COLLECTORS GATE CIRCLE,BALMATTA MANGALURE-1','','29AIGPB0221L1ZL','11','575002','MAHVEER','','','INDORE','','','23','636701','Document','0.00','0.00','0.00','0','Document','Surface','1','0.20','','','','','0.20','51.00','1','1','2025-11-05 11:01:08','2025-12-13 16:58:27','17617216042295','17617216042295','','558','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','1','0','','','','','','1','');
INSERT INTO `booking` VALUES ('1692','6','1','','2','3381572','2025-11-05','','5761','1621','NAMMA TV','919945649699','','','KULAI','MANGALORE','','11','575001','ARPITHA','919945526171','','MAHARAJA SOAPS INDUS P LTD','KIADB INDUS','','11','577005','Document','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-05 11:01:33','2025-11-05 11:01:33','17617213813089','17617213813089','','327','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1693','26','1','','2','3400898','2025-11-05','','5763','1622','vijayalatha','919611475520','','','permannur','','','11','575017','karn labour welfare board','918177291175','','karmika kalyan bhavan','yeshwanthpur','','11','560022','Document','0.00','0.00','0.00','0','Document','Surface','1','0.05','','','','','0.05','60.00','1','1','2025-11-05 11:01:53','2025-11-05 11:01:53','17615707686074','17615707686074','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1694','25','1','','2','3388900','2025-11-05','','5764','517','SUDARSHANA','919632214458','','','THOKUR','BAIKAMPADY','','11','575014','REKHA J','919700000493','','RIVIERA APTS','DWARAKAPURI COLONY PUNJAGUTTA','','1','500082','Document','100.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','70.00','1','1','2025-11-05 11:02:24','2025-11-05 11:02:24','17617202587270','17617202587270','','117','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1695','17','1','','3','21505464','2025-11-03','3910','3905','511','MEDIGLOBE','918147760815','','','3RD FLOOR,\'\'PARIN\'\' COLLECTORS GATE CIRCLE,BALMATTA MANGALURE-1','','29AIGPB0221L1ZL','11','','DR REDDY P','','','BLR','BLR','','11','575001','Document','0.00','0.00','0.00','0','Document','Surface','1','0.20','','','','','0.20','30.00','1','1','2025-11-05 11:03:12','2025-12-13 16:58:27','17617216042295','17617216042295','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','1','0','','','','','','1','');
INSERT INTO `booking` VALUES ('1696','25','1','','2','3388901','2025-11-05','','5765','1623','SANTHOSH N SHETTY','919844254713','','','SKL','MANGLORE','','11','575014','SATHISH POOJARY','919322469956','','ION EXCHANG INDIA','ION HOUSE MAHALAXMI MUMBAI','','14','400011','Document','100.00','0.00','0.00','0','Document','Surface','1','0.20','','','','','0.20','130.00','1','1','2025-11-05 11:04:44','2025-11-05 11:04:44','17617202587270','17617202587270','','57','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1697','10','1','','2','3406859','2025-11-05','','5766','1624','GOWRISH H K','918310648011','','','SHARADA , LAMINATE NAVARRE','PAIS GARDEN BEJAI MANGALORE','','11','575004','KARUNANIDHI G K','919945565452','','CHANDRA LAYOUT','1ST STAGE','','11','560072','Document','10.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-05 11:05:46','2025-11-05 11:05:46','17617151801089','17617151801089','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1698','17','1','','3','21505465','2025-11-03','3910','3905','511','MEDIGLOBE','918147760815','','','3RD FLOOR,\'\'PARIN\'\' COLLECTORS GATE CIRCLE,BALMATTA MANGALURE-1','','29AIGPB0221L1ZL','11','575002','ZYDAS LIFE SCIENCE','','','BANGALORE','','','11','560001','Document','0.01','0.00','0.00','0','Document','Surface','1','0.60','','','','','0.60','55.00','1','1','2025-11-05 11:05:51','2025-12-13 16:58:27','17617216042295','17617216042295','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','1','0','','','','','','1','');
INSERT INTO `booking` VALUES ('1699','6','1','','2','3381573','2025-11-05','','5076','569','SUMANA MOTORS','919845598128','','','AZZUDDIN RD','BUNDER','','11','575001','SWADEEP SUBBAIH','919448874010','','TATA COFFE LTD','POLIBETTA','','11','571215','Document','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-05 11:06:58','2025-11-05 11:06:58','17617213813089','17617213813089','','2857','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1700','25','1','','2','3388902','2025-11-05','','5768','1626','SHRUTHI','919481768237','','','KRISHNAPURA','MLR','','11','575014','SANGEETHA','919483188875','','KOTTIGEHAR ROAD MAGUNDI','N R PURA','','11','577160','Document','1000.00','0.00','0.00','0','Document','Surface','1','0.11','','','','','0.11','85.00','1','1','2025-11-05 11:07:36','2025-11-05 11:07:36','17617202587270','17617202587270','','696','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1701','21','1','','2','3393136','2025-11-05','','5769','1627','ARUNA SHARMA','919986221066','','','NEAR CSI CHURCH','KODIKAL KATTE','','11','575006','YASH SHARMA','919164748717','','105, SURAKSHA ELEGANCE','KODICHIKKANAHALLI, BOMMANAHALLI','','11','560076','Document','100.00','0.00','0.00','0','Document','Surface','1','0.17','','','','','0.17','85.00','1','1','2025-11-05 11:11:18','2025-11-05 11:11:18','17616388051318','17616388051318','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1702','13','1','','2','3404168','2025-11-05','','5770','1628','K R SHENOY','919483457465','','','DONGERKERY','MANGALAORE','','11','575001','K RAGHURAM SHENOY','919980844042','','13TH CROSS 10TH MAIN','MARUTHI NAGAR MALLESHPALAYA','','11','560075','Document','10.00','0.00','0.00','0','Document','Surface','1','0.69','','','','','0.69','170.00','1','1','2025-11-05 11:11:36','2025-11-05 11:11:36','17617147018423','17617147018423','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1703','10','1','','2','3406860','2025-11-05','','5771','1629','VINAYA K SHETTY','919823262937','','','MAURISHKA PARK APTS','MANGALORE','','11','575004','SHREE HOSA MARIGUDI TEMPLE','919823262937','','KAUP BEACH ROAD','KOPPALANGADI','','11','574106','Books','100.00','0.00','0.00','0','Document','Surface','1','0.31','','','','','0.31','85.00','1','1','2025-11-05 11:13:12','2025-11-05 11:13:12','17617151801089','17617151801089','','2933','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1704','8','1','','2','3351514','2025-11-05','','5772','1630','MUFTHI','918451920549','','','MANGALORE  INTL AIRPORT','KENJAR','','11','574142','JAGADISH','919902888545','','CREDO BRANDS MKT LTD','ANDHERI EAST MUMBAI','','14','400093','Document','10.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','100.00','1','1','2025-11-05 11:13:40','2025-11-05 11:13:40','17617178859109','17617178859109','','57','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1705','21','1','','2','3393137','2025-11-05','','5773','1631','SHRUTHI RAI','917676746914','','','SHAKTHI ELEGANCE','KOTTARA','','11','575006','PADMINI SHETTY','919900116937','','NO. 771 MANASA 14TH MAIN ROAD','ITI LAYOUT, MALLATHAHALLI','','11','560056','Document','100.00','0.00','0.00','0','Document','Surface','1','0.11','','','','','0.11','85.00','1','1','2025-11-05 11:14:33','2025-11-05 11:14:33','17616388051318','17616388051318','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1706','17','1','','3','21505467','2025-11-03','3910','3905','511','MEDIGLOBE','918147760815','','','3RD FLOOR,\'\'PARIN\'\' COLLECTORS GATE CIRCLE,BALMATTA MANGALURE-1','','29AIGPB0221L1ZL','11','575002','DINANTHRJ','','','BANGALORE','','','11','560001','Document','0.00','0.00','0.00','0','Document','Surface','1','0.30','','','','','0.30','45.00','1','1','2025-11-05 11:15:10','2025-12-13 16:58:27','17617216042295','17617216042295','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','1','0','','','','','','1','');
INSERT INTO `booking` VALUES ('1707','6','1','','2','3381574','2025-11-05','','5774','1632','DALVEER SINGH','918433189856','','','MANNAGUDDA','MANGALORE','','11','575003','KARNAN PATTU CENTER','916374913373','','6TH MAIN RD  NR VASAN DENTAL CARE','JAYANAGAR 4TH BLOCK','','11','560011','Parcel','5000.00','0.00','0.00','0','Document','Surface','1','6.34','','','','','6.34','770.00','1','1','2025-11-05 11:16:30','2025-11-05 11:16:30','17617213813089','17617213813089','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1708','17','1','','3','21505468','2025-11-03','3910','3905','511','MEDIGLOBE','918147760815','','','3RD FLOOR,\'\'PARIN\'\' COLLECTORS GATE CIRCLE,BALMATTA MANGALURE-1','','29AIGPB0221L1ZL','11','575001','MANOJ MEDICALS','','','BANGALORE','','','11','560001','Document','0.00','0.00','0.00','0','Document','Surface','1','0.90','','','','','0.90','55.00','1','1','2025-11-05 11:16:51','2025-12-13 16:58:27','17617216042295','17617216042295','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','1','0','','','','','','1','');
INSERT INTO `booking` VALUES ('1709','14','1','','2','3364695','2025-11-05','','5775','1633','DINESH','919972512037','','','BANTWAL','BANTWAL','','11','574211','BIGICO IPM P LTD','919241144300','','788 2 ND CROSS','MAHALAXMI LAYOUT','','11','560086','Document','0.01','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-05 11:17:04','2025-11-05 11:17:04','17617209872567','17617209872567','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1710','22','1','','2','3411146','2025-11-05','','5776','1634','SRI GURU MEDICAL','919448500294','','','MALLIKATTE','MANGALORE','','11','575004','UPENDREN','919207241659','','NEERCHAL HOUSE','KASARGOD','','12','671124','Document','0.10','0.00','0.00','0','Document','Surface','1','0.05','','','','','0.05','70.00','1','1','2025-11-05 11:21:13','2025-11-05 11:21:13','17617169725275','17617169725275','','570','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1711','17','1','','3','21505469','2025-11-03','3910','3905','511','MEDIGLOBE','918147760815','','','3RD FLOOR,\'\'PARIN\'\' COLLECTORS GATE CIRCLE,BALMATTA MANGALURE-1','','29AIGPB0221L1ZL','11','575002','EMOVI PHARMA','','','BANGALORE','','','11','560001','Document','0.00','0.00','0.00','0','Document','Surface','1','0.40','','','','','0.40','45.00','1','1','2025-11-05 11:21:27','2025-12-13 16:58:27','17617216042295','17617216042295','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','1','0','','','','','','1','');
INSERT INTO `booking` VALUES ('1712','17','1','','3','21505470','2025-11-03','3910','3905','511','MEDIGLOBE','918147760815','','','3RD FLOOR,\'\'PARIN\'\' COLLECTORS GATE CIRCLE,BALMATTA MANGALURE-1','','29AIGPB0221L1ZL','11','575002','INTAS PHARMA','','','BANGALORE','','','11','560001','Document','0.00','0.00','0.00','0','Document','Surface','1','0.70','','','','','0.70','55.00','1','1','2025-11-05 11:23:00','2025-12-13 16:58:27','17617216042295','17617216042295','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','1','0','','','','','','1','');
INSERT INTO `booking` VALUES ('1713','23','1','','2','3408624','2025-11-05','','5777','1635','MAHESH M G','919611022212','','','POLICE LINE','MANGALORE','','23','','MADHURI A C','919148780994','','KARNATAKA POLICE ACADEMY','NAZARBAD','','11','570010','Document','100.00','0.00','0.00','0','Document','Surface','1','2.50','','','','','2.50','431.00','1','1','2025-11-05 11:23:11','2025-11-05 11:23:11','17617218175043','17617218175043','','669','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1714','6','1','','2','3381575','2025-11-05','','5778','1636','SUDARSHAN','918618425002','','','MANGALORE','MANGALORE','','11','575003','RUPA &COMPANY LTD','916361382729','','3RD MAIN RD 1ST FLOOR','SRIRAMPURA','','11','560021','Document','0.00','0.00','0.00','0','Document','Surface','1','0.10','','','','','0.10','75.00','1','1','2025-11-05 11:24:18','2025-11-05 11:24:18','17617213813089','17617213813089','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1715','17','1','','3','21505471','2025-11-03','3910','3905','511','MEDIGLOBE','918147760815','','','3RD FLOOR,\'\'PARIN\'\' COLLECTORS GATE CIRCLE,BALMATTA MANGALURE-1','','29AIGPB0221L1ZL','11','575002','ARPITH GOWDA','','','SULLIA','','','11','574239','Document','0.00','0.00','0.00','0','Document','Surface','1','0.60','','','','','0.60','45.00','1','1','2025-11-05 11:25:06','2025-12-13 16:58:27','17617216042295','17617216042295','','2577','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','1','0','','','','','','1','');
INSERT INTO `booking` VALUES ('1716','18','1','','2','3385058','2025-11-05','','5779','1637','SHIVAPRASAD','919148444285','','','KA 13 D 7907','MANGALORE','','11','575013','BHARTH MINI TRANSPORT','917401699969','','PONNIAMMANMEDU','MADHAVARAM CHENNI','','23','600110','Document','10.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','70.00','1','1','2025-11-05 11:27:10','2025-11-05 11:27:10','17621531273939','17621531273939','','1931','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1717','17','1','','3','21505472','2025-11-03','3910','3905','511','MEDIGLOBE','918147760815','','','3RD FLOOR,\'\'PARIN\'\' COLLECTORS GATE CIRCLE,BALMATTA MANGALURE-1','','29AIGPB0221L1ZL','11','575002','NARNAKAR','','','BANGALORE','BANGALORE','','11','560001','Document','0.00','0.00','0.00','0','Document','Surface','1','1.30','','','','','1.30','247.00','1','1','2025-11-05 11:27:55','2025-12-14 08:36:02','17617216042295','17617216042295','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','1','0','','','','','','1','');
INSERT INTO `booking` VALUES ('1718','10','1','','2','3406861','2025-11-05','','5780','1638','K KRISHNANANDA PAI','918884424123','','','GREEN HILL APTS','BEJAI KAPIKAD, MANGLAORE','','11','575004','SANTOSH SAWANT','917045798014','','TORRENT PHARMACEUTICALS LTD','KASARVADI, SENAPATI BAPAT MARG','','14','400028','Document','100.00','0.00','0.00','0','Document','Surface','1','0.50','','','','','0.50','170.00','1','1','2025-11-05 11:30:55','2025-11-05 11:30:55','17617151801089','17617151801089','','57','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1719','17','1','','3','21505473','2025-11-03','3862','3864','511','BVELL HEALTHCARE','','','','First Floor, Shop No.6, Door No 15-20-1227/32, Essel Willcon, Bendorwell Circle, Mangalore,','','29AMUPS1065R1ZU','11','575002','VASAVI MEDICAL','','','SHIMOGGA','','','11','577201','Document','0.00','0.00','0.00','0','Document','Surface','1','0.60','','','','','0.60','141.00','1','1','2025-11-05 11:31:12','2025-12-13 16:58:27','17617216042295','17617216042295','','1829','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','1','0','','','','','','1','');
INSERT INTO `booking` VALUES ('1720','6','1','','2','3381576','2025-11-05','','5781','1639','PRASHANTH M SHET','919448447470','','','PRASHANTH M SHET','ALAKE MAIN RD','','11','575001','SRI RUDRESHWARA INDANE ENTERPR','919590143848','','N H 206 NR GOVT HOSPITAL','','','11','572216','Document','0.00','0.00','0.00','0','Document','Surface','1','0.15','','','','','0.15','85.00','1','1','2025-11-05 11:32:26','2025-11-05 11:32:26','17617213813089','17617213813089','LPG GAS DIST','850','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1721','20','1','','2','3418140','2025-11-05','','5782','1640','M P PARAMESH','919481974908','','','DEREBAIL','MANGALORE','','11','575008','C D VARADARAJU','919480588033','','CHINNAHALLI VILLAGE','VALLALA HALLI POST SAKLESHPURA','','11','573123','Non Doc','890.00','0.00','0.00','0','Document','Surface','1','0.09','','','','','0.09','75.00','1','1','2025-11-05 11:33:03','2025-11-05 11:33:03','17616388667516','17616388667516','','2050','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1722','17','1','','3','21505474','2025-11-03','3869','3870','511','DECCAN HERALD CIRCULATION','918217283384','','','BALMATTA MANGALORE','','29AABCT2065N1ZY','11','575002','N P SHNAKR','','','BANGALORE','','','11','560001','Document','0.00','0.00','0.00','0','Document','Surface','1','0.20','','','','','0.20','45.00','1','1','2025-11-05 11:33:11','2025-12-13 16:58:27','17617216042295','17617216042295','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','1','0','','','','','','1','');
INSERT INTO `booking` VALUES ('1723','10','1','','2','3406862','2025-11-05','','5783','1641','BHUMI RESIDENCY','919611713969','','','ADITYA COMPLEX','KSRTC BEJAI MANGALORE','','11','575004','S N KUMAR & ASSOCIATE','919972632348','','29TH MAIN , K R LAYOUT','J P NAGAR 6TH PHASE','','11','560078','Document','100.00','0.00','0.00','0','Document','Surface','1','0.30','','','','','0.30','105.00','1','1','2025-11-05 11:34:08','2025-11-05 11:34:08','17617151801089','17617151801089','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1724','6','1','','2','3381577','2025-11-05','','5784','1642','NUTHAN ENTERPRISES','919986938470','','','ALAKE','MANGALORE','','11','575003','HARDEV SINGH','919986938470','','IOCL','INDIAN OIL BHAVAN KALINGA RD','','11','560027','Document','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-05 11:34:36','2025-11-05 11:34:36','17617213813089','17617213813089','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1725','7','1','','2','3395061','2025-11-05','','4679','1643','M R TRANSPORT','917204081998','','','BAIKAMPADY','MANGALORE','','11','575011','SRINIVAS SHETTY','919164167600','','SRI LAKSHMI SRINIVAS R L','RAMOHALLI','','11','560074','Document','0.01','0.00','0.00','0','Document','Surface','1','0.01','','','','','0.01','60.00','1','1','2025-11-05 11:34:45','2025-11-05 11:34:45','17617199828916','17617199828916','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1726','17','1','','3','21505475','2025-11-03','3910','3905','511','MEDIGLOBE','918147760815','','','3RD FLOOR,\'\'PARIN\'\' COLLECTORS GATE CIRCLE,BALMATTA MANGALURE-1','','29AIGPB0221L1ZL','11','575002','NATCO PHARMA','','','BANGALORE','','','11','560001','Document','0.00','0.00','0.00','0','Document','Surface','1','0.60','','','','','0.60','55.00','1','1','2025-11-05 11:34:48','2025-12-13 16:58:27','17617216042295','17617216042295','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','1','0','','','','','','1','');
INSERT INTO `booking` VALUES ('1727','17','1','','3','21505476','2025-11-03','3910','3905','511','MEDIGLOBE','918147760815','','','3RD FLOOR,\'\'PARIN\'\' COLLECTORS GATE CIRCLE,BALMATTA MANGALURE-1','','29AIGPB0221L1ZL','11','575002','HEYERO HEALTHCARE','','','BANGALORE','BANGALORE','','11','560001','Document','0.00','0.00','0.00','0','Document','Surface','1','0.90','','','','','0.90','55.00','1','1','2025-11-05 11:36:25','2025-12-13 16:58:27','17617216042295','17617216042295','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','1','0','','','','','','1','');
INSERT INTO `booking` VALUES ('1728','20','1','','2','3418141','2025-11-05','','5785','1644','TAWASUL TRAVELS','919071188871','','','MANGALORE','','','11','575003','SHEBAZ','911902204555','','HAMZA TOWER 10TH FLOOR FLAT #1008','BELVENDER ROAD MAZGAON','','14','400010','Document','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','100.00','1','1','2025-11-05 11:37:02','2025-11-05 11:37:02','17616388667516','17616388667516','','57','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1729','17','1','','3','21505477','2025-11-03','3910','3905','511','MEDIGLOBE','918147760815','','','3RD FLOOR,\'\'PARIN\'\' COLLECTORS GATE CIRCLE,BALMATTA MANGALURE-1','','29AIGPB0221L1ZL','11','575002','NAGRAJ','','','YELLAPUR','','','11','581359','Document','0.00','0.00','0.00','0','Document','Surface','1','0.80','','','','','0.80','55.00','1','1','2025-11-05 11:38:00','2025-12-13 16:58:27','17617216042295','17617216042295','','1713','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','1','0','','','','','','1','');
INSERT INTO `booking` VALUES ('1730','17','1','','3','21505478','2025-11-03','3872','3872','511','DECCAN HERALD PV EDITORIAL DEPT','','','','BALMATTA MANGALORE','','29AABCT2065N1ZY','11','575002','HARSHA','','','BANGALORE','','','11','560001','Document','0.00','0.00','0.00','0','Document','Surface','1','0.80','','','','','0.80','45.00','1','1','2025-11-05 11:39:20','2025-12-13 16:58:27','17617216042295','17617216042295','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','1','0','','','','','','1','');
INSERT INTO `booking` VALUES ('1731','18','1','','2','3385059','2025-11-05','','4648','93','ROOPA.S','917483153243','','','IDFC FIRST BANK','BALLALBAGH CIRCLE','','11','575003','ABHIJEET','919620422492','','IDFC FIRST BANK','SARASWATHIPURAM MYSORE','','11','','Document','10.00','0.00','0.00','0','Document','Surface','1','0.90','','','','','0.90','155.00','1','1','2025-11-05 11:41:37','2025-11-05 11:41:37','17621531273939','17621531273939','','669','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1732','17','1','','3','21505479','2025-11-03','3885','3884','511','INDUSIND BANK LIMITED,PPD','919008071801','','','ESSEL WILLCON COMPLEX,2ND FLOOR,BENDOORWELL,KANKANADY,MANGALORE-575002. ground floor, 28, centinary building, M G Road, bangalore,560001','','29AAACI1314G1ZZ','11','575002','RAJU','','','INDUISND BANK','CHENNAI','','23','600096','Document','0.00','0.00','0.00','0','Document','Surface','1','0.30','','','','','0.30','27.90','1','1','2025-11-05 11:41:51','2025-12-13 16:58:27','17617216042295','17617216042295','','1931','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','1','0','','','','','','1','');
INSERT INTO `booking` VALUES ('1733','8','1','','2','3351515','2025-11-05','','5786','1645','ALISTAR NAZRETH','919901720053','','','OLD AIRPORT RD','BAJPE','','11','574142','SUREETH ATAKLE','917337681007','','YASHWANTH VIRAR  COLONY','BELGAUM','','11','590009','Document','1.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-05 11:42:55','2025-11-05 11:42:55','17617178859109','17617178859109','','4','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1734','17','1','','3','21505480','2025-11-03','3868','3870','511','DECCAN HERALD ADVERTISEMENT','918217283384','','','BALMATTA MANGALORE','','29AABCT2065N1ZY','11','575002','DIVAKAR','','','DECCAN','HUBLI','','11','580025','Document','0.01','0.00','0.00','0','Document','Surface','1','2.30','','','','','2.30','207.00','1','1','2025-11-05 11:45:36','2025-12-13 16:58:27','17617216042295','17617216042295','','557','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','1','0','','','','','','1','');
INSERT INTO `booking` VALUES ('1735','12','1','','2','3382973','2025-11-05','','5787','1646','COLLIN JOHN MATHIAS','919448314425','','','NELAKANTH ESTATE','BASRIKATTE','','23','','SABRISH P','919110291864','','BASRIKATTE PO','KOPPA TQ','','11','577126','Document','10.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-05 11:49:19','2025-11-05 11:49:19','17617206505387','17617206505387','NEALKHAN ESATAE','859','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1736','23','1','','2','3408625','2025-11-05','','5788','1647','C S SUDHAN','919620091194','','','PANDESWARA','MANGALORE','','23','','MR SACHIN JADHAV','919029878990','','RPG LIFE SCIENCE LTD','WORLI','','14','400030','Document','100.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','100.00','1','1','2025-11-05 11:49:48','2025-11-05 11:49:48','17617218175043','17617218175043','','57','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1737','24','1','','2','3399547','2025-11-05','','5789','1648','BABITHA','916361423598','','','MANGALADEVI ROAD','MANGALORE','','11','575001','RAGHAVENDRA K','918310147715','','RELAINCE RETAI LIMITED','BANNERGHATTA ROAD BANGALORE','','11','560029','Document','10.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-05 11:49:49','2025-11-05 11:49:49','17617227102844','17617227102844','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1738','20','1','','2','3418142','2025-11-05','','5790','1649','MITHALI DEVI','917002701645','','','BODANTHILA ROAD','KUMBLA','','12','671321','DR SHREEDEVI R BHAT','919964109288','','ASHWINI CLINIC MEGHA PLAZA','MAIN ROAD KAIKAMBA','','11','574151','Parcel','240.00','0.00','0.00','0','Document','Surface','1','1.00','','','','','1.00','105.00','1','1','2025-11-05 11:53:40','2025-11-05 11:53:40','17616388667516','17616388667516','','3194','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1739','22','1','','2','3411147','2025-11-05','','5791','1650','RAMESH BABU','919611474948','','','G FLOOR ZODIAC APTS','KADRI KAMBLA','','11','575003','SHASTRY C S','919448153330','','MANILA BOOKS AND ZEROX','K P COMPLEX MAIN RD','','11','574201','Document','0.10','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','50.00','1','1','2025-11-05 11:56:12','2025-11-05 11:56:12','17617169725275','17617169725275','','1904','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1740','17','1','','3','21505351','2025-11-04','3868','3870','511','DECCAN HERALD ADVERTISEMENT','918217283384','','','BALMATTA MANGALORE','','29AABCT2065N1ZY','11','','HARISH','','','DECCAN','BLR','','11','575001','Document','0.00','0.00','0.00','0','Document','Surface','1','6.80','','','','','6.80','215.00','1','1','2025-11-05 12:00:00','2025-12-13 16:58:27','17617216042295','17617216042295','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','1','0','','','','','','1','');
INSERT INTO `booking` VALUES ('1741','7','1','','2','3395062','2025-11-05','','5792','1651','LAKSHMI SOU CR CO OP LTD','918242400136','','','BAIKAMPADY','MANGALORE','','11','575011','SHREE LAKSHMI SOU CO OP SOC','918242491360','','KODIALBAIL','MANGALORE','','11','575003','Document','0.01','0.00','0.00','0','Document','Surface','1','0.01','','','','','0.01','35.00','1','1','2025-11-05 12:01:44','2025-11-05 12:01:44','17617199828916','17617199828916','','3453','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1742','17','1','','3','21505325','2025-11-03','3868','3870','511','DECCAN HERALD ADVERTISEMENT','918217283384','','','BALMATTA MANGALORE','','29AABCT2065N1ZY','11','575002','HARISH','','','DECCAN HERALD','','','11','560001','Document','0.00','0.00','0.00','0','Document','Surface','1','5.60','','','','','5.60','190.00','1','1','2025-11-05 12:02:07','2025-12-13 16:58:27','17617216042295','17617216042295','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','1','0','','','','','','1','');
INSERT INTO `booking` VALUES ('1743','23','1','','2','3408626','2025-11-05','','5793','1652','ASIF','919663295204','','','BUNDER','MANGALORE','','23','','MOHAMMED SALEEM','919663404954','','S/O VALLI PEER','ARALLIHALLI','','11','577233','Document','100.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-05 12:03:17','2025-11-05 12:03:17','17617218175043','17617218175043','','852','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1744','17','1','','3','21505323','2025-11-03','3868','3870','511','DECCAN HERALD ADVERTISEMENT','918217283384','','','BALMATTA MANGALORE','','29AABCT2065N1ZY','11','575002','HARISH L','','','DECCAN','','','11','560001','Document','0.00','0.00','0.00','0','Document','Surface','1','7.60','','','','','7.60','240.00','1','1','2025-11-05 12:03:43','2025-12-18 17:23:17','17617216042295','17617216042295','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','1','1','2025-12-18 17:23:17','','received','','','1','17645841409774');
INSERT INTO `booking` VALUES ('1745','20','1','','2','3418143','2025-11-05','','5794','1653','B JEEVESH RAO','919980647976','','','LOHITHNAGAR','KUNTIKANA MANGALORE','','11','575006','KRTHIK J RAO','919845816674','','MAHAVEER SITARA B1206','J P NAGAR 24TH MAIN 7TH PHASE','','11','560078','Document','0.00','0.00','0.00','0','Document','Surface','1','0.14','','','','','0.14','85.00','1','1','2025-11-05 12:08:32','2025-11-05 12:08:32','17616388667516','17616388667516','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1746','17','1','','3','21505324','2025-11-03','3868','3870','511','DECCAN HERALD ADVERTISEMENT','918217283384','','','BALMATTA MANGALORE','','29AABCT2065N1ZY','11','575002','HARISH','','','DECCAN HERALD','BANGALORE','','11','560001','Document','0.00','0.00','0.00','0','Document','Surface','1','7.60','','','','','7.60','240.00','1','1','2025-11-05 12:08:46','2025-12-18 17:23:16','17617216042295','17617216042295','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','1','1','2025-12-18 17:23:16','','received','','','1','17645841409774');
INSERT INTO `booking` VALUES ('1747','13','1','','2','3404169','2025-11-05','','5795','1654','subhaschandra salian','919148979329','','','nr sharavu temple','','','11','575001','ABHINANDAN ENT','9191576103','','INDIAAN OIL','','','11','576103','Document','10.00','0.00','0.00','0','Document','Surface','1','0.30','','','','','0.30','100.00','1','1','2025-11-05 12:08:46','2025-11-05 12:08:46','17617147018423','17617147018423','','1639','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1748','8','1','','2','3351516','2025-11-05','','5796','1655','GOPALKRISHNA SHETTY','919844429020','','','SUTHUPUDEL','SWAMILAPADAV','','11','574142','BABITHA ALVA','919106411633','','LA VISTA APT MIRA RD','THANE','','14','401107','Document','1.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','100.00','1','1','2025-11-05 12:10:23','2025-11-05 12:10:23','17617178859109','17617178859109','','57','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1749','12','1','','2','3382974','2025-11-05','','5426','1656','MILLION AQUTICS','918884687700','','','PADALNE','KUSHEKAR','','11','575001','SANDEEP C','918921755746','','NIBI NIVAS KOTHERI ROAD','VADUTHALA','ERNAKULAM','12','682023','Parcel','500.00','0.00','0.00','0','Document','Surface','1','0.76','','','','','0.76','160.00','1','1','2025-11-05 12:10:24','2025-11-05 12:10:24','17617206505387','17617206505387','','1930','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1750','22','1','','2','3411148','2025-11-05','','5797','1657','SANTHOSH','919880099836','','','HDFC BK KADRI','MANGALORE','','11','575002','GRETTA VAS','919108244742','','YESU KRIPA','SHANTI NAGAR VARAMBALLI','','11','576213','Document','0.10','0.00','0.00','0','Document','Surface','1','0.23','','','','','0.23','75.00','1','1','2025-11-05 12:11:26','2025-11-05 12:11:26','17617169725275','17617169725275','','1639','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1751','22','1','','2','3411149','2025-11-05','','5798','1658','DHARMAPRIYA','918904293273','','','GIRIDEEP ATTAVARA','MANGALORE','','11','575003','RAJAN IG','918867171073','','MOHAMMED TIFFIN CENTRE','3RD MAIN J RAMAYYA LAYOUT KACHARAKNA HALLI','','11','560084','Document','0.10','0.00','0.00','0','Document','Surface','1','0.40','','','','','0.40','105.00','1','1','2025-11-05 12:15:10','2025-11-05 12:15:10','17617169725275','17617169725275','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1752','20','1','','2','3418144','2025-11-05','','5799','1659','RADHA MEDICALS','919743758883','','','K R RAO ROAD','KARANGALPADY MANGALORE','','11','575003','G S SHIVAKUMAR','917619412684','','F011 PREMIER GRIHALAKSHMI APTS','S M ROAD JALAHALLI WEST','','11','560015','Parcel','850.00','0.00','0.00','0','Document','Surface','1','0.40','','','','','0.40','105.00','1','1','2025-11-05 12:18:16','2025-11-05 12:18:16','17616388667516','17616388667516','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1753','10','1','','2','3406863','2025-11-05','','5800','1660','ARUN KUMAR K','919448394358','','','SAUHARDHA','BHARATHI NAGAR BEJAI','','11','575004','MALLIKA RAJESH','919844903365','','NO 99 SRI VENKATESHWARA NILAYA','RAMANJANEYA NAGAR CHIKKALASANDRA','','11','560061','Document','10.00','0.00','0.00','0','Document','Surface','1','0.12','','','','','0.12','90.00','1','1','2025-11-05 12:26:28','2025-11-05 12:26:28','17617151801089','17617151801089','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1754','23','1','','2','3408627','2025-11-05','','5801','1661','VEENA MRUTHI','919483405785','','','PANDESHWARA','MANGALORE','','23','','SHWETHA A UCHIL','918431189484','','KORAMANGALA','00','','11','560034','Document','100.00','0.00','0.00','0','Document','Surface','1','0.75','','','','','0.75','125.00','1','1','2025-11-05 12:28:53','2025-11-05 12:28:53','17617218175043','17617218175043','URBAN NEST LADIES PG','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1755','24','1','','2','3399548','2025-11-05','','5802','1662','ODIYOOR SRI V.S.S.S.N','918242439114','','','PUMPWELL','MANGALORE','','11','575002','SRI VENUGOPALA MARLA','919980511101','','DIRECTOR ODIYOOR V.S.S.N','BONDEL MANGALORE','','11','575008','Document','10.00','0.00','0.00','0','Document','Surface','1','0.07','','','','','0.07','55.00','1','1','2025-11-05 12:29:51','2025-11-05 12:29:51','17617227102844','17617227102844','','3453','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1756','17','1','','2','3404724','2025-11-05','','5803','1663','KIDS& FAMILY DENTAL CLINIC','919446481258','','','MANGALORE','','','11','575002','DR SHUHUDHA','918296186993','','SHUKRIYA DENTAL CARE','NEAR K V C BANE','','11','574241','Others','0.00','0.00','0.00','0','Document','Surface','1','0.16','','','','','0.16','75.00','1','1','2025-11-05 12:30:07','2025-11-05 12:30:07','17617216042295','17617216042295','','2352','MEDICEINE','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1757','22','1','','2','3411150','2025-11-05','','5804','1664','YAMUNA Y MUTTA','919148520332','','','JAYANAGAR APTS 102','KADRI MANGALORE','','11','575003','YAVANIKA Y MUTTA','919880211205','','THE GIRLS HOSTEL','ARRATRA ACADEMY CAMPUS','','11','560035','Document','0.10','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-05 12:30:09','2025-11-05 12:30:09','17617169725275','17617169725275','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1758','24','1','','2','3399549','2025-11-05','','5802','1665','ODIYOOR SRI V.S.S.S.N','918242439114','','','PUMPWELL','MANGALORE','','11','575002','SRI ASHOK KUMAR U S','919449075395','','DIRECTOR ODIYOOR V.S.S.N','JODUMARGA BANTWAL','','11','574219','Parcel','10.00','0.00','0.00','0','Document','Surface','1','0.07','','','','','0.07','65.00','1','1','2025-11-05 12:35:20','2025-11-05 12:35:20','17617227102844','17617227102844','','783','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1759','7','1','','2','3395063','2025-11-05','','4662','891','ANJANEYA TPT','919901907759','','','TN 29 BK 5523','BAIKAMPADY','','11','575011','SREE VARI TRANSPORT','919443957522','','BOMMASAMUTHIRAN','PAIYUR','','23','635112','Document','0.01','0.00','0.00','0','Document','Surface','1','0.01','','','','','0.01','70.00','1','1','2025-11-05 12:39:27','2025-11-05 12:39:27','17617199828916','17617199828916','','461','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1760','7','1','','2','3395064','2025-11-05','','4662','116','ANJANEYA TPT','919901907759','','','KA 35 B 8350','BAIKAMPADY','','11','575011','THIRUMALAI VASA LORRY BOOK OFFICE','919443455669','','RAYAKOTTA RING ROAD','HOSUR','','23','635109','Document','0.01','0.00','0.00','0','Document','Surface','1','0.01','','','','','0.01','70.00','1','1','2025-11-05 12:41:49','2025-11-05 12:41:49','17617199828916','17617199828916','','452','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1761','24','1','','2','3399550','2025-11-05','','5802','1666','ODIYOOR SRI V.S.S.S.N','918242439114','','','PUMPWELL','MANGALORE','','11','575002','SRI KOKANATH SHETTY','919483456220','','ODIYOOR SRI.V.S.S.N','KODIALBAIL MANGALORE','','11','575003','Document','10.00','0.00','0.00','0','Document','Surface','1','0.07','','','','','0.07','55.00','1','1','2025-11-05 12:42:00','2025-11-05 12:42:00','17617227102844','17617227102844','','3453','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1762','6','1','','2','3381578','2025-11-05','','5805','1667','SREE KUMAR','919916326737','','','PREM SAGAR APT','MANNAGUDDA','','11','575003','SAPNA NAIR N K','918050106225','','CHANDROTH HOUSE','THALASSERY','','12','670101','Document','600.00','0.00','0.00','0','Document','Surface','1','0.10','','','','','0.10','85.00','1','1','2025-11-05 12:44:20','2025-11-05 12:44:20','17617213813089','17617213813089','','276','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1763','24','1','','2','3399551','2025-11-05','','5802','1668','ODIYOOR SRI V.S.S.S.N','918242439114','','','PUMPWELL','MANGALORE','','11','575002','SMT.SARITHA ASHOK','919448904814','','DIRECTOR SRI V.S.S.N','BEJAI KAPIKAD MANGALORE','','11','575004','Document','10.00','0.00','0.00','0','Document','Surface','1','0.07','','','','','0.07','55.00','1','1','2025-11-05 12:45:00','2025-11-05 12:45:00','17617227102844','17617227102844','','3453','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1764','7','1','','2','3395065','2025-11-05','','4662','1669','ANJANEYA TPT','919901907759','','','KA 35 B 8350','BAIKAMPADY','','11','575011','SUCCESS TRANSPORT','919790417203','','METTUR TK','SALEM','','23','636452','Document','0.01','0.00','0.00','0','Document','Surface','1','0.01','','','','','0.01','70.00','1','1','2025-11-05 12:45:13','2025-11-05 12:45:13','17617199828916','17617199828916','','1815','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1765','17','1','','2','3404725','2025-11-05','','5806','1670','ELIAN FERNDES','919448117722','','','MANGALORE','','','11','575002','HANUMAN H/W','919980349363','','H M T MAIN ROAD','MATHIKERE','','11','560054','Document','0.00','0.00','0.00','0','Document','Surface','1','0.63','','','','','0.63','130.00','1','1','2025-11-05 12:46:10','2025-11-05 12:46:10','17617216042295','17617216042295','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1766','26','1','','2','3400899','2025-11-05','','5807','1671','g p naik','917907448520','','','kumpala','mlr','','11','','pandu','919901557569','','pandu shop','yeshwanthpur','','11','560022','Document','0.00','0.00','0.00','0','Document','Surface','1','0.05','','','','','0.05','60.00','1','1','2025-11-05 12:47:19','2025-11-05 12:47:19','17615707686074','17615707686074','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1767','24','1','','2','3399552','2025-11-05','','5802','1672','ODIYOOR SRI V.S.S.S.N','918242439114','','','PUMPWELL','MANGALORE','','11','575002','SRI GANESH ATTAVARA','919844455257','','DIRECTOR SRI V.S.S.N','ATTAVARA MANGALORE','','11','575002','Document','10.00','0.00','0.00','0','Document','Surface','1','0.07','','','','','0.07','55.00','1','1','2025-11-05 12:47:59','2025-11-05 12:47:59','17617227102844','17617227102844','','3453','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1768','23','1','','2','3408628','2025-11-05','','5808','1673','DEVI PRASAD RAI','919964319917','','','PANDESWARA','','','23','','PADMANABHA S SHETTY','919341840107','','MURUDESHWAR POST','00','','11','581350','Document','100.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-05 12:51:21','2025-11-05 12:51:21','17617218175043','17617218175043','NEAR K G SCHOOL','1689','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1769','23','1','','2','3408629','2025-11-05','','5809','1674','DEVI PRASAD RAI','917975820202','','','PANDESHWARA','MANGALORE','','23','','GOVINDA NAIK','918693867037','','SALES MARINE SERVICES LTD','PHASE 1 A','VERNA INDU AREA','6','403722','Document','100.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','70.00','1','1','2025-11-05 12:53:32','2025-11-05 12:53:32','17617218175043','17617218175043','','628','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1770','18','1','','2','3385060','2025-11-05','','5810','1675','JAYASHREE','918928539192','','','MALEKOPPAL','MANGALORE','','11','575013','JAGADISH BANGERA','917977795129','','THAKURWADI NEAR SAMRAT','DOMBIVALI WEST','','14','421202','Document','10.00','0.00','0.00','0','Document','Surface','1','0.64','','','','','0.64','230.00','1','1','2025-11-05 12:54:32','2025-11-05 12:54:32','17621531273939','17621531273939','','1179','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1771','7','1','','2','3395066','2025-11-05','','5811','1676','SRI DURGA RW','919845195216','','','GIRIRAJ TOWERS','KULAI','','11','575012','HARISH P B','917483319645','','NETRAVATI LAYOUT KADABAGERE ROAD','MAGADI MAIN ROAD','','11','562130','Document','0.01','0.00','0.00','0','Document','Surface','1','0.01','','','','','0.01','60.00','1','1','2025-11-05 13:00:39','2025-11-05 13:00:39','17617199828916','17617199828916','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1772','18','1','','2','3385061','2025-11-05','','5812','1677','MANEESH T S','918593085103','','','IOCL MANGALORE','','','11','575010','KONSTELEC ENGINEERS LTD','918452995095','','KIROL ROAD VIDYAVIHAR WEST','MUMBAI MAHARASHTRA','','14','400086','Document','10.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','100.00','1','1','2025-11-05 13:02:36','2025-11-05 13:02:36','17621531273939','17621531273939','','2076','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1773','23','1','','2','3408630','2025-11-05','','5813','1678','DEVADAS ULLAL','919739791068','','','ULLAL','MANGALORE','','23','','DIVIKSHA ULLAL','918904790723','','OFF GST ROAD','NELLIKUPPAM ROAD IYYAPPA NAGAR','00','23','603202','Document','100.00','0.00','0.00','0','Document','Surface','1','1.00','','','','','1.00','160.00','1','1','2025-11-05 13:04:24','2025-11-05 13:04:24','17617218175043','17617218175043','','1931','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1774','16','1','','2','3357247','2025-11-05','','5814','1679','ROSHAN PETER SEQUIERA','919972339384','','','KAIKAMBA','MANGALORE','','11','574151','SWETHA SHARMA','919123381305','','UNIVERSAL CORPORATION LTD','SIKKIM COMMERCE HOUSE','','28','700071','Document','100.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','100.00','1','1','2025-11-05 13:05:18','2025-11-05 13:05:18','17617177578387','17617177578387','','2666','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1775','7','1','','2','3395067','2025-11-05','','5815','1680','HARIOM TRANSPORT','919945062760','','','BAIKAMPADY','MANGALORE','','11','575011','ARUL GANESH TRANSPORT','919442966956','','THURAIYUR ROAD','NAMAKKAL','','23','637002','Document','0.01','0.00','0.00','0','Document','Surface','1','0.01','','','','','0.01','70.00','1','1','2025-11-05 13:06:16','2025-11-05 13:06:16','17617199828916','17617199828916','','2424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1776','7','1','','2','3395068','2025-11-05','','5815','322','HARIOM TRANSPORT','919945062760','','','BAIKAMPADY','MANGALORE','','11','575011','BASKARRAJ LORRY BOOK OFFICE','919486157333','','NARIPPALAM','ERODE','','23','638102','Document','0.01','0.00','0.00','0','Document','Surface','1','0.01','','','','','0.01','70.00','1','1','2025-11-05 13:06:57','2025-11-05 13:06:57','17617199828916','17617199828916','','114','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1777','17','1','','2','3404726','2025-11-05','','5816','1681','ANIL','919582804231','','','MANGALORE','','','11','575002','DINESH MOGAVEERA','919591571446','','SOMESHWAR ROAD','','','11','576214','Others','0.00','0.00','0.00','0','Document','Surface','1','13.00','','','','','13.00','1105.00','1','1','2025-11-05 13:08:00','2025-11-05 13:08:00','17617216042295','17617216042295','','3370','POOJA BATHI','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1778','22','1','','2','3411151','2025-11-05','','5817','1682','gireesh','919480153064','','','SHRAVAN HOUSE','MAROLI KULSHEKHAR MANGALORE','','11','575005','SARFARAZ ALAM','917259920070','','NO 284 2ND FLOOR','13TH CROSS GANGAMMA LAYOUT','','11','560068','Document','0.10','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-05 13:08:44','2025-11-05 13:08:44','17617169725275','17617169725275','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1779','23','1','','2','3408631','2025-11-05','','5818','1683','VINAYA KUMAR','918296592929','','','PANDESHWARA','MANGALORE','','23','','VIJAY KUMAR G','919242436433','','SBI COLONY','CHIKKODI','','11','591201','Document','100.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-05 13:09:02','2025-11-05 13:09:02','17617218175043','17617218175043','MUSANDI','4','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1780','10','1','','2','3406864','2025-11-05','','5293','868','RAKESH K','919611023407','','','MANOHAR CHOWDHRY & ASSO','NEAR KSRTC BEJAI','','11','575004','VARSHA','919535904906','','BALAJI HOUSE','NEAR KUMODARI MATA','','11','574219','Parcel','500.00','0.00','0.00','0','Document','Surface','1','1.30','','','','','1.30','180.00','1','1','2025-11-05 13:09:50','2025-11-05 13:09:50','17617151801089','17617151801089','','1006','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1781','22','1','','2','3411152','2025-11-05','','5817','1684','gireesh','919480153064','','','SHRAVAN HOUSE','MAROLI KULSHEKHAR MANGALORE','','11','575005','RAFEEK A A','919731311197','','KONDANGERI POST','HALUGUNDA VILLAGE VIRAJPET','','11','571211','Document','9950.00','0.00','0.00','0','Document','Surface','1','0.35','','','','','0.35','105.00','1','1','2025-11-05 13:11:09','2025-11-05 13:11:09','17617169725275','17617169725275','','291','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1782','24','1','','2','3399553','2025-11-05','','5819','1685','KOSAMATTAM FINANCE LTD','918242431722','','','PUMPWELL','MANGALORE','','11','575002','KOSAMATTAM FINANCE LTD','918921772728','','OPP BUS STAND MAIN ROAD','MADANTHYAR BELTHANGADY','','11','574224','Document','10.00','0.00','0.00','0','Document','Surface','1','0.08','','','','','0.08','65.00','1','1','2025-11-05 13:11:55','2025-11-05 13:11:55','17617227102844','17617227102844','','2580','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1783','17','1','','3','21505321','2025-11-03','3910','3905','511','MEDIGLOBE','918147760815','','','3RD FLOOR,\'\'PARIN\'\' COLLECTORS GATE CIRCLE,BALMATTA MANGALURE-1','','29AIGPB0221L1ZL','11','575002','DR N RAMESH','','','SHIMOGGA','SHIMOGGA','','11','577202','Document','0.01','0.00','0.00','0','Document','Surface','1','2.60','','','','','2.60','477.00','1','1','2025-11-05 13:12:01','2025-12-14 08:36:02','17617216042295','17617216042295','','1829','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','1','0','','','','','','1','');
INSERT INTO `booking` VALUES ('1784','26','1','','2','3400900','2025-11-05','','5820','1686','shayika','917349344919','','','harekala','mlr','','11','574199','nishama','919380746637','','jari nagar','bajpe','','11','574142','gift','0.00','0.00','0.00','0','Document','Surface','1','0.30','','','','','0.30','75.00','1','1','2025-11-05 13:13:07','2025-11-26 15:56:16','17615707686074','17615707686074','','3453','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1785','17','1','','3','21505322','2025-11-03','3910','3905','511','MEDIGLOBE','918147760815','','','3RD FLOOR,\'\'PARIN\'\' COLLECTORS GATE CIRCLE,BALMATTA MANGALURE-1','','29AIGPB0221L1ZL','11','575002','S D PHARMACY','','','DHARWAD','','','11','560001','Parcel','0.00','0.00','0.00','0','Document','Surface','1','3.60','','','','','3.60','661.00','1','1','2025-11-05 13:14:00','2025-12-14 08:36:02','17617216042295','17617216042295','','379','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','1','0','','','','','','1','');
INSERT INTO `booking` VALUES ('1786','22','1','','2','3411153','2025-11-05','','5821','1687','SHREEKUMAR','919480704688','','','KADRI','MANGALORE','','11','575003','SKILWORTH TECHNOLGIOS','918123230323','','11TH CROSS MALLESHWARAM','BANGALORE','','11','560003','Document','0.10','0.00','0.00','0','Document','Surface','1','0.53','','','','','0.53','125.00','1','1','2025-11-05 13:14:55','2025-11-05 13:14:55','17617169725275','17617169725275','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1787','26','1','','2','3400901','2025-11-05','','5820','1688','shayika','917349344919','','','harekala','mlr','','11','574199','nafiya shahid','919946404224','','po charla','kgd','','12','671322','gif','0.00','0.00','0.00','0','Document','Surface','1','0.18','','','','','0.18','95.00','1','1','2025-11-05 13:15:47','2025-11-05 13:15:47','17615707686074','17615707686074','','879','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1788','10','1','','2','3406865','2025-11-05','','5822','1689','K SHASHINDRA','919886175917','','','BEJAI KAPIKAD','MANGALORE','','23','','KPTC EMPLOYEES UNION','919902861651','','CENTRAL COMMITTEE','ANANDA RAO CRICLE','','11','560009','Document','10.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-05 13:15:49','2025-11-05 13:15:49','17617151801089','17617151801089','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1789','24','1','','2','3399554','2025-11-05','','5823','1690','NAGARAJ NAYAK','919341003597','','','GLORIA','BANGALORE','','11','560001','MISS DURGADEVI','917397364960','','HBC LIFE SCINCES PVT LTD','ALAPAKKAM CHENNAI','','23','600116','Document','10.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','70.00','1','1','2025-11-05 13:16:34','2025-11-05 13:16:34','17617227102844','17617227102844','','1931','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1790','14','1','','2','3364696','2025-11-05','','5824','1691','D JOEL DHAS','919481017987','','','CANARA BANK CIRCLE OFFICE','LIGHT HOUSE HILL RD BALMATA RD','','11','575001','UCO BANK','919481017987','','UDUMALPET BRNCH PLOT NO 67','KALYANI NAGAR PALANI RD','','23','642154','Document','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','70.00','1','1','2025-11-05 13:18:35','2025-11-05 13:18:35','17617209872567','17617209872567','','1638','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1791','24','1','','2','3399555','2025-11-05','','5823','94','NAGARAJ NAYAK','919341003597','','','GLORIA','BANGALORE','','11','560001','HBC PHARMACEUTICALS PVT LTD','919099977793','','GANDHI NAGAR','GUJARATH','','14','382421','Document','10.00','0.00','0.00','0','Document','Surface','1','0.08','','','','','0.08','120.00','1','1','2025-11-05 13:18:36','2025-11-06 10:25:35','17617227102844','17617227102844','','381','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1792','7','1','','2','3395069','2025-11-05','','5825','1692','ADITHYA ELECTRICAL','919632092578','','','CHITHRAPURA DHWARA','BAIKAMPADY','','11','575011','AXON ELECTRIC CORP','917026625540','','PEENYA IND ESTATE','BANGALORE','','11','560058','Document','15000.00','0.00','0.00','0','Document','Surface','1','1.14','','','','','1.14','200.00','1','1','2025-11-05 13:20:36','2025-11-05 13:20:36','17617199828916','17617199828916','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1793','14','1','','2','3364697','2025-11-05','','5348','1693','CAUVERY KARNATAKA STATE','919845496921','','','ARTS & CRAFTS EMPORIUM','CITY LIGHT BLDG BALMATA RD HAMPANKATTA','','11','575007','THE MANAGING DIRECTOR','918071204445','','KSHDCL COMPLEX','NO 45 3 RD FLOOR M G RD','','11','560001','Document','10.00','0.00','0.00','0','Document','Surface','1','0.27','','','','','0.27','105.00','1','1','2025-11-05 13:24:04','2025-11-05 13:24:04','17617209872567','17617209872567','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1794','12','1','','2','3382954','2025-11-05','','5826','511','ABDUL SHIYAD K','919567453729','','','SHETHAL MAJILA SEMINARY VIEW','3RD CROSS JEPPU MANGALORE','','11','575001','MEDI ASSIST TPA P LTD','','','58/1 A SINGHASANDRA VILLAGE HOSUR MAIN RD','BEGUR HOBLI BANGALORE SOUTH','','11','560068','Document','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-05 13:24:39','2025-11-05 13:24:39','17617206505387','17617206505387','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1795','20','1','','2','3418145','2025-11-05','','5827','1694','UPADYAPRAMOD','919632430727','','','KAVOOR ROAD','BONDEL MANGALORE','','11','575015','SWAPNIL MAHAPADI','912268309999','','ARISTO PHARMA PVT LTD','ANDHERI WEST','','14','400053','Document','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','100.00','1','1','2025-11-05 13:25:34','2025-11-05 13:25:34','17616388667516','17616388667516','','57','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1796','25','1','','2','3388903','2025-11-05','','5828','1695','D THANGARAJ','917598519082','','','FIVE STAR SUPER BAZAR','SURATHKAL','','11','575030','VANGLI TRT','919577705858','','KARUNGAL PUDAR','PAPPINAICKENPATTI NAMAKKAL','','23','637003','Document','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','70.00','1','1','2025-11-05 13:27:18','2025-11-05 13:27:18','17617202587270','17617202587270','','2424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1797','6','1','','2','3381579','2025-11-05','','5829','1696','AUTO MARK','919845083303','','','R G COMPLEX ALAKE','KUDROLI','','11','575003','AUTO MARK','919483480649','','NARASIMHA BHAVAN','VIHNUVARDHANA RD CHAMARAJPURAM','','11','570005','Document','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-05 13:28:21','2025-11-05 13:28:21','17617213813089','17617213813089','','669','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1798','20','1','','2','3418146','2025-11-05','','5830','511','BANK OF MAHARASTRA','916366535017','','','KARANGALPADY','MANGALORE','','11','575003','BANK OF MAHARASTRA','','','FIRST FLOOR HUBLI DHARWAD MAIN ROAD','VIDYANAGAR','','11','580021','Document','100.00','0.00','0.00','0','Document','Surface','1','3.10','','','','','3.10','569.00','1','1','2025-11-05 13:28:24','2025-11-05 13:28:24','17616388667516','17616388667516','','557','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1799','25','1','','2','3388904','2025-11-05','','5831','1697','ANEESH AND NANDAN','916362699426','','','KRISHNA ARCADE','SURATHKAL','','11','575014','RASHMI SANDEEP POOJARY','919821361558','','NEAR SHIVANI HOSPITAL SHREE NAGAR','WAGLE ESTATE THANE','','14','400604','Document','100.00','0.00','0.00','0','Document','Surface','1','0.20','','','','','0.20','130.00','1','1','2025-11-05 13:30:26','2025-11-05 13:30:26','17617202587270','17617202587270','','739','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1800','12','1','','2','3382975','2025-11-05','','5832','1698','ABDUL SHAMSHEER','919538282218','','','JAMAL MANZIL NR PINTO GARDEN','HOIGEBAZAR RD BOLAR','','11','575001','SHOBHA','919632080358','','SELLER SQAURE P LTD 3RD FLOOR','SINGSANDRA POST HOSUR ROAD','','11','560068','Document','10.00','0.00','0.00','0','Document','Surface','1','0.06','','','','','0.06','75.00','1','1','2025-11-05 13:34:33','2025-11-05 13:34:33','17617206505387','17617206505387','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1801','23','1','','2','3408632','2025-11-05','','5833','1699','YOG MAYA ELECTRICAL','919157772457','','','BUNDER','MANGALORE','','23','','NARREET CONSTRUCTION','919466658259','','SECTOR C DEFENCE COLONY','00','','8','133001','Document','100.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','100.00','1','1','2025-11-05 13:34:45','2025-11-05 13:34:45','17617218175043','17617218175043','','2835','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1802','25','1','','2','3388905','2025-11-05','','5834','1700','LAKSHMANAN','916385688981','','','FIVE STAR SUPER BAZAR','MRPL ROAD BALA','','11','575030','BHADRA XPS','918667871891','','242 SALEM ROAD','NAMAKKAL','','23','637001','Document','100.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','70.00','1','1','2025-11-05 13:35:07','2025-11-05 13:35:07','17617202587270','17617202587270','','2424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1803','22','1','','2','3411154','2025-11-05','','5835','1701','VIRUPAKSHA H P','919986467373','','','KULSHEKHAR','MANGALORE','','11','575005','SCHILLER HEALTHCARE INDIA','918026564045','','2ND CROSS BIKASIPURA RD','J C IND LAYOUT YELACHENAHALLI','','11','560078','Document','0.10','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-05 13:35:19','2025-11-05 13:35:19','17617169725275','17617169725275','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1804','16','1','','2','3357248','2025-11-05','','5836','1702','PRAVEEN ALVA','919880980933','','','KULAVOOR','MANGALORE','','11','','SANJAY THAKUR','919702318555','','MORE RETAIL P LTD','ANDHERI KURLA ROAD','','14','400059','Document','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','100.00','1','1','2025-11-05 13:35:20','2025-11-05 13:35:20','17617177578387','17617177578387','','57','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1805','12','1','','2','3382976','2025-11-05','','5832','1703','ABDUL SHAMSHEER','919538282218','','','JAMAL MANZIL NR PINTO GARDEN','HOIGEBAZAR RD BOLAR','','11','575001','MOHD YASER','919964294900','','NR GINGER HOTEL VAKAD PUNE','','','14','411057','Non Doc','700.00','0.00','0.00','0','Document','Surface','1','0.45','','','','','0.45','170.00','1','1','2025-11-05 13:36:58','2025-11-05 13:36:58','17617206505387','17617206505387','E57 APT FLAT NO E-401 BHUMKAR CHOWK','13','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1806','25','1','','2','3388906','2025-11-05','','5837','1704','MARIAPPAN','919488850041','','','FIVE STAR SUPER','KANA BALA','','11','575030','S SAMPATH','919444810816','','RAGAVENDRA COLONY','VIRUBAMBAKKAM CHENNAI','','23','600092','Document','10.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','70.00','1','1','2025-11-05 13:38:15','2025-11-05 13:38:15','17617202587270','17617202587270','','1931','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1807','23','1','','2','3408633','2025-11-05','','5838','1705','YUVARAJ LAMANI','918971126818','','','CITY CONTROL  ROOM','MANGALORE','','23','','MOTOROLA SOLUTIONS INDIA PVT LTD','919844218850','','COMMUNICATION TEST DESIGN INDIA PVT LTD','PEENYA INDU AREA','','11','','Document','100.00','0.00','0.00','0','Document','Surface','1','10.30','','','','','10.30','1210.00','1','1','2025-11-05 13:38:26','2025-11-05 13:38:26','17617218175043','17617218175043','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1808','13','1','','2','3404170','2025-11-05','','5839','1706','BHANDARY SCHOOL BOOK CO','918951139777','','','CARST','MANGALROE','29AAJCB7442H1ZE','11','575001','ST JOSEPH PU COLLEGE','919901854842','','JANNA JYOTHI ATTIABLEROAD','OPP COURT TO ANEKAL','','11','562106','Document','10.00','0.00','0.00','0','Document','Surface','1','18.81','','','','','18.81','2090.00','1','1','2025-11-05 13:38:29','2025-11-05 13:38:29','17617147018423','17617147018423','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1809','25','1','','2','3388907','2025-11-05','','5840','1707','R GANESAN','919715426115','','','FIVE STAR SUPER','KANA BALA','','11','575014','SEMPARUTHI BULK CARRIERS','919443385398','','PATTI PARAMATHI ROAD','VALLI PURAM NAMAKKAL','','23','637003','Document','10.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','70.00','1','1','2025-11-05 13:40:20','2025-11-05 13:40:20','17617202587270','17617202587270','','2424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1810','25','1','','2','3388908','2025-11-05','','5841','1708','FIVE STAR SUPER BAZAR','916383795522','','','KANA SKL','SKL','','11','575030','CKP BULK CARRIERS','919677617355','','PARAMATHI ROAD','THILLAIPURAM NAMAKKAL','','23','637001','Document','10.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','70.00','1','1','2025-11-05 13:45:45','2025-11-05 13:45:45','17617202587270','17617202587270','','2424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1811','8','1','','2','3351517','2025-11-05','','5842','1709','VAIBHAV PARKAR','917767024676','','','GADRE MARINE EXPORT LTD','BAJPE','','11','574142','C ABHAY KUMAR  AND CO','919322273356','','105 DAMODAR BLDG PRINCESS STREET','MUMBAI','','14','400002','Non Doc','41000.00','0.00','0.00','0','Document','Surface','1','23.00','','','','','23.00','3500.00','1','1','2025-11-05 13:48:00','2025-11-05 13:48:00','17617178859109','17617178859109','','57','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1812','25','1','','2','3388909','2025-11-05','','5843','1710','PALANIVEL','919442126184','','','FIVE STAR SUPER','SKL','','11','575014','MSP BULK CARRIER','911994468988','','SALEM ROAD','NAMAKKAL','','23','637001','Document','100.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','70.00','1','1','2025-11-05 13:48:29','2025-11-05 13:48:29','17617202587270','17617202587270','','2424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1813','7','1','','2','3395070','2025-11-05','','5844','1711','DHEERAJ S','919611716777','','','BAIKAMPADY','MANGALORE','','11','575011','MANMOHAN DOBEY','919972451827','','VASUNDHARA COMPLEX','KALYAN NAGAR','','11','560043','Document','0.01','0.00','0.00','0','Document','Surface','1','0.01','','','','','0.01','60.00','1','1','2025-11-05 13:48:34','2025-11-05 13:48:34','17617199828916','17617199828916','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1814','25','1','','2','3388910','2025-11-05','','5845','1712','ARUNA','917708669982','','','FIVE STAR SUPER','KANA BALA','','11','575014','R BALAJI','919843809945','','MEENA LPG IND','MADUKKARAI COIMBATORE','','23','641105','Document','10.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','70.00','1','1','2025-11-05 13:51:02','2025-11-05 13:51:02','17617202587270','17617202587270','','535','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1815','17','1','','2','3404727','2025-11-05','','5846','1713','MEDIGLEN HEALTHCARE','919845329442','','','VELENCIA','MANGALORE','','11','575002','SHAMSHUDDIN SAMPYA','919449085239','','ARYAPU POST','SAMPTA ROAD','','11','574201','Others','0.01','0.00','0.00','0','Document','Surface','1','0.55','','','','','0.55','95.00','1','1','2025-11-05 13:51:44','2025-11-05 13:51:44','17617216042295','17617216042295','','1904','MEDICINE','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1816','25','1','','2','3388911','2025-11-05','','5847','1714','KRISHNAMOORTHY','916380530261','','','FIVE STAR','KANA BALA','','11','575030','V N TRT','917708333219','','SALEM ROAD','NAMAKKAL','','23','637001','Document','10.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','70.00','1','1','2025-11-05 13:52:59','2025-11-05 13:52:59','17617202587270','17617202587270','','2424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1817','20','1','','2','3418147','2025-11-05','','5848','1715','ADISH INFRATECH','919902485368','','','VIJAYA COMMERCIAL COMPLEX','MANNAGUDDA MANGALORE','','11','575003','ESSKAY DISTRIBUTORS','919008498036','','#134 KILAROI ROAD','BANGALORE','','11','560053','Document','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-05 13:54:20','2025-11-05 13:54:20','17616388667516','17616388667516','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1818','25','1','','2','3388912','2025-11-05','','5849','1716','NATARAJAN','918903288873','','','FIVE STAR SUPER','KANA BALA','','11','575014','KPN BULK CARRIERS','919003495962','','RASIKUMARIPALAYAM STREET','MOHANUR  NAMAKKAL','','23','637015','Document','10.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','70.00','1','1','2025-11-05 13:55:45','2025-11-05 13:55:45','17617202587270','17617202587270','','2424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1819','25','1','','2','3388913','2025-11-05','','5850','204','A RAMESH','919944646722','','','FIVE STAR SUPER','SKL','','11','575014','KKK  TRANSPORT','919443731899','','MAHALAKSHMI  TRANSPOT','PARAMATHIM ROAD','','23','637001','Document','10.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','70.00','1','1','2025-11-05 13:57:09','2025-11-05 13:57:09','17617202587270','17617202587270','','2424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1820','20','1','','2','3418148','2025-11-05','','5851','1717','ARUNA ADVOCATE','919448116700','','','KARANGALPADY','MANGALORE','','11','575003','K RAVISHANKAR ADVOCATE','919448104400','','ARPITHA #56 2ND MAIN ROAD','MARUTHINAGAR J P NAGAR 7TH PHASE','','11','560078','Document','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-05 13:57:35','2025-11-05 13:57:35','17616388667516','17616388667516','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1821','23','1','','2','3408634','2025-11-05','','5852','1718','KERALA TRANSPORT','919343346396','','','BUNDER','MANGALORE','','23','','THE ZONAL MANAGER','919745343220','','KERALA TRANSPORT CO','YMCA ROAD','','12','673001','Document','100.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','70.00','1','1','2025-11-05 13:58:47','2025-11-05 13:58:47','17617218175043','17617218175043','','112','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1822','25','1','','2','3388914','2025-11-05','','5853','1719','FIVE STAR SUPER','919487715994','','','KANA BALA','SKL','','11','575030','SARAVANAN TRT','919443264410','','BYE PASS ROAD','MADUKKARI 641105','','23','641105','Document','10.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','70.00','1','1','2025-11-05 13:59:22','2025-11-05 13:59:22','17617202587270','17617202587270','','2424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1823','20','1','','2','3418149','2025-11-05','','5854','511','SATHISH K','919535733994','','','EMPIRE MALL','M G ROAD MANGALORE','','11','575003','MAHARSTRA APEX CORP LTD','','','SYNDICATE HOUSE','MANIPAL','','11','576119','Document','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','50.00','1','1','2025-11-05 13:59:41','2025-11-05 13:59:41','17616388667516','17616388667516','','662','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1824','23','1','','2','3408635','2025-11-05','','5852','1720','KERALA TRANSPORT','919343346396','','','BUNDER','MANGALORE','','23','','THE ADMINISTRTION SECTION','914952766362','','KERALA TRANSPORT CO','YMCA ROAD','','12','673001','Document','100.00','0.00','0.00','0','Document','Surface','1','0.40','','','','','0.40','120.00','1','1','2025-11-05 14:00:46','2025-11-05 14:00:46','17617218175043','17617218175043','','112','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1825','18','1','','2','3385062','2025-11-05','','5586','1314','JACWAYS LOGISTICES LLP','917019658642','','','COMMERCE CENETRE KULUR','MANGALORE','','11','575013','WESTERN COFFEE COURERS AND EXPORTS','919108983194','','SADASHIVA NAGAR BANGALORE','','','11','560080','Document','10.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-05 14:01:05','2025-11-05 14:01:05','17621531273939','17621531273939','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1826','21','1','','2','3393138','2025-11-05','','5855','1721','JAGDISH SALIAN','919986150866','','','SALIAN NIVAS','S B BOLOOR','','11','575006','MD MASTAN','911861828977','','ASIAN PAINTS LTD','BLOCK E, KALBEBUDDEWERE HOUSE, P B ROAD','','11','580029','Document','100.00','0.00','0.00','0','Document','Surface','1','0.08','','','','','0.08','75.00','1','1','2025-11-05 14:01:33','2025-11-05 14:01:33','17616388051318','17616388051318','','557','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1827','23','1','','2','3408636','2025-11-05','','5856','1722','KISHU KUMARI C H','917907382331','','','UBI RO','MANGALORE','','23','','HERTIAGE INSURANCE TPA','919916593159','','BADMI ARCADE','BASNHAKARI 3RD STAGE','','11','560085','Document','100.00','0.00','0.00','0','Document','Surface','1','0.25','','','','','0.25','85.00','1','1','2025-11-05 14:03:17','2025-11-05 14:03:17','17617218175043','17617218175043','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1828','21','1','','2','3393139','2025-11-05','','5857','1723','MUSTAFA H','919844206477','','','CARGO SEA GROUP SHIPPING CO','MANGALORE','','11','575006','KPG TRADING CO','919895979749','','K P TOWER','PALLIKKAL BAZAR','','12','673634','Document','100.00','0.00','0.00','0','Document','Surface','1','0.20','','','','','0.20','95.00','1','1','2025-11-05 14:04:30','2025-11-05 14:04:30','17616388051318','17616388051318','','284','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1829','10','1','','2','3406866','2025-11-05','','5858','1724','CHANDRASHEKARA','917760484636','','','PUMPWELL','MANGALORE','','11','575004','MEDITECH INC','918296264757','','12TH MAIN ROAD','6TH BLOCK RAJAJI NAGAR','','11','560010','Document','10.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-05 14:06:21','2025-11-05 14:06:21','17617151801089','17617151801089','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1830','13','1','','2','3404171','2025-11-05','','5859','1725','KISHAN','917975790678','','','CARST','','','11','575001','MAHIN KUNJU','919847961009','','KUTTIKATTUAPA','','','12','683501','Document','10.00','0.00','0.00','0','Document','Surface','1','0.10','','','','','0.10','90.00','1','1','2025-11-05 14:09:17','2025-11-05 14:09:17','17617147018423','17617147018423','','1930','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1831','13','1','','2','3404172','2025-11-05','','5860','1726','KISHAN','917975282370','','','CAST','MANGALORE','','11','575001','SIBIN DAS','917012001247','','SRI KISHNA FURINTURE','NEDUMABASSER','','12','683589','Document','10.00','0.00','0.00','0','Document','Surface','1','0.10','','','','','0.10','90.00','1','1','2025-11-05 14:11:21','2025-11-05 14:11:21','17617147018423','17617147018423','','2432','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1832','21','1','','2','3393140','2025-11-05','','5861','452','SHAKEEL','919037396346','','','CANARA AGRO FARM, KUMPALA BYPASS','KOTEKAR','','11','575006','INCOME TAX PAN SERVICES UNIT','918494900188','','4TH FLOOR, SAPPHOIRE CHAMBERS','BANER ROAD, BANER','','14','411045','Document','100.00','0.00','0.00','0','Document','Surface','1','0.12','','','','','0.12','130.00','1','1','2025-11-05 14:12:15','2025-11-05 14:12:15','17616388051318','17616388051318','','13','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1833','23','1','','2','3408637','2025-11-05','','5862','1727','G K PAI','919449770505','','','RTO','MANGALORE','','23','','BAGADE RADHAKRISHNA RAO','919447096107','','MEHMOOB TRAVELS','KPR RAO ROAD','','12','671121','Document','100.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','70.00','1','1','2025-11-05 14:16:24','2025-11-05 14:16:24','17617218175043','17617218175043','','1062','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1834','6','1','','2','3381580','2025-11-05','','5863','1728','HEMANTH KULAL','919902892523','','','URWASTORE','MANGALORE','','11','575003','PRIYA S','919844264631','','4TH CROSS OM SHAKTI LAYOUT','KR PURAM BANGALORE','','11','560036','Document','0.01','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-05 14:16:41','2025-11-05 14:16:41','17617213813089','17617213813089','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1835','13','1','','2','3404173','2025-11-05','','5864','1466','LAXMI TELECOM','918073863011','','','MKTROAD','','','11','575001','MABENDRA KUMAR','917727952102','','NEAR APSARA TALIES','','','14','400007','Document','1850.00','0.00','0.00','0','Document','Surface','1','1.80','','','','','1.80','610.00','1','1','2025-11-05 14:16:45','2025-11-05 14:16:45','17617147018423','17617147018423','','57','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1836','20','1','','2','3418150','2025-11-05','','5865','1729','TAVA','918867368944','','','M G ROAD','OPP PVS BUILDING','','11','575003','ISHAAN MAHAJAN','919999914305','','NIH HOSTEL BLOCK C','MANIPAL UNIVERSITY ESHWAR NAGAR','','11','576104','Parcel','15000.00','0.00','0.00','0','Document','Surface','1','3.30','','','','','3.30','455.00','1','1','2025-11-05 14:16:56','2025-11-05 14:16:56','17616388667516','17616388667516','','662','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1837','10','1','','2','3406867','2025-11-05','','5866','1730','YATHISH','919590595259','','','D K MUL','KULSHEKARA MANGALORE','','11','','SURAKSHA SECURITY SERVICES','919844002954','','PRASHANTH BLDG,','R C ROAD','','11','573201','Parcel','200.00','0.00','0.00','0','Document','Surface','1','0.45','','','','','0.45','110.00','1','1','2025-11-05 14:18:25','2025-11-05 14:18:25','17617151801089','17617151801089','','448','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1838','20','1','','2','3418151','2025-11-05','','5867','511','BRIGHT HR SOLUTIONS','918296151083','','','KODIALBAIL','','','11','575003','PODAR INT SCHOOL','','','SHIVALLI VILLAGE','PERAMPALLI','','11','576102','Document','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','50.00','1','1','2025-11-05 14:19:03','2025-11-05 14:19:03','17616388667516','17616388667516','','1639','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1839','14','1','','2','3364698','2025-11-05','','6145','2185','MR PRADEEP PAI K','919740017070','','','FLAT NO 102 ASHOK PALACE','DONBASCO CROSS FALNIR','','11','575001','SANTHOSHA R','918069278000','','PHARMED LTD SATVA MINDCOMP TECH PARK','GROUND FLOOR OFC 1 WHITEFIELD IND AREA','','11','560066','Document','0.00','0.00','0.00','0','Document','Surface','1','0.23','','','','','0.23','85.00','1','1','2025-11-05 14:19:50','2025-11-06 10:45:04','17617209872567','17617209872567','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1840','17','1','','3','21505466','2025-11-03','3910','3905','511','MEDIGLOBE','918147760815','','','3RD FLOOR,\'\'PARIN\'\' COLLECTORS GATE CIRCLE,BALMATTA MANGALURE-1','','29AIGPB0221L1ZL','11','575002','SHAMEERABANU','','','MOODABIDRE','','','11','574227','Document','0.00','0.00','0.00','0','Document','Surface','1','1.80','','','','','1.80','245.00','1','1','2025-11-05 14:20:00','2025-12-14 08:36:02','17617216042295','17617216042295','','1731','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','1','0','','','','','','1','');
INSERT INTO `booking` VALUES ('1841','13','1','','2','3404174','2025-11-05','','5868','1732','PRATHAM POWER','918242492138','','','ALAKE','','','11','575001','GAJENDRA LUMINOUS POWER','919731314219','','HSR LAYOUT','','','11','560102','Document','10.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-05 14:21:36','2025-11-05 14:21:36','17617147018423','17617147018423','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1842','17','1','','3','21505453','2025-11-03','3910','3905','511','MEDIGLOBE','918147760815','','','3RD FLOOR,\'\'PARIN\'\' COLLECTORS GATE CIRCLE,BALMATTA MANGALURE-1','','29AIGPB0221L1ZL','11','','ZUDYS LIFE','','','BLR','BLR','','11','575001','Document','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','30.00','1','1','2025-11-05 14:21:56','2025-12-13 16:58:27','17617216042295','17617216042295','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','1','0','','','','','','1','');
INSERT INTO `booking` VALUES ('1843','21','1','','2','3393141','2025-11-05','','5869','865','MOLLY PINTO','919945849356','','','PINTO VILLA, MALAVOOR VILLAGE, BAJPE','','','11','574142','T M KARIAPPA','919972061245','','DY GENERAL MANGER, KIOCL LIMITED','PANAMBUR','','11','575010','Document','100.00','0.00','0.00','0','Document','Surface','1','0.05','','','','','0.05','35.00','1','1','2025-11-05 14:26:54','2025-11-05 14:26:54','17616388051318','17616388051318','','3453','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1844','13','1','','2','3404175','2025-11-05','','5795','1733','SNSB AND ASSO','919148979329','','','nr sharavu temple','','','11','575001','HIMALI R LAKHANI','919148979329','','HR LAKHANI ASSO','TITANIUM BUSINESS PARK JEVRAJ PARK','','7','380051','Document','10.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','100.00','1','1','2025-11-05 14:31:32','2025-11-05 14:32:24','17617147018423','17617147018423','','3','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1845','20','1','','2','3418152','2025-11-05','','5870','1734','H BHASKAR GADIYAR','919964244147','','','BALLALBAGH MANGALORE','','','11','575001','RATHNAKAR D SHENOY','919886677567','','JODURASTHE','KUKKUNDOOR','','11','576117','Document','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','50.00','1','1','2025-11-05 14:32:39','2025-11-05 14:32:39','17616388667516','17616388667516','','75','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1846','22','1','','2','3411155','2025-11-05','','5871','1735','MALATHI ARUN PUJARY','919902417876','','','ADHI APTS 201','KADRI KAIBATTAL 5TH CROSS','','11','575002','Y S PUJARY','919869873130','','12TH DWARAKA NEAR SUBRAMANYA TEMPLE','CHEEDANAGAR CHEMBUR','','14','400089','Document','0.11','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','100.00','1','1','2025-11-05 14:39:18','2025-11-05 14:39:18','17617169725275','17617169725275','','57','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1847','20','1','','2','3418153','2025-11-05','','5872','1736','ABHISHEK M','919886673610','','','KS RAO ROAD','MANGALORE','','11','575004','COMPLIENCE TEAM LULUI FOREX PVT LTD','919656971786','','CIVIL LINE ROAD','KAKKANAD WEST','','12','682030','Document','0.00','0.00','0.00','0','Document','Surface','1','0.25','','','','','0.25','95.00','1','1','2025-11-05 14:39:18','2025-11-05 14:39:18','17616388667516','17616388667516','','2432','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1848','20','1','','2','3418154','2025-11-05','','5873','1737','VADIRAJA K','919741988486','','','MANGALORE','MANGALORE','','11','575001','ASHWINI HARISH','917676924958','','CVSR HOMES TC PALYA MAIN ROAD','RAMAMURTHYNAGAR','','11','560016','Document','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-05 14:41:24','2025-11-05 14:41:24','17616388667516','17616388667516','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1849','7','1','','2','3395071','2025-11-05','','5874','1738','APMC','919743502283','','','BAIKAMAPADY','MANGALORE','','11','575011','KARYADARSHI','919901535061','','APMC','KARKALA','','11','574101','Document','0.00','0.00','0.00','0','Document','Surface','1','0.30','','','','','0.30','85.00','1','1','2025-11-05 14:42:23','2025-11-05 14:42:23','17617199828916','17617199828916','','75','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1850','23','1','','2','3408638','2025-11-05','','4777','1739','SUNDRESH','919731805276','','','RTO PANDESHWAR','MANGALORE','','11','575001','MR SRINIVASAN V','919845173344','','S S AUTO ASSOCIATES','V V ROAD','','11','570005','Document','100.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-05 14:43:27','2025-11-05 14:44:39','17617218175043','17617218175043','','669','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1851','20','1','','2','3418155','2025-11-05','','5875','1740','SHYAMA PRAKASH K','919448287264','','','M G ROAD','MANGALORE','','11','575001','PRASHANTH JOGIMUTT','919008062350','','HORAMAVU','BANGALORE','','11','560043','Document','0.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-05 14:44:57','2025-11-05 14:44:57','17616388667516','17616388667516','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1852','12','1','','2','3382977','2025-11-05','','5876','1741','RIZWAN','917892893126','','','MR BHATLINE JEPPU','MANGALORE','','11','575001','SHIVAPRASAD NAIK','919591570531','','OPP WEST COASYT GOVT HOSPITAL','GOKARNA','','11','581326','Document','5970.00','0.00','0.00','0','Parcel','Surface','1','0.11','','','','','0.11','85.00','1','1','2025-11-05 14:45:42','2025-11-05 14:45:42','17617206505387','17617206505387','','954','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1853','23','1','','2','3408639','2025-11-05','','4777','1742','SUNDRESH','919731805276','','','RTO PANDESHWAR','MANGALORE','','11','575001','MR D AJITH','919845278263','','C/O B S SANGANNA','MLLA BLOCK','','11','577001','Document','100.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-05 14:46:14','2025-11-05 14:46:14','17617218175043','17617218175043','','1123','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1854','21','1','','2','3393142','2025-11-05','','5877','1743','SCIENTECH SERVICES','919113809461','','','UDBHAV SQUARE','KOTTARA CHOWKI','','11','575006','SCIENCETECH SERVICES','918025730691','','NO. 15, SINGASANDRA','HOSUR ROAD','','11','560068','Document','100.00','0.00','0.00','0','Document','Surface','1','0.12','','','','','0.12','85.00','1','1','2025-11-05 14:50:53','2025-11-05 14:50:53','17616388051318','17616388051318','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1855','23','1','','2','3408640','2025-11-05','','4769','237','JAYANTHIMALA','919916644540','','','PANDESHWARA','MANGALORE','','11','575001','BALACHANDRA','918028015700','','SIVANTOS INDIA PVT LTD','DODDENAKKUNDI','','11','560048','Document','100.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-05 14:53:38','2025-11-05 14:53:38','17617218175043','17617218175043','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1856','22','1','','2','3411156','2025-11-05','','5878','1744','SANDRA PRINTERS','919844294836','','','neermarga','MANGALORE','','11','575029','THE HEARMINISTRESS','918217915853','','ST MARYS KANNADA M SCHOOL','KESHAVAPURA','','11','580023','Document','0.10','0.00','0.00','0','Document','Surface','1','0.71','','','','','0.71','125.00','1','1','2025-11-05 14:55:10','2025-11-05 14:55:10','17617169725275','17617169725275','','557','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1857','22','1','','2','3411157','2025-11-05','','5246','1745','HIMA REFRIGERATION','919164115665','','','YENEPOYA MALL KADRI RD','MANGALORE','','11','575002','DAIKIN AIRCONTIONING INDIA','919741641222','','G FLOOR OUTER RING RD','BELLANDUR','','11','560103','Document','0.10','0.00','0.00','0','Document','Surface','1','0.20','','','','','0.20','85.00','1','1','2025-11-05 14:58:05','2025-11-05 14:58:05','17617169725275','17617169725275','','424','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1858','7','1','','2','3395072','2025-11-05','','5879','1746','SHIVAM SINGH','918577005268','','','HOTEL DWARA','BAIKAMPADY','','11','575011','KAJOL GUPTA','919873780269','','BUREAU VERITAS INDIA P LTD','NOIDA','','26','201301','Document','0.01','0.00','0.00','0','Document','Surface','1','0.01','','','','','0.01','100.00','1','1','2025-11-05 14:59:17','2025-11-05 14:59:17','17617199828916','17617199828916','','226','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1859','12','1','','2','3382978','2025-11-05','','5880','1747','TWISHA MADHAV PUJARI','916361103817','','','CANARA ENGG COLLEGE','BENJANAPADAVU','','11','574219','THE MANAGER','919620977167','','UBI VINAYA ARCADE','TEMPLE ROAD','','11','581350','Document','10.00','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','60.00','1','1','2025-11-05 15:00:01','2025-11-05 15:00:01','17617206505387','17617206505387','','994','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1860','21','1','','2','3393143','2025-11-05','','5881','1748','THILAKRAJ ROADLINES','919108245857','','','KOTTARA CHOWKI','MANGALORE','','11','575006','SUBHAS','919845733315','','LAMINA FOUNDRIES LTD','NITTE, KARKALA','','11','574110','Document','100.00','0.00','0.00','0','Document','Surface','1','0.05','','','','','0.05','50.00','1','1','2025-11-05 15:01:00','2025-11-05 15:01:00','17616388051318','17616388051318','','738','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1861','22','1','','2','3411158','2025-11-05','','5882','1749','S K FINANCE LTD','919974217450','','','CITY TRADE CENTER','KADRI MANGALORE','','11','575003','RIMAL PATEL','919099079214','','K P EPITOME B BLOCK','MAKARBA AHMEDABAD','','7','380051','Document','0.02','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','100.00','1','1','2025-11-05 15:02:03','2025-11-05 15:02:03','17617169725275','17617169725275','','3','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1862','22','1','','2','3411159','2025-11-05','','5882','1749','S K FINANCE LTD','919974217450','','','CITY TRADE CENTER','KADRI MANGALORE','','11','575003','RIMAL PATEL','919099079214','','K P EPITOME B BLOCK','MAKARBA AHMEDABAD','','7','380051','Document','0.10','0.00','0.00','0','Document','Surface','1','0.02','','','','','0.02','100.00','1','1','2025-11-05 15:03:25','2025-11-05 15:03:25','17617169725275','17617169725275','','3','','0.00','CGST_SGST','0.00','0.00','0.00','0.00','1','0','0','','','','','','0','');
INSERT INTO `booking` VALUES ('1863','16','1','','2','3357249','2025-11-05','','5883','1750','SHARIN','918242258207','','','KAIKAMBA','MANGALORE','','11','57